"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const kinesisanalytics = require("@aws-cdk/aws-kinesisanalytics");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('test kinesisanalytics override inputProperty', () => {
    const stack = new core_1.Stack();
    const inputProperty = {
        inputSchema: {
            recordColumns: [{ name: 'x', sqlType: 'y' }],
            recordFormat: { recordFormatType: 'csv' }
        },
        namePrefix: 'zzz'
    };
    const defaultProps = defaults.DefaultCfnApplicationProps;
    const inProps = {
        inputs: [inputProperty]
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new kinesisanalytics.CfnApplication(stack, 'KinesisAnalytics', outProps);
    expect(stack).toHaveResource("AWS::KinesisAnalytics::Application", {
        Inputs: [
            {
                InputSchema: {
                    RecordColumns: [
                        {
                            Name: "x",
                            SqlType: "y"
                        }
                    ],
                    RecordFormat: {
                        RecordFormatType: "csv"
                    }
                },
                NamePrefix: "zzz"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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