/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { Bucket, BucketProps } from "@aws-cdk/aws-s3";
import { Construct, Stack } from "@aws-cdk/core";
import * as cache from '@aws-cdk/aws-elasticache';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as acm from '@aws-cdk/aws-certificatemanager';
export declare const fakeEcrRepoArn = "arn:aws:ecr:us-east-1:123456789012:repository/fake-repo";
export declare function CreateScrapBucket(scope: Construct, props?: BucketProps | any): Bucket;
/**
 * @summary Creates a stack name for Integration tests
 * @param {string} filename - the filename of the integ test
 * @returns {string} - a string with current filename after removing anything before the prefix '.' and suffix '.js'
 * e.g. 'integ.apigateway-dynamodb-CRUD.js' will return 'apigateway-dynamodb-CRUD'
 */
export declare function generateIntegStackName(filename: string): string;
export declare function getTestVpc(stack: Stack, publicFacing?: boolean): ec2.IVpc;
export declare function getFakeCertificate(scope: Construct, id: string): acm.ICertificate;
export declare function suppressAutoDeleteHandlerWarnings(stack: Stack): void;
export declare function CreateTestCache(scope: Construct, id: string, vpc: ec2.IVpc, port?: number): cache.CfnCacheCluster;
