"""tests for file_lib"""
import glob
import os
import logging
import unittest

# from pyamihtmlx.file_lib import AmiPath, PROJ, FILE
from pathlib import Path

from amilib.file_lib import FileLib

from test.resources import Resources
from test.test_all import AmiAnyTest

FILE_LIB = "file_lib"
PDF_LIB = "pdf_lib"
TEXT_LIB = "text_lib"
_SETUP = "_setup"
_TEARDOWN = "_teardown"
TEST = "test"

"""
a few tests on globbing, etc"""


class TestFile(AmiAnyTest):
    # nothing much here
    logger = logging.getLogger("test_file")
    TEST = "test"

    OPTIONS = [
        FILE_LIB,
        PDF_LIB,
        TEXT_LIB,
        _SETUP,
        _TEARDOWN,
    ]

    @classmethod
    def example_setup(cls, pyamix):
        """ setup test or examples
        these are general commands (i.e. not subcommands)
        :pyamix:
        """
        pyamix.run_commands([
            "--delete ${exam_temp}",
            "--copy ${examples_test.p} ${exam_temp} overwrite",
        ])

    @classmethod
    def example_teardown(cls, pyamix):
        """ clean example files

        """
        pyamix.run_command([
            "--delete", "${exam_temp}",
        ])

    @classmethod
    def run_arg_tests(cls, args):
        """This needs revision , maybe using Examples()"""
        cls.logger.warning(f"*****running tests : {args[TEST]}")
        if not args[TEST]:
            cls.logger.warning(f"No tests given: choose some/all of {TEST}")
            return
        if FILE_LIB in args[TEST]:
            cls.logger.warning("run test_file")
            cls.test_file.main()
        if PDF_LIB in args[TEST]:
            cls.logger.warning("run test_pdf")
            cls.test_pdf.test_read_pdf()
        if TEXT_LIB in args[TEST]:
            cls.logger.warning("run test_text NYI")


    @unittest.skip("if not windows")
    def test_glob_with_windows_FILE(self):
        """
        some instances of glob.glob with fully forward slashes generate backslash or double backslash on windows
        """
        input_dir = Path(Resources.TEST_RESOURCES_DIR, "ar6", "cleaned_content")
        assert input_dir.exists()
        glob_str = f"{str(input_dir)}/**/html_with_ids.html"
        files = FileLib.posix_glob(glob_str, recursive=True)
        assert len(files) > 70
        for file in files[:5]:
            print(f"file: {file}")
            assert not "\\" in file # backslash is not generated by UNIX/MacOS
            assert "/" in file


    @classmethod
    @unittest.skip("not yet right")
    def test_expand_braces(cls):
        """
        no longer tests braces
        :return:
        """

        home = os.path.expanduser("~")
        file = __file__
        python_dir = os.path.abspath(file + "/../")
        resources_dir = os.path.join(python_dir, "resources")
        print("python", os.path.abspath(python_dir))
        physchem_dir = os.path.abspath(python_dir + "/../")
        open_diagram = os.path.abspath(physchem_dir + "/../")
        print(os.path.abspath(open_diagram))
        opend = os.path.join(open_diagram, "*")
        print("opend", opend)
        print(f"od0 {glob(opend)}")
        open_diagram01 = os.path.join(physchem_dir, "**", "liion10", "**", "*.*ml")
        print(f"od01 {glob(open_diagram01)}")

        # open_diagram02 = os.path.join(home, "projects", "*iagram", "{*ot*,*.md}")
        # print("od02", bg.braced_glob(open_diagram02))
        open_diagram11 = os.path.join(home, "projects", "*iagram", "*", "*", "*.xml")
        print("od", open_diagram11)
        print("b", glob(open_diagram11))
        open_diagram12 = os.path.join(home, "projects", "*iagram", "**", "*.xml")
        print("od", open_diagram12)
        #        print("b12", glob(open_diagram12, recursive=True))
        # pics = os.path.join(home, "projects", "*iagram", "**", "{*.climate10_,*.txt,*.png}")
        # print("od", pics)
        # print("pics", bg.braced_glob(pics, recursive=True))





def main():
    TestFile.test_file_simple()
    TestFile.test_templates()
