"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-03-18T10:01:32.690Z","fingerprint":"MdJV28jVgsQCtQf1FHDAPJc8awCWI7q5M2M/woqY2mE="}
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
/**
 * Determine whether the given properties match those of a `CfnChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('channelClass', cdk.validateString)(properties.channelClass));
    errors.collect(cdk.propertyValidator('destinations', cdk.listValidator(CfnChannel_OutputDestinationPropertyValidator))(properties.destinations));
    errors.collect(cdk.propertyValidator('encoderSettings', cdk.validateObject)(properties.encoderSettings));
    errors.collect(cdk.propertyValidator('inputAttachments', cdk.listValidator(CfnChannel_InputAttachmentPropertyValidator))(properties.inputAttachments));
    errors.collect(cdk.propertyValidator('inputSpecification', CfnChannel_InputSpecificationPropertyValidator)(properties.inputSpecification));
    errors.collect(cdk.propertyValidator('logLevel', cdk.validateString)(properties.logLevel));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel` resource
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel` resource.
 */
// @ts-ignore TS6133
function cfnChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannelPropsValidator(properties).assertSuccess();
    return {
        ChannelClass: cdk.stringToCloudFormation(properties.channelClass),
        Destinations: cdk.listMapper(cfnChannelOutputDestinationPropertyToCloudFormation)(properties.destinations),
        EncoderSettings: cdk.objectToCloudFormation(properties.encoderSettings),
        InputAttachments: cdk.listMapper(cfnChannelInputAttachmentPropertyToCloudFormation)(properties.inputAttachments),
        InputSpecification: cfnChannelInputSpecificationPropertyToCloudFormation(properties.inputSpecification),
        LogLevel: cdk.stringToCloudFormation(properties.logLevel),
        Name: cdk.stringToCloudFormation(properties.name),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        Tags: cdk.objectToCloudFormation(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`
 *
 * @cloudformationResource AWS::MediaLive::Channel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 */
class CfnChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaLive::Channel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrInputs = cdk.Token.asList(this.getAtt('Inputs'));
        this.channelClass = props.channelClass;
        this.destinations = props.destinations;
        this.encoderSettings = props.encoderSettings;
        this.inputAttachments = props.inputAttachments;
        this.inputSpecification = props.inputSpecification;
        this.logLevel = props.logLevel;
        this.name = props.name;
        this.roleArn = props.roleArn;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::MediaLive::Channel", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            channelClass: this.channelClass,
            destinations: this.destinations,
            encoderSettings: this.encoderSettings,
            inputAttachments: this.inputAttachments,
            inputSpecification: this.inputSpecification,
            logLevel: this.logLevel,
            name: this.name,
            roleArn: this.roleArn,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnChannelPropsToCloudFormation(props);
    }
}
exports.CfnChannel = CfnChannel;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnChannel.CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Channel";
/**
 * Determine whether the given properties match those of a `AribSourceSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `AribSourceSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_AribSourceSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    return errors.wrap('supplied properties not correct for "AribSourceSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AribSourceSettings` resource
 *
 * @param properties - the TypeScript properties of a `AribSourceSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AribSourceSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelAribSourceSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_AribSourceSettingsPropertyValidator(properties).assertSuccess();
    return {};
}
/**
 * Determine whether the given properties match those of a `AudioLanguageSelectionProperty`
 *
 * @param properties - the TypeScript properties of a `AudioLanguageSelectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_AudioLanguageSelectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('languageCode', cdk.validateString)(properties.languageCode));
    errors.collect(cdk.propertyValidator('languageSelectionPolicy', cdk.validateString)(properties.languageSelectionPolicy));
    return errors.wrap('supplied properties not correct for "AudioLanguageSelectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioLanguageSelection` resource
 *
 * @param properties - the TypeScript properties of a `AudioLanguageSelectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioLanguageSelection` resource.
 */
// @ts-ignore TS6133
function cfnChannelAudioLanguageSelectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_AudioLanguageSelectionPropertyValidator(properties).assertSuccess();
    return {
        LanguageCode: cdk.stringToCloudFormation(properties.languageCode),
        LanguageSelectionPolicy: cdk.stringToCloudFormation(properties.languageSelectionPolicy),
    };
}
/**
 * Determine whether the given properties match those of a `AudioPidSelectionProperty`
 *
 * @param properties - the TypeScript properties of a `AudioPidSelectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_AudioPidSelectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('pid', cdk.validateNumber)(properties.pid));
    return errors.wrap('supplied properties not correct for "AudioPidSelectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioPidSelection` resource
 *
 * @param properties - the TypeScript properties of a `AudioPidSelectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioPidSelection` resource.
 */
// @ts-ignore TS6133
function cfnChannelAudioPidSelectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_AudioPidSelectionPropertyValidator(properties).assertSuccess();
    return {
        Pid: cdk.numberToCloudFormation(properties.pid),
    };
}
/**
 * Determine whether the given properties match those of a `AudioSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `AudioSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_AudioSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('selectorSettings', CfnChannel_AudioSelectorSettingsPropertyValidator)(properties.selectorSettings));
    return errors.wrap('supplied properties not correct for "AudioSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioSelector` resource
 *
 * @param properties - the TypeScript properties of a `AudioSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioSelector` resource.
 */
// @ts-ignore TS6133
function cfnChannelAudioSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_AudioSelectorPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        SelectorSettings: cfnChannelAudioSelectorSettingsPropertyToCloudFormation(properties.selectorSettings),
    };
}
/**
 * Determine whether the given properties match those of a `AudioSelectorSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `AudioSelectorSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_AudioSelectorSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('audioLanguageSelection', CfnChannel_AudioLanguageSelectionPropertyValidator)(properties.audioLanguageSelection));
    errors.collect(cdk.propertyValidator('audioPidSelection', CfnChannel_AudioPidSelectionPropertyValidator)(properties.audioPidSelection));
    return errors.wrap('supplied properties not correct for "AudioSelectorSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioSelectorSettings` resource
 *
 * @param properties - the TypeScript properties of a `AudioSelectorSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.AudioSelectorSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelAudioSelectorSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_AudioSelectorSettingsPropertyValidator(properties).assertSuccess();
    return {
        AudioLanguageSelection: cfnChannelAudioLanguageSelectionPropertyToCloudFormation(properties.audioLanguageSelection),
        AudioPidSelection: cfnChannelAudioPidSelectionPropertyToCloudFormation(properties.audioPidSelection),
    };
}
/**
 * Determine whether the given properties match those of a `CaptionSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `CaptionSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_CaptionSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('languageCode', cdk.validateString)(properties.languageCode));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('selectorSettings', CfnChannel_CaptionSelectorSettingsPropertyValidator)(properties.selectorSettings));
    return errors.wrap('supplied properties not correct for "CaptionSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.CaptionSelector` resource
 *
 * @param properties - the TypeScript properties of a `CaptionSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.CaptionSelector` resource.
 */
// @ts-ignore TS6133
function cfnChannelCaptionSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_CaptionSelectorPropertyValidator(properties).assertSuccess();
    return {
        LanguageCode: cdk.stringToCloudFormation(properties.languageCode),
        Name: cdk.stringToCloudFormation(properties.name),
        SelectorSettings: cfnChannelCaptionSelectorSettingsPropertyToCloudFormation(properties.selectorSettings),
    };
}
/**
 * Determine whether the given properties match those of a `CaptionSelectorSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `CaptionSelectorSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_CaptionSelectorSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('aribSourceSettings', CfnChannel_AribSourceSettingsPropertyValidator)(properties.aribSourceSettings));
    errors.collect(cdk.propertyValidator('dvbSubSourceSettings', CfnChannel_DvbSubSourceSettingsPropertyValidator)(properties.dvbSubSourceSettings));
    errors.collect(cdk.propertyValidator('embeddedSourceSettings', CfnChannel_EmbeddedSourceSettingsPropertyValidator)(properties.embeddedSourceSettings));
    errors.collect(cdk.propertyValidator('scte20SourceSettings', CfnChannel_Scte20SourceSettingsPropertyValidator)(properties.scte20SourceSettings));
    errors.collect(cdk.propertyValidator('scte27SourceSettings', CfnChannel_Scte27SourceSettingsPropertyValidator)(properties.scte27SourceSettings));
    errors.collect(cdk.propertyValidator('teletextSourceSettings', CfnChannel_TeletextSourceSettingsPropertyValidator)(properties.teletextSourceSettings));
    return errors.wrap('supplied properties not correct for "CaptionSelectorSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.CaptionSelectorSettings` resource
 *
 * @param properties - the TypeScript properties of a `CaptionSelectorSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.CaptionSelectorSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelCaptionSelectorSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_CaptionSelectorSettingsPropertyValidator(properties).assertSuccess();
    return {
        AribSourceSettings: cfnChannelAribSourceSettingsPropertyToCloudFormation(properties.aribSourceSettings),
        DvbSubSourceSettings: cfnChannelDvbSubSourceSettingsPropertyToCloudFormation(properties.dvbSubSourceSettings),
        EmbeddedSourceSettings: cfnChannelEmbeddedSourceSettingsPropertyToCloudFormation(properties.embeddedSourceSettings),
        Scte20SourceSettings: cfnChannelScte20SourceSettingsPropertyToCloudFormation(properties.scte20SourceSettings),
        Scte27SourceSettings: cfnChannelScte27SourceSettingsPropertyToCloudFormation(properties.scte27SourceSettings),
        TeletextSourceSettings: cfnChannelTeletextSourceSettingsPropertyToCloudFormation(properties.teletextSourceSettings),
    };
}
/**
 * Determine whether the given properties match those of a `DvbSubSourceSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `DvbSubSourceSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_DvbSubSourceSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('pid', cdk.validateNumber)(properties.pid));
    return errors.wrap('supplied properties not correct for "DvbSubSourceSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.DvbSubSourceSettings` resource
 *
 * @param properties - the TypeScript properties of a `DvbSubSourceSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.DvbSubSourceSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelDvbSubSourceSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_DvbSubSourceSettingsPropertyValidator(properties).assertSuccess();
    return {
        Pid: cdk.numberToCloudFormation(properties.pid),
    };
}
/**
 * Determine whether the given properties match those of a `EmbeddedSourceSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `EmbeddedSourceSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_EmbeddedSourceSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('convert608To708', cdk.validateString)(properties.convert608To708));
    errors.collect(cdk.propertyValidator('scte20Detection', cdk.validateString)(properties.scte20Detection));
    errors.collect(cdk.propertyValidator('source608ChannelNumber', cdk.validateNumber)(properties.source608ChannelNumber));
    errors.collect(cdk.propertyValidator('source608TrackNumber', cdk.validateNumber)(properties.source608TrackNumber));
    return errors.wrap('supplied properties not correct for "EmbeddedSourceSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.EmbeddedSourceSettings` resource
 *
 * @param properties - the TypeScript properties of a `EmbeddedSourceSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.EmbeddedSourceSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelEmbeddedSourceSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_EmbeddedSourceSettingsPropertyValidator(properties).assertSuccess();
    return {
        Convert608To708: cdk.stringToCloudFormation(properties.convert608To708),
        Scte20Detection: cdk.stringToCloudFormation(properties.scte20Detection),
        Source608ChannelNumber: cdk.numberToCloudFormation(properties.source608ChannelNumber),
        Source608TrackNumber: cdk.numberToCloudFormation(properties.source608TrackNumber),
    };
}
/**
 * Determine whether the given properties match those of a `HlsInputSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `HlsInputSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_HlsInputSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bandwidth', cdk.validateNumber)(properties.bandwidth));
    errors.collect(cdk.propertyValidator('bufferSegments', cdk.validateNumber)(properties.bufferSegments));
    errors.collect(cdk.propertyValidator('retries', cdk.validateNumber)(properties.retries));
    errors.collect(cdk.propertyValidator('retryInterval', cdk.validateNumber)(properties.retryInterval));
    return errors.wrap('supplied properties not correct for "HlsInputSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.HlsInputSettings` resource
 *
 * @param properties - the TypeScript properties of a `HlsInputSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.HlsInputSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelHlsInputSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_HlsInputSettingsPropertyValidator(properties).assertSuccess();
    return {
        Bandwidth: cdk.numberToCloudFormation(properties.bandwidth),
        BufferSegments: cdk.numberToCloudFormation(properties.bufferSegments),
        Retries: cdk.numberToCloudFormation(properties.retries),
        RetryInterval: cdk.numberToCloudFormation(properties.retryInterval),
    };
}
/**
 * Determine whether the given properties match those of a `InputAttachmentProperty`
 *
 * @param properties - the TypeScript properties of a `InputAttachmentProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_InputAttachmentPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('inputAttachmentName', cdk.validateString)(properties.inputAttachmentName));
    errors.collect(cdk.propertyValidator('inputId', cdk.validateString)(properties.inputId));
    errors.collect(cdk.propertyValidator('inputSettings', CfnChannel_InputSettingsPropertyValidator)(properties.inputSettings));
    return errors.wrap('supplied properties not correct for "InputAttachmentProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.InputAttachment` resource
 *
 * @param properties - the TypeScript properties of a `InputAttachmentProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.InputAttachment` resource.
 */
// @ts-ignore TS6133
function cfnChannelInputAttachmentPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_InputAttachmentPropertyValidator(properties).assertSuccess();
    return {
        InputAttachmentName: cdk.stringToCloudFormation(properties.inputAttachmentName),
        InputId: cdk.stringToCloudFormation(properties.inputId),
        InputSettings: cfnChannelInputSettingsPropertyToCloudFormation(properties.inputSettings),
    };
}
/**
 * Determine whether the given properties match those of a `InputSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `InputSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_InputSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('audioSelectors', cdk.listValidator(CfnChannel_AudioSelectorPropertyValidator))(properties.audioSelectors));
    errors.collect(cdk.propertyValidator('captionSelectors', cdk.listValidator(CfnChannel_CaptionSelectorPropertyValidator))(properties.captionSelectors));
    errors.collect(cdk.propertyValidator('deblockFilter', cdk.validateString)(properties.deblockFilter));
    errors.collect(cdk.propertyValidator('denoiseFilter', cdk.validateString)(properties.denoiseFilter));
    errors.collect(cdk.propertyValidator('filterStrength', cdk.validateNumber)(properties.filterStrength));
    errors.collect(cdk.propertyValidator('inputFilter', cdk.validateString)(properties.inputFilter));
    errors.collect(cdk.propertyValidator('networkInputSettings', CfnChannel_NetworkInputSettingsPropertyValidator)(properties.networkInputSettings));
    errors.collect(cdk.propertyValidator('sourceEndBehavior', cdk.validateString)(properties.sourceEndBehavior));
    errors.collect(cdk.propertyValidator('videoSelector', CfnChannel_VideoSelectorPropertyValidator)(properties.videoSelector));
    return errors.wrap('supplied properties not correct for "InputSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.InputSettings` resource
 *
 * @param properties - the TypeScript properties of a `InputSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.InputSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelInputSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_InputSettingsPropertyValidator(properties).assertSuccess();
    return {
        AudioSelectors: cdk.listMapper(cfnChannelAudioSelectorPropertyToCloudFormation)(properties.audioSelectors),
        CaptionSelectors: cdk.listMapper(cfnChannelCaptionSelectorPropertyToCloudFormation)(properties.captionSelectors),
        DeblockFilter: cdk.stringToCloudFormation(properties.deblockFilter),
        DenoiseFilter: cdk.stringToCloudFormation(properties.denoiseFilter),
        FilterStrength: cdk.numberToCloudFormation(properties.filterStrength),
        InputFilter: cdk.stringToCloudFormation(properties.inputFilter),
        NetworkInputSettings: cfnChannelNetworkInputSettingsPropertyToCloudFormation(properties.networkInputSettings),
        SourceEndBehavior: cdk.stringToCloudFormation(properties.sourceEndBehavior),
        VideoSelector: cfnChannelVideoSelectorPropertyToCloudFormation(properties.videoSelector),
    };
}
/**
 * Determine whether the given properties match those of a `InputSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `InputSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_InputSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('codec', cdk.validateString)(properties.codec));
    errors.collect(cdk.propertyValidator('maximumBitrate', cdk.validateString)(properties.maximumBitrate));
    errors.collect(cdk.propertyValidator('resolution', cdk.validateString)(properties.resolution));
    return errors.wrap('supplied properties not correct for "InputSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.InputSpecification` resource
 *
 * @param properties - the TypeScript properties of a `InputSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.InputSpecification` resource.
 */
// @ts-ignore TS6133
function cfnChannelInputSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_InputSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Codec: cdk.stringToCloudFormation(properties.codec),
        MaximumBitrate: cdk.stringToCloudFormation(properties.maximumBitrate),
        Resolution: cdk.stringToCloudFormation(properties.resolution),
    };
}
/**
 * Determine whether the given properties match those of a `MediaPackageOutputDestinationSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MediaPackageOutputDestinationSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_MediaPackageOutputDestinationSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('channelId', cdk.validateString)(properties.channelId));
    return errors.wrap('supplied properties not correct for "MediaPackageOutputDestinationSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.MediaPackageOutputDestinationSettings` resource
 *
 * @param properties - the TypeScript properties of a `MediaPackageOutputDestinationSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.MediaPackageOutputDestinationSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelMediaPackageOutputDestinationSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_MediaPackageOutputDestinationSettingsPropertyValidator(properties).assertSuccess();
    return {
        ChannelId: cdk.stringToCloudFormation(properties.channelId),
    };
}
/**
 * Determine whether the given properties match those of a `MultiplexProgramChannelDestinationSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MultiplexProgramChannelDestinationSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_MultiplexProgramChannelDestinationSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('multiplexId', cdk.validateString)(properties.multiplexId));
    errors.collect(cdk.propertyValidator('programName', cdk.validateString)(properties.programName));
    return errors.wrap('supplied properties not correct for "MultiplexProgramChannelDestinationSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.MultiplexProgramChannelDestinationSettings` resource
 *
 * @param properties - the TypeScript properties of a `MultiplexProgramChannelDestinationSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.MultiplexProgramChannelDestinationSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelMultiplexProgramChannelDestinationSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_MultiplexProgramChannelDestinationSettingsPropertyValidator(properties).assertSuccess();
    return {
        MultiplexId: cdk.stringToCloudFormation(properties.multiplexId),
        ProgramName: cdk.stringToCloudFormation(properties.programName),
    };
}
/**
 * Determine whether the given properties match those of a `NetworkInputSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkInputSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_NetworkInputSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('hlsInputSettings', CfnChannel_HlsInputSettingsPropertyValidator)(properties.hlsInputSettings));
    errors.collect(cdk.propertyValidator('serverValidation', cdk.validateString)(properties.serverValidation));
    return errors.wrap('supplied properties not correct for "NetworkInputSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.NetworkInputSettings` resource
 *
 * @param properties - the TypeScript properties of a `NetworkInputSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.NetworkInputSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelNetworkInputSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_NetworkInputSettingsPropertyValidator(properties).assertSuccess();
    return {
        HlsInputSettings: cfnChannelHlsInputSettingsPropertyToCloudFormation(properties.hlsInputSettings),
        ServerValidation: cdk.stringToCloudFormation(properties.serverValidation),
    };
}
/**
 * Determine whether the given properties match those of a `OutputDestinationProperty`
 *
 * @param properties - the TypeScript properties of a `OutputDestinationProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_OutputDestinationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('mediaPackageSettings', cdk.listValidator(CfnChannel_MediaPackageOutputDestinationSettingsPropertyValidator))(properties.mediaPackageSettings));
    errors.collect(cdk.propertyValidator('multiplexSettings', CfnChannel_MultiplexProgramChannelDestinationSettingsPropertyValidator)(properties.multiplexSettings));
    errors.collect(cdk.propertyValidator('settings', cdk.listValidator(CfnChannel_OutputDestinationSettingsPropertyValidator))(properties.settings));
    return errors.wrap('supplied properties not correct for "OutputDestinationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.OutputDestination` resource
 *
 * @param properties - the TypeScript properties of a `OutputDestinationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.OutputDestination` resource.
 */
// @ts-ignore TS6133
function cfnChannelOutputDestinationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_OutputDestinationPropertyValidator(properties).assertSuccess();
    return {
        Id: cdk.stringToCloudFormation(properties.id),
        MediaPackageSettings: cdk.listMapper(cfnChannelMediaPackageOutputDestinationSettingsPropertyToCloudFormation)(properties.mediaPackageSettings),
        MultiplexSettings: cfnChannelMultiplexProgramChannelDestinationSettingsPropertyToCloudFormation(properties.multiplexSettings),
        Settings: cdk.listMapper(cfnChannelOutputDestinationSettingsPropertyToCloudFormation)(properties.settings),
    };
}
/**
 * Determine whether the given properties match those of a `OutputDestinationSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `OutputDestinationSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_OutputDestinationSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('passwordParam', cdk.validateString)(properties.passwordParam));
    errors.collect(cdk.propertyValidator('streamName', cdk.validateString)(properties.streamName));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "OutputDestinationSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.OutputDestinationSettings` resource
 *
 * @param properties - the TypeScript properties of a `OutputDestinationSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.OutputDestinationSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelOutputDestinationSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_OutputDestinationSettingsPropertyValidator(properties).assertSuccess();
    return {
        PasswordParam: cdk.stringToCloudFormation(properties.passwordParam),
        StreamName: cdk.stringToCloudFormation(properties.streamName),
        Url: cdk.stringToCloudFormation(properties.url),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
/**
 * Determine whether the given properties match those of a `Scte20SourceSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `Scte20SourceSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_Scte20SourceSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('convert608To708', cdk.validateString)(properties.convert608To708));
    errors.collect(cdk.propertyValidator('source608ChannelNumber', cdk.validateNumber)(properties.source608ChannelNumber));
    return errors.wrap('supplied properties not correct for "Scte20SourceSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.Scte20SourceSettings` resource
 *
 * @param properties - the TypeScript properties of a `Scte20SourceSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.Scte20SourceSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelScte20SourceSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_Scte20SourceSettingsPropertyValidator(properties).assertSuccess();
    return {
        Convert608To708: cdk.stringToCloudFormation(properties.convert608To708),
        Source608ChannelNumber: cdk.numberToCloudFormation(properties.source608ChannelNumber),
    };
}
/**
 * Determine whether the given properties match those of a `Scte27SourceSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `Scte27SourceSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_Scte27SourceSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('pid', cdk.validateNumber)(properties.pid));
    return errors.wrap('supplied properties not correct for "Scte27SourceSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.Scte27SourceSettings` resource
 *
 * @param properties - the TypeScript properties of a `Scte27SourceSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.Scte27SourceSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelScte27SourceSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_Scte27SourceSettingsPropertyValidator(properties).assertSuccess();
    return {
        Pid: cdk.numberToCloudFormation(properties.pid),
    };
}
/**
 * Determine whether the given properties match those of a `TeletextSourceSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `TeletextSourceSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_TeletextSourceSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('pageNumber', cdk.validateString)(properties.pageNumber));
    return errors.wrap('supplied properties not correct for "TeletextSourceSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.TeletextSourceSettings` resource
 *
 * @param properties - the TypeScript properties of a `TeletextSourceSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.TeletextSourceSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelTeletextSourceSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_TeletextSourceSettingsPropertyValidator(properties).assertSuccess();
    return {
        PageNumber: cdk.stringToCloudFormation(properties.pageNumber),
    };
}
/**
 * Determine whether the given properties match those of a `VideoSelectorProperty`
 *
 * @param properties - the TypeScript properties of a `VideoSelectorProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_VideoSelectorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('colorSpace', cdk.validateString)(properties.colorSpace));
    errors.collect(cdk.propertyValidator('colorSpaceUsage', cdk.validateString)(properties.colorSpaceUsage));
    errors.collect(cdk.propertyValidator('selectorSettings', CfnChannel_VideoSelectorSettingsPropertyValidator)(properties.selectorSettings));
    return errors.wrap('supplied properties not correct for "VideoSelectorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelector` resource
 *
 * @param properties - the TypeScript properties of a `VideoSelectorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelector` resource.
 */
// @ts-ignore TS6133
function cfnChannelVideoSelectorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_VideoSelectorPropertyValidator(properties).assertSuccess();
    return {
        ColorSpace: cdk.stringToCloudFormation(properties.colorSpace),
        ColorSpaceUsage: cdk.stringToCloudFormation(properties.colorSpaceUsage),
        SelectorSettings: cfnChannelVideoSelectorSettingsPropertyToCloudFormation(properties.selectorSettings),
    };
}
/**
 * Determine whether the given properties match those of a `VideoSelectorPidProperty`
 *
 * @param properties - the TypeScript properties of a `VideoSelectorPidProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_VideoSelectorPidPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('pid', cdk.validateNumber)(properties.pid));
    return errors.wrap('supplied properties not correct for "VideoSelectorPidProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelectorPid` resource
 *
 * @param properties - the TypeScript properties of a `VideoSelectorPidProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelectorPid` resource.
 */
// @ts-ignore TS6133
function cfnChannelVideoSelectorPidPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_VideoSelectorPidPropertyValidator(properties).assertSuccess();
    return {
        Pid: cdk.numberToCloudFormation(properties.pid),
    };
}
/**
 * Determine whether the given properties match those of a `VideoSelectorProgramIdProperty`
 *
 * @param properties - the TypeScript properties of a `VideoSelectorProgramIdProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_VideoSelectorProgramIdPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('programId', cdk.validateNumber)(properties.programId));
    return errors.wrap('supplied properties not correct for "VideoSelectorProgramIdProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelectorProgramId` resource
 *
 * @param properties - the TypeScript properties of a `VideoSelectorProgramIdProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelectorProgramId` resource.
 */
// @ts-ignore TS6133
function cfnChannelVideoSelectorProgramIdPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_VideoSelectorProgramIdPropertyValidator(properties).assertSuccess();
    return {
        ProgramId: cdk.numberToCloudFormation(properties.programId),
    };
}
/**
 * Determine whether the given properties match those of a `VideoSelectorSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `VideoSelectorSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_VideoSelectorSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('videoSelectorPid', CfnChannel_VideoSelectorPidPropertyValidator)(properties.videoSelectorPid));
    errors.collect(cdk.propertyValidator('videoSelectorProgramId', CfnChannel_VideoSelectorProgramIdPropertyValidator)(properties.videoSelectorProgramId));
    return errors.wrap('supplied properties not correct for "VideoSelectorSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelectorSettings` resource
 *
 * @param properties - the TypeScript properties of a `VideoSelectorSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Channel.VideoSelectorSettings` resource.
 */
// @ts-ignore TS6133
function cfnChannelVideoSelectorSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_VideoSelectorSettingsPropertyValidator(properties).assertSuccess();
    return {
        VideoSelectorPid: cfnChannelVideoSelectorPidPropertyToCloudFormation(properties.videoSelectorPid),
        VideoSelectorProgramId: cfnChannelVideoSelectorProgramIdPropertyToCloudFormation(properties.videoSelectorProgramId),
    };
}
/**
 * Determine whether the given properties match those of a `CfnInputProps`
 *
 * @param properties - the TypeScript properties of a `CfnInputProps`
 *
 * @returns the result of the validation.
 */
function CfnInputPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('destinations', cdk.listValidator(CfnInput_InputDestinationRequestPropertyValidator))(properties.destinations));
    errors.collect(cdk.propertyValidator('inputSecurityGroups', cdk.listValidator(cdk.validateString))(properties.inputSecurityGroups));
    errors.collect(cdk.propertyValidator('mediaConnectFlows', cdk.listValidator(CfnInput_MediaConnectFlowRequestPropertyValidator))(properties.mediaConnectFlows));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('sources', cdk.listValidator(CfnInput_InputSourceRequestPropertyValidator))(properties.sources));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('vpc', CfnInput_InputVpcRequestPropertyValidator)(properties.vpc));
    return errors.wrap('supplied properties not correct for "CfnInputProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Input` resource
 *
 * @param properties - the TypeScript properties of a `CfnInputProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Input` resource.
 */
// @ts-ignore TS6133
function cfnInputPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInputPropsValidator(properties).assertSuccess();
    return {
        Destinations: cdk.listMapper(cfnInputInputDestinationRequestPropertyToCloudFormation)(properties.destinations),
        InputSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.inputSecurityGroups),
        MediaConnectFlows: cdk.listMapper(cfnInputMediaConnectFlowRequestPropertyToCloudFormation)(properties.mediaConnectFlows),
        Name: cdk.stringToCloudFormation(properties.name),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        Sources: cdk.listMapper(cfnInputInputSourceRequestPropertyToCloudFormation)(properties.sources),
        Tags: cdk.objectToCloudFormation(properties.tags),
        Type: cdk.stringToCloudFormation(properties.type),
        Vpc: cfnInputInputVpcRequestPropertyToCloudFormation(properties.vpc),
    };
}
/**
 * A CloudFormation `AWS::MediaLive::Input`
 *
 * @cloudformationResource AWS::MediaLive::Input
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 */
class CfnInput extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaLive::Input`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnInput.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrDestinations = cdk.Token.asList(this.getAtt('Destinations'));
        this.attrSources = cdk.Token.asList(this.getAtt('Sources'));
        this.destinations = props.destinations;
        this.inputSecurityGroups = props.inputSecurityGroups;
        this.mediaConnectFlows = props.mediaConnectFlows;
        this.name = props.name;
        this.roleArn = props.roleArn;
        this.sources = props.sources;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::MediaLive::Input", props.tags, { tagPropertyName: 'tags' });
        this.type = props.type;
        this.vpc = props.vpc;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnInput.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            destinations: this.destinations,
            inputSecurityGroups: this.inputSecurityGroups,
            mediaConnectFlows: this.mediaConnectFlows,
            name: this.name,
            roleArn: this.roleArn,
            sources: this.sources,
            tags: this.tags.renderTags(),
            type: this.type,
            vpc: this.vpc,
        };
    }
    renderProperties(props) {
        return cfnInputPropsToCloudFormation(props);
    }
}
exports.CfnInput = CfnInput;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnInput.CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Input";
/**
 * Determine whether the given properties match those of a `InputDestinationRequestProperty`
 *
 * @param properties - the TypeScript properties of a `InputDestinationRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnInput_InputDestinationRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('streamName', cdk.validateString)(properties.streamName));
    return errors.wrap('supplied properties not correct for "InputDestinationRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Input.InputDestinationRequest` resource
 *
 * @param properties - the TypeScript properties of a `InputDestinationRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Input.InputDestinationRequest` resource.
 */
// @ts-ignore TS6133
function cfnInputInputDestinationRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInput_InputDestinationRequestPropertyValidator(properties).assertSuccess();
    return {
        StreamName: cdk.stringToCloudFormation(properties.streamName),
    };
}
/**
 * Determine whether the given properties match those of a `InputSourceRequestProperty`
 *
 * @param properties - the TypeScript properties of a `InputSourceRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnInput_InputSourceRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('passwordParam', cdk.validateString)(properties.passwordParam));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "InputSourceRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Input.InputSourceRequest` resource
 *
 * @param properties - the TypeScript properties of a `InputSourceRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Input.InputSourceRequest` resource.
 */
// @ts-ignore TS6133
function cfnInputInputSourceRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInput_InputSourceRequestPropertyValidator(properties).assertSuccess();
    return {
        PasswordParam: cdk.stringToCloudFormation(properties.passwordParam),
        Url: cdk.stringToCloudFormation(properties.url),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
/**
 * Determine whether the given properties match those of a `InputVpcRequestProperty`
 *
 * @param properties - the TypeScript properties of a `InputVpcRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnInput_InputVpcRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    return errors.wrap('supplied properties not correct for "InputVpcRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Input.InputVpcRequest` resource
 *
 * @param properties - the TypeScript properties of a `InputVpcRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Input.InputVpcRequest` resource.
 */
// @ts-ignore TS6133
function cfnInputInputVpcRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInput_InputVpcRequestPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
    };
}
/**
 * Determine whether the given properties match those of a `MediaConnectFlowRequestProperty`
 *
 * @param properties - the TypeScript properties of a `MediaConnectFlowRequestProperty`
 *
 * @returns the result of the validation.
 */
function CfnInput_MediaConnectFlowRequestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('flowArn', cdk.validateString)(properties.flowArn));
    return errors.wrap('supplied properties not correct for "MediaConnectFlowRequestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::Input.MediaConnectFlowRequest` resource
 *
 * @param properties - the TypeScript properties of a `MediaConnectFlowRequestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::Input.MediaConnectFlowRequest` resource.
 */
// @ts-ignore TS6133
function cfnInputMediaConnectFlowRequestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInput_MediaConnectFlowRequestPropertyValidator(properties).assertSuccess();
    return {
        FlowArn: cdk.stringToCloudFormation(properties.flowArn),
    };
}
/**
 * Determine whether the given properties match those of a `CfnInputSecurityGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnInputSecurityGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnInputSecurityGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('whitelistRules', cdk.listValidator(CfnInputSecurityGroup_InputWhitelistRuleCidrPropertyValidator))(properties.whitelistRules));
    return errors.wrap('supplied properties not correct for "CfnInputSecurityGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::InputSecurityGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnInputSecurityGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::InputSecurityGroup` resource.
 */
// @ts-ignore TS6133
function cfnInputSecurityGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInputSecurityGroupPropsValidator(properties).assertSuccess();
    return {
        Tags: cdk.objectToCloudFormation(properties.tags),
        WhitelistRules: cdk.listMapper(cfnInputSecurityGroupInputWhitelistRuleCidrPropertyToCloudFormation)(properties.whitelistRules),
    };
}
/**
 * A CloudFormation `AWS::MediaLive::InputSecurityGroup`
 *
 * @cloudformationResource AWS::MediaLive::InputSecurityGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 */
class CfnInputSecurityGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaLive::InputSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnInputSecurityGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::MediaLive::InputSecurityGroup", props.tags, { tagPropertyName: 'tags' });
        this.whitelistRules = props.whitelistRules;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnInputSecurityGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            tags: this.tags.renderTags(),
            whitelistRules: this.whitelistRules,
        };
    }
    renderProperties(props) {
        return cfnInputSecurityGroupPropsToCloudFormation(props);
    }
}
exports.CfnInputSecurityGroup = CfnInputSecurityGroup;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnInputSecurityGroup.CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::InputSecurityGroup";
/**
 * Determine whether the given properties match those of a `InputWhitelistRuleCidrProperty`
 *
 * @param properties - the TypeScript properties of a `InputWhitelistRuleCidrProperty`
 *
 * @returns the result of the validation.
 */
function CfnInputSecurityGroup_InputWhitelistRuleCidrPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('cidr', cdk.validateString)(properties.cidr));
    return errors.wrap('supplied properties not correct for "InputWhitelistRuleCidrProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaLive::InputSecurityGroup.InputWhitelistRuleCidr` resource
 *
 * @param properties - the TypeScript properties of a `InputWhitelistRuleCidrProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaLive::InputSecurityGroup.InputWhitelistRuleCidr` resource.
 */
// @ts-ignore TS6133
function cfnInputSecurityGroupInputWhitelistRuleCidrPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInputSecurityGroup_InputWhitelistRuleCidrPropertyValidator(properties).assertSuccess();
    return {
        Cidr: cdk.stringToCloudFormation(properties.cidr),
    };
}
//# sourceMappingURL=data:application/json;base64,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