# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nbox',
 'nbox.framework',
 'nbox.hyperloop',
 'nbox.lib',
 'nbox.nbxlib',
 'nbox.observability',
 'nbox.relics',
 'nbox.sub_utils',
 'nbox.sublime',
 'nbox.sublime._yql',
 'nbox.sublime.proto']

package_data = \
{'': ['*'], 'nbox': ['assets/*']}

install_requires = \
['GitPython==3.1.27',
 'Jinja2==3.0.3',
 'cloudpickle==2.1.0',
 'gputil==1.4.0',
 'grpcio==1.43.0',
 'mypy-protobuf==3.2.0',
 'protobuf==3.20.2',
 'psutil==5.9.0',
 'python-json-logger==2.0.2',
 'randomname>=0.1.3,<0.2.0',
 'requests>=2.25.1,<3.0.0',
 'tabulate==0.8.9',
 'tqdm==4.64.0']

extras_require = \
{'compute-basic': ['numpy==1.22.3', 'redis==4.3.4'],
 'full': ['fastapi>=0.78.0,<0.79.0',
          'uvicorn>=0.18.2,<0.19.0',
          'numpy==1.22.3',
          'redis==4.3.4'],
 'serving': ['fastapi>=0.78.0,<0.79.0', 'uvicorn>=0.18.2,<0.19.0']}

entry_points = \
{'console_scripts': ['nbx = nbox.cli:main']}

setup_kwargs = {
    'name': 'nbox',
    'version': '0.10.6rc0',
    'description': 'ML Inference 🥶',
    'long_description': '<a href="https://nimblebox.ai/" target="_blank"><img src="./assets/built_at_nbx.svg" align="right"></a>\n[![PyPI - Python\nVersion](https://img.shields.io/badge/python-3.6%20%7C%203.7%20%7C%203.8%20%7C%203.9-blue)](https://pypi.org/project/nbox/)\n[![Downloads](https://pepy.tech/badge/nbox)](https://pepy.tech/project/nbox)\n![GitHub](https://img.shields.io/badge/license-Apache--2.0-blueviolet)\n\n## 🧐 What is Nbox?\n\n`nbox` provides first class support API for all NimbleBox.ai infrastructure (NBX-Build, Jobs, Deploy) and services (NBX-Workspaces) components. Write jobs using `nbox.Operators`\n\n# 🤷Why NimbleBox\n\n- Write and execute code in Python\n- Document your code that supports mathematical equations\n- Create/Upload/Share notebooks\n- Import notebooks from your local machine\n- Import/Publish notebooks from/to GitHub\n- Import external datasets (e.g. from Kaggle)\n- Integrate PyTorch, TensorFlow, Keras, OpenCV\n- Share your projects\n- Collaborate with your team\n\n# 🎚 Features\n\n### 🏗️ Freedom To Build\n![Build Landing Page (2)](https://user-images.githubusercontent.com/89596037/181773716-ba63f167-af0d-48aa-921a-02e13238c0f2.gif)\n\n\n### 🦾 Automate with Ease\n![Jobs Landing Page](https://user-images.githubusercontent.com/89596037/181774553-99120354-72f5-4064-9216-4f8a5aa050be.gif)\n\n\n### 🚀 Intuitive Dashboard\n![Deploy Landing Page](https://user-images.githubusercontent.com/89596037/181775468-cc342a30-d87e-4576-8bdd-8ffdd75ff759.gif)\n\n\n# 🏁 Get Started\n\n\n**Install the package from pipy:**\n\n```pip install nbox```\n\n\nFor convinience you should add nbox to your path by setting up an alias. Throughout the rest of the documentation we will be using nbx as the CLI:\n\n```# go to your .bashrc or .zshrc and add\nalias nbx="python3 -m nbox"\n```\n\n\n\nWhen loading nbox for the first time, it will prompt you the username and password and create a secrets file at ```~/.nbx/secrets.json. ``` This file then contains all the information that you don’t have to fetch manually again.\n\n\n## APIs\n\nOur APIs are deep, user functions are kept to minimum and most relavant. This documentation contains the full spec of everything, but here’s all the APIs you need to know:\n\n```\nnbox\n├── Model          # Framework agnostic Model\n│   ├── __call__\n│   ├── deploy\n│   ├── train_on_instance (WIP)\n│   └── train_on_jobs (WIP)\n├── Operators      # How jobs are combinations of operators\n│   ├── __call__\n│   └── deploy\n├── Jobs           # For controlling all your jobs\n│   ├── logs       # stream logs right on your terminal\n│   └── trigger    # manually trigger a job\n└── Instance\n   ├── __call__    # Run any command on the instance\n   └── mv (WIP)    # Move files to and from NBX-Build\n```\n\n## NBX-Jobs and NBX-Deploy\n\nCreate a simple folder:\n\n```\nnbx jobs new moonshot\n```\n\n### Run any Batch Process\n\nAdd the following code to `foobar.py`:\n\n```python\nfrom nbox import operator, Operator\nfrom nbox.lib.shell import ShellCommand\n\n# define your function and wrap it as an operator\n@operator()\ndef foo(x: Dict):\n  return "bar"\n\n# or use OOPs like torch, etc.\nclass MyJob(Operator):\n  def __init__(self):\n    super().__init__()\n    self.foo = foo\n    self.shell = ShellCommand("echo \'hello {text}\'")\n  \n  def forward(self):\n    text = self.foo()\n    self.shell(text = text)\n```\n\n# How to get help?\n\nJoin our [discord](https://discord.gg/qYZHxMaCsE) and someone from our community or engineering team will respond!\n\n## 🔖Read our [Blog](https://nimblebox.ai/blog).\n\n\n# 🧩 License\n\nThe code in thist repo is licensed as [Apache License 2.0](./LICENSE). Please check for individual repositories for licenses.\n',
    'author': 'NBX Research',
    'author_email': 'research@nimblebox.ai',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/NimbleBoxAI/nbox',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
