#
# This code has been auto-generated by the MDE Workbench
# Version: 2.2.0.
#
# File: entities.py
# Date: 2021-05-13 10:59
# Time: 10:59
#


from pypws.enums import *

class EntityBase(object):
	def initialiseFromDictionary(self, data: dict):
		pass

# Class: LocalPosition
# Description: Position with reference to some arbitrary local origin and axes.
class LocalPosition(object):

	# Constructor.
	def __init__(self):

		# X
		self.x = 0.0

		# Y
		self.y = 0.0

		# Z
		self.z = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# X
		self.x = float(data['x'])

		# Y
		self.y = float(data['y'])

		# Z
		self.z = float(data['z'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* LocalPosition')

		# X
		print('X\t{0}'.format(self.x))

		# Y
		print('Y\t{0}'.format(self.y))

		# Z
		print('Z\t{0}'.format(self.z))


# Class: Asset
# Description: Any equipment to be modeled, vessels, pipelines
class Asset(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Location of the asset
		self.location = LocalPosition()


	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Location of the asset
		self.location.initialiseFromDictionary(data['location'])


	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Asset')

		# Location of the asset
		self.location.print()



# Class: Scenario
# Description: Base struct/class for all scenario types.
class Scenario(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):
		super(Scenario, self).initialiseFromDictionary(data)


	# Utility method to get the Scenario entity to print itself.
	def print(self):
		pass

# Class: Instantaneous
# Description: Base struct/class for instantaneous release scenarios.
class Instantaneous(Scenario):

	# Constructor.
	def __init__(self):
		super().__init__()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):
		super(Instantaneous, self).initialiseFromDictionary(data)


	# Utility method to get the Instantaneous entity to print itself.
	def print(self):
		pass

# Class: CatastrophicRupture
# Description: Catastrophic rupture of a vessel scenario.
class CatastrophicRupture(Instantaneous):

	# Constructor.
	def __init__(self):
		super().__init__()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):
		super(CatastrophicRupture, self).initialiseFromDictionary(data)


	# Utility method to get the CatastrophicRupture entity to print itself.
	def print(self):
		pass

# Class: ConcentrationRecord
class ConcentrationRecord(object):

	# Constructor.
	def __init__(self):

		# Cloud concentration at an x, y, z position
		self.concentration = 0.0

		# x, y, z position
		self.position = LocalPosition()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Cloud concentration at an x, y, z position
		self.concentration = float(data['concentration'])

		# x, y, z position
		self.position.initialiseFromDictionary(data['position'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ConcentrationRecord')

		# Cloud concentration at an x, y, z position
		print('Concentration\t{0}'.format(self.concentration))

		# x, y, z position
		self.position.print()


# Class: ConstantMaterialResult
# Description: Constant material properties, i.e. critical pressure, temperature, mole weight
class ConstantMaterialResult(object):

	# Constructor.
	def __init__(self):

		# The critical pressure of the material
		self.criticalPressure = 0.0

		# The critical temperature of the material
		self.criticalTemperature = 0.0

		# The total molecular weight of the material
		self.totalMolecularWeight = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# The critical pressure of the material
		self.criticalPressure = float(data['criticalPressure'])

		# The critical temperature of the material
		self.criticalTemperature = float(data['criticalTemperature'])

		# The total molecular weight of the material
		self.totalMolecularWeight = float(data['totalMolecularWeight'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ConstantMaterialResult')

		# The critical pressure of the material
		print('Critical pressure\t{0}'.format(self.criticalPressure))

		# The critical temperature of the material
		print('Critical temperature\t{0}'.format(self.criticalTemperature))

		# The total molecular weight of the material
		print('Total molecular weight\t{0}'.format(self.totalMolecularWeight))


# Class: Interval
# Description: A range of permitted values for the design variable when carrying out a design optimization workflow
class Interval(object):

	# Constructor.
	def __init__(self):

		# The lower boundary of the interval
		self.lowerBoundary = 0.0

		# The upper boundary of the interval
		self.upperBoundary = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# The lower boundary of the interval
		self.lowerBoundary = float(data['lowerBoundary'])

		# The upper boundary of the interval
		self.upperBoundary = float(data['upperBoundary'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Interval')

		# The lower boundary of the interval
		print('Lower boundary\t{0}'.format(self.lowerBoundary))

		# The upper boundary of the interval
		print('Upper boundary\t{0}'.format(self.upperBoundary))


# Class: Constraint
# Description: A set of data describing a design constraint. This includes the result target of interest  (e.g. mass flow) and the design variable (e.g. stack diameter).
class Constraint(object):

	# Constructor.
	def __init__(self):

		# The result type to be prescribed as a design target
		self.targetVariable = TargetVariable.MASS_FLOW_RATE

		# User-defined target value for the chosen result type
		self.targetVariableValue = 0.0

		# The input type to vary to achieve the design target
		self.designVariable = DesignVariable.PIPE_DIAMETER

		# An interval of permitted values for the design variable
		self.permittedDesignVariableInterval = Interval()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# The result type to be prescribed as a design target
		self.targetVariable = TargetVariable(data['targetVariable'])

		# User-defined target value for the chosen result type
		self.targetVariableValue = float(data['targetVariableValue'])

		# The input type to vary to achieve the design target
		self.designVariable = DesignVariable(data['designVariable'])

		# An interval of permitted values for the design variable
		self.permittedDesignVariableInterval.initialiseFromDictionary(data['permittedDesignVariableInterval'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Constraint')

		# The result type to be prescribed as a design target
		print('Target variable\t{0}'.format(self.targetVariable))

		# User-defined target value for the chosen result type
		print('Target variable value\t{0}'.format(self.targetVariableValue))

		# The input type to vary to achieve the design target
		print('Design variable\t{0}'.format(self.designVariable))

		# An interval of permitted values for the design variable
		self.permittedDesignVariableInterval.print()


# Class: DischargeParameters
# Description: Discharge parameters.
class DischargeParameters(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Flashing at orifice
		self.flashAtOrifice = FlashAtOrifice.DISALLOW_LIQUID_FLASH

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Flashing at orifice
		self.flashAtOrifice = FlashAtOrifice(data['flashAtOrifice'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* DischargeParameters')

		# Flashing at orifice
		print('Flash at orifice\t{0}'.format(self.flashAtOrifice))


# Class: State
# Description: Description of the fluid state.
class State(object):

	# Constructor.
	def __init__(self):

		# Absolute pressure of the fluid
		self.pressure = 0.0

		# Temperature of the fluid
		self.temperature = 0.0

		# Mole fraction of liquid in the fluid
		self.liquidFraction = 0.0

		# How fluid equilibrium is specified
		self.flashFlag = FluidSpec.TP

		# Mixture modelling: Pseudo-component (=0), MC single aerosol (=1), MC multiple aerosol (=3)
		self.mixtureModelling = MixtureModelling.MC___SINGLE_AEROSOL

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Absolute pressure of the fluid
		self.pressure = float(data['pressure'])

		# Temperature of the fluid
		self.temperature = float(data['temperature'])

		# Mole fraction of liquid in the fluid
		self.liquidFraction = float(data['liquidFraction'])

		# How fluid equilibrium is specified
		self.flashFlag = FluidSpec(data['flashFlag'])

		# Mixture modelling: Pseudo-component (=0), MC single aerosol (=1), MC multiple aerosol (=3)
		self.mixtureModelling = MixtureModelling(data['mixtureModelling'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* State')

		# Absolute pressure of the fluid
		print('Pressure\t{0}'.format(self.pressure))

		# Temperature of the fluid
		print('Temperature\t{0}'.format(self.temperature))

		# Mole fraction of liquid in the fluid
		print('Liquid fraction\t{0}'.format(self.liquidFraction))

		# How fluid equilibrium is specified
		print('Flash flag\t{0}'.format(self.flashFlag))

		# Mixture modelling: Pseudo-component (=0), MC single aerosol (=1), MC multiple aerosol (=3)
		print('Mixture modelling\t{0}'.format(self.mixtureModelling))


# Class: DischargeRecord
# Description: Discharge results at a given time.
class DischargeRecord(object):

	# Constructor.
	def __init__(self):

		# Time
		self.time = 0.0

		# Mass flow rate (continuous and time-varying)
		self.massFlow = 0.0

		# Final fluid state
		self.finalState = State()

		# Final velocity
		self.finalVelocity = 0.0

		# Orifice fluid state
		self.orificeState = State()

		# Orifice velocity
		self.orificeVelocity = 0.0

		# Storage fluid state
		self.storageState = State()

		# Representative droplet size
		self.dropletDiameter = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Time
		self.time = float(data['time'])

		# Mass flow rate (continuous and time-varying)
		self.massFlow = float(data['massFlow'])

		# Final fluid state
		self.finalState.initialiseFromDictionary(data['finalState'])

		# Final velocity
		self.finalVelocity = float(data['finalVelocity'])

		# Orifice fluid state
		self.orificeState.initialiseFromDictionary(data['orificeState'])

		# Orifice velocity
		self.orificeVelocity = float(data['orificeVelocity'])

		# Storage fluid state
		self.storageState.initialiseFromDictionary(data['storageState'])

		# Representative droplet size
		self.dropletDiameter = float(data['dropletDiameter'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* DischargeRecord')

		# Time
		print('Time\t{0}'.format(self.time))

		# Mass flow rate (continuous and time-varying)
		print('Mass flow\t{0}'.format(self.massFlow))

		# Final fluid state
		self.finalState.print()

		# Final velocity
		print('Final velocity\t{0}'.format(self.finalVelocity))

		# Orifice fluid state
		self.orificeState.print()

		# Orifice velocity
		print('Orifice velocity\t{0}'.format(self.orificeVelocity))

		# Storage fluid state
		self.storageState.print()

		# Representative droplet size
		print('Droplet diameter\t{0}'.format(self.dropletDiameter))


# Class: DischargeResult
# Description: Scalar discharge results.
class DischargeResult(object):

	# Constructor.
	def __init__(self):

		# Specific expansion energy (instantaneous releases only)
		self.expansionEnergy = 0.0

		# Released mass
		self.releaseMass = 0.0

		# Release height above ground
		self.height = 0.0

		# Release angle (non-instantaneous releases only)
		self.angle = 0.0

		# Instantaneous, continuous or time-varying
		self.releaseType = DynamicType.INSTANTANEOUS

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Specific expansion energy (instantaneous releases only)
		self.expansionEnergy = float(data['expansionEnergy'])

		# Released mass
		self.releaseMass = float(data['releaseMass'])

		# Release height above ground
		self.height = float(data['height'])

		# Release angle (non-instantaneous releases only)
		self.angle = float(data['angle'])

		# Instantaneous, continuous or time-varying
		self.releaseType = DynamicType(data['releaseType'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* DischargeResult')

		# Specific expansion energy (instantaneous releases only)
		print('Expansion energy\t{0}'.format(self.expansionEnergy))

		# Released mass
		print('Release mass\t{0}'.format(self.releaseMass))

		# Release height above ground
		print('Height\t{0}'.format(self.height))

		# Release angle (non-instantaneous releases only)
		print('Angle\t{0}'.format(self.angle))

		# Instantaneous, continuous or time-varying
		print('Release type\t{0}'.format(self.releaseType))


# Class: DispersionOutputConfig
# Description: Dispersion plotting and reporting control parameters.
class DispersionOutputConfig(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Downwind distance
		self.downwindDistance = 100.0

		# Time since start of the release
		self.time = 60.0

		# Output resolution of results and gird
		self.resolution = Resolution.HIGH

		# Height of interest above ground level
		self.elevation = 1.0

		# Pre-defined concentration
		self.specialConcentration = SpecialConcentration.MIN

		# Concentration (vol fraction). Not used unless SpecialConcentration is undefined
		self.concentration = 0.0

		# Crosswind distance
		self.crosswindDistance = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Downwind distance
		self.downwindDistance = float(data['downwindDistance'])

		# Time since start of the release
		self.time = float(data['time'])

		# Output resolution of results and gird
		self.resolution = Resolution(data['resolution'])

		# Height of interest above ground level
		self.elevation = float(data['elevation'])

		# Pre-defined concentration
		self.specialConcentration = SpecialConcentration(data['specialConcentration'])

		# Concentration (vol fraction). Not used unless SpecialConcentration is undefined
		self.concentration = float(data['concentration'])

		# Crosswind distance
		self.crosswindDistance = float(data['crosswindDistance'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* DispersionOutputConfig')

		# Downwind distance
		print('Downwind distance\t{0}'.format(self.downwindDistance))

		# Time since start of the release
		print('Time\t{0}'.format(self.time))

		# Output resolution of results and gird
		print('Resolution\t{0}'.format(self.resolution))

		# Height of interest above ground level
		print('Elevation\t{0}'.format(self.elevation))

		# Pre-defined concentration
		print('Special concentration\t{0}'.format(self.specialConcentration))

		# Concentration (vol fraction). Not used unless SpecialConcentration is undefined
		print('Concentration\t{0}'.format(self.concentration))

		# Crosswind distance
		print('Crosswind distance\t{0}'.format(self.crosswindDistance))


# Class: DispersionParameters
# Description: Dispersion Parameters.
class DispersionParameters(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Relative tolerance
		self.relativeTolerance = 0.001

		# Rainout and equilibrium method
		self.rainoutThermoFlag = RainoutThermoFlag.RAINOUT_NON_EQUILIBRIUM

		# Fixed step size
		self.fixedStepSize = 0.01

		# Ratio to increase step size
		self.outputStepMultiplier = 1.2

		# Absolute maximum distance for dispersion calculations
		self.maxDispersionDistance = 50000.0

		# Absolute maximum height for dispersion calculations
		self.maxDispersionHeight = 1000.0

		# Number of release observers for time-varying releases
		self.numberOfReleaseObservers = 5

		# Number of pool observers for rainout cases
		self.numberOfPoolObservers = 10

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Relative tolerance
		self.relativeTolerance = float(data['relativeTolerance'])

		# Rainout and equilibrium method
		self.rainoutThermoFlag = RainoutThermoFlag(data['rainoutThermoFlag'])

		# Fixed step size
		self.fixedStepSize = float(data['fixedStepSize'])

		# Ratio to increase step size
		self.outputStepMultiplier = float(data['outputStepMultiplier'])

		# Absolute maximum distance for dispersion calculations
		self.maxDispersionDistance = float(data['maxDispersionDistance'])

		# Absolute maximum height for dispersion calculations
		self.maxDispersionHeight = float(data['maxDispersionHeight'])

		# Number of release observers for time-varying releases
		self.numberOfReleaseObservers = int(data['numberOfReleaseObservers'])

		# Number of pool observers for rainout cases
		self.numberOfPoolObservers = int(data['numberOfPoolObservers'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* DispersionParameters')

		# Relative tolerance
		print('Relative tolerance\t{0}'.format(self.relativeTolerance))

		# Rainout and equilibrium method
		print('Rainout thermo flag\t{0}'.format(self.rainoutThermoFlag))

		# Fixed step size
		print('Fixed step size\t{0}'.format(self.fixedStepSize))

		# Ratio to increase step size
		print('Output step multiplier\t{0}'.format(self.outputStepMultiplier))

		# Absolute maximum distance for dispersion calculations
		print('Max dispersion distance\t{0}'.format(self.maxDispersionDistance))

		# Absolute maximum height for dispersion calculations
		print('Max dispersion height\t{0}'.format(self.maxDispersionHeight))

		# Number of release observers for time-varying releases
		print('Number of release observers\t{0}'.format(self.numberOfReleaseObservers))

		# Number of pool observers for rainout cases
		print('Number of pool observers\t{0}'.format(self.numberOfPoolObservers))


# Class: DispersionRecord
# Description: Observer dispersion record at a given time.
class DispersionRecord(object):

	# Constructor.
	def __init__(self):

		# Id of the observer associated with this record
		self.observerIndex = 0

		# Centreline concentraton (molar)
		self.centrelineConcentration = 0.0

		# Distance downwind
		self.downwindDistance = 0.0

		# Time after the start of the release
		self.time = 0.0

		# Uncorrected centreline concentraton (molar)
		self.centrelineConcentrationUncorrected = 0.0

		# Crosswind radius
		self.crosswindRadius = 0.0

		# Vertical radius
		self.verticalRadius = 0.0

		# Crosswind exponent
		self.crosswindExponent = 0.0

		# Vertical exponent
		self.verticalExponent = 0.0

		# Centreline angle from horizontal
		self.theta = 0.0

		# Centreline height
		self.centrelineHeight = 0.0

		# Liquid mass fraction
		self.liquidFraction = 0.0

		# Vapour temperature
		self.vapourTemperature = 0.0

		# Mass concentration
		self.massConc = 0.0

		# Velocity
		self.velocity = 0.0

		# Mass flow rate (non-instantaneous)
		self.massFlow = 0.0

		# Instantanous or continuous (time-varying not permitted)
		self.instCon = DynamicType.INSTANTANEOUS

		# Profile flag
		self.profileFlag = 0

		# Elevation flag
		self.elevFlag = 0

		# Cloud density
		self.rhoCloud = 0.0

		# Liquid temperature
		self.liqTemp = 0.0

		# Effective width
		self.effectiveWidth = 0.0

		# Effective height
		self.effectiveHeight = 0.0

		# Passive transition distance
		self.passTranDist = 0.0

		# Downwind radius
		self.downwindRadius = 0.0

		# Droplet diameter
		self.dropletDiameter = 0.0

		# Droplet height
		self.dropletHeight = 0.0

		# Droplet downwind distance
		self.dropletDistance = 0.0

		# Mass (instantaneous)
		self.mass = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Id of the observer associated with this record
		self.observerIndex = int(data['observerIndex'])

		# Centreline concentraton (molar)
		self.centrelineConcentration = float(data['centrelineConcentration'])

		# Distance downwind
		self.downwindDistance = float(data['downwindDistance'])

		# Time after the start of the release
		self.time = float(data['time'])

		# Uncorrected centreline concentraton (molar)
		self.centrelineConcentrationUncorrected = float(data['centrelineConcentrationUncorrected'])

		# Crosswind radius
		self.crosswindRadius = float(data['crosswindRadius'])

		# Vertical radius
		self.verticalRadius = float(data['verticalRadius'])

		# Crosswind exponent
		self.crosswindExponent = float(data['crosswindExponent'])

		# Vertical exponent
		self.verticalExponent = float(data['verticalExponent'])

		# Centreline angle from horizontal
		self.theta = float(data['theta'])

		# Centreline height
		self.centrelineHeight = float(data['centrelineHeight'])

		# Liquid mass fraction
		self.liquidFraction = float(data['liquidFraction'])

		# Vapour temperature
		self.vapourTemperature = float(data['vapourTemperature'])

		# Mass concentration
		self.massConc = float(data['massConc'])

		# Velocity
		self.velocity = float(data['velocity'])

		# Mass flow rate (non-instantaneous)
		self.massFlow = float(data['massFlow'])

		# Instantanous or continuous (time-varying not permitted)
		self.instCon = DynamicType(data['instCon'])

		# Profile flag
		self.profileFlag = int(data['profileFlag'])

		# Elevation flag
		self.elevFlag = int(data['elevFlag'])

		# Cloud density
		self.rhoCloud = float(data['rhoCloud'])

		# Liquid temperature
		self.liqTemp = float(data['liqTemp'])

		# Effective width
		self.effectiveWidth = float(data['effectiveWidth'])

		# Effective height
		self.effectiveHeight = float(data['effectiveHeight'])

		# Passive transition distance
		self.passTranDist = float(data['passTranDist'])

		# Downwind radius
		self.downwindRadius = float(data['downwindRadius'])

		# Droplet diameter
		self.dropletDiameter = float(data['dropletDiameter'])

		# Droplet height
		self.dropletHeight = float(data['dropletHeight'])

		# Droplet downwind distance
		self.dropletDistance = float(data['dropletDistance'])

		# Mass (instantaneous)
		self.mass = float(data['mass'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* DispersionRecord')

		# Id of the observer associated with this record
		print('Observer index\t{0}'.format(self.observerIndex))

		# Centreline concentraton (molar)
		print('Centreline concentration\t{0}'.format(self.centrelineConcentration))

		# Distance downwind
		print('Downwind distance\t{0}'.format(self.downwindDistance))

		# Time after the start of the release
		print('Time\t{0}'.format(self.time))

		# Uncorrected centreline concentraton (molar)
		print('Centreline concentration uncorrected\t{0}'.format(self.centrelineConcentrationUncorrected))

		# Crosswind radius
		print('Crosswind radius\t{0}'.format(self.crosswindRadius))

		# Vertical radius
		print('Vertical radius\t{0}'.format(self.verticalRadius))

		# Crosswind exponent
		print('Crosswind exponent\t{0}'.format(self.crosswindExponent))

		# Vertical exponent
		print('Vertical exponent\t{0}'.format(self.verticalExponent))

		# Centreline angle from horizontal
		print('Theta\t{0}'.format(self.theta))

		# Centreline height
		print('Centreline height\t{0}'.format(self.centrelineHeight))

		# Liquid mass fraction
		print('Liquid fraction\t{0}'.format(self.liquidFraction))

		# Vapour temperature
		print('Vapour temperature\t{0}'.format(self.vapourTemperature))

		# Mass concentration
		print('Mass conc\t{0}'.format(self.massConc))

		# Velocity
		print('Velocity\t{0}'.format(self.velocity))

		# Mass flow rate (non-instantaneous)
		print('Mass flow\t{0}'.format(self.massFlow))

		# Instantanous or continuous (time-varying not permitted)
		print('Inst con\t{0}'.format(self.instCon))

		# Profile flag
		print('Profile flag\t{0}'.format(self.profileFlag))

		# Elevation flag
		print('Elev flag\t{0}'.format(self.elevFlag))

		# Cloud density
		print('Rho cloud\t{0}'.format(self.rhoCloud))

		# Liquid temperature
		print('Liq temp\t{0}'.format(self.liqTemp))

		# Effective width
		print('Effective width\t{0}'.format(self.effectiveWidth))

		# Effective height
		print('Effective height\t{0}'.format(self.effectiveHeight))

		# Passive transition distance
		print('Pass tran dist\t{0}'.format(self.passTranDist))

		# Downwind radius
		print('Downwind radius\t{0}'.format(self.downwindRadius))

		# Droplet diameter
		print('Droplet diameter\t{0}'.format(self.dropletDiameter))

		# Droplet height
		print('Droplet height\t{0}'.format(self.dropletHeight))

		# Droplet downwind distance
		print('Droplet distance\t{0}'.format(self.dropletDistance))

		# Mass (instantaneous)
		print('Mass\t{0}'.format(self.mass))


# Class: ExplosionConfinedVolume
# Description: Confined explosion volume data
class ExplosionConfinedVolume(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Number of confined explosion volumes
		self.nConfinedVolumes = 0

		# Explosion strength of confined volume
		self.confinedStrength = []

		# Explosion volume of confined source
		self.confinedVolume = []

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Number of confined explosion volumes
		self.nConfinedVolumes = int(data['nConfinedVolumes'])

		# Explosion strength of confined volume
		for dataItem in data['confinedStrength']:
			self.confinedStrength.append(float(dataItem))

		# Explosion volume of confined source
		for dataItem in data['confinedVolume']:
			self.confinedVolume.append(float(dataItem))

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ExplosionConfinedVolume')

		# Number of confined explosion volumes
		print('N confined volumes\t{0}'.format(self.nConfinedVolumes))

		# Explosion strength of confined volume
		print('Confined strength\t{0}'.format(self.confinedStrength))

		# Explosion volume of confined source
		print('Confined volume\t{0}'.format(self.confinedVolume))


# Class: ExplosionOutputConfig
# Description: Explosion output configuration
class ExplosionOutputConfig(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Overpressure of interest for explosions
		self.overpressureLevel = 2068.0

		# Confined explosion volume data
		self.explosionConfinedVolume = ExplosionConfinedVolume()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Overpressure of interest for explosions
		self.overpressureLevel = float(data['overpressureLevel'])

		# Confined explosion volume data
		self.explosionConfinedVolume.initialiseFromDictionary(data['explosionConfinedVolume'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ExplosionOutputConfig')

		# Overpressure of interest for explosions
		print('Overpressure level\t{0}'.format(self.overpressureLevel))

		# Confined explosion volume data
		self.explosionConfinedVolume.print()


# Class: ExplosionOverpressureResult
# Description: Worst case explosion summary results for a given overpressure.
class ExplosionOverpressureResult(object):

	# Constructor.
	def __init__(self):

		# Overpressure for this result
		self.overpressure = 0.0

		# Centre of the explosion (distance downwind)
		self.explosionCentre = 0.0

		# Maximum distance to overpressure (downwind edge)
		self.maximumDistance = 0.0

		# Flammable mass used in the explosion
		self.explodedMass = 0.0

		# Time of ignition
		self.ignitionTime = 0.0

		# Explosion diameter (max distance - centre)
		self.diameter = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Overpressure for this result
		self.overpressure = float(data['overpressure'])

		# Centre of the explosion (distance downwind)
		self.explosionCentre = float(data['explosionCentre'])

		# Maximum distance to overpressure (downwind edge)
		self.maximumDistance = float(data['maximumDistance'])

		# Flammable mass used in the explosion
		self.explodedMass = float(data['explodedMass'])

		# Time of ignition
		self.ignitionTime = float(data['ignitionTime'])

		# Explosion diameter (max distance - centre)
		self.diameter = float(data['diameter'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ExplosionOverpressureResult')

		# Overpressure for this result
		print('Overpressure\t{0}'.format(self.overpressure))

		# Centre of the explosion (distance downwind)
		print('Explosion centre\t{0}'.format(self.explosionCentre))

		# Maximum distance to overpressure (downwind edge)
		print('Maximum distance\t{0}'.format(self.maximumDistance))

		# Flammable mass used in the explosion
		print('Exploded mass\t{0}'.format(self.explodedMass))

		# Time of ignition
		print('Ignition time\t{0}'.format(self.ignitionTime))

		# Explosion diameter (max distance - centre)
		print('Diameter\t{0}'.format(self.diameter))


# Class: ExplosionParameters
# Description: Explosion parameters
class ExplosionParameters(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Explosion strength for uniform unconfined (Multi-energy method)
		self.explosionUniformStrength = 10.0

		# Explosion ME confined method where UniformConfined=3, UserDefined=1
		self.mEConfinedMethod = MEConfinedMethod.UNIFORM_CONFINED

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Explosion strength for uniform unconfined (Multi-energy method)
		self.explosionUniformStrength = float(data['explosionUniformStrength'])

		# Explosion ME confined method where UniformConfined=3, UserDefined=1
		self.mEConfinedMethod = MEConfinedMethod(data['mEConfinedMethod'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ExplosionParameters')

		# Explosion strength for uniform unconfined (Multi-energy method)
		print('Explosion uniform strength\t{0}'.format(self.explosionUniformStrength))

		# Explosion ME confined method where UniformConfined=3, UserDefined=1
		print('M e confined method\t{0}'.format(self.mEConfinedMethod))


# Class: FlameRecord
# Description: Flame geometry description
class FlameRecord(object):

	# Constructor.
	def __init__(self):

		# Distance downwind
		self.xCoordinate = 0.0

		# Height above ground
		self.zCoordinate = 0.0

		# Flame radius
		self.rCoordinate = 0.0

		# Inclination from vertical
		self.phiCoordinate = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Distance downwind
		self.xCoordinate = float(data['xCoordinate'])

		# Height above ground
		self.zCoordinate = float(data['zCoordinate'])

		# Flame radius
		self.rCoordinate = float(data['rCoordinate'])

		# Inclination from vertical
		self.phiCoordinate = float(data['phiCoordinate'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* FlameRecord')

		# Distance downwind
		print('X coordinate\t{0}'.format(self.xCoordinate))

		# Height above ground
		print('Z coordinate\t{0}'.format(self.zCoordinate))

		# Flame radius
		print('R coordinate\t{0}'.format(self.rCoordinate))

		# Inclination from vertical
		print('Phi coordinate\t{0}'.format(self.phiCoordinate))


# Class: FlameResult
# Description: Fire results
class FlameResult(object):

	# Constructor.
	def __init__(self):

		# Time of fire, or duration if initial rate
		self.time = 0.0

		# Surface emissive power of flame
		self.surfaceEmissivePower = 0.0

		# Fire type  (Fireball, pool, cone jet, API jet)
		self.fireType = FireType.FIRE__BALL

		# Pool fire SEP for the two zones
		self.poolZoneSEP = []

		# Length of the flame
		self.flameLength = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Time of fire, or duration if initial rate
		self.time = float(data['time'])

		# Surface emissive power of flame
		self.surfaceEmissivePower = float(data['surfaceEmissivePower'])

		# Fire type  (Fireball, pool, cone jet, API jet)
		self.fireType = FireType(data['fireType'])

		# Pool fire SEP for the two zones
		for dataItem in data['poolZoneSEP']:
			self.poolZoneSEP.append(float(dataItem))

		# Length of the flame
		self.flameLength = float(data['flameLength'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* FlameResult')

		# Time of fire, or duration if initial rate
		print('Time\t{0}'.format(self.time))

		# Surface emissive power of flame
		print('Surface emissive power\t{0}'.format(self.surfaceEmissivePower))

		# Fire type  (Fireball, pool, cone jet, API jet)
		print('Fire type\t{0}'.format(self.fireType))

		# Pool fire SEP for the two zones
		print('Pool zone s e p\t{0}'.format(self.poolZoneSEP))

		# Length of the flame
		print('Flame length\t{0}'.format(self.flameLength))


# Class: Transect
# Description: Definition of transect (line segment)
class Transect(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Cartesian coordinates of start point of transect
		self.transectStartPoint = LocalPosition()

		# Cartesian coordinates of end point of transect
		self.transectEndPoint = LocalPosition()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Cartesian coordinates of start point of transect
		self.transectStartPoint.initialiseFromDictionary(data['transectStartPoint'])

		# Cartesian coordinates of end point of transect
		self.transectEndPoint.initialiseFromDictionary(data['transectEndPoint'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Transect')

		# Cartesian coordinates of start point of transect
		self.transectStartPoint.print()

		# Cartesian coordinates of end point of transect
		self.transectEndPoint.print()


# Class: FlammableOutputConfig
# Description: Fire and radiation output configuration
class FlammableOutputConfig(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Position used for radiation calculations (including contours)
		self.position = LocalPosition()

		# Radiation type
		self.radiationType = RadiationType.INTENSITY

		# Plane orientation for contouring
		self.contourType = ContourType.FOOTPRINT

		# Radiation level (could be dose, probit, intensity, etc)
		self.radiationLevel = 0.0

		# Spatial resolution for radiation calculations
		self.radiationResolution = Resolution.MEDIUM

		# Definition of line segment of interest for radiation transects
		self.transect = Transect()

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Position used for radiation calculations (including contours)
		self.position.initialiseFromDictionary(data['position'])

		# Radiation type
		self.radiationType = RadiationType(data['radiationType'])

		# Plane orientation for contouring
		self.contourType = ContourType(data['contourType'])

		# Radiation level (could be dose, probit, intensity, etc)
		self.radiationLevel = float(data['radiationLevel'])

		# Spatial resolution for radiation calculations
		self.radiationResolution = Resolution(data['radiationResolution'])

		# Definition of line segment of interest for radiation transects
		self.transect.initialiseFromDictionary(data['transect'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* FlammableOutputConfig')

		# Position used for radiation calculations (including contours)
		self.position.print()

		# Radiation type
		print('Radiation type\t{0}'.format(self.radiationType))

		# Plane orientation for contouring
		print('Contour type\t{0}'.format(self.contourType))

		# Radiation level (could be dose, probit, intensity, etc)
		print('Radiation level\t{0}'.format(self.radiationLevel))

		# Spatial resolution for radiation calculations
		print('Radiation resolution\t{0}'.format(self.radiationResolution))

		# Definition of line segment of interest for radiation transects
		self.transect.print()


# Class: FlammableParameters
# Description: Fire and radiation parameters
class FlammableParameters(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Maximum exposure duration to radiation effects
		self.maxExposureDuration = 20.0

		# Relative tolerance for radiation calculations
		self.radiationRelativeTolerance = 0.001

		# Type of pool fire modelling
		self.poolFireType = PoolFireType.LATE

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Maximum exposure duration to radiation effects
		self.maxExposureDuration = float(data['maxExposureDuration'])

		# Relative tolerance for radiation calculations
		self.radiationRelativeTolerance = float(data['radiationRelativeTolerance'])

		# Type of pool fire modelling
		self.poolFireType = PoolFireType(data['poolFireType'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* FlammableParameters')

		# Maximum exposure duration to radiation effects
		print('Max exposure duration\t{0}'.format(self.maxExposureDuration))

		# Relative tolerance for radiation calculations
		print('Radiation relative tolerance\t{0}'.format(self.radiationRelativeTolerance))

		# Type of pool fire modelling
		print('Pool fire type\t{0}'.format(self.poolFireType))


# Class: MaterialComponent
# Description: Constituent component of a material
class MaterialComponent(object):

	# Constructor.
	def __init__(self):

		# Name of the component.
		self.name = "ComponentName"

		# Mole fraction of the component in the material.
		self.moleFraction = 0.0


	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Name of the component.
		self.name = data['name']

		# Mole fraction of the component in the material.
		self.moleFraction = float(data['moleFraction'])


	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* MaterialComponent')

		# Name of the component.
		print('Name:\t{0}'.format(self.name))

		# Mole fraction of the component in the material.
		print('Mole fraction\t{0}'.format(self.moleFraction))



# Class: Material
class Material(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Material name
		self.name = ""

		# Number of components in the material
		self.componentCount = 1

		# Constituent components
		self.components = []

		# Property used template for material
		self.propertyTemplate = PropertyTemplate.PHAST_MC


	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Material name
		self.name = data['name']

		# Number of components in the material
		self.componentCount = int(data['componentCount'])

		# Constituent components
		for dataItem in data['components']:
			materialComponent = MaterialComponent()
			materialComponent.initialiseFromDictionary(dataItem)
			self.components.append(materialComponent)

		# Property used template for material
		self.propertyTemplate = PropertyTemplate(data['propertyTemplate'])


	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Material')

		# Material name
		print('Name:\t{0}'.format(self.name))

		# Number of components in the material
		print('Component count\t{0}'.format(self.componentCount))

		# Constituent components
		for item in self.components:
			item.print()

		# Property used template for material
		print('Property template\t{0}'.format(self.propertyTemplate))



# Class: FlareStack
# Description: Contains inputs required for running a flare stack calculation.
class FlareStack(Asset):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Material being flared
		self.flareStackMaterial = Material()

		# Fluid state in flare stack (driving the outflow)
		self.flareStackFluidState = State()

		# Flare stack tip height above ground level
		self.flareStackHeight = 0.0

		# Diameter of flare stack tip
		self.flareStackTipDiameter = 0.0

		# Phase of the stored material
		self.flareStackConditions = VesselConditions.PURE_GAS

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		Asset.initialiseFromDictionary(self, data)

		# Material being flared
		self.flareStackMaterial.initialiseFromDictionary(data['flareStackMaterial'])

		# Fluid state in flare stack (driving the outflow)
		self.flareStackFluidState.initialiseFromDictionary(data['flareStackFluidState'])

		# Flare stack tip height above ground level
		self.flareStackHeight = float(data['flareStackHeight'])

		# Diameter of flare stack tip
		self.flareStackTipDiameter = float(data['flareStackTipDiameter'])

		# Phase of the stored material
		self.flareStackConditions = VesselConditions(data['flareStackConditions'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* FlareStack')

		# Material being flared
		self.flareStackMaterial.print()

		# Fluid state in flare stack (driving the outflow)
		self.flareStackFluidState.print()

		# Flare stack tip height above ground level
		print('Flare stack height\t{0}'.format(self.flareStackHeight))

		# Diameter of flare stack tip
		print('Flare stack tip diameter\t{0}'.format(self.flareStackTipDiameter))

		# Phase of the stored material
		print('Flare stack conditions\t{0}'.format(self.flareStackConditions))


# Class: FlashResult
# Description: Physical properties for a material generated at a particular pressure and temperature
class FlashResult(object):

	# Constructor.
	def __init__(self):

		# Pressure
		self.pressure = 0.0

		# Temperature
		self.temperature = 0.0

		# Liquid fraction (mole)
		self.liquidMoleFraction = 0.0

		# Density of liquid phase
		self.liquidDensity = 0.0

		# Density of vapour phase
		self.vapourDensity = 0.0

		# Entropy of liquid phase
		self.liquidEntropy = 0.0

		# Entropy of vapour phase
		self.vapourEntropy = 0.0

		# Enthalpy of liquid phase
		self.liquidEnthalpy = 0.0

		# Enthalpy of vapour phase
		self.vapourEnthalpy = 0.0

		# Vapour, liquid or two-phase
		self.fluidPhase = Phase.VAPOUR

		# Mixture bubble point pressure at given temperature
		self.bubblePointPressure = 0.0

		# Mixture bubble point temperature at given pressure
		self.bubblePointTemperature = 0.0

		# Mixture dew point pressure at given temperature
		self.dewPointPressure = 0.0

		# Mixture dew point temperature at given pressure
		self.dewPointTemperature = 0.0

		# Total fluid density (mass-based)
		self.totalFluidDensity = 0.0

		# Liquid mass fraction
		self.liquidMassFraction = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Pressure
		self.pressure = float(data['pressure'])

		# Temperature
		self.temperature = float(data['temperature'])

		# Liquid fraction (mole)
		self.liquidMoleFraction = float(data['liquidMoleFraction'])

		# Density of liquid phase
		self.liquidDensity = float(data['liquidDensity'])

		# Density of vapour phase
		self.vapourDensity = float(data['vapourDensity'])

		# Entropy of liquid phase
		self.liquidEntropy = float(data['liquidEntropy'])

		# Entropy of vapour phase
		self.vapourEntropy = float(data['vapourEntropy'])

		# Enthalpy of liquid phase
		self.liquidEnthalpy = float(data['liquidEnthalpy'])

		# Enthalpy of vapour phase
		self.vapourEnthalpy = float(data['vapourEnthalpy'])

		# Vapour, liquid or two-phase
		self.fluidPhase = Phase(data['fluidPhase'])

		# Mixture bubble point pressure at given temperature
		self.bubblePointPressure = float(data['bubblePointPressure'])

		# Mixture bubble point temperature at given pressure
		self.bubblePointTemperature = float(data['bubblePointTemperature'])

		# Mixture dew point pressure at given temperature
		self.dewPointPressure = float(data['dewPointPressure'])

		# Mixture dew point temperature at given pressure
		self.dewPointTemperature = float(data['dewPointTemperature'])

		# Total fluid density (mass-based)
		self.totalFluidDensity = float(data['totalFluidDensity'])

		# Liquid mass fraction
		self.liquidMassFraction = float(data['liquidMassFraction'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* FlashResult')

		# Pressure
		print('Pressure\t{0}'.format(self.pressure))

		# Temperature
		print('Temperature\t{0}'.format(self.temperature))

		# Liquid fraction (mole)
		print('Liquid mole fraction\t{0}'.format(self.liquidMoleFraction))

		# Density of liquid phase
		print('Liquid density\t{0}'.format(self.liquidDensity))

		# Density of vapour phase
		print('Vapour density\t{0}'.format(self.vapourDensity))

		# Entropy of liquid phase
		print('Liquid entropy\t{0}'.format(self.liquidEntropy))

		# Entropy of vapour phase
		print('Vapour entropy\t{0}'.format(self.vapourEntropy))

		# Enthalpy of liquid phase
		print('Liquid enthalpy\t{0}'.format(self.liquidEnthalpy))

		# Enthalpy of vapour phase
		print('Vapour enthalpy\t{0}'.format(self.vapourEnthalpy))

		# Vapour, liquid or two-phase
		print('Fluid phase\t{0}'.format(self.fluidPhase))

		# Mixture bubble point pressure at given temperature
		print('Bubble point pressure\t{0}'.format(self.bubblePointPressure))

		# Mixture bubble point temperature at given pressure
		print('Bubble point temperature\t{0}'.format(self.bubblePointTemperature))

		# Mixture dew point pressure at given temperature
		print('Dew point pressure\t{0}'.format(self.dewPointPressure))

		# Mixture dew point temperature at given pressure
		print('Dew point temperature\t{0}'.format(self.dewPointTemperature))

		# Total fluid density (mass-based)
		print('Total fluid density\t{0}'.format(self.totalFluidDensity))

		# Liquid mass fraction
		print('Liquid mass fraction\t{0}'.format(self.liquidMassFraction))


# Class: ReleaseOverTime
# Description: Scenario representing a release over time.
class ReleaseOverTime(Scenario):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Angle above horizontal of release
		self.releaseAngle = 0.0

		# Time-varying or steady-state modelling
		self.timeVaryingOption = TimeVaryingOption.INITIAL_RATE

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		Scenario.initialiseFromDictionary(self, data)

		# Angle above horizontal of release
		self.releaseAngle = float(data['releaseAngle'])

		# Time-varying or steady-state modelling
		self.timeVaryingOption = TimeVaryingOption(data['timeVaryingOption'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ReleaseOverTime')

		# Angle above horizontal of release
		print('Release angle\t{0}'.format(self.releaseAngle))

		# Time-varying or steady-state modelling
		print('Time varying option\t{0}'.format(self.timeVaryingOption))


# Class: Leak
# Description: Leak scenario.
class Leak(ReleaseOverTime):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Diameter of the hole
		self.holeDiameter = 0.0

		# Location of the hole above the base of the vessel as a fraction of vessel height
		self.holeHeightFraction = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		ReleaseOverTime.initialiseFromDictionary(self, data)

		# Diameter of the hole
		self.holeDiameter = float(data['holeDiameter'])

		# Location of the hole above the base of the vessel as a fraction of vessel height
		self.holeHeightFraction = float(data['holeHeightFraction'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Leak')

		# Diameter of the hole
		print('Hole diameter\t{0}'.format(self.holeDiameter))

		# Location of the hole above the base of the vessel as a fraction of vessel height
		print('Hole height fraction\t{0}'.format(self.holeHeightFraction))


# Class: Pipe
# Description: All pipe types
class Pipe(Asset):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Pipeline nodes
		self.nodes = []

		# Pipe diameter
		self.diameter = 0.0

		# Pipe roughness
		self.roughness = 4.5e-5

		# Material
		self.material = Material()

		# Fluid state
		self.state = State()

		# Upstream pumped inflow
		self.pumpedInflow = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		Asset.initialiseFromDictionary(self, data)

		# Pipeline nodes
		for dataItem in data['nodes']:
			localPosition = LocalPosition()
			localPosition.initialiseFromDictionary(dataItem)
			self.nodes.append(localPosition)

		# Pipe diameter
		self.diameter = float(data['diameter'])

		# Pipe roughness
		self.roughness = float(data['roughness'])

		# Material
		self.material.initialiseFromDictionary(data['material'])

		# Fluid state
		self.state.initialiseFromDictionary(data['state'])

		# Upstream pumped inflow
		self.pumpedInflow = float(data['pumpedInflow'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Pipe')

		# Pipeline nodes
		for item in self.nodes:
			item.print()

		# Pipe diameter
		print('Diameter\t{0}'.format(self.diameter))

		# Pipe roughness
		print('Roughness\t{0}'.format(self.roughness))

		# Material
		self.material.print()

		# Fluid state
		self.state.print()

		# Upstream pumped inflow
		print('Pumped inflow\t{0}'.format(self.pumpedInflow))


# Class: PipeBreach
# Description: Breach in a long pipe (runs GSPP / PBRK).
class PipeBreach(ReleaseOverTime):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Distance downstream
		self.distanceDownstream = 0.0

		# Breach relative aperture
		self.relativeAperture = 1.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		ReleaseOverTime.initialiseFromDictionary(self, data)

		# Distance downstream
		self.distanceDownstream = float(data['distanceDownstream'])

		# Breach relative aperture
		self.relativeAperture = float(data['relativeAperture'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* PipeBreach')

		# Distance downstream
		print('Distance downstream\t{0}'.format(self.distanceDownstream))

		# Breach relative aperture
		print('Relative aperture\t{0}'.format(self.relativeAperture))


# Class: PoolRecord
# Description: Pool results at a given time
class PoolRecord(object):

	# Constructor.
	def __init__(self):

		# Time since rainout
		self.time = 0.0

		# Mass spilled
		self.massSpilt = 0.0

		# Mass vaporised
		self.massVaporised = 0.0

		# Mass dissolved
		self.massDissolved = 0.0

		# Mass remaining
		self.massRemaining = 0.0

		# Vapourisation rate
		self.vapourisationRate = 0.0

		# Solution rate
		self.solutionRate = 0.0

		# Effective radius
		self.effectiveRadius = 0.0

		# Pool depth
		self.depth = 0.0

		# Pool temperature
		self.temperature = 0.0

		# Spill rate
		self.spillRate = 0.0

		# Actual pool radius
		self.actualRadius = 0.0

		# Pool centre
		self.poolCentre = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Time since rainout
		self.time = float(data['time'])

		# Mass spilled
		self.massSpilt = float(data['massSpilt'])

		# Mass vaporised
		self.massVaporised = float(data['massVaporised'])

		# Mass dissolved
		self.massDissolved = float(data['massDissolved'])

		# Mass remaining
		self.massRemaining = float(data['massRemaining'])

		# Vapourisation rate
		self.vapourisationRate = float(data['vapourisationRate'])

		# Solution rate
		self.solutionRate = float(data['solutionRate'])

		# Effective radius
		self.effectiveRadius = float(data['effectiveRadius'])

		# Pool depth
		self.depth = float(data['depth'])

		# Pool temperature
		self.temperature = float(data['temperature'])

		# Spill rate
		self.spillRate = float(data['spillRate'])

		# Actual pool radius
		self.actualRadius = float(data['actualRadius'])

		# Pool centre
		self.poolCentre = float(data['poolCentre'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* PoolRecord')

		# Time since rainout
		print('Time\t{0}'.format(self.time))

		# Mass spilled
		print('Mass spilt\t{0}'.format(self.massSpilt))

		# Mass vaporised
		print('Mass vaporised\t{0}'.format(self.massVaporised))

		# Mass dissolved
		print('Mass dissolved\t{0}'.format(self.massDissolved))

		# Mass remaining
		print('Mass remaining\t{0}'.format(self.massRemaining))

		# Vapourisation rate
		print('Vapourisation rate\t{0}'.format(self.vapourisationRate))

		# Solution rate
		print('Solution rate\t{0}'.format(self.solutionRate))

		# Effective radius
		print('Effective radius\t{0}'.format(self.effectiveRadius))

		# Pool depth
		print('Depth\t{0}'.format(self.depth))

		# Pool temperature
		print('Temperature\t{0}'.format(self.temperature))

		# Spill rate
		print('Spill rate\t{0}'.format(self.spillRate))

		# Actual pool radius
		print('Actual radius\t{0}'.format(self.actualRadius))

		# Pool centre
		print('Pool centre\t{0}'.format(self.poolCentre))


# Class: PoolVapourisationParameters
# Description: Pool vapourisation parameters
class PoolVapourisationParameters(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Cutoff rate for toxic materials
		self.toxicsCutoffRate = 0.001

		# Cutoff rate for flammable materials
		self.flammableCutoffRate = 0.1

		# Relative tolerance
		self.relativeTolerance = 0.001

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Cutoff rate for toxic materials
		self.toxicsCutoffRate = float(data['toxicsCutoffRate'])

		# Cutoff rate for flammable materials
		self.flammableCutoffRate = float(data['flammableCutoffRate'])

		# Relative tolerance
		self.relativeTolerance = float(data['relativeTolerance'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* PoolVapourisationParameters')

		# Cutoff rate for toxic materials
		print('Toxics cutoff rate\t{0}'.format(self.toxicsCutoffRate))

		# Cutoff rate for flammable materials
		print('Flammable cutoff rate\t{0}'.format(self.flammableCutoffRate))

		# Relative tolerance
		print('Relative tolerance\t{0}'.format(self.relativeTolerance))


# Class: RadiationRecord
# Description: Radiation type and level at specific point (x,y,z)
class RadiationRecord(object):

	# Constructor.
	def __init__(self):

		# Cartesian coordinates of a specific point
		self.position = LocalPosition()

		# Type of radiation result
		self.radiationType = RadiationType.DOSE

		# Radiation level
		self.radiationResult = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Cartesian coordinates of a specific point
		self.position.initialiseFromDictionary(data['position'])

		# Type of radiation result
		self.radiationType = RadiationType(data['radiationType'])

		# Radiation level
		self.radiationResult = float(data['radiationResult'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* RadiationRecord')

		# Cartesian coordinates of a specific point
		self.position.print()

		# Type of radiation result
		print('Radiation type\t{0}'.format(self.radiationType))

		# Radiation level
		print('Radiation result\t{0}'.format(self.radiationResult))


# Class: ScalarUdmOutputs
# Description: Scalar UDM output values required for post processing dispersion results.
class ScalarUdmOutputs(object):

	# Constructor.
	def __init__(self):

		# Number of observers
		self.observerCount = 0

		# Number of records
		self.recordCount = 0

		# Cloud type
		self.cloudType = DynamicType.INSTANTANEOUS

		# Minimum concentration
		self.minimumConcentration = 0.0

		# Wind power
		self.windPower = 0.0

		# Friction velocity
		self.frictionVelocity = 0.0

		# When is the last release observer released?
		self.dispersionReleaseDuration = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Number of observers
		self.observerCount = int(data['observerCount'])

		# Number of records
		self.recordCount = int(data['recordCount'])

		# Cloud type
		self.cloudType = DynamicType(data['cloudType'])

		# Minimum concentration
		self.minimumConcentration = float(data['minimumConcentration'])

		# Wind power
		self.windPower = float(data['windPower'])

		# Friction velocity
		self.frictionVelocity = float(data['frictionVelocity'])

		# When is the last release observer released?
		self.dispersionReleaseDuration = float(data['dispersionReleaseDuration'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ScalarUdmOutputs')

		# Number of observers
		print('Observer count\t{0}'.format(self.observerCount))

		# Number of records
		print('Record count\t{0}'.format(self.recordCount))

		# Cloud type
		print('Cloud type\t{0}'.format(self.cloudType))

		# Minimum concentration
		print('Minimum concentration\t{0}'.format(self.minimumConcentration))

		# Wind power
		print('Wind power\t{0}'.format(self.windPower))

		# Friction velocity
		print('Friction velocity\t{0}'.format(self.frictionVelocity))

		# When is the last release observer released?
		print('Dispersion release duration\t{0}'.format(self.dispersionReleaseDuration))


# Class: Substrate
# Description: The ground over which a release is taking place.
class Substrate(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Surface roughness length
		self.surfaceRoughness = 0.183

		# Dispersing surface type
		self.surfaceType = SurfaceType.LAND

		# Pool or bund surface type
		self.poolSurfaceType = PoolSurfaceType.CONCRETE

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Surface roughness length
		self.surfaceRoughness = float(data['surfaceRoughness'])

		# Dispersing surface type
		self.surfaceType = SurfaceType(data['surfaceType'])

		# Pool or bund surface type
		self.poolSurfaceType = PoolSurfaceType(data['poolSurfaceType'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Substrate')

		# Surface roughness length
		print('Surface roughness\t{0}'.format(self.surfaceRoughness))

		# Dispersing surface type
		print('Surface type\t{0}'.format(self.surfaceType))

		# Pool or bund surface type
		print('Pool surface type\t{0}'.format(self.poolSurfaceType))


# Class: ThermoPathRecord
# Description: Contains a point on the thermodynamic depressurization trajectory for each of isothermal, isentropic and isenthalpic assumptions.
class ThermoPathRecord(object):

	# Constructor.
	def __init__(self):

		# Absolute pressure value at specific point on the thermodynamic path
		self.pressure = 0.0

		# Bubble point temperature at given pressure
		self.bubbleTemperature = 0.0

		# Dew point temperature at given pressure
		self.dewTemperature = 0.0

		# Temperature at given pressure following isentropic depressurization
		self.isentropicTemperature = 0.0

		# Temperature at given pressure following isenthalpic depressurization
		self.isenthalpicTemperature = 0.0

		# Temperature at given pressure following isothermal depressurization
		self.isothermalTemperature = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Absolute pressure value at specific point on the thermodynamic path
		self.pressure = float(data['pressure'])

		# Bubble point temperature at given pressure
		self.bubbleTemperature = float(data['bubbleTemperature'])

		# Dew point temperature at given pressure
		self.dewTemperature = float(data['dewTemperature'])

		# Temperature at given pressure following isentropic depressurization
		self.isentropicTemperature = float(data['isentropicTemperature'])

		# Temperature at given pressure following isenthalpic depressurization
		self.isenthalpicTemperature = float(data['isenthalpicTemperature'])

		# Temperature at given pressure following isothermal depressurization
		self.isothermalTemperature = float(data['isothermalTemperature'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ThermoPathRecord')

		# Absolute pressure value at specific point on the thermodynamic path
		print('Pressure\t{0}'.format(self.pressure))

		# Bubble point temperature at given pressure
		print('Bubble temperature\t{0}'.format(self.bubbleTemperature))

		# Dew point temperature at given pressure
		print('Dew temperature\t{0}'.format(self.dewTemperature))

		# Temperature at given pressure following isentropic depressurization
		print('Isentropic temperature\t{0}'.format(self.isentropicTemperature))

		# Temperature at given pressure following isenthalpic depressurization
		print('Isenthalpic temperature\t{0}'.format(self.isenthalpicTemperature))

		# Temperature at given pressure following isothermal depressurization
		print('Isothermal temperature\t{0}'.format(self.isothermalTemperature))


# Class: ToxicRecord
# Description: Toxic result: dose, probit or lethality
class ToxicRecord(object):

	# Constructor.
	def __init__(self):

		# Cartesian coordinates of a specific point
		self.position = LocalPosition()

		# Type of toxic result
		self.toxicResultType = ToxicResultType.TOXIC_LETHALITY

		# Dose, probit or lethality level
		self.toxicResult = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Cartesian coordinates of a specific point
		self.position.initialiseFromDictionary(data['position'])

		# Type of toxic result
		self.toxicResultType = ToxicResultType(data['toxicResultType'])

		# Dose, probit or lethality level
		self.toxicResult = float(data['toxicResult'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* ToxicRecord')

		# Cartesian coordinates of a specific point
		self.position.print()

		# Type of toxic result
		print('Toxic result type\t{0}'.format(self.toxicResultType))

		# Dose, probit or lethality level
		print('Toxic result\t{0}'.format(self.toxicResult))


# Class: Vessel
# Description: All vessel types
class Vessel(Asset):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Fluid specification (at liquid surface)
		self.state = State()

		# Internal diameter of the vessel
		self.diameter = 0.0

		# Internal height of the vessel
		self.height = 0.0

		# Internal length of the vessel
		self.length = 0.0

		# Internal width of the vessel
		self.width = 0.0

		# Shape
		self.shape = VesselShape.VESSEL_SPHERE

		# Material
		self.material = Material()

		# Vessel conditions
		self.vesselConditions = VesselConditions.PURE_GAS

		# The liquid fill fraction in the vessel by volume
		self.liquidFillFractionByVolume = 0.0


	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		Asset.initialiseFromDictionary(self, data)

		# Fluid specification (at liquid surface)
		self.state.initialiseFromDictionary(data['state'])

		# Internal diameter of the vessel
		self.diameter = float(data['diameter'])

		# Internal height of the vessel
		self.height = float(data['height'])

		# Internal length of the vessel
		self.length = float(data['length'])

		# Internal width of the vessel
		self.width = float(data['width'])

		# Shape
		self.shape = VesselShape(data['shape'])

		# Material
		self.material.initialiseFromDictionary(data['material'])

		# Vessel conditions
		self.vesselConditions = VesselConditions(data['vesselConditions'])

		# The liquid fill fraction in the vessel by volume
		self.liquidFillFractionByVolume = float(data['liquidFillFractionByVolume'])


	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Vessel')

		# Fluid specification (at liquid surface)
		self.state.print()

		# Internal diameter of the vessel
		print('Diameter\t{0}'.format(self.diameter))

		# Internal height of the vessel
		print('Height\t{0}'.format(self.height))

		# Internal length of the vessel
		print('Length\t{0}'.format(self.length))

		# Internal width of the vessel
		print('Width\t{0}'.format(self.width))

		# Shape
		print('Shape\t{0}'.format(self.shape))

		# Material
		self.material.print()

		# Vessel conditions
		print('Vessel conditions\t{0}'.format(self.vesselConditions))

		# The liquid fill fraction in the vessel by volume
		print('Liquid fill fraction by volume\t{0}'.format(self.liquidFillFractionByVolume))



# Class: VesselLeakMaxFlammableCloudResults
# Description: Results for a linked run of vessel leak followed by dispersion and views from the cloud
class VesselLeakMaxFlammableCloudResults(object):

	# Constructor.
	def __init__(self):

		# Leak discharge mass rate
		self.dischargeRate = 0.0

		# Post atmospheric expansion temperature
		self.expandedTemperature = 0.0

		# Post atmospheric expansion fluid phase
		self.phase = Phase.VAPOUR

		# Maximum downwind distance to LFL
		self.lflExtent = 0.0

		# Horizontal area within LFL envelope
		self.lflArea = 0.0

		# Height of maximum LFL extent
		self.lflHeight = 0.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Leak discharge mass rate
		self.dischargeRate = float(data['dischargeRate'])

		# Post atmospheric expansion temperature
		self.expandedTemperature = float(data['expandedTemperature'])

		# Post atmospheric expansion fluid phase
		self.phase = Phase(data['phase'])

		# Maximum downwind distance to LFL
		self.lflExtent = float(data['lflExtent'])

		# Horizontal area within LFL envelope
		self.lflArea = float(data['lflArea'])

		# Height of maximum LFL extent
		self.lflHeight = float(data['lflHeight'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* VesselLeakMaxFlammableCloudResults')

		# Leak discharge mass rate
		print('Discharge rate\t{0}'.format(self.dischargeRate))

		# Post atmospheric expansion temperature
		print('Expanded temperature\t{0}'.format(self.expandedTemperature))

		# Post atmospheric expansion fluid phase
		print('Phase\t{0}'.format(self.phase))

		# Maximum downwind distance to LFL
		print('L f l extent\t{0}'.format(self.lflExtent))

		# Horizontal area within LFL envelope
		print('L f l area\t{0}'.format(self.lflArea))

		# Height of maximum LFL extent
		print('L f l height\t{0}'.format(self.lflHeight))


# Class: VesselRuleSet
# Description: Rule set for generating scenarios from a vessel
class VesselRuleSet(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Use time-varying leaks
		self.useTimeVarying = False

		# Include catastrophic rupture scenarios
		self.includeCatastrophicRupture = False

		# Hole diameters for leaks
		self.holeDiameters = []

		# Number of hole diameters (<= 5)
		self.numberOfDiameters = 3

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Use time-varying leaks
		self.useTimeVarying = bool(data['useTimeVarying'])

		# Include catastrophic rupture scenarios
		self.includeCatastrophicRupture = bool(data['includeCatastrophicRupture'])

		# Hole diameters for leaks
		for dataItem in data['holeDiameters']:
			self.holeDiameters.append(float(dataItem))

		# Number of hole diameters (<= 5)
		self.numberOfDiameters = int(data['numberOfDiameters'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* VesselRuleSet')

		# Use time-varying leaks
		print('Use time varying\t{0}'.format(self.useTimeVarying))

		# Include catastrophic rupture scenarios
		print('Include catastrophic rupture\t{0}'.format(self.includeCatastrophicRupture))

		# Hole diameters for leaks
		print('Hole diameters\t{0}'.format(self.holeDiameters))

		# Number of hole diameters (<= 5)
		print('Number of diameters\t{0}'.format(self.numberOfDiameters))


# Class: Weather
# Description: A sum of the meteorological conditions at the time
class Weather(EntityBase):

	# Constructor.
	def __init__(self):
		super().__init__()

		# Wind speed at reference height
		self.windSpeed = 0.0

		# Stability class
		self.stabilityClass = AtmosphericStabilityClass.STABILITY_D

		# Ambient temperature
		self.temperature = 283.0

		# Relative humidity
		self.relativeHumidity = 0.7

		# Mixing layer height
		self.mixingLayerHeight = 800.0

		# Solar radiation flux
		self.solarRadiation = 500.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Call the base class initialiseFromDictionary method
		EntityBase.initialiseFromDictionary(self, data)

		# Wind speed at reference height
		self.windSpeed = float(data['windSpeed'])

		# Stability class
		self.stabilityClass = AtmosphericStabilityClass(data['stabilityClass'])

		# Ambient temperature
		self.temperature = float(data['temperature'])

		# Relative humidity
		self.relativeHumidity = float(data['relativeHumidity'])

		# Mixing layer height
		self.mixingLayerHeight = float(data['mixingLayerHeight'])

		# Solar radiation flux
		self.solarRadiation = float(data['solarRadiation'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* Weather')

		# Wind speed at reference height
		print('Wind speed\t{0}'.format(self.windSpeed))

		# Stability class
		print('Stability class\t{0}'.format(self.stabilityClass))

		# Ambient temperature
		print('Temperature\t{0}'.format(self.temperature))

		# Relative humidity
		print('Relative humidity\t{0}'.format(self.relativeHumidity))

		# Mixing layer height
		print('Mixing layer height\t{0}'.format(self.mixingLayerHeight))

		# Solar radiation flux
		print('Solar radiation\t{0}'.format(self.solarRadiation))


# Class: WeatherStationData
# Description: Compiled data from weather live service
class WeatherStationData(object):

	# Constructor.
	def __init__(self):

		# Latitude measured in degrees
		self.latitude = 0.0

		# Longitude coordinate in degrees
		self.longitude = 0.0

		# Indicates if it is day or night
		self.dayNightOption = DayNight.DAY

		# Cloud coverage in percentage
		self.cloudiness = 0.0

		# Wind speed at reference height
		self.windSpeed = 0.0

		# Ambient temperature
		self.temperature = 0.0

		# Relative humidity
		self.relativeHumidity = 0.0

		# Solar radiation flux
		self.solarRadiation = 500.0

	# Initialise entity with data from a dictionary.
	def initialiseFromDictionary(self, data: dict):

		# Latitude measured in degrees
		self.latitude = float(data['latitude'])

		# Longitude coordinate in degrees
		self.longitude = float(data['longitude'])

		# Indicates if it is day or night
		self.dayNightOption = DayNight(data['dayNightOption'])

		# Cloud coverage in percentage
		self.cloudiness = float(data['cloudiness'])

		# Wind speed at reference height
		self.windSpeed = float(data['windSpeed'])

		# Ambient temperature
		self.temperature = float(data['temperature'])

		# Relative humidity
		self.relativeHumidity = float(data['relativeHumidity'])

		# Solar radiation flux
		self.solarRadiation = float(data['solarRadiation'])

	# Print out the entity's properties.
	def print(self):

		# Print out the entity name.
		print('* WeatherStationData')

		# Latitude measured in degrees
		print('Latitude\t{0}'.format(self.latitude))

		# Longitude coordinate in degrees
		print('Longitude\t{0}'.format(self.longitude))

		# Indicates if it is day or night
		print('Day night option\t{0}'.format(self.dayNightOption))

		# Cloud coverage in percentage
		print('Cloudiness\t{0}'.format(self.cloudiness))

		# Wind speed at reference height
		print('Wind speed\t{0}'.format(self.windSpeed))

		# Ambient temperature
		print('Temperature\t{0}'.format(self.temperature))

		# Relative humidity
		print('Relative humidity\t{0}'.format(self.relativeHumidity))

		# Solar radiation flux
		print('Solar radiation\t{0}'.format(self.solarRadiation))


