# MeerK40t
MeerK40t (pronounced MeerKat) is a built-from-the-ground-up MIT licensed open-source laser cutting software. It's a replacement for LaserDrw, Corel Laser, and K40 Whisperer.

For the M2-Nano, Meerk40t supports two sets of drivers which come with the software supplied with the K40 and which are used by Whisperer and the default USB drivers,
and so MeerK40t can usually run alongside these other pieces of software but without requiring them as a pre-requisite.

MeerK40t is written in Python and precompiled versions are [available for download](https://github.com/meerk40t/meerk40t/releases) for Windows, Mac OSX, Linux and Raspberry Pi.

Alternatively you can run MeerK40t directly from Python.

The primary source for help and documentation is the [MeerK40t Wiki - please click here](https://github.com/meerk40t/meerk40t/wiki).
Please help us make this a comprehensive source of information.

## GUI
![meerk40t7](https://user-images.githubusercontent.com/3302478/132944749-c40ad085-76ed-4236-b7bb-e97abdc578bf.png)

The wxMeerK40t is the GUI and is written in wxPython.

## Features
*   Built in Raster Preprocessing, RasterWizard.
*   Plugin API for writing your own code.
*   Dual drivers, use either the Whisperer method or LaserDrw method.
*   Grid/Guides, Zoom and Pan scene Navigation (use middle mouse button, mouse wheel).
*   Easy Object Manipulation.
*   PPI Power modulation (Yes, power modulation for the M2 Nano)
*   Keybinds and advanced console execution.
*   Drag-and-Drop support for SVGs/Images.
*   On-the-fly job processing
*   Multi-language support.
*   Multi-K40 support.
*   Pixel perfect curve cutting.
*   Command Line Interface

## Support
The primary source for help and documentation is the [MeerK40t Wiki - please click here](https://github.com/meerk40t/meerk40t/wiki).

If you have a bug, feature request, or other issue raise it here. These are likely to be resolved. Squeaky wheels get the grease.
https://github.com/meerk40t/meerk40t/issues

If you need additional support, please research/ask on:

*   [Facebook](https://www.facebook.com/groups/716000085655097/)
*   [Maker Forums](https://forum.makerforums.info/t/about-the-meerk40t-category/79660)
*   [Youtube - David Olsen's channel](https://www.youtube.com/channel/UCsAUV23O2FyKxC0HN7nkAQQ)
*   [Youtube - Milan Karakas' channel](https://www.youtube.com/channel/UCXhlGsmGJZ3m5GgTE8xuc_Q)
*   [IRC - channel #MeerK40t on irc.libera.chat](irc://irc.libera.chat:6667)
*   [Discord](https://discord.gg/qvASRhFZGB)

## Assisting the Project

Open source projects live and die with their support. There are a lots of ways to help the project.
*   Documentation - edit the Wiki
*   Provide Translations in other languages.
*   Code
*   Research ( https://github.com/meerk40t/meerk40t/wiki/Needed-Research )
*   Design ( Good design instincts, smooth out the rough edges)
*   Compile/Testers
*   Beta testers
*   Provide feedback, criticism is preferable to praise but both are welcome.
*   Make helpful support content
*   Make guides ("How to setup cameras?", etc)
*   Bounce ideas around
