[![Python >= 3.6](https://img.shields.io/badge/python->=3.6-red.svg)](https://www.python.org/downloads/) [![](https://badgen.net/github/release/deedy5/fake_traffic)](https://github.com/deedy5/fake_traffic/releases) [![](https://badge.fury.io/py/fake-traffic.svg)](https://pypi.org/project/fake-traffic) 
[![Downloads](https://pepy.tech/badge/fake-traffic/month)](https://pepy.tech/project/fake-traffic)
# fake_traffic
Imitating an Internet user by mimicking popular web traffic (internet traffic generator).

### How it works:
```python3
1. you specify the country, language and category of interests of a user,
while True:
  2. from google trends the script gets a list of popular keywords that are searched in real time 
  on google by people with a given category of interest in a given country in a given language,
  threads:
    3. select a random trend, take from there the keywords and urls of related articles,
    4. the selected keywords are searched on google and duckduckgo, the found urls are added 
       to the existing ones,
    5. the script sequentially sends requests to a list of urls,
    6. in each open url, recursive queries to random links are performed to a random depth (1-5).
```

### Install

```python3
pip install -U fake_traffic
```

### Dependencies
```python3
lxml
requests
google_trends
duckduckgo_search
google_searching
```
---
### Simple usage
```python3
from fake_traffic import fake_traffic

fake_traffic(country='US', language='en-US")
```
---
### Advanced usage
```python3
from fake_traffic import fake_traffic

fake_traffic(country='US', language='en-US', category='h', threads=2, min_wait=1, max_wait=5, debug=True)
    """
    Imitating an Internet user by mimicking popular web traffic (internet traffic generator).
    
    country = country code ISO 3166-1 Alpha-2 code (https://www.iso.org/obp/ui/),
    language = country-language code ISO-639 and ISO-3166 (https://www.fincher.org/Utilities/CountryLanguageList.shtml),
    category = сategory of interest of a user (defaults to 'h'):
               'all' (all), 'b' (business), 'e' (entertainment), 
               'm' (health), 's' (sports), 't' (sci/tech), 'h' (top stories);
    threads = number of threads (defaults to 1),
    min_wait = minimal delay between requests (defaults to 1),
    max_wait = maximum delay between requests (defaults to 30),
    debug = if True, then print the details of the requests (defaults to False).
    """
```
---
### Example
Mimic traffic of a user located in Turkey, who speaks Kurdish and is interested in health

Find Turkey country code ([ISO 3166-1 Alpha-2 code](https://www.iso.org/obp/ui/)):</br>
  - country = "TR" </br>

Find Turkey country-language code ([ISO-639 and ISO-3166](https://www.fincher.org/Utilities/CountryLanguageList.shtml)): </br>
  - english  "en-TR", </br>
  - kurdish  "ku-TR", </br>
  - turkish  "tr-TR". </br>

Set the health category
  - category = 'm'

Starting work in two threads:
  - threads=2
```python3
from fake_traffic import fake_traffic

fake_traffic(country="TR", language="ku-TR", category='m', threads=2)
```
P.S. you can select language from other country. 
For example, such combinations are also correct:
```python3
fake_traffic(country="TR", language="ar-TR")
fake_traffic(country="US", language="he-IL")
fake_traffic(country="DE", language="hi-IN")
```
### Other examples
Country   | Language  | Function                                     |
----------|---------- | ---------------------------------------------|
France    | French    | fake_traffic(country="FR", language="fr-FR") |
Germany   | German    | fake_traffic(country="DE", language="de-DE", category='b') |
India     | English   | fake_traffic(country="IN", language="en-IN", category='all') |
India     | Hindi     | fake_traffic(country="IN", language="hi-IN", max_wait=10) |
Russia    | English   | fake_traffic(country="RU", language="en-RU", category='b', threads=3, debug=True) |
Russia    | Russian   | fake_traffic(country="RU", language="ru-RU", min_wait=0.5, max_wait=3, threads=5) |
United Arab Emirates | Arabic | fake_traffic(country="AE", language="ar-AE", max_wait=60) |
United Kingdom | English   | fake_traffic(country="GB", language="en-GB") |
United States  | English   | fake_traffic(country="US", language="en-US", min_wait=60, max_wait=300) |
