"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplate = void 0;
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplate extends core_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const { approvalRuleTemplateName, approvalRuleTemplateDescription, template, } = props;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::ApprovalRuleTemplate', {
            codeDirectory: directories_1.approvalRuleTemplateDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:CreateApprovalRuleTemplate',
                        'codecommit:DeleteApprovalRuleTemplate',
                        'codecommit:GetApprovalRuleTemplate',
                        'codecommit:UpdateApprovalRuleTemplateContent',
                        'codecommit:UpdateApprovalRuleTemplateDescription',
                        'codecommit:UpdateApprovalRuleTemplateName',
                    ],
                    Resource: '*',
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::ApprovalRuleTemplate',
            properties: {
                ApprovalRuleTemplateName: approvalRuleTemplateName,
                ApprovalRuleTemplateDescription: approvalRuleTemplateDescription,
                Template: {
                    DestinationReferences: (_a = template.branches) === null || _a === void 0 ? void 0 : _a.map((branch) => `refs/heads/${branch}`),
                    Approvers: {
                        NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                        ApprovalPoolMembers: template.approvers.approvalPoolMembers,
                    },
                },
            },
        });
        this.approvalRuleTemplateName = resource.getAttString('ApprovalRuleTemplateName');
    }
}
exports.ApprovalRuleTemplate = ApprovalRuleTemplate;
//# sourceMappingURL=data:application/json;base64,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