// original implementation done by Christian Engwer
#ifndef DUNE_ORTHONORMALBASE_3D_HH
#define DUNE_ORTHONORMALBASE_3D_HH

#define PMAX3D 4

#include <stdlib.h>
#include <stdio.h>
#include <cassert>

namespace Dune
{
  namespace Fem
  {
    template <class DomainField, class RangeField>
    class OrthonormalBase_3D
    {
      typedef const DomainField*  DomainType;
      typedef       RangeField*   JacobianRangeType;

    public:
      /* \phi_i(x,y,z) for tetrahedron */
      static RangeField
      eval_tetrahedron_3d ( const int i, DomainType xi )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];
        const RangeField &z = xi[2];

        switch (i)	{
          #if (PMAX3D>=0)
          case ( 0 ):
            return 2.4494897427831780981972840747059;
          #endif
          #if (PMAX3D>=1)
          case ( 1 ):
            return -3.1622776601683793319988935444327
             + 12.649110640673517327995574177731*x;
          case ( 2 ):
            return -4.4721359549995793928183473374626
             + 4.4721359549995793928183473374626*x
             + 13.416407864998738178455042012388*y;
          case ( 3 ):
            return -7.7459666924148337703585307995648
             + 7.745966692414833770358530799565*x
             + 7.745966692414833770358530799565*y
             + 15.49193338482966754071706159913*z;
          #endif
          #if (PMAX3D>=2)
          case ( 4 ):
            return 3.7416573867739413855837487323165
             + x*(-37.416573867739413855837487323165
             + 56.12486080160912078375623098475*x);
          case ( 5 ):
            return 5.2915026221291811810032315072785
             - 15.874507866387543543009694521836*y
             + x*(-37.04051835490426826702262055095
             + 31.749015732775087086019389043671*x
             + 95.24704719832526125805816713101*y);
          case ( 6 ):
            return 9.165151389911680013176094387456
             - 9.165151389911680013176094387456*y
             - 18.330302779823360026352188774912*z
             + x*(-64.156059729381760092232660712192
             + 54.99090833947008007905656632474*x
             + 54.99090833947008007905656632474*y
             + 109.98181667894016015811313264947*z);
          case ( 7 ):
            return 6.480740698407860230965967436088
             + x*(-12.961481396815720461931934872176
             + 6.480740698407860230965967436088*x
             + 51.8459255872628818477277394887*y)
             + y*(-51.845925587262881847727739488704
             + 64.80740698407860230965967436088*y);
          case ( 8 ):
            return 11.22497216032182415675124619695
             - 22.449944320643648313502492393899*z
             + x*(-22.449944320643648313502492393899
             + 11.22497216032182415675124619695*x
             + 67.3498329619309449405074771817*y
             + 22.449944320643648313502492393899*z)
             + y*(-67.349832961930944940507477181698
             + 56.12486080160912078375623098475*y
             + 112.2497216032182415675124619695*z);
          case ( 9 ):
            return 14.49137674618943857371866415717
             + z*(-86.948260477136631442311984943019
             + 86.94826047713663144231198494302*z)
             + y*(-28.98275349237887714743732831434
             + 14.49137674618943857371866415717*y
             + 86.94826047713663144231198494302*z)
             + x*(-28.98275349237887714743732831434
             + 14.49137674618943857371866415717*x
             + 28.98275349237887714743732831434*y
             + 86.94826047713663144231198494302*z);
          #endif
          #if (PMAX3D>=3)
          case ( 10 ):
            return -4.2426406871192851464050661726291
             + x*(76.367532368147132635291191107324
             + x*(-267.28636328851496422351916887563
             + 237.58787847867996819868370566723*x));
          case ( 11 ):
            return -6.
             + 18.*y
             + x*(90.
             - 252.*y
             + x*(-252.
             + 168.*x
             + 504.*y));
          case ( 12 ):
            return -10.392304845413263761164678049035
             + 10.392304845413263761164678049035*y
             + 20.78460969082652752232935609807*z
             + x*(155.88457268119895641747017073553
             - 145.49226783578569265630549268649*y
             - 290.98453567157138531261098537299*z
             + x*(-436.47680350735707796891647805948
             + 290.98453567157138531261098537299*x
             + 290.98453567157138531261098537299*y
             + 581.969071343142770625221970746*z));
          case ( 13 ):
            return -7.3484692283495342945918522241177
             + (58.787753826796274356734817792941
             - 73.48469228349534294591852224118*y)*y
             + x*(73.484692283495342945918522241177
             + x*(-124.92397688194208300806148781
             + 58.78775382679627435673481779294*x
             + 470.30203061437019485387854234353*y)
             + y*(-529.08978444116646921061336013647
             + 587.8775382679627435673481779294*y));
          case ( 14 ):
            return -12.727922061357855439215198517887
             + y*(76.367532368147132635291191107324
             - 63.63961030678927719607599258944*y
             - 127.27922061357855439215198517887*z)
             + 25.455844122715710878430397035775*z
             + x*(127.27922061357855439215198517887
             - 229.10259710444139790587357332197*z
             + x*(-216.37467504308354246665837480408
             + 101.8233764908628435137215881431*x
             + 610.9402589451770610823295288586*y
             + 203.6467529817256870274431762862*z)
             + y*(-687.30779131332419371762071996591
             + 509.1168824543142175686079407155*y
             + 1018.233764908628435137215881431*z));
          case ( 15 ):
            return -16.431676725154983403709093484024
             + y*(32.863353450309966807418186968048
             - 16.431676725154983403709093484024*y
             - 98.59006035092990042225456090414*z)
             + (98.590060350929900422254560904144
             - 98.59006035092990042225456090414*z)*z
             + x*(164.31676725154983403709093484024
             + z*(-887.3105431583691038002910481373
             + 788.7204828074392033780364872332*z)
             + y*(-295.77018105278970126676368271243
             + 131.45341380123986722967274787219*y
             + 788.7204828074392033780364872332*z)
             + x*(-279.33850432763471786305458922841
             + 131.45341380123986722967274787219*x
             + 262.90682760247973445934549574439*y
             + 788.7204828074392033780364872332*z));
          case ( 16 ):
            return -8.4852813742385702928101323452582
             + y*(127.27922061357855439215198517887
             + y*(-381.83766184073566317645595553662
             + 296.98484809834996024835463208404*y))
             + x*(25.455844122715710878430397035775
             + x*(-25.455844122715710878430397035775
             + 8.485281374238570292810132345258*x
             + 127.27922061357855439215198517887*y)
             + y*(-254.55844122715710878430397035775
             + 381.83766184073566317645595553662*y));
          case ( 17 ):
            return -14.696938456699068589183704448235
             + 29.393876913398137178367408896471*z
             + x*(44.090815370097205767551113344706
             - 58.78775382679627435673481779294*z
             + x*(-44.090815370097205767551113344706
             + 14.696938456699068589183704448235*x
             + 191.06019993708789165938815782706*y
             + 29.393876913398137178367408896471*z)
             + y*(-382.12039987417578331877631565412
             + 484.99896907106926344306224679177*y
             + 352.72652296077764614040890675765*z))
             + y*(191.06019993708789165938815782706
             - 352.72652296077764614040890675765*z
             + y*(-484.99896907106926344306224679177
             + 308.63570759068044037285779341294*y
             + 617.2714151813608807457155868259*z));
          case ( 18 ):
            return -18.973665961010275991993361266596
             + (113.84199576606165595196016759958
             - 113.84199576606165595196016759958*z)*z
             + y*(170.76299364909248392794025139937
             + z*(-910.73596612849324761568134079662
             + 796.893970362431591663721173197*z)
             + y*(-284.60498941515413987990041899894
             + 132.81566172707193194395352886617*y
             + 796.893970362431591663721173197*z))
             + x*(56.920997883030827975980083799789
             + z*(-227.68399153212331190392033519916
             + 113.84199576606165595196016759958*z)
             + x*(-56.920997883030827975980083799789
             + 18.973665961010275991993361266596*x
             + 170.76299364909248392794025139937*y
             + 113.84199576606165595196016759958*z)
             + y*(-341.52598729818496785588050279873
             + 284.60498941515413987990041899894*y
             + 910.7359661284932476156813407966*z));
          case ( 19 ):
            return -22.449944320643648313502492393899
             + z*(269.39933184772377976202990872679
             + z*(-673.49832961930944940507477181698
             + 448.99888641287296627004984787799*z))
             + y*(67.349832961930944940507477181698
             + y*(-67.349832961930944940507477181698
             + 22.449944320643648313502492393899*y
             + 269.39933184772377976202990872679*z)
             + z*(-538.79866369544755952405981745358
             + 673.498329619309449405074771817*z))
             + x*(67.349832961930944940507477181698
             + x*(-67.349832961930944940507477181698
             + 22.449944320643648313502492393899*x
             + 67.3498329619309449405074771817*y
             + 269.39933184772377976202990872679*z)
             + y*(-134.6996659238618898810149543634
             + 67.3498329619309449405074771817*y
             + 538.7986636954475595240598174536*z)
             + z*(-538.79866369544755952405981745358
             + 673.498329619309449405074771817*z));
          #endif
          #if (PMAX3D>=4)
          case ( 20 ):
            return 4.6904157598234295545656301135445
             + x*(-131.33164127505602752783764317925
             + x*(787.98984765033616516702585907547
             + x*(-1575.9796953006723303340517181509
             + 984.9873095629202064587823238443*x)));
          case ( 21 ):
            return 6.6332495807107996982298654733414
             - 19.899748742132399094689596420024*y
             + x*(-165.83123951776999245574663683353
             + 477.59396981117757827255031408058*y
             + x*(875.58894465382556016634224248106
             - 2149.1728641502991022264764133626*y
             + x*(-1512.3809044020623311964093279218
             + 795.989949685295963787583856801*x
             + 2387.9698490558878913627515704029*y)));
          case ( 22 ):
            return 11.489125293076057319701222936438
             - 11.489125293076057319701222936438*y
             - 22.978250586152114639402445872876*z
             + x*(-287.22813232690143299253057341095
             + 275.73900703382537567282935047451*y
             + 551.478014067650751345658700949*z
             + x*(1516.5645386860395662005614276098
             - 1240.8255316522141905277320771353*y
             - 2481.6510633044283810554641542706*z
             + x*(-2619.5205668213410688918788295078
             + 1378.6950351691268783641467523725*x
             + 1378.6950351691268783641467523725*y
             + 2757.3900703382537567282935047451*z)));
          case ( 23 ):
            return 8.124038404635960360459883568266
             + y*(-64.992307237087682883679068546128
             + 81.24038404635960360459883568266*y)
             + x*(-162.48076809271920720919767136532
             + (1234.8538375046659747899023023764
             - 1462.3269128344728648827790422879*y)*y
             + x*(666.17114918014874955771045259782
             + x*(-877.39614770068371892966742537273
             + 365.58172820861821622069476057197*x
             + 2924.6538256689457297655580845758*y)
             + y*(-4094.5153559365240216717813184061
             + 3655.8172820861821622069476057197*y)));
          case ( 24 ):
            return 14.071247279470288663696890340633
             - 28.142494558940577327393780681267*z
             + y*(-84.4274836768217319821813420438
             + 70.35623639735144331848445170317*y
             + 140.71247279470288663696890340633*z)
             + x*(-281.42494558940577327393780681267
             + y*(1604.1221898596129076614454988322
             - 1266.412255152325979732720130657*y
             - 2532.824510304651959465440261314*z)
             + 534.7073966198709692204818329441*z
             + x*(1153.8422769165636704231450079319
             - 1772.9771572132563716258081829198*z
             + x*(-1519.6947061827911756792641567884
             + 633.2061275761629898663600653285*x
             + 3799.236765456977939198160391971*y
             + 1266.412255152325979732720130657*z)
             + y*(-5318.9314716397691148774245487594
             + 3166.0306378808149493318003266425*y
             + 6332.061275761629898663600653285*z)));
          case ( 25 ):
            return 18.165902124584949992535196858309
             + z*(-108.99541274750969995521118114985
             + 108.99541274750969995521118114985*z)
             + y*(-36.331804249169899985070393716618
             + 18.165902124584949992535196858309*y
             + 108.99541274750969995521118114985*z)
             + x*(-363.31804249169899985070393716618
             + y*(690.30428073422809971633748061575
             - 326.98623824252909986563354344956*y
             - 1961.9174294551745991938012606974*z)
             + (2070.9128422026842991490124418472
             - 1961.9174294551745991938012606974*z)*z
             + x*(1489.6039742159658993878861423814
             + z*(-6866.7110030931110971783044124409
             + 4904.7935736379364979845031517435*z)
             + y*(-2288.903667697703699059434804147
             + 817.4655956063227496640838586239*y
             + 4904.7935736379364979845031517435*z)
             + x*(-1961.9174294551745991938012606974
             + 817.4655956063227496640838586239*x
             + 1634.9311912126454993281677172478*y
             + 4904.7935736379364979845031517435*z)));
          case ( 26 ):
            return 9.3808315196468591091312602270889
             + y*(-140.71247279470288663696890340633
             + (422.137418384108659910906710219
             - 328.32910318764006881959410794811*y)*y)
             + x*(-121.95080975540916841870638295216
             + y*(1688.549673536434639643626840876
             + y*(-4643.511602225195259019973812409
             + 3283.2910318764006881959410794811*y))
             + x*(309.56744014834635060133158749393
             + x*(-290.80577710905263238306906703976
             + 93.80831519646859109131260227089*x
             + 1407.1247279470288663696890340633*y)
             + y*(-2954.961928688760619376346971533
             + 4221.37418384108659910906710219*y)));
          case ( 27 ):
            return 16.248076809271920720919767136532
             - 32.496153618543841441839534273064*z
             + y*(-211.22499852053496937195697277492
             + y*(536.18653470597338379035231550556
             - 341.20961299471033513931510986717*y
             - 682.4192259894206702786302197343*z)
             + 389.95384342252609730207441127677*z)
             + x*(-211.22499852053496937195697277492
             + 389.95384342252609730207441127677*z
             + x*(536.18653470597338379035231550556
             - 682.4192259894206702786302197343*z
             + x*(-503.69038108742954234851278123249
             + 162.48076809271920720919767136532*x
             + 2112.2499852053496937195697277492*y
             + 324.96153618543841441839534273064*z)
             + y*(-4435.7249689312343568110964282733
             + 5361.865347059733837903523155056*y
             + 3899.5384342252609730207441127677*z))
             + y*(2534.699982246419632463483673299
             - 4289.4922776477870703228185240445*z
             + y*(-5898.0518817657072216938754705611
             + 3412.0961299471033513931510986717*y
             + 6824.192259894206702786302197343*z)));
          case ( 28 ):
            return 20.976176963403030939829070273599
             + z*(-125.85706178041818563897442164159
             + 125.85706178041818563897442164159*z)
             + y*(-188.78559267062727845846163246239
             + y*(314.64265445104546409743605410398
             - 146.83323874382121657880349191519*y
             - 880.9994324629272994728209514911*z)
             + (1006.8564942433454851117953731327
             - 880.9994324629272994728209514911*z)*z)
             + x*(-272.69030052423940221777791355678
             + (1510.2847413650182276676930596991
             - 1384.4276795846000420287186380575*z)*z
             + y*(2265.4271120475273415015395895487
             + z*(-11075.42143667680033622974910446
             + 8809.994324629272994728209514911*z)
             + y*(-3461.0691989615001050717965951438
             + 1468.3323874382121657880349191519*y
             + 8809.994324629272994728209514911*z))
             + x*(692.21383979230002101435931902876
             + z*(-2642.9982973887818984184628544734
             + 1258.5706178041818563897442164159*z)
             + x*(-650.26148586549395913470117848156
             + 209.76176963403030939829070273599*x
             + 1887.8559267062727845846163246239*y
             + 1258.5706178041818563897442164159*z)
             + y*(-3964.4974460831728476276942817102
             + 3146.4265445104546409743605410398*y
             + 10068.564942433454851117953731327*z)));
          case ( 29 ):
            return 24.819347291981713192266483910899
             + y*(-74.458041875945139576799451732697
             + y*(74.458041875945139576799451732697
             - 24.819347291981713192266483910899*y
             - 297.83216750378055830719780693079*z)
             + (595.66433500756111661439561386157
             - 744.580418759451395767994517327*z)*z)
             + z*(-297.83216750378055830719780693079
             + (744.58041875945139576799451732697
             - 496.38694583963426384532967821798*z)*z)
             + x*(-322.65151479576227149946429084169
             + z*(3573.9860100453666996863736831694
             + z*(-8190.3846063539653534479396905967
             + 4963.8694583963426384532967821798*z))
             + y*(893.49650251134167492159342079236
             + y*(-819.03846063539653534479396905967
             + 248.19347291981713192266483910899*y
             + 2978.3216750378055830719780693079*z)
             + z*(-6552.3076850831722827583517524773
             + 7445.80418759451395767994517327*z))
             + x*(819.03846063539653534479396905967
             + x*(-769.39976605143310896026100123787
             + 248.19347291981713192266483910899*x
             + 744.580418759451395767994517327*y
             + 2978.3216750378055830719780693079*z)
             + y*(-1563.6188793948479311127884863866
             + 744.580418759451395767994517327*y
             + 5956.643350075611166143956138616*z)
             + z*(-6254.4755175793917244511539455465
             + 7445.80418759451395767994517327*z)));
          case ( 30 ):
            return 10.488088481701515469914535136799
             + y*(-251.71412356083637127794884328319
             + y*(1321.4991486943909492092314272367
             + y*(-2349.3318199011394652608558706431
             + 1321.4991486943909492092314272367*y)))
             + x*(-41.952353926806061879658140547198
             + x*(62.928530890209092819487210820796
             + x*(-41.952353926806061879658140547198
             + 10.488088481701515469914535136799*x
             + 251.71412356083637127794884328319*y)
             + y*(-755.14237068250911383384652984956
             + 1321.4991486943909492092314272367*y))
             + y*(755.14237068250911383384652984956
             + y*(-2642.9982973887818984184628544734
             + 2349.3318199011394652608558706431*y)));
          case ( 31 ):
            return 18.165902124584949992535196858309
             - 36.331804249169899985070393716618*z
             + y*(-399.6498467408688998357743308828
             + 762.967889232567899686478268049*z
             + y*(1907.4197230814197492161956701225
             - 3051.8715569302715987459130721959*z
             + y*(-3051.8715569302715987459130721959
             + 1525.935778465135799372956536098*y
             + 3051.8715569302715987459130721959*z)))
             + x*(-72.663608498339799970140787433237
             + 108.99541274750969995521118114985*z
             + x*(108.99541274750969995521118114985
             - 108.99541274750969995521118114985*z
             + x*(-72.663608498339799970140787433237
             + 18.165902124584949992535196858309*x
             + 399.6498467408688998357743308828*y
             + 36.331804249169899985070393716618*z)
             + y*(-1198.9495402226066995073229926484
             + 1907.4197230814197492161956701225*y
             + 762.967889232567899686478268049*z))
             + y*(1198.9495402226066995073229926484
             - 1525.935778465135799372956536098*z
             + y*(-3814.8394461628394984323913402449
             + 3051.8715569302715987459130721959*y
             + 3051.8715569302715987459130721959*z)));
          case ( 32 ):
            return 23.452078799117147772828150567722
             + z*(-140.71247279470288663696890340633
             + 140.71247279470288663696890340633*z)
             + y*(-422.137418384108659910906710219
             + (2392.1120375099490728284713579077
             - 2251.3995647152461861915024545013*z)*z
             + y*(1618.1934371390831963251423891728
             + z*(-7317.0485853245501051223829771294
             + 5065.649020609303918930880522628*z)
             + y*(-2063.7829343223090040088772499596
             + 844.274836768217319821813420438*y
             + 5065.649020609303918930880522628*z)))
             + x*(-93.808315196468591091312602270889
             + (422.137418384108659910906710219
             - 281.42494558940577327393780681267*z)*z
             + x*(140.71247279470288663696890340633
             + z*(-422.137418384108659910906710219
             + 140.71247279470288663696890340633*z)
             + x*(-93.808315196468591091312602270889
             + 23.452078799117147772828150567722*x
             + 422.137418384108659910906710219*y
             + 140.71247279470288663696890340633*z)
             + y*(-1266.412255152325979732720130657
             + 1618.1934371390831963251423891728*y
             + 2392.1120375099490728284713579077*z))
             + y*(1266.412255152325979732720130657
             + z*(-4784.2240750198981456569427158154
             + 2251.3995647152461861915024545013*z)
             + y*(-3236.3868742781663926502847783457
             + 2063.7829343223090040088772499596*y
             + 7317.048585324550105122382977129*z)));
          case ( 33 ):
            return 27.748873851023215893479457892222
             + z*(-332.98648621227859072175349470667
             + (832.46621553069647680438373676667
             - 554.9774770204643178695891578444*z)*z)
             + y*(-332.98648621227859072175349470667
             + z*(3662.8513483350644979392884417734
             + z*(-8324.6621553069647680438373676667
             + 4994.7972931841788608263024206*z))
             + y*(832.46621553069647680438373676667
             + y*(-776.96846782865004501742482098223
             + 249.73986465920894304131512103*y
             + 2996.87837591050731649578145236*z)
             + z*(-6326.7432380332932237133163994267
             + 7492.1959397762682912394536309*z)))
             + x*(-110.99549540409286357391783156889
             + z*(998.95945863683577216526048412001
             + z*(-1664.9324310613929536087674735333
             + 554.9774770204643178695891578444*z))
             + x*(166.49324310613929536087674735333
             + x*(-110.99549540409286357391783156889
             + 27.748873851023215893479457892222*x
             + 332.98648621227859072175349470667*y
             + 332.98648621227859072175349470667*z)
             + z*(-998.95945863683577216526048412001
             + 832.4662155306964768043837367667*z)
             + y*(-998.95945863683577216526048412001
             + 832.4662155306964768043837367667*y
             + 3662.8513483350644979392884417734*z))
             + y*(998.95945863683577216526048412001
             + y*(-1664.9324310613929536087674735333
             + 776.9684678286500450174248209822*y
             + 6326.743238033293223713316399427*z)
             + z*(-7325.7026966701289958785768835467
             + 8324.662155306964768043837367667*z)));
          case ( 34 ):
            return 31.464265445104546409743605410398
             + z*(-629.28530890209092819487210820796
             + z*(2831.7838900594091768769244869358
             + z*(-4404.9971623146364973641047574557
             + 2202.4985811573182486820523787279*z)))
             + y*(-125.85706178041818563897442164159
             + y*(188.78559267062727845846163246239
             + y*(-125.85706178041818563897442164159
             + 31.464265445104546409743605410398*y
             + 629.285308902090928194872108208*z)
             + z*(-1887.8559267062727845846163246239
             + 2831.7838900594091768769244869358*z))
             + z*(1887.8559267062727845846163246239
             + z*(-5663.5677801188183537538489738717
             + 4404.9971623146364973641047574557*z)))
             + x*(-125.85706178041818563897442164159
             + x*(188.78559267062727845846163246239
             + x*(-125.85706178041818563897442164159
             + 31.464265445104546409743605410398*x
             + 125.85706178041818563897442164159*y
             + 629.285308902090928194872108208*z)
             + y*(-377.57118534125455691692326492478
             + 188.78559267062727845846163246239*y
             + 1887.8559267062727845846163246239*z)
             + z*(-1887.8559267062727845846163246239
             + 2831.7838900594091768769244869358*z))
             + z*(1887.8559267062727845846163246239
             + z*(-5663.5677801188183537538489738717
             + 4404.9971623146364973641047574557*z))
             + y*(377.57118534125455691692326492478
             + y*(-377.57118534125455691692326492478
             + 125.85706178041818563897442164159*y
             + 1887.8559267062727845846163246239*z)
             + z*(-3775.7118534125455691692326492478
             + 5663.567780118818353753848973872*z)));
          #endif
          #if (PMAX3D>=5)
          case ( 35 ):
            return -5.0990195135927848300282241090228
             + x*(203.96078054371139320112896436091
             + x*(-1835.6470248934025388101606792482
             + x*(6118.8234163113417960338689308273
             + x*(-8413.3821974280949695465697798876
             + 4038.423454765485585382353494346*x))));
          case ( 36 ):
            return -7.211102550927978586238442534941
             + 21.633307652783935758715327604823*y
             + x*(266.81079438433520769082237379282
             - 778.7990755002216873137517937736*y
             + x*(-2206.5973805839614473889634156919
             + 5840.993066251662654853138453302*y
             + x*(6706.3253723630200852017515574951
             - 14277.983050837397600752116219183*y
             + x*(-8328.8234463218152671054011278568
             + 3569.4957627093494001880290547958*x
             + 10708.487288128048200564087164387*y))));
          case ( 37 ):
            return -12.48999599679679641169378624188
             + 12.48999599679679641169378624188*y
             + 24.979991993593592823387572483759*z
             + x*(462.12985188148146723267009094954
             - 449.63985588468467082097630470767*y
             - 899.2797117693693416419526094153*z
             + x*(-3821.9387750198197019782985900152
             + 3372.2989191351350311573222853075*y
             + 6744.597838270270062314644570615*z
             + x*(11615.696277021020662875221204948
             - 8243.397357885885631717898919641*y
             - 16486.794715771771263435797839281*z
             + x*(-14425.945376300299855506323109371
             + 6182.54801841441422378842418973*x
             + 6182.54801841441422378842418973*y
             + 12365.096036828828447576848379461*z))));
          case ( 38 ):
            return -8.8317608663278468547640427269593
             + (70.654086930622774838112341815674
             - 88.31760866327846854764042726959*y)*y
             + x*(282.6163477224910993524493672627
             + y*(-2190.2766948493060199814825962859
             + 2649.5282598983540564292128180878*y)
             + x*(-1995.9779557900933891766736562928
             + (13777.546951471441093431906654056
             - 14572.405429440947310360670499483*y)*y
             + x*(5122.4213024701511757631447816364
             + x*(-5343.2153241283473471322458498103
             + 1942.987390592126308048089399931*x
             + 15543.899124737010464384715199448*y)
             + y*(-27201.823468289768312673251599035
             + 19429.87390592126308048089399931*y))));
          case ( 39 ):
            return -15.297058540778354490084672327068
             + y*(91.78235124467012694050803396241
             - 76.48529270389177245042336163534*y
             - 152.97058540778354490084672327068*z)
             + 30.594117081556708980169344654137*z
             + x*(489.50587330490734368270951446619
             - 948.4176295282579783852496842782*z
             + y*(-2845.2528885847739351557490528347
             + 2294.5587811167531735127008490603*y
             + 4589.1175622335063470254016981205*z)
             + x*(-3457.1352302159081147591359459174
             + y*(17897.55849271067475339906662267
             - 12620.073296142142454319854669831*y
             - 25240.146592284284908639709339663*z)
             + 5965.852830903558251133022207557*z
             + x*(8872.2939536514456042491099496996
             - 11778.735076399332957365197691843*z
             + x*(-9254.7204171709044665012267578763
             + 3365.352878971237987818627911955*x
             + 20192.11727382742792691176747173*y
             + 6730.70575794247597563725582391*z)
             + y*(-35336.205229197998872095593075528
             + 16826.764394856189939093139559775*y
             + 33653.52878971237987818627911955*z))));
          case ( 40 ):
            return -19.748417658131499017438461043723
             + y*(39.496835316262998034876922087446
             - 19.748417658131499017438461043723*y
             - 118.49050594878899410463076626234*z)
             + (118.49050594878899410463076626234
             - 118.49050594878899410463076626234*z)*z
             + x*(631.94936506020796855803075339914
             + z*(-3673.2056844124588172435537541325
             + 3554.7151784636698231389229878702*z)
             + y*(-1224.4018948041529390811845847108
             + 592.4525297439449705231538313117*y
             + 3554.7151784636698231389229878702*z)
             + x*(-4463.1423907377187779410921958814
             + y*(7701.882886671284616800999807052
             - 3258.4889135916973378773460722143*y
             - 19550.933481550184027264076433286*z)
             + (23105.648660013853850402999421156
             - 19550.933481550184027264076433286*z)*z
             + x*(11454.082241716269430114307405359
             + z*(-45618.844790283762730282845011
             + 26067.911308733578703018768577714*z)
             + y*(-15206.281596761254243427615003667
             + 4344.6518847889297838364614296191*y
             + 26067.911308733578703018768577714*z)
             + x*(-11947.792683169556905550268931452
             + 4344.6518847889297838364614296191*x
             + 8689.303769577859567672922859238*y
             + 26067.911308733578703018768577714*z))));
          case ( 41 ):
            return -10.198039027185569660056448218046
             + y*(152.97058540778354490084672327068
             + y*(-458.91175622335063470254016981205
             + 356.93136595149493810197568763159*y))
             + x*(254.95097567963924150141120545114
             + y*(-3671.2940497868050776203213584964
             + (10554.970393137064598158423905677
             - 7852.490050932888638243465127895*y)*y)
             + x*(-1376.7352686700519041076205094362
             + y*(16979.734980263973483993986283046
             + y*(-40384.23454765485585382353494346
             + 23557.470152798665914730395383685*y))
             + x*(2702.4803422041759599149587777821
             + x*(-2243.56858598082532521241860797
             + 673.070575794247597563725582391*x
             + 10096.058636913713963455883735865*y)
             + y*(-23557.470152798665914730395383685
             + 30288.175910741141890367651207595*y))));
          case ( 42 ):
            return -17.663521732655693709528085453919
             + 35.327043465311387419056170907837*z
             + y*(229.62578252452401822386511090094
             - 423.92452158373664902867405089404*z
             + y*(-582.89621717763789241442681997931
             + 370.93395638576956790008979453229*y
             + 741.8679127715391358001795890646*z))
             + x*(441.58804331639234273820213634796
             - 847.8490431674732980573481017881*z
             + y*(-5511.0187805885764373727626616226
             + y*(13406.612995085671525531816859524
             - 8160.54704048693049380197547971*y
             - 16321.094080973860987603950959421*z)
             + 9750.263996425942927659503170563*z)
             + x*(-2384.575433908518650786291536279
             + 3921.3018246495640035152349707699*z
             + x*(4680.8332591537588330249426452884
             - 5440.364693657953662534650319807*z
             + x*(-3885.9747811842526160961787998621
             + 1165.7924343552757848288536399586*x
             + 15155.301646618585202775097319462*y
             + 2331.5848687105515696577072799172*z)
             + y*(-35362.370508776698806475227078745
             + 38471.150333724100899352170118635*y
             + 27979.018424526618835892487359007*z))
             + y*(25488.461860222166022849027310004
             - 37305.357899368825114523316478676*z
             + y*(-51294.867111632134532469560158179
             + 24481.641121460791481405926439131*y
             + 48963.282242921582962811852878262*z))));
          case ( 43 ):
            return -22.803508501982759582720980511335
             + (136.82105101189655749632588306801
             - 136.82105101189655749632588306801*z)*z
             + y*(205.23157651784483624448882460202
             + z*(-1094.5684080951724599706070645441
             + 957.7473570832759024742811814761*z)
             + y*(-342.05262752974139374081470767003
             + 159.62455951387931707904686357935*y
             + 957.7473570832759024742811814761*z))
             + x*(570.08771254956898956802451278338
             + z*(-3283.7052242855173799118211936323
             + 3146.8841732736208224154953105642*z)
             + y*(-4925.5578364282760698677317904484
             + y*(7867.2104331840520560387382764106
             - 3511.7403093053449757390309987456*y
             - 21070.441855832069854434185992474*z)
             + (25175.073386188966579323962484514
             - 21070.441855832069854434185992474*z)*z)
             + x*(-3078.4736477676725436673323690302
             + (15187.136662320517882092173020549
             - 12040.252489046897059676677709985*z)*z
             + y*(22780.704993480776823138259530824
             + z*(-96322.019912375176477413421679879
             + 63211.32556749620956330255797742*z)
             + y*(-30100.631222617242649191694274962
             + 10535.220927916034927217092996237*y
             + 63211.32556749620956330255797742*z))
             + x*(6042.9297530254312894210598355038
             + z*(-21070.441855832069854434185992474
             + 9030.189366785172794757508282489*z)
             + x*(-5016.7718704362071081986157124937
             + 1505.0315611308621324595847137481*x
             + 13545.284050177759192136262423733*y
             + 9030.189366785172794757508282489*z)
             + y*(-31605.66278374810478165127898871
             + 22575.473416962931986893770706222*y
             + 72241.51493428138235806006625991*z))));
          case ( 44 ):
            return -26.981475126464082931100611222991
             + z*(323.77770151756899517320733467589
             + z*(-809.44425379392248793301833668973
             + 539.6295025292816586220122244598*z))
             + y*(80.944425379392248793301833668973
             + y*(-80.944425379392248793301833668973
             + 26.981475126464082931100611222991*y
             + 323.77770151756899517320733467589*z)
             + z*(-647.55540303513799034641466935179
             + 809.4442537939224879330183366897*z))
             + x*(674.53687816160207327751528057478
             + y*(-1942.6662091054139710392440080554
             + y*(1861.7217837260217222459421743864
             - 593.5924527822098244842134469058*y
             - 7123.10943338651789381056136287*z)
             + (14893.774269808173777967537395091
             - 17807.773583466294734526403407174*z)*z)
             + z*(-7770.6648364216558841569760322214
             + (18617.217837260217222459421743864
             - 11871.849055644196489684268938116*z)*z)
             + x*(-3642.4991420726511956985825151038
             + z*(35939.324868450158464226014149024
             + z*(-71231.094333865178938105613628696
             + 35615.547166932589469052806814348*z))
             + y*(8984.831217112539616056503537256
             + y*(-7123.1094333865178938105613628696
             + 1780.7773583466294734526403407174*y
             + 21369.328300159553681431684088609*z)
             + z*(-56984.875467092143150484490902957
             + 53423.32075039888420357921022152*z))
             + x*(7150.0909085129819767416619740926
             + x*(-5935.924527822098244842134469058
             + 1780.7773583466294734526403407174*x
             + 5342.332075039888420357921022152*y
             + 21369.328300159553681431684088609*z)
             + y*(-12465.441508426406314168482385022
             + 5342.332075039888420357921022152*y
             + 42738.656600319107362863368177218*z)
             + z*(-49861.766033705625256673929540088
             + 53423.32075039888420357921022152*z))));
          case ( 45 ):
            return -11.401754250991379791360490255668
             + y*(273.64210202379311499265176613602
             + y*(-1436.6210356249138537114217722141
             + (2553.9929522220690732647498172695
             - 1436.6210356249138537114217722141*y)*y))
             + x*(182.42806801586207666176784409068
             + y*(-4104.6315303568967248897764920403
             + y*(20112.694498748793951959904810998
             + y*(-33201.908378886897952441747624504
             + 17239.452427498966244537061266569*y)))
             + x*(-615.69472955353450873346647380605
             + x*(866.53332307534486414339725943073
             + x*(-558.68595829857760977666402252771
             + 136.82105101189655749632588306801*x
             + 3283.7052242855173799118211936323*y)
             + y*(-10124.757774880345254728115347033
             + 17239.452427498966244537061266569*y))
             + y*(10672.041978927931484713418879305
             + y*(-35915.525890622846342785544305353
             + 30647.915426664828879176997807234*y))));
          case ( 46 ):
            return -19.748417658131499017438461043723
             + 39.496835316262998034876922087446*z
             + y*(434.46518847889297838364614296191
             - 829.4335416415229587324153638364*z
             + y*(-2073.5838541038073968310384095909
             + y*(3317.7341665660918349296614553455
             - 1658.8670832830459174648307276727*y
             - 3317.7341665660918349296614553455*z)
             + 3317.7341665660918349296614553455*z))
             + x*(315.97468253010398427901537669957
             - 592.4525297439449705231538313117*z
             + y*(-6516.9778271833946757546921444286
             + 11612.069582981321422253815093709*z
             + y*(29030.173957453303555634537734273
             - 43130.544165359193854085598919491*z
             + y*(-43130.544165359193854085598919491
             + 19906.404999396551009577968732073*y
             + 39812.809998793102019155937464146*z)))
             + x*(-1066.414553539100946941676896361
             + 1540.3765773342569233601999614104*z
             + x*(1500.879742017993925325323039323
             - 1461.3829067017309272904461172355*z
             + x*(-967.67246524844345185448459114243
             + 236.98101189757798820926153252468*x
             + 5213.582261746715740603753715543*y
             + 473.96202379515597641852306504935*z)
             + y*(-16075.211973719040200194907289591
             + 24883.006249245688761972460915091*y
             + 9953.202499698275504788984366036*z))
             + y*(16944.142350676826156962199575514
             - 20735.838541038073968310384095909*z
             + y*(-51839.596352595184920775960239773
             + 39812.809998793102019155937464146*y
             + 39812.809998793102019155937464146*z))));
          case ( 47 ):
            return -25.495097567963924150141120545114
             + (152.97058540778354490084672327068
             - 152.97058540778354490084672327068*z)*z
             + y*(458.91175622335063470254016981205
             + z*(-2600.4999519323202633143942956016
             + 2447.5293665245367184135475723309*z)
             + y*(-1759.1617321895107663597373176129
             + y*(2243.56858598082532521241860797
             - 917.8235124467012694050803396241*y
             - 5506.941074680207616430482037745*z)
             + (7954.4704412047443348440296100755
             - 5506.941074680207616430482037745*z)*z))
             + x*(407.92156108742278640225792872182
             + z*(-2294.5587811167531735127008490603
             + 2141.5881957089696286118541257896*z)
             + y*(-6883.6763433502595205381025471808
             + (36406.999327052483686401520138423
             - 31817.881764818977339376118440302*z)*z
             + y*(24628.26425065315072903632244658
             + z*(-103408.11573566167635297238493098
             + 66083.29289616249139716578445294*z)
             + y*(-29166.39161775072922776144190361
             + 11013.882149360415232860964075489*y
             + 66083.29289616249139716578445294*z)))
             + x*(-1376.7352686700519041076205094362
             + (5965.8528309035582511330222075567
             - 3824.2646351945886225211680817671*z)*z
             + x*(1937.6274151652582354107251614287
             + z*(-5659.9116600879911613313287610153
             + 1835.6470248934025388101606792482*z)
             + x*(-1249.2597808302322833569149067106
             + 305.94117081556708980169344654137*x
             + 5506.941074680207616430482037745*y
             + 1835.6470248934025388101606792482*z)
             + y*(-16979.734980263973483993986283046
             + 21109.940786274129196316847811354*y
             + 31205.999423187843159772731547219*z))
             + y*(17897.55849271067475339906662267
             + z*(-65012.49879830800658285985739004
             + 29370.352398294440620962570867971*z)
             + y*(-43979.043304737769158993432940321
             + 26922.82303176990390254902329564*y
             + 95453.64529445693201812835532091*z))));
          case ( 48 ):
            return -30.166206257996712172516764424594
             + z*(361.99447509596054607020117309513
             + z*(-904.98618773990136517550293273782
             + 603.3241251599342434503352884919*z))
             + y*(361.99447509596054607020117309513
             + y*(-904.98618773990136517550293273782
             + y*(844.65377522390794083046940388863
             - 271.49585632197040955265087982134*y
             - 3257.9502758636449146318105578561*z)
             + (6877.8950268232503753338222888074
             - 8144.87568965911228657952639464*z)*z)
             + z*(-3981.9392260555660067722129040464
             + (9049.8618773990136517550293273782
             - 5429.917126439408191053017596427*z)*z))
             + x*(482.6593001279473947602682307935
             + z*(-5429.9171264394081910530175964269
             + (12669.806628358619112457041058329
             - 7843.213627079145164854358750394*z)*z)
             + y*(-5429.9171264394081910530175964269
             + z*(55747.149164777924094810980656649
             + z*(-117648.20440618717747281538125592
             + 65159.00551727289829263621115712*z))
             + y*(12669.806628358619112457041058329
             + y*(-10980.499077910803230796102250552
             + 3257.9502758636449146318105578561*y
             + 39095.403310363738975581726694274*z)
             + z*(-89412.635348702254879339689754496
             + 97738.50827590934743895431673568*z)))
             + x*(-1628.9751379318224573159052789281
             + z*(14117.78452874246129673784575071
             + z*(-22624.654693497534129387573318445
             + 7239.889501919210921404023461903*z))
             + x*(2292.6316756077501251112740962691
             + x*(-1478.1441066418388964533214568051
             + 361.99447509596054607020117309513*x
             + 4343.9337011515265528424140771415*y
             + 4343.9337011515265528424140771415*z)
             + z*(-13393.79557855054020459744340452
             + 10859.834252878816382106035192854*z)
             + y*(-13393.79557855054020459744340452
             + 10859.834252878816382106035192854*y
             + 47783.270712666792081266554848557*z))
             + y*(14117.78452874246129673784575071
             + y*(-22624.654693497534129387573318445
             + 10135.845302686895289965632846664*y
             + 82534.74032187900450400586746569*z)
             + z*(-99548.48065138915016930532260116
             + 108598.34252878816382106035192854*z))));
          case ( 49 ):
            return -34.205262752974139374081470767003
             + y*(136.82105101189655749632588306801
             + z*(-2052.3157651784483624448882460202
             + (6156.9472955353450873346647380605
             - 4788.7367854163795123714059073804*z)*z)
             + y*(-205.23157651784483624448882460202
             + y*(136.82105101189655749632588306801
             - 34.205262752974139374081470767003*y
             - 684.1052550594827874816294153401*z)
             + (2052.3157651784483624448882460202
             - 3078.4736477676725436673323690302*z)*z))
             + z*(684.10525505948278748162941534005
             + z*(-3078.4736477676725436673323690302
             + (4788.7367854163795123714059073804
             - 2394.3683927081897561857029536902*z)*z))
             + x*(547.28420404758622998530353227204
             + z*(-10261.578825892241812224441230101
             + z*(43098.631068747415611342653166423
             + z*(-62253.578210412933660828276795945
             + 28732.420712498277074228435444282*z)))
             + y*(-2052.3157651784483624448882460202
             + y*(2873.2420712498277074228435444282
             + y*(-1778.6736631546552474522364798841
             + 410.46315303568967248897764920403*y
             + 8209.263060713793449779552984081*z)
             + z*(-26680.104947319828711783547198262
             + 36941.683773212070524007988428363*z))
             + z*(28732.420712498277074228435444282
             + z*(-80040.314841959486135350641594786
             + 57464.84142499655414845687088856*z)))
             + x*(-1847.0841886606035262003994214181
             + x*(2599.5999692260345924301917782922
             + x*(-1676.0578748957328293299920675831
             + 410.46315303568967248897764920403*x
             + 1641.8526121427586899559105968161*y
             + 8209.263060713793449779552984081*z)
             + y*(-5062.3788874401726273640576735164
             + 2462.7789182141380349338658952242*y
             + 24627.789182141380349338658952242*z)
             + z*(-25311.894437200863136820288367582
             + 36941.683773212070524007988428363*z))
             + z*(26680.104947319828711783547198262
             + z*(-76961.841194191813591683309225756
             + 57464.84142499655414845687088856*z))
             + y*(5336.0209894639657423567094396524
             + y*(-5130.7894129461209061122206150504
             + 1641.8526121427586899559105968161*y
             + 24627.789182141380349338658952242*z)
             + z*(-51307.894129461209061122206150504
             + 73883.36754642414104801597685673*z))));
          case ( 50 ):
            return -12.48999599679679641169378624188
             + y*(437.14985988788787440928251846579
             + y*(-3497.1988791031029952742601477263
             + y*(10491.596637309308985822780443179
             + y*(-13114.495796636636232278475553974
             + 5770.378150520119942202529243748*y))))
             + x*(62.449979983983982058468931209398
             + x*(-124.8999599679679641169378624188
             + x*(124.8999599679679641169378624188
             + x*(-62.449979983983982058468931209398
             + 12.48999599679679641169378624188*x
             + 437.14985988788787440928251846579*y)
             + y*(-1748.5994395515514976371300738631
             + 3497.1988791031029952742601477263*y))
             + y*(2622.8991593273272464556951107947
             + y*(-10491.596637309308985822780443179
             + 10491.596637309308985822780443179*y)))
             + y*(-1748.5994395515514976371300738631
             + y*(10491.596637309308985822780443179
             + y*(-20983.193274618617971645560886358
             + 13114.495796636636232278475553974*y))));
          case ( 51 ):
            return -21.633307652783935758715327604823
             + 43.266615305567871517430655209646*z
             + y*(713.89915254186988003760581095916
             - 1384.5316897781718885577809667087*z
             + y*(-5365.0602978904160681614012459961
             + 9345.588906002660247765021525284*z
             + y*(15056.782126337619288065868012957
             - 20767.97534667257832836671450063*z
             + y*(-17522.979198754987964559415359907
             + 7138.991525418698800376058109592*y
             + 14277.983050837397600752116219183*z))))
             + x*(108.16653826391967879357663802411
             - 173.06646122227148606972262083858*z
             + x*(-216.33307652783935758715327604823
             + 259.59969183340722910458393125788*z
             + x*(216.33307652783935758715327604823
             - 173.06646122227148606972262083858*z
             + x*(-108.16653826391967879357663802411
             + 21.633307652783935758715327604823*x
             + 713.8991525418698800376058109592*y
             + 43.266615305567871517430655209646*z)
             + y*(-2855.5966101674795201504232438366
             + 5365.060297890416068161401245996*y
             + 1384.5316897781718885577809667087*z))
             + y*(4283.3949152512192802256348657549
             - 4153.595069334515665673342900126*z
             + y*(-16095.180893671248204484203737988
             + 15056.782126337619288065868012957*y
             + 9345.588906002660247765021525284*z)))
             + y*(-2855.5966101674795201504232438366
             + 4153.595069334515665673342900126*z
             + y*(16095.180893671248204484203737988
             - 18691.177812005320495530043050567*z
             + y*(-30113.564252675238576131736025914
             + 17522.979198754987964559415359907*y
             + 20767.97534667257832836671450063*z))));
          case ( 52 ):
            return -27.928480087537882339767849082173
             + (167.57088052522729403860709449304
             - 167.57088052522729403860709449304*z)*z
             + y*(809.92592253859858785326762338301
             + z*(-4691.984654706364233080998645805
             + 4524.413774181136939042391551312*z)
             + y*(-5306.4112166321976445558913256128
             + (27146.482645086821634254349307872
             - 22622.06887090568469521195775656*z)*z
             + y*(12902.957800442501640972746275964
             + z*(-50271.264157568188211582128347911
             + 27649.195286662503516370170591351*z)
             + y*(-12986.74324070511528799204982321
             + 4608.1992144437505860616950985585*y
             + 27649.195286662503516370170591351*z))))
             + x*(139.64240043768941169883924541086
             + z*(-670.28352210090917615442837797215
             + 502.7126415756818821158212834791*z)
             + x*(-279.28480087537882339767849082173
             + (1005.4252831513637642316425669582
             - 502.7126415756818821158212834791*z)*z
             + x*(279.28480087537882339767849082173
             + z*(-670.28352210090917615442837797215
             + 167.57088052522729403860709449304*z)
             + x*(-139.64240043768941169883924541086
             + 27.928480087537882339767849082173*x
             + 809.925922538598587853267623383*y
             + 167.57088052522729403860709449304*z)
             + y*(-3239.703690154394351413070493532
             + 5306.411216632197644555891325613*y
             + 4691.984654706364233080998645805*z))
             + y*(4859.5555352315915271196057402981
             + z*(-14075.953964119092699242995937415
             + 4524.413774181136939042391551312*z)
             + y*(-15919.233649896592933667673976838
             + 12902.957800442501640972746275964*y
             + 27146.482645086821634254349307872*z)))
             + y*(-3239.703690154394351413070493532
             + (14075.953964119092699242995937415
             - 9048.827548362273878084783102624*z)*z
             + y*(15919.233649896592933667673976838
             + z*(-54292.965290173643268508698615744
             + 22622.06887090568469521195775656*z)
             + y*(-25805.915600885003281945492551928
             + 12986.74324070511528799204982321*y
             + 50271.26415756818821158212834791*z))));
          case ( 53 ):
            return -33.045423283716612123634852625232
             + z*(396.54507940459934548361823150279
             + z*(-991.36269851149836370904557875697
             + 660.9084656743322424726970525046*z))
             + y*(760.04473552548207884360161038035
             + z*(-8723.9917469011856006396010930614
             + (20818.616668741465637889957153896
             - 13218.169313486644849453941050093*z)*z)
             + y*(-3899.3599474785602305889126097774
             + z*(38068.327622841537166427350224268
             + z*(-74352.202388362377278178418406773
             + 36349.965612088273335998337887756*z))
             + y*(7468.2656621199543399414766933025
             + y*(-6113.403307487573242872447735668
             + 1817.4982806044136667999168943878*y
             + 21809.979367252964001599002732653*z)
             + z*(-51550.860322597914912870370095363
             + 54524.94841813241000399750683163*z))))
             + x*(165.22711641858306061817426312616
             + z*(-1586.1803176183973819344729260112
             + (2974.0880955344950911271367362709
             - 1321.8169313486644849453941050093*z)*z)
             + x*(-330.45423283716612123634852625232
             + z*(2379.2704764275960729017093890167
             + z*(-2974.0880955344950911271367362709
             + 660.9084656743322424726970525046*z))
             + x*(330.45423283716612123634852625232
             + x*(-165.22711641858306061817426312616
             + 33.045423283716612123634852625232*x
             + 760.0447355254820788436016103803*y
             + 396.54507940459934548361823150279*z)
             + z*(-1586.1803176183973819344729260112
             + 991.362698511498363709045578757*z)
             + y*(-3040.1789421019283153744064415214
             + 3899.3599474785602305889126097774*y
             + 8723.991746901185600639601093061*z))
             + y*(4560.2684131528924730616096622821
             + z*(-26171.975240703556801918803279184
             + 20818.616668741465637889957153896*z)
             + y*(-11698.079842435680691766737829332
             + 7468.265662119954339941476693303*y
             + 38068.327622841537166427350224268*z)))
             + y*(-3040.1789421019283153744064415214
             + z*(26171.975240703556801918803279184
             + z*(-41637.233337482931275779914307793
             + 13218.169313486644849453941050093*z))
             + y*(11698.079842435680691766737829332
             + y*(-14936.531324239908679882953386605
             + 6113.403307487573242872447735668*y
             + 51550.86032259791491287037009536*z)
             + z*(-76136.655245683074332854700448536
             + 74352.20238836237727817841840677*z))));
          case ( 54 ):
            return -37.469987990390389235081358725639
             + z*(749.39975980780778470162717451278
             + z*(-3372.2989191351350311573222853075
             + (5245.7983186546544929113902215894
             - 2622.8991593273272464556951107947*z)*z))
             + y*(562.04981985585583852622038088458
             + z*(-10491.596637309308985822780443179
             + z*(43839.885948756755405045189708997
             + z*(-62949.579823855853914936682659073
             + 28851.890752600599711012646218742*z)))
             + y*(-1873.4993995195194617540679362819
             + y*(2622.8991593273272464556951107947
             + y*(-1686.1494595675675155786611426537
             + 412.16986789429428158589494598203*y
             + 8243.397357885885631717898919641*z)
             + z*(-25479.591833465464679855323933434
             + 37095.288110486485342730545138382*z))
             + z*(26978.39135308108024925857828246
             + z*(-77562.875140108105716618412562072
             + 57703.78150520119942202529243748*z))))
             + x*(187.34993995195194617540679362819
             + z*(-2997.5990392312311388065086980511
             + z*(10116.896757405405093471966855922
             + z*(-10491.596637309308985822780443179
             + 2622.8991593273272464556951107947*z)))
             + x*(-374.69987990390389235081358725639
             + z*(4496.3985588468467082097630470767
             + z*(-10116.896757405405093471966855922
             + 5245.798318654654492911390221589*z))
             + x*(374.69987990390389235081358725639
             + x*(-187.34993995195194617540679362819
             + 37.469987990390389235081358725639*x
             + 562.0498198558558385262203808846*y
             + 749.3997598078077847016271745128*z)
             + z*(-2997.5990392312311388065086980511
             + 3372.2989191351350311573222853075*z)
             + y*(-2248.1992794234233541048815235383
             + 1873.4993995195194617540679362819*y
             + 10491.596637309308985822780443179*z))
             + y*(3372.2989191351350311573222853075
             + y*(-5620.4981985585583852622038088458
             + 2622.8991593273272464556951107947*y
             + 26978.39135308108024925857828246*z)
             + z*(-31474.789911927926957468341329537
             + 43839.885948756755405045189708997*z)))
             + y*(-2248.1992794234233541048815235383
             + z*(31474.789911927926957468341329537
             + z*(-87679.771897513510810090379417995
             + 62949.57982385585391493668265907*z))
             + y*(5620.4981985585583852622038088458
             + y*(-5245.7983186546544929113902215894
             + 1686.1494595675675155786611426537*y
             + 25479.591833465464679855323933434*z)
             + z*(-53956.78270616216049851715656492
             + 77562.87514010810571661841256207*z))));
          case ( 55 ):
            return -41.424630354415958264314352688096
             + z*(1242.7389106324787479294305806429
             + z*(-8699.1723744273512355060140645002
             + z*(23197.792998472936628016037505334
             + z*(-26097.517123282053706518042193501
             + 10439.0068493128214826072168774*z))))
             + y*(207.12315177207979132157176344048
             + y*(-414.24630354415958264314352688096
             + y*(414.24630354415958264314352688096
             + y*(-207.12315177207979132157176344048
             + 41.424630354415958264314352688096*y
             + 1242.7389106324787479294305806429*z)
             + z*(-4970.9556425299149917177223225716
             + 8699.1723744273512355060140645*z))
             + z*(7456.4334637948724875765834838573
             + z*(-26097.517123282053706518042193501
             + 23197.792998472936628016037505334*z)))
             + z*(-4970.9556425299149917177223225716
             + z*(26097.517123282053706518042193501
             + z*(-46395.585996945873256032075010668
             + 26097.517123282053706518042193501*z))))
             + x*(207.12315177207979132157176344048
             + z*(-4970.9556425299149917177223225716
             + z*(26097.517123282053706518042193501
             + z*(-46395.585996945873256032075010668
             + 26097.517123282053706518042193501*z)))
             + x*(-414.24630354415958264314352688096
             + x*(414.24630354415958264314352688096
             + x*(-207.12315177207979132157176344048
             + 41.424630354415958264314352688096*x
             + 207.12315177207979132157176344048*y
             + 1242.7389106324787479294305806429*z)
             + y*(-828.49260708831916528628705376193
             + 414.24630354415958264314352688096*y
             + 4970.9556425299149917177223225716*z)
             + z*(-4970.9556425299149917177223225716
             + 8699.1723744273512355060140645*z))
             + z*(7456.4334637948724875765834838573
             + z*(-26097.517123282053706518042193501
             + 23197.792998472936628016037505334*z))
             + y*(1242.7389106324787479294305806429
             + y*(-1242.7389106324787479294305806429
             + 414.24630354415958264314352688096*y
             + 7456.433463794872487576583483857*z)
             + z*(-14912.866927589744975153166967715
             + 26097.517123282053706518042193501*z)))
             + y*(-828.49260708831916528628705376193
             + y*(1242.7389106324787479294305806429
             + y*(-828.49260708831916528628705376193
             + 207.12315177207979132157176344048*y
             + 4970.9556425299149917177223225716*z)
             + z*(-14912.866927589744975153166967715
             + 26097.517123282053706518042193501*z))
             + z*(14912.866927589744975153166967715
             + z*(-52195.034246564107413036084387001
             + 46395.585996945873256032075010668*z))));
          #endif
          #if (PMAX3D>=6)
          case ( 56 ):
            return 5.477225575051661134569697828008
             + x*(-295.77018105278970126676368271243
             + x*(3697.1272631598712658345460339054
             + x*(-18074.844397670481744080002832426
             + x*(40668.39989475858392418000637296
             + x*(-42295.135890548927281147206627878
             + 16448.108401880138387112802577508*x)))));
          case ( 57 ):
            return 7.7459666924148337703585307995648
             - 23.237900077244501311075592398694*y
             + x*(-395.0443013131565222882850707778
             + 1161.8950038622250655537796199347*y
             + x*(4647.5800154489002622151184797389
             - 12780.845042484475721091575819282*y
             + x*(-21301.408404140792868485959698803
             + 51123.38016993790288436630327713*y
             + x*(44732.957648695665023820515367487
             - 83075.49277614909218709524282533*y
             + x*(-43199.256243597527937289526269173
             + 15507.425318214497208257778660729*x
             + 46522.275954643491624773335982186*y)))));
          case ( 58 ):
            return 13.416407864998738178455042012388
             - 13.416407864998738178455042012388*y
             - 26.832815729997476356910084024775*z
             + x*(-684.23680111493564710120714263177
             + 670.8203932499369089227521006194*y
             + 1341.6407864998738178455042012388*z
             + x*(8049.8447189992429070730252074326
             - 7379.024325749305998150273106813*y
             - 14758.048651498611996300546213626*z
             + x*(-36895.121628746529990751365534066
             + 29516.097302997223992601092427253*y
             + 59032.19460599444798520218485451*z
             + x*(77479.755420367712980577867621539
             - 47963.658117370488987976775194286*y
             - 95927.31623474097797595355038857*z
             + x*(-74823.306663097962821243769303086
             + 26859.6485457274738332669941088*x
             + 26859.6485457274738332669941088*y
             + 53719.2970914549476665339882176*z)))));
          case ( 59 ):
            return 9.4868329805051379959966806332982
             + y*(-75.894663844041103967973445066385
             + 94.86832980505137995996680633298*y)
             + x*(-436.39431710323634781584730913172
             + (3415.2598729818496785588050279873
             - 4174.2065114222607182385394786512*y)*y
             + x*(4601.1139955449919280583901071496
             + y*(-33393.65209137808574590831582921
             + 37567.858602800346464146855307861*y)
             + x*(-18783.92930140017323207342765393
             + (116877.78231982330011067910540223
             - 108529.36929697877867420202644493*y)*y
             + x*(34958.979533161433515247768133704
             + x*(-29845.576556669164135405557272356
             + 9496.319813485643133992677313931*x
             + 75970.55850788514507194141851145*y)
             + y*(-162794.0539454681680113030396674
             + 94963.19813485643133992677313931*y)))));
          case ( 60 ):
            return 16.431676725154983403709093484024
             - 32.863353450309966807418186968048*z
             + y*(-98.590060350929900422254560904144
             + 82.15838362577491701854546742012*y
             + 164.31676725154983403709093484024*z)
             + x*(-755.85712935712923657061830026511
             + y*(4436.5527157918455190014552406865
             - 3614.9688795340963488160005664853*y
             - 7229.937759068192697632001132971*z)
             + 1478.8509052639485063338184135622*z
             + x*(7969.3632117001669507989103397517
             - 14459.875518136385395264002265941*z
             + y*(-43379.626554409156185792006797824
             + 32534.719915806867139344005098368*y
             + 65069.43983161373427868801019674*z)
             + x*(-32534.719915806867139344005098368
             + y*(151828.69294043204665027202379238
             - 93989.19086788650506921601472862*y
             - 187978.38173577301013843202945724*z)
             + 50609.56431347734888342400793079*z
             + x*(60550.728732196113842668009488629
             - 70491.89315091487880191201104646*z
             + x*(-51694.05497733757778806880810074
             + 16448.108401880138387112802577508*x
             + 98688.65041128083032267681546505*y
             + 32896.216803760276774225605155016*z)
             + y*(-211475.67945274463640573603313939
             + 82240.54200940069193556401288754*y
             + 164481.08401880138387112802577508*z)))));
          case ( 61 ):
            return 21.213203435596425732025330863145
             + z*(-127.27922061357855439215198517887
             + 127.27922061357855439215198517887*z)
             + y*(-42.426406871192851464050661726291
             + 21.213203435596425732025330863145*y
             + 127.27922061357855439215198517887*z)
             + x*(-975.80735803743558367316521970469
             + y*(1909.1883092036783158822797776831
             - 933.3809511662427322091145579784*y
             - 5600.28570699745639325468734787*z)
             + (5727.5649276110349476468393330493
             - 5600.28570699745639325468734787*z)*z
             + x*(10288.403666264266480032285468626
             + z*(-56002.857069974563932546873478704
             + 50402.57136297710753929218613083*z)
             + y*(-18667.619023324854644182291159568
             + 8400.428560496184589882031021806*y
             + 50402.57136297710753929218613083*z)
             + x*(-42002.142802480922949410155109028
             + y*(65336.666581636991254638019058488
             - 24267.904730322311037436978507438*y
             - 145607.42838193386622462187104463*z)
             + (196009.99974491097376391405717546
             - 145607.42838193386622462187104463*z)*z
             + x*(78170.654660172828822513344230691
             + z*(-273013.92821612599917116600820868
             + 127406.49983419213294654413716405*z)
             + y*(-91004.642738708666390388669402894
             + 21234.416639032022157757356194009*y
             + 127406.49983419213294654413716405*z)
             + x*(-66736.738008386355352951690895456
             + 21234.416639032022157757356194009*x
             + 42468.833278064044315514712388017*y
             + 127406.49983419213294654413716405*z)))));
          case ( 62 ):
            return 10.954451150103322269139395656016
             + y*(-164.31676725154983403709093484024
             + (492.95030175464950211127280452072
             - 383.40579025361627941987884796056*y)*y)
             + x*(-427.22359485402956849643643058463
             + y*(6244.0371555588936934094555239291
             + y*(-18239.161164922031578117093767267
             + 13802.60844913018605911563852658*y))
             + x*(3779.2856467856461828530915013255
             + y*(-50445.247546225799049386916995954
             + (133096.58147375536557004365722059
             - 89716.95491934620938425165042277*y)*y)
             + x*(-12871.480101371403666238789895819
             + y*(142626.95397434525594419493144133
             + y*(-294784.28044928040226254113710339
             + 139559.70765231632570883590065764*y))
             + x*(20046.645604689079752525094050509
             + x*(-14525.602225037005328878838639877
             + 3987.4202186376093059667400187898*x
             + 59811.30327956413958950110028185*y)
             + y*(-158072.73009599094034368147931631
             + 179433.90983869241876850330084554*y)))));
          case ( 63 ):
            return 18.973665961010275991993361266596
             - 37.947331922020551983986722533193*z
             + y*(-246.65765749313358789591369646575
             + y*(626.13097671333910773578092179768
             - 398.44698518121579583186058659852*y
             - 796.893970362431591663721173197*z)
             + 455.36798306424662380784067039831*z)
             + x*(-739.97297247940076368774108939726
             + 1441.9986130367809753914954562613*z
             + y*(9372.9909847390763400447204656986
             - 16848.615373377125080890104804738*z
             + y*(-23166.846138393546986223894106514
             + 14344.091466523768649946981117547*y
             + 28688.182933047537299893962235094*z))
             + x*(6545.9147565485452172377096369757
             - 11649.83090006030945908392381769*z
             + y*(-75723.900850392011484045504814986
             + y*(169055.36371260155908866084888537
             - 93236.59453240449622465537726405*y
             - 186473.18906480899244931075452811*z)
             + 122949.35542734658842811698100754*z)
             + x*(-22294.057504187074290592199488251
             + 32938.284108313839122100475158811*z
             + x*(34721.808708648805065347851117871
             - 36505.333308983771008595227076931*z
             + x*(-25159.081064299625965383197039507
             + 6906.414409807740461085583501041*x
             + 89783.38732750062599411258551353*y
             + 13812.828819615480922171167002082*z)
             + y*(-237284.66650839451155586897600005
             + 227911.67552365543521582425553435*y
             + 165753.94583538577106605400402499*z))
             + y*(214098.84670403995429365308853227
             - 272310.05387241948103708872089819*z
             + y*(-374426.32407457678642599699123501
             + 145034.70260596254968279725352186*y
             + 290069.40521192509936559450704372*z)))));
          case ( 64 ):
            return 24.494897427831780981972840747059
             + z*(-146.96938456699068589183704448235
             + 146.96938456699068589183704448235*z)
             + y*(-220.45407685048602883775556672353
             + y*(367.42346141747671472959261120588
             - 171.46428199482246687380988522941*y
             - 1028.7856919689348012428593113765*z)
             + (1175.7550765359254871346963558588
             - 1028.7856919689348012428593113765*z)*z)
             + x*(-955.3009996854394582969407891353
             + (5584.8366135456460638898076903294
             - 5437.867228978655377997970645847*z)*z
             + y*(8377.2549203184690958347115354941
             + z*(-43502.937831829243023983765166777
             + 37036.284910881652844742935209553*z)
             + y*(-13594.668072446638444994926614618
             + 6172.714151813608807457155868259*y
             + 37036.284910881652844742935209553*z))
             + x*(8450.7396126019644387806300577353
             + z*(-45119.601062066140568793972656083
             + 39681.733833087485190796002010235*z)
             + y*(-67679.401593099210853190958984124
             + y*(99204.334582718712976990005025589
             - 40122.641986788457248471513143683*y
             - 240735.8519207307434908290788621*z)
             + (317453.87066469988152636801608188
             - 240735.8519207307434908290788621*z)*z)
             + x*(-28781.504477702342653818087877794
             + (127569.42580414791535411455461068
             - 87887.69197106043016331855260045*z)*z
             + y*(191354.13870622187303117183191602
             + z*(-703101.53576848344130654842080358
             + 374477.99187669226765240078934104*z)
             + y*(-219719.22992765107540829638150112
             + 62412.99864611537794206679822351*y
             + 374477.99187669226765240078934104*z))
             + x*(44825.662292932159197010298567118
             + z*(-141384.54795344503982794723679202
             + 53496.85598238460966462868419158*z)
             + x*(-32480.2339893049415820959868306
             + 8916.142663730768277438114031929*x
             + 80245.28397357691449694302628737*y
             + 53496.85598238460966462868419158*z)
             + y*(-212076.82193016755974192085518804
             + 133742.13995596152416157171047894*y
             + 427974.84785907687731702947353261*z)))));
          case ( 65 ):
            return 28.98275349237887714743732831434
             + y*(-86.948260477136631442311984943019
             + y*(86.948260477136631442311984943019
             - 28.98275349237887714743732831434*y
             - 347.79304190854652576924793977207*z)
             + (695.58608381709305153849587954415
             - 869.4826047713663144231198494302*z)*z)
             + z*(-347.79304190854652576924793977207
             + (869.48260477136631442311984943019
             - 579.6550698475775429487465662868*z)*z)
             + x*(-1130.3273862027762087500558042592
             + z*(13216.135592524767979231421711339
             + z*(-32170.856376540553633655434428917
             + 20867.582514512791546154876386324*z))
             + y*(3304.0338981311919948078554278347
             + y*(-3217.0856376540553633655434428917
             + 1043.3791257256395773077438193162*y
             + 12520.549508707674927692925831795*z)
             + z*(-25736.685101232442906924347543134
             + 31301.373771769187319232314579487*z))
             + x*(9999.0499548707126158658782684471
             + y*(-26693.115966480945852789779377507
             + y*(23476.030328826890489424235934615
             - 6781.964317216657252500334825555*y
             - 81383.57180659988703000401790667*z)
             + (187808.24263061512391539388747692
             - 203458.92951649971757501004476666*z)*z)
             + z*(-106772.46386592378341115911751003
             + (234760.30328826890489424235934615
             - 135639.28634433314505000669651111*z)*z)
             + x*(-34054.735353545180648238860769349
             + z*(301884.36037661838436770721172216
             + z*(-519950.59765327705602502566995925
             + 210994.44542451822563334375012839*z))
             + y*(75471.09009415459609192680293054
             + y*(-51995.059765327705602502566995925
             + 10549.72227122591128166718750642*y
             + 126596.66725471093538000625007704*z)
             + z*(-415960.4781226216448200205359674
             + 316491.66813677733845001562519259*z))
             + x*(53038.438891053345179810310815241
             + x*(-38431.131130894391097501897344814
             + 10549.72227122591128166718750642*x
             + 31649.166813677733845001562519259*y
             + 126596.66725471093538000625007704*z)
             + y*(-83644.226579005439447504129515184
             + 31649.166813677733845001562519259*y
             + 253193.33450942187076001250015407*z)
             + z*(-334576.90631602175779001651806074
             + 316491.66813677733845001562519259*z)))));
          case ( 66 ):
            return 12.247448713915890490986420373529
             + y*(-293.93876913398137178367408896471
             + y*(1543.1785379534022018642889670647
             + y*(-2743.4285119171594699809581636706
             + 1543.1785379534022018642889670647*y)))
             + x*(-367.42346141747671472959261120588
             + y*(8524.2243048854597817265485799765
             + y*(-43208.999062695261652200091077812
             + (74072.569821763305689485870419106
             - 40122.641986788457248471513143683*y)*y))
             + x*(2461.7371914970939886882704950794
             + y*(-50557.46829104479594679194330193
             + y*(222217.70946528991706845761125732
             + y*(-320981.13589430765798777210514946
             + 140429.24695375960036965029600289*y)))
             + x*(-6417.6631260919266172768842757294
             + x*(7973.0891127592447096321596631677
             + x*(-4776.5049984271972914847039456765
             + 1114.5178329663460346797642539912*x
             + 26748.427991192304832314342095788*y)
             + y*(-87887.691971060430163318552600447
             + 140429.24695375960036965029600289*y))
             + y*(103466.44673516144286785327931558
             + y*(-320981.13589430765798777210514946
             + 249651.99458446151176826719289402*y)))));
          case ( 67 ):
            return 21.213203435596425732025330863145
             - 42.426406871192851464050661726291*z
             + y*(-466.6904755831213661045572789892
             + 890.9545442950498807450638962521*z
             + y*(2227.3863607376247018626597406303
             - 3563.8181771801995229802555850084*z
             + y*(-3563.8181771801995229802555850084
             + 1781.9090885900997614901277925042*y
             + 3563.8181771801995229802555850084*z)))
             + x*(-636.39610306789277196075992589436
             + 1230.3657992645926924574691900624*z
             + y*(13534.023791910519617032161090687
             - 24946.727240261396660861789095059*z
             + y*(-62366.818100653491652154472737648
             + y*(96223.090783865387120466900795228
             - 46329.63630334259379874332260511*y
             - 92659.27260668518759748664521022*z)
             + 96223.09078386538712046690079523*z))
             + x*(4263.8538905548815721370915034922
             - 7297.341981845170451816713816922*z
             + y*(-80270.761800296874969983851986142
             + 128297.4543784871828272892010603*z
             + y*(320743.63594621795706822300265076
             - 416966.72673008334418868990344599*z
             + y*(-416966.72673008334418868990344599
             + 162153.72706169907829560162911788*y
             + 324307.45412339815659120325823577*z)))
             + x*(-11115.718600252527083581273372288
             + 14934.095218659883715345832927654*z
             + x*(13809.795436573273151548490391908
             - 12685.495654486662587751147856161*z
             + x*(-8273.1493398826060354898790366267
             + 1930.4015126392747416143051085462*x
             + 42468.833278064044315514712388017*y
             + 3860.8030252785494832286102170925*z)
             + y*(-139540.45219935328846526262641777
             + 202692.15882712384786950203639735*y
             + 81076.86353084953914780081455894*z))
             + y*(164275.0474052587208688041622042
             - 185318.54521337037519497329042044*z
             + y*(-463296.3630334259379874332260511
             + 324307.45412339815659120325823577*y
             + 324307.45412339815659120325823577*z)))));
          case ( 68 ):
            return 27.38612787525830567284848914004
             + z*(-164.31676725154983403709093484024
             + 164.31676725154983403709093484024*z)
             + y*(-492.95030175464950211127280452072
             + (2793.3850432763471786305458922841
             - 2629.0682760247973445934549574439*z)*z
             + y*(1889.6428233928230914265457506628
             + z*(-8544.4718970805913699287286116925
             + 5915.403621055794025335273654249*z)
             + y*(-2409.9792530227308992106670443235
             + 985.9006035092990042225456090414*y
             + 5915.403621055794025335273654249*z)))
             + x*(-821.5838362577491701854546742012
             + (4765.186250294945187075637110367
             - 4600.8694830433953530385461755267*z)*z
             + y*(14295.558750884835561226911331101
             + z*(-78214.781211737721001655284983955
             + 70984.84345266952830402328385098*z)
             + y*(-52909.999054999046559943281018557
             + y*(65069.439831613734278688010196735
             - 25633.415691241774109786185835078*y
             - 153800.49414745064465871711501047*z)
             + (230700.7412211759669880756725157
             - 153800.49414745064465871711501047*z)*z))
             + x*(5504.6117029269194402425463171481
             + z*(-28262.483967266571454379640792521
             + 23661.614484223176101341094616995*z)
             + y*(-84787.451901799714363138922377564
             + (402247.44623179399372279860848891
             - 307600.98829490128931743423002093*z)*z
             + y*(272108.56656856652516542258809544
             + z*(-999703.21195842919028166124756802
             + 538301.7295160772563055099025366*z)
             + y*(-281967.57260365951520764804418585
             + 89716.95491934620938425165042277*y
             + 538301.7295160772563055099025366*z)))
             + x*(-14350.331006635352172572608309381
             + (57839.502072545541581056009063765
             - 34177.88758832236547971491444677*z)*z
             + x*(17828.369246793156993024366430166
             + z*(-49130.713408213400377090189517232
             + 14952.825819891034897375275070462*z)
             + x*(-10680.589871350739212410910764616
             + 2492.1376366485058162292125117436*x
             + 44858.477459673104692125825211386*y
             + 14952.825819891034897375275070462*z)
             + y*(-147392.1402246402011312705685517
             + 171957.49692874690131981566331031*y
             + 254198.03893814759325537967619785*z))
             + y*(173518.50621763662474316802719129
             + z*(-581024.08900148021315515354559509
             + 239245.21311825655835800440112739*z)
             + y*(-393045.70726570720301672151613786
             + 219308.11202506851182817070103344*y
             + 777546.942634333814663514303664*z)))));
          case ( 69 ):
            return 32.40370349203930115482983718044
             + z*(-388.84444190447161385795804616528
             + (972.1111047611790346448951154132
             - 648.0740698407860230965967436088*z)*z)
             + y*(-388.84444190447161385795804616528
             + z*(4277.2888609491877524375385078181
             + z*(-9721.111047611790346448951154132
             + 5832.666628567074207869370692479*z))
             + y*(972.1111047611790346448951154132
             + y*(-907.30369777710043233523544105232
             + 291.63333142835371039346853462396*y
             + 3499.5999771402445247216224154875*z)
             + z*(-7388.0443961849606633012028771403
             + 8748.999942850611311804056038719*z)))
             + x*(-972.1111047611790346448951154132
             + z*(11276.488815229676801880783338793
             + z*(-27219.11093331301297005706323157
             + 17497.999885701222623608112077438*z))
             + y*(11276.488815229676801880783338793
             + y*(-27219.11093331301297005706323157
             + y*(24497.199839981711673051356908413
             - 7582.466617137196470230181900223*y
             - 90989.59940564635764276218280268*z)
             + (199477.19869699393790913247768279
             - 227473.99851411589410690545700669*z)*z)
             + z*(-119764.08810657725706825107821891
             + (262469.99828551833935412168116156
             - 151649.33234274392940460363800446*z)*z))
             + x*(6513.1444018998995321207972732684
             + z*(-66881.244007569117583568783940428
             + (139983.9990856097809888648966195
             - 75824.66617137196470230181900223*z)*z)
             + y*(-66881.244007569117583568783940428
             + z*(615929.5959766830363510055451258
             + z*(-1.1373699925705794705345272850334e6
             + 530772.6631996037529161127330156*z))
             + y*(139983.9990856097809888648966195
             + y*(-106154.53263992075058322254660312
             + 26538.63315998018764580563665078*y
             + 318463.59791976225174966763980936*z)
             + z*(-864401.19435364039760624073662542
             + 796158.9947994056293741690995234*z)))
             + x*(-16979.540629828593805130834682551
             + z*(136873.24355037400807800123225018
             + z*(-202199.10979032523920613818400595
             + 58974.7403555115281017903036684*z))
             + x*(21094.810973317585051794224004466
             + x*(-12637.444361895327450383636500372
             + 2948.73701777557640508951518342*x
             + 35384.84421330691686107418220104*y
             + 35384.84421330691686107418220104*z)
             + z*(-116264.48812943701254352945580342
             + 88462.1105332672921526854555026*z)
             + y*(-116264.48812943701254352945580342
             + 88462.1105332672921526854555026*y
             + 389233.28634637608547181600421145*z))
             + y*(136873.24355037400807800123225018
             + y*(-202199.10979032523920613818400595
             + 82564.63649771613934250642513576*y
             + 672312.0400528314203604094618198*z)
             + z*(-889676.08307743105250700800962616
             + 884621.105332672921526854555026*z)))));
          case ( 70 ):
            return 36.742346141747671472959261120588
             + z*(-734.84692283495342945918522241177
             + z*(3306.811152757290432566333500853
             + z*(-5143.9284598446740062142965568824
             + 2571.9642299223370031071482784412*z)))
             + y*(-146.96938456699068589183704448235
             + y*(220.45407685048602883775556672353
             + y*(-146.96938456699068589183704448235
             + 36.742346141747671472959261120588*y
             + 734.8469228349534294591852224118*z)
             + z*(-2204.5407685048602883775556672353
             + 3306.811152757290432566333500853*z))
             + z*(2204.5407685048602883775556672353
             + z*(-6613.6223055145808651326670017059
             + 5143.928459844674006214296556882*z)))
             + x*(-1102.2703842524301441887778336177
             + y*(4262.1121524427298908632742899883
             + z*(-61727.141518136088074571558682588
             + (178567.80224889368335858200904606
             - 133742.13995596152416157171047894*z)*z)
             + y*(-6172.7141518136088074571558682588
             + y*(3968.1733833087485190796002010235
             - 955.3009996854394582969407891353*y
             - 19106.019993708789165938815782706*z)
             + (59522.600749631227786194003015353
             - 85977.08997168955124672467102218*z)*z))
             + z*(21310.560762213649454316371449941
             + z*(-92590.712277204132111857338023883
             + (138886.06841580619816778600703582
             - 66871.06997798076208078585523947*z)*z))
             + x*(7385.2115744912819660648114852383
             + z*(-126393.67072761198986697985825482
             + z*(476180.80599704982228955202412283
             + z*(-601839.62980182685872707269715524
             + 234048.74492293266728275049333815*z)))
             + y*(-25278.734145522397973395971650965
             + y*(31745.387066469988152636801608188
             + y*(-17195.417994337910249344934204435
             + 3343.5534988990381040392927619735*y
             + 66871.06997798076208078585523947*z)
             + z*(-257931.26991506865374017401306653
             + 300919.81490091342936353634857762*z))
             + z*(317453.87066469988152636801608188
             + z*(-773793.80974520596122052203919959
             + 468097.4898458653345655009866763*z)))
             + x*(-19252.989378275779851830652827188
             + x*(23919.267338277734128896478989503
             + x*(-14329.514995281591874454111837029
             + 3343.5534988990381040392927619735*x
             + 13374.213995596152416157171047894*y
             + 66871.06997798076208078585523947*z)
             + y*(-43943.845985530215081659276300224
             + 20061.320993394228624235756571841*y
             + 200613.20993394228624235756571841*z)
             + z*(-219719.22992765107540829638150112
             + 300919.81490091342936353634857762*z))
             + z*(258666.11683790360716963319828894
             + z*(-687816.71977351640997379736817741
             + 468097.4898458653345655009866763*z))
             + y*(51733.223367580721433926639657788
             + y*(-45854.447984901093998253157878494
             + 13374.213995596152416157171047894*y
             + 200613.20993394228624235756571841*z)
             + z*(-458544.47984901093998253157878494
             + 601839.6298018268587270726971552*z)))));
          case ( 71 ):
            return 13.416407864998738178455042012388
             + y*(-469.57427527495583624592647043357
             + y*(3756.5942021996466899674117634685
             + y*(-11269.782606598940069902235290406
             + (14087.228258248675087377794113007
             - 6198.380433629417038446229409723*y)*y)))
             + x*(-254.91174943497602539064579823537
             + y*(8452.3369549492050524266764678042
             + y*(-63862.101437393993729445999978965
             + y*(180316.52170558304111843576464649
             + y*(-211308.42387373012631066691169511
             + 86777.32607081183853824721173612*y))))
             + x*(1073.312629199899054276403360991
             + x*(-2012.4611797498107267682563018581
             + x*(1945.3791404248170358759810917962
             + x*(-952.56495841491041067030798287952
             + 187.82971010998233449837058817343*x
             + 6574.03985384938170744297058607*y)
             + y*(-26765.733690672482666017808814713
             + 52592.31883079505365954376468856*y))
             + y*(41322.536224196113589641529398154
             + y*(-161533.55069458480766859870582915
             + 157776.95649238516097863129406568*y)))
             + y*(-29113.605067047261847247441166881
             + y*(169046.73909898410104853352935608
             + y*(-326823.69559136926202716482342176
             + 197221.1956154814512232891175821*y)))));
          case ( 72 ):
            return 23.237900077244501311075592398694
             - 46.475800154489002622151184797389*z
             + y*(-766.85070254906854326549454915692
             + 1487.2256049436480839088379135164*z
             + y*(5762.9992191566363251467469148762
             - 10038.772833369624566384655916236*z
             + y*(-16173.578453762172912508612309491
             + y*(18822.699062568046061971229842942
             - 7668.507025490685432654945491569*y
             - 15337.014050981370865309890983138*z)
             + 22308.384074154721258632568702747*z)))
             + x*(-441.52010146764552491043625557519
             + 836.564402780802047198721326353*z
             + y*(13803.312645883233778778901884824
             - 25282.83528404201742645024452978*z
             + y*(-97970.986725662817527494697552896
             + 160620.36533391399306215449465978*z
             + y*(258777.25526019476660013779695186
             - 334625.7611123208188794885305412*z
             + y*(-282340.48593852069092956844764414
             + 107359.09835686959605716923688197*y
             + 214718.19671373919211433847376394*z))))
             + x*(1859.0320061795601048860473918956
             - 2881.4996095783181625733734574381*z
             + x*(-3485.6850115866751966613388598042
             + 4089.8704135950322307493042621702*z
             + x*(3369.4955112004526901059608978107
             - 2649.1206088058731494626175334512*z
             + x*(-1649.8909054843595930863670603073
             + 325.33060108142301835505829358172*x
             + 10735.909835686959605716923688197*y
             + 650.6612021628460367101165871634*z)
             + y*(-43710.490045296906966133189301944
             + 80681.98906819290855205445680827*y
             + 20821.15846921107317472373078923*z))
             + y*(67482.861824318031807363520325809
             - 63950.70101257686760808003028121*z
             + y*(-247808.96642373536198131011733968
             + 226430.09835267042077512057233288*y
             + 140542.8196671747439293851828273*z)))
             + y*(-47544.743558042249682460662047729
             + 66925.15222246416377589770610824*z
             + y*(259334.96486204863463160361116943
             - 291124.41216771911242515502157084*z
             + y*(-469033.77515910301446274975697525
             + 263517.78687595264486759721780119*y
             + 312317.37703816609762085596183845*z)))));
          case ( 73 ):
            return 30.
             + z*(-180.
             + 180.*z)
             + y*(-870.
             + (5040.
             - 4860.*z)*z
             + y*(5700.
             + z*(-29160.
             + 24300.*z)
             + y*(-13860.
             + y*(13950.
             - 4950.*y
             - 29700.*z)
             + (54000.
             - 29700.*z)*z)))
             + x*(-570.
             + (3240.
             - 3060.*z)*z
             + y*(15660.
             + z*(-85680.
             + 77760.*z)
             + y*(-96900.
             + (466560.
             - 364500.*z)*z
             + y*(221760.
             + z*(-810000.
             + 415800.*z)
             + y*(-209250.
             + 69300.*y
             + 415800.*z))))
             + x*(2400.
             + z*(-11160.
             + 8100.*z)
             + x*(-4500.
             + (15840.
             - 7740.*z)*z
             + x*(4350.
             + z*(-10260.
             + 2520.*z)
             + x*(-2130.
             + 420.*x
             + 12180.*y
             + 2520.*z)
             + y*(-49590.
             + 79800.*y
             + 70560.*z))
             + y*(76560.
             + z*(-216720.
             + 68040.*z)
             + y*(-245100.
             + 194040.*y
             + 408240.*z)))
             + y*(-53940.
             + (226800.
             - 140940.*z)*z
             + y*(256500.
             + z*(-845640.
             + 340200.*z)
             + y*(-401940.
             + 195300.*y
             + 756000.*z)))));
          case ( 74 ):
            return 35.49647869859769625540396974937
             + z*(-425.95774438317235506484763699244
             + (1064.8943609579308876621190924811
             - 709.9295739719539251080793949874*z)*z)
             + y*(-816.4190100677470138742913042355
             + z*(9371.0703764297918114266480138336
             + z*(-22362.781580116548640904500942103
             + 14198.591479439078502161587899748*z))
             + y*(4188.5844864345281581376684304256
             + y*(-8022.2041858830793537212971633576
             + y*(6566.8485592405738072497344036334
             - 1952.3063284228732940472183362153*y
             - 23427.675941074479528566620034584*z)
             + (55374.506769812406158430192809017
             - 58569.18985268619882141655008646*z)*z)
             + z*(-40891.943460784546086225373151274
             + (79867.077071844816574658931936082
             - 39046.126568457465880944366724307*z)*z)))
             + x*(-674.43309527335622885267542523802
             + z*(7667.2393988971023911672574658639
             + z*(-18103.204136284825090256024572179
             + 11358.873183551262801729270319798*z))
             + y*(14695.542181219446249737243476239
             + z*(-159308.19639930646079425301623517
             + (357804.50528186477825447201507365
             - 212978.87219158617753242381849622*z)*z)
             + y*(-71205.936269386978688340363317236
             + z*(654271.09537255273737960597042038
             + z*(-1.1980061560776722486198839790412e6
             + 546645.7719584045223332211341403*z))
             + y*(128355.26697412926965954075461372
             + y*(-98502.728388608607108746016054501
             + 27332.288597920226116661056707015*y
             + 327987.46317504271339993268048418*z)
             + z*(-830617.60154718609237645289213525
             + 819968.6579376067834998317012104*z))))
             + x*(2839.7182958878157004323175799496
             + z*(-26409.380151756686014020553493531
             + (47920.246243106889944795359161649
             - 20587.957645186663828134302454634*z)*z)
             + x*(-5324.4718047896544383105954624055
             + z*(37484.281505719167245706592055334
             + z*(-45790.457521191028169471120976687
             + 9939.014035607354951513111529824*z))
             + x*(5146.9894112966659570335756136586
             + x*(-2520.2499876004364341336818522052
             + 496.95070178036774757565557649118*x
             + 11429.866140948458194240078259297*y
             + 5963.408421364412970907866917894*z)
             + z*(-24279.591429840824238696315308569
             + 14908.521053411032427269667294735*z)
             + y*(-46535.883573861579790834604341424
             + 58640.18281008339421392735802596*y
             + 131194.98527001708535997307219367*z))
             + y*(71844.872885961737220937634772724
             + z*(-402956.02618648104789134586459484
             + 313078.94212163168097266301318944*z)
             + y*(-180109.1329166847107999197425083
             + 112310.85860236311095209816028701*y
             + 572487.2084509836452071552241178*z)))
             + y*(-50617.978624200314860206060862601
             + z*(421698.16693934063151419916062251
             + z*(-648520.66582337991058623052732098
             + 198780.28071214709903026223059647*z))
             + y*(188486.30188955376711619507936915
             + y*(-232643.92139060930125791761773737
             + 91935.87982936803330149628165087*y
             + 775243.0947773736862180226993262*z)
             + z*(-1.1858663603627518365005358213869e6
             + 1.1181390790058274320452250471051e6*z)))));
          case ( 75 ):
            return 40.249223594996214535365126037163
             + z*(-804.98447189992429070730252074326
             + z*(3622.4301235496593081828613433447
             + z*(-5634.8913032994700349511176452028
             + 2817.4456516497350174755588226014*z)))
             + y*(-603.73835392494321803047689055744
             + y*(2012.4611797498107267682563018581
             + z*(-28979.440988397274465462890746757
             + (83315.892841642164088205810896927
             - 61983.80433629417038446229409723*z)*z)
             + y*(-2817.4456516497350174755588226014
             + y*(1811.2150617748296540914306716723
             - 442.74145954495835988901638640879*y
             - 8854.829190899167197780327728176*z)
             + (27369.472044597425884048285705271
             - 39846.731359046252390011474776791*z)*z))
             + z*(11269.782606598940069902235290406
             + z*(-47091.591606145571006377197463481
             + (67618.695639593640419413411742434
             - 30991.902168147085192231147048615*z)*z)))
             + x*(-764.7352483049280761719373947061
             + z*(14489.720494198637232731445373379
             + z*(-61581.312100344208239108642836859
             + (90158.260852791520559217882323245
             - 42261.684774746025262133382339021*z)*z))
             + y*(10867.290370648977924548584030034
             + z*(-191586.3043121819811883379999369
             + z*(753465.46569832913610203515941569
             + z*(-1.0142804345939046062912011761365e6
             + 433886.63035405919269123605868062*z)))
             + y*(-34211.840055746782355060357131589
             + y*(45079.130426395760279608941161623
             + y*(-27168.225926622444811371460075085
             + 6198.380433629417038446229409723*y
             + 123967.60867258834076892458819446*z)
             + z*(-410542.08066896138826072428557906
             + 557854.2390266475334601606468751*z))
             + z*(463671.05581435639144740625194812
             + z*(-1.2497383926246324613230871634539e6
             + 867773.2607081183853824721173612*z))))
             + x*(3219.937887599697162829210082973
             + z*(-49909.037257795306023852756286082
             + z*(163009.35555973466886822876045051
             + z*(-163411.84779568463101358241171088
             + 39444.23912309629024465782351642*z)))
             + x*(-6037.3835392494321803047689055744
             + z*(70838.633527193337582242621825407
             + z*(-155764.49531263535025186303776382
             + 78888.47824619258048931564703284*z))
             + x*(5836.1374212744511076279432753886
             + x*(-2857.6948752447312320109239486386
             + 563.4891303299470034951117645203*x
             + 8452.336954949205052426676467804*y
             + 11269.782606598940069902235290406*z)
             + z*(-45884.114898295684570316243682366
             + 50714.02172969523031456005880683*z)
             + y*(-34413.086173721763427737182761774
             + 28174.456516497350174755588226014*y
             + 157776.95649238516097863129406568*z))
             + y*(53128.975145395003186681966369055
             + y*(-86535.8307292418612510350209799
             + 39444.23912309629024465782351642*y
             + 405712.1738375618425164804704546*z)
             + z*(-484600.65208375442300579611748744
             + 659282.2824860379940892807644887*z)))
             + y*(-37431.777943346479517889567214562
             + z*(507140.21729695230314560058806825
             + z*(-1.3656561565782215591849387264409e6
             + 946661.7389543109658717877643941*z))
             + y*(90560.753088741482704571533583617
             + y*(-81705.923897842315506791205855441
             + 25357.010864847615157280029403413*y
             + 383172.60862436396237667599987379*z)
             + z*(-840403.78866352095949842383165596
             + 1.166422499782990297234881352557e6*z)))));
          case ( 76 ):
            return 44.497190922573977692268384644804
             + z*(-1334.9157276772193307680515393441
             + z*(9344.4100937405353153763607754089
             + z*(-24918.42691664142750767029540109
             + (28033.230281221605946129082326227
             - 11213.292112488642378451632930491*z)*z)))
             + y*(-222.48595461286988846134192322402
             + z*(5339.6629107088773230722061573765
             + z*(-28033.230281221605946129082326227
             + (49836.853833282855015340590802181
             - 28033.230281221605946129082326227*z)*z))
             + y*(444.97190922573977692268384644804
             + z*(-8009.4943660633159846083092360648
             + (28033.230281221605946129082326227
             - 24918.42691664142750767029540109*z)*z)
             + y*(-444.97190922573977692268384644804
             + y*(222.48595461286988846134192322402
             - 44.497190922573977692268384644804*y
             - 1334.9157276772193307680515393441*z)
             + (5339.6629107088773230722061573765
             - 9344.410093740535315376360775409*z)*z)))
             + x*(-845.44662752890557615309930825128
             + z*(24028.483098189947953824927708194
             + z*(-158854.97159358910036139813318195
             + z*(398694.83066626284012272472641745
             + z*(-420498.4542183240891919362348934
             + 156986.08957484099329832286102687*z))))
             + y*(4004.7471830316579923041546180324
             + y*(-7564.5224568375762076856253896167
             + y*(7119.5505476118364307629415431687
             + y*(-3337.2893191930483269201288483603
             + 622.9606729160356876917573850273*y
             + 18688.820187481070630752721550818*z)
             + z*(-80094.943660633159846083092360648
             + 130821.74131236749441526905085572*z))
             + z*(128151.90985701305575373294777704
             + z*(-420498.4542183240891919362348934
             + 348857.97683297998510738413561527*z)))
             + z*(-90774.269482050914492227504675401
             + z*(448531.68449954569513806531721963
             + z*(-747552.80749924282523010886203271
             + 392465.22393710248324580715256717*z))))
             + x*(3559.7752738059182153814707715843
             + z*(-82764.775115987598507619195439336
             + z*(420498.4542183240891919362348934
             + z*(-722634.38058260139772243856663162
             + 392465.22393710248324580715256717*z)))
             + x*(-6674.5786383860966538402576967206
             + x*(6452.0926837732267653789157734966
             + x*(-3159.3005555027524161510553097811
             + 622.9606729160356876917573850273*x
             + 3114.8033645801784384587869251363*y
             + 18688.820187481070630752721550818*z)
             + y*(-12681.699412933583642296489623769
             + 6229.606729160356876917573850273*y
             + 74755.28074992428252301088620327*z)
             + z*(-76090.196477601501853778937742615
             + 130821.74131236749441526905085572*z))
             + z*(117472.58403559530110758853546228
             + z*(-401809.63403084301856118351334258
             + 348857.97683297998510738413561527*z))
             + y*(19578.764005932550184598089243714
             + y*(-19133.792096706810407675405397266
             + 6229.606729160356876917573850273*y
             + 112132.92112488642378451632930491*z)
             + z*(-229605.50516048172489210486476719
             + 392465.22393710248324580715256717*z)))
             + y*(-13794.129185997933084603199239889
             + y*(20023.735915158289961520773090162
             + y*(-12904.185367546453530757831546993
             + 3114.8033645801784384587869251363*y
             + 74755.28074992428252301088620327*z)
             + z*(-232275.33661583616355364096784588
             + 392465.22393710248324580715256717*z))
             + z*(240284.83098189947953824927708194
             + z*(-812963.67815542657243774338746057
             + 697715.9536659599702147682712305*z)))));
          case ( 77 ):
            return 14.49137674618943857371866415717
             + y*(-695.58608381709305153849587954415
             + y*(7825.3434429422968298080786448717
             + y*(-34779.304190854652576924793977207
             + y*(71732.31489363772093990738757799
             + y*(-68863.022297892212102311092074871
             + 24867.202496461076592501227693703*y)))))
             + x*(-86.948260477136631442311984943019
             + y*(3477.9304190854652576924793977207
             + y*(-31301.373771769187319232314579487
             + y*(104337.91257256395773077438193162
             + y*(-143464.62978727544187981477515598
             + 68863.02229789221210231109207487*y))))
             + x*(217.37065119284157860577996235755
             + x*(-289.8275349237887714743732831434
             + x*(217.37065119284157860577996235755
             + x*(-86.948260477136631442311984943019
             + 14.49137674618943857371866415717*x
             + 695.5860838170930515384958795441*y)
             + y*(-3477.9304190854652576924793977207
             + 7825.343442942296829808078644872*y))
             + y*(6955.8608381709305153849587954415
             + y*(-31301.373771769187319232314579487
             + 34779.304190854652576924793977207*y)))
             + y*(-6955.8608381709305153849587954415
             + y*(46952.06065765378097884847186923
             + y*(-104337.91257256395773077438193162
             + 71732.31489363772093990738757799*y)))));
          case ( 78 ):
            return 25.099800796022266439345160773556
             - 50.19960159204453287869032154711*z
             + y*(-1154.5908366170242562098773955836
             + 2258.98207164200397954106446962*z
             + y*(12424.40139403102188747585458291
             - 22589.8207164200397954106446962*z
             + y*(-52709.581671646759522624837624467
             + 82829.34262687347924983903055273*z
             + y*(103536.67828359184906229878819092
             - 124244.0139403102188747585458291*z
             + y*(-94425.450594635766344816494830116
             + 32303.443624480656907437221915566*y
             + 64606.88724896131381487444383113*z)))))
             + x*(-150.59880477613359863607096464133
             + 250.99800796022266439345160773556*z
             + x*(376.49701194033399659017741160333
             - 501.9960159204453287869032154711*z
             + x*(-501.99601592044532878690321547111
             + 501.9960159204453287869032154711*z
             + x*(376.49701194033399659017741160333
             - 250.99800796022266439345160773556*z
             + x*(-150.59880477613359863607096464133
             + 25.099800796022266439345160773556*x
             + 1154.5908366170242562098773955836*y
             + 50.19960159204453287869032154711*z)
             + y*(-5772.9541830851212810493869779178
             + 12424.40139403102188747585458291*y
             + 2258.98207164200397954106446962*z))
             + y*(11545.908366170242562098773955836
             - 9035.92828656801591816425787848*z
             + y*(-49697.60557612408754990341833164
             + 52709.58167164675952262483762447*y
             + 22589.8207164200397954106446962*z)))
             + y*(-11545.908366170242562098773955836
             + 13553.89242985202387724638681772*z
             + y*(74546.40836418613132485512749746
             - 67769.4621492601193862319340886*z
             + y*(-158128.7450149402785678745128734
             + 103536.67828359184906229878819092*y
             + 82829.34262687347924983903055273*z))))
             + y*(5772.9541830851212810493869779178
             - 9035.92828656801591816425787848*z
             + y*(-49697.60557612408754990341833164
             + 67769.4621492601193862319340886*z
             + y*(158128.7450149402785678745128734
             - 165658.68525374695849967806110547*z
             + y*(-207073.35656718369812459757638183
             + 94425.45059463576634481649483012*y
             + 124244.0139403102188747585458291*z)))));
          case ( 79 ):
            return 32.40370349203930115482983718044
             + z*(-194.42222095223580692897902308264
             + 194.42222095223580692897902308264*z)
             + y*(-1360.9555466656506485028531615785
             + (7971.3110590416680840881399463882
             - 7776.888838089432277159160923306*z)*z
             + y*(13317.922135228152774635063081161
             + z*(-71936.221752327248563722238540577
             + 64159.33291423781628656307761727*z)
             + y*(-51197.851517422095824631142745095
             + (235250.88735220532638406461792999
             - 171091.55443796751009750154031272*z)*z
             + y*(90892.388295170239739297693291134
             + z*(-310103.44241881611205172154181681
             + 139011.88798084860195422000150409*z)
             + y*(-74852.555066610785667656923886816
             + 23168.647996808100325703333584015*y
             + 139011.88798084860195422000150409*z)))))
             + x*(-194.42222095223580692897902308264
             + (972.1111047611790346448951154132
             - 777.6888838089432277159160923306*z)*z
             + x*(486.0555523805895173224475577066
             + z*(-1944.2222095223580692897902308264
             + 1166.5333257134148415738741384958*z)
             + x*(-648.0740698407860230965967436088
             + (1944.2222095223580692897902308264
             - 777.6888838089432277159160923306*z)*z
             + x*(486.0555523805895173224475577066
             + z*(-972.1111047611790346448951154132
             + 194.42222095223580692897902308264*z)
             + x*(-194.42222095223580692897902308264
             + 32.40370349203930115482983718044*x
             + 1360.9555466656506485028531615785*y
             + 194.42222095223580692897902308264*z)
             + y*(-6804.7777333282532425142658078924
             + 13317.922135228152774635063081161*y
             + 7971.311059041668084088139946388*z))
             + y*(13609.555466656506485028531615785
             + z*(-31885.244236166672336352559785553
             + 7776.888838089432277159160923306*z)
             + y*(-53271.688540912611098540252324643
             + 51197.8515174220958246311427451*y
             + 71936.22175232724856372223854058*z)))
             + y*(-13609.555466656506485028531615785
             + (47827.866354250008504528839678329
             - 23330.666514268296831477482769917*z)*z
             + y*(79907.532811368916647810378486965
             + z*(-215808.66525698174569116671562173
             + 64159.33291423781628656307761727*z)
             + y*(-153593.55455226628747389342823529
             + 90892.38829517023973929769329113*y
             + 235250.88735220532638406461792999*z))))
             + y*(6804.7777333282532425142658078924
             + z*(-31885.244236166672336352559785553
             + 23330.666514268296831477482769917*z)
             + y*(-53271.688540912611098540252324643
             + (215808.66525698174569116671562173
             - 128318.66582847563257312615523454*z)*z
             + y*(153593.55455226628747389342823529
             + z*(-470501.77470441065276812923585999
             + 171091.55443796751009750154031272*z)
             + y*(-181784.77659034047947859538658227
             + 74852.55506661078566765692388682*y
             + 310103.44241881611205172154181681*z)))));
          case ( 80 ):
            return 38.340579025361627941987884796056
             + z*(-460.08694830433953530385461755267
             + (1150.2173707608488382596365438817
             - 766.8115805072325588397576959211*z)*z)
             + y*(-1380.260844913018605911563852658
             + z*(16103.043190651883735634911614344
             + z*(-39107.390605868860500827642491977
             + 25304.782156738674441712003965397*z))
             + y*(11502.173707608488382596365438817
             + z*(-121923.04130064997685552147365146
             + (265700.21264575608163797604163667
             - 151828.69294043204665027202379238*z)*z)
             + y*(-37573.767444854395383148127100135
             + z*(328962.16803760276774225605155016
             + z*(-556705.20744825083771766408723874
             + 219308.11202506851182817070103344*z))
             + y*(56935.759852662017493852008922143
             + y*(-40487.651450781879106739206344635
             + 10965.405601253425591408535051672*y
             + 131584.86721504110709690242062006*z)
             + z*(-354266.95019434144218396805551556
             + 328962.16803760276774225605155016*z)))))
             + x*(-230.04347415216976765192730877634
             + z*(2300.4347415216976765192730877634
             + z*(-4600.8694830433953530385461755267
             + 2300.4347415216976765192730877634*z))
             + x*(575.10868538042441912981827194084
             + z*(-4600.8694830433953530385461755267
             + (6901.3042245650930295578192632901
             - 2300.4347415216976765192730877634*z)*z)
             + x*(-766.81158050723255883975769592112
             + z*(4600.8694830433953530385461755267
             + z*(-4600.8694830433953530385461755267
             + 766.8115805072325588397576959211*z))
             + x*(575.10868538042441912981827194084
             + x*(-230.04347415216976765192730877634
             + 38.340579025361627941987884796056*x
             + 1380.260844913018605911563852658*y
             + 460.08694830433953530385461755267*z)
             + z*(-2300.4347415216976765192730877634
             + 1150.2173707608488382596365438817*z)
             + y*(-6901.3042245650930295578192632901
             + 11502.173707608488382596365438817*y
             + 16103.043190651883735634911614344*z))
             + y*(13802.60844913018605911563852658
             + z*(-64412.172762607534942539646457374
             + 39107.390605868860500827642491977*z)
             + y*(-46008.694830433953530385461755267
             + 37573.767444854395383148127100135*y
             + 121923.04130064997685552147365146*z)))
             + y*(-13802.60844913018605911563852658
             + z*(96618.259143911302413809469686061
             + z*(-117322.17181760658150248292747593
             + 25304.782156738674441712003965397*z))
             + y*(69013.042245650930295578192632901
             + z*(-365769.12390194993056656442095438
             + 265700.21264575608163797604163667*z)
             + y*(-112721.30233456318614944438130041
             + 56935.75985266201749385200892214*y
             + 328962.16803760276774225605155016*z))))
             + y*(6901.3042245650930295578192632901
             + z*(-64412.172762607534942539646457374
             + (117322.17181760658150248292747593
             - 50609.56431347734888342400793079*z)*z)
             + y*(-46008.694830433953530385461755267
             + z*(365769.12390194993056656442095438
             + z*(-531400.42529151216327595208327334
             + 151828.69294043204665027202379238*z))
             + y*(112721.30233456318614944438130041
             + y*(-113871.51970532403498770401784429
             + 40487.651450781879106739206344635*y
             + 354266.95019434144218396805551556*z)
             + z*(-657924.33607520553548451210310032
             + 556705.2074482508377176640872387*z)))));
          case ( 81 ):
            return 43.474130238568315721155992471509
             + z*(-869.48260477136631442311984943019
             + z*(3912.6717214711484149040393224358
             + z*(-6086.3782333995642009618389460113
             + 3043.1891166997821004809194730057*z)))
             + y*(-1217.2756466799128401923677892023
             + z*(23476.030328826890489424235934615
             + z*(-101729.46475824985878750502238333
             + (152159.45583498910502404597365028
             - 73036.53880079477041154206735214*z)*z))
             + y*(7825.3434429422968298080786448717
             + z*(-133030.83853001904610673733696282
             + z*(496909.30862683584869281299394935
             + z*(-620810.57980675554849810757249315
             + 237368.75110258300383751171889444*z)))
             + y*(-19998.099909741425231731756536894
             + y*(24562.883584791098382453135746403
             + y*(-14607.307760158954082308413470427
             + 3390.9821586083286262501674127777*y
             + 67819.64317216657252500334825555*z)
             + z*(-224326.51203101250912116492115299
             + 305188.39427474957636251506715*z))
             + z*(266931.15966480945852789779377507
             + z*(-704280.90986480671468272707803845
             + 474737.50220516600767502343778888*z)))))
             + x*(-260.84478143140989432693595482906
             + z*(4347.4130238568315721155992471509
             + z*(-15650.686885884593659616157289743
             + (18259.134700198692602885516838034
             - 6086.378233399564200961838946011*z)*z))
             + x*(652.11195357852473581733988707264
             + z*(-8694.8260477136631442311984943019
             + z*(23476.030328826890489424235934615
             + z*(-18259.134700198692602885516838034
             + 3043.1891166997821004809194730057*z)))
             + x*(-869.48260477136631442311984943019
             + z*(8694.8260477136631442311984943019
             + z*(-15650.686885884593659616157289743
             + 6086.378233399564200961838946011*z))
             + x*(652.11195357852473581733988707264
             + x*(-260.84478143140989432693595482906
             + 43.474130238568315721155992471509*x
             + 1217.2756466799128401923677892023*y
             + 869.4826047713663144231198494302*z)
             + z*(-4347.4130238568315721155992471509
             + 3912.6717214711484149040393224358*z)
             + y*(-6086.3782333995642009618389460113
             + 7825.343442942296829808078644872*y
             + 23476.030328826890489424235934615*z))
             + y*(12172.756466799128401923677892023
             + z*(-93904.12131530756195769694373846
             + 101729.46475824985878750502238333*z)
             + y*(-31301.373771769187319232314579487
             + 19998.099909741425231731756536894*y
             + 133030.83853001904610673733696282*z)))
             + y*(-12172.756466799128401923677892023
             + z*(140856.18197296134293654541560769
             + z*(-305188.39427474957636251506715
             + 152159.45583498910502404597365028*z))
             + y*(46952.06065765378097884847186923
             + y*(-59994.299729224275695195269610683
             + 24562.883584791098382453135746403*y
             + 266931.15966480945852789779377507*z)
             + z*(-399092.51559005713832021201088846
             + 496909.30862683584869281299394935*z))))
             + y*(6086.3782333995642009618389460113
             + z*(-93904.12131530756195769694373846
             + z*(305188.39427474957636251506715
             + z*(-304318.91166997821004809194730057
             + 73036.53880079477041154206735214*z)))
             + y*(-31301.373771769187319232314579487
             + z*(399092.51559005713832021201088846
             + z*(-993818.6172536716973856259878987
             + 620810.5798067555484981075724932*z))
             + y*(59994.299729224275695195269610683
             + y*(-49125.767169582196764906271492806
             + 14607.307760158954082308413470427*y
             + 224326.51203101250912116492115299*z)
             + z*(-533862.31932961891705579558755013
             + 704280.9098648067146827270780385*z)))));
          case ( 82 ):
            return 48.062459362791663118840935411414
             + z*(-1441.8737808837498935652280623424
             + z*(10093.116466186249254956596436397
             + z*(-26914.977243163331346550923830392
             + (30279.349398558747764869789309191
             - 12111.739759423499105947915723676*z)*z)))
             + y*(-865.12426853024993613913683740545
             + z*(24511.854275023748190608877059821
             + z*(-161489.86345897998807930554298235
             + z*(403724.65864744997019826385745587
             + z*(-423910.89157982246870817705032867
             + 157452.61687250548837732290440779*z))))
             + y*(3604.684452209374733913070155856
             + y*(-6728.7443107908328366377309575979
             + y*(6488.4320139768745210435262805408
             + y*(-3172.1223179442497658435017371533
             + 624.8119717162916205449321603484*y
             + 18744.359151488748616347964810451*z)
             + z*(-76419.310386838744358957087304148
             + 131210.51406042124031443575367316*z))
             + z*(118233.65003246749127234870111208
             + z*(-403724.65864744997019826385745587
             + 349894.70416112330750516200979509*z)))
             + z*(-83628.67929125749382678322761586
             + z*(423910.89157982246870817705032867
             + z*(-726704.38556540994635687494342057
             + 393631.54218126372094330726101948*z)))))
             + x*(-288.37475617674997871304561246848
             + z*(7209.368904418749467826140311712
             + z*(-40372.465864744997019826385745587
             + z*(80744.931729489994039652771491175
             + z*(-60558.698797117495529739578618381
             + 12111.739759423499105947915723676*z))))
             + x*(720.9368904418749467826140311712
             + z*(-14418.737808837498935652280623424
             + z*(60558.698797117495529739578618381
             + z*(-80744.931729489994039652771491175
             + 30279.349398558747764869789309191*z)))
             + x*(-961.24918725583326237681870822827
             + x*(720.9368904418749467826140311712
             + x*(-288.37475617674997871304561246848
             + 48.062459362791663118840935411414*x
             + 865.1242685302499361391368374054*y
             + 1441.8737808837498935652280623424*z)
             + z*(-7209.368904418749467826140311712
             + 10093.116466186249254956596436397*z)
             + y*(-4325.6213426512496806956841870272
             + 3604.684452209374733913070155856*y
             + 24511.854275023748190608877059821*z))
             + z*(14418.737808837498935652280623424
             + z*(-40372.465864744997019826385745587
             + 26914.977243163331346550923830392*z))
             + y*(8651.2426853024993613913683740545
             + y*(-14418.737808837498935652280623424
             + 6728.744310790832836637730957598*y
             + 83628.67929125749382678322761586*z)
             + z*(-98047.417100094992762435508239284
             + 161489.86345897998807930554298235*z)))
             + y*(-8651.2426853024993613913683740545
             + z*(147071.12565014248914365326235893
             + z*(-484469.59037693996423791662894705
             + 403724.65864744997019826385745587*z))
             + y*(21628.106713256248403478420935136
             + y*(-20186.232932372498509913192872794
             + 6488.432013976874521043526280541*y
             + 118233.65003246749127234870111208*z)
             + z*(-250886.03787377248148034968284758
             + 423910.89157982246870817705032867*z))))
             + y*(4325.6213426512496806956841870272
             + z*(-98047.417100094992762435508239284
             + z*(484469.59037693996423791662894705
             + z*(-807449.31729489994039652771491175
             + 423910.89157982246870817705032867*z)))
             + y*(-14418.737808837498935652280623424
             + y*(20186.232932372498509913192872794
             + y*(-12976.864027953749042087052561082
             + 3172.1223179442497658435017371533*y
             + 76419.31038683874435895708730415*z)
             + z*(-236467.30006493498254469740222415
             + 403724.65864744997019826385745587*z))
             + z*(250886.03787377248148034968284758
             + z*(-847821.78315964493741635410065734
             + 726704.3855654099463568749434206*z)))));
          case ( 83 ):
            return 52.24940191045252529379426939414
             + z*(-2194.4748802390060623393593145539
             + z*(21944.748802390060623393593145539
             + z*(-87778.995209560242493574372582155
             + z*(164585.61601792545467545194859154
             + z*(-144835.34209577440011439771476056
             + 48278.447365258133371465904920185*z)))))
             + y*(-313.49641146271515176276561636484
             + z*(10972.374401195030311696796572769
             + z*(-87778.995209560242493574372582155
             + z*(263336.98562868072748072311774647
             + z*(-329171.23203585090935090389718308
             + 144835.34209577440011439771476056*z))))
             + y*(783.7410286567878794069140409121
             + y*(-1044.9880382090505058758853878828
             + y*(783.7410286567878794069140409121
             + y*(-313.49641146271515176276561636484
             + 52.24940191045252529379426939414*y
             + 2194.4748802390060623393593145539*z)
             + z*(-10972.374401195030311696796572769
             + 21944.748802390060623393593145539*z))
             + z*(21944.748802390060623393593145539
             + z*(-87778.995209560242493574372582155
             + 87778.99520956024249357437258216*z)))
             + z*(-21944.748802390060623393593145539
             + z*(131668.49281434036374036155887323
             + z*(-263336.98562868072748072311774647
             + 164585.61601792545467545194859154*z)))))
             + x*(-313.49641146271515176276561636484
             + z*(10972.374401195030311696796572769
             + z*(-87778.995209560242493574372582155
             + z*(263336.98562868072748072311774647
             + z*(-329171.23203585090935090389718308
             + 144835.34209577440011439771476056*z))))
             + x*(783.7410286567878794069140409121
             + x*(-1044.9880382090505058758853878828
             + x*(783.7410286567878794069140409121
             + x*(-313.49641146271515176276561636484
             + 52.24940191045252529379426939414*x
             + 313.49641146271515176276561636484*y
             + 2194.4748802390060623393593145539*z)
             + y*(-1567.4820573135757588138280818242
             + 783.7410286567878794069140409121*y
             + 10972.374401195030311696796572769*z)
             + z*(-10972.374401195030311696796572769
             + 21944.748802390060623393593145539*z))
             + z*(21944.748802390060623393593145539
             + z*(-87778.995209560242493574372582155
             + 87778.99520956024249357437258216*z))
             + y*(3134.9641146271515176276561636484
             + y*(-3134.9641146271515176276561636484
             + 1044.9880382090505058758853878828*y
             + 21944.748802390060623393593145539*z)
             + z*(-43889.497604780121246787186291078
             + 87778.99520956024249357437258216*z)))
             + z*(-21944.748802390060623393593145539
             + z*(131668.49281434036374036155887323
             + z*(-263336.98562868072748072311774647
             + 164585.61601792545467545194859154*z)))
             + y*(-3134.9641146271515176276561636484
             + y*(4702.4461719407272764414842454726
             + y*(-3134.9641146271515176276561636484
             + 783.7410286567878794069140409121*y
             + 21944.748802390060623393593145539*z)
             + z*(-65834.246407170181870180779436617
             + 131668.49281434036374036155887323*z))
             + z*(65834.246407170181870180779436617
             + z*(-263336.98562868072748072311774647
             + 263336.98562868072748072311774647*z))))
             + y*(1567.4820573135757588138280818242
             + y*(-3134.9641146271515176276561636484
             + y*(3134.9641146271515176276561636484
             + y*(-1567.4820573135757588138280818242
             + 313.49641146271515176276561636484*y
             + 10972.374401195030311696796572769*z)
             + z*(-43889.497604780121246787186291078
             + 87778.99520956024249357437258216*z))
             + z*(65834.246407170181870180779436617
             + z*(-263336.98562868072748072311774647
             + 263336.98562868072748072311774647*z)))
             + z*(-43889.497604780121246787186291078
             + z*(263336.98562868072748072311774647
             + z*(-526673.97125736145496144623549293
             + 329171.23203585090935090389718308*z)))));
          #endif
          #if (PMAX3D>=7)
          case ( 84 ):
            return -5.8309518948453004708741528775456
             + x*(408.16663263917103296119070142819
             + x*(-6734.7494385463220438596465735651
             + x*(44898.329590308813625730977157101
             + x*(-145919.57116850364428362567576058
             + x*(245144.87956308612239649113527777
             + x*(-204287.39963590510199707594606481
             + 66706.08967703023738680030891912*x))))));
          case ( 85 ):
            return -8.2462112512353210996428197119482
             + 24.738633753705963298928459135844*y
             + x*(552.49615383276651367606892070053
             - 1632.7498277445935777292783029657*y
             + x*(-8707.9990813044990812228176158173
             + 24491.247416168903665939174544486*y
             + x*(55332.077495789004578603320267172
             - 141504.98507119811006987078625703*y
             + x*(-170985.19029436438300109386672724
             + 371450.5858118950389334108139247*y
             + x*(272397.09626205636188450126354478
             - 445740.70297427404672009297670965*y
             + x*(-214615.89402465046693930402582316
             + 66035.65969989245136593970025328*x
             + 198106.97909967735409781910075984*y))))));
          case ( 86 ):
            return -14.282856857085699995998799622735
             + 14.282856857085699995998799622735*y
             + 28.565713714171399991997599245469*z
             + x*(956.95140942474189973191957472321
             - 942.6685525676561997359207751005*y
             - 1885.337105135312399471841550201*z
             + x*(-15082.696841082499195774732401608
             + 14140.028288514842996038811626507*y
             + 28280.056577029685992077623253014*z
             + x*(95837.969511045046973151945468549
             - 81697.94122253020397711313384204*y
             - 163395.88244506040795422626768408*z
             + x*(-296155.0369316719894170351101774
             + 214457.09570914178543992197633536*y
             + 428914.19141828357087984395267072*z
             + x*(471805.61056011192796782834793779
             - 257348.51485097014252790637160243*y
             - 514697.0297019402850558127432049*z
             + x*(-371725.63256251242809586475898129
             + 114377.11771154228556795838737886*x
             + 114377.11771154228556795838737886*y
             + 228754.23542308457113591677475772*z))))));
          case ( 87 ):
            return -10.09950493836207795336338591707
             + (80.796039506896623626907087336557
             - 100.9950493836207795336338591707*y)*y
             + x*(626.16930617844883310852992685832
             + y*(-4928.55840992069404124133232753
             + 6059.702963017246772018031550242*y)
             + x*(-9099.6539494642322359804107112797
             + (67868.673185793163846601953362708
             - 78776.13851922420803623441015314*y)*y
             + x*(53123.395975784530034691409923786
             + y*(-357118.49462048307643092932602758
             + 367621.97975637963750242724738133*y)
             + x*(-150331.13100751953033581399937558
             + (845530.55343967316625558266897707
             - 689291.21204321182031705108884*y)*y
             + x*(218735.07795504588431394421219189
             + x*(-157158.39634585229503228764825552
             + 44114.63757076555650029126968576*x
             + 352917.10056612445200233015748608*y)
             + y*(-904350.07020069390825597102855808
             + 441146.3757076555650029126968576*y))))));
          case ( 88 ):
            return -17.492855684535901412622458632637
             + y*(104.95713410721540847573475179582
             - 87.46427842267950706311229316318*y
             - 174.92855684535901412622458632637*z)
             + 34.985711369071802825244917265273*z
             + x*(1084.5570524412258875825924352235
             - 2134.1283935133799723399399531817*z
             + y*(-6402.3851805401399170198198595451
             + 5247.856705360770423786737589791*y
             + 10495.713410721540847573475179582*z)
             + x*(-15761.062971766847172772835228006
             + y*(88163.992650060943119617191508489
             - 68222.13716969001550922758866728*y
             - 136444.27433938003101845517733457*z)
             + 29387.99755002031437320573050283*z
             + x*(92012.420900658841430394132407669
             - 154636.84425129736848758253431251*z
             + y*(-463910.53275389210546274760293753
             + 318369.97345855340570972874711399*y
             + 636739.946917106811419457494228*z)
             + x*(-260381.1568643168925268852967468
             + y*(1.0983764084320092496985641775433e6
             - 596943.7002347876357057414008387*y
             - 1.1938874004695752714114828016775e6*z)
             + 366125.46947733641656618805918109*z
             + x*(378860.26841567855279457720906565
             - 391595.06735402068902296635895021*z
             + x*(-272206.32730706316188181807878246
             + 76408.79363005281737033489930736*x
             + 458452.76178031690422200939584414*y
             + 152817.58726010563474066979861471*z)
             + y*(-1.1747852020620620670688990768506e6
             + 382043.96815026408685167449653679*y
             + 764087.9363005281737033489930736*z))))));
          case ( 89 ):
            return -22.583179581272429849720499859691
             + y*(45.166359162544859699440999719382
             - 22.583179581272429849720499859691*y
             - 135.49907748763457909832299915815*z)
             + (135.49907748763457909832299915815
             - 135.49907748763457909832299915815*z)*z
             + x*(1400.1571340388906506826709913009
             + z*(-8265.443726745709324997702948647
             + 8129.944649258074745899379949489*z)
             + y*(-2755.1479089152364416659009828823
             + 1354.9907748763457909832299915815*y
             + 8129.944649258074745899379949489*z)
             + x*(-20347.444802726459294598170373582
             + y*(37939.741696537682147530439764281
             - 17614.880073392495282781989890559*y
             - 105689.28044035497169669193934335*z)
             + (113819.22508961304644259131929284
             - 105689.28044035497169669193934335*z)*z
             + x*(118787.52459749298100952982926198
             + z*(-598905.92249534483961458765627901
             + 493216.64205498986791789571693565*z)
             + y*(-199635.30749844827987152921875967
             + 82202.77367583164465298261948928*y
             + 493216.64205498986791789571693565*z)
             + x*(-336150.6280672401183130896404115
             + y*(472665.94863603195675465006206334
             - 154130.20064218433372434241154239*y
             - 924781.2038531060023460544692544*z)
             + (1.41799784590809587026395018619e6
             - 924781.2038531060023460544692544*z)*z
             + x*(489106.50337119828568524658596119
             + z*(-1.5166411743190938438475293295771e6
             + 591859.9704659878415014748603228*z)
             + y*(-505547.05810636461461584310985905
             + 98643.32841099797358357914338713*y
             + 591859.9704659878415014748603228*z)
             + x*(-351416.85746418028089150069831665
             + 98643.32841099797358357914338713*x
             + 197286.65682199594716715828677426*y
             + 591859.9704659878415014748603228*z))))));
          case ( 90 ):
            return -11.661903789690600941748305755091
             + y*(174.92855684535901412622458632637
             + y*(-524.7856705360770423786737589791
             + 408.16663263917103296119070142819*y))
             + x*(641.40470843298305179615681653001
             + y*(-9446.1420696493867628161276616238
             + (27813.640538412083246069709225892
             - 21224.664897236893713981916474266*y)*y)
             + x*(-8221.6421717318736639325555573393
             + y*(113878.49050632871819617220569847
             + y*(-313821.8309805740713424469078695
             + 222858.98142098738399681012297979*y))
             + x*(42157.782199731522404420125304655
             + y*(-518488.24248964411787012967387135
             + (1.2416428964883582822679421137446e6
             - 742863.2714032912799893670765993*y)*y)
             + x*(-104607.27699352469044748230262317
             + y*(1.0506209124132262388421048654762e6
             + y*(-1.9102198407513204342583724826839e6
             + 742863.2714032912799893670765993*y))
             + x*(133715.38885259243039808607378788
             + x*(-84898.659588947574855927665897064
             + 21224.664897236893713981916474266*x
             + 318369.97345855340570972874711399*y)
             + y*(-955109.92037566021712918624134197
             + 955109.920375660217129186241342*y))))));
          case ( 91 ):
            return -20.199009876724155906726771834139
             + 40.398019753448311813453543668278*z
             + y*(262.58712839741402678744803384381
             - 484.77623704137974176144252401934*z
             + y*(-666.56732593189714492198347052659
             + 424.17920741120727404126220851692*y
             + 848.3584148224145480825244170338*z))
             + x*(1110.9455432198285748699724508777
             - 2181.493066686208837926491358087*z
             + y*(-14179.704933460357446522193827566
             + y*(35328.068274390548680865123937909
             - 22057.31878538277825014563484288*y
             - 44114.63757076555650029126968576*z)
             + 25693.140563193126313356453773025*z)
             + x*(-14240.301963090529914242374143068
             + 26299.110859494850990558256928049*z
             + y*(170944.22058671653143862867003232
             - 289896.18975074508557334262936357*z
             + y*(-398607.2609072744926633461153749
             + 231601.84724651917162652916585024*y
             + 463203.69449303834325305833170048*z))
             + x*(73019.420704357823602817280180413
             - 119739.73054922079621507630343278*z
             + y*(-778308.24856993517539799597231305
             + y*(1.5770982931548686448854128912659e6
             - 772006.1574883972387550972195008*y
             - 1.5440123149767944775101944390016e6*z)
             + 1.1469805768399044690075730118298e6*z)
             + x*(-181185.11859421567848333914335223
             + 242630.50663921056075160198327168*z
             + x*(231601.84724651917162652916585024
             - 220573.1878538277825014563484288*z
             + x*(-147048.79190255185500097089895253
             + 36762.197975637963750242724738133*x
             + 477908.57368329352875315542159573*y
             + 73524.39595127592750048544947627*z)
             + y*(-1.4337257210498805862594662647872e6
             + 1.2131525331960528037580099163584e6*y
             + 882292.7514153111300058253937152*z))
             + y*(1.5770982931548686448854128912659e6
             - 1.7645855028306222600116507874304e6*z
             + y*(-2.4263050663921056075160198327168e6
             + 772006.1574883972387550972195008*y
             + 1.5440123149767944775101944390016e6*z))))));
          case ( 92 ):
            return -26.076809620810594858331886229717
             + (156.4608577248635691499913173783
             - 156.4608577248635691499913173783*z)*z
             + y*(234.69128658729535372498697606745
             + z*(-1251.6868617989085531999305390264
             + 1095.2260040740449840499392216481*z)
             + y*(-391.15214431215892287497829344575
             + 182.53766734567416400832320360802*y
             + 1095.2260040740449840499392216481*z))
             + x*(1434.2245291445827172082537426344
             + z*(-8448.8863171426327340995311384282
             + 8292.42545941776916494953982105*z)
             + y*(-12673.329475713949101149296707642
             + y*(20731.063648544422912373849552625
             - 9491.958701975056528432806587617*y
             - 56951.7522118503391705968395257*z)
             + (66339.403675342153319596318568399
             - 56951.7522118503391705968395257*z)*z)
             + x*(-18384.15078267146937512397979195
             + (101856.01837888618351664434761327
             - 93563.59291946841435169480779222*z)*z
             + y*(152784.02756832927527496652141991
             + z*(-748508.74335574731481355846233779
             + 597993.3982244285612912668150199*z)
             + y*(-233908.98229867103587923701948056
             + 99665.56637073809354854446916998*y
             + 597993.3982244285612912668150199*z))
             + x*(94267.666779230300412869768720426
             + z*(-463749.98229649561896057426470928
             + 370186.38937702720460887945691706*z)
             + y*(-695624.97344474342844086139706392
             + y*(925465.97344256801152219864229265
             - 332218.55456912697849514823056659*y
             - 1.9933113274147618709708893833995e6*z)
             + (2.9614911150162176368710356553365e6
             - 1.9933113274147618709708893833995e6*z)*z)
             + x*(-233908.98229867103587923701948056
             + (939703.91149553059631484785217407
             - 569517.522118503391705968395257*z)*z
             + y*(1.4095558672432958944722717782611e6
             + z*(-4.5561401769480271336477471620561e6
             + 1.9933113274147618709708893833995e6*z)
             + y*(-1.4237938052962584792649209881425e6
             + 332218.55456912697849514823056659*y
             + 1.9933113274147618709708893833995e6*z))
             + x*(298996.69911221428064563340750993
             + z*(-854276.28317775508755895259288552
             + 284758.76105925169585298419762851*z)
             + x*(-189839.17403950113056865613175234
             + 47459.793509875282642164032938084*x
             + 427138.14158887754377947629644276*y
             + 284758.76105925169585298419762851*z)
             + y*(-1.2814144247666326313384288893283e6
             + 711896.9026481292396324604940713*y
             + 2.2780700884740135668238735810281e6*z))))));
          case ( 93 ):
            return -30.854497241083024978157561074178
             + z*(370.25396689299629973789073289013
             + z*(-925.63491723249074934472683222533
             + 617.0899448216604995631512214836*z))
             + y*(92.563491723249074934472683222533
             + y*(-92.563491723249074934472683222533
             + 30.854497241083024978157561074178*y
             + 370.25396689299629973789073289013*z)
             + z*(-740.50793378599259947578146578026
             + 925.6349172324907493447268322253*z))
             + x*(1696.9973482595663737986658590798
             + y*(-4998.4285530554500464615248940168
             + y*(4905.8650613322009715270522107942
             - 1604.4338565363172988641931758572*y
             - 19253.206278435807586370318110287*z)
             + (39246.920490657607772216417686354
             - 48133.015696089518965925795275717*z)*z)
             + z*(-19993.714212221800185846099576067
             + (49058.650613322009715270522107942
             - 32088.677130726345977283863517145*z)*z)
             + x*(-21752.420554963532609601080557295
             + z*(241035.33244734059112936686711148
             + z*(-553529.68050502946810814664567075
             + 336931.10987262663276148056693002*z))
             + y*(60258.833111835147782341716777869
             + y*(-55352.968050502946810814664567075
             + 16846.555493631331638074028346501*y
             + 202158.66592357597965688834015801*z)
             + z*(-442823.7444040235744865173165366
             + 505396.664808939949142220850395*z))
             + x*(111539.00752651513529603958328315
             + y*(-274358.18946771025810577703307159
             + y*(219005.22141720731129496236850451
             - 56155.184978771105460246761155*y
             - 673862.21974525326552296113386*z)
             + (1.7520417713376584903596989480361e6
             - 1.6846555493631331638074028346501e6*z)*z)
             + z*(-1.0974327578708410324231081322863e6
             + (2.1900522141720731129496236850451e6
             - 1.1231036995754221092049352231001e6*z)*z)
             + x*(-276764.84025251473405407332283537
             + z*(2.2237453251593357762257717417381e6
             + z*(-3.3693110987262663276148056693002e6
             + 1.1231036995754221092049352231001e6*z))
             + y*(555936.33128983394405644293543453
             + y*(-336931.10987262663276148056693002
             + 56155.184978771105460246761155*y
             + 673862.21974525326552296113386*z)
             + z*(-2.6954488789810130620918445354402e6
             + 1.6846555493631331638074028346501e6*z))
             + x*(353777.66536625796439955459527652
             + x*(-224620.73991508442184098704462001
             + 56155.184978771105460246761155*x
             + 168465.55493631331638074028346501*y
             + 673862.21974525326552296113386*z)
             + y*(-505396.66480893994914222085039503
             + 168465.55493631331638074028346501*y
             + 1.3477244394905065310459222677201e6*z)
             + z*(-2.0215866592357597965688834015801e6
             + 1.6846555493631331638074028346501e6*z))))));
          case ( 94 ):
            return -13.038404810405297429165943114858
             + y*(312.9217154497271382999826347566
             + y*(-1642.8390061110674760749088324722
             + (2920.6026775307866241331712577283
             - 1642.8390061110674760749088324722*y)*y))
             + x*(599.76662127864368174163338328348
             + y*(-14081.477195237721223499218564047
             + y*(72284.916268886968947295988628775
             + y*(-125585.91513382382483772636408232
             + 68999.23825666483399514617096383*y)))
             + x*(-6375.7799522881904428621461831657
             + y*(138937.24165967884940519228983193
             + y*(-657135.60244442699042996353298886
             + (1.042655155878490824815542139009e6
             - 517494.2869249862549635962822287*y)*y))
             + x*(27067.728386401397462948497906446
             + y*(-510688.23961395468970557165992277
             + y*(2.0239776555288351305242876816057e6
             + y*(-2.5555273428394382961165248505122e6
             + 919989.8434221977866019489461844*y)))
             + x*(-56052.102279932373647984389450776
             + x*(60785.04322610949661477162680147
             + x*(-33313.124290585534931518984658463
             + 7301.506693826966560332928144321*x
             + 175236.1606518471974479902754637*y)
             + y*(-624278.82232220564090846535633942
             + 919989.8434221977866019489461844*y))
             + y*(834562.21510442227784605368689585
             + y*(-2.3574739737693818281674941745975e6
             + 1.6355374994172405095145759043278e6*y))))));
          case ( 95 ):
            return -22.583179581272429849720499859691
             + 45.166359162544859699440999719382*z
             + y*(496.82995078799345669385099691321
             - 948.493542413442053688260994107*z
             + y*(-2371.2338560336051342206524852676
             + y*(3793.9741696537682147530439764281
             - 1896.9870848268841073765219882141*y
             - 3793.9741696537682147530439764281*z)
             + 3793.9741696537682147530439764281*z))
             + x*(1038.8262607385317730871429935458
             - 2032.4861623145186864748449873722*z
             + y*(-22357.347785459705551223294861094
             + 41733.715866191450362283483740709*z
             + y*(104334.28966547862590570870935177
             - 163140.88929511203323438089098641*z
             + y*(-163140.88929511203323438089098641
             + 79673.45756272913250981392350499*y
             + 159346.91512545826501962784700998*z)))
             + x*(-11043.174815242218196513324431389
             + 20053.863468169917706551803875406*z
             + y*(220592.49814986909477206984262946
             - 379397.41696537682147530439764281*z
             + y*(-948493.54241344205368826099410703
             + y*(1.3544487785663952526668366995848e6
             - 597550.9317204684938236044262874*y
             - 1.1951018634409369876472088525749e6*z)
             + 1.3544487785663952526668366995848e6*z))
             + x*(46882.680810721564368019757708719
             - 73711.49815327321102948771154203*z
             + y*(-810826.47968600532132436482696235
             + 1.1685440442533606101439375447399e6*z
             + y*(2.9213601106334015253598438618496e6
             - 3.3197273984470471879089134793746e6*z
             + y*(-3.3197273984470471879089134793746e6
             + 1.0623127675030551001308523133999e6*y
             + 2.1246255350061102002617046267997e6*z)))
             + x*(-97085.089019890175923948428896812
             + 120458.67988650714081840914625159*z
             + x*(105282.78320789206795939697034588
             - 90106.88652927699510038479444017*z
             + x*(-57700.023830151058266035877141511
             + 12646.580565512560715843479921427*x
             + 278224.7724412763357485565582714*y
             + 25293.161131025121431686959842854*z)
             + y*(-991175.75182204694610423273884184
             + 1.3278909593788188751635653917498e6*y
             + 531156.3837515275500654261566999*z))
             + y*(1.3250454787515785490025006087675e6
             - 1.3610882333632893470426545265436e6*z
             + y*(-3.402720583408223367606636316359e6
             + 2.1246255350061102002617046267997e6*y
             + 2.1246255350061102002617046267997e6*z))))));
          case ( 96 ):
            return -29.154759474226502354370764387728
             + (174.92855684535901412622458632637
             - 174.92855684535901412622458632637*z)*z
             + y*(524.7856705360770423786737589791
             + z*(-2973.7854663711032401458179675482
             + 2798.8569095257442260195933812219*z)
             + y*(-2011.6784037216286624515827427532
             + y*(2565.6188337319322071846272661201
             - 1049.5713410721540847573475179582*y
             - 6297.428046432924508544085107749*z)
             + (9096.2849559586687345636784889711
             - 6297.428046432924508544085107749*z)*z))
             + x*(1341.1189358144191083010551618355
             + z*(-7871.7850580411556356801063846865
             + 7696.85650119579662155388179836*z)
             + y*(-23615.35517412346690704031915406
             + (130846.56052032854256641599057212
             - 120350.84710960700171884251539254*z)*z
             + y*(88513.849763751661147869640681142
             + z*(-391140.25310622275558623817502576
             + 264491.97795018282935885157452547*z)
             + y*(-110321.60985047308490893897244316
             + 44081.996325030471559808595754245*y
             + 264491.97795018282935885157452547*z)))
             + x*(-14256.677382896759651287303785599
             + (77668.279239339402272043716328907
             - 69971.42273814360565048983453055*z)*z
             + y*(233004.83771801820681613114898672
             + z*(-1.1895141865484412960583271870193e6
             + 999191.9167006906886889948370962*z)
             + y*(-804671.36148865146498063309710129
             + y*(915925.92364229979796491193400486
             - 330614.97243772853669856446815683*y
             - 1.983689834626371220191386808941e6*z)
             + (3.2473737292772447382392332205627e6
             - 1.983689834626371220191386808941e6*z)*z))
             + x*(60525.280668494218887673706868923
             + z*(-285483.40477162591105399852488463
             + 215511.98203348230540350869035408*z)
             + y*(-856450.2143148777331619955746539
             + (3.6637036945691991918596477360194e6
             - 2.4489997958350261977671442085691e6*z)*z
             + y*(2.478387793385046512140349939072e6
             + z*(-7.9592493364638351427432186778497e6
             + 3.5265597060024377247846876603396e6*z)
             + y*(-2.244916479515440681286548857855e6
             + 587759.9510004062874641146100566*y
             + 3.5265597060024377247846876603396e6*z)))
             + x*(-125336.31097969973362143991610284
             + (466534.46110657249067464097173242
             - 251022.47907309018527113228137834*z)*z
             + x*(135919.48866884395397607650357559
             + z*(-348982.4709064912331818180497211
             + 97959.99183340104791068576834277*z)
             + x*(-74490.410456648713515417303010645
             + 16326.665305566841318447628057128*x
             + 293879.9755002031437320573050283*y
             + 97959.99183340104791068576834277*z)
             + y*(-1.0469474127194736995454541491633e6
             + 1.1265399060841120509728863359418e6*y
             + 1.665319861167817814481658061827e6*z))
             + y*(1.3996033833197174720239229151973e6
             + z*(-4.2673821442425331496092487834317e6
             + 1.5673598693344167665709722934843e6*z)
             + y*(-2.8867585093405371306180212358509e6
             + 1.4367465468898820360233912690272e6*y
             + 5.093919575336854491355659953824e6*z))))));
          case ( 97 ):
            return -34.496376621320680380463909187988
             + z*(413.95651945584816456556691025586
             + z*(-1034.8912986396204114139172756397
             + 689.9275324264136076092781837598*z))
             + y*(413.95651945584816456556691025586
             + y*(-1034.8912986396204114139172756397
             + y*(965.89854539697905065298945726368
             - 310.4673895918861234241751826919*y
             - 3725.6086751026334810901021923028*z)
             + (7865.1738696611151267457712948614
             - 9314.021687756583702725255480757*z)*z)
             + z*(-4553.5217140143298102212360128145
             + (10348.912986396204114139172756397
             - 6209.347791837722468483503653838*z)*z))
             + x*(1586.8333245807512975013398226475
             + z*(-18628.043375513167405450510961514
             + (45535.217140143298102212360128145
             - 29666.88389433578512719896190167*z)*z)
             + y*(-18628.043375513167405450510961514
             + z*(200354.95541663051164973438456384
             + z*(-445003.25841503677690798442852505
             + 260792.60725718434367630715346119*z))
             + y*(45535.217140143298102212360128145
             + y*(-41533.637452070099178078546662338
             + 13039.63036285921718381535767306*y
             + 156475.56435431060620578429207672*z)
             + z*(-338202.47639542795045006816567904
             + 391188.91088577651551446073019179*z)))
             + x*(-16868.728167825812706046851592926
             + z*(183796.6946383965850671117081536
             + z*(-413956.51945584816456556691025586
             + 246304.12907622965791651231160224*z))
             + y*(183796.6946383965850671117081536
             + y*(-413956.51945584816456556691025586
             + y*(344825.78070672152108311723624313
             - 97797.22772144412887861518254795*y
             - 1.1735667326573295465433821905754e6*z)
             + (2.8078670714690181002482403522655e6
             - 2.9339168316433238663584554764384e6*z)*z)
             + z*(-1.8214086856057319240884944051258e6
             + (3.6945619361434448687476846740336e6
             - 1.9559445544288825775723036509589e6*z)*z))
             + x*(71614.477865861732469843075474264
             + z*(-675577.03975194420457100519753757
             + (1.2749860799240123468619460835881e6
             - 603686.5908731119066581184107898*z)*z)
             + y*(-675577.03975194420457100519753757
             + z*(5.6099387516656543261925627677874e6
             + z*(-9.055298863096678599871776161847e6
             + 3.4772347634291245823507620461492e6*z))
             + y*(1.2749860799240123468619460835881e6
             + y*(-845161.22722235666932136577510572
             + 173861.73817145622911753810230746*y
             + 2.0863408580574747494104572276895e6*z)
             + z*(-6.8820271359534757359025498830037e6
             + 5.215852145143686873526143069224e6*z)))
             + x*(-148299.92309505760495561434559916
             + z*(1.1040220373887470548963669496524e6
             + z*(-1.4850690135478552903789712905429e6
             + 386359.41815879162026119578290547*z))
             + x*(160822.1078085970119337227446344
             + x*(-88138.242267474338372085287975311
             + 19317.970907939581013059789145274*x
             + 231815.65089527497215671746974328*y
             + 231815.65089527497215671746974328*z)
             + z*(-825843.25631441708830830598596044
             + 579539.1272381874303917936743582*z)
             + y*(-825843.25631441708830830598596044
             + 579539.1272381874303917936743582*y
             + 2.5499721598480246937238921671761e6*z))
             + y*(1.1040220373887470548963669496524e6
             + y*(-1.4850690135478552903789712905429e6
             + 540903.1854223082683656740960677*y
             + 4.4044973670102244709776319251224e6*z)
             + z*(-6.5343036596105632776674736783888e6
             + 5.795391272381874303917936743582e6*z))))));
          case ( 98 ):
            return -39.115214431215892287497829344575
             + y*(156.4608577248635691499913173783
             + z*(-2346.9128658729535372498697606745
             + (7040.7385976188606117496092820235
             - 5476.130020370224920249696108241*z)*z)
             + y*(-234.69128658729535372498697606745
             + y*(156.4608577248635691499913173783
             - 39.115214431215892287497829344575*y
             - 782.3042886243178457499565868915*z)
             + (2346.9128658729535372498697606745
             - 3520.3692988094303058748046410118*z)*z))
             + z*(782.3042886243178457499565868915
             + z*(-3520.3692988094303058748046410118
             + (5476.1300203702249202496961082405
             - 2738.0650101851124601248480541203*z)*z))
             + x*(1799.2998638359310452249001498505
             + z*(-35203.692988094303058748046410118
             + z*(154896.24914761493345849140420452
             + z*(-235473.59087591967157073693265434
             + 114998.73042777472332524361827305*z)))
             + y*(-7040.7385976188606117496092820235
             + y*(10326.416609840995563899426946968
             + y*(-6727.8168821691334734496266472669
             + 1642.8390061110674760749088324722*y
             + 32856.780122221349521498176649443*z)
             + z*(-100917.253232537002101744399709
             + 147855.51054999607284674179492249*z))
             + z*(103264.16609840995563899426946968
             + z*(-302751.75969761100630523319912701
             + 229997.4608555494466504872365461*z)))
             + x*(-19127.339856864571328586438549497
             + y*(69468.620829839424702596144915965
             + z*(-938765.1463491814148999479042698
             + (2.5135436793499332383946105136824e6
             - 1.7249809564166208498786542740958e6*z)*z)
             + y*(-93876.51463491814148999479042698
             + y*(55856.526207776294186546900304053
             - 12321.292545833006070561816243541*y
             - 246425.85091666012141123632487082*z)
             + (837847.8931166444127982035045608
             - 1.1089163291249705463505634619187e6*z)*z))
             + z*(347343.10414919712351298072457983
             + z*(-1.4081477195237721223499218564047e6
             + (1.9549784172721702965291415106419e6
             - 862490.4782083104249393271370479*z)*z))
             + x*(81203.185159204192388845493719338
             + z*(-1.2767205990348867242639291498069e6
             + z*(4.3370949761332181368377593177265e6
             + z*(-4.7916137678239468052184840947105e6
             + 1.5333164057036629776699149103073e6*z)))
             + y*(-255344.11980697734485278582996139
             + y*(289139.6650755478757891839545151
             + y*(-136903.25050925562300624240270601
             + 21904.520081480899680998784432962*y
             + 438090.40162961799361997568865924*z)
             + z*(-2.0535487576388343450936360405902e6
             + 1.9714068073332809712898905989666e6*z))
             + z*(2.891396650755478757891839545151e6
             + z*(-6.1606462729165030352809081217706e6
             + 3.0666328114073259553398298206147e6*z)))
             + x*(-168156.30683979712094395316835233
             + x*(182355.12967832848984431488040441
             + x*(-99939.372871756604794556953975389
             + 21904.520081480899680998784432962*x
             + 87618.08032592359872399513773185*y
             + 438090.40162961799361997568865924*z)
             + y*(-312139.41116110282045423267816971
             + 131427.12048888539808599270659777*y
             + 1.3142712048888539808599270659777e6*z)
             + z*(-1.5606970558055141022711633908485e6
             + 1.9714068073332809712898905989666e6*z))
             + z*(2.0864055377610556946151342172396e6
             + z*(-5.0517299437915324889303446598519e6
             + 3.0666328114073259553398298206147e6*z))
             + y*(417281.10755221113892302684344793
             + y*(-336781.99625276883259535631065679
             + 87618.08032592359872399513773185*y
             + 1.3142712048888539808599270659777e6*z)
             + z*(-3.3678199625276883259535631065679e6
             + 3.9428136146665619425797811979332e6*z))))));
          case ( 99 ):
            return -14.282856857085699995998799622735
             + y*(499.89998999799949985995798679571
             + y*(-3999.1999199839959988796638943657
             + y*(11997.599759951987996638991683097
             + y*(-14996.999699939984995798739603871
             + 6598.679867973593398151445425703*y))))
             + x*(499.89998999799949985995798679571
             + y*(-16996.599659931982995238571551054
             + y*(131973.59735947186796302890851407
             + y*(-383923.1923184636158924477338591
             + (464906.99069813953486976092772001
             - 197960.3960392078019445433627711*y)*y)))
             + x*(-3999.1999199839959988796638943657
             + y*(122975.39753950787696554966475174
             + y*(-851829.58295659114776136840949989
             + y*(2.1715655565513098273916574946406e6
             + y*(-2.2495499549909977493698109405807e6
             + 791841.5841568312077781734510844*y))))
             + x*(12997.399739947986996358907656688
             + x*(-21495.699569913978493978193432215
             + x*(19296.139613922780694594378290314
             + x*(-8998.1998199639909974792437623228
             + 1713.9428228502839995198559547281*x
             + 59987.99879975993998319495841549*y)
             + y*(-254948.99489897974492857857326581
             + 479903.99039807951986555966732388*y))
             + y*(420415.89158831757938222466689519
             + y*(-1.5596879687937584395630689188026e6
             + 1.4397119711942385595966790019716e6*y)))
             + y*(-331933.59335867166790701210323235
             + y*(1.8036391639127821954947284163589e6
             + y*(-3.2393519351870367590925277544362e6
             + 1.7996399639927981994958487524646e6*y))))));
          case ( 100 ):
            return -24.738633753705963298928459135844
             + 49.477267507411926597856918271689*z
             + y*(816.37491387229678886463915148287
             - 1583.272560237181651131421384694*z
             + y*(-6135.1811709190788981342578656894
             + 10687.089781600976145137094346685*z
             + y*(17218.089092579350456054207558548
             - 23749.088403557724766971320770411*z
             + y*(-20038.293340501830272132051900034
             + 8163.749138722967888646391514829*y
             + 16327.498277445935777292783029657*z))))
             + x*(865.85218137970871546249606975456
             - 1682.2270952520055043271352212374*z
             + y*(-27756.747071658090821397731150417
             + 52247.9944878269944873369056949*z
             + y*(202460.97864032960363843050956775
             - 341986.87301123123664438701909391*z
             + y*(-550978.85096253921459373464187353
             + y*(621187.09355555673843609360890105
             - 244912.47416168903665939174544486*y
             - 489824.94832337807331878349088972*z)
             + 736221.7405102894677761109438827*z)))
             + x*(-6926.8174510376697236999685580364
             + 12171.407806823333943072801894835*z
             + y*(200828.22881258501006070123126479
             - 337237.05533051969169099275493983*z
             + y*(-1.3067935894057638053025969253918e6
             + 1.93436325046977668226981407675e6*z
             + y*(3.1164741257568624325458115680971e6
             - 3.5623632605336587150456981155616e6*z
             + y*(-3.0057440010752745408198077850051e6
             + 979649.8966467561466375669817794*y
             + 1.9592997932935122932751339635589e6*z))))
             + x*(22512.156715872426602024897813618
             - 32852.905624921519260976993732401*z
             + x*(-37231.643799327474764887330999446
             + 41610.38197373343026879766826649*z
             + x*(33421.894201256756416852348292526
             - 25233.406428780082564907028318561*z
             + x*(-15585.339264834756878324929255582
             + 2968.6360504447155958714150963013*x
             + 97964.98966467561466375669817794*y
             + 5937.272100889431191742830192603*z)
             + y*(-416351.20607487136232096596725626
             + 736221.7405102894677761109438827*y
             + 189992.70722846179813577056616329*z))
             + y*(686571.30256660159943516152639709
             - 617476.2984925008439412543400307*z
             + y*(-2.3927206566584407702723605676189e6
             + 2.0661706911095220547265049070257e6*y
             + 1.2824507737921171374164513216022e6*z)))
             + y*(-542072.94281120506780612039658462
             + 714055.924666968924660271044497*z
             + y*(2.7669667080845045830585502974259e6
             - 2.8855142410322635591870154736049e6*z
             + y*(-4.6488840549964246231346360408079e6
             + 2.4045952008602196326558462280041e6*y
             + 2.8498906084269269720365584924493e6*z))))));
          case ( 101 ):
            return -31.937438845342623998140490353961
             + (191.62463307205574398884294212377
             - 191.62463307205574398884294212377*z)*z
             + y*(926.18572651493609594607422026488
             + z*(-5365.4897260175608316876023794655
             + 5173.865092945505087698759437342*z)
             + y*(-6068.1133806150985596466931672526
             + (31043.19055767303052619255662405
             - 25869.325464727525438493797186709*z)*z
             + y*(14755.09674654829228714090654353
             + z*(-57487.38992161672319665288263713
             + 31618.064456889197758159085450422*z)
             + y*(-14850.909063084320159135328014592
             + 5269.677409481532959693180908404*y
             + 31618.064456889197758159085450422*z))))
             + x*(1117.8103595869918399349171623886
             + z*(-6515.2375244498952956206600322081
             + 6323.612891377839551631817090084*z)
             + y*(-31490.314701507827262166523489006
             + (177061.16095857950744569087852236
             - 165563.68297425616280636030199494*z)*z
             + y*(200247.74156029825246834087451934
             + z*(-993382.09784553697683816181196961
             + 801949.089406553288593307712788*z)
             + y*(-472163.09588954535318850900939296
             + y*(460378.18095561392493319516845235
             - 158090.32228444598879079542725211*y
             - 948541.9337066759327447725635126*z)
             + (1.782109087570118419096239361751e6
             - 948541.9337066759327447725635126*z)*z)))
             + x*(-8942.4828766959347194793372991091
             + (47139.659735725713021255363762447
             - 40816.046844347873469623546672362*z)*z
             + y*(227841.68872267427960273425818516
             + z*(-1.1428493116417404571494593068261e6
             + 936469.5818231364208734754581589*z)
             + y*(-1.2925081500710159932047456446248e6
             + (5.6188174909388185252408527489531e6
             - 3.8803988197091288157740695780063e6*z)*z
             + y*(2.6706725111252409039725040843789e6
             + z*(-8.6231084882425084794979323955695e6
             + 3.7941677348267037309790902540506e6*z)
             + y*(-2.2276363594626480238702992021888e6
             + 632361.2891377839551631817090084*y
             + 3.7941677348267037309790902540506e6*z))))
             + x*(29063.069349261787838307846222105
             + z*(-127238.75635984501400859171357018
             + 86422.70951549714053896816689782*z)
             + x*(-48065.845462240649117201437982712
             + (161156.31641359888069461691432609
             - 74733.60689810174015564874742827*z)*z
             + x*(43147.479880057885021487802468202
             + z*(-97728.562866748429434309900483121
             + 22994.955968646689278661153054852*z)
             + x*(-20120.586472565853118828508922996
             + 3832.4926614411148797768588424753*x
             + 111142.28718179233151352890643179*y
             + 22994.955968646689278661153054852*z)
             + y*(-472354.72052261740893249785233509
             + 728173.6056738118271576031800703*y
             + 643858.7671221072998025122855359*z))
             + y*(778922.19599906125669064841924276
             + z*(-2.0925409931468487243581649279915e6
             + 620863.811153460610523851132481*z)
             + y*(-2.3665642184398884382622103352285e6
             + 1.7706116095857950744569087852236e6*y
             + 3.725182866920763663143106794886e6*z)))
             + y*(-614987.32240591756770819328225588
             + (2.4198358664339199350911086731389e6
             - 1.3969435750952863736786650480823e6*z)*z
             + y*(2.7367191346574094504006586184309e6
             + z*(-8.3816614505717182420719902884936e6
             + 3.104319055767303052619255662405e6*z)
             + y*(-3.9838761215680389175280447667531e6
             + 1.782109087570118419096239361751e6*y
             + 6.898486790594006783598345916456e6*z))))));
          case ( 102 ):
            return -37.788887255382368562215735906069
             + z*(453.46664706458842274658883087283
             + z*(-1133.6666176614710568664720771821
             + 755.7777451076473712443147181214*z))
             + y*(869.1444068737944769309619258396
             + z*(-9976.2662354209453004249542792023
             + (23806.998970890892194195913620824
             - 15115.554902152947424886294362428*z)*z)
             + y*(-4459.0886961351194903414568369162
             + z*(43532.798118200488583672527763792
             + z*(-85024.996324610329264985405788656
             + 41567.775980920605418437309496676*z))
             + y*(8540.2885197164152950607563147717
             + y*(-6990.9441422457381840099111426229
             + 2078.3887990460302709218654748338*y
             + 24940.665588552363251062385698006*z)
             + z*(-58950.664118396494957056548013468
             + 62351.66397138090812765596424501*z))))
             + x*(1322.6110539383828996775507567124
             + z*(-15417.866000196006373384020249676
             + (37410.998382828544876593578547009
             - 24184.887843444715879818070979884*z)*z)
             + y*(-29550.909833709012215652705478546
             + z*(329216.78576889119491402349121368
             + z*(-761823.96706850855021426923586636
             + 468582.20196674137017147512523526*z))
             + y*(147149.92697245894318126807561823
             + y*(-273289.23263092528944194420207269
             + y*(216719.26840961788370430724542131
             - 62351.66397138090812765596424501*y
             - 748219.9676565708975318715709402*z)
             + (1.8274705876702913436687529884175e6
             - 1.8705499191414272438296789273504e6*z)*z)
             + z*(-1.3930495397824156346775208884413e6
             + (2.6357748860629202072145475794483e6
             - 1.2470332794276181625531192849003e6*z)*z)))
             + x*(-10580.888431507063197420406053699
             + z*(111552.79517788875199566085239472
             + z*(-241470.98956189333511255855243978
             + 136795.77186448417419522096397997*z))
             + y*(213809.52409095344132501663375654
             + z*(-2.1249447081446613489905152614701e6
             + (4.3090668137312514871494603653691e6
             - 2.2673332353229421137329441543642e6*z)*z)
             + y*(-949785.89227678045144273030626315
             + z*(7.8794364593942884336447275252464e6
             + z*(-1.2753749448691549389747810868298e7
             + 4.9881331177104726502124771396012e6*z))
             + y*(1.5457922220686711684059968929737e6
             + y*(-1.0486416213368607276014866713934e6
             + 249406.65588552363251062385698006*y
             + 2.9928798706262835901274862837607e6*z)
             + z*(-8.8425996177594742435584822020203e6
             + 7.482199676565708975318715709402e6*z))))
             + x*(34387.887402397955391616319674523
             + z*(-301101.85365088671270373498369956
             + (511283.64456532344664677890680912
             - 204059.99117906479023596497389278*z)*z)
             + x*(-56872.275319350464686134682538635
             + z*(381365.45018131886352988120676405
             + z*(-442129.98088797371217792411010101
             + 90693.32941291768454931776617457*z))
             + x*(51052.7866820215799275534592091
             + x*(-23806.998970890892194195913620824
             + 4534.6664706458842274658883087283*x
             + 104297.32882485533723171543110075*y
             + 54415.99764775061072959065970474*z)
             + z*(-231267.99000294009560076030374515
             + 136039.99411937652682397664926185*z)
             + y*(-443263.64750563518323479058217819
             + 535090.6435362143388409748204299*y
             + 1.1971519482505134360509945135043e6*z))
             + y*(730950.4461808611550989389796311
             + z*(-3.8907438318141686671657321688889e6
             + 2.8568398765069070633035096344989e6*z)
             + y*(-1.7390445914926966012331681663973e6
             + 1.0248346223659698354072907577726e6*y
             + 5.223935774184058630040703331655e6*z)))
             + y*(-577111.88616419953268215871875749
             + z*(4.4992960721748463304916543799203e6
             + z*(-6.4278897221405408924328966776224e6
             + 1.8138665882583536909863553234913e6*z))
             + y*(2.0110490019569388901439970334492e6
             + y*(-2.3058779003234321296664042049884e6
             + 838913.2970694885820811893371147*y
             + 7.074079694207579394846785761616e6*z)
             + z*(-1.1753855491914131917591582496224e7
             + 1.0202999558953239511798248694639e7*z))))));
          case ( 103 ):
            return -42.848570571257099987996398868204
             + z*(856.97141142514199975992797736407
             + z*(-3856.3713514131389989196758981383
             + (5998.7998799759939983194958415485
             - 2999.3999399879969991597479207743*z)*z))
             + y*(642.72855856885649981994598302305
             + z*(-11997.599759951987996638991683097
             + z*(50132.827568370806985955786675798
             + z*(-71985.598559711927979833950098582
             + 32993.399339867966990757227128517*z)))
             + y*(-2142.4285285628549993998199434102
             + y*(2999.3999399879969991597479207743
             + y*(-1928.1856757065694994598379490692
             + 471.33427628382809986796038755024*y
             + 9426.685525676561997359207751005*z)
             + z*(-29137.027988454827991837551230378
             + 42420.084865544528988116434879522*z))
             + z*(30850.970811305111991357407185107
             + z*(-88696.541082502196975152545657181
             + 65986.79867973593398151445425703*z))))
             + x*(1499.6999699939984995798739603871
             + z*(-29137.027988454827991837551230378
             + z*(127260.25459663358696434930463856
             + z*(-191961.59615923180794622386692955
             + 92981.398139627906973952185544*z)))
             + y*(-21852.770991341120993878163422784
             + y*(70700.141442574214980194058132536
             + z*(-987231.06596176358372343702992341
             + (2.7495927735575681062297289153726e6
             - 1.979603960392078019445433627711e6*z)*z)
             + y*(-95980.798079615903973111933464776
             + y*(59773.755946903654483254976421144
             - 14140.028288514842996038811626507*y
             - 282800.56577029685992077623253014*z)
             + (903247.86764209966774696408814173
             - 1.2726025459663358696434930463856e6*z)*z))
             + z*(395920.7920784156038890867255422
             + z*(-1.6042504821878658235505851736255e6
             + (2.231553555351069767374852453056e6
             - 989801.9801960390097227168138555*z)*z)))
             + x*(-11997.599759951987996638991683097
             + z*(210814.96721058493194094228243156
             + z*(-821407.09785099860676989096630346
             + (1.0857827782756549136958287473203e6
             - 449909.99099819954987396218811614*z)*z))
             + y*(158111.22540793869895570671182367
             + z*(-2.5554887488697734432841052284997e6
             + z*(9.0740417898751160644579973883195e6
             + z*(-1.0797839783956789196975092514787e7
             + 3.959207920784156038890867255422e6*z)))
             + y*(-456337.27658388811487216164794637
             + y*(542891.38913782745684791437366014
             + y*(-289227.85135598542491897569236037
             + 56560.11315405937198415524650603*y
             + 1.1312022630811874396831049301206e6*z)
             + z*(-4.3705541982682241987756326845568e6
             + 5.090410183865343478573972185543e6*z))
             + z*(5.5840257168462252704356907005043e6
             + z*(-1.3304481162375329546272881848577e7
             + 7.918415841568312077781734510844e6*z))))
             + x*(38992.199219843960989076722970065
             + z*(-569029.01718629428784059217696974
             + z*(1.7392234794873256885127738300604e6
             + z*(-1.6196759675935183795462638772181e6
             + 359927.99279855963989916975049291*z)))
             + x*(-64487.098709741935481934580296646
             + z*(720712.95700854442179809942896318
             + z*(-1.5039848270511242095786736002739e6
             + 719855.9855971192797983395009858*z))
             + x*(57888.418841768342083783134870943
             + x*(-26994.599459891972992437731286968
             + 5141.828468550851998559567864184*x
             + 77127.42702826277997839351796277*y
             + 102836.56937101703997119135728369*z)
             + z*(-437055.41982682241987756326845568
             + 462764.5621695766798703611077766*z)
             + y*(-327791.56487011681490817245134176
             + 257091.42342754259992797839320922*y
             + 1.4397119711942385595966790019716e6*z))
             + y*(540534.71775640831634857457172239
             + y*(-835547.12613951344976592977792997
             + 359927.99279855963989916975049291*y
             + 3.7021164973566134389628888622128e6*z)
             + z*(-4.6790639063812753186892067564078e6
             + 6.015939308204496838314694401096e6*z)))
             + y*(-426771.76288972071588044413272731
             + z*(5.4109174917383465864841852490767e6
             + z*(-1.3535863443460117886208062402466e7
             + 8.63827182716543135758007401183e6*z))
             + y*(966235.26638184760472931879447799
             + y*(-809837.98379675918977313193860905
             + 231382.2810847883399351805538883*y
             + 3.4964433586145793590205061476454e6*z)
             + z*(-8.3297621190523802376664999399788e6
             + 1.0643584929900263637018305478862e7*z))))));
          case ( 104 ):
            return -47.370877129308044933170959823702
             + z*(1421.1263138792413479951287947111
             + z*(-9947.8841971546894359659015629774
             + z*(26527.691192412505162575737501273
             + z*(-29843.652591464068307897704688932
             + 11937.461036585627323159081875573*z))))
             + y*(236.85438564654022466585479911851
             + y*(-473.70877129308044933170959823702
             + y*(473.70877129308044933170959823702
             + y*(-236.85438564654022466585479911851
             + 47.370877129308044933170959823702*y
             + 1421.1263138792413479951287947111*z)
             + z*(-5684.5052555169653919805151788442
             + 9947.884197154689435965901562977*z))
             + z*(8526.7578832754480879707727682663
             + z*(-29843.652591464068307897704688932
             + 26527.691192412505162575737501273*z)))
             + z*(-5684.5052555169653919805151788442
             + z*(29843.652591464068307897704688932
             + z*(-53055.382384825010325151475002546
             + 29843.652591464068307897704688932*z))))
             + x*(1657.9806995257815726609835938296
             + z*(-48318.294671894205831834379020176
             + z*(328280.17850610475138687475157825
             + z*(-848886.11815720016520242360004074
             + (925153.2303353861175448288453569
             - 358123.83109756881969477245626719*z)*z)))
             + y*(-8053.0491119823676386390631700293
             + z*(187588.67343205985793535700090186
             + z*(-954996.88292685018585272655004583
             + (1.6447168539295753200796957250789e6
             - 895309.577743922049236931140668*z)*z))
             + y*(15632.389452671654827946416741822
             + z*(-272856.25226481433881506472858452
             + (925153.2303353861175448288453569
             - 795830.7357723751548772721250382*z)*z)
             + y*(-15158.680681378574378614707143585
             + y*(7342.4859550427469646414987726738
             - 1421.1263138792413479951287947111*y
             - 42633.789416377240439853863841332*z)
             + (176219.66292102592715139597054417
             - 298436.52591464068307897704688932*z)*z)))
             + x*(-13263.845596206252581287868750637
             + z*(349597.07321429337160680168349892
             + z*(-2.1188993339939488498607370329142e6
             + z*(4.8015121058266634344262084877304e6
             + z*(-4.4765478887196102461846557033398e6
             + 1.4324953243902752787790898250687e6*z))))
             + y*(58266.178869048895267800280583153
             + y*(-100899.96828542613570765414442448
             + y*(85741.2876040475613290394372809
             + y*(-35528.157846981033699878219867776
             + 5684.505255516965391980515178844*y
             + 170535.15766550896175941545536533*z)
             + z*(-852675.78832754480879707727682663
             + 1.1937461036585627323159081875573e6*z))
             + z*(1.5433431768728561039227098710562e6
             + z*(-4.4765478887196102461846557033398e6
             + 3.1833229430895006195090885001528e6*z)))
             + z*(-1.2107996194251136284918497330938e6
             + z*(5.4017011190549963637294845486967e6
             + z*(-7.9583073577237515487727212503819e6
             + 3.5812383109756881969477245626719e6*z))))
             + x*(43107.498187670320889185573439569
             + z*(-943627.87241581625506876551968814
             + z*(4.4864957729167649356206216049028e6
             + z*(-7.1624766219513763938954491253437e6
             + 3.5812383109756881969477245626719e6*z)))
             + x*(-71293.170079608607624422294534671
             + x*(63998.055001695168704713966721821
             + x*(-29843.652591464068307897704688932
             + 5684.505255516965391980515178844*x
             + 28422.526277584826959902575894221*y
             + 170535.15766550896175941545536533*z)
             + y*(-120795.73667973551457958594755044
             + 56845.05255516965391980515178844*y
             + 682140.6306620358470376618214613*z)
             + z*(-724774.42007841308747751568530264
             + 1.1937461036585627323159081875573e6*z))
             + z*(1.195167229972441973663903316352e6
             + z*(-3.8796748368903288800267016095612e6
             + 3.1833229430895006195090885001528e6*z))
             + y*(199194.53832874032894398388605867
             + y*(-184746.42080430137523936674331244
             + 56845.05255516965391980515178844*y
             + 1.023210945993053770556492732192e6*z)
             + z*(-2.2169570496516165028724009197492e6
             + 3.5812383109756881969477245626719e6*z)))
             + y*(-157271.31206930270917812758661469
             + y*(213642.6558531792826486010288049
             + y*(-127901.36824913172131956159152399
             + 28422.526277584826959902575894221*y
             + 682140.6306620358470376618214613*z)
             + z*(-2.3022246284843709837521086474319e6
             + 3.5812383109756881969477245626719e6*z))
             + z*(2.5637118702381513917832123456587e6
             + z*(-8.0577861996952984431323802660117e6
             + 6.366645886179001239018177000306e6*z))))));
          case ( 105 ):
            return -15.427248620541512489078780537089
             + y*(740.50793378599259947578146578026
             + y*(-8330.7142550924167441025414900279
             + y*(37025.396689299629973789073289013
             + y*(-76364.880671680486820939963658589
             + (73310.285444813267348102365112246
             - 26473.158632849235431259187401644*y)*y))))
             + x*(339.39946965191327475973317181595
             + y*(-15550.666609505844588991410781385
             + y*(166614.28510184833488205082980056
             + y*(-703482.53709669296950199239249125
             + y*(1.3745678520902487627769193458546e6
             + y*(-1.2462748525618255449177402069082e6
             + 423570.53812558776690014699842631*y)))))
             + x*(-1712.4245968801078862877446396169
             + y*(66645.714040739333952820331920224
             + y*(-583149.99785646917208717790430196
             + y*(1.8882952311542811286632427377397e6
             + y*(-2.5200410621654560650910188007335e6
             + 1.1729645671170122775696378417959e6*y))))
             + x*(4011.0846413407932471604829396431
             + x*(-5168.1282878814066838413914799247
             + x*(3795.1031606532120723133800121238
             + x*(-1496.4431161925267114406417120976
             + 246.83597792866419982526048859342*x
             + 11848.126940575881591612503452484*y)
             + y*(-59981.142636665400557538298728201
             + 133291.42808147866790564066384045*y))
             + y*(122183.80907468877891350394185374
             + y*(-541496.42658100708836666519685182
             + 592406.3470287940795806251726242*y)))
             + y*(-125886.34874361874191088284918264
             + y*(833071.42550924167441025414900279
             + y*(-1.8142444377756818687156645911616e6
             + 1.2218380907468877891350394185374e6*y))))));
          case ( 106 ):
            return -26.720778431774774925538166179159
             + 53.44155686354954985107633235832*z
             + y*(1229.1558078616396465747556442413
             - 2404.8700588597297432984349561244*z
             + y*(-13226.785323728513588141392258684
             + 24048.700588597297432984349561244*z
             + y*(56113.634706727027343630148976235
             - 88178.56882485675725427594839123*z
             + y*(-110223.21103107094656784493548903
             + y*(100523.568460336703269874581166
             - 34389.641841694135329167619872578*y
             - 68779.28368338827065833523974516*z)
             + 132267.85323728513588141392258684*z))))
             + x*(587.85712549904504836183965594151
             - 1122.2726941345405468726029795247*z
             + y*(-25812.271965094432578069868529068
             + 48097.401177194594865968699122487*z
             + y*(264535.70647457027176282784517368
             - 456925.31118334865122670264166363*z
             + y*(-1.0661590594278135195289728305485e6
             + 1.5872142388474216305769670710421e6*z
             + y*(1.9840177985592770382212088388026e6
             - 2.2485535050338473099840366839763e6*z
             + y*(-1.708900663825723955587867879822e6
             + 550234.2694671061652666819179613*y
             + 1.1004685389342123305333638359225e6*z)))))
             + x*(-2966.0064059270000167347364458867
             + 4809.7401177194594865968699122487*z
             + x*(6947.4023922614414806399232065815
             - 9085.064666803423474682976500914*z
             + x*(-8951.4607746445496000552856700184
             + 8817.856882485675725427594839123*z
             + x*(6573.3114942165946316823888800732
             - 4328.7661059475135379371829210238*z
             + x*(-2591.9155078821531677772021193785
             + 427.53245490839639880861065886655*x
             + 19666.492925786234345196090307861*y
             + 855.0649098167927976172213177331*z)
             + y*(-99561.620436792811372555207183548
             + 211628.56517965621741026227613894*y
             + 38477.92094175567589277495929799*z))
             + y*(202810.70829717054168483468129982
             - 156316.55382588243331439827214808*z
             + y*(-859741.04604235338322919049681446
             + 897818.1553076324374980823836198*y
             + 384779.2094175567589277495929799*z)))
             + y*(-208956.48733647873991770845952103
             + 240487.00588597297432984349561244*z
             + y*(1.3226785323728513588141392258684e6
             - 1.1783863288412675742162331285009e6*z
             + y*(-2.7495681006296243398378772998355e6
             + 1.7635713764971351450855189678245e6*y
             + 1.4108571011977081160684151742596e6*z))))
             + y*(110624.02270754756819172800798172
             - 168340.9041201810820308904469287*z
             + y*(-925874.97266099595116989745810788
             + 1.2264837300184621690822018276234e6*z
             + y*(2.861795370043078394525137597788e6
             - 2.9098927712202729893911062969105e6*z
             + y*(-3.6373659640253412367388828711381e6
             + 1.608377095365387252317993298656e6*y
             + 2.1162856517965621741026227613894e6*z))))));
          case ( 107 ):
            return -34.496376621320680380463909187988
             + (206.97825972792408228278345512793
             - 206.97825972792408228278345512793*z)*z
             + y*(1448.8478180954685759794841858955
             + z*(-8486.1086488448873735941216602452
             + 8279.130389116963291311338205117*z)
             + y*(-14178.010791362799636370666676263
             + (76581.956099331910444629878397334
             - 68302.82571021494715331854019222*z)*z
             + y*(54504.275061686675001132976517022
             + z*(-250443.6942707881395621679807048
             + 182140.86856057319240884944051258*z)
             + y*(-96762.336422804508467201265272308
             + y*(79686.629995250771678871630224253
             - 24664.909284244286472031695069412*y
             - 147989.45570546571883219017041647*z)
             + (330130.32426603891124103961092905
             - 147989.45570546571883219017041647*z)*z))))
             + x*(758.92028566905496837020600213575
             + z*(-4346.5434542864057279384525576865
             + 4139.5651945584816456556691025586*z)
             + y*(-30425.804180004840095569167903806
             + (169722.1729768977474718824332049
             - 157303.47739322230253491542589723*z)*z
             + y*(283560.21582725599272741333352527
             + z*(-1.4550571658873062984479676895494e6
             + 1.2294508627838690487597337234599e6*z)
             + y*(-1.0355812261720468250215265538234e6
             + (4.5079864968741865121190236526863e6
             - 3.0963947655297442709504404887138e6*z)*z
             + y*(1.7417220556104811524096227749015e6
             + z*(-5.6122155125226614910976733857938e6
             + 2.3678312912874515013150427266635e6*z)
             + y*(-1.3546727099192631185408177138123e6
             + 394638.54854790858355250712111059*y
             + 2.3678312912874515013150427266635e6*z)))))
             + x*(-3829.0978049665955222314939198667
             + (18628.043375513167405450510961514
             - 14488.478180954685759794841858955*z)*z
             + x*(8969.057921543376898920616388877
             + z*(-35186.304153747093988073187371748
             + 20697.825972792408228278345512793*z)
             + x*(-11556.286168142427927455409577976
             + (34151.412855107473576659270096109
             - 13453.586882315065348380924583316*z)*z
             + x*(8486.1086488448873735941216602452
             + z*(-16765.239037961850664905459865362
             + 3311.6521556467853165245352820469*z)
             + x*(-3346.1485322681059969049991912349
             + 551.9420259411308860874225470078*x
             + 23181.565089527497215671746974328*y
             + 3311.6521556467853165245352820469*z)
             + y*(-117356.67326573295465433821905754
             + 226848.17266180479418193066682021*y
             + 135777.73838151819797750594656392*z))
             + y*(239059.88998575231503661489067276
             + z*(-551597.06217491767928361790791594
             + 132466.08622587141266098141128188*z)
             + y*(-921570.70143858197636409333395711
             + 872068.4009869868000181276242723*y
             + 1.2253112975893105671140780543574e6*z)))
             + y*(-246304.12907622965791651231160224
             + (848610.86488448873735941216602452
             - 405677.38906673120127425557205074*z)*z
             + y*(1.4178010791362799636370666676263e6
             + z*(-3.7525158488672636117868640414694e6
             + 1.0928452113634391544530966430755e6*z)
             + y*(-2.6707094780226470750555158493341e6
             + 1.5481973827648721354752202443569e6*y
             + 4.0070991083326102329946876912767e6*z))))
             + y*(130396.3036285921718381535767306
             + z*(-594027.60541914211615158851621716
             + 422235.64984496512785687824846098*z)
             + y*(-992460.75539539597454594666733843
             + (3.9056797610659274326761237982641e6
             - 2.2539932484370932560595118263432e6*z)*z
             + y*(2.7797180281460204250577818023681e6
             + z*(-8.2646419109360086055515433632583e6
             + 2.9142538969691710785415910482013e6*z)
             + y*(-3.1931571019525487794176417539862e6
             + 1.2749860799240123468619460835881e6*y
             + 5.282085188256622579856633774865e6*z))))));
          case ( 108 ):
            return -40.816663263917103296119070142819
             + z*(489.79995916700523955342884171383
             + z*(-1224.4998979175130988835721042846
             + 816.3332652783420659223814028564*z))
             + y*(1469.3998775010157186602865251415
             + z*(-17142.998570845183384370009459984
             + (41632.996529195445362041451545675
             - 26938.997754185288175438586294261*z)*z)
             + y*(-12244.998979175130988835721042846
             + z*(129796.98917925638848165864305416
             + z*(-282859.47641894552584210515608974
             + 161633.98652511172905263151776556*z))
             + y*(40000.329998638761230196688739963
             + y*(-60612.744946916898394736819162086
             + y*(43102.396406696461080701738070817
             - 11673.565693480291542690054060846*y
             - 140082.78832176349851228064873016*z)
             + (377145.96855859403445614020811965
             - 350206.97080440874628070162182539*z)*z)
             + z*(-350206.97080440874628070162182539
             + (592657.95059207633985964889847373
             - 233471.31386960583085380108121693*z)*z))))
             + x*(897.96659180617627251461954314202
             + z*(-10285.79914250711003062200567599
             + (24489.997958350261977671442085691
             - 15510.332040288499252525246654271*z)*z)
             + y*(-30857.397427521330091866017027971
             + z*(342859.97141690366768740018919968
             + z*(-791026.93405471346187878757936783
             + 484901.95957533518715789455329669*z))
             + y*(244899.97958350261977671442085691
             + z*(-2.4661427944058713811515142180291e6
             + (5.0914705755410194651578928096153e6
             - 2.7477777709268993938947358020146e6*z)*z)
             + y*(-760006.26997413646337373708605929
             + z*(6.303725474479357433052629192857e6
             + z*(-1.0075185160065297777614031274053e7
             + 3.7355410219136932936608172994708e6*z))
             + y*(1.0910294090445041711052627449176e6
             + y*(-732740.73891383983837192954720389
             + 186777.05109568466468304086497354*y
             + 2.2413246131482159761964903796825e6*z)
             + z*(-6.411481465496098585754383538034e6
             + 5.603311532870539940491225949206e6*z)))))
             + x*(-4530.6496222947984658692167858529
             + z*(44081.996325030471559808595754245
             + z*(-85714.99285422591692185004729992
             + 41632.996529195445362041451545675*z))
             + x*(10612.332448618446856990958237133
             + z*(-83265.993058390890724082903091351
             + (122449.98979175130988835721042846
             - 40000.329998638761230196688739963*z)*z)
             + x*(-13673.582193412229604199888497844
             + z*(80816.993262555864526315758882782
             + z*(-79592.493364638351427432186778497
             + 13061.332244453473054758102445702*z))
             + x*(10040.899162923607410845291255133
             + x*(-3959.2163365999590197235498038535
             + 653.0666122226736527379051222851*x
             + 23510.398040016251498564584402264*y
             + 7836.799346672083832854861467421*z)
             + z*(-39673.79669252742440382773617882
             + 19591.998366680209582137153668553*z)
             + y*(-119021.39007758227321148320853646
             + 195919.98366680209582137153668553*y
             + 274287.97713352293414992015135974*z))
             + y*(242450.97978766759357894727664835
             + z*(-1.114294907104936919984050614899e6
             + 666127.9444671271257926632247308*z)
             + y*(-795924.93364638351427432186778497
             + 640005.2799782201796831470198394*y
             + 2.0767518268681022157065382888666e6*z)))
             + y*(-249797.97917517267217224870927405
             + z*(1.7142998570845183384370009459984e6
             + z*(-2.0400168299305768227400311257381e6
             + 431023.96406696461080701738070817*z))
             + y*(1.2244998979175130988835721042846e6
             + z*(-6.3600524697835630356012735096541e6
             + 4.5257516227031284134736824974358e6*z)
             + y*(-1.9600161699332993002796377482582e6
             + 969803.9191506703743157891065934*y
             + 5.603311532870539940491225949206e6*z))))
             + y*(132245.98897509141467942578726273
             + z*(-1.2000098999591628369059006621989e6
             + (2.1232828229889677134641140288294e6
             - 888986.9258881145097894733477106*z)*z)
             + y*(-857149.9285422591692185004729992
             + z*(6.6196464481420758125645907957624e6
             + z*(-9.3343627218252023527894701509613e6
             + 2.586143784401787664842104284249e6*z))
             + y*(2.0400168299305768227400311257381e6
             + y*(-2.0002205832482576470263150323488e6
             + 689638.3425071433772912278091331*y
             + 6.034335496937504551298243329914e6*z)
             + z*(-1.1556830036545488627263153520238e7
             + 9.48252720947322143775438237558e6*z))))));
          case ( 109 ):
            return -46.281745861624537467236341611266
             + z*(925.63491723249074934472683222533
             + z*(-4165.357127546208372051270745014
             + (6479.4444206274352454130878255773
             - 3239.7222103137176227065439127886*z)*z))
             + y*(1295.8888841254870490826175651155
             + z*(-24992.142765277250232307624470084
             + z*(108299.28531620141767333303937036
             + z*(-161986.11051568588113532719563943
             + 77753.33304752922294495705390693*z)))
             + y*(-8330.7142550924167441025414900279
             + y*(21289.603096347287234928717141183
             + z*(-284169.91959037466004883113749318
             + (749764.28295831750696922873410252
             - 505396.664808939949142220850395*z)*z)
             + y*(-26149.186411817863668988533010365
             + y*(15550.666609505844588991410781385
             - 3609.9761772067139224444346456788*y
             - 72199.52354413427844888869291358*z)
             + (238813.80864598261333093952271413
             - 324897.85594860425301999911811109*z)*z))
             + z*(141622.14233657108464974320533048
             + z*(-529000.35519836846325051138461677
             + (660903.33090399839503213495820888
             - 252698.33240446997457111042519751*z)*z))))
             + x*(1018.1984089557398242791995154479
             + z*(-19438.333261882305736239263476732
             + z*(83307.142550924167441025414900279
             + z*(-123109.44399192126966284866868597
             + 58314.9997856469172087177904302*z)))
             + y*(-27213.666566635228030734968867425
             + z*(499842.85530554500464615248940168
             + z*(-2.0576864210078269357933277480369e6
             + (2.9157499892823458604358895215098e6
             - 1.3218066618079967900642699164178e6*z)*z))
             + y*(166614.28510184833488205082980056
             + z*(-2.690820704394850608345120901279e6
             + z*(9.5220063935706323385092049231019e6
             + z*(-1.1235356625367972715546294289551e7
             + 4.0431733184715195931377668031602e6*z)))
             + y*(-404502.45883059845746364562568247
             + y*(470685.35541272154604179359418658
             + y*(-264361.33236159935801285398328355
             + 57759.61883530742275911095433086*y
             + 1.1551923767061484551822190866172e6*z)
             + z*(-4.0598347469817044266259718861403e6
             + 5.198365695177668048319985889777e6*z))
             + z*(5.1150585526267438808789604748772e6
             + z*(-1.2745992810291397618476888479743e7
             + 8.08634663694303918627553360632e6*z)))))
             + x*(-5137.2737906403236588632339188506
             + z*(83307.142550924167441025414900279
             + z*(-291574.99892823458604358895215098
             + (330451.66545199919751606747910444
             - 106910.83294035268154931594912203*z)*z))
             + x*(12033.253924022379741481448818929
             + z*(-157357.93592952342738860356147831
             + z*(416535.7127546208372051270745014
             + z*(-317492.77661074432702524130345329
             + 51835.55536501948196330470260462*z)))
             + x*(-15504.384863644220051524174439774
             + z*(152729.76134336097364187992731718
             + z*(-270748.21329050354418333259842591
             + 103671.11073003896392660940520924*z))
             + x*(11385.309481959636216940140036372
             + x*(-4489.3293485775801343219251362928
             + 740.5079337859925994757814657803*x
             + 20734.222146007792785321881041847*y
             + 14810.158675719851989515629315605*z)
             + z*(-74976.428295831750696922873410252
             + 66645.71404073933395282033192022*z)
             + y*(-104966.99961416445097569202277435
             + 133291.42808147866790564066384045*y
             + 399874.28424443600371692199152134*z))
             + y*(213821.66588070536309863189824405
             + z*(-1.6244892797430212650999955905554e6
             + 1.7327885650592226827733286299258e6*z)
             + y*(-541496.42658100708836666519685182
             + 340633.64954155659575885947425892*y
             + 2.2659542773851373543958912852876e6*z)))
             + y*(-220301.11030133279834404498606963
             + z*(2.4992142765277250232307624470084e6
             + z*(-5.3066649804938694659933189291478e6
             + 2.5917777682509740981652351302309e6*z))
             + y*(833071.42550924167441025414900279
             + y*(-1.0431905517210170745115071399179e6
             + 418386.98258908581870381652816585*y
             + 4.5467187134459945607812981998908e6*z)
             + z*(-6.9394849744919831478374170611933e6
             + 8.464005683173895412008182153868e6*z))))
             + y*(116629.99957129383441743558086039
             + z*(-1.7494499935694075162615337129059e6
             + z*(5.5232635511262723013399850078885e6
             + z*(-5.3455416470176340774657974561013e6
             + 1.2440533287604675671193128625108e6*z)))
             + y*(-583149.99785646917208717790430196
             + z*(7.2227292591651253171369034718542e6
             + z*(-1.7457011721546159287266875692354e7
             + 1.0574453294463974320514159331342e7*z))
             + y*(1.0857697579137116489813645742003e6
             + y*(-862923.15158998950107662158934206
             + 248810.66575209351342386257250217*y
             + 3.8210209383357218132950323634262e6*z)
             + z*(-9.3776073464823637816114275372748e6
             + 1.199622852733308011150765974564e7*z))))));
          case ( 110 ):
            return -51.166395221864125377372295532386
             + z*(1534.9918566559237613211688659716
             + z*(-10744.942996591466329248182061801
             + z*(28653.181324243910211328485498136
             + z*(-32234.828989774398987744546185403
             + 12893.931595909759595097818474161*z))))
             + y*(920.99511399355425679270131958295
             + z*(-26094.861563150703942459870721517
             + z*(171919.08794546346126797091298882
             + z*(-429797.71986365865316992728247205
             + (451287.60585684158582842364659565
             - 167621.1107468268747362716401641*z)*z)))
             + y*(-3837.479641639809403302922164929
             + z*(89029.527686043578156627794226352
             + z*(-451287.60585684158582842364659565
             + (773635.89575458557570586910844968
             - 419052.77686706718684067910041024*z)*z))
             + y*(7163.2953310609775528321213745341
             + z*(-125869.33224578574842833584700967
             + (429797.71986365865316992728247205
             - 372491.35721517083274727031147577*z)*z)
             + y*(-6907.4633549516569259452598968722
             + y*(3376.9820846430322749065715051375
             - 665.163137884233629905839841921*y
             - 19954.894136527008897175195257631*z)
             + (81354.568402763959350021949896494
             - 139684.25895568906228022636680341*z)*z))))
             + x*(1125.6606948810107583021905017125
             + z*(-32234.828989774398987744546185403
             + z*(214898.85993182932658496364123602
             + z*(-544410.44516063429401524122446459
             + (580226.92181593918177940183133726
             - 219196.83713046591311666291406074*z)*z)))
             + y*(-19340.897393864639392646727711242
             + z*(521897.23126301407884919741443034
             + z*(-3.2664626709638057640914473467875e6
             + z*(7.7363589575458557570586910844968e6
             + z*(-7.671889299566306959083201992126e6
             + 2.6819377719492299957803462426256e6*z))))
             + y*(76749.592832796188066058443298579
             + y*(-136102.61129015857350381030611615
             + y*(124334.3403891298246670146781437
             + y*(-57408.695438931548673411715587337
             + 10642.610206147738078493437470736*y
             + 319278.30618443214235480312412209*z)
             + z*(-1.3830276628469873089503731482404e6
             + 2.2349481432910249964836218688546e6*z))
             + z*(2.2656479804241434717100452461741e6
             + z*(-7.3065612376821971038887638020248e6
             + 5.959861715442733323956324983612e6*z)))
             + z*(-1.6915610260348279849759280903007e6
             + z*(8.1231769054231485449116256387217e6
             + z*(-1.3151810227827954786999774843645e7
             + 6.704844429873074989450865606564e6*z)))))
             + x*(-5679.4698696269179168883248040949
             + z*(138149.26709903313851890519793744
             + z*(-752146.00976140264304737274432608
             + z*(1.461312247536439420777752760405e6
             + z*(-1.0637493566625551665955700241183e6
             + 206302.90553455615352156509558658*z))))
             + x*(13303.26275768467259811679683842
             + z*(-260948.61563150703942459870721517
             + z*(1.0744942996591466329248182061801e6
             + z*(-1.4040058848879516003550957894087e6
             + 515757.2638363903838039127389665*z)))
             + x*(-17140.742399324482001419719003349
             + x*(12586.933224578574842833584700967
             + x*(-4963.1403365208201616051126666415
             + 818.6623235498260060379567285182*x
             + 14735.921823896868108683221113327*y
             + 24559.869706494780181138701855545*z)
             + z*(-124334.3403891298246670146781437
             + 171919.08794546346126797091298882*z)
             + y*(-74600.604233477894800208806886219
             + 61399.67426623695045284675463886*y
             + 417517.78501041126307935793154427*z))
             + z*(253273.65634822742061799286288531
             + z*(-698421.29477844531140113183401707
             + 458450.90118790256338125576797018*z))
             + y*(151964.19380893645237079571773119
             + y*(-249436.17670658761121468994072038
             + 114612.72529697564084531394199255*y
             + 1.4244724429766972505060447076216e6*z)
             + z*(-1.6961660016047957562598915968986e6
             + 2.7507054071274153802875346078211e6*z)))
             + y*(-156569.1693789042236547592243291
             + z*(2.6094861563150703942459870721517e6
             + z*(-8.4240353093277096021305747364521e6
             + 6.876763517818538450718836519553e6*z))
             + y*(383747.9641639809403302922164929
             + y*(-351001.47122198790008877394735217
             + 110519.41367922651081512415834995*y
             + 2.0139093159325719748533735521547e6*z)
             + z*(-4.3624468566161353296747619170913e6
             + 7.22060169370946537325477834553e6*z))))
             + y*(82889.560259419883111343118762466
             + z*(-1.8266403094205492759721909505062e6
             + z*(8.7678734852186365246665165624297e6
             + z*(-1.4183324755500735554607600321577e7
             + 7.22060169370946537325477834553e6*z)))
             + y*(-268623.57491478665823120455154503
             + y*(365328.06188410985519443819010124
             + y*(-227946.29071340467855619357659678
             + 54031.7133542885163985051440822*y
             + 1.3016730944442233496003511983439e6*z)
             + z*(-4.1536879641109296981350829513191e6
             + 6.876763517818538450718836519553e6*z))
             + z*(4.540505911988222485988017505544e6
             + z*(-1.4892490993275772332337980337656e7
             + 1.2378174332073369211293905735195e7*z))))));
          case ( 111 ):
            return -55.623735940693519727645958532027
             + z*(2336.1969095091278285611302583452
             + z*(-23361.969095091278285611302583452
             + z*(93447.876380365113142445210333806
             + z*(-175214.76821318458714208476937589
             + (154188.99602760243668503459705078
             - 51396.33200920081222834486568359*z)*z))))
             + y*(333.74241564416111836587575119216
             + z*(-11680.984547545639142805651291726
             + z*(93447.876380365113142445210333806
             + z*(-280343.62914109533942733563100142
             + (350429.53642636917428416953875177
             - 154188.99602760243668503459705078*z)*z)))
             + y*(-834.35603911040279591468937798041
             + z*(23361.969095091278285611302583452
             + z*(-140171.81457054766971366781550071
             + (280343.62914109533942733563100142
             - 175214.76821318458714208476937589*z)*z))
             + y*(1112.4747188138703945529191706405
             + z*(-23361.969095091278285611302583452
             + (93447.876380365113142445210333806
             - 93447.87638036511314244521033381*z)*z)
             + y*(-834.35603911040279591468937798041
             + y*(333.74241564416111836587575119216
             - 55.62373594069351972764595853203*y
             - 2336.1969095091278285611302583452*z)
             + (11680.984547545639142805651291726
             - 23361.969095091278285611302583452*z)*z))))
             + x*(1223.7221906952574340082110877046
             + z*(-49060.135099691684399783735425248
             + z*(467239.38190182556571222605166903
             + z*(-1.7755096512269371497064589963423e6
             + z*(3.153865827837322568557525848766e6
             + z*(-2.6212129324692414236455881498633e6
             + 822341.3121472129956535178509375*z)))))
             + y*(-7008.5907285273834856833907750355
             + z*(233619.69095091278285611302583452
             + z*(-1.7755096512269371497064589963423e6
             + z*(5.0461853245397161096920413580255e6
             + z*(-5.9573021192482759628308821587801e6
             + 2.4670239364416389869605535528125e6*z))))
             + y*(16687.120782208055918293787559608
             + y*(-21137.01965746353749650546424217
             + y*(15018.408703987250326464408803647
             + y*(-5673.6210659507390122198877702668
             + 889.9797750510963156423353365124*y
             + 37379.150552146045256978084133522*z)
             + z*(-198576.73730827586542769607195934
             + 373791.50552146045256978084133522*z))
             + z*(420515.44371164300914100344650213
             + z*(-1.5886138984662069234215685756747e6
             + 1.4951660220858418102791233653409e6*z)))
             + z*(-443877.41280673428742661474908558
             + z*(2.5230926622698580548460206790128e6
             + z*(-4.7658416953986207702647057270241e6
             + 2.8034362914109533942733563100142e6*z)))))
             + x*(-6174.234689416980689768701397055
             + z*(210257.72185582150457050172325106
             + z*(-1.6353378366563894799927911808416e6
             + z*(4.7658416953986207702647057270241e6
             + z*(-5.7820873510350913756887973894042e6
             + 2.4670239364416389869605535528125e6*z))))
             + x*(14462.171344580315129187949218327
             + x*(-18633.951540132329108761396108229
             + x*(13683.439041410605853000905798879
             + x*(-5395.5023862472714135816579776067
             + 889.9797750510963156423353365124*x
             + 5339.878650306577893854012019075*y
             + 37379.150552146045256978084133522*z)
             + y*(-27033.135667177050587635935846565
             + 13349.696625766444734635030047687*y
             + 186895.75276073022628489042066761*z)
             + z*(-189231.94967023935411345155092596
             + 373791.50552146045256978084133522*z))
             + z*(385472.49006900609171258649262695
             + z*(-1.5185279911809330885647346679243e6
             + 1.4951660220858418102791233653409e6*z))
             + y*(55067.498581286584530369498946707
             + y*(-54233.142542176181734454809568727
             + 17799.595501021926312846706730249*y
             + 373791.50552146045256978084133522*z)
             + z*(-759263.99559046654428236733396217
             + 1.4951660220858418102791233653409e6*z)))
             + z*(-397153.47461655173085539214391868
             + z*(2.3361969095091278285611302583452e6
             + z*(-4.5789459426378905439798153063565e6
             + 2.8034362914109533942733563100142e6*z)))
             + y*(-56736.210659507390122198877702668
             + y*(83435.603911040279591468937798041
             + y*(-54511.261221879649333093039361387
             + 13349.696625766444734635030047687*y
             + 373791.50552146045256978084133522*z)
             + z*(-1.1447364856594726359949538265891e6
             + 2.2427490331287627154186850480113e6*z))
             + z*(1.1680984547545639142805651291726e6
             + z*(-4.5789459426378905439798153063565e6
             + 4.4854980662575254308373700960227e6*z))))
             + y*(30036.817407974500652928817607295
             + y*(-58404.922737728195714028256458629
             + y*(56736.210659507390122198877702668
             + y*(-27533.749290643292265184749473354
             + 5339.878650306577893854012019075*y
             + 186895.75276073022628489042066761*z)
             + z*(-770944.9801380121834251729852539
             + 1.4951660220858418102791233653409e6*z))
             + z*(1.191460423849655192566176431756e6
             + z*(-4.6256698808280731005510379115234e6
             + 4.4854980662575254308373700960227e6*z)))
             + z*(-817668.9183281947399963955904208
             + z*(4.7658416953986207702647057270241e6
             + z*(-9.2513397616561462011020758230468e6
             + 5.606872582821906788546712620028e6*z))))));
          case ( 112 ):
            return -16.492422502470642199285639423896
             + y*(1039.0226176556504585549952837055
             + y*(-15585.339264834756878324929255582
             + y*(95243.739951767958700874567673001
             + y*(-285731.219855303876102623703019
             + y*(445740.70297427404672009297670965
             + y*(-346687.21342443536967118342632972
             + 106128.73880339858255240308969277*y))))))
             + x*(115.44695751729449539499947596727
             + y*(-6234.1357059339027513299717022328
             + y*(77926.69632417378439162464627791
             + y*(-380974.959807071834803498270692
             + y*(857193.65956591162830787110905701
             + y*(-891481.40594854809344018595341929
             + 346687.21342443536967118342632972*y)))))
             + x*(-346.34087255188348618499842790182
             + x*(577.23478758647247697499737983637
             + x*(-577.23478758647247697499737983637
             + x*(346.34087255188348618499842790182
             + x*(-115.44695751729449539499947596727
             + 16.492422502470642199285639423896*x
             + 1039.0226176556504585549952837055*y)
             + y*(-6234.1357059339027513299717022328
             + 15585.339264834756878324929255582*y))
             + y*(15585.339264834756878324929255582
             + y*(-77926.69632417378439162464627791
             + 95243.739951767958700874567673*y)))
             + y*(-20780.452353113009171099905674109
             + y*(155853.39264834756878324929255582
             + y*(-380974.959807071834803498270692
             + 285731.219855303876102623703019*y))))
             + y*(15585.339264834756878324929255582
             + y*(-155853.39264834756878324929255582
             + y*(571462.43971060775220524740603801
             + y*(-857193.65956591162830787110905701
             + 445740.70297427404672009297670965*y))))));
          case ( 113 ):
            return -28.565713714171399991997599245469
             + 57.13142742834279998399519849094*z
             + y*(1742.5085365644553995118535539736
             - 3427.8856457005679990397119094563*z
             + y*(-25280.65663704168899291787533224
             + 47133.427628382809986796038755024*z
             + y*(149255.85415654556495818745605758
             - 251378.28068470831992957887336013*z
             + y*(-432056.41992684242487896368858772
             + 612734.5591689765298283485038153*z
             + y*(649498.63271911512161804941404423
             - 686262.7062692537134077503242731*z
             + y*(-486102.75027405471366382314636015
             + 142971.39713942785695994798422357*y
             + 285942.79427885571391989596844715*z))))))
             + x*(199.95999599919979994398319471828
             - 342.78856457005679990397119094563*z
             + x*(-599.87998799759939983194958415485
             + 856.9714114251419997599279773641*z
             + x*(999.79997999599899971991597359142
             - 1142.6285485668559996799039698188*z
             + x*(-999.79997999599899971991597359142
             + 856.9714114251419997599279773641*z
             + x*(599.87998799759939983194958415485
             - 342.78856457005679990397119094563*z
             + x*(-199.95999599919979994398319471828
             + 28.565713714171399991997599245469*x
             + 1742.5085365644553995118535539736*y
             + 57.13142742834279998399519849094*z)
             + y*(-10455.051219386732397071121323842
             + 25280.65663704168899291787533224*y
             + 3427.8856457005679990397119094563*z))
             + y*(26137.628048466830992677803309604
             - 17139.428228502839995198559547281*z
             + y*(-126403.2831852084449645893766612
             + 149255.85415654556495818745605758*y
             + 47133.427628382809986796038755024*z)))
             + y*(-34850.170731289107990237071079472
             + 34278.856457005679990397119094563*z
             + y*(252806.5663704168899291787533224
             - 188533.7105135312399471841550201*z
             + y*(-597023.4166261822598327498242303
             + 432056.41992684242487896368858772*y
             + 251378.28068470831992957887336013*z))))
             + y*(26137.628048466830992677803309604
             - 34278.856457005679990397119094563*z
             + y*(-252806.5663704168899291787533224
             + 282800.56577029685992077623253014*z
             + y*(895535.12493927338974912473634546
             - 754134.8420541249597887366200804*z
             + y*(-1.2961692597805272746368910657632e6
             + 649498.6327191151216180494140442*y
             + 612734.5591689765298283485038153*z)))))
             + y*(-10455.051219386732397071121323842
             + 17139.428228502839995198559547281*z
             + y*(126403.2831852084449645893766612
             - 188533.7105135312399471841550201*z
             + y*(-597023.4166261822598327498242303
             + 754134.8420541249597887366200804*z
             + y*(1.2961692597805272746368910657632e6
             - 1.2254691183379530596566970076306e6*z
             + y*(-1.2989972654382302432360988280885e6
             + 486102.75027405471366382314636015*y
             + 686262.7062692537134077503242731*z))))));
          case ( 114 ):
            return -36.878177829171549240009097127051
             + (221.26906697502929544005458276231
             - 221.26906697502929544005458276231*z)*z
             + y*(2102.0561362627783066805185362419
             + z*(-12391.067750601640544643056634689
             + 12169.798683626611249203002051927*z)
             + y*(-28433.075106291264464047013884956
             + (158207.38288714594623963902667505
             - 146037.58420351933499043602462312*z)*z
             + y*(156179.08310654151103143852633306
             + z*(-778867.11575210311994899213132332
             + 632829.5315485837849585561067002*z)
             + y*(-419858.05458511808809750357079148
             + (1.7402812117586054086360292934255e6
             - 1.1074516802100216236774731867253e6*z)*z
             + y*(585367.31668244000108666439869768
             + z*(-1.7719226883360345978839570987606e6
             + 664471.0081260129742064839120352*z)
             + y*(-406065.61607700792868174016846596
             + 110745.16802100216236774731867253*y
             + 664471.0081260129742064839120352*z))))))
             + x*(258.14724480420084468006367988936
             + z*(-1327.6144018501757726403274965738
             + 1106.3453348751464772002729138115*z)
             + x*(-774.44173441260253404019103966807
             + (3319.0360046254394316008187414346
             - 2212.6906697502929544005458276231*z)*z
             + x*(1290.7362240210042234003183994468
             + z*(-4425.3813395005859088010916552461
             + 2212.6906697502929544005458276231*z)
             + x*(-1290.7362240210042234003183994468
             + (3319.0360046254394316008187414346
             - 1106.3453348751464772002729138115*z)*z
             + x*(774.44173441260253404019103966807
             + z*(-1327.6144018501757726403274965738
             + 221.26906697502929544005458276231*z)
             + x*(-258.14724480420084468006367988936
             + 36.878177829171549240009097127051*x
             + 2102.0561362627783066805185362419*y
             + 221.26906697502929544005458276231*z)
             + y*(-12612.336817576669840083111217452
             + 28433.075106291264464047013884956*y
             + 12391.067750601640544643056634689*z))
             + y*(31530.842043941674600207778043629
             + z*(-61955.338753008202723215283173446
             + 12169.798683626611249203002051927*z)
             + y*(-142165.37553145632232023506942478
             + 156179.08310654151103143852633306*y
             + 158207.38288714594623963902667505*z)))
             + y*(-42041.122725255566133610370724838
             + (123910.67750601640544643056634689
             - 48679.194734506444996812008207708*z)*z
             + y*(284330.75106291264464047013884956
             + z*(-632829.5315485837849585561067002
             + 146037.58420351933499043602462312*z)
             + y*(-624716.33242616604412575410533225
             + 419858.05458511808809750357079148*y
             + 778867.1157521031199489921313233*z))))
             + y*(31530.842043941674600207778043629
             + z*(-123910.67750601640544643056634689
             + 73018.79210175966749521801231156*z)
             + y*(-284330.75106291264464047013884956
             + (949244.2973228756774378341600503
             - 438112.75261055800497130807386937*z)*z
             + y*(937074.49863924906618863115799837
             + z*(-2.33660134725630935984697639397e6
             + 632829.5315485837849585561067002*z)
             + y*(-1.2595741637553542642925107123744e6
             + 585367.3166824400010866643986977*y
             + 1.7402812117586054086360292934255e6*z)))))
             + y*(-12612.336817576669840083111217452
             + (61955.338753008202723215283173446
             - 48679.194734506444996812008207708*z)*z
             + y*(142165.37553145632232023506942478
             + z*(-632829.5315485837849585561067002
             + 438112.75261055800497130807386937*z)
             + y*(-624716.33242616604412575410533225
             + (2.33660134725630935984697639397e6
             - 1.2656590630971675699171122134004e6*z)*z
             + y*(1.2595741637553542642925107123744e6
             + z*(-3.4805624235172108172720585868511e6
             + 1.1074516802100216236774731867253e6*z)
             + y*(-1.1707346333648800021733287973954e6
             + 406065.61607700792868174016846596*y
             + 1.7719226883360345978839570987606e6*z))))));
          case ( 115 ):
            return -43.634848458542857646008617949492
             + z*(523.6181815025142917521034153939
             + z*(-1309.0454537562857293802585384847
             + 872.6969691708571529201723589898*z))
             + y*(2225.3772713856857399464395154241
             + z*(-26180.909075125714587605170769695
             + (64143.227234058000739632668385753
             - 41889.454520201143340168273231512*z)*z)
             + y*(-26835.431802003857452295300038937
             + z*(295844.27254892057483993842969755
             + z*(-675467.45413824343636021340585813
             + 408422.18157196114756664066400724*z))
             + y*(131122.71961792128722625589693822
             + z*(-1.2776283628661348718751323335611e6
             + (2.5186034530270937433276174280447e6
             - 1.2706467871127680146517709546892e6*z)*z)
             + y*(-313516.3861746304321865719199671
             + z*(2.4845682712294303143637307060441e6
             + z*(-3.6928172250464820425817093370655e6
             + 1.1912313629182200137360352700211e6*z))
             + y*(389702.83158324626163650296690691
             + y*(-242217.04379337140279299383823763
             + 59561.56814591100068680176350106*y
             + 714738.8177509320082416211620127*z)
             + z*(-2.1918657077695248252743048968389e6
             + 1.7868470443773300206040529050317e6*z))))))
             + x*(305.44393920980000352206032564644
             + z*(-3141.7090890150857505126204923634
             + (6545.2272687814286469012926924237
             - 3490.7878766834286116806894359593*z)*z)
             + x*(-916.33181762940001056618097693932
             + z*(7854.2727225377143762815512309085
             + z*(-13090.454537562857293802585384847
             + 5236.181815025142917521034153939*z))
             + x*(1527.2196960490000176103016282322
             + z*(-10472.363630050285835042068307878
             + (13090.454537562857293802585384847
             - 3490.7878766834286116806894359593*z)*z)
             + x*(-1527.2196960490000176103016282322
             + z*(7854.2727225377143762815512309085
             + z*(-6545.2272687814286469012926924237
             + 872.6969691708571529201723589898*z))
             + x*(916.33181762940001056618097693932
             + x*(-305.44393920980000352206032564644
             + 43.634848458542857646008617949492*x
             + 2225.3772713856857399464395154241*y
             + 523.6181815025142917521034153939*z)
             + z*(-3141.7090890150857505126204923634
             + 1309.0454537562857293802585384847*z)
             + y*(-13352.263628314114439678637092544
             + 26835.431802003857452295300038937*y
             + 26180.909075125714587605170769695*z))
             + y*(33380.659070785286099196592731361
             + z*(-130904.54537562857293802585384847
             + 64143.22723405800073963266838575*z)
             + y*(-134177.15901001928726147650019469
             + 131122.71961792128722625589693822*y
             + 295844.27254892057483993842969755*z)))
             + y*(-44507.545427713714798928790308481
             + z*(261809.09075125714587605170769695
             + z*(-256572.90893623200295853067354301
             + 41889.454520201143340168273231512*z))
             + y*(268354.31802003857452295300038937
             + z*(-1.1833770901956822993597537187902e6
             + 675467.4541382434363602134058581*z)
             + y*(-524490.87847168514890502358775289
             + 313516.3861746304321865719199671*y
             + 1.2776283628661348718751323335611e6*z))))
             + y*(33380.659070785286099196592731361
             + z*(-261809.09075125714587605170769695
             + (384859.36340434800443779601031452
             - 125668.36356060343002050481969454*z)*z)
             + y*(-268354.31802003857452295300038937
             + z*(1.7750656352935234490396305781853e6
             + z*(-2.0264023624147303090806402175744e6
             + 408422.18157196114756664066400724*z))
             + y*(786736.31770752772335753538162933
             + y*(-940549.15852389129655971575990129
             + 389702.83158324626163650296690691*y
             + 2.4845682712294303143637307060441e6*z)
             + z*(-3.8328850885984046156253970006833e6
             + 2.5186034530270937433276174280447e6*z)))))
             + y*(-13352.263628314114439678637092544
             + z*(130904.54537562857293802585384847
             + z*(-256572.90893623200295853067354301
             + 125668.36356060343002050481969454*z))
             + y*(134177.15901001928726147650019469
             + z*(-1.1833770901956822993597537187902e6
             + (2.0264023624147303090806402175744e6
             - 816844.3631439222951332813280145*z)*z)
             + y*(-524490.87847168514890502358775289
             + z*(3.8328850885984046156253970006833e6
             + z*(-5.0372069060541874866552348560893e6
             + 1.2706467871127680146517709546892e6*z))
             + y*(940549.15852389129655971575990129
             + y*(-779405.66316649252327300593381382
             + 242217.04379337140279299383823763*y
             + 2.1918657077695248252743048968389e6*z)
             + z*(-4.9691365424588606287274614120881e6
             + 3.6928172250464820425817093370655e6*z))))));
          case ( 116 ):
            return -49.477267507411926597856918271689
             + z*(989.54535014823853195713836543378
             + z*(-4452.954075667073393807122644452
             + (6926.8174510376697236999685580364
             - 3463.4087255188348618499842790182*z)*z))
             + y*(2127.5225028187128437078474856826
             + z*(-41560.904706226018342199811348219
             + z*(182571.11710235000914609202842253
             + z*(-277072.69804150678894799874232146
             + 135072.94029523455961214938688171*z)))
             + y*(-21522.611365724188070067759448185
             + z*(388891.32260825774305915537761547
             + z*(-1.5674398346348098346201071708471e6
             + (2.1611670447237529537943901901074e6
             - 945510.582066641917285045708172*z)*z))
             + y*(88316.922500730288977174599114965
             + z*(-1.3774471274063480364843366046838e6
             + z*(4.6310722386937563295594075502301e6
             + z*(-5.0427231043554235588535771102505e6
             + 1.5758509701110698621417428469533e6*z)))
             + y*(-178860.32203929411465125275955216
             + y*(191031.72984611744859432556144699
             + y*(-103555.92089301316236931452994264
             + 22512.156715872426602024897813618*y
             + 450243.13431744853204049795627237*z)
             + z*(-1.6208752835428147153457926425805e6
             + 2.0260941044285183941822408032257e6*z))
             + z*(2.1997593133795342565407185863593e6
             + z*(-5.2678446715141478248738260883867e6
             + 3.1517019402221397242834856939066e6*z))))))
             + x*(346.34087255188348618499842790182
             + z*(-5937.2721008894311917428301926027
             + z*(22264.77037833536696903561322226
             + z*(-27707.269804150678894799874232146
             + 10390.226176556504585549952837055*z)))
             + x*(-1039.0226176556504585549952837055
             + z*(14843.180252223577979357075481507
             + z*(-44529.54075667073393807122644452
             + (41560.904706226018342199811348219
             - 10390.226176556504585549952837055*z)*z))
             + x*(1731.7043627594174309249921395091
             + z*(-19790.907002964770639142767308676
             + z*(44529.54075667073393807122644452
             + z*(-27707.269804150678894799874232146
             + 3463.4087255188348618499842790182*z)))
             + x*(-1731.7043627594174309249921395091
             + z*(14843.180252223577979357075481507
             + z*(-22264.77037833536696903561322226
             + 6926.817451037669723699968558036*z))
             + x*(1039.0226176556504585549952837055
             + x*(-346.34087255188348618499842790182
             + 49.477267507411926597856918271689*x
             + 2127.5225028187128437078474856826*y
             + 989.5453501482385319571383654338*z)
             + z*(-5937.2721008894311917428301926027
             + 4452.954075667073393807122644452*z)
             + y*(-12765.135016912277062247084914096
             + 21522.611365724188070067759448185*y
             + 41560.904706226018342199811348219*z))
             + y*(31912.837542280692655617712285239
             + z*(-207804.52353113009171099905674109
             + 182571.11710235000914609202842253*z)
             + y*(-107613.05682862094035033879724092
             + 88316.92250073028897717459911496*y
             + 388891.32260825774305915537761547*z)))
             + y*(-42550.450056374256874156949713652
             + z*(415609.04706226018342199811348219
             + z*(-730284.46840940003658436811369013
             + 277072.69804150678894799874232146*z))
             + y*(215226.11365724188070067759448185
             + y*(-353267.69000292115590869839645986
             + 178860.32203929411465125275955216*y
             + 1.3774471274063480364843366046838e6*z)
             + z*(-1.5555652904330309722366215104619e6
             + 1.5674398346348098346201071708471e6*z))))
             + y*(31912.837542280692655617712285239
             + z*(-415609.04706226018342199811348219
             + z*(1.0954267026141000548765521705352e6
             + z*(-831218.09412452036684399622696437
             + 135072.94029523455961214938688171*z)))
             + y*(-215226.11365724188070067759448185
             + z*(2.3333479356495464583549322656928e6
             + z*(-4.7023195039044295038603215125413e6
             + 2.1611670447237529537943901901074e6*z))
             + y*(529901.53500438173386304759468979
             + y*(-536580.96611788234395375827865647
             + 191031.72984611744859432556144699*y
             + 2.1997593133795342565407185863593e6*z)
             + z*(-4.1323413822190441094530098140515e6
             + 4.6310722386937563295594075502301e6*z)))))
             + y*(-12765.135016912277062247084914096
             + z*(207804.52353113009171099905674109
             + z*(-730284.46840940003658436811369013
             + (831218.09412452036684399622696437
             - 270145.88059046911922429877376342*z)*z))
             + y*(107613.05682862094035033879724092
             + z*(-1.5555652904330309722366215104619e6
             + z*(4.7023195039044295038603215125413e6
             + z*(-4.3223340894475059075887803802147e6
             + 945510.582066641917285045708172*z)))
             + y*(-353267.69000292115590869839645986
             + z*(4.1323413822190441094530098140515e6
             + z*(-9.2621444773875126591188151004602e6
             + 5.042723104355423558853577110251e6*z))
             + y*(536580.96611788234395375827865647
             + y*(-382063.45969223489718865112289398
             + 103555.92089301316236931452994264*y
             + 1.6208752835428147153457926425805e6*z)
             + z*(-4.3995186267590685130814371727186e6
             + 5.267844671514147824873826088387e6*z))))));
          case ( 117 ):
            return -54.699177324709372634288659621393
             + z*(1640.9753197412811790286597886418
             + z*(-11486.827238188968253200618520493
             + z*(30631.53930183724867520164938798
             + z*(-34460.481714566904759601855561478
             + 13784.192685826761903840742224591*z))))
             + y*(1805.072851715409296931525767506
             + z*(-52511.210231720997728917113236537
             + z*(356091.64438385801584921917413527
             + z*(-918946.1790551174602560494816394
             + (999353.96972244023802845381128285
             - 385957.39520314933330754078228855*z)*z)))
             + y*(-13948.290217800890021743608203455
             + z*(365937.49630230570292339113286712
             + z*(-2.2054708297322819046145187559346e6
             + z*(4.9623093668976342853826672008528e6
             + z*(-4.5832440680373983330270467896765e6
             + 1.4473402320118099999032779335821e6*z))))
             + y*(44579.829519638138696945257591435
             + y*(-73023.40172848701246677536059456
             + y*(65146.720193728862807437793609079
             + y*(-30248.64506056428306676162877063
             + 5743.413619094484126600309260246*y
             + 172302.40857283452379800927780739*z)
             + z*(-735156.94324409396820483958531152
             + 1.2061168600098416665860649446517e6*z))
             + z*(1.2192446625677719160182942229609e6
             + z*(-3.9399817426988161108478121525289e6
             + 3.2163116266929111108961731857379e6*z)))
             + z*(-971457.38928683845798496659487594
             + z*(4.594730895275587301280247408197e6
             + z*(-7.2903063538372651846979925543393e6
             + 3.6183505800295249997581948339552e6*z))))))
             + x*(382.89424127296560844002061734975
             + z*(-9845.8519184476870741719587318508
             + z*(57434.136190944841266003092602463
             + z*(-122526.15720734899470080659755192
             + (103381.44514370071427880556668443
             - 27568.385371653523807681484449182*z)*z)))
             + x*(-1148.6827238188968253200618520493
             + z*(24614.629796119217685429896829627
             + z*(-114868.27238188968253200618520493
             + z*(183789.23581102349205120989632788
             + z*(-103381.44514370071427880556668443
             + 13784.192685826761903840742224591*z))))
             + x*(1914.4712063648280422001030867488
             + z*(-32819.506394825623580573195772836
             + z*(114868.27238188968253200618520493
             + z*(-122526.15720734899470080659755192
             + 34460.481714566904759601855561478*z)))
             + x*(-1914.4712063648280422001030867488
             + z*(24614.629796119217685429896829627
             + z*(-57434.136190944841266003092602463
             + 30631.53930183724867520164938798*z))
             + x*(1148.6827238188968253200618520493
             + x*(-382.89424127296560844002061734975
             + 54.69917732470937263428865962139*x
             + 1805.072851715409296931525767506*y
             + 1640.9753197412811790286597886418*z)
             + z*(-9845.8519184476870741719587318508
             + 11486.827238188968253200618520493*z)
             + y*(-10830.437110292455781589154605036
             + 13948.290217800890021743608203455*y
             + 52511.21023172099772891711323654*z))
             + y*(27076.09277573113945397288651259
             + z*(-262556.05115860498864458556618269
             + 356091.64438385801584921917413527*z)
             + y*(-69741.451089004450108718041017276
             + 44579.829519638138696945257591435*y
             + 365937.49630230570292339113286712*z)))
             + y*(-36101.457034308185938630515350119
             + z*(525112.10231720997728917113236537
             + z*(-1.4243665775354320633968766965411e6
             + 918946.1790551174602560494816394*z))
             + y*(139482.90217800890021743608203455
             + y*(-178319.31807855255478778103036574
             + 73023.40172848701246677536059456*y
             + 971457.3892868384579849665948759*z)
             + z*(-1.4637499852092228116935645314685e6
             + 2.2054708297322819046145187559346e6*z))))
             + y*(27076.09277573113945397288651259
             + z*(-525112.10231720997728917113236537
             + z*(2.1365498663031480950953150448116e6
             + z*(-2.7568385371653523807681484449182e6
             + 999353.9697224402380284538112829*z)))
             + y*(-139482.90217800890021743608203455
             + y*(267478.97711782883218167154554861
             + y*(-219070.20518546103740032608178368
             + 65146.72019372886280743779360908*y
             + 1.2192446625677719160182942229609e6*z)
             + z*(-2.9143721678605153739548997846278e6
             + 4.594730895275587301280247408197e6*z))
             + z*(2.1956249778138342175403467972027e6
             + z*(-6.6164124891968457138435562678037e6
             + 4.9623093668976342853826672008528e6*z)))))
             + y*(-10830.437110292455781589154605036
             + z*(262556.05115860498864458556618269
             + z*(-1.4243665775354320633968766965411e6
             + z*(2.7568385371653523807681484449182e6
             + z*(-1.9987079394448804760569076225657e6
             + 385957.39520314933330754078228855*z))))
             + y*(69741.451089004450108718041017276
             + z*(-1.4637499852092228116935645314685e6
             + z*(6.6164124891968457138435562678037e6
             + z*(-9.9246187337952685707653344017056e6
             + 4.5832440680373983330270467896765e6*z)))
             + y*(-178319.31807855255478778103036574
             + y*(219070.20518546103740032608178368
             + y*(-130293.44038745772561487558721816
             + 30248.64506056428306676162877063*y
             + 735156.9432440939682048395853115*z)
             + z*(-2.4384893251355438320365884459217e6
             + 3.9399817426988161108478121525289e6*z))
             + z*(2.9143721678605153739548997846278e6
             + z*(-9.189461790551174602560494816394e6
             + 7.290306353837265184697992554339e6*z))))));
          case ( 118 ):
            return -59.464274989274022090448032855726
             + z*(2497.4995495495089277988173799405
             + z*(-24974.995495495089277988173799405
             + z*(99899.981981980357111952695197619
             + z*(-187312.46621621316958491130349554
             + (164834.97027026758923472194707607
             - 54944.99009008919641157398235869*z)*z))))
             + y*(1248.7497747747544638994086899702
             + z*(-49949.990990990178555976347598809
             + z*(474524.91441440669628177530218869
             + z*(-1.7981996756756464280151485135571e6
             + z*(3.1843119256756238829434921594241e6
             + z*(-2.6373595243242814277555511532171e6
             + 824174.8513513379461736097353804*z)))))
             + y*(-6243.7488738737723194970434498512
             + z*(212287.46171170825886289947729494
             + z*(-1.6483497027026758923472194707607e6
             + z*(4.7951991351350571413737293694857e6
             + z*(-5.8066864527026082571322504083616e6
             + 2.4725245540540138385208292061411e6*z))))
             + y*(14568.747372372135412159768049653
             + y*(-18731.246621621316958491130349554
             + y*(13736.247522522299102893495589673
             + y*(-5411.249024023936010230770989871
             + 891.9641248391103313567204928359*y
             + 37462.493243242633916982260699107*z)
             + z*(-189809.96576576267851271012087548
             + 374624.93243242633916982260699107*z))
             + z*(387112.43018017388380881669389077
             + z*(-1.5234747252252004459572786017637e6
             + 1.4984997297297053566792904279643e6*z)))
             + z*(-399599.92792792142844781078079048
             + z*(2.347649576576538392130888337144e6
             + z*(-4.5953991711710964271498239790905e6
             + 2.809686993243197543773669552433e6*z))))))
             + x*(416.24992492491815463313622999008
             + z*(-14984.997297297053566792904279643
             + z*(124874.97747747544638994086899702
             + z*(-399599.92792792142844781078079048
             + z*(561937.39864863950875473391048661
             + z*(-329669.94054053517846944389415214
             + 54944.99009008919641157398235869*z)))))
             + x*(-1248.7497747747544638994086899702
             + z*(37462.493243242633916982260699107
             + z*(-249749.95495495089277988173799405
             + z*(599399.89189188214267171617118571
             + z*(-561937.39864863950875473391048661
             + 164834.97027026758923472194707607*z))))
             + x*(2081.2496246245907731656811499504
             + z*(-49949.990990990178555976347598809
             + z*(249749.95495495089277988173799405
             + z*(-399599.92792792142844781078079048
             + 187312.46621621316958491130349554*z)))
             + x*(-2081.2496246245907731656811499504
             + x*(1248.7497747747544638994086899702
             + x*(-416.24992492491815463313622999008
             + 59.46427498927402209044803285573*x
             + 1248.7497747747544638994086899702*y
             + 2497.4995495495089277988173799405*z)
             + z*(-14984.997297297053566792904279643
             + 24974.995495495089277988173799405*z)
             + y*(-7492.4986486485267833964521398214
             + 6243.748873873772319497043449851*y
             + 49949.990990990178555976347598809*z))
             + z*(37462.493243242633916982260699107
             + z*(-124874.97747747544638994086899702
             + 99899.98198198035711195269519762*z))
             + y*(18731.246621621316958491130349554
             + y*(-31218.744369368861597485217249256
             + 14568.747372372135412159768049653*y
             + 212287.46171170825886289947729494*z)
             + z*(-249749.95495495089277988173799405
             + 474524.91441440669628177530218869*z)))
             + y*(-24974.995495495089277988173799405
             + y*(62437.488738737723194970434498512
             + y*(-58274.989489488541648639072198611
             + 18731.246621621316958491130349554*y
             + 399599.92792792142844781078079048*z)
             + z*(-849149.84684683303545159790917976
             + 1.6483497027026758923472194707607e6*z))
             + z*(499499.90990990178555976347598809
             + z*(-1.8980996576576267851271012087548e6
             + 1.7981996756756464280151485135571e6*z))))
             + y*(18731.246621621316958491130349554
             + z*(-499499.90990990178555976347598809
             + z*(2.8471494864864401776906518131321e6
             + z*(-5.3945990270269392840454455406714e6
             + 3.1843119256756238829434921594241e6*z)))
             + y*(-62437.488738737723194970434498512
             + y*(87412.484234232812472958608297917
             + y*(-56193.739864863950875473391048661
             + 13736.247522522299102893495589673*y
             + 387112.43018017388380881669389077*z)
             + z*(-1.1987997837837642853434323423714e6
             + 2.347649576576538392130888337144e6*z))
             + z*(1.2737247702702495531773968637696e6
             + z*(-4.9450491081080276770416584122821e6
             + 4.7951991351350571413737293694857e6*z)))))
             + y*(-7492.4986486485267833964521398214
             + z*(249749.95495495089277988173799405
             + z*(-1.8980996576576267851271012087548e6
             + z*(5.3945990270269392840454455406714e6
             + z*(-6.3686238513512477658869843188482e6
             + 2.6373595243242814277555511532171e6*z))))
             + y*(31218.744369368861597485217249256
             + y*(-58274.989489488541648639072198611
             + y*(56193.739864863950875473391048661
             + y*(-27472.495045044598205786991179345
             + 5411.249024023936010230770989871*y
             + 189809.96576576267851271012087548*z)
             + z*(-774224.86036034776761763338778155
             + 1.5234747252252004459572786017637e6*z))
             + z*(1.1987997837837642853434323423714e6
             + z*(-4.6952991531530767842617766742881e6
             + 4.5953991711710964271498239790905e6*z)))
             + z*(-849149.84684683303545159790917976
             + z*(4.9450491081080276770416584122821e6
             + z*(-9.5903982702701142827474587389714e6
             + 5.806686452702608257132250408362e6*z))))));
          case ( 119 ):
            return -63.874877690685247996280980707922
             + z*(3576.9931506783738877917349196437
             + z*(-48289.407534158047485188421415189
             + z*(268274.48630087804158438011897327
             + z*(-737754.8373274146143570453271765
             + z*(1.0623669657514770446741452711342e6
             + z*(-767265.03082051119893132714026356
             + 219218.58023443177112323632578959*z))))))
             + y*(447.12414383479673597396686495546
             + z*(-21461.958904070243326750409517862
             + z*(241447.03767079023742594210707595
             + z*(-1.0730979452035121663375204758931e6
             + z*(2.2132645119822438430711359815295e6
             + z*(-2.1247339315029540893482905422683e6
             + 767265.0308205111989313271402636*z)))))
             + y*(-1341.3724315043902079219005948664
             + y*(2235.6207191739836798698343247773
             + y*(-2235.6207191739836798698343247773
             + y*(1341.3724315043902079219005948664
             + y*(-447.12414383479673597396686495546
             + 63.87487769068524799628098070792*y
             + 3576.9931506783738877917349196437*z)
             + z*(-21461.958904070243326750409517862
             + 48289.407534158047485188421415189*z))
             + z*(53654.897260175608316876023794655
             + z*(-241447.03767079023742594210707595
             + 268274.48630087804158438011897327*z)))
             + z*(-71539.863013567477755834698392873
             + z*(482894.07534158047485188421415189
             + z*(-1.0730979452035121663375204758931e6
             + 737754.8373274146143570453271765*z))))
             + z*(53654.897260175608316876023794655
             + z*(-482894.07534158047485188421415189
             + z*(1.6096469178052682495062807138396e6
             + z*(-2.2132645119822438430711359815295e6
             + 1.0623669657514770446741452711342e6*z))))))
             + x*(447.12414383479673597396686495546
             + z*(-21461.958904070243326750409517862
             + z*(241447.03767079023742594210707595
             + z*(-1.0730979452035121663375204758931e6
             + z*(2.2132645119822438430711359815295e6
             + z*(-2.1247339315029540893482905422683e6
             + 767265.0308205111989313271402636*z)))))
             + y*(-2682.7448630087804158438011897327
             + z*(107309.79452035121663375204758931
             + z*(-965788.15068316094970376842830379
             + z*(3.2192938356105364990125614276793e6
             + z*(-4.426529023964487686142271963059e6
             + 2.1247339315029540893482905422683e6*z))))
             + y*(6706.8621575219510396095029743319
             + y*(-8942.4828766959347194793372991091
             + y*(6706.8621575219510396095029743319
             + y*(-2682.7448630087804158438011897327
             + 447.12414383479673597396686495546*y
             + 21461.958904070243326750409517862*z)
             + z*(-107309.79452035121663375204758931
             + 241447.03767079023742594210707595*z))
             + z*(214619.58904070243326750409517862
             + z*(-965788.15068316094970376842830379
             + 1.0730979452035121663375204758931e6*z)))
             + z*(-214619.58904070243326750409517862
             + z*(1.4486822260247414245556526424557e6
             + z*(-3.2192938356105364990125614276793e6
             + 2.2132645119822438430711359815295e6*z)))))
             + x*(-1341.3724315043902079219005948664
             + z*(53654.897260175608316876023794655
             + z*(-482894.07534158047485188421415189
             + z*(1.6096469178052682495062807138396e6
             + z*(-2.2132645119822438430711359815295e6
             + 1.0623669657514770446741452711342e6*z))))
             + x*(2235.6207191739836798698343247773
             + x*(-2235.6207191739836798698343247773
             + x*(1341.3724315043902079219005948664
             + x*(-447.12414383479673597396686495546
             + 63.87487769068524799628098070792*x
             + 447.12414383479673597396686495546*y
             + 3576.9931506783738877917349196437*z)
             + y*(-2682.7448630087804158438011897327
             + 1341.3724315043902079219005948664*y
             + 21461.958904070243326750409517862*z)
             + z*(-21461.958904070243326750409517862
             + 48289.407534158047485188421415189*z))
             + y*(6706.8621575219510396095029743319
             + y*(-6706.8621575219510396095029743319
             + 2235.6207191739836798698343247773*y
             + 53654.89726017560831687602379465*z)
             + z*(-107309.79452035121663375204758931
             + 241447.03767079023742594210707595*z))
             + z*(53654.897260175608316876023794655
             + z*(-241447.03767079023742594210707595
             + 268274.48630087804158438011897327*z)))
             + z*(-71539.863013567477755834698392873
             + z*(482894.07534158047485188421415189
             + z*(-1.0730979452035121663375204758931e6
             + 737754.8373274146143570453271765*z)))
             + y*(-8942.4828766959347194793372991091
             + y*(13413.724315043902079219005948664
             + y*(-8942.4828766959347194793372991091
             + 2235.6207191739836798698343247773*y
             + 71539.86301356747775583469839287*z)
             + z*(-214619.58904070243326750409517862
             + 482894.07534158047485188421415189*z))
             + z*(214619.58904070243326750409517862
             + z*(-965788.15068316094970376842830379
             + 1.0730979452035121663375204758931e6*z))))
             + y*(6706.8621575219510396095029743319
             + y*(-13413.724315043902079219005948664
             + y*(13413.724315043902079219005948664
             + y*(-6706.8621575219510396095029743319
             + 1341.3724315043902079219005948664*y
             + 53654.89726017560831687602379465*z)
             + z*(-214619.58904070243326750409517862
             + 482894.07534158047485188421415189*z))
             + z*(321929.38356105364990125614276793
             + z*(-1.4486822260247414245556526424557e6
             + 1.6096469178052682495062807138396e6*z)))
             + z*(-214619.58904070243326750409517862
             + z*(1.4486822260247414245556526424557e6
             + z*(-3.2192938356105364990125614276793e6
             + 2.2132645119822438430711359815295e6*z))))));
          #endif
          #if (PMAX3D>=8)
          case ( 120 ):
            return 6.1644140029689764502501923814542
             + x*(-542.46843226126992762201692956797
             + x*(11391.837077486668480062355520927
             + x*(-98729.254671551126827207081181371
             + x*(431940.4891880361798690309801685
             + x*(-1.0366571740512868316856743524044e6
             + x*(1.3822095654017157755808991365392e6
             + x*(-959084.18823792523203572593147618
             + 269742.42794191647151004791822767*x)))))));
          case ( 121 ):
            return 8.7177978870813471044739639677192
             - 26.153393661244041313421891903158*y
             + x*(-741.01282040191450388028693725613
             + 2196.8850675444994703274389198652*y
             + x*(15012.047961554079713904165952413
             - 42839.258817117739671385058937372*y
             + x*(-125344.49802045560866812665392787
             + 333194.23524424908633299490284623*y
             + x*(527557.53913672772002724192950653
             - 1.2494783821659340737487308856734e6*y
             + x*(-1.2161589586415091651154313953887e6
             + 2.3989984937585934215975633004928e6*y
             + x*(1.5549064311398290695539762132824e6
             - 2.2657207996608937870643653393544e6*y
             + x*(-1.0326754665121080526075678757601e6
             + 277435.1999584767902527794293087*x
             + 832305.5998754303707583382879261*y)))))));
          case ( 122 ):
            return 15.099668870541499394473369613892
             - 15.099668870541499394473369613892*y
             - 30.199337741082998788946739227784*z
             + x*(-1283.4718539960274485302364171808
             + 1268.3721851254859491357630475669*y
             + 2536.7443702509718982715260951339*z
             + x*(26001.629795072461957283142475122
             - 24733.257609946976008147379427555*y
             - 49466.515219893952016294758855111*z
             + x*(-217103.03902064567829373810830854
             + 192369.78141069870228559072888099*y
             + 384739.56282139740457118145776197*z
             + x*(913756.46170081883585655596218469
             - 721386.6802901201335709652333037*y
             - 1.4427733605802402671419304666074e6*z
             + x*(-2.1064491064471507900272184812468e6
             + 1.3850624261570306564562532479431e6*y
             + 2.7701248523140613129125064958862e6*z
             + x*(2.6931769397497818319982702043338e6
             - 1.3081145135927511755420169563907e6*y
             - 2.6162290271855023510840339127814e6*z
             + x*(-1.7886463757288638522717374709832e6
             + 480531.86213611267672972051459251*x
             + 480531.86213611267672972051459251*y
             + 961063.724272225353459441029185*z)))))));
          case ( 123 ):
            return 10.677078252031311210811523965596
             + y*(-85.416626016250489686492191724766
             + 106.77078252031311210811523965596*y)
             + x*(-854.16626016250489686492191724766
             + (6747.9134552837886852328831462565
             - 8328.121036584422744432988693165*y)*y
             + x*(16250.513099591655662855139475637
             + y*(-123256.19134144945661760823265884
             + 145742.11814022739802757730213038*y)
             + x*(-127142.64782518885389834362738231
             + (893884.99126006137456914078639967
             - 971614.1209348493201838486808692*y)*y
             + x*(500381.27228144739989468207064764
             + y*(-3.1091651869915178245883157787815e6
             + 2.9148423628045479605515460426076e6*y)
             + x*(-1.0765484459958130467637043384031e6
             + (5.5032223809749865495213189284432e6
             - 3.9641856134141852263501026179464e6*y)*y
             + x*(1.2825306396340011026426802587474e6
             + x*(-792837.12268283704527002052358928
             + 198209.28067070926131750513089732*x
             + 1.5856742453656740905400410471786e6*y)
             + y*(-4.7570227360970222716201231415357e6
             + 1.9820928067070926131750513089732e6*y)))))));
          case ( 124 ):
            return 18.493242008906929350750577144363
             - 36.986484017813858701501154288725*z
             + y*(-110.95945205344157610450346286618
             + 92.46621004453464675375288572181*y
             + 184.93242008906929350750577144363*z)
             + x*(-1479.459360712554348060046171549
             + y*(8765.7967122218845122557735664279
             - 7212.364383473702446792725086301*y
             - 14424.728766947404893585450172603*z)
             + 2921.9322374072948374185911888093*z
             + x*(28146.71433755634647184237841372
             - 53371.49643770539810626616563863*z
             + y*(-160114.48931311619431879849691589
             + 126216.37671078979281887268901028*y
             + 252432.75342157958563774537802055*z)
             + x*(-220217.52584206371470873787263507
             + y*(1.1611906657392660939336287388945e6
             - 841442.5114052652854591512600685*y
             - 1.682885022810530570918302520137e6*z)
             + 387063.55524642203131120957963151*z
             + x*(866685.78674742324402292579787056
             - 1.3463080182484244567346420161096e6*z
             + y*(-4.0389240547452733702039260483288e6
             + 2.5243275342157958563774537802055e6*y
             + 5.048655068431591712754907560411e6*z)
             + x*(-1.8646366052740678725774791923118e6
             + y*(7.148895576899133865260949105542e6
             - 3.4330854465334823646733371410795e6*y
             - 6.866170893066964729346674282159e6*z)
             + 2.382965192299711288420316368514e6*z
             + x*(2.2214082301099003536121593265809e6
             - 2.0598512679200894188040022846477e6*z
             + x*(-1.3732341786133929458693348564318e6
             + 343308.54465334823646733371410795*x
             + 2.0598512679200894188040022846477e6*y
             + 686617.0893066964729346674282159*z)
             + y*(-6.1795538037602682564120068539431e6
             + 1.7165427232667411823366685705397e6*y
             + 3.4330854465334823646733371410795e6*z)))))));
          case ( 125 ):
            return 23.874672772626643897936464614284
             + z*(-143.2480366357598633876187876857
             + 143.2480366357598633876187876857*z)
             + y*(-47.749345545253287795872929228568
             + 23.874672772626643897936464614284*y
             + 143.2480366357598633876187876857*z)
             + x*(-1909.9738218101315118349171691427
             + y*(3772.1982980750097358739614090569
             - 1862.2244762648782240390442399142*y
             - 11173.346857589269344234265439485*z)
             + (11316.594894225029207621884227171
             - 11173.346857589269344234265439485*z)*z
             + x*(36337.25195993775201265929914294
             + z*(-206706.91686540148286833391063047
             + 195533.57000781221352409964519099*z)
             + y*(-68902.305621800494289444636876824
             + 32588.928334635368920683274198498*y
             + 195533.57000781221352409964519099*z)
             + x*(-284299.60337643807553662742062689
             + y*(499696.90113107565678381020437697
             - 217259.52223090245947122182798999*y
             - 1.3035571333854147568273309679399e6*z)
             + (1.4990907033932269703514306131309e6
             - 1.3035571333854147568273309679399e6*z)*z
             + x*(1.1188865394891476662767924141484e6
             + z*(-5.2142285335416590273093238717596e6
             + 3.9106714001562442704819929038197e6*z)
             + y*(-1.7380761778472196757697746239199e6
             + 651778.56669270737841366548397*y
             + 3.9106714001562442704819929038197e6*z)
             + x*(-2.407235506318399250941137854129e6
             + y*(3.0763948347895788261125010843382e6
             - 886418.8507020820346425850581991*y
             - 5.318513104212492207855510349195e6*z)
             + (9.2291845043687364783375032530146e6
             - 5.318513104212492207855510349195e6*z)*z
             + x*(2.8678256934479124650201281294678e6
             + z*(-7.9777696563187383117832655237923e6
             + 2.6592565521062461039277551745974e6*z)
             + y*(-2.6592565521062461039277551745974e6
             + 443209.42535104101732129252909957*y
             + 2.6592565521062461039277551745974e6*z)
             + x*(-1.7728377014041640692851701163983e6
             + 443209.42535104101732129252909957*x
             + 886418.8507020820346425850581991*y
             + 2.6592565521062461039277551745974e6*z)))))));
          case ( 126 ):
            return 12.328828005937952900500384762908
             + y*(-184.93242008906929350750577144363
             + (554.79726026720788052251731433088
             - 431.5089802078283515175134667018*y)*y)
             + x*(-900.00444443347056173652808769232
             + y*(13315.134246412989132540415543941
             + y*(-39390.605478971759517098729317493
             + 30205.628614547984606225942669126*y))
             + x*(15571.309771499634513331985955553
             + y*(-220254.51232608152856743937378936
             + (621372.93149927282618521939205059
             - 453084.42921821976909338914003689*y)*y)
             + x*(-110478.62776120999594138394786042
             + y*(1.436924904092068410553319844117e6
             + y*(-3.6894017807769324054747401403004e6
             + 2.4164502891638387684980754135301e6*y))
             + x*(393536.18994953945658397228163204
             + y*(-4.4661179451510234382062643803636e6
             + (9.7089520546761379091440530007904e6
             - 5.134956864473157383058410253751e6*y)*y)
             + x*(-765842.13807285375827328290070235
             + y*(7.0215141259417829358929791301716e6
             + y*(-1.1355590323149210898534884389724e7
             + 3.697168942420673315802055382701e6*y))
             + x*(826080.79170986659614512778065392
             + x*(-463613.24833529078087041646862441
             + 105633.3983548763804514872966486*x
             + 1.584500975323145706772309449729e6*y)
             + y*(-5.3696977497062160062839375796372e6
             + 4.753502925969437120316928349187e6*y)))))));
          case ( 127 ):
            return 21.354156504062622421623047931191
             - 42.708313008125244843246095862383*z
             + y*(-277.60403455281409148109962310549
             + y*(704.68716463406653991356058172932
             - 448.43728658531507085408400655502*y
             - 896.87457317063014170816801311*z)
             + 512.4997560975029381189531503486*z)
             + x*(-1558.853424796571436778482498977
             + 3074.9985365850176287137189020916*z
             + y*(19987.490487802614586639172863595
             - 36387.48268292270860644567367475*z
             + y*(-50032.788689018724333862801302781
             + 31390.610060972054959785880458851*y
             + 62781.2201219441099195717609177*z))
             + x*(26970.299664631092118509909537095
             - 50865.6007926771666083061001721*z
             + y*(-330626.40515240158295398965111864
             + y*(789249.62439015452470318785153683
             - 470859.15091458082439678820688277*y
             - 941718.3018291616487935764137655*z)
             + 573999.7268292032906932275283904*z)
             + x*(-191354.59643290515952016413251141
             + 331843.59207313315243202216485071*z
             + y*(2.1569833484753654908081440715296e6
             - 3.4081233780483945384910384498182e6*z
             + y*(-4.6861696448165424904251778685e6
             + 2.5112488048777643967828704367081e6*y
             + 5.022497609755528793565740873416e6*z))
             + x*(681624.67560967890769820768996363
             - 1.0314057591462246629643932150765e6*z
             + y*(-6.7041374344504603092685558979975e6
             + y*(1.2332025381096164448487310180263e7
             - 5.336403710365249343163599678005e6*y
             - 1.0672807420730498686327199356009e7*z)
             + 8.9687457317063014170816801311e6*z)
             + x*(-1.3264774937193619795863804913897e6
             + 1.621549228292499296208367767703e6*z
             + x*(1.4308139023982119527384307035815e6
             - 1.2400785765039246092684936394601e6*z
             + x*(-803001.70117877085354271309440452
             + 182962.41292680854890846627467445*x
             + 2.3785113680485111358100615707678e6*y
             + 365924.8258536170978169325493489*z)
             + y*(-8.060510747275509960245208656491e6
             + 6.037759626584682113979387064257e6*y
             + 4.3910979102434051738031905921868e6*z))
             + y*(1.0540069983901245425354390490069e7
             - 1.0489845007803690137418733081335e7*z
             + y*(-1.4423536885730073938950757986836e7
             + 3.8422106714629795270777917681634e6*y
             + 7.684421342925959054155583536327e6*z)))))));
          case ( 128 ):
            return 27.568097504180443535911825105868
             + z*(-165.40858502508266121547095063521
             + 165.40858502508266121547095063521*z)
             + y*(-248.11287753762399182320642595282
             + y*(413.52146256270665303867737658803
             - 192.97668252926310475138277574108*y
             - 1157.8600951755786285082966544465*z)
             + (1323.2686802006612897237676050817
             - 1157.8600951755786285082966544465*z)*z)
             + x*(-2012.4711178051723781215632327284
             + (11909.418121805951607513908445735
             - 11744.0095367808689462984374951*z)*z
             + y*(17864.127182708927411270862668603
             + z*(-93952.076294246951570387499960799
             + 81050.20666229050399558076581125*z)
             + y*(-29360.02384195217236574609373775
             + 13508.367777048417332596794301875*y
             + 81050.20666229050399558076581125*z))
             + x*(34818.507147779900185856635108712
             + z*(-197001.62476487344950762590220654
             + 185257.61522809258056132746471144*z)
             + y*(-295502.4371473101742614388533098
             + y*(463144.03807023145140331866177859
             - 202625.51665572625998895191452813*y
             - 1.2157530999343575599337114871688e6*z)
             + (1.4820609218247406444906197176915e6
             - 1.2157530999343575599337114871688e6*z)*z)
             + x*(-247037.72173496095452530586477369
             + (1.2852247056448922776442092864356e6
             - 1.0999670904167996970828818217241e6*z)*z
             + y*(1.9278370584673384164663139296534e6
             + z*(-8.7997367233343975766630545737932e6
             + 6.4840165329832403196464612649e6*z)
             + y*(-2.7499177260419992427072045543104e6
             + 1.08066942216387338660774354415e6*y
             + 6.4840165329832403196464612649e6*z))
             + x*(879973.67233343975766630545737932
             + z*(-3.9946173283557462683536234578403e6
             + 2.8946502379389465712707416361162e6*z)
             + y*(-5.9919259925336194025304351867605e6
             + y*(7.2366255948473664281768540902904e6
             - 2.2964225220982309465414550313188e6*y
             - 1.3778535132589385679248730187913e7*z)
             + (2.3157201903511572570165933088929e7
             - 1.3778535132589385679248730187913e7*z)*z)
             + x*(-1.7124750807646807915637707519263e6
             + (6.2802331562323384810290010537177e6
             - 3.3855829182933919097582594176015e6*z)*z
             + y*(9.4203497343485077215435015805765e6
             + z*(-2.7084663346347135278066075340812e7
             + 9.920545295464357689059085735297e6*z)
             + y*(-8.4639572957334797743956485440037e6
             + 1.6534242159107262815098476225496e6*y
             + 9.920545295464357689059085735297e6*z))
             + x*(1.8471728051701064386802359293936e6
             + z*(-4.802803674788300151052414522644e6
             + 1.4172207564949082412941551050425e6*z)
             + x*(-1.0366707385472013987244282712811e6
             + 236203.45941581804021569251750708*x
             + 2.1258311347423623619412326575637e6*y
             + 1.4172207564949082412941551050425e6*z)
             + y*(-7.2042055121824502265786217839659e6
             + 3.5430518912372706032353877626062e6*y
             + 1.133776605195926593035324084034e7*z)))))));
          case ( 129 ):
            return 32.619012860600180952251535775392
             + y*(-97.857038581800542856754607326177
             + y*(97.857038581800542856754607326177
             - 32.619012860600180952251535775392*y
             - 391.42815432720217142701842930471*z)
             + (782.85630865440434285403685860942
             - 978.5703858180054285675460732618*z)*z)
             + z*(-391.42815432720217142701842930471
             + (978.57038581800542856754607326177
             - 652.3802572120036190450307155078*z)*z)
             + x*(-2381.1879388238132095143621116037
             + z*(28182.827111558556342745326909939
             + z*(-69478.497393078385428295771201586
             + 45666.618004840253333152150085549*z))
             + y*(7045.7067778896390856863317274848
             + y*(-6947.8497393078385428295771201586
             + 2283.3309002420126666576075042775*y
             + 27399.97080290415199989129005133*z)
             + z*(-55582.797914462708342636616961269
             + 68499.92700726037999972822512832*z))
             + x*(41197.813242938028542693689684321
             + y*(-116547.73295092444654239473732548
             + y*(109599.88321161660799956516020532
             - 34249.963503630189999864112564162*y
             - 410999.56204356227999836935076995*z)
             + (876799.06569293286399652128164255
             - 1.0274989051089056999959233769249e6*z)*z)
             + z*(-466190.93180369778616957894930191
             + (1.0959988321161660799956516020532e6
             - 684999.2700726037999972822512832*z)*z)
             + x*(-292298.97424383822151312601208329
             + z*(3.0413967591223608719879331956976e6
             + z*(-6.5074930656897360999741813871908e6
             + 3.653329440387220266652172006844e6*z))
             + y*(760349.1897805902179969832989244
             + y*(-650749.30656897360999741813871908
             + 182666.4720193610133326086003422*y
             + 2.1919976642323321599913032041064e6*z)
             + z*(-5.2059944525517888799793451097526e6
             + 5.479994160580830399978258010266e6*z))
             + x*(1.0411988905103577759958690219505e6
             + y*(-2.3632474817504831099906237669272e6
             + y*(1.7124981751815094999932056282081e6
             - 388166.25304114215333179327572717*y
             - 4.657995036493705839981519308726e6*z)
             + (1.3699985401452075999945645025665e7
             - 1.1644987591234264599953798271815e7*z)*z)
             + z*(-9.4529899270019324399624950677087e6
             + (1.7124981751815094999932056282081e7
             - 7.763325060822843066635865514543e6*z)*z)
             + x*(-2.0262278408747620403919608992958e6
             + z*(1.4861744163495212044741035723841e7
             + z*(-2.0029378656922935111920533027522e7
             + 5.589594043792447007977823170471e6*z))
             + y*(3.7154360408738030111852589309603e6
             + y*(-2.0029378656922935111920533027522e6
             + 279479.70218962235039889115852356*y
             + 3.3537564262754682047866939022828e6*z)
             + z*(-1.6023502925538348089536426422018e7
             + 8.384391065688670511966734755707e6*z))
             + x*(2.1856043377116545245246619030944e6
             + x*(-1.2266053596100092045284667512979e6
             + 279479.70218962235039889115852356*x
             + 838439.1065688670511966734755707*y
             + 3.3537564262754682047866939022828e6*z)
             + y*(-2.8413769722611605623887267783229e6
             + 838439.1065688670511966734755707*y
             + 6.707512852550936409573387804566e6*z)
             + z*(-1.1365507889044642249554907113292e7
             + 8.384391065688670511966734755707e6*z)))))));
          case ( 130 ):
            return 13.784048752090221767955912552934
             + y*(-330.81717005016532243094190127042
             + y*(1736.7901427633679427624449816697
             + y*(-3087.6269204682096760221244118573
             + 1736.7901427633679427624449816697*y)))
             + x*(-882.17912013377419314917840338779
             + y*(20841.481713160415313149339780036
             + y*(-107680.98885132881245127158886352
             + (188345.24214856079023734958912329
             - 104207.40856580207656574669890018*y)*y))
             + x*(13315.391094519154227845411526134
             + y*(-298727.90455529928615514053684719
             + y*(1.4606405100639924398632162295842e6
             + y*(-2.4083489979652035472972570412487e6
             + 1.2504889027896249187889603868022e6*y)))
             + x*(-82208.066757466082624089062465699
             + y*(1.6742656976238866968229969623296e6
             + y*(-7.3292544024614127184575178226462e6
             + (1.0621436606410641285516107976789e7
             - 4.7240691883163608043138503501416e6*y)*y))
             + x*(255018.68596242119292895233814184
             + y*(-4.4461827654742219334718591530744e6
             + y*(1.6013205116278252432269742730995e7
             + y*(-1.7846483600306251927407879100535e7
             + 5.314577836855905904853081643909e6*y)))
             + x*(-434197.53569084198569061124541743
             + x*(412970.10061262304416795914008591
             + x*(-206209.3693312697176486204517919
             + 42179.189181396078609945092411979*x
             + 1.0123005403535058866386822178875e6*y)
             + y*(-3.936724323596967336928208625118e6
             + 5.314577836855905904853081643909e6*y))
             + y*(5.9745580911059857231028107369438e6
             + y*(-1.535322486202817261402001363796e7
             + 9.448138376632721608627700700283e6*y)))))));
          case ( 131 ):
            return 23.874672772626643897936464614284
             - 47.749345545253287795872929228568*z
             + y*(-525.24280099778616575460222151425
             + 1002.7362564503190437133315137999*z
             + y*(2506.8406411257976092833287844998
             - 4010.9450258012761748533260551997*z
             + y*(-4010.9450258012761748533260551997
             + 2005.4725129006380874266630275999*y
             + 4010.9450258012761748533260551997*z)))
             + x*(-1527.9790574481052094679337353142
             + 3008.2087693509571311399945413998*z
             + y*(33090.296462860528442539939955398
             - 62169.6478999197807102265538556*z
             + y*(-155424.11974979945177556638463899
             + y*(244667.64657387784666605288936718
             - 120328.35077403828524559978165599*y
             - 240656.70154807657049119956331198*z)
             + 244667.64657387784666605288936718*z))
             + x*(23062.933898357338005406624817398
             - 43117.659027363718879673255093397*z
             + y*(-474294.24930100090767640580602737
             + 843301.1916747183157629118031057*z
             + y*(2.1082529791867957894072795077644e6
             - 3.1285371201249954163855943230558e6*z
             + y*(-3.1285371201249954163855943230558e6
             + 1.4439402092884594229471973798719e6*y
             + 2.8878804185769188458943947597438e6*z)))
             + x*(-142388.54841594530420729307495959
             + 241659.43780452688953491289482578*z
             + y*(2.6582538158497957848840418430836e6
             - 4.2315470022203463644702589882357e6*z
             + y*(-1.0578867505550865911175647470589e7
             + y*(1.3797650888756390041495441629887e7
             - 5.454885235089735597800523435072e6*y
             - 1.0909770470179471195601046870143e7*z)
             + 1.3797650888756390041495441629887e7*z))
             + x*(441705.32096636553875572253182887
             - 641751.204128204187976532168832*z
             + y*(-7.0592632454102460677418538571515e6
             + 9.245228284471941583036916557235e6*z
             + y*(2.3113070711179853957592291393088e7
             - 2.3183262249131376290652224599054e7*z
             + y*(-2.3183262249131376290652224599054e7
             + 6.136745889475952547525588864456e6*y
             + 1.2273491778951905095051177728911e7*z)))
             + x*(-752052.19233773928278499863534995
             + 862353.1805472743775934651018679*z
             + x*(715285.19626789425118217647984395
             - 568217.21198851412477088785782*z
             + x*(-357165.10467849459271312951062969
             + 73056.49868423753032768558171971*x
             + 1.6072429710532256672090827978336e6*y
             + 146112.99736847506065537116343942*z)
             + y*(-6.2503893318736553724797664360196e6
             + 7.670932361844940684406986080569e6*y
             + 3.0683729447379762737627944322278e6*z))
             + y*(9.4858849860200181535281161205473e6
             - 8.864188507020820346425850581991e6*z
             + y*(-2.2160471267552050866064626454978e7
             + 1.2273491778951905095051177728911e7*y
             + 1.2273491778951905095051177728911e7*z)))))));
          case ( 132 ):
            return 30.822070014844882251250961907271
             + z*(-184.93242008906929350750577144363
             + 184.93242008906929350750577144363*z)
             + y*(-554.79726026720788052251731433088
             + (3143.8511415141779896275981145417
             - 2958.918721425108696120092343098*z)*z
             + y*(2126.7228310242968753363163716017
             + z*(-9616.4858446316032623903001150686
             + 6657.567123206494566270207771971*z)
             + y*(-2712.3421613063496381100846478399
             + 1109.5945205344157610450346286618*y
             + 6657.567123206494566270207771971*z)))
             + x*(-1972.6124809500724640800615620654
             + (11650.742465611365490972863600949
             - 11465.810045522296197465357829505*z)*z
             + y*(34952.227396834096472918590802846
             + z*(-194918.77077387903535691108310158
             + 180494.04200693163046332563292898*z)
             + y*(-131856.81552350640627085161503931
             + y*(165452.87183968732792471516351823
             - 66575.67123206494566270207771971*y
             - 399454.02739238967397621246631824*z)
             + (586605.63652252779900580830701919
             - 399454.02739238967397621246631824*z)*z))
             + x*(29774.119634340156254708429202424
             + z*(-166993.9753404295720372777116136
             + 155528.16529490727583981235378409*z)
             + y*(-500981.92602128871611183313484079
             + (2.6439788100134236892768100143295e6
             - 2.3079566027115847829736720276165e6*z)*z
             + y*(1.788573900891433672157842068517e6
             + z*(-7.5008589588126505446644340897535e6
             + 4.7934483287086760877145495958188e6*z)
             + y*(-2.1156268858189527177258660253151e6
             + 798908.0547847793479524249326365*y
             + 4.7934483287086760877145495958188e6*z)))
             + x*(-183822.82556853487774646073681497
             + (935942.9780707796944414867092762
             - 780414.8127758724186016743554921*z)*z
             + y*(2.8078289342123390833244601278286e6
             + z*(-1.3267051817189831116228464043366e7
             + 1.0178680401702373914653117660257e7*z)
             + y*(-8.9747703469225328139192550881592e6
             + y*(9.3304570348938427550986911885691e6
             - 3.01809709585361087004249418996e6*y
             - 1.810858257512166522025496513976e7*z)
             + (3.3080711305532715222622632395836e7
             - 1.810858257512166522025496513976e7*z)*z))
             + x*(570239.11734464516653039404624642
             + z*(-2.4854917259970913047408775682024e6
             + 1.7050769132212188861392032127102e6*z)
             + y*(-7.4564751779912739142226327046071e6
             + (2.8986307524760721064366454616074e7
             - 1.7102550209837128263574133743107e7*z)*z
             + y*(1.9608384502044017190600836946168e7
             + z*(-5.5583288181970666856615934665097e7
             + 2.037215539701187337278683578223e7*z)
             + y*(-1.5677337692350700908276289264514e7
             + 3.395359232835312228797805963705e6*y
             + 2.037215539701187337278683578223e7*z)))
             + x*(-970895.20546761379091440530007904
             + (3.3398795068085914407455542322719e6
             - 1.6348025935873725546063510195617e6*z)*z
             + x*(923429.21764475267224747881874185
             + z*(-2.2006957990599245927393186801792e6
             + 565893.2054725520381329676606175*z)
             + x*(-461098.16742207943847871439013278
             + 94315.53424542533968882794343625*x
             + 1.6976796164176561143989029818525e6*y
             + 565893.2054725520381329676606175*z)
             + y*(-6.6020873971797737782179560405375e6
             + 6.507771862934348438529128097101e6*y
             + 9.620184493033384648260450230497e6*z))
             + y*(1.0019638520425774322236662696816e7
             + z*(-2.7791644090985333428307967332548e7
             + 9.05429128756083261012748256988e6*z)
             + y*(-1.8800229826254784377973036724959e7
             + 8.29976701359742989261685902239e6*y
             + 2.942644668457270598291431835211e7*z)))))));
          case ( 133 ):
            return 36.46916505762093808125066058733
             + z*(-437.62998069145125697500792704796
             + (1094.0749517286281424375198176199
             - 729.3833011524187616250132117466*z)*z)
             + y*(-437.62998069145125697500792704796
             + z*(4813.9297876059638267250871975276
             + z*(-10940.749517286281424375198176199
             + 6564.449710371768854625118905719*z))
             + y*(1094.0749517286281424375198176199
             + y*(-1021.1366216133862662750184964452
             + 328.22248551858844273125594528597*y
             + 3938.6698262230613127750713434317*z)
             + z*(-8314.9696331375738825251506139113
             + 9846.674565557653281937678358579*z)))
             + x*(-2334.0265636877400372000422775891
             + z*(27570.688783561429189425499404022
             + z*(-67832.647007174944831126228692434
             + 44492.381370297544459125805916543*z))
             + y*(27570.688783561429189425499404022
             + y*(-67832.647007174944831126228692434
             + y*(62289.33391841656224277612828316
             - 19693.349131115306563875356717158*y
             - 236320.1895733836787665042806059*z)
             + (507213.14762139200683403418744859
             - 590800.4739334591969162607015147*z)*z)
             + z*(-298463.64683156975725695540624671
             + (667385.72055446316688688708874814
             - 393866.98262230613127750713434317*z)*z))
             + x*(35229.213445661826186488138127361
             + z*(-395179.87256438048504843215812431
             + (920117.03440377626778995416661834
             - 568918.9748988866340675103051623*z)*z)
             + y*(-395179.87256438048504843215812431
             + z*(4.0485149513766155782757983331207e6
             + z*(-8.5337846234832995110126545774352e6
             + 4.726403791467673575330085612118e6*z))
             + y*(920117.03440377626778995416661834
             + y*(-796486.56485844128769451442722729
             + 236320.1895733836787665042806059*y
             + 2.8358422748806041451980513672708e6*z)
             + z*(-6.4856763138473076283696174788508e6
             + 7.089605687201510362995128418177e6*z)))
             + x*(-217502.10040365127471657893974284
             + z*(2.2148453322794348115505151187897e6
             + z*(-4.616996296294810761086333630356e6
             + 2.5090785559643205399900454484083e6*z))
             + y*(2.2148453322794348115505151187897e6
             + y*(-4.616996296294810761086333630356e6
             + y*(3.5127099783500487559860636277716e6
             - 892765.1606105605642290161711778*y
             - 1.0713181927326726770748194054134e7*z)
             + (2.8603495537993254155886518111855e7
             - 2.6782954818316816926870485135335e7*z)*z)
             + z*(-2.0314783703697167348779867973566e7
             + (3.7636178339464808099850681726125e7
             - 1.7855303212211211284580323423557e7*z)*z))
             + x*(674716.02273104497544121847152619
             + z*(-5.8817469404931048937441065395246e6
             + (1.0087371054937951473273932718456e7
             - 4.2158354806609804421925763638954e6*z)*z)
             + y*(-5.8817469404931048937441065395246e6
             + z*(4.4384432641726986482405303961204e7
             + z*(-6.323753220991470663288864545843e7
             + 2.0087216113737612695152863851501e7*z))
             + y*(1.0087371054937951473273932718456e7
             + y*(-5.9021696729253726190696069094535e6
             + 1.0043608056868806347576431925751e6*y
             + 1.2052329668242567617091718310901e7*z)
             + z*(-4.8060524479535177040995370548407e7
             + 3.0130824170606419042729295777252e7*z)))
             + x*(-1.1487786993150595495593958085009e6
             + z*(7.9035974512876097009686431624862e6
             + z*(-9.6716225732810727791476751877599e6
             + 2.2319129015264014105725404279446e6*z))
             + x*(1.0926161851263233049142697911964e6
             + x*(-545578.70926200923369550988238646
             + 111595.64507632007052862702139723*x
             + 1.3391477409158408463435242567668e6*y
             + 1.3391477409158408463435242567668e6*z)
             + z*(-5.2077967702282699580025943318707e6
             + 3.3478693522896021158588106419169e6*z)
             + y*(-5.2077967702282699580025943318707e6
             + 3.3478693522896021158588106419169e6*y
             + 1.4730625150074249309778766824434e7*z))
             + y*(7.9035974512876097009686431624862e6
             + y*(-9.6716225732810727791476751877599e6
             + 3.1246780621369619748015565991224e6*y
             + 2.5443807077400976080526960878568e7*z)
             + z*(-4.2555139322436720228249770826144e7
             + 3.3478693522896021158588106419169e7*z)))))));
          case ( 134 ):
            return 41.352146256270665303867737658803
             + z*(-827.04292512541330607735475317605
             + z*(3721.6931630643598773480963892922
             + z*(-5789.3004758778931425414832722324
             + 2894.6502379389465712707416361162*z)))
             + y*(-165.40858502508266121547095063521
             + y*(248.11287753762399182320642595282
             + y*(-165.40858502508266121547095063521
             + 41.352146256270665303867737658803*y
             + 827.0429251254133060773547531761*z)
             + z*(-2481.1287753762399182320642595282
             + 3721.6931630643598773480963892922*z))
             + z*(2481.1287753762399182320642595282
             + z*(-7443.3863261287197546961927785845
             + 5789.300475877893142541483272232*z)))
             + x*(-2646.5373604013225794475352101634
             + y*(10420.740856580207656574669890018
             + z*(-153829.98407332687493038798409075
             + (454046.56589385190503646775949365
             - 347358.02855267358855248899633394*z)*z)
             + y*(-15382.998407332687493038798409075
             + y*(10089.923686530042334143727988748
             - 2481.1287753762399182320642595282*y
             - 49622.575507524798364641285190563*z)
             + (151348.85529795063501215591983122
             - 223301.58978386159264088578335753*z)*z))
             + z*(52103.704282901038282873349450091
             + z*(-230744.97610999031239558197613612
             + (353147.32902855148169503047960617
             - 173679.01427633679427624449816697*z)*z))
             + x*(39946.173283557462683536234578403
             + z*(-746819.76138824821538785134211797
             + z*(3.1299439501371266568497490633948e6
             + z*(-4.5156543711847566511823569523412e6
             + 2.0841481713160415313149339780036e6*z)))
             + y*(-149363.95227764964307757026842359
             + y*(208662.93000914177712331660422632
             + y*(-129018.69631956447574806734149546
             + 29773.545304514879018784771114338*y
             + 595470.9060902975803756954222868*z)
             + z*(-1.935280444793467136221010122432e6
             + 2.6796190774063391116906294002904e6*z))
             + z*(2.0866293000914177712331660422632e6
             + z*(-5.8058413343804014086630303672959e6
             + 4.1682963426320830626298679560073e6*z)))
             + x*(-246624.2002723982478722671873971
             + y*(837132.8488119433484114984811648
             + z*(-1.0470363432087732454939311175209e7
             + (2.5605248961882795956154903158331e7
             - 1.5746897294387869347712834500472e7*z)*z)
             + y*(-1.0470363432087732454939311175209e6
             + y*(569005.53248628435458122007018512
             - 112477.83781705620962652024643194*y
             - 2.2495567563411241925304049286389e6*z)
             + (8.5350829872942653187183010527768e6
             - 1.0123005403535058866386822178875e7*z)*z))
             + z*(4.185664244059716742057492405824e6
             + z*(-1.5705545148131598682408966762813e7
             + (1.9915193637019952410342702456479e7
             - 7.873448647193934673856417250236e6*z)*z))
             + x*(765056.05788726357878685701442551
             + z*(-1.1115456913685554833679647882686e7
             + z*(3.4314010963453398069149448709274e7
             + z*(-3.3462156750574222363889773313503e7
             + 8.857629728093176508088469406516e6*z)))
             + y*(-2.2230913827371109667359295765372e6
             + y*(2.287600730896893204609963247285e6
             + y*(-956061.62144497778182542209467151
             + 126537.56754418823582983527723594*y
             + 2.5307513508837647165967055447187e6*z)
             + z*(-1.4340924321674666727381331420073e7
             + 1.1388381078976941224685174951234e7*z))
             + z*(2.287600730896893204609963247285e7
             + z*(-4.3022772965024000182143994260218e7
             + 1.7715259456186353016176938813031e7*z)))
             + x*(-1.3025926070725259570718337362523e6
             + x*(1.2389103018378691325038774202577e6
             + x*(-618628.10799380915294586135537569
             + 126537.56754418823582983527723594*x
             + 506150.2701767529433193411089437*y
             + 2.5307513508837647165967055447187e6*z)
             + y*(-1.968362161798483668464104312559e6
             + 759225.4052651294149790116634156*y
             + 7.592254052651294149790116634156e6*z)
             + z*(-9.841810808992418342320521562795e6
             + 1.1388381078976941224685174951234e7*z))
             + z*(1.4936395227764964307757026842359e7
             + z*(-3.2899767561488941315757172081343e7
             + 1.7715259456186353016176938813031e7*z))
             + y*(2.9872790455529928615514053684719e6
             + y*(-2.1933178374325960877171448054229e6
             + 506150.2701767529433193411089437*y
             + 7.592254052651294149790116634156e6*z)
             + z*(-2.1933178374325960877171448054229e7
             + 2.2776762157953882449370349902468e7*z)))))));
          case ( 135 ):
            return 15.099668870541499394473369613892
             + y*(-528.48841046895247880656793648623
             + y*(4227.9072837516198304525434918898
             + y*(-12683.721851254859491357630475669
             + (15854.652314068574364197038094587
             - 6976.047018190172720246696761618*y)*y)))
             + x*(-800.28245013869946790708858953629
             + y*(27481.397344385528897941532697284
             + y*(-215623.27147133261135307971808638
             + y*(634186.09256274297456788152378347
             + y*(-776877.96338936014384565486663476
             + 334850.25687312829057184144455767*y))))
             + x*(9935.5821168163066015634772059411
             + y*(-320263.97674418520215678016951065
             + y*(2.3464885424821490059011616379989e6
             + y*(-6.4052795348837040431356033902131e6
             + (7.2297214552152699100738493711316e6
             - 2.8462271834215904698606522787402e6*y)*y)))
             + x*(-50523.492040831856973907894728083
             + y*(1.4480582446849297919299961459723e6
             + y*(-9.2379774149972893295388075297793e6
             + y*(2.1308652710108163945480819199125e7
             + y*(-1.9406094432419935021777174627774e7
             + 5.69245436684318093972130455748e6*y))))
             + x*(130536.6373858312622652222803121
             + x*(-188458.96717322845394242212615099
             + x*(154741.40658530928579456309180317
             + x*(-67767.313890990249282396482827148
             + 12321.329798361863505890269604936*x
             + 431246.54294266522270615943617276*y)
             + y*(-1.9406094432419935021777174627774e6
             + 3.4499723435413217816492754893821e6*y))
             + y*(3.4753397872438315006319907503334e6
             + y*(-1.2074903202394626235772464212837e7
             + 1.0349917030623965344947826468146e7*y)))
             + y*(-3.1207240638191643873527836649512e6
             + y*(1.572781509555602576928346178983e7
             + y*(-2.5874792576559913362369566170366e7
             + 1.2937396288279956681184783085183e7*y)))))));
          case ( 136 ):
            return 26.153393661244041313421891903158
             - 52.30678732248808262684378380632*z
             + y*(-863.0619908210533633429224328042
             + 1673.8171943196186440590010818021*z
             + y*(6486.0416279885222457286291919831
             - 11298.266061657425847398257302164*z
             + y*(-18202.761988225852754141636764598
             + y*(21184.248865607673463871732441558
             - 8630.619908210533633429224328042*y
             - 17261.239816421067266858448656084*z)
             + 25107.257914794279660885016227031*z)))
             + x*(-1386.1298640459341896113602708674
             + 2719.9529407693802965958767579284*z
             + y*(44879.223522694774893831966505819
             - 85364.67691030055084700905517191*z
             + y*(-330788.12302741463453216008879114
             + 564913.3030828712923699128651082*z
             + y*(910138.09941129263770708183822989
             - 1.2302556378249197033833657951245e6*z
             + y*(-1.0380281944147759997297148896363e6
             + 414269.75559410561440460276774602*y
             + 828539.511188211228809205535492*z))))
             + x*(17208.933029098579184231604872278
             - 31697.913117427778071867332986627*z
             + y*(-523015.56643755833818581099427935
             + 928968.5428473883474527456004002*z
             + y*(3.5997531035336298463793892015506e6
             - 5.705624361137000052936119937593e6*z
             + y*(-9.1923948040540556408415265661219e6
             + y*(9.6600174827170990995255099933503e6
             - 3.5212929225498977224391235258412e6*y
             - 7.042585845099795444878247051682e6*z)
             + 1.1448909609146191525363567399526e7*z)))
             + x*(-87509.255190522562234709650307966
             + 143320.5972636173463975519676293*z
             + y*(2.3647898548496862155596074658835e6
             - 3.6572905695883667372689173637376e6*z
             + y*(-1.4172000957154921106917054784483e7
             + 1.8981086983584475423629072267636e7*z
             + y*(3.0580640140219432626957949764524e7
             - 3.0731283687708198304923259861886e7*z
             + y*(-2.5929520611503792319779000508467e7
             + 7.042585845099795444878247051682e6*y
             + 1.4085171690199590889756494103365e7*z))))
             + x*(226096.0882014547371545322555028
             - 308871.57913929212791151254337629*z
             + x*(-326420.50628598687963281863284331
             + 343969.43343268163135412472231033*z
             + x*(268019.97824042893537994754822356
             - 192070.52304817623940577037413679*z
             + x*(-117376.43075166325741463745086137
             + 21341.169227575137711752263792977*x
             + 704258.5845099795444878247051682*y
             + 42682.338455150275423504527585953*z)
             + y*(-3.169163630294907950195211173257e6
             + 5.292609968438634152514561420658e6*y
             + 1.3658348305648088135521448827505e6*z))
             + y*(5.6754956516392469173430579181204e6
             - 4.7804219069768308474325070896268e6*z
             + y*(-1.8524134889535219533800964972304e7
             + 1.4853453782392295847379575599912e7*y
             + 9.219385106312459491476977958566e6*z)))
             + y*(-5.0963810557983201105399569657088e6
             + 6.226599962868981355899484024304e6*z
             + y*(2.4128074856117302754110500594177e7
             - 2.3048462765781148728692444896415e7*z
             + y*(-3.7133634455980739618448938999779e7
             + 1.7286347074335861546519333672311e7*y
             + 2.0487522458472132203282173241258e7*z)))))));
          case ( 137 ):
            return 33.763886032268264366233778819044
             + z*(-202.58331619360958619740267291427
             + 202.58331619360958619740267291427*z)
             + y*(-979.15269493577966662077958575228
             + (5672.3328534210684135272748415994
             - 5469.749537227458827329872168685*z)*z
             + y*(6415.1383461309702295844179756184
             + z*(-32818.497223364752963979233012111
             + 27348.747686137294136649360843426*z)
             + y*(-15598.915346907938137200005814398
             + y*(15700.207005004742930298707150856
             - 5571.041195324263620428573505142*y
             - 33426.247171945581722571441030854*z)
             + (60774.99485808287585922080187428
             - 33426.247171945581722571441030854*z)*z)))
             + x*(-1789.4859597102180114103902774093
             + (10534.332442067698482264938991542
             - 10331.749125874088896067536318628*z)*z
             + y*(50915.940136660542664280538459119
             + z*(-289288.97552447448908989101692157
             + 273487.47686137294136649360843426*z)
             + y*(-327172.05565267948170880531675654
             + (1.6409248611682376481989616506055e6
             - 1.3400886366207274126958186813279e6*z)*z
             + y*(779945.76734539690686000029071992
             + z*(-2.9779747480460609171018192918397e6
             + 1.604459864253387922683429169481e6*z)
             + y*(-769310.14324523240358463665039192
             + 267409.97737556465378057152824683*y
             + 1.604459864253387922683429169481e6*z))))
             + x*(22216.637009232517952981826462931
             + z*(-122765.48961332740923562601978604
             + 112433.74048745332033955848346742*z)
             + y*(-593366.53313108247797219242896588
             + (3.1481447336486929695076375370877e6
             - 2.762223516299866707801585445186e6*z)*z
             + y*(3.5604017821026884774193519764682e6
             + z*(-1.6573341097799200246809512671116e7
             + 1.2471028944878606126312108544602e7*z)
             + y*(-7.8774522501885087592860029362712e6
             + y*(7.1592943942821627762162104607901e6
             - 2.2729848076922995571348579900981e6*y
             - 1.3637908846153797342809147940588e7*z)
             + (2.7713397655285791391804685654671e7
             - 1.3637908846153797342809147940588e7*z)*z)))
             + x*(-112973.96266396961256941822392852
             + (555078.28637049026618088332378509
             - 442644.54588303694584132484031767*z)*z
             + y*(2.6828783841240362865409360649613e6
             + z*(-1.2394047284725034483557095528895e7
             + 9.189179222542130829914185243391e6*z)
             + y*(-1.4017077286296169951641953276726e7
             + (5.5135075335252784979485111460346e7
             - 3.3474867167832048023258817672353e7*z)*z
             + y*(2.6206177782805336070496009768189e7
             + z*(-7.4388593706293440051686261494118e7
             + 2.7275817692307594685618295881177e7*z)
             + y*(-1.9217053374125805346685617552647e7
             + 4.5459696153845991142697159801961e6*y
             + 2.7275817692307594685618295881177e7*z))))
             + x*(291888.79474895914544609101789064
             + z*(-1.1962544821232646064956627835587e6
             + 753609.9362402276606543379432411*z)
             + x*(-421407.06156874020755496379344049
             + (1.3321878872891766388341199770842e6
             - 578577.9510489489781797820338431*z)*z
             + x*(346012.30405868517322516376533757
             + z*(-743885.93706293440051686261494118
             + 165307.98601398542233708058109804*z)
             + x*(-151532.32051281997047565719933987
             + 27551.33100233090372284676351634*x
             + 798988.5990675962079625561419739*y
             + 165307.98601398542233708058109804*z)
             + y*(-3.5954486958041829358315026388824e6
             + 5.234752890442871707340885068105e6*y
             + 4.6286236083915918254382562707451e6*z))
             + y*(6.438908121897687087698246555907e6
             + z*(-1.6200182629370571389033896947608e7
             + 4.4633156223776064031011756896471e6*z)
             + y*(-1.8321635116550050975693097738366e7
             + 1.2728714923076877519955204744549e7*y
             + 2.6779893734265638418607054137883e7*z)))
             + y*(-5.7818966635957789313957034538672e6
             + (2.110107821472637449832146241075e7
             - 1.1158289055944016007752939224118e7*z)*z
             + y*(2.38643146476072092540540348693e7
             + z*(-6.6949734335664096046517635344706e7
             + 2.2316578111888032015505878448235e7*z)
             + y*(-3.1821787307692193799888011861373e7
             + 1.2811368916083870231123745035098e7*y
             + 4.9592395804195626701124174329412e7*z)))))));
          case ( 138 ):
            return 39.949968710876357831560764656117
             + z*(-479.3996245305162939787291758734
             + (1198.4990613262907349468229396835
             - 798.9993742175271566312152931223*z)*z)
             + y*(-918.84928035015623012589758709068
             + z*(10546.791739671358467532041869215
             + z*(-25168.480287852105433883281733353
             + 15979.987484350543132624305862447*z))
             + y*(4714.0963078834102241241702294218
             + y*(-9028.6929286580568699327328122823
             + y*(7390.7442115121261988387414613816
             - 2197.2482790981996807358420560864*y
             - 26366.979349178396168830104673037*z)
             + (62321.951188967118217234792863542
             - 65917.44837294599042207526168259*z)*z)
             + z*(-46022.363954929564221958000883846
             + (89887.429599471805121011720476262
             - 43944.965581963993614716841121728*z)*z)))
             + x*(-2117.3483416764469650727205267742
             + z*(24928.780475586847286893917145417
             + z*(-61123.452127640827482287969923858
             + 39949.968710876357831560764656117*z))
             + y*(47780.162578208123966546674528715
             + z*(-537886.37872323928184413413532995
             + (1.2584240143926052716941640866677e6
             - 783019.3867331766134985909872599*z)*z)
             + y*(-240418.91170205392143033268170051
             + z*(2.3011181977464782110979000441923e6
             + z*(-4.4044840503741184509295743033369e6
             + 2.109358347934271693506408373843e6*z))
             + y*(451434.64643290284349663664061412
             + y*(-362146.4663640941837430983316077
             + 105467.91739671358467532041869215*y
             + 1.2656150087605630161038450243058e6*z)
             + z*(-3.0537756082593887926445048503136e6
             + 3.1640375219014075402596125607644e6*z))))
             + x*(26287.079411756643453166983143725
             + z*(-290516.17246549287415110988057928
             + (665166.97903609135789548673152434
             - 403494.68397985121409876372302678*z)*z)
             + y*(-556822.66389219467545629393777695
             + z*(5.8534694155176039494802832374142e6
             + z*(-1.2710082545365313244111057275343e7
             + 7.286874292863847668476683473276e6*z))
             + y*(2.6163234508752926743889144773291e6
             + y*(-4.5594899289723187193160300702026e6
             + y*(3.37017936044952954667046610639e6
             - 896477.2978720654697402235588833*y
             - 1.0757727574464785636882682706599e7*z)
             + (2.8418809742169005907059065545775e7
             - 2.6894318936161964092206706766498e7*z)*z)
             + z*(-2.3241293797239429932088790446342e7
             + (4.0988667897359143135181344537176e7
             - 1.7929545957441309394804471177665e7*z)*z)))
             + x*(-133672.59530659229330440231853937
             + z*(1.3135549712136146455017179418931e6
             + z*(-2.6187204489979452558588081232084e6
             + 1.3423189486854456231404416924455e6*z))
             + y*(2.5176470281594280705449593886285e6
             + z*(-2.3044739951181918251557511484234e7
             + (4.2283046883591537128923913312034e7
             - 1.9559504680845064794332150375635e7*z)*z)
             + y*(-1.0300300432725251339711311951287e7
             + z*(7.7317571444281667892889441484862e7
             + z*(-1.1002221382975348946811834586295e8
             + 3.585909191488261878960894235533e7*z))
             + y*(1.5168204120145535541486991124634e7
             + y*(-9.046270914890842467378619548731e6
             + 1.7929545957441309394804471177665e6*y
             + 2.1515455148929571273765365413198e7*z)
             + z*(-7.6282068255295752697895386464975e7
             + 5.3788637872323928184413413533e7*z))))
             + x*(345367.47950552611345384281045213
             + z*(-2.8308547828526987159443957835324e6
             + (4.4584165081338015340021813356226e6
             - 1.6299587234037553995276791979696e6*z)*z)
             + x*(-498615.55948044782209570990367299
             + z*(3.1525319309126751492041230605435e6
             + z*(-3.4229133191478863390081263157361e6
             + 651983.4893615021598110716791878*z))
             + x*(409407.27934906091505783471619588
             + x*(-179295.45957441309394804471177665
             + 32599.174468075107990553583959391*x
             + 749781.012765727483782732431066*y
             + 391190.09361690129588664300751269*z)
             + z*(-1.7603554212760558314898935338071e6
             + 977975.2340422532397166075187817*z)
             + y*(-3.374014557445773677022295939797e6
             + 3.8467025872328627428853229072082e6*y
             + 8.606182059571828509506146165279e6*z))
             + y*(6.0423528675826273693079025327083e6
             + z*(-3.0121637208501399783271511578477e7
             + 2.0537479914887318034048757894416e7*z)
             + y*(-1.3463459055315019600098630175229e7
             + 7.367413429784974405865109974822e6*y
             + 3.7554248987222524405117728721219e7*z)))
             + y*(-5.4258050004676725388934252517705e6
             + z*(3.9234065271577453499219195753479e7
             + z*(-5.1343699787218295085121894736041e7
             + 1.3039669787230043196221433583756e7*z))
             + y*(1.7536438265326286033741913253449e7
             + y*(-1.8418533574462436014662774937056e7
             + 6.030847276593894978252413032487e6*y
             + 5.085471217019716846526359097665e7*z)
             + z*(-9.3885622468056311012794321803046e7
             + 7.334814255316899297874556390863e7*z)))))));
          case ( 139 ):
            return 45.299006611624498183420108841677
             + z*(-905.98013223248996366840217683353
             + z*(4076.9105950462048365078097957509
             + z*(-6341.8609256274297456788152378347
             + 3170.9304628137148728394076189174*z)))
             + y*(-679.48509917436747275130163262515
             + y*(2264.9503305812249091710054420838
             + z*(-32615.284760369638692062478366007
             + (93768.943686062711239679625302271
             - 69760.47018190172720246696761618*z)*z)
             + y*(-3170.9304628137148728394076189174
             + y*(2038.4552975231024182539048978755
             - 498.28907272786948001762119725844*y
             - 9965.781454557389600352423945169*z)
             + (30803.32449590465876472567401234
             - 44846.01654550825320158590775326*z)*z))
             + z*(12683.721851254859491357630475669
             + z*(-52999.837735600662874601527344762
             + (76102.331107529156948145782854017
             - 34880.235090950863601233483808091*z)*z)))
             + x*(-2400.8473504160984037212657686089
             + z*(47110.966876089478110756913195344
             + z*(-207922.4403473564466618982995833
             + (317093.04628137148728394076189174
             - 155375.59267787202876913097332695*z)*z))
             + y*(35333.225157067108583067684896508
             + z*(-646869.81441399783405923915425914
             + z*(2.6499918867800331437300763672381e6
             + z*(-3.7290142242689286904591433598468e6
             + 1.6742512843656414528592072227884e6*z)))
             + y*(-115512.46685964247036772127754628
             + y*(158546.52314068574364197038094587
             + y*(-99884.309578632018494441339995897
             + 23917.875490937735040845817468405*y
             + 478357.50981875470081691634936811*z)
             + z*(-1.5093629002993282794715580266047e6
             + 2.1526087941843961536761235721565e6*z))
             + z*(1.6307642380184819346031239183004e6
             + z*(-4.5946782406170728507443016398113e6
             + 3.3485025687312829057184144455767e6*z))))
             + x*(29806.746350448919804690431617823
             + z*(-549023.96013288891798305171916112
             + z*(2.2626853802506436842618344366418e6
             + z*(-3.2026397674418520215678016951065e6
             + 1.4459442910430539820147698742263e6*z)))
             + y*(-411767.97009966668848728878937084
             + y*(1.2570474334725798245899080203565e6
             + z*(-1.6470718803986667539491551574834e7
             + (4.2758638320844596325293909137835e7
             - 2.8462271834215904698606522787402e7*z)*z)
             + y*(-1.6013198837209260107839008475533e6
             + y*(929535.61567053470272378063343121
             - 203301.94167297074784718944848145*y
             - 4.0660388334594149569437889696289e6*z)
             + (1.4046315970132524396714907349627e7
             - 1.829717475056736730624705036333e7*z)*z))
             + z*(7.0394656274464470177034849139966e6
             + z*(-2.6764918056478334751673771309105e7
             + (3.4702662985033295568354476981432e7
             - 1.4231135917107952349303261393701e7*z)*z)))
             + x*(-151570.47612249557092172368418425
             + z*(2.4823855623170225004514219645239e6
             + z*(-8.9080496501759575677695644037157e6
             + (1.0654326355054081972740409599562e7
             - 3.8812188864839870043554349255549e6*z)*z))
             + y*(1.8617891717377668753385664733929e6
             + z*(-2.7713932244991867988616422589338e7
             + z*(8.90397273958091136293305659392e7
             + z*(-9.3149253275615688104530438213317e7
             + 2.8462271834215904698606522787402e7*z)))
             + y*(-4.9489164723199764265386468909532e6
             + y*(5.3271631775270409863702047997812e6
             + y*(-2.4950692841682773599427795949996e6
             + 406603.88334594149569437889696289*y
             + 8.132077666918829913887577939258e6*z)
             + z*(-3.7703269182987302328024224991104e7
             + 3.659434950113473461249410072666e7*z))
             + z*(5.4793678397420993002664963654892e7
             + z*(-1.1477318707174075855736786136998e8
             + 5.69245436684318093972130455748e7*z))))
             + x*(391609.9121574937867956668409363
             + z*(-5.349812680832853235461914854202e6
             + z*(1.5166107413571881991809052440193e7
             + z*(-1.2937396288279956681184783085183e7
             + 2.5874792576559913362369566170366e6*z)))
             + x*(-565376.90151968536182726637845297
             + z*(5.9577253495608540010834127148573e6
             + z*(-1.1643656659451961013066304776665e7
             + 5.174958515311982672473913234073e6*z))
             + x*(464224.2197559278573836892754095
             + x*(-203301.94167297074784718944848145
             + 36963.989395085590517670808814808*x
             + 554459.8409262838577650621322221*y
             + 739279.7879017118103534161762962*z)
             + z*(-3.3267590455577031465903727933327e6
             + 3.3267590455577031465903727933327e6*z)
             + y*(-2.4950692841682773599427795949996e6
             + 1.8481994697542795258835404407404e6*y
             + 1.0349917030623965344947826468146e7*z))
             + y*(4.468294012170640500812559536143e6
             + y*(-6.4686981441399783405923915425914e6
             + 2.5874792576559913362369566170366e6*y
             + 2.6614072364461625172722982346662e7*z)
             + z*(-3.6224709607183878707317392638512e7
             + 4.3247867592250140905674846313326e7*z)))
             + y*(-4.0123595106246399265964361406515e6
             + z*(4.718344528666807730785038536949e7
             + z*(-1.0811966898062535226418711578331e8
             + 6.209950218374379206968695880888e7*z))
             + y*(8.4256152297621566621161402445519e6
             + y*(-6.4686981441399783405923915425914e6
             + 1.6633795227788515732951863966664e6*y
             + 2.513551278865820155201614999407e7*z)
             + z*(-6.6535180911154062931807455866655e7
             + 7.651545804782717237157857424665e7*z)))))));
          case ( 140 ):
            return 50.07993610219565765375626235541
             + z*(-1502.3980830658697296126878706623
             + z*(10516.786581461088107288815094636
             + z*(-28044.764217229568286103506919029
             + (31550.359744383264321866445283908
             - 12620.143897753305728746578113563*z)*z)))
             + y*(-250.39968051097828826878131177705
             + z*(6009.5923322634789184507514826492
             + z*(-31550.359744383264321866445283908
             + (56089.528434459136572207013838059
             - 31550.359744383264321866445283908*z)*z))
             + y*(500.7993610219565765375626235541
             + z*(-9014.3884983952183776761272239737
             + (31550.359744383264321866445283908
             - 28044.764217229568286103506919029*z)*z)
             + y*(-500.7993610219565765375626235541
             + y*(250.39968051097828826878131177705
             - 50.07993610219565765375626235541*y
             - 1502.3980830658697296126878706623*z)
             + (6009.5923322634789184507514826492
             - 10516.786581461088107288815094636*z)*z)))
             + x*(-2654.2366134163698556490819048367
             + z*(78124.700319425225939859769274439
             + z*(-536356.11565451549347172956982644
             + z*(1.4022382108614784143051753459515e6
             + z*(-1.5459676274747799517714558189115e6
             + 605766.907092158674979835749451*z))))
             + y*(13020.783386570870989976628212407
             + y*(-25540.767412119785403415693801259
             + y*(25039.968051097828826878131177705
             + y*(-12269.584345037936125170284277075
             + 2403.8369329053915673803005930597*y
             + 72115.10798716174702140901779179*z)
             + z*(-294470.02428091046700408682264981
             + 504805.7559101322291498631245425*z))
             + z*(450719.42491976091888380636119869
             + z*(-1.5459676274747799517714558189115e6
             + 1.3461486824270192777329683321134e6*z)))
             + z*(-306489.20894543742484098832561511
             + z*(1.5775179872191632160933222641954e6
             + z*(-2.7483868932884976920381436780649e6
             + 1.5144172677303966874495893736276e6*z))))
             + x*(32952.59795524474273617162062986
             + z*(-910453.23833791705614528884962135
             + z*(5.836816552710903899545292377523e6
             + z*(-1.416260592970093198448227099411e7
             + (1.4386964043438768530771099049462e7
             - 5.149018710283348737328603870334e6*z)*z)))
             + y*(-151742.20638965284269088147493689
             + z*(3.3353237444062307997401670728703e6
             + z*(-1.5932931670913548482542554868374e7
             + (2.5576824966113366276926398310155e7
             - 1.2872546775708371843321509675834e7*z)*z))
             + y*(277943.64536718589997834725607252
             + z*(-4.5522661916895852807264442481067e6
             + (1.4386964043438768530771099049462e7
             - 1.1442263800629663860730230822964e7*z)*z)
             + y*(-252903.67731608807115146912489482
             + y*(114182.25431300609945056427817033
             - 20432.613929695828322732555041007*y
             - 612978.4178908748496819766512302*z)
             + (2.740374103512146386813542676088e6
             - 4.2908489252361239477738365586115e6*z)*z)))
             + x*(-167567.4661979466705094684538412
             + z*(4.1165707476004830591387647656147e6
             + z*(-2.297917868049247751442606098178e7
             + z*(4.7115203884945674720653891623969e7
             + z*(-3.8617640327125115529964529027503e7
             + 1.0298037420566697474657207740668e7*z))))
             + y*(686095.12460008050985646079426911
             + y*(-1.0942466038329751197345743324657e6
             + y*(841342.92651688704858310520757088
             + y*(-306489.20894543742484098832561511
             + 40865.227859391656645465110082014*y
             + 1.2259568357817496993639533024604e6*z)
             + z*(-7.3557410146904981961837198147626e6
             + 8.581697850472247895547673117223e6*z))
             + z*(1.5144172677303966874495893736276e7
             + z*(-3.8617640327125115529964529027503e7
             + 2.2884527601259327721460461645928e7*z)))
             + z*(-1.3130959245995701436814891989588e7
             + z*(5.3004604370563884060735628076966e7
             + z*(-6.8653582803777983164381384937784e7
             + 2.5745093551416743686643019351669e7*z))))
             + x*(432941.04760348146041672288806252
             + z*(-8.8716606805039607533629218762608e6
             + z*(3.9122446083035247759114392152046e7
             + z*(-5.721131900314831930365115411482e7
             + 2.5745093551416743686643019351669e7*z)))
             + x*(-625047.68249150400317653191045787
             + x*(513219.18517530109963569417661824
             + x*(-224758.75322665411155005810545108
             + 40865.227859391656645465110082014*x
             + 204326.13929695828322732555041007*y
             + 1.2259568357817496993639533024604e6*z)
             + y*(-919467.62683631227452296497684532
             + 408652.27859391656645465110082014*y
             + 4.9038273431269987974558132098417e6*z)
             + z*(-5.5168057610178736471377898610719e6
             + 8.581697850472247895547673117223e6*z))
             + z*(9.8797697942411593419330354374752e6
             + z*(-3.003594247665286763441685591028e7
             + 2.2884527601259327721460461645928e7*z))
             + y*(1.6466282990401932236555059062459e6
             + y*(-1.4302829750787079825912788528705e6
             + 408652.27859391656645465110082014*y
             + 7.355741014690498196183719814763e6*z)
             + z*(-1.7163395700944495791095346234446e7
             + 2.5745093551416743686643019351669e7*z)))
             + y*(-1.4786101134173267922271536460435e6
             + y*(1.8629736230016784647197329596212e6
             + y*(-1.0216306964847914161366277520504e6
             + 204326.13929695828322732555041007*y
             + 4.9038273431269987974558132098417e6*z)
             + z*(-1.8389352536726245490459299536906e7
             + 2.5745093551416743686643019351669e7*z))
             + z*(2.2355683476020141576636795515455e7
             + z*(-6.4362733878541859216607548379172e7
             + 4.5769055202518655442920923291856e7*z)))))));
          case ( 141 ):
            return 16.309506430300090476125767887696
             + y*(-782.85630865440434285403685860942
             + y*(8807.133472362048857107914659356
             + y*(-39142.815432720217142701842930471
             + y*(80732.056829985447856822551044096
             + y*(-77502.774556786029942549649002333
             + 27987.113034394955257031817695287*y)))))
             + x*(-652.38025721200361904503071550785
             + y*(30531.396037521769371307437485767
             + y*(-334671.07194975785657010075705553
             + y*(1.4482841710106480342799681884274e6
             + y*(-2.9063540458794761228456118375875e6
             + (2.7125971094875110479892377150816e6
             - 951561.8431694284787390818016397*y)*y))))
             + x*(6067.136392071633657118785654223
             + y*(-260691.15078191664617039427391694
             + y*(2.59810437434680441284683482451e6
             + y*(-1.0098846381641816022817075476062e7
             + y*(1.7922516616256769424214606331789e7
             + y*(-1.4493018842118987599256784363436e7
             + 4.2820282942624281543258681073789e6*y)))))
             + x*(-23616.165311074531009430111901384
             + y*(872884.7841496608422822510973495
             + y*(-7.2218494473368800628284900206719e6
             + y*(2.1998262273188762034198435726925e7
             + y*(-2.7448899322195052271319667354993e7
             + 1.1857924507188262581210096297357e7*y))))
             + x*(48765.424226597270523616045984212
             + x*(-58322.794994753123542625745966402
             + x*(40773.766075750226190314419719241
             + x*(-15526.650121645686133271731029087
             + 2495.3544838359138428472424868175*x
             + 119777.01522412386445666763936724*y)
             + y*(-625502.19061486906994037545002893
             + 1.3474914212713934751375109428815e6*y))
             + y*(1.3316385810211417871947166964946e6
             + y*(-5.689408223145883561691712869944e6
             + 5.988850761206193222833381968362e6*y)))
             + y*(-1.4678555787270081428513191098927e6
             + y*(9.2915258133419615442488499656205e6
             + y*(-1.9297408008331067051352008564722e7
             + 1.2352004694987773522093850309747e7*y)))))));
          case ( 142 ):
            return 28.248893783651068838184248649521
             - 56.49778756730213767636849729904*z
             + y*(-1299.449114047949166556475437878
             + 2542.4004405285961954365823784569*z
             + y*(13983.202422907279074901203081513
             - 25424.004405285961954365823784569*z
             + y*(-59322.676945667244560186922163994
             + 93221.34948604852716600802054342*z
             + y*(116526.68685756065895751002567927
             - 139832.02422907279074901203081513*z
             + y*(-106272.3384140953209692491434195
             + 36356.326299558925594743128011933*y
             + 72712.65259911785118948625602387*z)))))
             + x*(-1129.9557513460427535273699459808
             + 2203.4137151247833693783713946626*z
             + y*(50678.51544787001749570254207724
             - 96611.21674008665542659013038136*z
             + y*(-531361.69207047660484624571709749
             + 940688.162995580592311535480029*z
             + y*(2.1949390469896880487269161200678e6
             - 3.3559685814977469779762887395631e6*z
             + y*(-4.1949607268721837224703609244538e6
             + y*(3.7195318444933362339237200196824e6
             - 1.2361150941850034702212663524057e6*y
             - 2.4722301883700069404425327048115e6*z)
             + 4.8941208480175476762154210785295e6*z))))
             + x*(10508.588487518197607804540497622
             - 18813.763259911611846230709600581*z
             + y*(-432716.55497796707246330632081336
             + 750008.1299559358776537918016448*z
             + y*(4.1250447147576473270958549090463e6
             - 6.559393136563778184226382536419e6*z
             + y*(-1.530525065198214909652822591831e7
             + 2.0695139585902773030853780560639e7*z
             + y*(2.5868924482378466288567225700799e7
             - 2.6148588530836611870065249762429e7*z
             + y*(-1.9872927283435825021249589819446e7
             + 5.562517923832515615995698585826e6*y
             + 1.1125035847665031231991397171652e7*z)))))
             + x*(-40904.398198726747677690792044506
             + 62995.03313754188350915087448843*z
             + x*(84464.192413116695826170903462067
             - 105933.3516886915081431909324357*z
             + x*(-101018.04417033622216534687317069
             + 96102.73665198093618750281390567*z
             + x*(70622.234459127672095460621623802
             - 45141.732266274408003418429341934*z
             + x*(-26892.946882035817533951404714344
             + 4322.0807488986135322421900433767*x
             + 198815.71444933622248314074199533*y
             + 8644.161497797227064484380086753*z)
             + y*(-1.0382598421243113840786238748645e6
             + 2.1394299707048136984598840714715e6*y
             + 388987.2674008752179017971039039*z))
             + y*(2.2103629429955615323125647198304e6
             - 1.6423906845814731422520322164831e6*z
             + y*(-9.0331487651981022823861771906572e6
             + 9.076369572687088417708599091091e6*y
             + 3.889872674008752179017971039039e6*z)))
             + y*(-2.4364670888399046872933914460212e6
             + 2.682232464757668986185594409272e6*z
             + y*(1.4752278556167179424020769250996e7
             - 1.2534034171805979243502351125792e7*z
             + y*(-2.9246079734213951568172152626849e7
             + 1.7828583089206780820499033928929e7*y
             + 1.4262866471365424656399227143143e7*z))))
             + y*(1.4488857621634633207104701132339e6
             - 2.0847683612334488802579975503346e6*z
             + y*(-1.146622598678396884141898652684e7
             + 1.4288290475770710618353592966928e7*z
             + y*(3.3339344443464991442825050256164e7
             - 3.1695258825256499236442726984762e7*z
             + y*(-3.9619073531570624045553408730953e7
             + 1.6259667777356584108295118943183e7*y
             + 2.1394299707048136984598840714715e7*z)))))));
          case ( 143 ):
            return 36.46916505762093808125066058733
             + z*(-218.81499034572562848750396352398
             + 218.81499034572562848750396352398*z)
             + y*(-1531.7049324200793994125277446679
             + (8971.4146041747507679876625044832
             - 8752.599613829025139500158540959*z)*z
             + y*(14988.826838682205551394021501393
             + z*(-80961.546427918482540376466503873
             + 72208.94681408945740087630796291*z)
             + y*(-57621.280791041082168376043727982
             + (264766.13831832801046987979586402
             - 192557.1915042385530690034879011*z)*z
             + y*(102296.00798662673131790810294746
             + z*(-349009.90960143237743756882182075
             + 156452.71809719382436856533391965*z)
             + y*(-84243.771283104366967689025956733
             + 26075.453016198970728094222319941*y
             + 156452.71809719382436856533391965*z)))))
             + x*(-1458.7666023048375232500264234932
             + (8533.7846234832995110126545774352
             - 8314.969633137573882525150613911*z)*z
             + y*(59736.492364383096577088582042047
             + z*(-340913.75495864052918353117517036
             + 323846.18571167393016150586601549*z)
             + y*(-569575.41986992381095297281705292
             + (2.9955772178329838539939292606433e6
             - 2.5995220853072204664315470866649e6*z)*z
             + y*(2.1319873892685200402299136179353e6
             + z*(-9.5315809794598083769156726511046e6
             + 6.739501702648349357415122076539e6*z)
             + y*(-3.6826562875185623274446917061086e6
             + y*(2.9485319949086528438691159084856e6
             - 886565.402550765004755203558878*y
             - 5.319392415304590028531221353268e6*z)
             + (1.2215346836050133210314908763726e7
             - 5.319392415304590028531221353268e6*z)*z))))
             + x*(13566.529401434988966225245738487
             + z*(-72865.391785126634286338819853486
             + 64550.42215198906040381366923957*z)
             + y*(-510057.7424958864400043717389744
             + (2.6465673082315514765563604388225e6
             - 2.2581707003678884859910409035675e6*z)*z
             + y*(4.4217039174112506376612363429108e6
             + z*(-2.0888078978402968495417128357999e7
             + 1.6030386192727859542994540367767e7*z)
             + y*(-1.4866290444088599199441019281819e7
             + (5.8778082706668818324313314681812e7
             - 3.6008194811292609423903652237506e7*z)*z
             + y*(2.2709713773031134352575598854336e7
             + z*(-6.526485309546785458082536968048e7
             + 2.3937265868870655128390496089706e7*z)
             + y*(-1.5753585229940516622957847853909e7
             + 3.989544311478442521398416014951e6*y
             + 2.3937265868870655128390496089706e7*z)))))
             + x*(-52807.351003435118341650956530454
             + (243978.71423548407576356691932924
             - 179428.29208349501535975325008966*z)*z
             + x*(109042.80352228660486293947515612
             + z*(-410278.10689823555341406993160746
             + 230849.8148147405380543166815178*z)
             + x*(-130413.73424605247457855236226029
             + (372204.29857807929405724424195429
             - 141354.48376333875600292756043649*z)*z
             + x*(91172.912644052345203126651468325
             + z*(-174833.17728623477716151566685566
             + 33478.693522896021158588106419169*z)
             + x*(-34718.645134855133053350628879138
             + 5579.782253816003526431351069862*x
             + 234350.85466027214811011674493418*y
             + 33478.693522896021158588106419169*z)
             + y*(-1.2238322410036434401306096679896e6
             + 2.2932905063183774493632852897131e6*y
             + 1.3726264344387368675021123631859e6*z))
             + y*(2.60543009004655505840070969368e6
             + z*(-5.7955338342968889961200299778962e6
             + 1.3391477409158408463435242567668e6*z)
             + y*(-9.6827821377887047862005378898997e6
             + 8.816055961029285571761534690381e6*y
             + 1.2387116603471527828677599375093e7*z)))
             + y*(-2.8719467482876488738984895212522e6
             + (9.4648424074043620602269839422298e6
             - 4.3150316096177093937735781606929e6*z)*z
             + y*(1.5813212314809726856720692683969e7
             + z*(-3.9914042388963811892405597986409e7
             + 1.1047968862555686982334075118326e7*z)
             + y*(-2.8407291429983253509009389557895e7
             + 1.5651289221953889891639939750962e7*y
             + 4.0509219162704185601891608767195e7*z))))
             + y*(1.7078509996483885303449684353047e6
             + z*(-7.3565599754232956297498832536762e6
             + 4.9189609829719121283990891000191e6*z)
             + y*(-1.2290838007719408552143097631142e7
             + (4.5500389092490187187691574175177e7
             - 2.4551041916790415516297944707391e7*z)*z
             + y*(3.2383159804565088178627336575126e7
             + z*(-9.0020487028231523559759130593766e7
             + 2.9461250300148498619557533648869e7*z)
             + y*(-3.4780642715453088648088755002137e7
             + 1.288929700631496814605642097138e7*y
             + 5.339851616901915374794802973857e7*z)))))));
          case ( 144 ):
            return 43.15089802078283515175134667018
             + z*(-517.81077624939402182101616004216
             + (1294.5269406234850545525404001054
             - 863.0179604156567030350269334036*z)*z)
             + y*(-1553.4323287481820654630484801265
             + z*(18123.377168728790763735565601475
             + z*(-44013.915981198491854786373603583
             + 28479.592693716671200155888802319*z))
             + y*(12945.269406234850545525404001054
             + z*(-137219.85570608941578256928241117
             + (299035.72328402504760163683242435
             - 170877.55616230002720093533281391*z)*z)
             + y*(-42287.880060367178448716319736776
             + z*(370234.70501831672560202655443014
             + z*(-626551.03926176676640342955365101
             + 246823.13667887781706801770295343*z))
             + y*(64079.083560862510200350749805217
             + y*(-45567.34830994667392024942208371
             + 12341.156833943890853400885147671*y
             + 148093.88200732669024081062177206*z)
             + z*(-398714.29771203339680218244323246
             + 370234.70501831672560202655443014*z)))))
             + x*(-1726.0359208313134060700538668072
             + z*(20194.620273726366851019630241644
             + z*(-49192.023743692432072996535204005
             + 31931.664535379298012295996535933*z))
             + y*(60583.860821179100553058890724932
             + z*(-688688.33241169404902195149285607
             + (1.6285148913043441986270958233326e6
             - 1.0252653369738001632056119968835e6*z)*z)
             + y*(-491920.23743692432072996535204005
             + z*(5.0771346611253083839550634492133e6
             + z*(-1.0765286038224901713658925967276e7
             + 5.980714465680500952032736648487e6*z))
             + y*(1.5646515622335856026025038302607e6
             + y*(-2.3068470081910503672126269929878e6
             + y*(1.5948571908481335872087297729298e6
             - 419599.33235409228901563009502083*y
             - 5.03519198824910746818756114025e6*z)
             + (1.3955000419921168888076385513136e7
             - 1.2587979970622768670468902850625e7*z)*z)
             + z*(-1.3328449380659402121672955959485e7
             + (2.1929286374161836824120034377785e7
             - 8.391986647081845780312601900417e6*z)*z))))
             + x*(16052.134063731214676451500961307
             + z*(-172430.98849104820926639838129404
             + (381885.44748392809109299941803109
             - 222658.63378723942938303694881813*z)*z)
             + y*(-517292.96547314462779919514388211
             + z*(5.3463962647749932753019918524353e6
             + z*(-1.1355590323149210898534884389724e7
             + 6.322469578005101006434607314115e6*z))
             + y*(3.8188544748392809109299941803109e6
             + z*(-3.5402722772171069271902874862082e7
             + (6.6385930569053560567563376798205e7
             - 3.1954103002350105086574907236201e7*z)*z)
             + y*(-1.0910273055574732039768810492088e7
             + z*(8.2192104514066313083649895083492e7
             + z*(-1.1716504434195038531744132653274e8
             + 3.7763939911868306011406708551874e7*z))
             + y*(1.4225556550511477264477866456758e7
             + y*(-8.5210941339600280230866419296537e6
             + 1.8881969955934153005703354275937e6*y
             + 2.2658363947120983606844025131125e7*z)
             + z*(-7.455957367215024520200811688447e7
             + 5.664590986780245901711006282781e7*z)))))
             + x*(-62482.50033409354529973594997842
             + z*(577359.015518074334330433018447
             + z*(-1.0615120913112577447330831280864e6
             + 485016.09375359906710568513657282*z))
             + x*(129021.18508214067710373652654384
             + z*(-970895.20546761379091440530007904
             + (1.3657259223577767325529301221112e6
             - 425467.85448491875459626827816797*z)*z)
             + x*(-154307.61132231941850266281569256
             + z*(880796.13040021923111754848823171
             + z*(-836264.40364277134524094109846808
             + 132041.74794359547556435912081075*z))
             + x*(107877.24505195708787937836667545
             + x*(-41079.654915785259064467282030011
             + 6602.087397179773778217956040537*x
             + 237675.14629847185601584641745935*y
             + 79225.04876615728533861547248645*z)
             + z*(-413730.81022326582343499191187368
             + 198062.62191539321334653868121612*z)
             + y*(-1.241192430669797470304975735621e6
             + 1.9806262191539321334653868121612e6*y
             + 2.7728767068155049868515415370257e6*z))
             + y*(2.6423883912006576933526454646951e6
             + z*(-1.1707701650998798833373175378553e7
             + 6.734129145123369253782315161348e6*z)
             + y*(-8.3626440364277134524094109846808e6
             + 6.470045649236178302653596919727e6*y
             + 2.0994637923031680614733100208909e7*z)))
             + y*(-2.9126856164028413727432159002371e6
             + z*(1.9120162913008874255741021709557e7
             + z*(-2.1698860578730856484409682186567e7
             + 4.3573776821386506936238509867547e6*z))
             + y*(1.3657259223577767325529301221112e7
             + z*(-6.7649388863102081980806656228708e7
             + 4.5752465662455832283050435360925e7*z)
             + y*(-2.0847924869761018975217145630231e7
             + 9.804099784811964060653664720198e6*y
             + 5.664590986780245901711006282781e7*z))))
             + y*(1.732077046554223002991299055341e6
             + z*(-1.486116927835760842626316379321e7
             + (2.4735820781433552422389941965214e7
             - 9.683061515863668208053002192788e6*z)*z)
             + y*(-1.0615120913112577447330831280864e7
             + z*(7.7117558906822251669803936715078e7
             + z*(-1.0167214591656851618455652302428e8
             + 2.6144266092831904161743105920528e7*z))
             + y*(2.3765788593926354288178571692068e7
             + y*(-2.1786888410693253468119254933774e7
             + 6.971804291421841109798161578808e6*y
             + 6.100328754994110971073391381457e7*z)
             + z*(-1.2587979970622768670468902850625e8
             + 9.58623090070503152597247217086e7*z)))))));
          case ( 145 ):
            return 48.928519290900271428377303663089
             + z*(-978.57038581800542856754607326177
             + z*(4403.566736181024428553957329678
             + z*(-6849.9927007260379999728225128324
             + 3424.9963503630189999864112564162*z)))
             + y*(-1369.9985401452075999945645025665
             + z*(26421.400417086146571323743978068
             + z*(-114492.73514070663514240289057163
             + (171249.81751815094999932056282081
             - 82199.91240871245599967387015399*z)*z))
             + y*(8807.133472362048857107914659356
             + z*(-149721.26903015483057083454920905
             + z*(559252.9754949901024263525808691
             + z*(-698699.25547405587599722789630891
             + 267149.71532831548199894007800046*z)))
             + y*(-22507.118873814124857053559685021
             + y*(27644.613399358653357033176569645
             + y*(-16439.982481742491199934774030798
             + 3816.4245046902211714134296857209*y
             + 76328.49009380442342826859371442*z)
             + z*(-252471.15954104540057042688690154
             + 343478.20542211990542720867171488*z))
             + z*(300421.10844612766657023664449136
             + z*(-792642.01251258439713971231934204
             + 534299.4306566309639978801560009*z)))))
             + x*(-1957.1407716360108571350921465235
             + z*(38164.245046902211714134296857209
             + z*(-167335.53597487892828505037852776
             + (253449.7299268634059989944329748
             - 123299.86861306868399951080523098*z)*z))
             + y*(53429.943065663096399788015600093
             + z*(-1.0040132158492735697103022711666e6
             + z*(4.2362312002061455002689069511502e6
             + z*(-6.1649934306534341999755402615492e6
             + 2.8769969343049359599885854553896e6*z)))
             + y*(-334671.07194975785657010075705553
             + y*(832763.39833112261971098170834577
             + z*(-1.0815159904060595996528519201689e7
             + (2.7742470437940453899889931176971e7
             - 1.8166180642325452775927925304032e7*z)*z)
             + y*(-995206.08237691152085319435650722
             + y*(575399.38686098719199771709107792
             - 129758.43315946751982805660931451*y
             - 2.5951686631893503965611321862902e6*z)
             + (8.8364905839365890199649410415538e6
             - 1.1678258984352076784525094838306e7*z)*z))
             + z*(5.5396869541157287311208783207349e6
             + z*(-2.0133107117819643687348692911288e7
             + (2.4454473941591955659902976370812e7
             - 9.083090321162726387963962652016e6*z)*z))))
             + x*(18201.409176214900971356356962669
             + z*(-325863.93847739580771299284239617
             + z*(1.299052187173402206423417412255e6
             + z*(-1.7672981167873178039929882083108e6
             + 760349.1897805902179969832989244*z)))
             + y*(-456209.51386835413079818997935464
             + z*(7.79431312304041323854050447353e6
             + z*(-2.953912566630231186673994576748e7
             + (3.801745948902951089984916494622e7
             - 1.5371383620429229271939013718796e7*z)*z))
             + y*(2.59810437434680441284683482451e6
             + z*(-3.8628087409779946287275313695935e7
             + z*(1.2415416055988780273865027295294e8
             + z*(-1.3065676077364844881148161660977e8
             + 4.0873906445232268745837831934071e7*z)))
             + y*(-5.8068366694440442131198183987354e6
             + y*(6.1371041746576210452613651984612e6
             + y*(-3.0742767240858458543878027437592e6
             + 583912.9492176038392262547419153*y
             + 1.1678258984352076784525094838306e7*z)
             + z*(-4.7212106834175489906669827850588e7
             + 5.255216542958434553036292677238e7*z))
             + z*(6.6693486075040341978592535077083e7
             + z*(-1.4822405633985328226512620371696e8
             + 8.174781289046453749167566386814e7*z)))))
             + x*(-70848.495933223593028290335704152
             + z*(1.0911059801870760528528138716869e6
             + z*(-3.6109247236684400314142450103359e6
             + (3.8496958978080333559847262522118e6
             - 1.1644987591234264599953798271815e6*z)*z))
             + x*(146296.27267979181157084813795264
             + z*(-1.8348194734087601785641488873658e6
             + z*(4.6457629066709807721244249828103e6
             + z*(-3.3770464014579367339866014988264e6
             + 524024.4416055419069979209222317*z)))
             + x*(-174968.38498425937062787723789921
             + z*(1.6645482262764272339933958706183e6
             + z*(-2.844704111572941780845856434972e6
             + 1.0480488832110838139958418444634e6*z))
             + x*(122321.29822725067857094325915772
             + x*(-46579.95036493705839981519308726
             + 7486.063451507741528541727460453*x
             + 209609.77664221676279916836889267*y
             + 149721.26903015483057083454920905*z)
             + z*(-781877.73826858633742546931253616
             + 673745.7106356967375687554714407*z)
             + y*(-1.0946288335760208723956570375506e6
             + 1.3474914212713934751375109428815e6*y
             + 4.0424742638141804254125328286444e6*z))
             + y*(2.3303675167869981275907542188656e6
             + z*(-1.7068224669437650685075138609832e7
             + 1.7517388476528115176787642257459e7*z)
             + y*(-5.689408223145883561691712869944e6
             + 3.4435891876935611031291946318082e6*y
             + 2.2907354161613689077337686028985e7*z)))
             + y*(-2.5687472627722642499898084423122e6
             + z*(2.7874577440025884632746549896862e7
             + z*(-5.6444918424368371125204625051812e7
             + 2.6201222080277095349896046111584e7*z))
             + y*(9.2915258133419615442488499656205e6
             + y*(-1.1096009604790363554527404924715e7
             + 4.2296258501018739636260760151557e6*y
             + 4.5964429592257532985246206607179e7*z)
             + z*(-7.3812585631866331471421432760062e7
             + 8.556570525073348567123194487297e7*z))))
             + y*(1.5275483722619064739939394203616e6
             + z*(-2.1665548342010640188485470062016e7
             + z*(6.4344917149077128950030424501255e7
             + z*(-5.8224937956171322999768991359076e7
             + 1.257658659853300576795010213356e7*z)))
             + y*(-7.2218494473368800628284900206719e6
             + z*(8.4143353194947014780809016655487e7
             + z*(-1.901460116682966348249598774955e8
             + 1.0690098608753054902757586813526e8*z))
             + y*(1.2649000807083538169664100542982e7
             + y*(-9.3991685557819421413912800336793e6
             + 2.5153173197066011535900204267121e6*y
             + 3.8628087409779946287275313695935e7*z)
             + z*(-1.0214317687168340663388045912706e8
             + 1.2127422791442541276237598485933e8*z)))))));
          case ( 146 ):
            return 54.092513345194083336829302321803
             + z*(-1622.7754003558225001048790696541
             + z*(11359.427802490757500734153487579
             + z*(-30291.80747330868666862440930021
             + (34078.283407472272502202460462736
             - 13631.313362988909000880984185094*z)*z)))
             + y*(-973.66524021349350006292744179246
             + z*(27587.18180604898250178294418412
             + z*(-181750.84483985212001174645580126
             + z*(454377.11209963030002936613950315
             + z*(-477095.9677046118150308344464783
             + 177207.07371885581701145279440623*z))))
             + y*(4056.9385008895562502621976741352
             + y*(-7572.9518683271716671561023250525
             + y*(7302.4893016012012504719558134434
             + y*(-3570.105880782809500230733953239
             + 703.2026734875230833787809301834*y
             + 21096.080204625692501363427905503*z)
             + z*(-86007.096218858592505558590691667
             + 147672.56143237984750954399533852*z))
             + z*(133067.58282917744500860008371164
             + z*(-454377.11209963030002936613950315
             + 393793.49715301292669211732090273*z)))
             + z*(-94120.973220637705006082986039938
             + z*(477095.9677046118150308344464783
             + z*(-817878.80177933454005285905110567
             + 443017.68429713954252863198601557*z)))))
             + x*(-2163.7005338077633334731720928721
             + z*(63288.24061387707750409028371651
             + z*(-431658.25649464878502789783252799
             + z*(1.1207968765124214067391031441078e6
             + z*(-1.2268182026690018100792885766585e6
             + 477095.9677046118150308344464783*z))))
             + y*(37972.944368326246502454170229906
             + z*(-1.0483129086298613350677518789965e6
             + z*(6.7247812590745284404346188646466e6
             + z*(-1.6357576035586690801057181022113e7
             + (1.6698358869661413526079205626741e7
             - 6.025040506441097778389395009812e6*z)*z)))
             + y*(-154163.66303380313750996351161714
             + z*(3.4824760091635950852250704834777e6
             + z*(-1.7175454837366025341110040073219e7
             + (2.8625758062276708901850066788698e7
             - 1.5062601266102744445973487524529e7*z)*z))
             + y*(280199.21912810535168477578602694
             + z*(-4.7904329818503880203096030136189e6
             + (1.590319892348706050102781488261e7
             - 1.3388978903202439507531988910693e7*z)*z)
             + y*(-262889.61485764324501699040928396
             + y*(124953.70582739833250807568836337
             - 23908.890898575784834878551626237*y
             - 717266.7269572735450463565487871*z)
             + (3.0102483676600507376945506742084e6
             - 5.02086708870091481532449584151e6*z)*z))))
             + x*(20122.414964412199001300500463711
             + z*(-540384.20831848889253492473019481
             + z*(3.3510312017347734627165752788357e6
             + z*(-7.8152863281136411605050975994541e6
             + (7.5653789164588444954889462227274e6
             - 2.5490555988789259831647440426127e6*z)*z)))
             + y*(-324230.52499109333552095483811689
             + z*(8.1382186327844498380259685343153e6
             + z*(-4.6891717968681846963030585596725e7
             + z*(1.008717188861179266065192829697e8
             + z*(-8.9216945960762409410766041491443e7
             + 2.7112682278984940002752277544153e7*z))))
             + y*(1.1967968577624190938273483138699e6
             + y*(-1.9538215820284102901262743998635e6
             + y*(1.6211526249554666776047741905844e6
             + y*(-667609.7997063853765431472492557
             + 107590.00904359103175695348231807*y
             + 3.227700271307730952708604469542e6*z)
             + z*(-1.6083326992926556798539456459342e7
             + 2.2593901899154116668960231286794e7*z))
             + z*(2.9541003388077392791909218583983e7
             + z*(-8.4968519962630866105491468087089e7
             + 6.025040506441097778389395009812e7*z)))
             + z*(-2.4283211090924527891569410398304e7
             + z*(1.0591530483042382293684524711818e8
             + z*(-1.5294333593273555898988464255676e8
             + 6.778170569746235000688069386038e7*z)))))
             + x*(-78325.959323841032671728829761971
             + z*(1.8093945713967420876169401626643e6
             + z*(-9.3147307980424211506020058598145e6
             + z*(1.7023995799999481907766918026718e7
             + z*(-1.158661635854057265074883655733e7
             + 2.0855909445373030771347905803194e6*z))))
             + x*(161736.61490213030917711961394219
             + z*(-3.0427038756671671876966482556014e6
             + z*(1.1984196331627749163274531929396e7
             + z*(-1.4933861084341182527631833785003e7
             + 5.213977361343257692836976450799e6*z)))
             + x*(-193434.82772241404201250158510277
             + x*(135231.28336298520834207325580451
             + x*(-51496.072704624767336661495810357
             + 8276.154541814694750534883255236*x
             + 148970.78175266450550962789859425*y
             + 248284.63625444084251604649765708*z)
             + z*(-1.2965975448843021775837983766536e6
             + 1.7379924537810858976123254835995e6*z)
             + y*(-777958.52693058130655027902599217
             + 620711.5906361021062901162441427*y
             + 4.2208388163254943227727904601703e6*z))
             + z*(2.7603409560052540726783992974816e6
             + z*(-7.3381903604090293454742631529758e6
             + 4.6346465434162290602995346229321e6*z))
             + y*(1.656204573603152443607039578489e6
             + y*(-2.6207822715746533376693796974914e6
             + 1.158661635854057265074883655733e6*y
             + 1.440050890275756886593069686411e7*z)
             + z*(-1.7821319446707642696151781942941e7
             + 2.7807879260497374361797207737593e7*z)))
             + y*(-1.8256223254003003126179889533609e6
             + z*(2.9104476805381676539381006114246e7
             + z*(-8.9603166506047095165791002710021e7
             + 6.951969815124343590449301934398e7*z))
             + y*(4.2800701184384818440266185462127e6
             + y*(-3.7334652710852956319079584462509e6
             + 1.1172808631449837913222092394568e6*y
             + 2.035934017286414908631581280788e7*z)
             + z*(-4.6401639797774388567998912117689e7
             + 7.299568305880560769971767031118e7*z))))
             + y*(1.0856367428380452525701640975986e6
             + z*(-2.2621489080960165651462014230978e7
             + z*(1.0214397479999689144660150816031e8
             + z*(-1.5448821811387430200998448743107e8
             + 7.299568305880560769971767031118e7*z)))
             + y*(-3.3266895707294361252150020927909e6
             + y*(4.2559989499998704769417295066795e6
             + y*(-2.4828463625444084251604649765708e6
             + 546226.1997597698535353022948456*y
             + 1.3159085721485364653350464375825e7*z)
             + z*(-4.5242978161920331302924028461956e7
             + 6.951969815124343590449301934398e7*z))
             + z*(5.2895986949998390213418638154445e7
             + z*(-1.6221262901956801711048371180262e8
             + 1.2513545667223818462808743481917e8*z)))))));
          case ( 147 ):
            return 58.804761711956626208528952254129
             + z*(-2469.7999919021783007582159946734
             + z*(24697.999919021783007582159946734
             + z*(-98791.999676087132030328639786937
             + z*(185234.99939266337255686619960051
             + z*(-163006.79946554376785004225564845
             + 54335.59982184792261668075188282*z)))))
             + y*(-352.82857027173975725117371352478
             + z*(12348.999959510891503791079973367
             + z*(-98791.999676087132030328639786937
             + z*(296375.99902826139609098591936081
             + z*(-370469.99878532674511373239920102
             + 163006.79946554376785004225564845*z))))
             + y*(882.07142567934939312793428381194
             + y*(-1176.0952342391325241705790450826
             + y*(882.07142567934939312793428381194
             + y*(-352.82857027173975725117371352478
             + 58.804761711956626208528952254129*y
             + 2469.7999919021783007582159946734*z)
             + z*(-12348.999959510891503791079973367
             + 24697.999919021783007582159946734*z))
             + z*(24697.999919021783007582159946734
             + z*(-98791.999676087132030328639786937
             + 98791.99967608713203032863978694*z)))
             + z*(-24697.999919021783007582159946734
             + z*(148187.99951413069804549295968041
             + z*(-296375.99902826139609098591936081
             + 185234.99939266337255686619960051*z)))))
             + x*(-2352.1904684782650483411580901652
             + z*(96322.199684184953729570423792264
             + z*(-938523.99692282775428812207797591
             + z*(3.6553039880152238851221596721167e6
             + z*(-6.6684599781358814120471831856183e6
             + (5.7052379812940318747514789476956e6
             - 1.8474103939428293689671455640157e6*z)*z))))
             + y*(13760.314240597850532795774827466
             + z*(-469261.99846141387714406103898795
             + z*(3.6553039880152238851221596721167e6
             + z*(-1.0669535965017410259275493096989e7
             + (1.2966449957486436078980633972036e7
             - 5.542231181828488106901436692047e6*z)*z)))
             + y*(-33518.714175815276938861502784854
             + z*(913825.99700380597128053991802917
             + z*(-5.3347679825087051296377465484946e6
             + (1.0373159965989148863184507177628e7
             - 6.297989979350554666933450786417e6*z)*z))
             + y*(43515.523666847903394311424668056
             + z*(-889127.99708478418827295775808244
             + (3.4577199886630496210615023925428e6
             - 3.3589279889869624890311737527559e6*z)*z)
             + y*(-31754.57132445657815260563421723
             + y*(12348.999959510891503791079973367
             - 1999.3618982065252910899843766404*y
             - 83973.1997246740622257793438189*z)
             + (432214.99858288120263268779906785
             - 839731.997246740622257793438189*z)*z))))
             + x*(21875.371356847864949572770238536
             + z*(-822443.39730342537415248592622625
             + z*(7.2859099761114259872367371842866e6
             + z*(-2.548833591643048006382478906503e7
             + z*(4.1122169865171268707624296311313e7
             + z*(-3.048227150005668458795790180626e7
             + 8.313346772742732160352155038071e6*z)))))
             + y*(-117491.91390048933916464084660375
             + z*(3.6429549880557129936183685921433e6
             + z*(-2.548833591643048006382478906503e7
             + z*(6.57954717842740299321988740981e7
             + z*(-6.927788977285610133626795865059e7
             + 2.4940040318228196481056465114212e7*z))))
             + y*(260211.07057540807097274061372452
             + y*(-303432.57043369619123600939363131
             + y*(195819.85650081556527440141100625
             + y*(-65978.942640815334605969484429133
             + 8997.128541929363809904929694882*y
             + 377879.39876103328001600704718504*z)
             + z*(-2.3092629924285367112089319550197e6
             + 3.7787939876103328001600704718504e6*z))
             + z*(5.482955982022835827683239508175e6
             + z*(-1.8474103939428293689671455640157e7
             + 1.5115175950441331200640281887401e7*z)))
             + z*(-6.3720839791076200159561972662575e6
             + z*(3.289773589213701496609943704905e7
             + z*(-5.5422311818284881069014366920472e7
             + 2.8340954907077496001200528538878e7*z)))))
             + x*(-85149.294958913194749949922863979
             + z*(2.7538269909709288053454108340609e6
             + z*(-2.0252359933597862066217371156322e7
             + z*(5.5521103817960968201044695560259e7
             + z*(-6.2979899793505546669334507864173e7
             + 2.4940040318228196481056465114212e7*z))))
             + x*(175826.23751875031236350156723985
             + x*(-210285.82788195689532169953326077
             + x*(147011.90427989156552132238063532
             + x*(-55982.133149782708150519562545931
             + 8997.128541929363809904929694882*x
             + 53982.77125157618285942957816929*y
             + 377879.39876103328001600704718504*z)
             + y*(-281910.0276471200660436877971063
             + 134956.92812894045714857394542323*y
             + 1.8893969938051664000800352359252e6*z)
             + z*(-1.9733701935298404623058145797441e6
             + 3.7787939876103328001600704718504e6*z))
             + z*(4.2011297862256052895897254069395e6
             + z*(-1.595490794768807182289807532559e7
             + 1.5115175950441331200640281887401e7*z))
             + y*(600161.39803222932708424648670565
             + y*(-569818.14098885970796064554734251
             + 179942.57083858727619809859389764*y
             + 3.7787939876103328001600704718504e6*z)
             + z*(-7.9774539738440359114490376627952e6
             + 1.5115175950441331200640281887401e7*z)))
             + z*(-4.6308749848165843139216549900127e6
             + z*(2.6056389914567981072999178743805e7
             + z*(-4.870445584031095609095201941496e7
             + 2.8340954907077496001200528538878e7*z)))
             + y*(-661553.56925951204484595071285896
             + y*(930585.3540917136097499706694216
             + y*(-579814.95047989233441609546922572
             + 134956.92812894045714857394542323*y
             + 3.7787939876103328001600704718504e6*z)
             + z*(-1.217611396007773902273800485374e7
             + 2.2672763925661996800960422831102e7*z))
             + z*(1.3028194957283990536499589371902e7
             + z*(-4.870445584031095609095201941496e7
             + 4.5345527851323993601920845662204e7*z))))
             + y*(393403.85585298982933505869058013
             + y*(-723298.56905706650236490611272579
             + y*(660965.52164239247858386542333641
             + y*(-299904.28473097879366349765649606
             + 53982.77125157618285942957816929*y
             + 1.8893969938051664000800352359252e6*z)
             + z*(-8.3973199724674062225779343818897e6
             + 1.5115175950441331200640281887401e7*z))
             + z*(1.3880275954490242050261173890065e7
             + z*(-5.0383919834804437335467606291338e7
             + 4.5345527851323993601920845662204e7*z)))
             + z*(-1.0126179966798931033108685578161e7
             + z*(5.5521103817960968201044695560259e7
             + z*(-1.0076783966960887467093521258268e8
             + 5.668190981415499200240105707776e7*z)))))));
          case ( 148 ):
            return 17.435595774162694208947927935438
             + y*(-1098.4425337722497351637194599326
             + y*(16476.638006583746027455791898989
             + y*(-100690.56559578955905667428382716
             + y*(302071.69678736867717002285148147
             + y*(-471231.8469882951363852356483111
             + (366513.65876867399496629439313085
             - 112198.05880673693723457991626455*y)*y)))))
             + x*(-435.88989435406735522369819838596
             + y*(26362.620810533993643929267038383
             + y*(-378962.67415142615863148321367675
             + y*(2.2151924431073702992468342441975e6
             + y*(-6.3435056325347422205704798811109e6
             + y*(9.4246369397659027277047129662219e6
             + y*(-6.9637595166048059043595934694862e6
             + 2.0195650585212648702224384927618e6*y))))))
             + x*(2563.0325788019160487153454065095
             + y*(-135108.43165398671742513749357171
             + y*(1.6476638006583746027455791898989e6
             + y*(-7.8538641164715856064205941385183e6
             + y*(1.7218086716880014598691302534444e7
             + y*(-1.7435578338566920046253718987511e7
             + 6.597245857836131909393299076355e6*y)))))
             + x*(-7200.9010547291927082954942373361
             + x*(11594.671189818191648950372077067
             + x*(-11350.57284897991393002510108597
             + x*(6712.7043730526372704449522551438
             + x*(-2214.3206633186621645363868478007
             + 313.84072393492849576106270283789*x
             + 19771.965607900495232946950278787*y)
             + y*(-119730.23618117522113284542113266
             + 296579.48411850742849420425418181*y))
             + y*(303170.1393211409269051865709414
             + y*(-1.499374058599120888498477062808e6
             + 1.8124301807242120630201371088888e6*y)))
             + y*(-411915.95016459365068639479747473
             + y*(3.048178031217993015079321501313e6
             + y*(-7.3504112884926378111372227193825e6
             + 5.437290542172636189060411326666e6*y))))
             + y*(318548.33479395242319747864338046
             + y*(-3.130561221250911745216600460808e6
             + y*(1.1277343346728430614347519788642e7
             + y*(-1.6613943323305277244351256831481e7
             + 8.4821732457893124549342416696e6*y)))))));
          case ( 149 ):
            return 30.199337741082998788946739227784
             - 60.39867548216599757789347845557*z
             + y*(-1842.1596022060629261257510928949
             + 3623.9205289299598546736087073341*z
             + y*(26726.413900858453928217864216589
             - 49828.907272786948001762119725844*z
             + y*(-157791.53969715866867224671246517
             + 265754.1721215303893427313052045*z
             + y*(456764.98333388035668281943082024
             - 647775.794546230324022907556436*z
             + y*(-686642.34221900414346428200982214
             + y*(513902.13034000939039150666143921
             - 151147.68539412040893867842983506*y
             - 302295.37078824081787735685967012*z)
             + 725508.8898917779629056564632083*z)))))
             + x*(-754.98344352707496972366848069461
             + 1449.5682115719839418694434829337*z
             + y*(44211.830452945510227018026229476
             - 83350.17216538907665749300026869*z
             + y*(-614707.51971974444034901087698155
             + 1.0962359600013128560387666339686e6*z
             + y*(3.4714138733374907107894276742338e6
             - 5.580837614552138176197357409295e6*z
             + y*(-9.592064650011487490339208047225e6
             + 1.295551589092460648045815112872e7*z
             + y*(1.3732846844380082869285640196443e7
             - 1.3784668907943781295207472800958e7*z
             + y*(-9.764140476460178417438626567345e6
             + 2.7206583370941673608962117370311e6*y
             + 5.441316674188334721792423474062e6*z))))))
             + x*(4439.3026479392008219751706664843
             - 7429.037084306417702080897850035*z
             + x*(-12472.326487067278499835003301075
             + 17515.615889828139297589108752115*z
             + x*(20082.559597820194194649581586477
             - 22649.503305812249091710054420838*z
             + x*(-19659.768869445032211604327237288
             + 16670.034433077815331498600053737*z
             + x*(11626.745030316954533744494602697
             - 6583.455627556093735990389151657*z
             + x*(-3835.3158931175408461962358819286
             + 543.5880793394939782010413061001*x
             + 33158.872839709132670263519672107*y
             + 1087.1761586789879564020826122002*z)
             + y*(-200795.39664046085894770686912554
             + 481075.45021545217070792155589861*y
             + 65230.56952073927738412495673201*z))
             + y*(508436.05020887336761070730163898
             - 329776.76813262634677529839236741*z
             + y*(-2.4321036649781193074678256437096e6
             + 2.8402477145488560361004408243731e6*y
             + 896920.3309101650640317181550652*z)))
             + y*(-690809.85082727359729715665983557
             + 670425.2978520425731146176108568*z
             + y*(4.944386571658813976720304880069e6
             - 3.6375102309134472041286347399866e6*z
             + y*(-1.1518782397892582813074010009958e7
             + 8.221769700009846420290749754764e6*y
             + 4.7835750981875470081691634936811e6*z))))
             + y*(534226.28463975824857646781693951
             - 688544.9004966923723879856543935*z
             + y*(-5.078018641163106246361394201152e6
             + 5.580837614552138176197357409295e6*z
             + y*(1.7672652446081770891291631796099e7
             - 1.4616479466684171413850221786248e7*z
             + y*(-2.5122074083363419617555068695113e7
             + 1.2359562159942074582357076176798e7*y
             + 1.1659964301832145832412336015848e7*z)))))
             + y*(-226585.63107134573991346738442607
             + 362392.05289299598546736087073341*z
             + y*(2.6726413900858453928217864216589e6
             - 3.8866547672773819441374453386159e6*z
             + y*(-1.2307740096378376156435243572284e7
             + 1.5147987810927232192535684396657e7*z
             + y*(2.6035604050031180330920707556754e7
             - 2.3967704398210521988847579588131e7*z
             + y*(-2.5405766662103153308178434363419e7
             + 9.250238346120169027047119905906e6*y
             + 1.3059160018052003332301816337749e7*z)))))));
          case ( 150 ):
            return 38.987177379235855627353652799598
             + z*(-233.92306427541513376412191679759
             + 233.92306427541513376412191679759*z)
             + y*(-2222.2691106164437707591582095771
             + (13099.691599423247490790827340665
             - 12865.768535147832357026705423867*z)*z
             + y*(30059.11375939084468868966630849
             + z*(-167254.99095692182064134717051028
             + 154389.22242177398828432046508641*z)
             + y*(-165110.6962010638485818427196063
             + (823409.18624946127084970914712752
             - 669019.9638276872825653886820411*z)*z
             + y*(443869.01446260021631742133712343
             + z*(-1.839804900526140027054818875613e6
             + 1.1707849366984527444894301935719e6*z)
             + y*(-618843.46654061073637298453088803
             + y*(429287.81012276600631279107097638
             - 117078.49366984527444894301935719*y
             - 702470.9620190716466936581161432*z)
             + (1.8732558987175243911830883097151e6
             - 702470.9620190716466936581161432*z)*z)))))
             + x*(-974.67943448089639068384131998996
             + (5614.1535426099632103389260031422
             - 5380.230478334548076574804086345*z)*z
             + y*(53334.458654794650498219797029851
             + z*(-301292.9067867346922881890288353
             + 283046.90777325231185458751932508*z)
             + y*(-691359.61646598942783986232509528
             + (3.6796098010522800541096377512261e6
             - 3.2421736708572537539707297668146e6*z)*z
             + y*(3.6324353164234046688005398313386e6
             + z*(-1.7291592911238686687843892089678e7
             + 1.3380399276553745651307773640822e7*z)
             + y*(-9.321249303714604542665848079592e6
             + (3.6796098010522800541096377512261e7
             - 2.2244913797270602145299173677867e7*z)*z
             + y*(1.2376869330812214727459690617761e7
             + z*(-3.5591862075632963432478677884587e7
             + 1.2644477316343289640485846090577e7*z)
             + y*(-8.1564683923325541199430303485512e6
             + 2.1074128860572149400809743484295e6*y
             + 1.2644477316343289640485846090577e7*z))))))
             + x*(5731.115074747670777220986961541
             + z*(-28772.536905876061452986995766104
             + 23392.306427541513376412191679759*z)
             + x*(-16101.704257624408374097058606234
             + (67837.688639870388791595355871301
             - 44445.382212328875415183164191542*z)*z
             + x*(25926.472957191843992190179111733
             + z*(-87721.149103280675161545718799096
             + 43275.766890951799746362554607554*z)
             + x*(-25380.652473882542013407227972539
             + (64562.765740014576918897649036135
             - 21286.998849062777172535094428581*z)*z
             + x*(15010.063291005804416531156327845
             + z*(-25497.614006020249580289288930937
             + 4210.6151569574724077541945023566*z)
             + x*(-4951.371527162953664673913905549
             + 701.7691928262454012923657503928*x
             + 40000.843991095987873664847772388*y
             + 4210.6151569574724077541945023566*z)
             + y*(-242227.3330571923710127482448439
             + 541064.0476690352043964139935528*y
             + 235794.44878961845483423489213197*z))
             + y*(613346.27453013848072952766584328
             + z*(-1.1920719355475155216619652880005e6
             + 231583.83363266098242648069762961*z)
             + y*(-2.7353793521045668666707596340726e6
             + 2.9719925316191492744731689529134e6*y
             + 3.010589837224592771544249069185e6*z)))
             + y*(-833350.91648116641403468432859142
             + (2.423442945893300785796303058023e6
             - 939201.1030657917620629494959423*z)*z
             + y*(5.5609360454873062674075882670707e6
             + z*(-1.220961433985529290681834344725e7
             + 2.7790060035919317891177683715554e6*z)
             + y*(-1.205308082267766094647451853126e7
             + 7.989642260326803893713584068222e6*y
             + 1.4821365352490302875294764648295e7*z))))
             + y*(644458.04207876869352015588077736
             + z*(-2.4889414038904170232502571947264e6
             + 1.4409660759365572239869910074732e6*z)
             + y*(-5.7112316142842604908510365986132e6
             + (1.8732558987175243911830883097151e7
             - 8.491407233197569355637625579753e6*z)*z
             + y*(1.8492397974519151041166384595906e7
             + z*(-4.5287505243720369896734003092014e7
             + 1.204235934889837108617699627674e7*z)
             + y*(-2.4412795795443011897458173541789e7
             + 1.1139182397730993254713721555984e7*y
             + 3.3116488209470520486986739761035e7*z)))))
             + y*(-273339.10060582258380337645977798
             + (1.3099691599423247490790827340665e6
             - 1.0035299457415309238480830230617e6*z)*z
             + y*(3.005911375939084468868966630849e6
             + z*(-1.3045889294639902010025079299802e7
             + 8.800185678041117332206266509925e6*z)
             + y*(-1.2878634303682980189383732129291e7
             + (4.6934323616219292438433421386269e7
             - 2.4753738661624429454919381235521e7*z)*z
             + y*(2.5300533824368212330093016216035e7
             + z*(-6.8072781319467181001028298397683e7
             + 2.1074128860572149400809743484295e7*z)
             + y*(-2.2897208262002597245800427642857e7
             + 7.727180582209788113630239277575e6*y
             + 3.3718606176915439041295589574872e7*z)))))));
          case ( 151 ):
            return 46.130250378683183557416732955271
             + z*(-553.56300454419820268900079546326
             + (1383.9075113604955067225019886581
             - 922.6050075736636711483346591054*z)*z)
             + y*(-2352.6427693128423614282533807188
             + z*(27678.150227209910134450039773163
             + z*(-67811.468056664279829402597444249
             + 44285.040363535856215120063637061*z))
             + y*(28370.103982890157887811290767492
             + z*(-312763.09756747198451928544943674
             + (714096.2758620156814688110261476
             - 431779.14354447459809742062046134*z)*z)
             + y*(-138621.40238794296659003728253059
             + z*(1.3506937310878436145611619409303e6
             + z*(-2.6626380518575933549340938261783e6
             + 1.3433128910272543051919752636575e6*z))
             + y*(331445.84897083867386003922628363
             + y*(-411989.26613201951235128884202353
             + y*(256069.01985207035192722028463471
             - 62967.79176690254555587384048395*y
             - 755613.5012028305466704860858073*z)
             + (2.3172147370220136764561573298092e6
             - 1.8890337530070763666762152145184e6*z)*z)
             + z*(-2.6266564565622204717593087744732e6
             + (3.9040030895479578244641781100046e6
             - 1.2593558353380509111174768096789e6*z)*z)))))
             + x*(-1153.2562594670795889354183238818
             + z*(13285.512109060756864536019091118
             + z*(-31829.872761291396654617545739137
             + 20297.310166620600765263362500319*z))
             + y*(56463.426463508216674278081137252
             + z*(-636597.45522582793309235091478275
             + (1.4918522972466141562468571437735e6
             - 929985.8476342529805175213363783*z)*z)
             + y*(-652512.39160647363141965968765232
             + z*(6.8807881464843836594242798876083e6
             + z*(-1.49960217931023293108450315491e7
             + 8.635582870889491961948412409227e6*z))
             + y*(3.049670852534745264980820215673e6
             + z*(-2.8364568352844715905784400759537e7
             + (5.3252761037151867098681876523565e7
             - 2.5522944929517831798647530009493e7*z)*z)
             + y*(-6.9603628283876121510608237519561e6
             + z*(5.2533129131244409435186175489463e7
             + z*(-7.4176058701411198664819384090088e7
             + 2.266840503608491640011458257422e7*z))
             + y*(8.2397853226403902470257768404706e6
             + y*(-4.8653113771893366866171854080595e6
             + 1.133420251804245820005729128711e6*y
             + 1.3601043021650949840068749544532e7*z)
             + z*(-4.4027080003418259852666989266375e7
             + 3.4002607554127374600171873861331e7*z))))))
             + x*(6781.1468056664279829402597444249
             + z*(-68088.249558936378930747097841981
             + (138390.75113604955067225019886581
             - 71963.19059074576634957010341022*z)*z)
             + x*(-19051.793406396154809213110710527
             + z*(160533.27131781747877981023068434
             + z*(-262942.42715849414627727537784505
             + 103331.76084825033116861348181981*z))
             + x*(30676.616501824317065682127415256
             + z*(-207586.12670407432600837529829872
             + (256022.88960169166874366286790176
             - 67350.1655528774479938284301147*z)*z)
             + x*(-30030.792996522752495878293153882
             + z*(152783.38925419870394216421954786
             + z*(-125935.58353380509111174768096789
             + 16606.890136325946080670023863898*z))
             + x*(17760.14639579302566960544218778
             + x*(-5858.5417980927643117919250853195
             + 830.3445068162973040335011931949*x
             + 42347.569847631162505708560852939*y
             + 9964.134081795567648402014318339*z)
             + z*(-60338.367495317604093101086705495
             + 24910.335204488919121005035795847*z)
             + y*(-256438.06185509981739567961849835
             + 510661.8716920228419806032338149*y
             + 498206.70408977838242010071591693*z))
             + y*(649329.4043303444917541979330784
             + z*(-2.5187116706761018222349536193578e6
             + 1.2206064250199570369292467539965e6*z)
             + y*(-2.5816794624430043677908274598418e6
             + 2.4951852429829733986206710855506e6*y
             + 5.629735756214495721347138089861e6*z)))
             + y*(-882241.03849231588553559501776957
             + z*(5.1204577920338333748732573580351e6
             + z*(-4.9502371681364924275463896134302e6
             + 797130.7265436454118721611454671*z))
             + y*(5.248469236834679209245088791986e6
             + z*(-2.2831706122425454869907837808882e7
             + 1.2853732965516282266438598470657e7*z)
             + y*(-1.0119362374319836561072721624733e7
             + 5.966025281475096129480706073105e6*y
             + 2.4312487159581185062100914936746e7*z))))
             + y*(682266.40310072428481419348040847
             + z*(-5.2588485431698829255455075569009e6
             + (7.5948844223463993408930909137559e6
             - 2.4356772199944720918316035000383e6*z)*z)
             + y*(-5.3903197567491299986841452458235e6
             + z*(3.5029466927556862266159970336915e7
             + z*(-3.9275295172410862480784606438118e7
             + 7.772024583800542765753571168304e6*z))
             + y*(1.5525597067449612258084175643426e7
             + y*(-1.8229521693396127062302157445599e7
             + 7.415806790376351222323199156424e6*y
             + 4.7279816218119968491667557940517e7*z)
             + z*(-7.4288155209831398800863906751169e7
             + 4.7927484933436680388813688871209e7*z)))))
             + y*(-289375.06062547961045567516582842
             + z*(2.7678150227209910134450039773163e6
             + z*(-5.2892945084198138266934026006514e6
             + 2.5242473007215438042618436273125e6*z))
             + y*(2.8370103982890157887811290767492e6
             + z*(-2.4395521610262814792504265056066e7
             + (4.0703487724134893843722228490413e7
             - 1.597582831114556012960456295707e7*z)*z)
             + y*(-1.0812469386259551394022908037386e7
             + z*(7.698954267200708602998623063303e7
             + z*(-9.8517607918730954132561471568596e7
             + 2.4179632038490577493455554745835e7*z))
             + y*(1.8892413391337804410022235898167e7
             + y*(-1.5243602846884721956997687154871e7
             + 4.6092423573372663346899651234248e6*y
             + 4.1709865266396246176210831936566e7*z)
             + z*(-9.7186288892802157455094424655507e7
             + 7.027205561186324084035520598008e7*z)))))));
          case ( 152 ):
            return 52.306787322488082626843783806315
             + z*(-1046.1357464497616525368756761263
             + z*(4707.6108590239274364159405425684
             + z*(-7322.9502251483315677581297328842
             + 3661.4751125741657838790648664421*z)))
             + y*(-2249.1918548669875529542827036716
             + z*(43937.701350889989406548778397305
             + z*(-193012.0452199810248930535622453
             + (292918.00900593326271032518931537
             - 142797.52939039246557128352979124*z)*z))
             + y*(22753.452485282315942677045955747
             + z*(-411131.34835475632944699214071764
             + z*(1.6570790223764224576184110709841e6
             + z*(-2.2847604702462794491405364766599e6
             + 999582.7057327472589989847085387*z)))
             + y*(-93367.615370641227488916154094273
             + y*(189089.03617079441869604027845983
             + z*(-2.3255597643578201535894746280288e6
             + (5.5691036462253061572800576618584e6
             - 3.3319423524424908633299490284623e6*z)*z)
             + y*(-201956.50585212648702224384927618
             + y*(109478.10586596755693798403950662
             - 23799.588231732077595213921631874*y
             - 475991.76463464155190427843263747*z)
             + (1.7135703526847095868554023574949e6
             - 2.1419629408558869835692529468686e6*z)*z))
             + z*(1.4562209590580682203313309411678e6
             + z*(-4.8959152933848845338725781642711e6
             + (5.3311077639079853813279184455397e6
             - 1.6659711762212454316649745142311e6*z)*z)))))
             + x*(-1307.6696830622020656710945951579
             + z*(25107.257914794279660885016227031
             + z*(-108275.04975755033103756663247907
             + (161104.90495326329449067885412345
             - 76890.97736405748146146036219528*z)*z))
             + y*(53980.604516807701270902784888117
             + z*(-1.010567131070469756350621903138e6
             + z*(4.2462649948395825476471783693967e6
             + z*(-6.1512781891245985169168289756227e6
             + 2.8559505878078493114256705958248e6*z)))
             + y*(-523329.40716149326668157205698219
             + z*(9.0448896638046392478338270957881e6
             + z*(-3.4798659469904871609986632490666e7
             + (4.5695209404925588982810729533197e7
             - 1.8992071408922197920980709462235e7*z)*z))
             + y*(2.054087538154107004756155390074e6
             + z*(-3.0580640140219432626957949764524e7
             + z*(9.7918305867697690677451563285422e7
             + z*(-1.0129104751425172224523045046525e8
             + 2.9987481171982417769969541256161e7*z)))
             + y*(-3.9708697595866827926168458476564e6
             + y*(4.0391301170425297404448769855237e6
             + y*(-2.0800840114533835818216967506257e6
             + 428392.58817117739671385058937372*y
             + 8.567851763423547934277011787474e6*z)
             + z*(-3.2557836701009482150252644792403e7
             + 3.8555332935405965704246553043635e7*z))
             + z*(4.6511195287156403071789492560576e7
             + z*(-1.0581296927828081698832109557531e8
             + 5.997496234396483553993908251232e7*z))))))
             + x*(7689.0977364057481461460362195284
             + z*(-128674.69681332068326203570816354
             + z*(470761.08590239274364159405425684
             + z*(-571190.11756156986228513411916496
             + 208704.0814167274496811066973872*z)))
             + x*(-21602.703164187578124886482712008
             + z*(303379.36647043087923569394607663
             + z*(-894446.06321454621291902870308799
             + (820170.42521661313558891053008303
             - 201381.13119157911811334856765431*z)*z))
             + x*(34784.0135694545749468511162312
             + z*(-392300.90491866061970132837854737
             + z*(870908.00891942657573694900037515
             + z*(-534575.36643582820444634347050054
             + 65906.55202633498410982316759596*z)))
             + x*(-34051.718546939741790075303257911
             + z*(288733.46602013421610017768661086
             + z*(-428392.58817117739671385058937372
             + 131813.10405266996821964633519191*z))
             + x*(20138.113119157911811334856765431
             + x*(-6642.9619899559864936091605434021
             + 941.5221718047854872831881085137*x
             + 40485.453387605775953177088666088*y
             + 18830.443436095709745663762170274*z)
             + z*(-114028.79636302402012651944869777
             + 84736.99546243069385548692976623*z)
             + y*(-245161.9121805016432720168147002
             + 409562.14473508168696818682720345*y
             + 790878.6243160198093178780111515*z))
             + y*(620776.95194328856461538202621335
             + z*(-3.9983308229309890359959388341547e6
             + 3.4742168139596584480749641204155e6*z)
             + y*(-2.070564176160690750783611181973e6
             + 1.6806170766715420948004907736969e6*y
             + 7.400364270385613930045858532918e6*z)))
             + y*(-843446.94557512033235785601387684
             + z*(8.1284747499146480402115240035014e6
             + z*(-1.4089879301058614817192910043907e7
             + 5.272524162106798728785853407677e6*z))
             + y*(4.2093887097772284493952535018132e6
             + y*(-6.8158359220568096066908792488819e6
             + 3.4036026510742995365287250122769e6*y
             + 2.6211977263045227965963956941021e7*z)
             + z*(-3.0012588429897212049630426272388e7
             + 2.9827422402775604237131399277713e7*z))))
             + y*(652265.63791142639035674198406475
             + z*(-8.3481632566690979872442678954879e6
             + z*(2.1617349064637874788021998971474e7
             + z*(-1.6110490495326329449067885412345e7
             + 2.5703555290270643802831035362423e6*z)))
             + y*(-4.323155972203640029108638731592e6
             + z*(4.6046711015732708898063119760376e7
             + z*(-9.1139346230703235169012608904124e7
             + 4.1125688464433030084529656579877e7*z))
             + y*(1.0457172921511817478758609258559e7
             + y*(-1.0399896989393693028282215315291e7
             + 3.6352171053382767664003892869713e6*y
             + 4.1860075758440762764610543304518e7*z)
             + z*(-8.009215274819375211822320176423e7
             + 8.812647528092792160970640695688e7*z)))))
             + y*(-276650.5981486394690133767725516
             + z*(4.3937701350889989406548778397305e6
             + z*(-1.5054939527158519941658177855134e7
             + (1.6696326513338195974488535790976e7
             - 5.283508587444521226137490602276e6*z)*z))
             + y*(2.2753452485282315942677045955747e6
             + z*(-3.2068245171670993696865386975976e7
             + z*(9.4453504275456080084249431046092e7
             + z*(-8.4536137399112339618199849636415e7
             + 1.7992488703189450661981724753696e7*z)))
             + y*(-7.2826739989100157441354600193533e6
             + z*(8.3004594666309888558885863646566e7
             + z*(-1.8114886585524072775328539207803e8
             + 9.595993975034373686390253201971e7*z))
             + y*(1.077807506173528186567429587221e7
             + y*(-7.4723907165286800198230224232188e6
             + 1.9706059055874160248837127111191e6*y
             + 3.0844266348324772563397242434908e7*z)
             + z*(-8.6045711281239345682810561237065e7
             + 1.0024386563205551083104103791345e8*z)))))));
          case ( 153 ):
            return 57.82732917920384121395251797091
             + z*(-1734.8198753761152364185755391273
             + z*(12143.739127632806654930028773891
             + z*(-32383.30434035415107981341006371
             + (36431.217382898419964790086321674
             - 14572.486953159367985916034528669*z)*z)))
             + y*(-1908.30186291372676006043309304
             + z*(55514.236012035687565394417252074
             + z*(-376455.91295661700630283089199063
             + z*(971499.13021062453239440230191129
             + z*(-1.0565053041040541789789125033285e6
             + 408029.63468846230360564896680274*z))))
             + y*(14745.968940696979509557892082582
             + z*(-386864.83220887369772134234522539
             + z*(2.3315979125054988777465655245871e6
             + z*(-5.246095303137372474929772430321e6
             + (4.8453519119254898553170814807826e6
             - 1.5301111300817336385211836255103e6*z)*z)))
             + y*(-47129.273281051130589371302146292
             + z*(1.0270133662226602199597967191634e6
             + z*(-4.8574956510531226619720115095565e6
             + (7.7072264330042879569955915951629e6
             - 3.8252778252043340963029590637757e6*z)*z))
             + y*(77199.484454237128020626611491165
             + z*(-1.2889711674044536206590016255716e6
             + (4.1653025207780526826409998694447e6
             - 3.4002469557371858633804080566895e6*z)*z)
             + y*(-68872.349052431774885817448903354
             + y*(31978.513036099724191315742437913
             - 6071.869563816403327465014386946*y
             - 182156.08691449209982395043160837*z)
             + (777199.30416849962591552184152904
             - 1.2750926084014446987676530212586e6*z)*z)))))
             + x*(-1445.6832294800960303488129492728
             + z*(41635.677009026765674045812939055
             + z*(-279305.9999355545530633906617995
             + z*(712432.69548779132375589502140162
             + z*(-765055.56504086681926059181275514
             + 291449.73906318735971832069057339*z))))
             + y*(45799.244709929442241450394232961
             + z*(-1.2768274282768208140040715967977e6
             + z*(8.2820300850455741386622796237938e6
             + z*(-2.0401481734423115180282448340137e7
             + (2.1130106082081083579578250066571e7
             - 7.752563059080783768507330369252e6*z)*z)))
             + y*(-339157.28563603052871983151789939
             + z*(8.5110263085952213498695315949586e6
             + z*(-4.8963556162615476432677876016329e7
             + z*(1.0492190606274744949859544860642e8
             + z*(-9.2061686326584307251024548134869e7
             + 2.7542000341471205493381305259185e7*z))))
             + y*(1.0368440121831248729661686472184e6
             + y*(-1.6211891735389796884331588413145e6
             + y*(1.3774469810486354977163489780671e6
             + y*(-607591.74768589475963499910632036
             + 109293.65214869525989437025896502*y
             + 3.2788095644608577968311077689506e6*z)
             + z*(-1.4766786779201492892394914989052e7
             + 2.2951666951226004577817754382654e7*z))
             + z*(2.5779423348089072413180032511432e7
             + z*(-7.9140747894783000970178997519449e7
             + 6.120444520326934554084734502041e7*z)))
             + z*(-2.1567280690675864619155731102431e7
             + z*(9.7149913021062453239440230191129e7
             + z*(-1.464373022270814711829162403081e8
             + 6.885500085367801373345326314796e7*z))))))
             + x*(8500.6173893429646584510201417238
             + z*(-213382.84467126217407948479131266
             + z*(1.2143739127632806654930028773891e6
             + z*(-2.5258977385476237842254459849694e6
             + (2.0765793908252099379930349203354e6
             - 539182.0172668966154788932775608*z)*z)))
             + x*(-23882.686951011186421362389921986
             + z*(503097.76385907341856138690634692
             + z*(-2.3073104342502332644367054670393e6
             + z*(3.6269300861196649209391019271355e6
             + z*(-2.003716956059413098063454747692e6
             + 262304.76515686862374648862151605*z))))
             + x*(38455.173904170554407278424450655
             + z*(-650557.45326604321365696582717274
             + z*(2.2465917386120692311620553231699e6
             + z*(-2.3639812168458530288263789346508e6
             + 655761.9128921715593662215537901*z)))
             + x*(-37645.591295661700630283089199063
             + z*(478810.28560380780525152684879914
             + z*(-1.1050802606145854055986326184241e6
             + 582899.4781263747194366413811468*z))
             + x*(22263.5217339934788673717194188
             + x*(-7344.0708057588878341719697823056
             + 1040.8919252256691418511453234764*x
             + 34349.433532447081681087795674721*y
             + 31226.757756770074255534359704292*z)
             + z*(-189095.36641599656076962473376488
             + 218587.30429739051978874051793004*z)
             + y*(-208004.90305759621684658720714136
             + 265427.44093254563117204205748648*y
             + 999256.2482166423761770995105373*z))
             + y*(526691.31416418858577667953367905
             + z*(-5.0517954770952475684508919699387e6
             + 6.776206433219106113450956055831e6*z)
             + y*(-1.341883173603425135369768179515e6
             + 848326.9190589203506086834386333*y
             + 6.963566979759726558984162214057e6*z)))
             + y*(-715613.19859264753502266240989002
             + z*(1.0270133662226602199597967191634e7
             + z*(-2.7481281645833041460106655115316e7
             + 1.7486984343791241583099241434403e7*z))
             + y*(2.7280042540289412092682100352777e6
             + y*(-3.4404369495167325330241050566793e6
             + 1.389590720176268304371279006841e6*y
             + 1.8486240592007883959276340944941e7*z)
             + z*(-2.8241132751247779933657991201453e7
             + 4.1968762425098979799438179442568e7*z))))
             + y*(553407.54024498076041752559698161
             + z*(-1.0547704842286780637424939277894e7
             + z*(4.216306225114110470591705990295e7
             + z*(-5.3432452161584349281692126605121e7
             + 1.9017095473872975221620425059914e7*z)))
             + y*(-2.8017340987324261068159994956906e6
             + y*(5.2784786074777266260095858403847e6
             + y*(-4.2459716449830420411344636320141e6
             + 1.2397022829437719479447140802604e6*y
             + 2.3201481013280165171862029260289e7*z)
             + z*(-5.6485735142246312097788819553985e7
             + 8.743492171895620791549620717202e7*z))
             + z*(4.3328861207393854144790342665244e7
             + z*(-1.2823788518780243827606110385229e8
             + 9.442971545647270454873590374578e7*z)))))
             + y*(-234721.12913838839148743327044393
             + z*(5.5514236012035687565394417252074e6
             + z*(-2.9363561210616126491620809575269e7
             + z*(5.5375450422005598346480931208944e7
             + z*(-3.9090696251850004622219762623156e7
             + 7.344533424392321464901681402449e6*z))))
             + y*(1.4745968940696979509557892082582e6
             + z*(-3.017545691229214842226470292758e7
             + z*(1.3290108101281343603155423490147e8
             + z*(-1.9410552621608278157240157992188e8
             + 8.721633441465881739570746665409e7*z)))
             + y*(-3.6760833159219881859709615674108e6
             + y*(4.4003706138915162971757168549964e6
             + y*(-2.5482769149399756707752456094241e6
             + 575613.2346497950354436833638824*y
             + 1.3989587475032993266479393147523e7*z)
             + z*(-4.7691933193964783964383060146149e7
             + 7.497544537400494828753799765e7*z))
             + z*(5.8539761874691632537708412992312e7
             + z*(-1.7972733908896553849296442585359e8
             + 1.3873007579407718322592064871293e8*z)))))));
          case ( 154 ):
            return 62.864934582006843920873547956512
             + z*(-2640.3272524442874446766890141735
             + z*(26403.272524442874446766890141735
             + z*(-105613.09009777149778706756056694
             + z*(198024.54393332155835075167606301
             + z*(-174261.59866132297134866147493545
             + 58087.19955377432378288715831182*z)))))
             + y*(-1320.1636262221437223383445070868
             + z*(52806.54504888574889353378028347
             + z*(-501662.17796441461448857091269297
             + z*(1.9010356217598869601672160902049e6
             + z*(-3.3664172468664664919627784930712e6
             + (2.7881855785811675415785835989672e6
             - 871307.9933066148567433073746773*z)*z))))
             + y*(6600.8181311107186116917225354338
             + z*(-224427.81645776443279751856620475
             + z*(1.7426159866132297134866147493545e6
             + z*(-5.0694283246930318937792429072131e6
             + (6.1387608619329683088733019579534e6
             - 2.6139239799198445702299221240318e6*z)*z)))
             + y*(-15401.908972591676760614019249345
             + z*(422452.36039108599114827024226776
             + z*(-2.4819076172976301979960876733231e6
             + (4.8582021444974888982051077860793e6
             - 2.9703681589998233752612751409452e6*z)*z))
             + y*(19802.454393332155835075167606301
             + z*(-409250.72412886455392488679719689
             + (1.6105996239910153412527802986458e6
             - 1.5841963514665724668060134085041e6*z)*z)
             + y*(-14521.799888443580945721789577954
             + y*(5720.7090469626227967994928640426
             - 942.9740187301026588131032193477*y
             - 39604.908786664311670150335212603*z)
             + (200664.87118576584579542836507719
             - 396049.08786664311670150335212603*z)*z)))))
             + x*(-1571.6233645501710980218386989128
             + z*(63367.854058662898672240536340164
             + z*(-607275.26806218611227563847325991
             + z*(2.3234879821509729513154863324727e6
             + z*(-4.1585154225997527253657851973233e6
             + (3.485231973226459426973229498709e6
             - 1.1036567915217121518748560079245e6*z)*z))))
             + y*(31683.927029331449336120268170082
             + z*(-1.2145505361243722245512769465198e6
             + z*(1.1036567915217121518748560079245e7
             + z*(-3.9921748056957626163511537894303e7
             + z*(6.7328344937329329839255569861424e7
             + z*(-5.2975525993042183289993088380377e7
             + 1.5683543879519067421379532744191e7*z)))))
             + y*(-151818.81701554652806890961831498
             + z*(4.9374119620708175215454084565045e6
             + z*(-3.6594935718877823983218909736445e7
             + z*(1.0138856649386063787558485814426e8
             + z*(-1.1663645637672639786859273720111e8
             + 4.7050631638557202264138598232572e7*z))))
             + y*(338841.9973970168887335084234856
             + y*(-415851.54225997527253657851973233
             + y*(290435.99776887161891443579155909
             + y*(-108693.47189228983313919036441681
             + 16973.532337141847858635857948258*y
             + 712888.3581599576100627060338268*z)
             + z*(-3.8126325525295510701131389364665e6
             + 7.128883581599576100627060338268e6*z))
             + z*(8.1850144825772910784977359439379e6
             + z*(-3.0601392855829291483802825674271e7
             + 2.8515534326398304402508241353074e7*z)))
             + z*(-8.871499568212805814113675087623e6
             + z*(4.9638152345952603959921753466462e7
             + z*(-9.2305840745452289065897047935506e7
             + 5.346662686199682075470295253701e7*z))))))
             + x*(9241.1453835550060563684115496073
             + z*(-324760.25205064735569523274874334
             + z*(2.6403272524442874446766890141735e6
             + z*(-8.2378210276261768273912697242213e6
             + z*(1.1287399004199328825992845535592e7
             + z*(-6.4476791504689499399004745726117e6
             + 1.0455695919679378280919688496127e6*z)))))
             + x*(-25963.21798236882653932077530604
             + z*(765694.90320884335895623981411032
             + z*(-5.0166217796441461448857091269297e6
             + z*(1.1828666090950407752151566783497e7
             + z*(-1.0891349916332685709291342183466e7
             + 3.1367087759038134842759065488381e6*z))))
             + x*(41805.181497034551207380909391081
             + z*(-990122.71966660779175375838031507
             + z*(4.884605417021931772651874676221e6
             + z*(-7.7097555771373193384559319213866e6
             + 3.5644417907997880503135301691342e6*z)))
             + x*(-40925.072412886455392488679719689
             + x*(24202.999814072634909536315963257
             + x*(-7983.846691914869177950940590477
             + 1131.5688224761231905757238632172*x
             + 23762.945271998587002090201127562*y
             + 47525.890543997174004180402255123*z)
             + z*(-287795.67051642733146975910254491
             + 475258.90543997174004180402255123*z)
             + y*(-143897.83525821366573487955127246
             + 118814.72635999293501045100563781*y
             + 950517.8108799434800836080451025*z))
             + z*(728730.32167462333473076616791189
             + z*(-2.4026977997243015746557870028979e6
             + 1.9010356217598869601672160902049e6*z))
             + y*(364365.16083731166736538308395594
             + y*(-600674.44993107539366394675072447
             + 277234.36150665018169105234648822*y
             + 4.0397006962397597903553341916855e6*z)
             + z*(-4.8053955994486031493115740057958e6
             + 9.029919203359463060794276428473e6*z)))
             + y*(-495061.35983330389587687919015753
             + y*(1.2211513542554829431629686690552e6
             + y*(-1.1243393549991924035248234052022e6
             + 356444.17907997880503135301691342*y
             + 7.60414248703954784066886436082e6*z)
             + z*(-1.6383230601416803594218855332947e7
             + 3.1367087759038134842759065488381e7*z))
             + z*(9.769210834043863545303749352442e6
             + z*(-3.6621338991402266857665676626587e7
             + 3.4218641191677965283009889623689e7*z))))
             + y*(382847.45160442167947811990705516
             + z*(-1.0033243559288292289771418253859e7
             + z*(5.6186163932014436822719942221612e7
             + z*(-1.0455695919679378280919688496127e8
             + 6.059551044359639685533001287528e7*z)))
             + y*(-1.2541554449110365362214272817324e6
             + y*(1.7250138049302677971887701559267e6
             + y*(-1.0891349916332685709291342183466e6
             + 261392.39799198445702299221240318*y
             + 7.366513034319561970647962349544e6*z)
             + z*(-2.3234879821509729513154863324727e7
             + 4.4674337111357343563929578119816e7*z))
             + z*(2.5135915443269616473322079414932e7
             + z*(-9.5843879263727634241763811214498e7
             + 9.124970984447457408802637232984e7*z)))))
             + y*(-162380.12602532367784761637437167
             + z*(5.280654504888574889353378028347e6
             + z*(-3.9129649881224339930108531190051e7
             + z*(1.0835903044031355672953131714168e8
             + z*(-1.2455743813405926020262280424364e8
             + 5.018734041446101574841450478141e7*z))))
             + y*(660081.81311107186116917225354338
             + y*(-1.2013488998621507873278935014489e6
             + y*(1.1287399004199328825992845535592e6
             + y*(-537306.59587241249499170621438431
             + 102972.76284532721034239087155277*y
             + 3.6119676813437852243177105713894e6*z)
             + z*(-1.5142276792767988495220811496285e7
             + 2.8990793231838276142550045375625e7*z))
             + z*(2.4079784542291901495451403809262e7
             + z*(-9.1830581840012317325855243912955e7
             + 8.744763860095480016769194014943e7*z)))
             + z*(-1.750536968370562575820644816397e7
             + z*(9.9329111236954093668737040713207e7
             + z*(-1.8756884801364218006983198756689e8
             + 1.1049769551479342955971943524316e8*z)))))));
          case ( 155 ):
            return 67.527772064536528732467557638088
             + z*(-3781.555235614045609018183227733
             + z*(51050.995680789615721745473574395
             + z*(-283616.64267105342067636374207997
             + z*(779945.76734539690686000029071992
             + z*(-1.1231219049773715458784004186367e6
             + (811143.59803921278313440030234872
             - 231755.31372548936660982865781392*z)*z)))))
             + y*(-472.69440445175570112727290346662
             + z*(22689.331413684273654109099366398
             + z*(-255254.97840394807860872736787197
             + z*(1.1344665706842136827054549683199e6
             + z*(-2.3398373020361907205800008721598e6
             + (2.2462438099547430917568008372734e6
             - 811143.5980392127831344003023487*z)*z))))
             + y*(1418.0832133552671033818187103999
             + z*(-56723.328534210684135272748415994
             + z*(510509.95680789615721745473574395
             + z*(-1.7016998560263205240581824524798e6
             + (2.3398373020361907205800008721598e6
             - 1.1231219049773715458784004186367e6*z)*z)))
             + y*(-2363.4720222587785056363645173331
             + z*(75631.104712280912180363664554659
             + z*(-510509.95680789615721745473574395
             + (1.1344665706842136827054549683199e6
             - 779945.7673453969068600002907199*z)*z))
             + y*(2363.4720222587785056363645173331
             + z*(-56723.328534210684135272748415994
             + (255254.97840394807860872736787197
             - 283616.64267105342067636374207997*z)*z)
             + y*(-1418.0832133552671033818187103999
             + y*(472.69440445175570112727290346662
             - 67.52777206453652873246755763809*y
             - 3781.555235614045609018183227733*z)
             + (22689.331413684273654109099366398
             - 51050.99568078961572174547357439*z)*z)))))
             + x*(-1688.1943016134132183116889409522
             + z*(90757.325654737094616436397465591
             + z*(-1.1741729006581611616001458922111e6
             + z*(6.2395661387631752548800023257594e6
             + z*(-1.6378861114253335044060006105118e7
             + z*(2.2462438099547430917568008372734e7
             + z*(-1.5411728362745042879553605744626e7
             + 4.1715956470588085989769158406506e6*z))))))
             + y*(11344.665706842136827054549683199
             + z*(-521854.62251473829404450928542715
             + z*(5.6156095248868577293920020931834e6
             + z*(-2.3823797984368487336814554334718e7
             + z*(4.6796746040723814411600017443195e7
             + z*(-4.2678632389140118743379215908194e7
             + 1.4600584764705830096419205442277e7*z)))))
             + y*(-32615.913907171143377781830339197
             + y*(51996.384489693127124000019381328
             + y*(-49632.912467434348618363654863995
             + y*(28361.664267105342067636374207997
             + y*(-8981.1936845833583214181851658658
             + 1215.4998971616575171844160374856*y
             + 68067.99424105282096232729809919*z)
             + z*(-431097.29686000119942807288796156
             + 918917.9222542130829914185243391*z))
             + z*(1.1344665706842136827054549683199e6
             + z*(-4.8498445896750134935658199895675e6
             + 5.105099568078961572174547357439e6*z)))
             + z*(-1.5882531989578991557876369556478e6
             + z*(1.0210199136157923144349094714879e7
             + z*(-2.1554864843000059971403644398078e7
             + 1.4039023812217144323480005232959e7*z))))
             + z*(1.2479132277526350509760004651519e6
             + z*(-1.0720709092965819301566549450623e7
             + z*(3.4033997120526410481163649049597e7
             + z*(-4.4456908738687623691020016571036e7
             + 2.021619428959268782581120753546e7*z))))))
             + x*(9926.582493486869723672730972799
             + z*(-465131.29398052760990923653701115
             + z*(5.1050995680789615721745473574395e6
             + z*(-2.2122098128342166812756371882238e7
             + z*(4.4456908738687623691020016571036e7
             + z*(-4.1555510484162747197500815489557e7
             + 1.4600584764705830096419205442277e7*z)))))
             + y*(-58141.411747565951238654567126394
             + z*(2.2689331413684273654109099366398e6
             + z*(-1.9909888315507950131480734694014e7
             + z*(6.4664594529000179914210933194233e7
             + z*(-8.6573980175339056661460032269911e7
             + 4.0432388579185375651622415070921e7*z))))
             + y*(141808.32133552671033818187103999
             + y*(-184350.81773618472343963643235198
             + y*(134717.90526875037482127277748799
             + y*(-52469.078894144882825127292284795
             + 8508.499280131602620290912262399*y
             + 408407.96544631692577396378859516*z)
             + z*(-2.0987631557657953130050916913918e6
             + 4.5945896112710654149570926216955e6*z))
             + z*(4.3109729686000119942807288796156e6
             + z*(-1.8888868401892157817045825222526e7
             + 2.0420398272315846288698189429758e7*z)))
             + z*(-4.4244196256684333625512743764476e6
             + z*(2.9099067538050080961394919937405e7
             + z*(-6.2962894672973859390152750741754e7
             + 4.2117071436651432970440015698876e7*z)))))
             + x*(-27888.969862653586366509101304531
             + z*(1.0966510183280732266152731360426e6
             + z*(-9.699689179350026987131639979135e6
             + z*(3.1765063979157983115752739112957e7
             + z*(-4.2897017203996829877300015989596e7
             + 2.021619428959268782581120753546e7*z))))
             + x*(44905.968422916791607090925829329
             + x*(-43960.579614013280204836380022396
             + x*(25998.192244846563562000009690664
             + x*(-8576.0270521961391490233798200372
             + 1215.4998971616575171844160374856*x
             + 8508.499280131602620290912262399*y
             + 68067.99424105282096232729809919*z)
             + y*(-51523.690085241371422872746477861
             + 25525.497840394807860872736787197*y
             + 408407.96544631692577396378859516*z)
             + z*(-412189.52068193097138298197182289
             + 918917.9222542130829914185243391*z))
             + y*(130463.65562868457351112732135679
             + y*(-129045.57241532930640774550264639
             + 42542.496400658013101454561311996*y
             + 1.0210199136157923144349094714879e6*z)
             + z*(-2.0647291586452689025239280423422e6
             + 4.5945896112710654149570926216955e6*z))
             + z*(1.0437092450294765880890185708543e6
             + z*(-4.6456406069518550306788380952699e6
             + 5.105099568078961572174547357439e6*z)))
             + z*(-1.4180832133552671033818187103999e6
             + z*(9.444434200946078908522912611263e6
             + z*(-2.0704014914986899709374553171838e7
             + 1.4039023812217144323480005232959e7*z)))
             + y*(-177260.40166940838792272733879998
             + y*(262345.39447072441412563646142397
             + y*(-172533.45762489083091145460976532
             + 42542.496400658013101454561311996*y
             + 1.3613598848210564192465459619839e6*z)
             + z*(-4.1408029829973799418749106343676e6
             + 9.189179222542130829914185243391e6*z))
             + z*(4.1975263115315906260101833827836e6
             + z*(-1.8633613423488209738437097854654e7
             + 2.0420398272315846288698189429758e7*z))))
             + y*(137081.37729100915332690914200532
             + y*(-269435.81053750074964254555497597
             + y*(264708.86649298319263127282594131
             + y*(-129990.96122423281781000004845332
             + 25525.497840394807860872736787197*y
             + 1.0210199136157923144349094714879e6*z)
             + z*(-4.1597107591754501699200015505062e6
             + 9.189179222542130829914185243391e6*z))
             + z*(6.3530127958315966231505478225914e6
             + z*(-2.8078047624434288646960010465917e7
             + 3.0630597408473769433047284144637e7*z)))
             + z*(-4.3109729686000119942807288796156e6
             + z*(2.8588557581242184804177465201661e7
             + z*(-6.2395661387631752548800023257594e7
             + 4.2117071436651432970440015698876e7*z)))))));
          case ( 156 ):
            return 18.493242008906929350750577144363
             + y*(-1479.459360712554348060046171549
             + y*(28479.592693716671200155888802319
             + y*(-227836.74154973336960124711041855
             + y*(925586.76254579181400506638607535
             + y*(-2.0733143481025736633713487048088e6
             + y*(2.591642935128217079214185881011e6
             + y*(-1.6925015086551621741806928202521e6
             + 449570.71323652745251674653037946*y)))))))
             + x*(-147.9459360712554348060046171549
             + y*(10356.215524987880436420323200843
             + y*(-170877.55616230002720093533281391
             + y*(1.1391837077486668480062355520927e6
             + y*(-3.7023470501831672560202655443014e6
             + y*(6.2199430443077209901140461144264e6
             + y*(-5.183285870256434158428371762022e6
             + 1.6925015086551621741806928202521e6*y))))))
             + x*(517.81077624939402182101616004216
             + x*(-1035.6215524987880436420323200843
             + x*(1294.5269406234850545525404001054
             + x*(-1035.6215524987880436420323200843
             + x*(517.81077624939402182101616004216
             + x*(-147.9459360712554348060046171549
             + 18.493242008906929350750577144363*x
             + 1479.459360712554348060046171549*y)
             + y*(-10356.215524987880436420323200843
             + 28479.592693716671200155888802319*y))
             + y*(31068.646574963641309260969602529
             + y*(-170877.55616230002720093533281391
             + 227836.74154973336960124711041855*y)))
             + y*(-51781.077624939402182101616004216
             + y*(427193.89040575006800233833203478
             + y*(-1.1391837077486668480062355520927e6
             + 925586.7625457918140050663860754*y))))
             + y*(51781.077624939402182101616004216
             + y*(-569591.85387433342400311777604637
             + y*(2.2783674154973336960124711041855e6
             + y*(-3.7023470501831672560202655443014e6
             + 2.0733143481025736633713487048088e6*y)))))
             + y*(-31068.646574963641309260969602529
             + y*(427193.89040575006800233833203478
             + y*(-2.2783674154973336960124711041855e6
             + y*(5.5535205752747508840303983164521e6
             + y*(-6.2199430443077209901140461144264e6
             + 2.591642935128217079214185881011e6*y)))))));
          case ( 157 ):
            return 32.031234756093933632434571896787
             - 64.06246951218786726486914379357*z
             + y*(-2498.4363109753268233298966079494
             + 4932.8101524384657793949240721052*z
             + y*(46861.696448165424904251778685
             - 88790.58274389238402910863329789*z
             + y*(-365027.95128044646767522438133579
             + 641265.3198170005513213401293737*z
             + y*(1.4428469695882512404730152910908e6
             - 2.2444286193595019296246904528079e6*z
             + y*(-3.142200067103302701474566633931e6
             + 4.0399715148471034733244428150542e6*z
             + y*(3.8155286529111532803619737697734e6
             - 3.5910857909752030873995047244926e6*z
             + y*(-2.418486349024116364983339916495e6
             + 622943.4535365148212835875542487*y
             + 1.2458869070730296425671751084974e6*z)))))))
             + x*(-256.2498780487514690594765751743
             + 448.43728658531507085408400655502*z
             + y*(17489.054176827287763309276255646
             - 29596.860914630794676369544432631*z
             + y*(-281170.17868899254942551067211
             + 443952.91371946192014554316648947*z
             + y*(1.8251397564022323383761219066789e6
             - 2.5650612792680022052853605174947e6*z
             + y*(-5.7713878783530049618920611643631e6
             + 6.733285858078505788874071358424e6*z
             + y*(9.4266002013099081044236999017931e6
             - 8.079943029694206946648885630108e6*z
             + y*(-7.6310573058223065607239475395468e6
             + 2.418486349024116364983339916495e6*y
             + 3.5910857909752030873995047244926e6*z))))))
             + x*(896.87457317063014170816801311004
             - 1345.3118597559452125622520196651*z
             + x*(-1793.7491463412602834163360262201
             + 2242.1864329265753542704200327751*z
             + x*(2242.1864329265753542704200327751
             - 2242.1864329265753542704200327751*z
             + x*(-1793.7491463412602834163360262201
             + 1345.3118597559452125622520196651*z
             + x*(896.87457317063014170816801311004
             - 448.43728658531507085408400655502*z
             + x*(-256.2498780487514690594765751743
             + 32.031234756093933632434571896787*x
             + 2498.4363109753268233298966079494*y
             + 64.06246951218786726486914379357*z)
             + y*(-17489.054176827287763309276255646
             + 46861.696448165424904251778685*y
             + 4932.8101524384657793949240721052*z))
             + y*(52467.162530481863289927828766937
             - 29596.860914630794676369544432631*z
             + y*(-281170.17868899254942551067211
             + 365027.95128044646767522438133579*y
             + 88790.58274389238402910863329789*z)))
             + y*(-87445.270884136438816546381278229
             + 73992.15228657698669092386108158*z
             + y*(702925.44672248137356377668027499
             - 443952.91371946192014554316648947*z
             + y*(-1.8251397564022323383761219066789e6
             + 1.4428469695882512404730152910908e6*y
             + 641265.3198170005513213401293737*z))))
             + y*(87445.270884136438816546381278229
             - 98656.2030487693155878984814421*z
             + y*(-937233.92896330849808503557369999
             + 887905.8274389238402910863329789*z
             + y*(3.6502795128044646767522438133579e6
             - 2.5650612792680022052853605174947e6*z
             + y*(-5.7713878783530049618920611643631e6
             + 3.142200067103302701474566633931e6*y
             + 2.2444286193595019296246904528079e6*z)))))
             + y*(-52467.162530481863289927828766937
             + 73992.15228657698669092386108158*z
             + y*(702925.44672248137356377668027499
             - 887905.8274389238402910863329789*z
             + y*(-3.6502795128044646767522438133579e6
             + 3.8475919189020033079280407762421e6*z
             + y*(8.6570818175295074428380917465447e6
             - 6.733285858078505788874071358424e6*z
             + y*(-9.4266002013099081044236999017931e6
             + 3.8155286529111532803619737697734e6*y
             + 4.0399715148471034733244428150542e6*z)))))));
          case ( 158 ):
            return 41.352146256270665303867737658803
             + z*(-248.11287753762399182320642595282
             + 248.11287753762399182320642595282*z)
             + y*(-3060.0588229640292324862125867514
             + (18112.240060246551403094069094556
             - 17864.127182708927411270862668603*z)*z
             + y*(54378.072326995924874586075021325
             + z*(-308156.1939017289978444223810334
             + 290292.06671902007043315151836479*z)
             + y*(-400785.00151577528812508611338911
             + (2.0965538151929227309060942993013e6
             - 1.8062617484739026604729427809365e6*z)*z
             + y*(1.4971544552082794373265314419369e6
             + z*(-6.8863729160567538930530943523204e6
             + 5.080111167582851232580151571384e6*z)
             + y*(-3.0781710630242757838893066558459e6
             + (1.1582653462088900810282745582755e7
             - 6.502542294506049577702594011371e6*z)*z
             + y*(3.5259734548334308184648903869531e6
             + z*(-9.5731872669116841005065967389634e6
             + 3.070644972405634522804002727592e6*z)
             + y*(-2.1073053732195531038850999110926e6
             + 511774.1620676057538006671212653*y
             + 3.070644972405634522804002727592e6*z)))))))
             + x*(-330.81717005016532243094190127042
             + (1736.7901427633679427624449816697
             - 1488.6772652257439509392385557169*z)*z
             + y*(21420.41176074820462740348810726
             + z*(-108673.44036147930841856441456733
             + 89320.63591354463705635431334301*z)
             + y*(-326268.43396197554924751645012795
             + (1.540780969508644989222111905167e6
             - 1.1611682668760802817326060734592e6*z)*z
             + y*(2.0039250075788764406254305669456e6
             + z*(-8.3862152607716909236243771972052e6
             + 5.418785245421707981418828342809e6*z)
             + y*(-5.9886178208331177493061257677478e6
             + (2.0659118748170261679159283056961e7
             - 1.0160222335165702465160303142768e7*z)*z
             + y*(9.2345131890728273516679199675378e6
             + z*(-2.3165306924177801620565491165511e7
             + 6.502542294506049577702594011371e6*z)
             + y*(-7.0519469096668616369297807739062e6
             + 2.1073053732195531038850999110926e6*y
             + 9.573187266911684100506596738963e6*z))))))
             + x*(1157.8600951755786285082966544465
             + z*(-5210.3704282901038282873349450091
             + 3721.6931630643598773480963892922*z)
             + x*(-2315.7201903511572570165933088929
             + (8683.9507138168397138122249083485
             - 4962.2575507524798364641285190563*z)*z
             + x*(2894.6502379389465712707416361162
             + z*(-8683.9507138168397138122249083485
             + 3721.6931630643598773480963892922*z)
             + x*(-2315.7201903511572570165933088929
             + (5210.3704282901038282873349450091
             - 1488.6772652257439509392385557169*z)*z
             + x*(1157.8600951755786285082966544465
             + z*(-1736.7901427633679427624449816697
             + 248.11287753762399182320642595282*z)
             + x*(-330.81717005016532243094190127042
             + 41.352146256270665303867737658803*x
             + 3060.0588229640292324862125867514*y
             + 248.11287753762399182320642595282*z)
             + y*(-21420.41176074820462740348810726
             + 54378.07232699592487458607502133*y
             + 18112.240060246551403094069094556*z))
             + y*(64261.235282244613882210464321779
             + z*(-108673.44036147930841856441456733
             + 17864.127182708927411270862668603*z)
             + y*(-326268.43396197554924751645012795
             + 400785.00151577528812508611338911*y
             + 308156.1939017289978444223810334*z)))
             + y*(-107102.0588037410231370174405363
             + (271683.60090369827104641103641833
             - 89320.63591354463705635431334301*z)*z
             + y*(815671.08490493887311879112531988
             + z*(-1.540780969508644989222111905167e6
             + 290292.06671902007043315151836479*z)
             + y*(-2.0039250075788764406254305669456e6
             + 1.4971544552082794373265314419369e6*y
             + 2.0965538151929227309060942993013e6*z))))
             + y*(107102.0588037410231370174405363
             + z*(-362244.80120493102806188138189111
             + 178641.27182708927411270862668603*z)
             + y*(-1.0875614465399184974917215004265e6
             + (3.081561939017289978444223810334e6
             - 1.1611682668760802817326060734592e6*z)*z
             + y*(4.0078500151577528812508611338911e6
             + z*(-8.3862152607716909236243771972052e6
             + 1.8062617484739026604729427809365e6*z)
             + y*(-5.9886178208331177493061257677478e6
             + 3.0781710630242757838893066558459e6*y
             + 6.88637291605675389305309435232e6*z)))))
             + y*(-64261.235282244613882210464321779
             + (271683.60090369827104641103641833
             - 178641.27182708927411270862668603*z)*z
             + y*(815671.08490493887311879112531988
             + z*(-3.081561939017289978444223810334e6
             + 1.7417524003141204225989091101888e6*z)
             + y*(-4.0078500151577528812508611338911e6
             + (1.2579322891157536385436565795808e7
             - 5.418785245421707981418828342809e6*z)*z
             + y*(8.9829267312496766239591886516217e6
             + z*(-2.0659118748170261679159283056961e7
             + 5.080111167582851232580151571384e6*z)
             + y*(-9.2345131890728273516679199675378e6
             + 3.5259734548334308184648903869531e6*y
             + 1.1582653462088900810282745582755e7*z)))))));
          case ( 159 ):
            return 48.928519290900271428377303663089
             + z*(-587.14223149080325714052764395706
             + (1467.8555787270081428513191098927
             - 978.5703858180054285675460732618*z)*z)
             + y*(-3327.13931178121845712965664909
             + z*(39338.529509883818228415352145123
             + z*(-96878.468195982537428187061252916
             + 63607.07507817035285689049476202*z))
             + y*(54212.799374317500742642052458702
             + z*(-611215.0629819261906832892773593
             + (1.4311591892588329392800361321453e6
             - 890499.0510943849399964669266682*z)*z)
             + y*(-365789.61021877042919854872218525
             + z*(3.7782602596433189596992953888637e6
             + z*(-8.0144914598494644599682023400139e6
             + 4.4524952554719246999823346333411e6*z))
             + y*(1.2498790252860474336378982220736e6
             + z*(-1.122028804378925024395548327602e7
             + (2.0036228649623661149920505850035e7
             - 8.904990510943849399964669266682e6*z)*z)
             + y*(-2.3509174948891762415906726864041e6
             + z*(1.699072189488086465513258896083e7
             + z*(-2.2440576087578500487910966552039e7
             + 6.055393547441817591975975101344e6*z))
             + y*(2.466682371531446283790213386871e6
             + y*(-1.3535585576634651087946297285357e6
             + 302769.67737209087959879875506719*y
             + 3.6332361284650905551855850608063e6*z)
             + z*(-1.2609466563496490750349971681622e7
             + 9.083090321162726387963962652016e6*z)))))))
             + x*(-391.42815432720217142701842930471
             + z*(4109.9956204356227999836935076995
             + z*(-8807.133472362048857107914659356
             + 4892.8519290900271428377303663089*z))
             + x*(1369.9985401452075999945645025665
             + z*(-12329.986861306868399951080523098
             + (22017.83368090512214276978664839
             - 9785.703858180054285675460732618*z)*z)
             + x*(-2739.997080290415199989129005133
             + z*(20549.978102178113999918467538497
             + z*(-29357.111574540162857026382197853
             + 9785.703858180054285675460732618*z))
             + x*(3424.9963503630189999864112564162
             + z*(-20549.978102178113999918467538497
             + (22017.83368090512214276978664839
             - 4892.8519290900271428377303663089*z)*z)
             + x*(-2739.997080290415199989129005133
             + z*(12329.986861306868399951080523098
             + z*(-8807.133472362048857107914659356
             + 978.5703858180054285675460732618*z))
             + x*(1369.9985401452075999945645025665
             + x*(-391.42815432720217142701842930471
             + 48.928519290900271428377303663089*x
             + 3327.13931178121845712965664909*y
             + 587.1422314908032571405276439571*z)
             + z*(-4109.9956204356227999836935076995
             + 1467.8555787270081428513191098927*z)
             + y*(-23289.97518246852919990759654363
             + 54212.7993743175007426420524587*y
             + 39338.529509883818228415352145123*z))
             + y*(69869.925547405587599722789630891
             + z*(-236031.17705930290937049211287074
             + 96878.46819598253742818706125292*z)
             + y*(-325276.79624590500445585231475221
             + 365789.61021877042919854872218525*y
             + 611215.0629819261906832892773593*z)))
             + y*(-116449.87591234264599953798271815
             + z*(590077.94264825727342623028217685
             + z*(-484392.34097991268714093530626458
             + 63607.07507817035285689049476202*z))
             + y*(813191.99061476251113963078688053
             + z*(-3.0560753149096309534164463867965e6
             + 1.4311591892588329392800361321453e6*z)
             + y*(-1.8289480510938521459927436109263e6
             + 1.2498790252860474336378982220736e6*y
             + 3.7782602596433189596992953888637e6*z))))
             + y*(116449.87591234264599953798271815
             + z*(-786770.59019767636456830704290247
             + (968784.68195982537428187061252916
             - 254428.30031268141142756197904806*z)*z)
             + y*(-1.084255987486350014852841049174e6
             + z*(6.112150629819261906832892773593e6
             + z*(-5.7246367570353317571201445285814e6
             + 890499.0510943849399964669266682*z))
             + y*(3.6578961021877042919854872218525e6
             + z*(-1.5113041038573275838797181555455e7
             + 8.014491459849464459968202340014e6*z)
             + y*(-4.9995161011441897345515928882944e6
             + 2.3509174948891762415906726864041e6*y
             + 1.122028804378925024395548327602e7*z)))))
             + y*(-69869.925547405587599722789630891
             + z*(590077.94264825727342623028217685
             + z*(-968784.68195982537428187061252916
             + 381642.45046902211714134296857209*z))
             + y*(813191.99061476251113963078688053
             + z*(-6.112150629819261906832892773593e6
             + (8.5869551355529976356802167928721e6
             - 2.6714971532831548199894007800046e6*z)*z)
             + y*(-3.6578961021877042919854872218525e6
             + z*(2.2669561557859913758195772333182e7
             + z*(-2.4043474379548393379904607020042e7
             + 4.4524952554719246999823346333411e6*z))
             + y*(7.4992741517162846018273893324416e6
             + y*(-7.0527524846675287247720180592123e6
             + 2.466682371531446283790213386871e6*y
             + 1.699072189488086465513258896083e7*z)
             + z*(-3.3660864131367750731866449828059e7
             + 2.0036228649623661149920505850035e7*z))))))
             + y*(23289.97518246852919990759654363
             + z*(-236031.17705930290937049211287074
             + (484392.34097991268714093530626458
             - 254428.30031268141142756197904806*z)*z)
             + y*(-325276.79624590500445585231475221
             + z*(3.0560753149096309534164463867965e6
             + z*(-5.7246367570353317571201445285814e6
             + 2.6714971532831548199894007800046e6*z))
             + y*(1.8289480510938521459927436109263e6
             + z*(-1.5113041038573275838797181555455e7
             + (2.4043474379548393379904607020042e7
             - 8.904990510943849399964669266682e6*z)*z)
             + y*(-4.9995161011441897345515928882944e6
             + z*(3.3660864131367750731866449828059e7
             + z*(-4.007245729924732229984101170007e7
             + 8.904990510943849399964669266682e6*z))
             + y*(7.0527524846675287247720180592123e6
             + y*(-4.9333647430628925675804267737419e6
             + 1.3535585576634651087946297285357e6*y
             + 1.2609466563496490750349971681622e7*z)
             + z*(-3.3981443789761729310265177921659e7
             + 2.2440576087578500487910966552039e7*z)))))));
          case ( 160 ):
            return 55.479726026720788052251731433088
             + z*(-1109.5945205344157610450346286618
             + z*(4993.1753424048709247026558289779
             + z*(-7767.1616437409103273152424006323
             + 3883.5808218704551636576212003162*z)))
             + y*(-3328.7835616032472831351038859853
             + z*(65466.076711530529901657043091044
             + z*(-289604.16985948251363275403808072
             + (442728.21369323188865696881683604
             - 217480.52602474548916482678721771*z)*z))
             + y*(47712.564382979877724936489032456
             + z*(-888785.21094806702459707273755807
             + z*(3.7099292794068190970540732809306e6
             + z*(-5.3282728876062644845382562868338e6
             + 2.4466559177783867531043013561992e6*z)))
             + y*(-282946.60273627601906648383030875
             + z*(4.7701468437774533567326038686169e6
             + z*(-1.7755731517591721008242644127846e7
             + (2.2291753917536412639394745689815e7
             - 8.699221040989819566593071488708e6*z)*z))
             + y*(851336.39588003049266180281884074
             + z*(-1.2256581073823156496503452508198e7
             + z*(3.7398883314612483226022892159045e7
             + z*(-3.5884286794083005712196419890921e7
             + 9.242922356051683289505138456752e6*z)))
             + y*(-1.4167302838183420437023002138753e6
             + y*(1.3243010602578252108072488293078e6
             + y*(-652441.57807423646749448036165312
             + 132041.74794359547556435912081075*y
             + 2.640834958871909511287182416215e6*z)
             + z*(-1.0407996602612819838602424816847e7
             + 1.1883757314923592800792320872967e7*z))
             + z*(1.6078024602543684377542551769309e7
             + z*(-3.4952227396834096472918590802846e7
             + 1.8485844712103366579010276913505e7*z)))))))
             + x*(-443.83780821376630441801385146471
             + z*(7767.1616437409103273152424006323
             + z*(-29959.052054429225548215934973868
             + (38835.808218704551636576212003162
             - 15534.323287481820654630484801265*z)*z))
             + y*(23301.484931222730981945727201897
             + z*(-392796.46026918317940994225854626
             + z*(1.4480208492974125681637701904036e6
             + z*(-1.7709128547729275546278752673442e6
             + 652441.5780742364674944803616531*z)))
             + y*(-286275.38629787926634961893419474
             + z*(4.4439260547403351229853636877904e6
             + z*(-1.4839717117627276388216293123722e7
             + (1.5984818662818793453614768860501e7
             - 4.8933118355567735062086027123984e6*z)*z))
             + y*(1.4147330136813800953324191515437e6
             + z*(-1.9080587375109813426930415474468e7
             + z*(5.3267194552775163024727932383537e7
             + z*(-4.458350783507282527878949137963e7
             + 8.699221040989819566593071488708e6*z)))
             + y*(-3.405345583520121970647211275363e6
             + y*(4.250190851455026131106900641626e6
             + y*(-2.6486021205156504216144976586156e6
             + 652441.5780742364674944803616531*y
             + 1.0407996602612819838602424816847e7*z)
             + z*(-3.2156049205087368755085103538618e7
             + 3.4952227396834096472918590802846e7*z))
             + z*(3.6769743221469469489510357524594e7
             + z*(-7.479776662922496645204578431809e7
             + 3.5884286794083005712196419890921e7*z))))))
             + x*(1553.4323287481820654630484801265
             + z*(-23301.484931222730981945727201897
             + z*(74897.630136073063870539837434669
             + z*(-77671.616437409103273152424006323
             + 23301.484931222730981945727201897*z)))
             + x*(-3106.8646574963641309260969602529
             + z*(38835.808218704551636576212003162
             + z*(-99863.506848097418494053116579559
             + (77671.616437409103273152424006323
             - 15534.323287481820654630484801265*z)*z))
             + x*(3883.5808218704551636576212003162
             + z*(-38835.808218704551636576212003162
             + z*(74897.630136073063870539837434669
             + z*(-38835.808218704551636576212003162
             + 3883.5808218704551636576212003162*z)))
             + x*(-3106.8646574963641309260969602529
             + z*(23301.484931222730981945727201897
             + z*(-29959.052054429225548215934973868
             + 7767.161643740910327315242400632*z))
             + x*(1553.4323287481820654630484801265
             + x*(-443.83780821376630441801385146471
             + 55.47972602672078805225173143309*x
             + 3328.7835616032472831351038859853*y
             + 1109.5945205344157610450346286618*z)
             + z*(-7767.1616437409103273152424006323
             + 4993.1753424048709247026558289779*z)
             + y*(-23301.484931222730981945727201897
             + 47712.564382979877724936489032456*y
             + 65466.07671153052990165704309104*z))
             + y*(69904.454793668192945837181605691
             + z*(-392796.46026918317940994225854626
             + 289604.16985948251363275403808072*z)
             + y*(-286275.38629787926634961893419474
             + 282946.60273627601906648383030875*y
             + 888785.2109480670245970727375581*z)))
             + y*(-116507.42465611365490972863600949
             + z*(981991.15067295794852485564636566
             + z*(-1.4480208492974125681637701904036e6
             + 442728.21369323188865696881683604*z))
             + y*(715688.46574469816587404733548684
             + z*(-4.4439260547403351229853636877904e6
             + 3.7099292794068190970540732809306e6*z)
             + y*(-1.4147330136813800953324191515437e6
             + 851336.3958800304926618028188407*y
             + 4.7701468437774533567326038686169e6*z))))
             + y*(116507.42465611365490972863600949
             + z*(-1.3093215342306105980331408618209e6
             + z*(2.8960416985948251363275403808072e6
             + z*(-1.7709128547729275546278752673442e6
             + 217480.52602474548916482678721771*z)))
             + y*(-954251.28765959755449872978064912
             + z*(8.8878521094806702459707273755807e6
             + z*(-1.4839717117627276388216293123722e7
             + 5.328272887606264484538256286834e6*z))
             + y*(2.8294660273627601906648383030875e6
             + y*(-3.405345583520121970647211275363e6
             + 1.4167302838183420437023002138753e6*y
             + 1.2256581073823156496503452508198e7*z)
             + z*(-1.9080587375109813426930415474468e7
             + 1.7755731517591721008242644127846e7*z)))))
             + y*(-69904.454793668192945837181605691
             + z*(981991.15067295794852485564636566
             + z*(-2.8960416985948251363275403808072e6
             + (2.6563692821593913319418129010163e6
             - 652441.5780742364674944803616531*z)*z))
             + y*(715688.46574469816587404733548684
             + z*(-8.8878521094806702459707273755807e6
             + z*(2.2259575676440914582324439685584e7
             + z*(-1.5984818662818793453614768860501e7
             + 2.4466559177783867531043013561992e6*z)))
             + y*(-2.8294660273627601906648383030875e6
             + z*(2.8620881062664720140395623211702e7
             + z*(-5.3267194552775163024727932383537e7
             + 2.2291753917536412639394745689815e7*z))
             + y*(5.1080183752801829559708169130444e6
             + y*(-4.250190851455026131106900641626e6
             + 1.3243010602578252108072488293078e6*y
             + 1.6078024602543684377542551769309e7*z)
             + z*(-3.6769743221469469489510357524594e7
             + 3.7398883314612483226022892159045e7*z)))))));
          case ( 161 ):
            return 61.335144900782618107089427524108
             + z*(-1840.0543470234785432126828257232
             + z*(12880.380429164349802488779780063
             + z*(-34347.681144438266139970079413501
             + (38641.141287493049407466339340188
             - 15456.456514997219762986535736075*z)*z)))
             + y*(-3066.7572450391309053544713762054
             + z*(90162.663004150448617421458460439
             + z*(-618258.26059988879051946142944301
             + z*(1.6143410137885985085785937324345e6
             + z*(-1.7774924992246802727434516096487e6
             + 695540.5431748748893343941081234*z))))
             + y*(36494.411215965657773718209376844
             + z*(-1.0046696734748192845941248228449e6
             + z*(6.4144294537238462016394123304712e6
             + z*(-1.5490804196141658029126505815489e7
             + (1.5649662221434685010023867432776e7
             - 5.564324345398999114675152864987e6*z)*z)))
             + y*(-180325.32600830089723484291692088
             + z*(4.4050901067742076324511626847815e6
             + z*(-2.4421201293695607225518726462999e7
             + z*(4.9632399253713294572256764752508e7
             + z*(-4.0186786938992771383764992913796e7
             + 1.0510390430198109438830844300531e7*z))))
             + y*(457253.50523533441798835168219223
             + y*(-651747.24971571610000593225687117
             + y*(530242.32766726573353578810094592
             + y*(-230620.14482694264408265624749065
             + 41707.898532532180312820810716394*y
             + 1.2512369559759654093846243214918e6*z)
             + z*(-5.6673673888323139130950631032276e6
             + 8.758658691831757865692370250443e6*z))
             + z*(1.023990244118565809297857992515e7
             + z*(-3.0912913029994439525973071472151e7
             + 2.335642317821802097517965400118e7*z)))
             + z*(-9.3125150502858249071993877809854e6
             + z*(4.0766404058305167124876988003899e7
             + z*(-5.9078011568433817760748536591221e7
             + 2.6275976075495273597077110751328e7*z)))))))
             + x*(-490.68115920626094485671542019287
             + z*(12880.380429164349802488779780063
             + z*(-77282.282574986098814932678680376
             + z*(171738.4057221913306998503970675
             + z*(-154564.56514997219762986535736075
             + 46369.369544991659288959607208226*z))))
             + x*(1717.384057221913306998503970675
             + z*(-38641.141287493049407466339340188
             + z*(193205.70643746524703733169670094
             + z*(-343476.81144438266139970079413501
             + (231846.84772495829644479803604113
             - 46369.369544991659288959607208226*z)*z)))
             + x*(-3434.7681144438266139970079413501
             + z*(64401.902145821749012443898900314
             + z*(-257607.60858328699604977559560125
             + z*(343476.81144438266139970079413501
             + z*(-154564.56514997219762986535736075
             + 15456.456514997219762986535736075*z))))
             + x*(4293.4601430547832674962599266876
             + z*(-64401.902145821749012443898900314
             + z*(193205.70643746524703733169670094
             + z*(-171738.4057221913306998503970675
             + 38641.141287493049407466339340188*z)))
             + x*(-3434.7681144438266139970079413501
             + z*(38641.141287493049407466339340188
             + z*(-77282.282574986098814932678680376
             + 34347.681144438266139970079413501*z))
             + x*(1717.384057221913306998503970675
             + x*(-490.68115920626094485671542019287
             + 61.33514490078261810708942752411*x
             + 3066.7572450391309053544713762054*y
             + 1840.0543470234785432126828257232*z)
             + z*(-12880.380429164349802488779780063
             + 12880.380429164349802488779780063*z)
             + y*(-21467.300715273916337481299633438
             + 36494.411215965657773718209376844*y
             + 90162.66300415044861742145846044*z))
             + y*(64401.902145821749012443898900314
             + z*(-540975.97802490269170452875076263
             + 618258.260599888790519461429443*z)
             + y*(-218966.46729579394664230925626107
             + 180325.32600830089723484291692088*y
             + 1.0046696734748192845941248228449e6*z)))
             + y*(-107336.50357636958168740649816719
             + z*(1.3524399450622567292613218769066e6
             + z*(-3.0912913029994439525973071472151e6
             + 1.6143410137885985085785937324345e6*z))
             + y*(547416.16823948486660577314065267
             + y*(-901626.63004150448617421458460439
             + 457253.50523533441798835168219223*y
             + 4.4050901067742076324511626847815e6*z)
             + z*(-5.0233483673740964229706241142245e6
             + 6.414429453723846201639412330471e6*z))))
             + y*(107336.50357636958168740649816719
             + z*(-1.8032532600830089723484291692088e6
             + z*(6.1825826059988879051946142944301e6
             + z*(-6.4573640551543940343143749297381e6
             + 1.7774924992246802727434516096487e6*z)))
             + y*(-729888.22431931315547436418753689
             + z*(1.0046696734748192845941248228449e7
             + z*(-2.5657717814895384806557649321885e7
             + 1.5490804196141658029126505815489e7*z))
             + y*(1.8032532600830089723484291692088e6
             + y*(-1.8290140209413376719534067287689e6
             + 651747.2497157161000059322568712*y
             + 9.312515050285824907199387780985e6*z)
             + z*(-1.7620360427096830529804650739126e7
             + 2.4421201293695607225518726462999e7*z)))))
             + y*(-64401.902145821749012443898900314
             + z*(1.3524399450622567292613218769066e6
             + z*(-6.1825826059988879051946142944301e6
             + z*(9.6860460827315910514715623946072e6
             + z*(-5.332477497674040818230354828946e6
             + 695540.5431748748893343941081234*z))))
             + y*(547416.16823948486660577314065267
             + z*(-1.0046696734748192845941248228449e7
             + z*(3.8486576722343077209836473982827e7
             + z*(-4.6472412588424974087379517446466e7
             + 1.5649662221434685010023867432776e7*z)))
             + y*(-1.8032532600830089723484291692088e6
             + y*(2.7435210314120065079301100931534e6
             + y*(-1.9552417491471483000177967706135e6
             + 530242.3276672657335357881009459*y
             + 1.023990244118565809297857992515e7*z)
             + z*(-2.7937545150857474721598163342956e7
             + 4.0766404058305167124876988003899e7*z))
             + z*(2.6430540640645245794706976108689e7
             + z*(-7.3263603881086821676556179388997e7
             + 4.9632399253713294572256764752508e7*z))))))
             + y*(21467.300715273916337481299633438
             + z*(-540975.97802490269170452875076263
             + z*(3.0912913029994439525973071472151e6
             + z*(-6.4573640551543940343143749297381e6
             + (5.332477497674040818230354828946e6
             - 1.3910810863497497786687882162468e6*z)*z)))
             + y*(-218966.46729579394664230925626107
             + z*(5.0233483673740964229706241142245e6
             + z*(-2.5657717814895384806557649321885e7
             + z*(4.6472412588424974087379517446466e7
             + z*(-3.1299324442869370020047734865552e7
             + 5.564324345398999114675152864987e6*z))))
             + y*(901626.63004150448617421458460439
             + z*(-1.7620360427096830529804650739126e7
             + z*(7.3263603881086821676556179388997e7
             + z*(-9.9264798507426589144513529505017e7
             + 4.0186786938992771383764992913796e7*z)))
             + y*(-1.8290140209413376719534067287689e6
             + y*(1.9552417491471483000177967706135e6
             + y*(-1.0604846553345314670715762018918e6
             + 230620.14482694264408265624749065*y
             + 5.667367388832313913095063103228e6*z)
             + z*(-2.04798048823713161859571598503e7
             + 3.0912913029994439525973071472151e7*z))
             + z*(2.7937545150857474721598163342956e7
             + z*(-8.1532808116610334249753976007797e7
             + 5.907801156843381776074853659122e7*z)))))));
          case ( 162 ):
            return 66.678332312678606764129079234039
             + z*(-2800.4899571325014840934213278296
             + z*(28004.899571325014840934213278296
             + z*(-112019.59828530005936373685311319
             + z*(210036.74678493761130700659958722
             + z*(-184832.33717074509795016580763676
             + 61610.77905691503265005526921225*z)))))
             + y*(-2533.7766278817870570369050108935
             + z*(103618.1284139025549114565891297
             + z*(-1.0081763845677005342736316780187e6
             + z*(3.9206859399855020777307898589615e6
             + z*(-7.1412493906878787844382243859656e6
             + (6.099467126634588232355471652013e6
             - 1.9715449298212810448017686147921e6*z)*z))))
             + y*(22870.667983248762120096274177275
             + z*(-856949.92688254545413258692631587
             + z*(7.56132288425775400705223758514e6
             + z*(-2.6324605597045513950478160481599e7
             + z*(4.2217386103772459872708326517032e7
             + z*(-3.1051832644685176455627855682975e7
             + 8.379065951740444440407516612866e6*z)))))
             + y*(-87748.685323485046501593868271995
             + z*(2.8284948567038264989343555411079e6
             + z*(-2.0723625682780510982291317825939e7
             + z*(5.6569897134076529978687110822159e7
             + z*(-6.3851171022621033837330006274516e7
             + 2.5137197855221333321222549838599e7*z))))
             + y*(179698.10558266884522932786853574
             + y*(-213770.73339444761328579782802433
             + y*(148892.71605421132890430023392961
             + y*(-56543.225801151458535981459190465
             + 9068.253194524290519921554775829*y
             + 380866.63417002020183670530058483*z)
             + z*(-1.9939488494783410566745159854147e6
             + 3.8086663417002020183670530058483e6*z))
             + z*(4.2595452247985347573060938396289e6
             + z*(-1.6130822153083208548378106848299e7
             + 1.5234665366800808073468212023393e7*z)))
             + z*(-4.7188255777682650006974149373929e6
             + z*(2.646463009490213902468283154799e7
             + z*(-4.9288623245532026120044215369802e7
             + 2.8564997562751515137752897543862e7*z)))))))
             + x*(-533.42665850142885411303263387231
             + z*(19603.429699927510388653949294808
             + z*(-168029.39742795008904560527966978
             + z*(560097.99142650029681868426556593
             + z*(-840146.98713975044522802639834889
             + (554497.01151223529385049742291027
             - 123221.5581138300653001105384245*z)*z))))
             + x*(1866.9933047550009893956142185531
             + z*(-58810.289099782531165961847884423
             + z*(420073.49356987522261401319917445
             + z*(-1.1201959828530005936373685311319e6
             + z*(1.2602204807096256678420395975233e6
             + z*(-554497.01151223529385049742291027
             + 61610.77905691503265005526921225*z)))))
             + x*(-3733.9866095100019787912284371062
             + z*(98017.148499637551943269746474038
             + z*(-560097.99142650029681868426556593
             + z*(1.1201959828530005936373685311319e6
             + z*(-840146.98713975044522802639834889
             + 184832.33717074509795016580763676*z))))
             + x*(4667.4832618875024734890355463827
             + z*(-98017.148499637551943269746474038
             + z*(420073.49356987522261401319917445
             + z*(-560097.99142650029681868426556593
             + 210036.74678493761130700659958722*z)))
             + x*(-3733.9866095100019787912284371062
             + x*(1866.9933047550009893956142185531
             + x*(-533.42665850142885411303263387231
             + 66.67833231267860676412907923404*x
             + 2533.7766278817870570369050108935*y
             + 2800.4899571325014840934213278296*z)
             + z*(-19603.429699927510388653949294808
             + 28004.899571325014840934213278296*z)
             + y*(-17736.436395172509399258335076254
             + 22870.667983248762120096274177275*y
             + 103618.1284139025549114565891297*z))
             + z*(58810.289099782531165961847884423
             + z*(-168029.39742795008904560527966978
             + 112019.59828530005936373685311319*z))
             + y*(53209.309185517528197775005228763
             + y*(-137224.00789949257272057764506365
             + 87748.685323485046501593868272*y
             + 856949.9268825454541325869263159*z)
             + z*(-621708.77048341532946873953477818
             + 1.0081763845677005342736316780187e6*z)))
             + y*(-88682.181975862546996291675381272
             + z*(1.5542719262085383236718488369455e6
             + z*(-5.0408819228385026713681583900934e6
             + 3.9206859399855020777307898589615e6*z))
             + y*(343060.01974873143180144411265913
             + y*(-438743.42661742523250796934135998
             + 179698.10558266884522932786853574*y
             + 2.8284948567038264989343555411079e6*z)
             + z*(-4.2847496344127272706629346315794e6
             + 7.56132288425775400705223758514e6*z))))
             + y*(88682.181975862546996291675381272
             + z*(-2.0723625682780510982291317825939e6
             + z*(1.0081763845677005342736316780187e7
             + z*(-1.5682743759942008310923159435846e7
             + 7.141249390687878784438224385966e6*z)))
             + y*(-457413.35966497524240192548354551
             + y*(877486.85323485046501593868271995
             + y*(-718792.42233067538091731147414294
             + 213770.73339444761328579782802433*y
             + 4.7188255777682650006974149373929e6*z)
             + z*(-1.1313979426815305995737422164432e7
             + 2.0723625682780510982291317825939e7*z))
             + z*(8.5694992688254545413258692631587e6
             + z*(-3.024529153703101602820895034056e7
             + 2.6324605597045513950478160481599e7*z)))))
             + y*(-53209.309185517528197775005228763
             + z*(1.5542719262085383236718488369455e6
             + z*(-1.0081763845677005342736316780187e7
             + z*(2.3524115639913012466384739153769e7
             + z*(-2.1423748172063636353314673157897e7
             + 6.099467126634588232355471652013e6*z))))
             + y*(343060.01974873143180144411265913
             + z*(-8.5694992688254545413258692631587e6
             + z*(4.536793730554652404231342551084e7
             + z*(-7.8973816791136541851434481444796e7
             + 4.2217386103772459872708326517032e7*z)))
             + y*(-877486.85323485046501593868271995
             + y*(1.0781886334960130713759672112144e6
             + y*(-641312.20018334283985739348407299
             + 148892.71605421132890430023392961*y
             + 4.2595452247985347573060938396289e6*z)
             + z*(-1.4156476733304795002092244812179e7
             + 2.646463009490213902468283154799e7*z))
             + z*(1.6970969140222958993606133246648e7
             + z*(-6.2170877048341532946873953477818e7
             + 5.656989713407652997868711082216e7*z))))))
             + y*(17736.436395172509399258335076254
             + z*(-621708.77048341532946873953477818
             + z*(5.0408819228385026713681583900934e6
             + z*(-1.5682743759942008310923159435846e7
             + z*(2.1423748172063636353314673157897e7
             + z*(-1.2198934253269176464710943304026e7
             + 1.9715449298212810448017686147921e6*z)))))
             + y*(-137224.00789949257272057764506365
             + z*(4.2847496344127272706629346315794e6
             + z*(-3.024529153703101602820895034056e7
             + z*(7.8973816791136541851434481444796e7
             + z*(-8.4434772207544919745416653034064e7
             + 3.1051832644685176455627855682975e7*z))))
             + y*(438743.42661742523250796934135998
             + y*(-718792.42233067538091731147414294
             + y*(641312.20018334283985739348407299
             + y*(-297785.43210842265780860046785922
             + 56543.22580115145853598145919047*y
             + 1.9939488494783410566745159854147e6*z)
             + z*(-8.5190904495970695146121876792578e6
             + 1.6130822153083208548378106848299e7*z))
             + z*(1.4156476733304795002092244812179e7
             + z*(-5.292926018980427804936566309598e7
             + 4.9288623245532026120044215369802e7*z)))
             + z*(-1.1313979426815305995737422164432e7
             + z*(6.2170877048341532946873953477818e7
             + z*(-1.1313979426815305995737422164432e8
             + 6.385117102262103383733000627452e7*z)))))));
          case ( 163 ):
            return 71.624018317879931693809393842852
             + z*(-4010.9450258012761748533260551997
             + z*(54147.757848317228360519901745196
             + z*(-300820.87693509571311399945413998
             + z*(827257.41157151321106349849888494
             + z*(-1.1912506726629790239314378383943e6
             + (860347.70803437373950603843884034
             - 245813.63086696392557315383966867*z)*z)))))
             + y*(-1718.9764396291183606514254522285
             + z*(92251.735593429352021626499269594
             + z*(-1.1912506726629790239314378383943e6
             + z*(6.3172384156370099753939885369396e6
             + z*(-1.6545148231430264221269969977699e7
             + z*(2.2633762780596601454697318929492e7
             + z*(-1.5486258744618727311108691899126e7
             + 4.1788317247383867347436152743674e6*z))))))
             + y*(10027.362564503190437133315137999
             + z*(-469280.56801874931245783914845837
             + z*(5.1440369955901366942493906657936e6
             + z*(-2.2260744893197082770435959606358e7
             + z*(4.4671900224861713397428918939787e7
             + z*(-4.1693773543204265837600324343801e7
             + 1.4625911036584353571602653460286e7*z)))))
             + y*(-28076.615180608933223973282386398
             + y*(45123.131540264356967099918120997
             + y*(-44120.395283814037923386586607197
             + y*(26071.142667708295136546619358798
             + y*(-8594.8821981455918032571272611423
             + 1217.6083114039588387947596953285*y
             + 68186.0654386216949725065429384*z)
             + z*(-413127.33765753144600989258368557
             + 920511.8834213928821288383296683*z))
             + z*(1.0468566517341330816367181004071e6
             + z*(-4.6567071749552816390047115500869e6
             + 5.11395490789662712293799072038e6*z)))
             + z*(-1.4238854841594530420729307495959e6
             + z*(9.4758576234555149630909828054093e6
             + z*(-2.0756640508521604204865962335659e7
             + 1.4063375996715724588079474481044e7*z))))
             + z*(1.1030098820953509480846646651799e6
             + z*(-9.7465964126971011048935823141353e6
             + z*(3.1887012955120145590083942138838e7
             + z*(-4.3017385401718686975301921942017e7
             + 2.0251261435270643406834443252703e7*z)))))))
             + x*(-572.99214654303945355047515074282
             + z*(28076.615180608933223973282386398
             + z*(-324886.54708990337016311941047118
             + z*(1.5041043846754785655699972706999e6
             + z*(-3.3090296462860528442539939955398e6
             + z*(3.573752017988937071794313515183e6
             + z*(-1.7206954160687474790120768776807e6
             + 245813.63086696392557315383966867*z))))))
             + y*(12032.835077403828524559978165599
             + z*(-553510.41356057611212975899561756
             + z*(5.9562533633148951196571891919716e6
             + z*(-2.5268953662548039901575954147758e7
             + z*(4.9635444694290792663809909933097e7
             + z*(-4.5267525561193202909394637858984e7
             + 1.5486258744618727311108691899126e7*z)))))
             + y*(-60164.175387019142622799890827996
             + z*(2.3464028400937465622891957422918e6
             + z*(-2.0576147982360546776997562663175e7
             + z*(6.6782234679591248311307878819075e7
             + z*(-8.9343800449723426794857837879574e7
             + 4.1693773543204265837600324343801e7*z))))
             + y*(140383.07590304466611986641193199
             + y*(-180492.52616105742786839967248399
             + y*(132361.18585144211377015975982159
             + y*(-52142.285335416590273093238717596
             + 8594.882198145591803257127261142*y
             + 413127.33765753144600989258368557*z)
             + z*(-2.0937133034682661632734362008143e6
             + 4.6567071749552816390047115500869e6*z))
             + z*(4.2716564524783591262187922487877e6
             + z*(-1.8951715246911029926181965610819e7
             + 2.0756640508521604204865962335659e7*z)))
             + z*(-4.4120395283814037923386586607197e6
             + z*(2.9239789238091303314680746942406e7
             + z*(-6.3774025910240291180167884277676e7
             + 4.3017385401718686975301921942017e7*z))))))
             + x*(2005.4725129006380874266630275999
             + z*(-84229.845541826799671919847159194
             + z*(812216.36772475842540779852617794
             + z*(-3.0082087693509571311399945413998e6
             + z*(4.9635444694290792663809909933097e6
             + z*(-3.573752017988937071794313515183e6
             + 860347.7080343737395060384388403*z)))))
             + x*(-4010.9450258012761748533260551997
             + z*(140383.07590304466611986641193199
             + z*(-1.0829551569663445672103980349039e6
             + z*(3.0082087693509571311399945413998e6
             + z*(-3.3090296462860528442539939955398e6
             + 1.1912506726629790239314378383943e6*z))))
             + x*(5013.6812822515952185666575689997
             + z*(-140383.07590304466611986641193199
             + z*(812216.36772475842540779852617794
             + z*(-1.5041043846754785655699972706999e6
             + 827257.4115715132110634984988849*z)))
             + x*(-4010.9450258012761748533260551997
             + x*(2005.4725129006380874266630275999
             + x*(-572.99214654303945355047515074282
             + 71.62401831787993169380939384285*x
             + 1718.9764396291183606514254522285*y
             + 4010.9450258012761748533260551997*z)
             + z*(-28076.615180608933223973282386398
             + 54147.7578483172283605199017452*z)
             + y*(-12032.835077403828524559978165599
             + 10027.362564503190437133315137999*y
             + 92251.73559342935202162649926959*z))
             + z*(84229.845541826799671919847159194
             + z*(-324886.54708990337016311941047118
             + 300820.87693509571311399945413998*z))
             + y*(36098.505232211485573679934496798
             + y*(-60164.175387019142622799890827996
             + 28076.615180608933223973282386398*y
             + 469280.56801874931245783914845837*z)
             + z*(-553510.41356057611212975899561756
             + 1.1912506726629790239314378383943e6*z)))
             + y*(-60164.175387019142622799890827996
             + y*(150410.43846754785655699972706999
             + y*(-140383.07590304466611986641193199
             + 45123.131540264356967099918120997*y
             + 1.1030098820953509480846646651799e6*z)
             + z*(-2.3464028400937465622891957422918e6
             + 5.144036995590136694249390665794e6*z))
             + z*(1.3837760339014402803243974890439e6
             + z*(-5.9562533633148951196571891919716e6
             + 6.31723841563700997539398853694e6*z))))
             + y*(60164.175387019142622799890827996
             + z*(-1.8450347118685870404325299853919e6
             + z*(1.1912506726629790239314378383943e7
             + z*(-2.5268953662548039901575954147758e7
             + 1.6545148231430264221269969977699e7*z)))
             + y*(-200547.25129006380874266630275999
             + y*(280766.15180608933223973282386398
             + y*(-180492.52616105742786839967248399
             + 44120.395283814037923386586607197*y
             + 1.4238854841594530420729307495959e6*z)
             + z*(-4.4120395283814037923386586607197e6
             + 9.746596412697101104893582314135e6*z))
             + z*(4.6928056801874931245783914845837e6
             + z*(-2.0576147982360546776997562663175e7
             + 2.2260744893197082770435959606358e7*z)))))
             + y*(-36098.505232211485573679934496798
             + z*(1.3837760339014402803243974890439e6
             + z*(-1.1912506726629790239314378383943e7
             + z*(3.7903430493822059852363931221637e7
             + z*(-4.9635444694290792663809909933097e7
             + 2.2633762780596601454697318929492e7*z))))
             + y*(150410.43846754785655699972706999
             + y*(-280766.15180608933223973282386398
             + y*(270738.78924158614180259950872598
             + y*(-132361.18585144211377015975982159
             + 26071.142667708295136546619358798*y
             + 1.0468566517341330816367181004071e6*z)
             + z*(-4.2716564524783591262187922487877e6
             + 9.475857623455514963090982805409e6*z))
             + z*(6.6180592925721056885079879910795e6
             + z*(-2.9239789238091303314680746942406e7
             + 3.1887012955120145590083942138838e7*z)))
             + z*(-4.6928056801874931245783914845837e6
             + z*(3.0864221973540820165496343994762e7
             + z*(-6.6782234679591248311307878819075e7
             + 4.4671900224861713397428918939787e7*z)))))));
          case ( 164 ):
            return 76.249590162833006534759150723637
             + z*(-5489.9704917239764705026588521019
             + z*(96074.483605169588233796529911783
             + z*(-704546.21310457698038117455268641
             + z*(2.642048299142163676429404572574e6
             + z*(-5.495460462215700446973161510954e6
             + z*(6.4113705392516505214686884294463e6
             + z*(-3.9253289015826431764094010792528e6
             + 981332.2253956607941023502698132*z)))))))
             + y*(-609.9967213026640522780732057891
             + z*(38429.793442067835293518611964713
             + z*(-576446.9016310175294027791794707
             + z*(3.522731065522884901905872763432e6
             + z*(-1.0568193196568654705717618290296e7
             + z*(1.6486381386647101340919484532862e7
             + z*(-1.2822741078503301042937376858893e7
             + 3.9253289015826431764094010792528e6*z))))))
             + y*(2134.9885245593241829732562202618
             + y*(-4269.9770491186483659465124405237
             + y*(5337.4713113983104574331405506546
             + y*(-4269.9770491186483659465124405237
             + y*(2134.9885245593241829732562202618
             + y*(-609.9967213026640522780732057891
             + 76.24959016283300653475915072364*y
             + 5489.970491723976470502658852102*z)
             + z*(-38429.793442067835293518611964713
             + 96074.48360516958823379652991178*z))
             + z*(115289.38032620350588055583589414
             + z*(-576446.9016310175294027791794707
             + 704546.2131045769803811745526864*z)))
             + z*(-192148.96721033917646759305982357
             + z*(1.4411172540775438235069479486767e6
             + z*(-3.522731065522884901905872763432e6
             + 2.642048299142163676429404572574e6*z))))
             + z*(192148.96721033917646759305982357
             + z*(-1.9214896721033917646759305982357e6
             + z*(7.0454621310457698038117455268641e6
             + z*(-1.0568193196568654705717618290296e7
             + 5.495460462215700446973161510954e6*z)))))
             + z*(-115289.38032620350588055583589414
             + z*(1.4411172540775438235069479486767e6
             + z*(-7.0454621310457698038117455268641e6
             + z*(1.5852289794852982058576427435444e7
             + z*(-1.6486381386647101340919484532862e7
             + 6.411370539251650521468688429446e6*z)))))))
             + x*(-609.9967213026640522780732057891
             + z*(38429.793442067835293518611964713
             + z*(-576446.9016310175294027791794707
             + z*(3.522731065522884901905872763432e6
             + z*(-1.0568193196568654705717618290296e7
             + z*(1.6486381386647101340919484532862e7
             + z*(-1.2822741078503301042937376858893e7
             + 3.9253289015826431764094010792528e6*z))))))
             + y*(4269.9770491186483659465124405237
             + z*(-230578.76065240701176111167178828
             + z*(2.8822345081550876470138958973535e6
             + z*(-1.4090924262091539607623491053728e7
             + z*(3.1704579589705964117152854870888e7
             + z*(-3.2972762773294202681838969065724e7
             + 1.2822741078503301042937376858893e7*z)))))
             + y*(-12809.931147355945097839537321571
             + y*(21349.885245593241829732562202618
             + y*(-21349.885245593241829732562202618
             + y*(12809.931147355945097839537321571
             + y*(-4269.9770491186483659465124405237
             + 609.9967213026640522780732057891*y
             + 38429.793442067835293518611964713*z)
             + z*(-230578.76065240701176111167178828
             + 576446.9016310175294027791794707*z))
             + z*(576446.9016310175294027791794707
             + z*(-2.8822345081550876470138958973535e6
             + 3.522731065522884901905872763432e6*z)))
             + z*(-768595.86884135670587037223929426
             + z*(5.764469016310175294027791794707e6
             + z*(-1.4090924262091539607623491053728e7
             + 1.0568193196568654705717618290296e7*z))))
             + z*(576446.9016310175294027791794707
             + z*(-5.764469016310175294027791794707e6
             + z*(2.1136386393137309411435236580592e7
             + z*(-3.1704579589705964117152854870888e7
             + 1.6486381386647101340919484532862e7*z))))))
             + x*(2134.9885245593241829732562202618
             + z*(-115289.38032620350588055583589414
             + z*(1.4411172540775438235069479486767e6
             + z*(-7.0454621310457698038117455268641e6
             + z*(1.5852289794852982058576427435444e7
             + z*(-1.6486381386647101340919484532862e7
             + 6.411370539251650521468688429446e6*z)))))
             + x*(-4269.9770491186483659465124405237
             + x*(5337.4713113983104574331405506546
             + x*(-4269.9770491186483659465124405237
             + x*(2134.9885245593241829732562202618
             + x*(-609.9967213026640522780732057891
             + 76.24959016283300653475915072364*x
             + 609.9967213026640522780732057891*y
             + 5489.970491723976470502658852102*z)
             + y*(-4269.9770491186483659465124405237
             + 2134.9885245593241829732562202618*y
             + 38429.793442067835293518611964713*z)
             + z*(-38429.793442067835293518611964713
             + 96074.48360516958823379652991178*z))
             + y*(12809.931147355945097839537321571
             + y*(-12809.931147355945097839537321571
             + 4269.9770491186483659465124405237*y
             + 115289.38032620350588055583589414*z)
             + z*(-230578.76065240701176111167178828
             + 576446.9016310175294027791794707*z))
             + z*(115289.38032620350588055583589414
             + z*(-576446.9016310175294027791794707
             + 704546.2131045769803811745526864*z)))
             + z*(-192148.96721033917646759305982357
             + z*(1.4411172540775438235069479486767e6
             + z*(-3.522731065522884901905872763432e6
             + 2.642048299142163676429404572574e6*z)))
             + y*(-21349.885245593241829732562202618
             + y*(32024.827868389862744598843303928
             + y*(-21349.885245593241829732562202618
             + 5337.471311398310457433140550655*y
             + 192148.96721033917646759305982357*z)
             + z*(-576446.9016310175294027791794707
             + 1.4411172540775438235069479486767e6*z))
             + z*(576446.9016310175294027791794707
             + z*(-2.8822345081550876470138958973535e6
             + 3.522731065522884901905872763432e6*z))))
             + z*(192148.96721033917646759305982357
             + z*(-1.9214896721033917646759305982357e6
             + z*(7.0454621310457698038117455268641e6
             + z*(-1.0568193196568654705717618290296e7
             + 5.495460462215700446973161510954e6*z))))
             + y*(21349.885245593241829732562202618
             + y*(-42699.770491186483659465124405237
             + y*(42699.770491186483659465124405237
             + y*(-21349.885245593241829732562202618
             + 4269.9770491186483659465124405237*y
             + 192148.96721033917646759305982357*z)
             + z*(-768595.86884135670587037223929426
             + 1.9214896721033917646759305982357e6*z))
             + z*(1.1528938032620350588055583589414e6
             + z*(-5.764469016310175294027791794707e6
             + 7.045462131045769803811745526864e6*z)))
             + z*(-768595.86884135670587037223929426
             + z*(5.764469016310175294027791794707e6
             + z*(-1.4090924262091539607623491053728e7
             + 1.0568193196568654705717618290296e7*z)))))
             + y*(-12809.931147355945097839537321571
             + y*(32024.827868389862744598843303928
             + y*(-42699.770491186483659465124405237
             + y*(32024.827868389862744598843303928
             + y*(-12809.931147355945097839537321571
             + 2134.9885245593241829732562202618*y
             + 115289.38032620350588055583589414*z)
             + z*(-576446.9016310175294027791794707
             + 1.4411172540775438235069479486767e6*z))
             + z*(1.1528938032620350588055583589414e6
             + z*(-5.764469016310175294027791794707e6
             + 7.045462131045769803811745526864e6*z)))
             + z*(-1.1528938032620350588055583589414e6
             + z*(8.6467035244652629410416876920605e6
             + z*(-2.1136386393137309411435236580592e7
             + 1.5852289794852982058576427435444e7*z))))
             + z*(576446.9016310175294027791794707
             + z*(-5.764469016310175294027791794707e6
             + z*(2.1136386393137309411435236580592e7
             + z*(-3.1704579589705964117152854870888e7
             + 1.6486381386647101340919484532862e7*z)))))));
          #endif
        }

          printf("Error in eval_tetrahedron_3d -- unmatched switch/case %d\n",i);
          return -123456789.0;
      }


      /* \nabla\phi_i(x,y,z) for tetrahedron */
      static void
      grad_tetrahedron_3d ( const int i, DomainType xi, JacobianRangeType grad )
      {
        const RangeField &x = xi[0];
        const RangeField &y = xi[1];
        const RangeField &z = xi[2];

        switch (i)	{
          #if (PMAX3D>=0)
          case ( 0 ):
            grad[0]= 0;
            grad[1]= 0;
            grad[2]= 0;
            return;
          #endif
          #if (PMAX3D>=1)
          case ( 1 ):
            grad[0]= 12.649110640673517327995574177731;
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 2 ):
            grad[0]= 4.4721359549995793928183473374626;
            grad[1]= 13.416407864998738178455042012388;
            grad[2]= 0;
            return;
          case ( 3 ):
            grad[0]= 7.7459666924148337703585307995648;
            grad[1]= 7.7459666924148337703585307995648;
            grad[2]= 15.49193338482966754071706159913;
            return;
          #endif
          #if (PMAX3D>=2)
          case ( 4 ):
            grad[0]= -37.416573867739413855837487323165
             + 112.2497216032182415675124619695*x;
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 5 ):
            grad[0]= -37.04051835490426826702262055095
             + 63.49803146555017417203877808734*x
             + 95.24704719832526125805816713101*y;
            grad[1]= -15.874507866387543543009694521836
             + 95.24704719832526125805816713101*x;
            grad[2]= 0;
            return;
          case ( 6 ):
            grad[0]= -64.156059729381760092232660712192
             + 109.98181667894016015811313264947*x
             + 54.99090833947008007905656632474*y
             + 109.98181667894016015811313264947*z;
            grad[1]= -9.165151389911680013176094387456
             + 54.99090833947008007905656632474*x;
            grad[2]= -18.330302779823360026352188774912
             + 109.98181667894016015811313264947*x;
            return;
          case ( 7 ):
            grad[0]= -12.961481396815720461931934872176
             + 12.961481396815720461931934872176*x
             + 51.8459255872628818477277394887*y;
            grad[1]= -51.845925587262881847727739488704
             + 51.8459255872628818477277394887*x
             + 129.61481396815720461931934872176*y;
            grad[2]= 0;
            return;
          case ( 8 ):
            grad[0]= -22.449944320643648313502492393899
             + 22.449944320643648313502492393899*x
             + 67.3498329619309449405074771817*y
             + 22.449944320643648313502492393899*z;
            grad[1]= -67.349832961930944940507477181698
             + 67.3498329619309449405074771817*x
             + 112.2497216032182415675124619695*y
             + 112.2497216032182415675124619695*z;
            grad[2]= -22.449944320643648313502492393899
             + 22.449944320643648313502492393899*x
             + 112.2497216032182415675124619695*y;
            return;
          case ( 9 ):
            grad[0]= -28.98275349237887714743732831434
             + 28.98275349237887714743732831434*x
             + 28.98275349237887714743732831434*y
             + 86.94826047713663144231198494302*z;
            grad[1]= -28.98275349237887714743732831434
             + 28.98275349237887714743732831434*x
             + 28.98275349237887714743732831434*y
             + 86.94826047713663144231198494302*z;
            grad[2]= -86.948260477136631442311984943019
             + 86.94826047713663144231198494302*x
             + 86.94826047713663144231198494302*y
             + 173.89652095427326288462396988604*z;
             return;
          #endif
          #if (PMAX3D>=3)
          case ( 10 ):
            grad[0]= 76.367532368147132635291191107324
             + x*(-534.57272657702992844703833775127
             + 712.7636354360399045960511170017*x);
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 11 ):
            grad[0]= 90.
             - 252.*y
             + x*(-504.
             + 504.*x
             + 1008.*y);
            grad[1]= 18.
             + x*(-252.
             + 504.*x);
            grad[2]= 0;
            return;
          case ( 12 ):
            grad[0]= 155.88457268119895641747017073553
             - 145.49226783578569265630549268649*y
             - 290.98453567157138531261098537299*z
             + x*(-872.95360701471415593783295611896
             + 872.953607014714155937832956119*x
             + 581.969071343142770625221970746*y
             + 1163.9381426862855412504439414919*z);
            grad[1]= 10.392304845413263761164678049035
             + x*(-145.49226783578569265630549268649
             + 290.98453567157138531261098537299*x);
            grad[2]= 20.78460969082652752232935609807
             + x*(-290.98453567157138531261098537299
             + 581.969071343142770625221970746*x);
            return;
          case ( 13 ):
            grad[0]= 73.484692283495342945918522241177
             + y*(-529.08978444116646921061336013647
             + 587.8775382679627435673481779294*y)
             + x*(-249.84795376388416601612297562
             + 176.36326148038882307020445337882*x
             + 940.6040612287403897077570846871*y);
            grad[1]= 58.787753826796274356734817792941
             - 146.96938456699068589183704448235*y
             + x*(-529.08978444116646921061336013647
             + 470.30203061437019485387854234353*x
             + 1175.7550765359254871346963558588*y);
            grad[2]= 0;
            return;
          case ( 14 ):
            grad[0]= 127.27922061357855439215198517887
             - 229.10259710444139790587357332197*z
             + x*(-432.74935008616708493331674960817
             + 305.47012947258853054116476442929*x
             + 1221.8805178903541221646590577172*y
             + 407.29350596345137405488635257239*z)
             + y*(-687.30779131332419371762071996591
             + 509.1168824543142175686079407155*y
             + 1018.233764908628435137215881431*z);
            grad[1]= 76.367532368147132635291191107324
             - 127.27922061357855439215198517887*y
             - 127.27922061357855439215198517887*z
             + x*(-687.30779131332419371762071996591
             + 610.9402589451770610823295288586*x
             + 1018.233764908628435137215881431*y
             + 1018.233764908628435137215881431*z);
            grad[2]= 25.455844122715710878430397035775
             - 127.27922061357855439215198517887*y
             + x*(-229.10259710444139790587357332197
             + 203.6467529817256870274431762862*x
             + 1018.233764908628435137215881431*y);
            return;
          case ( 15 ):
            grad[0]= 164.31676725154983403709093484024
             + z*(-887.3105431583691038002910481373
             + 788.7204828074392033780364872332*z)
             + y*(-295.77018105278970126676368271243
             + 131.45341380123986722967274787219*y
             + 788.7204828074392033780364872332*z)
             + x*(-558.67700865526943572610917845682
             + 394.36024140371960168901824361658*x
             + 525.8136552049594689186909914888*y
             + 1577.4409656148784067560729744663*z);
            grad[1]= 32.863353450309966807418186968048
             - 32.863353450309966807418186968048*y
             - 98.59006035092990042225456090414*z
             + x*(-295.77018105278970126676368271243
             + 262.90682760247973445934549574439*x
             + 262.90682760247973445934549574439*y
             + 788.7204828074392033780364872332*z);
            grad[2]= 98.590060350929900422254560904144
             - 98.59006035092990042225456090414*y
             - 197.18012070185980084450912180829*z
             + x*(-887.3105431583691038002910481373
             + 788.7204828074392033780364872332*x
             + 788.7204828074392033780364872332*y
             + 1577.4409656148784067560729744663*z);
            return;
          case ( 16 ):
            grad[0]= 25.455844122715710878430397035775
             + x*(-50.911688245431421756860794071549
             + 25.455844122715710878430397035775*x
             + 254.55844122715710878430397035775*y)
             + y*(-254.55844122715710878430397035775
             + 381.83766184073566317645595553662*y);
            grad[1]= 127.27922061357855439215198517887
             + x*(-254.55844122715710878430397035775
             + 127.27922061357855439215198517887*x
             + 763.6753236814713263529119110732*y)
             + y*(-763.67532368147132635291191107324
             + 890.9545442950498807450638962521*y);
            grad[2]= 0;
            return;
          case ( 17 ):
            grad[0]= 44.090815370097205767551113344706
             - 58.78775382679627435673481779294*z
             + x*(-88.181630740194411535102226689412
             + 44.090815370097205767551113344706*x
             + 382.12039987417578331877631565412*y
             + 58.78775382679627435673481779294*z)
             + y*(-382.12039987417578331877631565412
             + 484.99896907106926344306224679177*y
             + 352.72652296077764614040890675765*z);
            grad[1]= 191.06019993708789165938815782706
             - 352.72652296077764614040890675765*z
             + x*(-382.12039987417578331877631565412
             + 191.06019993708789165938815782706*x
             + 969.9979381421385268861244935835*y
             + 352.72652296077764614040890675765*z)
             + y*(-969.99793814213852688612449358353
             + 925.9071227720413211185733802388*y
             + 1234.5428303627217614914311736518*z);
            grad[2]= 29.393876913398137178367408896471
             + x*(-58.787753826796274356734817792941
             + 29.393876913398137178367408896471*x
             + 352.72652296077764614040890675765*y)
             + y*(-352.72652296077764614040890675765
             + 617.2714151813608807457155868259*y);
            return;
          case ( 18 ):
            grad[0]= 56.920997883030827975980083799789
             + z*(-227.68399153212331190392033519916
             + 113.84199576606165595196016759958*z)
             + x*(-113.84199576606165595196016759958
             + 56.92099788303082797598008379979*x
             + 341.52598729818496785588050279873*y
             + 227.68399153212331190392033519916*z)
             + y*(-341.52598729818496785588050279873
             + 284.60498941515413987990041899894*y
             + 910.7359661284932476156813407966*z);
            grad[1]= 170.76299364909248392794025139937
             + z*(-910.73596612849324761568134079662
             + 796.893970362431591663721173197*z)
             + x*(-341.52598729818496785588050279873
             + 170.76299364909248392794025139937*x
             + 569.2099788303082797598008379979*y
             + 910.7359661284932476156813407966*z)
             + y*(-569.20997883030827975980083799789
             + 398.44698518121579583186058659852*y
             + 1593.7879407248631833274423463941*z);
            grad[2]= 113.84199576606165595196016759958
             - 227.68399153212331190392033519916*z
             + x*(-227.68399153212331190392033519916
             + 113.84199576606165595196016759958*x
             + 910.7359661284932476156813407966*y
             + 227.68399153212331190392033519916*z)
             + y*(-910.73596612849324761568134079662
             + 796.893970362431591663721173197*y
             + 1593.7879407248631833274423463941*z);
            return;
          case ( 19 ):
            grad[0]= 67.349832961930944940507477181698
             + y*(-134.6996659238618898810149543634
             + 67.3498329619309449405074771817*y
             + 538.7986636954475595240598174536*z)
             + x*(-134.6996659238618898810149543634
             + 67.3498329619309449405074771817*x
             + 134.6996659238618898810149543634*y
             + 538.7986636954475595240598174536*z)
             + z*(-538.79866369544755952405981745358
             + 673.498329619309449405074771817*z);
            grad[1]= 67.349832961930944940507477181698
             + y*(-134.6996659238618898810149543634
             + 67.3498329619309449405074771817*y
             + 538.7986636954475595240598174536*z)
             + x*(-134.6996659238618898810149543634
             + 67.3498329619309449405074771817*x
             + 134.6996659238618898810149543634*y
             + 538.7986636954475595240598174536*z)
             + z*(-538.79866369544755952405981745358
             + 673.498329619309449405074771817*z);
            grad[2]= 269.39933184772377976202990872679
             + z*(-1346.996659238618898810149543634
             + 1346.996659238618898810149543634*z)
             + y*(-538.79866369544755952405981745358
             + 269.39933184772377976202990872679*y
             + 1346.996659238618898810149543634*z)
             + x*(-538.79866369544755952405981745358
             + 269.39933184772377976202990872679*x
             + 538.7986636954475595240598174536*y
             + 1346.996659238618898810149543634*z);
             return;
          #endif
          #if (PMAX3D>=4)
          case ( 20 ):
            grad[0]= -131.33164127505602752783764317925
             + x*(1575.9796953006723303340517181509
             + x*(-4727.9390859020169910021551544528
             + 3939.9492382516808258351292953774*x));
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 21 ):
            grad[0]= -165.83123951776999245574663683353
             + 477.59396981117757827255031408058*y
             + x*(1751.1778893076511203326844849621
             - 4298.3457283005982044529528267252*y
             + x*(-4537.1427132061869935892279837655
             + 3183.9597987411838551503354272039*x
             + 7163.909547167663674088254711209*y));
            grad[1]= -19.899748742132399094689596420024
             + x*(477.59396981117757827255031408058
             + x*(-2149.1728641502991022264764133626
             + 2387.9698490558878913627515704029*x));
            grad[2]= 0;
            return;
          case ( 22 ):
            grad[0]= -287.22813232690143299253057341095
             + 275.73900703382537567282935047451*y
             + 551.478014067650751345658700949*z
             + x*(3033.1290773720791324011228552196
             - 2481.6510633044283810554641542706*y
             - 4963.3021266088567621109283085412*z
             + x*(-7858.5617004640232066756364885235
             + 5514.78014067650751345658700949*x
             + 4136.0851055073806350924402571176*y
             + 8272.170211014761270184880514235*z));
            grad[1]= -11.489125293076057319701222936438
             + x*(275.73900703382537567282935047451
             + x*(-1240.8255316522141905277320771353
             + 1378.6950351691268783641467523725*x));
            grad[2]= -22.978250586152114639402445872876
             + x*(551.47801406765075134565870094902
             + x*(-2481.6510633044283810554641542706
             + 2757.3900703382537567282935047451*x));
            return;
          case ( 23 ):
            grad[0]= -162.48076809271920720919767136532
             + (1234.8538375046659747899023023764
             - 1462.3269128344728648827790422879*y)*y
             + x*(1332.3422983602974991154209051956
             + y*(-8189.0307118730480433435626368122
             + 7311.634564172364324413895211439*y)
             + x*(-2632.1884431020511567890022761182
             + 1462.3269128344728648827790422879*x
             + 8773.961477006837189296674253727*y));
            grad[1]= -64.992307237087682883679068546128
             + 162.48076809271920720919767136532*y
             + x*(1234.8538375046659747899023023764
             - 2924.6538256689457297655580845758*y
             + x*(-4094.5153559365240216717813184061
             + 2924.6538256689457297655580845758*x
             + 7311.634564172364324413895211439*y));
            grad[2]= 0;
            return;
          case ( 24 ):
            grad[0]= -281.42494558940577327393780681267
             + y*(1604.1221898596129076614454988322
             - 1266.412255152325979732720130657*y
             - 2532.824510304651959465440261314*z)
             + 534.7073966198709692204818329441*z
             + x*(2307.6845538331273408462900158639
             - 3545.9543144265127432516163658396*z
             + x*(-4559.0841185483735270377924703652
             + 2532.824510304651959465440261314*x
             + 11397.710296370933817594481175913*y
             + 3799.236765456977939198160391971*z)
             + y*(-10637.862943279538229754849097519
             + 6332.061275761629898663600653285*y
             + 12664.12255152325979732720130657*z));
            grad[1]= -84.4274836768217319821813420438
             + 140.71247279470288663696890340633*y
             + 140.71247279470288663696890340633*z
             + x*(1604.1221898596129076614454988322
             - 2532.824510304651959465440261314*y
             - 2532.824510304651959465440261314*z
             + x*(-5318.9314716397691148774245487594
             + 3799.236765456977939198160391971*x
             + 6332.061275761629898663600653285*y
             + 6332.061275761629898663600653285*z));
            grad[2]= -28.142494558940577327393780681267
             + 140.71247279470288663696890340633*y
             + x*(534.70739661987096922048183294407
             - 2532.824510304651959465440261314*y
             + x*(-1772.9771572132563716258081829198
             + 1266.412255152325979732720130657*x
             + 6332.061275761629898663600653285*y));
            return;
          case ( 25 ):
            grad[0]= -363.31804249169899985070393716618
             + y*(690.30428073422809971633748061575
             - 326.98623824252909986563354344956*y
             - 1961.9174294551745991938012606974*z)
             + (2070.9128422026842991490124418472
             - 1961.9174294551745991938012606974*z)*z
             + x*(2979.2079484319317987757722847627
             + z*(-13733.422006186222194356608824882
             + 9809.587147275872995969006303487*z)
             + y*(-4577.8073353954073981188696082939
             + 1634.9311912126454993281677172478*y
             + 9809.587147275872995969006303487*z)
             + x*(-5885.7522883655237975814037820922
             + 3269.8623824252909986563354344956*x
             + 4904.7935736379364979845031517435*y
             + 14714.38072091380949395350945523*z));
            grad[1]= -36.331804249169899985070393716618
             + 36.331804249169899985070393716618*y
             + 108.99541274750969995521118114985*z
             + x*(690.30428073422809971633748061575
             - 653.9724764850581997312670868991*y
             - 1961.9174294551745991938012606974*z
             + x*(-2288.903667697703699059434804147
             + 1634.9311912126454993281677172478*x
             + 1634.9311912126454993281677172478*y
             + 4904.7935736379364979845031517435*z));
            grad[2]= -108.99541274750969995521118114985
             + 108.99541274750969995521118114985*y
             + 217.99082549501939991042236229971*z
             + x*(2070.9128422026842991490124418472
             - 1961.9174294551745991938012606974*y
             - 3923.8348589103491983876025213948*z
             + x*(-6866.7110030931110971783044124409
             + 4904.7935736379364979845031517435*x
             + 4904.7935736379364979845031517435*y
             + 9809.587147275872995969006303487*z));
            return;
          case ( 26 ):
            grad[0]= -121.95080975540916841870638295216
             + y*(1688.549673536434639643626840876
             + y*(-4643.511602225195259019973812409
             + 3283.2910318764006881959410794811*y))
             + x*(619.13488029669270120266317498787
             + x*(-872.41733132715789714920720111927
             + 375.23326078587436436525040908356*x
             + 4221.37418384108659910906710219*y)
             + y*(-5909.923857377521238752693943066
             + 8442.74836768217319821813420438*y));
            grad[1]= -140.71247279470288663696890340633
             + (844.274836768217319821813420438
             - 984.9873095629202064587823238443*y)*y
             + x*(1688.549673536434639643626840876
             + x*(-2954.961928688760619376346971533
             + 1407.1247279470288663696890340633*x
             + 8442.74836768217319821813420438*y)
             + y*(-9287.023204450390518039947624818
             + 9849.873095629202064587823238443*y));
            grad[2]= 0;
            return;
          case ( 27 ):
            grad[0]= -211.22499852053496937195697277492
             + 389.95384342252609730207441127677*z
             + y*(2534.699982246419632463483673299
             - 4289.4922776477870703228185240445*z
             + y*(-5898.0518817657072216938754705611
             + 3412.0961299471033513931510986717*y
             + 6824.192259894206702786302197343*z))
             + x*(1072.3730694119467675807046310111
             - 1364.8384519788413405572604394687*z
             + x*(-1511.0711432622886270455383436975
             + 649.9230723708768288367906854613*x
             + 6336.749955616049081158709183248*y
             + 974.8846085563152432551860281919*z)
             + y*(-8871.4499378624687136221928565465
             + 10723.730694119467675807046310111*y
             + 7799.076868450521946041488225535*z));
            grad[1]= -211.22499852053496937195697277492
             + y*(1072.3730694119467675807046310111
             - 1023.6288389841310054179453296015*y
             - 1364.8384519788413405572604394687*z)
             + 389.95384342252609730207441127677*z
             + x*(2534.699982246419632463483673299
             - 4289.4922776477870703228185240445*z
             + x*(-4435.7249689312343568110964282733
             + 2112.2499852053496937195697277492*x
             + 10723.730694119467675807046310111*y
             + 3899.5384342252609730207441127677*z)
             + y*(-11796.103763531414443387750941122
             + 10236.288389841310054179453296015*y
             + 13648.384519788413405572604394687*z));
            grad[2]= -32.496153618543841441839534273064
             + (389.95384342252609730207441127677
             - 682.4192259894206702786302197343*y)*y
             + x*(389.95384342252609730207441127677
             + x*(-682.41922598942067027863021973435
             + 324.96153618543841441839534273064*x
             + 3899.5384342252609730207441127677*y)
             + y*(-4289.4922776477870703228185240445
             + 6824.192259894206702786302197343*y));
            return;
          case ( 28 ):
            grad[0]= -272.69030052423940221777791355678
             + (1510.2847413650182276676930596991
             - 1384.4276795846000420287186380575*z)*z
             + y*(2265.4271120475273415015395895487
             + z*(-11075.42143667680033622974910446
             + 8809.994324629272994728209514911*z)
             + y*(-3461.0691989615001050717965951438
             + 1468.3323874382121657880349191519*y
             + 8809.994324629272994728209514911*z))
             + x*(1384.4276795846000420287186380575
             + z*(-5285.9965947775637968369257089469
             + 2517.1412356083637127794884328319*z)
             + x*(-1950.7844575964818774041035354447
             + 839.047078536121237593162810944*x
             + 5663.567780118818353753848973872*y
             + 3775.7118534125455691692326492478*z)
             + y*(-7928.9948921663456952553885634203
             + 6292.85308902090928194872108208*y
             + 20137.129884866909702235907462655*z));
            grad[1]= -188.78559267062727845846163246239
             + y*(629.28530890209092819487210820796
             - 440.49971623146364973641047574557*y
             - 1761.9988649258545989456419029823*z)
             + (1006.8564942433454851117953731327
             - 880.9994324629272994728209514911*z)*z
             + x*(2265.4271120475273415015395895487
             + z*(-11075.42143667680033622974910446
             + 8809.994324629272994728209514911*z)
             + x*(-3964.4974460831728476276942817102
             + 1887.8559267062727845846163246239*x
             + 6292.85308902090928194872108208*y
             + 10068.564942433454851117953731327*z)
             + y*(-6922.1383979230002101435931902876
             + 4404.9971623146364973641047574557*y
             + 17619.988649258545989456419029823*z));
            grad[2]= -125.85706178041818563897442164159
             + y*(1006.8564942433454851117953731327
             - 880.9994324629272994728209514911*y
             - 1761.9988649258545989456419029823*z)
             + 251.71412356083637127794884328319*z
             + x*(1510.2847413650182276676930596991
             - 2768.855359169200084057437276115*z
             + x*(-2642.9982973887818984184628544734
             + 1258.5706178041818563897442164159*x
             + 10068.564942433454851117953731327*y
             + 2517.1412356083637127794884328319*z)
             + y*(-11075.42143667680033622974910446
             + 8809.994324629272994728209514911*y
             + 17619.988649258545989456419029823*z));
            return;
          case ( 29 ):
            grad[0]= -322.65151479576227149946429084169
             + z*(3573.9860100453666996863736831694
             + z*(-8190.3846063539653534479396905967
             + 4963.8694583963426384532967821798*z))
             + y*(893.49650251134167492159342079236
             + y*(-819.03846063539653534479396905967
             + 248.19347291981713192266483910899*y
             + 2978.3216750378055830719780693079*z)
             + z*(-6552.3076850831722827583517524773
             + 7445.80418759451395767994517327*z))
             + x*(1638.0769212707930706895879381193
             + x*(-2308.1992981542993268807830037136
             + 992.773891679268527690659356436*x
             + 2233.7412562783541873039835519809*y
             + 8934.965025113416749215934207924*z)
             + y*(-3127.2377587896958622255769727733
             + 1489.1608375189027915359890346539*y
             + 11913.286700151222332287912277231*z)
             + z*(-12508.951035158783448902307891093
             + 14891.608375189027915359890346539*z));
            grad[1]= -74.458041875945139576799451732697
             + y*(148.91608375189027915359890346539
             - 74.4580418759451395767994517327*y
             - 595.6643350075611166143956138616*z)
             + (595.66433500756111661439561386157
             - 744.580418759451395767994517327*z)*z
             + x*(893.49650251134167492159342079236
             + y*(-1638.0769212707930706895879381193
             + 744.580418759451395767994517327*y
             + 5956.643350075611166143956138616*z)
             + x*(-1563.6188793948479311127884863866
             + 744.580418759451395767994517327*x
             + 1489.1608375189027915359890346539*y
             + 5956.643350075611166143956138616*z)
             + z*(-6552.3076850831722827583517524773
             + 7445.80418759451395767994517327*z));
            grad[2]= -297.83216750378055830719780693079
             + y*(595.66433500756111661439561386157
             - 297.83216750378055830719780693079*y
             - 1489.1608375189027915359890346539*z)
             + (1489.1608375189027915359890346539
             - 1489.1608375189027915359890346539*z)*z
             + x*(3573.9860100453666996863736831694
             + z*(-16380.769212707930706895879381193
             + 14891.608375189027915359890346539*z)
             + y*(-6552.3076850831722827583517524773
             + 2978.3216750378055830719780693079*y
             + 14891.608375189027915359890346539*z)
             + x*(-6254.4755175793917244511539455465
             + 2978.3216750378055830719780693079*x
             + 5956.643350075611166143956138616*y
             + 14891.608375189027915359890346539*z));
            return;
          case ( 30 ):
            grad[0]= -41.952353926806061879658140547198
             + y*(755.14237068250911383384652984956
             + y*(-2642.9982973887818984184628544734
             + 2349.3318199011394652608558706431*y))
             + x*(125.85706178041818563897442164159
             + x*(-125.85706178041818563897442164159
             + 41.952353926806061879658140547198*x
             + 755.1423706825091138338465298496*y)
             + y*(-1510.2847413650182276676930596991
             + 2642.9982973887818984184628544734*y));
            grad[1]= -251.71412356083637127794884328319
             + y*(2642.9982973887818984184628544734
             + y*(-7047.9954597034183957825676119292
             + 5285.996594777563796836925708947*y))
             + x*(755.14237068250911383384652984956
             + x*(-755.14237068250911383384652984956
             + 251.71412356083637127794884328319*x
             + 2642.9982973887818984184628544734*y)
             + y*(-5285.9965947775637968369257089469
             + 7047.995459703418395782567611929*y));
            grad[2]= 0;
            return;
          case ( 31 ):
            grad[0]= -72.663608498339799970140787433237
             + 108.99541274750969995521118114985*z
             + x*(217.99082549501939991042236229971
             - 217.99082549501939991042236229971*z
             + x*(-217.99082549501939991042236229971
             + 72.66360849833979997014078743324*x
             + 1198.9495402226066995073229926484*y
             + 108.99541274750969995521118114985*z)
             + y*(-2397.8990804452133990146459852968
             + 3814.8394461628394984323913402449*y
             + 1525.935778465135799372956536098*z))
             + y*(1198.9495402226066995073229926484
             - 1525.935778465135799372956536098*z
             + y*(-3814.8394461628394984323913402449
             + 3051.8715569302715987459130721959*y
             + 3051.8715569302715987459130721959*z));
            grad[1]= -399.6498467408688998357743308828
             + 762.967889232567899686478268049*z
             + x*(1198.9495402226066995073229926484
             - 1525.935778465135799372956536098*z
             + x*(-1198.9495402226066995073229926484
             + 399.6498467408688998357743308828*x
             + 3814.8394461628394984323913402449*y
             + 762.967889232567899686478268049*z)
             + y*(-7629.6788923256789968647826804898
             + 9155.614670790814796237739216588*y
             + 6103.743113860543197491826144392*z))
             + y*(3814.8394461628394984323913402449
             - 6103.743113860543197491826144392*z
             + y*(-9155.6146707908147962377392165878
             + 6103.743113860543197491826144392*y
             + 9155.614670790814796237739216588*z));
            grad[2]= -36.331804249169899985070393716618
             + y*(762.96788923256789968647826804898
             + y*(-3051.8715569302715987459130721959
             + 3051.8715569302715987459130721959*y))
             + x*(108.99541274750969995521118114985
             + x*(-108.99541274750969995521118114985
             + 36.331804249169899985070393716618*x
             + 762.967889232567899686478268049*y)
             + y*(-1525.935778465135799372956536098
             + 3051.8715569302715987459130721959*y));
            return;
          case ( 32 ):
            grad[0]= -93.808315196468591091312602270889
             + (422.137418384108659910906710219
             - 281.42494558940577327393780681267*z)*z
             + x*(281.42494558940577327393780681267
             + z*(-844.274836768217319821813420438
             + 281.42494558940577327393780681267*z)
             + x*(-281.42494558940577327393780681267
             + 93.80831519646859109131260227089*x
             + 1266.412255152325979732720130657*y
             + 422.137418384108659910906710219*z)
             + y*(-2532.824510304651959465440261314
             + 3236.3868742781663926502847783457*y
             + 4784.2240750198981456569427158154*z))
             + y*(1266.412255152325979732720130657
             + z*(-4784.2240750198981456569427158154
             + 2251.3995647152461861915024545013*z)
             + y*(-3236.3868742781663926502847783457
             + 2063.7829343223090040088772499596*y
             + 7317.048585324550105122382977129*z));
            grad[1]= -422.137418384108659910906710219
             + (2392.1120375099490728284713579077
             - 2251.3995647152461861915024545013*z)*z
             + x*(1266.412255152325979732720130657
             + z*(-4784.2240750198981456569427158154
             + 2251.3995647152461861915024545013*z)
             + x*(-1266.412255152325979732720130657
             + 422.137418384108659910906710219*x
             + 3236.3868742781663926502847783457*y
             + 2392.1120375099490728284713579077*z)
             + y*(-6472.7737485563327853005695566914
             + 6191.348802966927012026631749879*y
             + 14634.097170649100210244765954259*z))
             + y*(3236.3868742781663926502847783457
             + z*(-14634.097170649100210244765954259
             + 10131.298041218607837861761045256*z)
             + y*(-6191.3488029669270120266317498787
             + 3377.099347072869279287253681752*y
             + 15196.947061827911756792641567884*z));
            grad[2]= -140.71247279470288663696890340633
             + 281.42494558940577327393780681267*z
             + x*(422.137418384108659910906710219
             - 562.8498911788115465478756136253*z
             + x*(-422.137418384108659910906710219
             + 140.71247279470288663696890340633*x
             + 2392.1120375099490728284713579077*y
             + 281.42494558940577327393780681267*z)
             + y*(-4784.2240750198981456569427158154
             + 7317.048585324550105122382977129*y
             + 4502.7991294304923723830049090027*z))
             + y*(2392.1120375099490728284713579077
             - 4502.7991294304923723830049090027*z
             + y*(-7317.0485853245501051223829771294
             + 5065.649020609303918930880522628*y
             + 10131.298041218607837861761045256*z));
            return;
          case ( 33 ):
            grad[0]= -110.99549540409286357391783156889
             + z*(998.95945863683577216526048412001
             + z*(-1664.9324310613929536087674735333
             + 554.9774770204643178695891578444*z))
             + x*(332.98648621227859072175349470667
             + x*(-332.98648621227859072175349470667
             + 110.99549540409286357391783156889*x
             + 998.95945863683577216526048412*y
             + 998.95945863683577216526048412*z)
             + z*(-1997.91891727367154433052096824
             + 1664.9324310613929536087674735333*z)
             + y*(-1997.91891727367154433052096824
             + 1664.9324310613929536087674735333*y
             + 7325.702696670128995878576883547*z))
             + y*(998.95945863683577216526048412001
             + y*(-1664.9324310613929536087674735333
             + 776.9684678286500450174248209822*y
             + 6326.743238033293223713316399427*z)
             + z*(-7325.7026966701289958785768835467
             + 8324.662155306964768043837367667*z));
            grad[1]= -332.98648621227859072175349470667
             + z*(3662.8513483350644979392884417734
             + z*(-8324.6621553069647680438373676667
             + 4994.7972931841788608263024206*z))
             + x*(998.95945863683577216526048412001
             + x*(-998.95945863683577216526048412001
             + 332.98648621227859072175349470667*x
             + 1664.9324310613929536087674735333*y
             + 3662.8513483350644979392884417734*z)
             + z*(-7325.7026966701289958785768835467
             + 8324.662155306964768043837367667*z)
             + y*(-3329.8648621227859072175349470667
             + 2330.9054034859501350522744629467*y
             + 12653.486476066586447426632798853*z))
             + y*(1664.9324310613929536087674735333
             + y*(-2330.9054034859501350522744629467
             + 998.95945863683577216526048412*y
             + 8990.63512773152194948734435708*z)
             + z*(-12653.486476066586447426632798853
             + 14984.3918795525365824789072618*z));
            grad[2]= -332.98648621227859072175349470667
             + (1664.9324310613929536087674735333
             - 1664.9324310613929536087674735333*z)*z
             + y*(3662.8513483350644979392884417734
             + z*(-16649.324310613929536087674735333
             + 14984.3918795525365824789072618*z)
             + y*(-6326.7432380332932237133163994267
             + 2996.87837591050731649578145236*y
             + 14984.3918795525365824789072618*z))
             + x*(998.95945863683577216526048412001
             + z*(-3329.8648621227859072175349470667
             + 1664.9324310613929536087674735333*z)
             + x*(-998.95945863683577216526048412001
             + 332.98648621227859072175349470667*x
             + 3662.8513483350644979392884417734*y
             + 1664.9324310613929536087674735333*z)
             + y*(-7325.7026966701289958785768835467
             + 6326.743238033293223713316399427*y
             + 16649.324310613929536087674735333*z));
            return;
          case ( 34 ):
            grad[0]= -125.85706178041818563897442164159
             + z*(1887.8559267062727845846163246239
             + z*(-5663.5677801188183537538489738717
             + 4404.9971623146364973641047574557*z))
             + y*(377.57118534125455691692326492478
             + y*(-377.57118534125455691692326492478
             + 125.85706178041818563897442164159*y
             + 1887.8559267062727845846163246239*z)
             + z*(-3775.7118534125455691692326492478
             + 5663.567780118818353753848973872*z))
             + x*(377.57118534125455691692326492478
             + x*(-377.57118534125455691692326492478
             + 125.85706178041818563897442164159*x
             + 377.57118534125455691692326492478*y
             + 1887.8559267062727845846163246239*z)
             + y*(-755.14237068250911383384652984956
             + 377.57118534125455691692326492478*y
             + 3775.7118534125455691692326492478*z)
             + z*(-3775.7118534125455691692326492478
             + 5663.567780118818353753848973872*z));
            grad[1]= -125.85706178041818563897442164159
             + z*(1887.8559267062727845846163246239
             + z*(-5663.5677801188183537538489738717
             + 4404.9971623146364973641047574557*z))
             + y*(377.57118534125455691692326492478
             + y*(-377.57118534125455691692326492478
             + 125.85706178041818563897442164159*y
             + 1887.8559267062727845846163246239*z)
             + z*(-3775.7118534125455691692326492478
             + 5663.567780118818353753848973872*z))
             + x*(377.57118534125455691692326492478
             + x*(-377.57118534125455691692326492478
             + 125.85706178041818563897442164159*x
             + 377.57118534125455691692326492478*y
             + 1887.8559267062727845846163246239*z)
             + y*(-755.14237068250911383384652984956
             + 377.57118534125455691692326492478*y
             + 3775.7118534125455691692326492478*z)
             + z*(-3775.7118534125455691692326492478
             + 5663.567780118818353753848973872*z));
            grad[2]= -629.28530890209092819487210820796
             + z*(5663.5677801188183537538489738717
             + z*(-13214.991486943909492092314272367
             + 8809.994324629272994728209514911*z))
             + y*(1887.8559267062727845846163246239
             + y*(-1887.8559267062727845846163246239
             + 629.285308902090928194872108208*y
             + 5663.567780118818353753848973872*z)
             + z*(-11327.135560237636707507697947743
             + 13214.991486943909492092314272367*z))
             + x*(1887.8559267062727845846163246239
             + x*(-1887.8559267062727845846163246239
             + 629.285308902090928194872108208*x
             + 1887.8559267062727845846163246239*y
             + 5663.567780118818353753848973872*z)
             + y*(-3775.7118534125455691692326492478
             + 1887.8559267062727845846163246239*y
             + 11327.135560237636707507697947743*z)
             + z*(-11327.135560237636707507697947743
             + 13214.991486943909492092314272367*z));
             return;
          #endif
          #if (PMAX3D>=5)
          case ( 35 ):
            grad[0]= 203.96078054371139320112896436091
             + x*(-3671.2940497868050776203213584964
             + x*(18356.470248934025388101606792482
             + x*(-33653.52878971237987818627911955
             + 20192.11727382742792691176747173*x)));
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 36 ):
            grad[0]= 266.81079438433520769082237379282
             - 778.7990755002216873137517937736*y
             + x*(-4413.1947611679228947779268313839
             + 11681.986132503325309706276906604*y
             + x*(20118.976117089060255605254672485
             - 42833.949152512192802256348657549*y
             + x*(-33315.293785287261068421604511427
             + 17847.478813546747000940145273979*x
             + 42833.949152512192802256348657549*y)));
            grad[1]= 21.633307652783935758715327604823
             + x*(-778.79907550022168731375179377363
             + x*(5840.9930662516626548531384533022
             + x*(-14277.983050837397600752116219183
             + 10708.487288128048200564087164387*x)));
            grad[2]= 0;
            return;
          case ( 37 ):
            grad[0]= 462.12985188148146723267009094954
             - 449.63985588468467082097630470767*y
             - 899.2797117693693416419526094153*z
             + x*(-7643.8775500396394039565971800303
             + 6744.597838270270062314644570615*y
             + 13489.19567654054012462928914123*z
             + x*(34847.088831063061988625663614844
             - 24730.192073657656895153696758922*y
             - 49460.384147315313790307393517843*z
             + x*(-57703.781505201199422025292437484
             + 30912.740092072071118942120948652*x
             + 24730.192073657656895153696758922*y
             + 49460.384147315313790307393517843*z)));
            grad[1]= 12.48999599679679641169378624188
             + x*(-449.63985588468467082097630470767
             + x*(3372.2989191351350311573222853075
             + x*(-8243.3973578858856317178989196405
             + 6182.54801841441422378842418973*x)));
            grad[2]= 24.979991993593592823387572483759
             + x*(-899.27971176936934164195260941533
             + x*(6744.597838270270062314644570615
             + x*(-16486.794715771771263435797839281
             + 12365.096036828828447576848379461*x)));
            return;
          case ( 38 ):
            grad[0]= 282.6163477224910993524493672627
             + y*(-2190.2766948493060199814825962859
             + 2649.5282598983540564292128180878*y)
             + x*(-3991.9559115801867783533473125856
             + (27555.093902942882186863813308113
             - 29144.810858881894620721340998966*y)*y
             + x*(15367.263907410453527289434344909
             + y*(-81605.470404869304938019754797104
             + 58289.62171776378924144268199793*y)
             + x*(-21372.861296513389388528983399241
             + 9714.936952960631540240446999655*x
             + 62175.59649894804185753886079779*y)));
            grad[1]= 70.654086930622774838112341815674
             - 176.63521732655693709528085453919*y
             + x*(-2190.2766948493060199814825962859
             + 5299.056519796708112858425636176*y
             + x*(13777.546951471441093431906654056
             - 29144.810858881894620721340998966*y
             + x*(-27201.823468289768312673251599035
             + 15543.899124737010464384715199448*x
             + 38859.747811842526160961787998621*y)));
            grad[2]= 0;
            return;
          case ( 39 ):
            grad[0]= 489.50587330490734368270951446619
             - 948.4176295282579783852496842782*z
             + y*(-2845.2528885847739351557490528347
             + 2294.5587811167531735127008490603*y
             + 4589.1175622335063470254016981205*z)
             + x*(-6914.2704604318162295182718918349
             + y*(35795.11698542134950679813324534
             - 25240.146592284284908639709339663*y
             - 50480.29318456856981727941867933*z)
             + 11931.705661807116502266044415113*z
             + x*(26616.881860954336812747329849099
             - 35336.205229197998872095593075528*z
             + x*(-37018.881668683617866004907031505
             + 16826.764394856189939093139559775*x
             + 80768.46909530971170764706988692*y
             + 26922.82303176990390254902329564*z)
             + y*(-106008.61568759399661628677922658
             + 50480.29318456856981727941867933*y
             + 100960.58636913713963455883735865*z)));
            grad[1]= 91.78235124467012694050803396241
             - 152.97058540778354490084672327068*y
             - 152.97058540778354490084672327068*z
             + x*(-2845.2528885847739351557490528347
             + 4589.1175622335063470254016981205*y
             + 4589.1175622335063470254016981205*z
             + x*(17897.55849271067475339906662267
             - 25240.146592284284908639709339663*y
             - 25240.146592284284908639709339663*z
             + x*(-35336.205229197998872095593075528
             + 20192.11727382742792691176747173*x
             + 33653.52878971237987818627911955*y
             + 33653.52878971237987818627911955*z)));
            grad[2]= 30.594117081556708980169344654137
             - 152.97058540778354490084672327068*y
             + x*(-948.41762952825797838524968427824
             + 4589.1175622335063470254016981205*y
             + x*(5965.8528309035582511330222075567
             - 25240.146592284284908639709339663*y
             + x*(-11778.735076399332957365197691843
             + 6730.70575794247597563725582391*x
             + 33653.52878971237987818627911955*y)));
            return;
          case ( 40 ):
            grad[0]= 631.94936506020796855803075339914
             + z*(-3673.2056844124588172435537541325
             + 3554.7151784636698231389229878702*z)
             + y*(-1224.4018948041529390811845847108
             + 592.4525297439449705231538313117*y
             + 3554.7151784636698231389229878702*z)
             + x*(-8926.2847814754375558821843917628
             + y*(15403.765773342569233601999614104
             - 6516.977827183394675754692144429*y
             - 39101.866963100368054528152866572*z)
             + (46211.297320027707700805998842312
             - 39101.866963100368054528152866572*z)*z
             + x*(34362.246725148808290342922216078
             + z*(-136856.534370851288190848535033
             + 78203.73392620073610905630573314*z)
             + y*(-45618.844790283762730282845011
             + 13033.955654366789351509384288857*y
             + 78203.73392620073610905630573314*z)
             + x*(-47791.17073267822762220107572581
             + 21723.259423944648919182307148095*x
             + 34757.215078311438270691691436953*y
             + 104271.64523493431481207507431086*z)));
            grad[1]= 39.496835316262998034876922087446
             - 39.496835316262998034876922087446*y
             - 118.49050594878899410463076626234*z
             + x*(-1224.4018948041529390811845847108
             + 1184.9050594878899410463076626234*y
             + 3554.7151784636698231389229878702*z
             + x*(7701.882886671284616800999807052
             - 6516.977827183394675754692144429*y
             - 19550.933481550184027264076433286*z
             + x*(-15206.281596761254243427615003667
             + 8689.303769577859567672922859238*x
             + 8689.303769577859567672922859238*y
             + 26067.911308733578703018768577714*z)));
            grad[2]= 118.49050594878899410463076626234
             - 118.49050594878899410463076626234*y
             - 236.98101189757798820926153252468*z
             + x*(-3673.2056844124588172435537541325
             + 3554.7151784636698231389229878702*y
             + 7109.43035692733964627784597574*z
             + x*(23105.648660013853850402999421156
             - 19550.933481550184027264076433286*y
             - 39101.866963100368054528152866572*z
             + x*(-45618.844790283762730282845011
             + 26067.911308733578703018768577714*x
             + 26067.911308733578703018768577714*y
             + 52135.82261746715740603753715543*z)));
            return;
          case ( 41 ):
            grad[0]= 254.95097567963924150141120545114
             + y*(-3671.2940497868050776203213584964
             + (10554.970393137064598158423905677
             - 7852.490050932888638243465127895*y)*y)
             + x*(-2753.4705373401038082152410188723
             + y*(33959.469960527946967987972566092
             + y*(-80768.469095309711707647069886921
             + 47114.940305597331829460790767371*y))
             + x*(8107.4410266125278797448763333462
             + x*(-8974.2743439233013008496744318801
             + 3365.352878971237987818627911955*x
             + 40384.23454765485585382353494346*y)
             + y*(-70672.410458395997744191186151056
             + 90864.52773222342567110295362279*y)));
            grad[1]= 152.97058540778354490084672327068
             + y*(-917.8235124467012694050803396241
             + 1070.7940978544848143059270628948*y)
             + x*(-3671.2940497868050776203213584964
             + (21109.940786274129196316847811354
             - 23557.470152798665914730395383685*y)*y
             + x*(16979.734980263973483993986283046
             + x*(-23557.470152798665914730395383685
             + 10096.058636913713963455883735865*x
             + 60576.35182148228378073530241519*y)
             + y*(-80768.469095309711707647069886921
             + 70672.41045839599774419118615106*y)));
            grad[2]= 0;
            return;
          case ( 42 ):
            grad[0]= 441.58804331639234273820213634796
             - 847.8490431674732980573481017881*z
             + y*(-5511.0187805885764373727626616226
             + y*(13406.612995085671525531816859524
             - 8160.54704048693049380197547971*y
             - 16321.094080973860987603950959421*z)
             + 9750.263996425942927659503170563*z)
             + x*(-4769.150867817037301572583072558
             + 7842.60364929912800703046994154*z
             + x*(14042.499777461276499074827935865
             - 16321.094080973860987603950959421*z
             + x*(-15543.899124737010464384715199448
             + 5828.962171776378924144268199793*x
             + 60621.20658647434081110038927785*y
             + 9326.339474842206278630829119669*z)
             + y*(-106087.11152633009641942568123623
             + 115413.4510011723026980565103559*y
             + 83937.05527357985650767746207702*z))
             + y*(50976.923720444332045698054620009
             - 74610.71579873765022904663295735*z
             + y*(-102589.73422326426906493912031636
             + 48963.282242921582962811852878262*y
             + 97926.56448584316592562370575652*z)));
            grad[1]= 229.62578252452401822386511090094
             - 423.92452158373664902867405089404*z
             + y*(-1165.7924343552757848288536399586
             + 1112.8018691573087037002693835969*y
             + 1483.7358255430782716003591781292*z)
             + x*(-5511.0187805885764373727626616226
             + y*(26813.225990171343051063633719048
             - 24481.641121460791481405926439131*y
             - 32642.188161947721975207901918841*z)
             + 9750.263996425942927659503170563*z
             + x*(25488.461860222166022849027310004
             - 37305.357899368825114523316478676*z
             + x*(-35362.370508776698806475227078745
             + 15155.301646618585202775097319462*x
             + 76942.30066744820179870434023727*y
             + 27979.018424526618835892487359007*z)
             + y*(-102589.73422326426906493912031636
             + 73444.92336438237444421777931739*y
             + 97926.56448584316592562370575652*z)));
            grad[2]= 35.327043465311387419056170907837
             + y*(-423.92452158373664902867405089404
             + 741.8679127715391358001795890646*y)
             + x*(-847.84904316747329805734810178809
             + (9750.263996425942927659503170563
             - 16321.094080973860987603950959421*y)*y
             + x*(3921.3018246495640035152349707699
             + x*(-5440.3646936579536625346503198069
             + 2331.5848687105515696577072799172*x
             + 27979.018424526618835892487359007*y)
             + y*(-37305.357899368825114523316478676
             + 48963.282242921582962811852878262*y)));
            return;
          case ( 43 ):
            grad[0]= 570.08771254956898956802451278338
             + z*(-3283.7052242855173799118211936323
             + 3146.8841732736208224154953105642*z)
             + y*(-4925.5578364282760698677317904484
             + y*(7867.2104331840520560387382764106
             - 3511.7403093053449757390309987456*y
             - 21070.441855832069854434185992474*z)
             + (25175.073386188966579323962484514
             - 21070.441855832069854434185992474*z)*z)
             + x*(-6156.9472955353450873346647380605
             + (30374.273324641035764184346041098
             - 24080.50497809379411935335541997*z)*z
             + y*(45561.409986961553646276519061648
             + z*(-192644.03982475035295482684335976
             + 126422.65113499241912660511595484*z)
             + y*(-60201.262445234485298383388549925
             + 21070.441855832069854434185992474*y
             + 126422.65113499241912660511595484*z))
             + x*(18128.789259076293868263179506511
             + z*(-63211.325567496209563302557977421
             + 27090.568100355518384272524847466*z)
             + x*(-20067.087481744828432794462849975
             + 7525.157805654310662297923568741*x
             + 54181.13620071103676854504969493*y
             + 36120.757467140691179030033129955*z)
             + y*(-94816.988351244314344953836966131
             + 67726.42025088879596068131211867*y
             + 216724.54480284414707418019877973*z)));
            grad[1]= 205.23157651784483624448882460202
             + z*(-1094.5684080951724599706070645441
             + 957.7473570832759024742811814761*z)
             + y*(-684.10525505948278748162941534005
             + 478.87367854163795123714059073804*y
             + 1915.4947141665518049485623629521*z)
             + x*(-4925.5578364282760698677317904484
             + y*(15734.420866368104112077476552821
             - 10535.220927916034927217092996237*y
             - 42140.883711664139708868371984947*z)
             + (25175.073386188966579323962484514
             - 21070.441855832069854434185992474*z)*z
             + x*(22780.704993480776823138259530824
             + z*(-96322.019912375176477413421679879
             + 63211.32556749620956330255797742*z)
             + x*(-31605.66278374810478165127898871
             + 13545.284050177759192136262423733*x
             + 45150.946833925863973787541412443*y
             + 72241.51493428138235806006625991*z)
             + y*(-60201.262445234485298383388549925
             + 31605.66278374810478165127898871*y
             + 126422.65113499241912660511595484*z)));
            grad[2]= 136.82105101189655749632588306801
             - 273.64210202379311499265176613602*z
             + y*(-1094.5684080951724599706070645441
             + 957.7473570832759024742811814761*y
             + 1915.4947141665518049485623629521*z)
             + x*(-3283.7052242855173799118211936323
             + y*(25175.073386188966579323962484514
             - 21070.441855832069854434185992474*y
             - 42140.883711664139708868371984947*z)
             + 6293.768346547241644830990621128*z
             + x*(15187.136662320517882092173020549
             - 24080.50497809379411935335541997*z
             + x*(-21070.441855832069854434185992474
             + 9030.189366785172794757508282489*x
             + 72241.51493428138235806006625991*y
             + 18060.378733570345589515016564977*z)
             + y*(-96322.019912375176477413421679879
             + 63211.32556749620956330255797742*y
             + 126422.65113499241912660511595484*z)));
            return;
          case ( 44 ):
            grad[0]= 674.53687816160207327751528057478
             + y*(-1942.6662091054139710392440080554
             + y*(1861.7217837260217222459421743864
             - 593.5924527822098244842134469058*y
             - 7123.10943338651789381056136287*z)
             + (14893.774269808173777967537395091
             - 17807.773583466294734526403407174*z)*z)
             + z*(-7770.6648364216558841569760322214
             + (18617.217837260217222459421743864
             - 11871.849055644196489684268938116*z)*z)
             + x*(-7284.9982841453023913971650302076
             + z*(71878.649736900316928452028298048
             + z*(-142462.18866773035787621122725739
             + 71231.0943338651789381056136287*z))
             + y*(17969.662434225079232113007074512
             + y*(-14246.218866773035787621122725739
             + 3561.5547166932589469052806814348*y
             + 42738.656600319107362863368177218*z)
             + z*(-113969.75093418428630096898180591
             + 106846.64150079776840715842044304*z))
             + x*(21450.272725538945930224985922278
             + x*(-23743.698111288392979368537876232
             + 8903.886791733147367263201703587*x
             + 21369.328300159553681431684088609*y
             + 85477.31320063821472572673635444*z)
             + y*(-37396.324525279218942505447155066
             + 16026.996225119665261073763066457*y
             + 128215.96980095732208859010453165*z)
             + z*(-149585.29810111687577002178862026
             + 160269.96225119665261073763066457*z)));
            grad[1]= 80.944425379392248793301833668973
             + y*(-161.88885075878449758660366733795
             + 80.94442537939224879330183366897*y
             + 647.5554030351379903464146693518*z)
             + z*(-647.55540303513799034641466935179
             + 809.4442537939224879330183366897*z)
             + x*(-1942.6662091054139710392440080554
             + y*(3723.4435674520434444918843487728
             - 1780.7773583466294734526403407174*y
             - 14246.218866773035787621122725739*z)
             + (14893.774269808173777967537395091
             - 17807.773583466294734526403407174*z)*z
             + x*(8984.831217112539616056503537256
             + y*(-14246.218866773035787621122725739
             + 5342.332075039888420357921022152*y
             + 42738.656600319107362863368177218*z)
             + x*(-12465.441508426406314168482385022
             + 5342.332075039888420357921022152*x
             + 10684.664150079776840715842044304*y
             + 42738.656600319107362863368177218*z)
             + z*(-56984.875467092143150484490902957
             + 53423.32075039888420357921022152*z)));
            grad[2]= 323.77770151756899517320733467589
             + z*(-1618.8885075878449758660366733795
             + 1618.8885075878449758660366733795*z)
             + y*(-647.55540303513799034641466935179
             + 323.77770151756899517320733467589*y
             + 1618.8885075878449758660366733795*z)
             + x*(-7770.6648364216558841569760322214
             + y*(14893.774269808173777967537395091
             - 7123.10943338651789381056136287*y
             - 35615.547166932589469052806814348*z)
             + (37234.435674520434444918843487728
             - 35615.547166932589469052806814348*z)*z
             + x*(35939.324868450158464226014149024
             + z*(-142462.18866773035787621122725739
             + 106846.64150079776840715842044304*z)
             + y*(-56984.875467092143150484490902957
             + 21369.328300159553681431684088609*y
             + 106846.64150079776840715842044304*z)
             + x*(-49861.766033705625256673929540088
             + 21369.328300159553681431684088609*x
             + 42738.656600319107362863368177218*y
             + 106846.64150079776840715842044304*z)));
            return;
          case ( 45 ):
            grad[0]= 182.42806801586207666176784409068
             + y*(-4104.6315303568967248897764920403
             + y*(20112.694498748793951959904810998
             + y*(-33201.908378886897952441747624504
             + 17239.452427498966244537061266569*y)))
             + x*(-1231.3894591070690174669329476121
             + x*(2599.5999692260345924301917782922
             + x*(-2234.7438331943104391066560901108
             + 684.1052550594827874816294153401*x
             + 13134.820897142069519647284774529*y)
             + y*(-30374.273324641035764184346041098
             + 51718.35728249689873361118379971*y))
             + y*(21344.08395785586296942683775861
             + y*(-71831.051781245692685571088610706
             + 61295.83085332965775835399561447*y)));
            grad[1]= 273.64210202379311499265176613602
             + y*(-2873.2420712498277074228435444282
             + (7661.9788566662072197942494518086
             - 5746.484142499655414845687088856*y)*y)
             + x*(-4104.6315303568967248897764920403
             + y*(40225.388997497587903919809621995
             + y*(-99605.725136660693857325242873512
             + 68957.80970999586497814824506628*y))
             + x*(10672.041978927931484713418879305
             + x*(-10124.757774880345254728115347033
             + 3283.7052242855173799118211936323*x
             + 34478.904854997932489074122533139*y)
             + y*(-71831.051781245692685571088610706
             + 91943.7462799944866375309934217*y)));
            grad[2]= 0;
            return;
          case ( 46 ):
            grad[0]= 315.97468253010398427901537669957
             - 592.4525297439449705231538313117*z
             + y*(-6516.9778271833946757546921444286
             + 11612.069582981321422253815093709*z
             + y*(29030.173957453303555634537734273
             - 43130.544165359193854085598919491*z
             + y*(-43130.544165359193854085598919491
             + 19906.404999396551009577968732073*y
             + 39812.809998793102019155937464146*z)))
             + x*(-2132.8291070782018938833537927221
             + 3080.7531546685138467203999228208*z
             + x*(4502.6392260539817759759691179689
             - 4384.1487201051927818713383517065*z
             + x*(-3870.6898609937738074179383645697
             + 1184.9050594878899410463076626234*x
             + 20854.329046986862962415014862172*y
             + 1895.8480951806239056740922601974*z)
             + y*(-48225.635921157120600584721868772
             + 74649.01874773706628591738274527*y
             + 29859.607499094826514366953098109*z))
             + y*(33888.284701353652313924399151029
             - 41471.677082076147936620768191819*z
             + y*(-103679.19270519036984155192047955
             + 79625.61999758620403831187492829*y
             + 79625.61999758620403831187492829*z)));
            grad[1]= 434.46518847889297838364614296191
             - 829.4335416415229587324153638364*z
             + y*(-4147.1677082076147936620768191819
             + y*(9953.2024996982755047889843660364
             - 6635.468333132183669859322910691*y
             - 9953.202499698275504788984366036*z)
             + 6635.468333132183669859322910691*z)
             + x*(-6516.9778271833946757546921444286
             + 11612.069582981321422253815093709*z
             + x*(16944.142350676826156962199575514
             - 20735.838541038073968310384095909*z
             + x*(-16075.211973719040200194907289591
             + 5213.582261746715740603753715543*x
             + 49766.012498491377523944921830182*y
             + 9953.202499698275504788984366036*z)
             + y*(-103679.19270519036984155192047955
             + 119438.42999637930605746781239244*y
             + 79625.61999758620403831187492829*z))
             + y*(58060.347914906607111269075468546
             - 86261.08833071838770817119783898*z
             + y*(-129391.63249607758156225679675847
             + 79625.61999758620403831187492829*y
             + 119438.42999637930605746781239244*z)));
            grad[2]= 39.496835316262998034876922087446
             + y*(-829.43354164152295873241536383637
             + (3317.7341665660918349296614553455
             - 3317.7341665660918349296614553455*y)*y)
             + x*(-592.45252974394497052315383131169
             + y*(11612.069582981321422253815093709
             + y*(-43130.544165359193854085598919491
             + 39812.809998793102019155937464146*y))
             + x*(1540.3765773342569233601999614104
             + x*(-1461.3829067017309272904461172355
             + 473.96202379515597641852306504935*x
             + 9953.202499698275504788984366036*y)
             + y*(-20735.838541038073968310384095909
             + 39812.809998793102019155937464146*y)));
            return;
          case ( 47 ):
            grad[0]= 407.92156108742278640225792872182
             + z*(-2294.5587811167531735127008490603
             + 2141.5881957089696286118541257896*z)
             + y*(-6883.6763433502595205381025471808
             + (36406.999327052483686401520138423
             - 31817.881764818977339376118440302*z)*z
             + y*(24628.26425065315072903632244658
             + z*(-103408.11573566167635297238493098
             + 66083.29289616249139716578445294*z)
             + y*(-29166.39161775072922776144190361
             + 11013.882149360415232860964075489*y
             + 66083.29289616249139716578445294*z)))
             + x*(-2753.4705373401038082152410188723
             + (11931.705661807116502266044415113
             - 7648.529270389177245042336163534*z)*z
             + x*(5812.882245495774706232175484286
             + z*(-16979.734980263973483993986283046
             + 5506.941074680207616430482037745*z)
             + x*(-4997.0391233209291334276596268423
             + 1529.7058540778354490084672327068*x
             + 22027.764298720830465721928150978*y
             + 7342.588099573610155240642716993*z)
             + y*(-50939.204940791920451981958849138
             + 63329.82235882238758895054343406*y
             + 93617.99826956352947931819464166*z))
             + y*(35795.11698542134950679813324534
             + z*(-130024.99759661601316571971478008
             + 58740.70479658888124192514173594*z)
             + y*(-87958.086609475538317986865880643
             + 53845.64606353980780509804659128*y
             + 190907.29058891386403625671064181*z)));
            grad[1]= 458.91175622335063470254016981205
             + z*(-2600.4999519323202633143942956016
             + 2447.5293665245367184135475723309*z)
             + y*(-3518.3234643790215327194746352257
             + y*(6730.7057579424759756372558239101
             - 3671.2940497868050776203213584964*y
             - 16520.823224040622849291446113234*z)
             + (15908.940882409488669688059220151
             - 11013.882149360415232860964075489*z)*z)
             + x*(-6883.6763433502595205381025471808
             + (36406.999327052483686401520138423
             - 31817.881764818977339376118440302*z)*z
             + x*(17897.55849271067475339906662267
             + z*(-65012.49879830800658285985739004
             + 29370.352398294440620962570867971*z)
             + x*(-16979.734980263973483993986283046
             + 5506.941074680207616430482037745*x
             + 42219.881572548258392633695622709*y
             + 31205.999423187843159772731547219*z)
             + y*(-87958.086609475538317986865880643
             + 80768.46909530971170764706988692*y
             + 190907.29058891386403625671064181*z))
             + y*(49256.52850130630145807264489316
             + z*(-206816.23147132335270594476986196
             + 132166.58579232498279433156890587*z)
             + y*(-87499.174853252187683284325710831
             + 44055.528597441660931443856301957*y
             + 198249.87868848747419149735335881*z)));
            grad[2]= 152.97058540778354490084672327068
             - 305.94117081556708980169344654137*z
             + y*(-2600.4999519323202633143942956016
             + y*(7954.4704412047443348440296100755
             - 5506.941074680207616430482037745*y
             - 11013.882149360415232860964075489*z)
             + 4895.0587330490734368270951446619*z)
             + x*(-2294.5587811167531735127008490603
             + 4283.1763914179392572237082515791*z
             + x*(5965.8528309035582511330222075567
             - 7648.529270389177245042336163534*z
             + x*(-5659.9116600879911613313287610153
             + 1835.6470248934025388101606792482*x
             + 31205.999423187843159772731547219*y
             + 3671.2940497868050776203213584964*z)
             + y*(-65012.49879830800658285985739004
             + 95453.64529445693201812835532091*y
             + 58740.70479658888124192514173594*z))
             + y*(36406.999327052483686401520138423
             - 63635.7635296379546787522368806*z
             + y*(-103408.11573566167635297238493098
             + 66083.29289616249139716578445294*y
             + 132166.58579232498279433156890587*z)));
            return;
          case ( 48 ):
            grad[0]= 482.6593001279473947602682307935
             + z*(-5429.9171264394081910530175964269
             + (12669.806628358619112457041058329
             - 7843.213627079145164854358750394*z)*z)
             + y*(-5429.9171264394081910530175964269
             + z*(55747.149164777924094810980656649
             + z*(-117648.20440618717747281538125592
             + 65159.00551727289829263621115712*z))
             + y*(12669.806628358619112457041058329
             + y*(-10980.499077910803230796102250552
             + 3257.9502758636449146318105578561*y
             + 39095.403310363738975581726694274*z)
             + z*(-89412.635348702254879339689754496
             + 97738.50827590934743895431673568*z)))
             + x*(-3257.9502758636449146318105578561
             + z*(28235.56905748492259347569150142
             + z*(-45249.309386995068258775146636891
             + 14479.779003838421842808046923805*z))
             + x*(6877.8950268232503753338222888074
             + x*(-5912.5764265673555858132858272204
             + 1809.9723754798027303510058654756*x
             + 17375.734804606106211369656308566*y
             + 17375.734804606106211369656308566*z)
             + z*(-40181.386735651620613792330213559
             + 32579.502758636449146318105578561*z)
             + y*(-40181.386735651620613792330213559
             + 32579.502758636449146318105578561*y
             + 143349.81213800037624379966454567*z))
             + y*(28235.56905748492259347569150142
             + y*(-45249.309386995068258775146636891
             + 20271.690605373790579931265693327*y
             + 165069.48064375800900801173493138*z)
             + z*(-199096.96130277830033861064520232
             + 217196.68505757632764212070385708*z)));
            grad[1]= 361.99447509596054607020117309513
             + y*(-1809.9723754798027303510058654756
             + y*(2533.9613256717238224914082116659
             - 1085.9834252878816382106035192854*y
             - 9773.850827590934743895431673568*z)
             + (13755.790053646500750667644577615
             - 16289.751379318224573159052789281*z)*z)
             + z*(-3981.9392260555660067722129040464
             + (9049.8618773990136517550293273782
             - 5429.917126439408191053017596427*z)*z)
             + x*(-5429.9171264394081910530175964269
             + z*(55747.149164777924094810980656649
             + z*(-117648.20440618717747281538125592
             + 65159.00551727289829263621115712*z))
             + x*(14117.78452874246129673784575071
             + x*(-13393.79557855054020459744340452
             + 4343.9337011515265528424140771415*x
             + 21719.668505757632764212070385708*y
             + 47783.270712666792081266554848557*z)
             + z*(-99548.48065138915016930532260116
             + 108598.34252878816382106035192854*z)
             + y*(-45249.309386995068258775146636891
             + 30407.535908060685869896898539991*y
             + 165069.48064375800900801173493138*z))
             + y*(25339.613256717238224914082116659
             + y*(-32941.497233732409692388306751657
             + 13031.801103454579658527242231425*y
             + 117286.20993109121692674518008282*z)
             + z*(-178825.27069740450975867937950899
             + 195477.01655181869487790863347137*z)));
            grad[2]= 361.99447509596054607020117309513
             + z*(-1809.9723754798027303510058654756
             + 1809.9723754798027303510058654756*z)
             + y*(-3981.9392260555660067722129040464
             + y*(6877.8950268232503753338222888074
             - 3257.9502758636449146318105578561*y
             - 16289.751379318224573159052789281*z)
             + (18099.723754798027303510058654756
             - 16289.751379318224573159052789281*z)*z)
             + x*(-5429.9171264394081910530175964269
             + (25339.613256717238224914082116659
             - 23529.640881237435494563076251183*z)*z
             + y*(55747.149164777924094810980656649
             + z*(-235296.40881237435494563076251183
             + 195477.01655181869487790863347137*z)
             + y*(-89412.635348702254879339689754496
             + 39095.403310363738975581726694274*y
             + 195477.01655181869487790863347137*z))
             + x*(14117.78452874246129673784575071
             + z*(-45249.309386995068258775146636891
             + 21719.668505757632764212070385708*z)
             + x*(-13393.79557855054020459744340452
             + 4343.9337011515265528424140771415*x
             + 47783.270712666792081266554848557*y
             + 21719.668505757632764212070385708*z)
             + y*(-99548.48065138915016930532260116
             + 82534.74032187900450400586746569*y
             + 217196.68505757632764212070385708*z)));
            return;
          case ( 49 ):
            grad[0]= 547.28420404758622998530353227204
             + z*(-10261.578825892241812224441230101
             + z*(43098.631068747415611342653166423
             + z*(-62253.578210412933660828276795945
             + 28732.420712498277074228435444282*z)))
             + y*(-2052.3157651784483624448882460202
             + y*(2873.2420712498277074228435444282
             + y*(-1778.6736631546552474522364798841
             + 410.46315303568967248897764920403*y
             + 8209.263060713793449779552984081*z)
             + z*(-26680.104947319828711783547198262
             + 36941.683773212070524007988428363*z))
             + z*(28732.420712498277074228435444282
             + z*(-80040.314841959486135350641594786
             + 57464.84142499655414845687088856*z)))
             + x*(-3694.1683773212070524007988428363
             + x*(7798.7999076781037772905753348766
             + x*(-6704.2314995829313173199682703325
             + 2052.3157651784483624448882460202*x
             + 6567.410448571034759823642387265*y
             + 32837.052242855173799118211936323*z)
             + y*(-15187.136662320517882092173020549
             + 7388.336754642414104801597685673*y
             + 73883.36754642414104801597685673*z)
             + z*(-75935.683311602589410460865102746
             + 110825.05131963621157202396528509*z))
             + z*(53360.209894639657423567094396524
             + z*(-153923.68238838362718336661845151
             + 114929.68284999310829691374177713*z))
             + y*(10672.041978927931484713418879305
             + y*(-10261.578825892241812224441230101
             + 3283.7052242855173799118211936323*y
             + 49255.578364282760698677317904484*z)
             + z*(-102615.78825892241812224441230101
             + 147766.73509284828209603195371345*z)));
            grad[1]= 136.82105101189655749632588306801
             + y*(-410.46315303568967248897764920403
             + y*(410.46315303568967248897764920403
             - 136.82105101189655749632588306801*y
             - 2052.3157651784483624448882460202*z)
             + (4104.6315303568967248897764920403
             - 6156.94729553534508733466473806*z)*z)
             + z*(-2052.3157651784483624448882460202
             + (6156.9472955353450873346647380605
             - 4788.7367854163795123714059073804*z)*z)
             + x*(-2052.3157651784483624448882460202
             + z*(28732.420712498277074228435444282
             + z*(-80040.314841959486135350641594786
             + 57464.84142499655414845687088856*z))
             + y*(5746.4841424996554148456870888564
             + y*(-5336.0209894639657423567094396524
             + 1641.8526121427586899559105968161*y
             + 24627.789182141380349338658952242*z)
             + z*(-53360.209894639657423567094396524
             + 73883.36754642414104801597685673*z))
             + x*(5336.0209894639657423567094396524
             + x*(-5062.3788874401726273640576735164
             + 1641.8526121427586899559105968161*x
             + 4925.5578364282760698677317904484*y
             + 24627.789182141380349338658952242*z)
             + y*(-10261.578825892241812224441230101
             + 4925.5578364282760698677317904484*y
             + 49255.578364282760698677317904484*z)
             + z*(-51307.894129461209061122206150504
             + 73883.36754642414104801597685673*z)));
            grad[2]= 684.10525505948278748162941534005
             + y*(-2052.3157651784483624448882460202
             + y*(2052.3157651784483624448882460202
             - 684.1052550594827874816294153401*y
             - 6156.94729553534508733466473806*z)
             + (12313.894591070690174669329476121
             - 14366.210356249138537114217722141*z)*z)
             + z*(-6156.9472955353450873346647380605
             + (14366.210356249138537114217722141
             - 9577.473570832759024742811814761*z)*z)
             + x*(-10261.578825892241812224441230101
             + z*(86197.262137494831222685306332847
             + z*(-186760.73463123880098248483038783
             + 114929.68284999310829691374177713*z))
             + y*(28732.420712498277074228435444282
             + y*(-26680.104947319828711783547198262
             + 8209.263060713793449779552984081*y
             + 73883.36754642414104801597685673*z)
             + z*(-160080.62968391897227070128318957
             + 172394.52427498966244537061266569*z))
             + x*(26680.104947319828711783547198262
             + x*(-25311.894437200863136820288367582
             + 8209.263060713793449779552984081*x
             + 24627.789182141380349338658952242*y
             + 73883.36754642414104801597685673*z)
             + y*(-51307.894129461209061122206150504
             + 24627.789182141380349338658952242*y
             + 147766.73509284828209603195371345*z)
             + z*(-153923.68238838362718336661845151
             + 172394.52427498966244537061266569*z)));
            return;
          case ( 50 ):
            grad[0]= 62.449979983983982058468931209398
             + y*(-1748.5994395515514976371300738631
             + y*(10491.596637309308985822780443179
             + y*(-20983.193274618617971645560886358
             + 13114.495796636636232278475553974*y)))
             + x*(-249.79991993593592823387572483759
             + x*(374.69987990390389235081358725639
             + x*(-249.79991993593592823387572483759
             + 62.4499799839839820584689312094*x
             + 1748.5994395515514976371300738631*y)
             + y*(-5245.7983186546544929113902215894
             + 10491.596637309308985822780443179*y))
             + y*(5245.7983186546544929113902215894
             + y*(-20983.193274618617971645560886358
             + 20983.193274618617971645560886358*y)));
            grad[1]= 437.14985988788787440928251846579
             + y*(-6994.3977582062059905485202954526
             + y*(31474.789911927926957468341329537
             + y*(-52457.983186546544929113902215894
             + 28851.890752600599711012646218742*y)))
             + x*(-1748.5994395515514976371300738631
             + x*(2622.8991593273272464556951107947
             + x*(-1748.5994395515514976371300738631
             + 437.14985988788787440928251846579*x
             + 6994.397758206205990548520295453*y)
             + y*(-20983.193274618617971645560886358
             + 31474.789911927926957468341329537*y))
             + y*(20983.193274618617971645560886358
             + y*(-62949.579823855853914936682659073
             + 52457.98318654654492911390221589*y)));
            grad[2]= 0;
            return;
          case ( 51 ):
            grad[0]= 108.16653826391967879357663802411
             - 173.06646122227148606972262083858*z
             + x*(-432.66615305567871517430655209646
             + 519.1993836668144582091678625158*z
             + x*(648.99922958351807276145982814469
             - 519.1993836668144582091678625158*z
             + x*(-432.66615305567871517430655209646
             + 108.16653826391967879357663802411*x
             + 2855.5966101674795201504232438366*y
             + 173.06646122227148606972262083858*z)
             + y*(-8566.7898305024385604512697315099
             + 16095.180893671248204484203737988*y
             + 4153.595069334515665673342900126*z))
             + y*(8566.7898305024385604512697315099
             - 8307.190138669031331346685800252*z
             + y*(-32190.361787342496408968407475977
             + 30113.564252675238576131736025914*y
             + 18691.177812005320495530043050567*z)))
             + y*(-2855.5966101674795201504232438366
             + 4153.595069334515665673342900126*z
             + y*(16095.180893671248204484203737988
             - 18691.177812005320495530043050567*z
             + y*(-30113.564252675238576131736025914
             + 17522.979198754987964559415359907*y
             + 20767.97534667257832836671450063*z)));
            grad[1]= 713.89915254186988003760581095916
             - 1384.5316897781718885577809667087*z
             + y*(-10730.120595780832136322802491992
             + 18691.177812005320495530043050567*z
             + y*(45170.34637901285786419760403887
             - 62303.92604001773498510014350189*z
             + y*(-70091.916795019951858237661439626
             + 35694.957627093494001880290547958*y
             + 57111.93220334959040300846487673*z)))
             + x*(-2855.5966101674795201504232438366
             + 4153.595069334515665673342900126*z
             + x*(4283.3949152512192802256348657549
             - 4153.595069334515665673342900126*z
             + x*(-2855.5966101674795201504232438366
             + 713.8991525418698800376058109592*x
             + 10730.120595780832136322802491992*y
             + 1384.5316897781718885577809667087*z)
             + y*(-32190.361787342496408968407475977
             + 45170.34637901285786419760403887*y
             + 18691.177812005320495530043050567*z))
             + y*(32190.361787342496408968407475977
             - 37382.355624010640991060086101134*z
             + y*(-90340.692758025715728395208077741
             + 70091.91679501995185823766143963*y
             + 62303.92604001773498510014350189*z)));
            grad[2]= 43.266615305567871517430655209646
             + y*(-1384.5316897781718885577809667087
             + y*(9345.5889060026602477650215252835
             + y*(-20767.97534667257832836671450063
             + 14277.983050837397600752116219183*y)))
             + x*(-173.06646122227148606972262083858
             + x*(259.59969183340722910458393125788
             + x*(-173.06646122227148606972262083858
             + 43.266615305567871517430655209646*x
             + 1384.5316897781718885577809667087*y)
             + y*(-4153.595069334515665673342900126
             + 9345.588906002660247765021525284*y))
             + y*(4153.595069334515665673342900126
             + y*(-18691.177812005320495530043050567
             + 20767.97534667257832836671450063*y)));
            return;
          case ( 52 ):
            grad[0]= 139.64240043768941169883924541086
             + z*(-670.28352210090917615442837797215
             + 502.7126415756818821158212834791*z)
             + y*(-3239.703690154394351413070493532
             + (14075.953964119092699242995937415
             - 9048.827548362273878084783102624*z)*z
             + y*(15919.233649896592933667673976838
             + z*(-54292.965290173643268508698615744
             + 22622.06887090568469521195775656*z)
             + y*(-25805.915600885003281945492551928
             + 12986.74324070511528799204982321*y
             + 50271.26415756818821158212834791*z)))
             + x*(-558.56960175075764679535698164346
             + (2010.8505663027275284632851339164
             - 1005.4252831513637642316425669582*z)*z
             + x*(837.85440262613647019303547246518
             + z*(-2010.8505663027275284632851339164
             + 502.7126415756818821158212834791*z)
             + x*(-558.56960175075764679535698164346
             + 139.64240043768941169883924541086*x
             + 3239.703690154394351413070493532*y
             + 670.2835221009091761544283779721*z)
             + y*(-9719.1110704631830542392114805961
             + 15919.233649896592933667673976838*y
             + 14075.953964119092699242995937415*z))
             + y*(9719.1110704631830542392114805961
             + z*(-28151.90792823818539848599187483
             + 9048.827548362273878084783102624*z)
             + y*(-31838.467299793185867335347953677
             + 25805.915600885003281945492551928*y
             + 54292.96529017364326850869861574*z)));
            grad[1]= 809.92592253859858785326762338301
             + z*(-4691.984654706364233080998645805
             + 4524.413774181136939042391551312*z)
             + y*(-10612.822433264395289111782651226
             + (54292.965290173643268508698615744
             - 45244.13774181136939042391551312*z)*z
             + y*(38708.873401327504922918238827891
             + z*(-150813.79247270456463474638504373
             + 82947.58585998751054911051177405*z)
             + y*(-51946.972962820461151968199292841
             + 23040.996072218752930308475492793*y
             + 110596.7811466500140654806823654*z)))
             + x*(-3239.703690154394351413070493532
             + (14075.953964119092699242995937415
             - 9048.827548362273878084783102624*z)*z
             + x*(4859.5555352315915271196057402981
             + z*(-14075.953964119092699242995937415
             + 4524.413774181136939042391551312*z)
             + x*(-3239.703690154394351413070493532
             + 809.925922538598587853267623383*x
             + 10612.822433264395289111782651226*y
             + 4691.984654706364233080998645805*z)
             + y*(-31838.467299793185867335347953677
             + 38708.873401327504922918238827891*y
             + 54292.96529017364326850869861574*z))
             + y*(31838.467299793185867335347953677
             + z*(-108585.93058034728653701739723149
             + 45244.13774181136939042391551312*z)
             + y*(-77417.746802655009845836477655783
             + 51946.97296282046115196819929284*y
             + 150813.79247270456463474638504373*z)));
            grad[2]= 167.57088052522729403860709449304
             - 335.14176105045458807721418898607*z
             + x*(-670.28352210090917615442837797215
             + 1005.4252831513637642316425669582*z
             + x*(1005.4252831513637642316425669582
             - 1005.4252831513637642316425669582*z
             + x*(-670.28352210090917615442837797215
             + 167.57088052522729403860709449304*x
             + 4691.984654706364233080998645805*y
             + 335.14176105045458807721418898607*z)
             + y*(-14075.953964119092699242995937415
             + 27146.482645086821634254349307872*y
             + 9048.827548362273878084783102624*z))
             + y*(14075.953964119092699242995937415
             - 18097.655096724547756169566205248*z
             + y*(-54292.965290173643268508698615744
             + 50271.26415756818821158212834791*y
             + 45244.13774181136939042391551312*z)))
             + y*(-4691.984654706364233080998645805
             + 9048.827548362273878084783102624*z
             + y*(27146.482645086821634254349307872
             - 45244.13774181136939042391551312*z
             + y*(-50271.264157568188211582128347911
             + 27649.195286662503516370170591351*y
             + 55298.3905733250070327403411827*z)));
            return;
          case ( 53 ):
            grad[0]= 165.22711641858306061817426312616
             + z*(-1586.1803176183973819344729260112
             + (2974.0880955344950911271367362709
             - 1321.8169313486644849453941050093*z)*z)
             + y*(-3040.1789421019283153744064415214
             + z*(26171.975240703556801918803279184
             + z*(-41637.233337482931275779914307793
             + 13218.169313486644849453941050093*z))
             + y*(11698.079842435680691766737829332
             + y*(-14936.531324239908679882953386605
             + 6113.403307487573242872447735668*y
             + 51550.86032259791491287037009536*z)
             + z*(-76136.655245683074332854700448536
             + 74352.20238836237727817841840677*z)))
             + x*(-660.90846567433224247269705250465
             + z*(4758.5409528551921458034187780335
             + z*(-5948.1761910689901822542734725418
             + 1321.8169313486644849453941050093*z))
             + x*(991.36269851149836370904557875697
             + x*(-660.90846567433224247269705250465
             + 165.22711641858306061817426312616*x
             + 3040.1789421019283153744064415214*y
             + 1586.1803176183973819344729260112*z)
             + z*(-4758.5409528551921458034187780335
             + 2974.0880955344950911271367362709*z)
             + y*(-9120.5368263057849461232193245642
             + 11698.079842435680691766737829332*y
             + 26171.975240703556801918803279184*z))
             + y*(9120.5368263057849461232193245642
             + z*(-52343.950481407113603837606558368
             + 41637.233337482931275779914307793*z)
             + y*(-23396.159684871361383533475658665
             + 14936.531324239908679882953386605*y
             + 76136.65524568307433285470044854*z)));
            grad[1]= 760.04473552548207884360161038035
             + z*(-8723.9917469011856006396010930614
             + (20818.616668741465637889957153896
             - 13218.169313486644849453941050093*z)*z)
             + x*(-3040.1789421019283153744064415214
             + z*(26171.975240703556801918803279184
             + z*(-41637.233337482931275779914307793
             + 13218.169313486644849453941050093*z))
             + x*(4560.2684131528924730616096622821
             + x*(-3040.1789421019283153744064415214
             + 760.0447355254820788436016103803*x
             + 7798.719894957120461177825219555*y
             + 8723.991746901185600639601093061*z)
             + z*(-26171.975240703556801918803279184
             + 20818.616668741465637889957153896*z)
             + y*(-23396.159684871361383533475658665
             + 22404.796986359863019824430079908*y
             + 76136.65524568307433285470044854*z))
             + y*(23396.159684871361383533475658665
             + z*(-152273.31049136614866570940089707
             + 148704.40477672475455635683681355*z)
             + y*(-44809.593972719726039648860159815
             + 24453.613229950292971489790942672*y
             + 154652.58096779374473861111028609*z)))
             + y*(-7798.7198949571204611778252195549
             + z*(76136.655245683074332854700448536
             + z*(-148704.40477672475455635683681355
             + 72699.93122417654667199667577551*z))
             + y*(22404.796986359863019824430079908
             + y*(-24453.613229950292971489790942672
             + 9087.491403022068333999584471939*y
             + 87239.91746901185600639601093061*z)
             + z*(-154652.58096779374473861111028609
             + 163574.8452543972300119925204949*z)));
            grad[2]= 396.54507940459934548361823150279
             + z*(-1982.7253970229967274180911575139
             + 1982.7253970229967274180911575139*z)
             + y*(-8723.9917469011856006396010930614
             + (41637.233337482931275779914307793
             - 39654.507940459934548361823150279*z)*z
             + y*(38068.327622841537166427350224268
             + z*(-148704.40477672475455635683681355
             + 109049.89683626482000799501366327*z)
             + y*(-51550.860322597914912870370095363
             + 21809.979367252964001599002732653*y
             + 109049.89683626482000799501366327*z)))
             + x*(-1586.1803176183973819344729260112
             + (5948.1761910689901822542734725418
             - 3965.4507940459934548361823150279*z)*z
             + x*(2379.2704764275960729017093890167
             + z*(-5948.1761910689901822542734725418
             + 1982.7253970229967274180911575139*z)
             + x*(-1586.1803176183973819344729260112
             + 396.54507940459934548361823150279*x
             + 8723.991746901185600639601093061*y
             + 1982.7253970229967274180911575139*z)
             + y*(-26171.975240703556801918803279184
             + 38068.327622841537166427350224268*y
             + 41637.233337482931275779914307793*z))
             + y*(26171.975240703556801918803279184
             + z*(-83274.466674965862551559828615586
             + 39654.507940459934548361823150279*z)
             + y*(-76136.655245683074332854700448536
             + 51550.86032259791491287037009536*y
             + 148704.40477672475455635683681355*z)));
            return;
          case ( 54 ):
            grad[0]= 187.34993995195194617540679362819
             + z*(-2997.5990392312311388065086980511
             + z*(10116.896757405405093471966855922
             + z*(-10491.596637309308985822780443179
             + 2622.8991593273272464556951107947*z)))
             + y*(-2248.1992794234233541048815235383
             + z*(31474.789911927926957468341329537
             + z*(-87679.771897513510810090379417995
             + 62949.57982385585391493668265907*z))
             + y*(5620.4981985585583852622038088458
             + y*(-5245.7983186546544929113902215894
             + 1686.1494595675675155786611426537*y
             + 25479.591833465464679855323933434*z)
             + z*(-53956.78270616216049851715656492
             + 77562.87514010810571661841256207*z)))
             + x*(-749.39975980780778470162717451278
             + z*(8992.7971176936934164195260941533
             + z*(-20233.793514810810186943933711845
             + 10491.596637309308985822780443179*z))
             + x*(1124.0996397117116770524407617692
             + x*(-749.39975980780778470162717451278
             + 187.34993995195194617540679362819*x
             + 2248.1992794234233541048815235383*y
             + 2997.5990392312311388065086980511*z)
             + z*(-8992.7971176936934164195260941533
             + 10116.896757405405093471966855922*z)
             + y*(-6744.597838270270062314644570615
             + 5620.498198558558385262203808846*y
             + 31474.789911927926957468341329537*z))
             + y*(6744.597838270270062314644570615
             + y*(-11240.996397117116770524407617692
             + 5245.798318654654492911390221589*y
             + 53956.78270616216049851715656492*z)
             + z*(-62949.579823855853914936682659073
             + 87679.77189751351081009037941799*z)));
            grad[1]= 562.04981985585583852622038088458
             + z*(-10491.596637309308985822780443179
             + z*(43839.885948756755405045189708997
             + z*(-62949.579823855853914936682659073
             + 28851.890752600599711012646218742*z)))
             + y*(-3746.9987990390389235081358725639
             + y*(7868.6974779819817393670853323841
             + y*(-6744.597838270270062314644570615
             + 2060.8493394714714079294747299101*y
             + 32973.589431543542526871595678562*z)
             + z*(-76438.775500396394039565971800303
             + 111285.86433145945602819163541515*z))
             + z*(53956.78270616216049851715656492
             + z*(-155125.75028021621143323682512414
             + 115407.56301040239884405058487497*z)))
             + x*(-2248.1992794234233541048815235383
             + x*(3372.2989191351350311573222853075
             + x*(-2248.1992794234233541048815235383
             + 562.0498198558558385262203808846*x
             + 3746.9987990390389235081358725639*y
             + 10491.596637309308985822780443179*z)
             + z*(-31474.789911927926957468341329537
             + 43839.885948756755405045189708997*z)
             + y*(-11240.996397117116770524407617692
             + 7868.697477981981739367085332384*y
             + 53956.78270616216049851715656492*z))
             + z*(31474.789911927926957468341329537
             + z*(-87679.771897513510810090379417995
             + 62949.57982385585391493668265907*z))
             + y*(11240.996397117116770524407617692
             + y*(-15737.394955963963478734170664768
             + 6744.597838270270062314644570615*y
             + 76438.7755003963940395659718003*z)
             + z*(-107913.56541232432099703431312984
             + 155125.75028021621143323682512414*z)));
            grad[2]= 749.39975980780778470162717451278
             + z*(-6744.597838270270062314644570615
             + (15737.394955963963478734170664768
             - 10491.596637309308985822780443179*z)*z)
             + y*(-10491.596637309308985822780443179
             + z*(87679.771897513510810090379417995
             + z*(-188848.73947156756174481004797722
             + 115407.56301040239884405058487497*z))
             + y*(26978.39135308108024925857828246
             + y*(-25479.591833465464679855323933434
             + 8243.397357885885631717898919641*y
             + 74190.57622097297068546109027676*z)
             + z*(-155125.75028021621143323682512414
             + 173111.34451560359826607587731245*z)))
             + x*(-2997.5990392312311388065086980511
             + z*(20233.793514810810186943933711845
             + z*(-31474.789911927926957468341329537
             + 10491.596637309308985822780443179*z))
             + x*(4496.3985588468467082097630470767
             + x*(-2997.5990392312311388065086980511
             + 749.3997598078077847016271745128*x
             + 10491.596637309308985822780443179*y
             + 6744.597838270270062314644570615*z)
             + z*(-20233.793514810810186943933711845
             + 15737.394955963963478734170664768*z)
             + y*(-31474.789911927926957468341329537
             + 26978.39135308108024925857828246*y
             + 87679.77189751351081009037941799*z))
             + y*(31474.789911927926957468341329537
             + y*(-53956.78270616216049851715656492
             + 25479.591833465464679855323933434*y
             + 155125.75028021621143323682512414*z)
             + z*(-175359.54379502702162018075883599
             + 188848.73947156756174481004797722*z)));
            return;
          case ( 55 ):
            grad[0]= 207.12315177207979132157176344048
             + z*(-4970.9556425299149917177223225716
             + z*(26097.517123282053706518042193501
             + z*(-46395.585996945873256032075010668
             + 26097.517123282053706518042193501*z)))
             + y*(-828.49260708831916528628705376193
             + y*(1242.7389106324787479294305806429
             + y*(-828.49260708831916528628705376193
             + 207.12315177207979132157176344048*y
             + 4970.9556425299149917177223225716*z)
             + z*(-14912.866927589744975153166967715
             + 26097.517123282053706518042193501*z))
             + z*(14912.866927589744975153166967715
             + z*(-52195.034246564107413036084387001
             + 46395.585996945873256032075010668*z)))
             + x*(-828.49260708831916528628705376193
             + x*(1242.7389106324787479294305806429
             + x*(-828.49260708831916528628705376193
             + 207.12315177207979132157176344048*x
             + 828.4926070883191652862870537619*y
             + 4970.9556425299149917177223225716*z)
             + y*(-2485.4778212649574958588611612858
             + 1242.7389106324787479294305806429*y
             + 14912.866927589744975153166967715*z)
             + z*(-14912.866927589744975153166967715
             + 26097.517123282053706518042193501*z))
             + z*(14912.866927589744975153166967715
             + z*(-52195.034246564107413036084387001
             + 46395.585996945873256032075010668*z))
             + y*(2485.4778212649574958588611612858
             + y*(-2485.4778212649574958588611612858
             + 828.4926070883191652862870537619*y
             + 14912.866927589744975153166967715*z)
             + z*(-29825.733855179489950306333935429
             + 52195.034246564107413036084387*z)));
            grad[1]= 207.12315177207979132157176344048
             + z*(-4970.9556425299149917177223225716
             + z*(26097.517123282053706518042193501
             + z*(-46395.585996945873256032075010668
             + 26097.517123282053706518042193501*z)))
             + y*(-828.49260708831916528628705376193
             + y*(1242.7389106324787479294305806429
             + y*(-828.49260708831916528628705376193
             + 207.12315177207979132157176344048*y
             + 4970.9556425299149917177223225716*z)
             + z*(-14912.866927589744975153166967715
             + 26097.517123282053706518042193501*z))
             + z*(14912.866927589744975153166967715
             + z*(-52195.034246564107413036084387001
             + 46395.585996945873256032075010668*z)))
             + x*(-828.49260708831916528628705376193
             + x*(1242.7389106324787479294305806429
             + x*(-828.49260708831916528628705376193
             + 207.12315177207979132157176344048*x
             + 828.4926070883191652862870537619*y
             + 4970.9556425299149917177223225716*z)
             + y*(-2485.4778212649574958588611612858
             + 1242.7389106324787479294305806429*y
             + 14912.866927589744975153166967715*z)
             + z*(-14912.866927589744975153166967715
             + 26097.517123282053706518042193501*z))
             + z*(14912.866927589744975153166967715
             + z*(-52195.034246564107413036084387001
             + 46395.585996945873256032075010668*z))
             + y*(2485.4778212649574958588611612858
             + y*(-2485.4778212649574958588611612858
             + 828.4926070883191652862870537619*y
             + 14912.866927589744975153166967715*z)
             + z*(-29825.733855179489950306333935429
             + 52195.034246564107413036084387*z)));
            grad[2]= 1242.7389106324787479294305806429
             + z*(-17398.344748854702471012028129
             + z*(69593.378995418809884048112516002
             + z*(-104390.068493128214826072168774
             + 52195.034246564107413036084387*z)))
             + y*(-4970.9556425299149917177223225716
             + y*(7456.4334637948724875765834838573
             + y*(-4970.9556425299149917177223225716
             + 1242.7389106324787479294305806429*y
             + 17398.344748854702471012028129*z)
             + z*(-52195.034246564107413036084387001
             + 69593.378995418809884048112516*z))
             + z*(52195.034246564107413036084387001
             + z*(-139186.757990837619768096225032
             + 104390.068493128214826072168774*z)))
             + x*(-4970.9556425299149917177223225716
             + x*(7456.4334637948724875765834838573
             + x*(-4970.9556425299149917177223225716
             + 1242.7389106324787479294305806429*x
             + 4970.9556425299149917177223225716*y
             + 17398.344748854702471012028129*z)
             + y*(-14912.866927589744975153166967715
             + 7456.433463794872487576583483857*y
             + 52195.034246564107413036084387*z)
             + z*(-52195.034246564107413036084387001
             + 69593.378995418809884048112516*z))
             + z*(52195.034246564107413036084387001
             + z*(-139186.757990837619768096225032
             + 104390.068493128214826072168774*z))
             + y*(14912.866927589744975153166967715
             + y*(-14912.866927589744975153166967715
             + 4970.9556425299149917177223225716*y
             + 52195.034246564107413036084387*z)
             + z*(-104390.068493128214826072168774
             + 139186.757990837619768096225032*z)));
             return;
          #endif
          #if (PMAX3D>=6)
          case ( 56 ):
            grad[0]= -295.77018105278970126676368271243
             + x*(7394.2545263197425316690920678108
             + x*(-54224.533193011445232240008497279
             + x*(162673.59957903433569672002549184
             + x*(-211475.67945274463640573603313939
             + 98688.65041128083032267681546505*x))));
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 57 ):
            grad[0]= -395.0443013131565222882850707778
             + 1161.8950038622250655537796199347*y
             + x*(9295.1600308978005244302369594778
             - 25561.690084968951442183151638564*y
             + x*(-63904.22521242237860545787909641
             + 153370.14050981370865309890983138*y
             + x*(178931.83059478266009528206146995
             - 332301.97110459636874838097130133*y
             + x*(-215996.28121798763968644763134586
             + 93044.55190928698324954667196437*x
             + 232611.37977321745812386667991093*y))));
            grad[1]= -23.237900077244501311075592398694
             + x*(1161.8950038622250655537796199347
             + x*(-12780.845042484475721091575819282
             + x*(51123.380169937902884366303277128
             + x*(-83075.492776149092187095242825332
             + 46522.275954643491624773335982186*x))));
            grad[2]= 0;
            return;
          case ( 58 ):
            grad[0]= -684.23680111493564710120714263177
             + 670.8203932499369089227521006194*y
             + 1341.6407864998738178455042012388*z
             + x*(16099.689437998485814146050414865
             - 14758.048651498611996300546213626*y
             - 29516.097302997223992601092427253*z
             + x*(-110685.3648862395899722540966022
             + 88548.29190899167197780327728176*y
             + 177096.58381798334395560655456352*z
             + x*(309919.02168147085192231147048615
             - 191854.63246948195595190710077714*y
             - 383709.26493896391190381420155429*z
             + x*(-374116.53331548981410621884651543
             + 161157.8912743648429996019646528*x
             + 134298.242728637369166334970544*y
             + 268596.485457274738332669941088*z))));
            grad[1]= -13.416407864998738178455042012388
             + x*(670.82039324993690892275210061938
             + x*(-7379.0243257493059981502731068132
             + x*(29516.097302997223992601092427253
             + x*(-47963.658117370488987976775194286
             + 26859.6485457274738332669941088*x))));
            grad[2]= -26.832815729997476356910084024775
             + x*(1341.6407864998738178455042012388
             + x*(-14758.048651498611996300546213626
             + x*(59032.194605994447985202184854506
             + x*(-95927.316234740977975953550388572
             + 53719.2970914549476665339882176*x))));
            return;
          case ( 59 ):
            grad[0]= -436.39431710323634781584730913172
             + (3415.2598729818496785588050279873
             - 4174.2065114222607182385394786512*y)*y
             + x*(9202.2279910899838561167802142992
             + y*(-66787.304182756171491816631658419
             + 75135.71720560069292829371061572*y)
             + x*(-56351.787904200519696220282961791
             + (350633.3469594699003320373162067
             - 325588.10789093633602260607933479*y)*y
             + x*(139835.91813264573406099107253481
             + y*(-651176.21578187267204521215866959
             + 379852.79253942572535970709255726*y)
             + x*(-149227.88278334582067702778636178
             + 56977.91888091385880395606388359*x
             + 379852.79253942572535970709255726*y))));
            grad[1]= -75.894663844041103967973445066385
             + 189.73665961010275991993361266596*y
             + x*(3415.2598729818496785588050279873
             - 8348.413022844521436477078957302*y
             + x*(-33393.65209137808574590831582921
             + 75135.71720560069292829371061572*y
             + x*(116877.78231982330011067910540223
             - 217058.73859395755734840405288986*y
             + x*(-162794.0539454681680113030396674
             + 75970.55850788514507194141851145*x
             + 189926.39626971286267985354627863*y))));
            grad[2]= 0;
            return;
          case ( 60 ):
            grad[0]= -755.85712935712923657061830026511
             + y*(4436.5527157918455190014552406865
             - 3614.9688795340963488160005664853*y
             - 7229.937759068192697632001132971*z)
             + 1478.8509052639485063338184135622*z
             + x*(15938.726423400333901597820679503
             - 28919.751036272770790528004531882*z
             + y*(-86759.253108818312371584013595647
             + 65069.43983161373427868801019674*y
             + 130138.87966322746855737602039347*z)
             + x*(-97604.159747420601418032015295103
             + y*(455486.07882129613995081607137715
             - 281967.57260365951520764804418585*y
             - 563935.1452073190304152960883717*z)
             + 151828.69294043204665027202379238*z
             + x*(242202.91492878445537067203795451
             - 281967.57260365951520764804418585*z
             + x*(-258470.2748866878889403440405037
             + 98688.65041128083032267681546505*x
             + 493443.25205640415161338407732524*y
             + 164481.08401880138387112802577508*z)
             + y*(-845902.71781097854562294413255756
             + 328962.16803760276774225605155016*y
             + 657924.3360752055354845121031003*z))));
            grad[1]= -98.590060350929900422254560904144
             + 164.31676725154983403709093484024*y
             + 164.31676725154983403709093484024*z
             + x*(4436.5527157918455190014552406865
             - 7229.937759068192697632001132971*y
             - 7229.937759068192697632001132971*z
             + x*(-43379.626554409156185792006797824
             + 65069.43983161373427868801019674*y
             + 65069.43983161373427868801019674*z
             + x*(151828.69294043204665027202379238
             - 187978.38173577301013843202945724*y
             - 187978.38173577301013843202945724*z
             + x*(-211475.67945274463640573603313939
             + 98688.65041128083032267681546505*x
             + 164481.08401880138387112802577508*y
             + 164481.08401880138387112802577508*z))));
            grad[2]= -32.863353450309966807418186968048
             + 164.31676725154983403709093484024*y
             + x*(1478.8509052639485063338184135622
             - 7229.937759068192697632001132971*y
             + x*(-14459.875518136385395264002265941
             + 65069.43983161373427868801019674*y
             + x*(50609.564313477348883424007930794
             - 187978.38173577301013843202945724*y
             + x*(-70491.893150914878801912011046463
             + 32896.216803760276774225605155016*x
             + 164481.08401880138387112802577508*y))));
            return;
          case ( 61 ):
            grad[0]= -975.80735803743558367316521970469
             + y*(1909.1883092036783158822797776831
             - 933.3809511662427322091145579784*y
             - 5600.28570699745639325468734787*z)
             + (5727.5649276110349476468393330493
             - 5600.28570699745639325468734787*z)*z
             + x*(20576.807332528532960064570937251
             + z*(-112005.71413994912786509374695741
             + 100805.14272595421507858437226167*z)
             + y*(-37335.238046649709288364582319136
             + 16800.857120992369179764062043611*y
             + 100805.14272595421507858437226167*z)
             + x*(-126006.42840744276884823046532708
             + y*(196009.99974491097376391405717546
             - 72803.71419096693311231093552232*y
             - 436822.28514580159867386561313389*z)
             + (588029.99923473292129174217152639
             - 436822.28514580159867386561313389*z)*z
             + x*(312682.61864069131529005337692276
             + z*(-1.0920557128645039966846640328347e6
             + 509625.9993367685317861765486562*z)
             + y*(-364018.57095483466556155467761158
             + 84937.66655612808863102942477603*y
             + 509625.9993367685317861765486562*z)
             + x*(-333683.69004193177676475845447728
             + 127406.49983419213294654413716405*x
             + 212344.16639032022157757356194009*y
             + 637032.4991709606647327206858203*z))));
            grad[1]= -42.426406871192851464050661726291
             + 42.426406871192851464050661726291*y
             + 127.27922061357855439215198517887*z
             + x*(1909.1883092036783158822797776831
             - 1866.7619023324854644182291159568*y
             - 5600.28570699745639325468734787*z
             + x*(-18667.619023324854644182291159568
             + 16800.857120992369179764062043611*y
             + 50402.57136297710753929218613083*z
             + x*(65336.666581636991254638019058488
             - 48535.809460644622074873957014877*y
             - 145607.42838193386622462187104463*z
             + x*(-91004.642738708666390388669402894
             + 42468.833278064044315514712388017*x
             + 42468.833278064044315514712388017*y
             + 127406.49983419213294654413716405*z))));
            grad[2]= -127.27922061357855439215198517887
             + 127.27922061357855439215198517887*y
             + 254.55844122715710878430397035775*z
             + x*(5727.5649276110349476468393330493
             - 5600.28570699745639325468734787*y
             - 11200.571413994912786509374695741*z
             + x*(-56002.857069974563932546873478704
             + 50402.57136297710753929218613083*y
             + 100805.14272595421507858437226167*z
             + x*(196009.99974491097376391405717546
             - 145607.42838193386622462187104463*y
             - 291214.85676386773244924374208926*z
             + x*(-273013.92821612599917116600820868
             + 127406.49983419213294654413716405*x
             + 127406.49983419213294654413716405*y
             + 254812.9996683842658930882743281*z))));
            return;
          case ( 62 ):
            grad[0]= -427.22359485402956849643643058463
             + y*(6244.0371555588936934094555239291
             + y*(-18239.161164922031578117093767267
             + 13802.60844913018605911563852658*y))
             + x*(7558.5712935712923657061830026511
             + y*(-100890.49509245159809877383399191
             + (266193.16294751073114008731444119
             - 179433.90983869241876850330084554*y)*y)
             + x*(-38614.440304114210998716369687457
             + y*(427880.86192303576783258479432399
             + y*(-884352.84134784120678762341131018
             + 418679.12295694897712650770197293*y))
             + x*(80186.582418756319010100376202037
             + x*(-72628.011125185026644394193199386
             + 23924.521311825655835800440112739*x
             + 299056.51639782069794750550140924*y)
             + y*(-632290.92038396376137472591726525
             + 717735.6393547696750740132033822*y))));
            grad[1]= -164.31676725154983403709093484024
             + (985.90060350929900422254560904144
             - 1150.2173707608488382596365438817*y)*y
             + x*(6244.0371555588936934094555239291
             + y*(-36478.322329844063156234187534533
             + 41407.825347390558177346915579741*y)
             + x*(-50445.247546225799049386916995954
             + (266193.16294751073114008731444119
             - 269150.86475803862815275495126831*y)*y
             + x*(142626.95397434525594419493144133
             + x*(-158072.73009599094034368147931631
             + 59811.30327956413958950110028185*x
             + 358867.81967738483753700660169109*y)
             + y*(-589568.56089856080452508227420678
             + 418679.12295694897712650770197293*y))));
            grad[2]= 0;
            return;
          case ( 63 ):
            grad[0]= -739.97297247940076368774108939726
             + 1441.9986130367809753914954562613*z
             + y*(9372.9909847390763400447204656986
             - 16848.615373377125080890104804738*z
             + y*(-23166.846138393546986223894106514
             + 14344.091466523768649946981117547*y
             + 28688.182933047537299893962235094*z))
             + x*(13091.829513097090434475419273951
             - 23299.66180012061891816784763538*z
             + y*(-151447.80170078402296809100962997
             + y*(338110.72742520311817732169777075
             - 186473.18906480899244931075452811*y
             - 372946.37812961798489862150905622*z)
             + 245898.71085469317685623396201509*z)
             + x*(-66882.172512561222871776598464752
             + 98814.85232494151736630142547643*z
             + x*(138887.23483459522026139140447148
             - 146021.33323593508403438090830773*z
             + x*(-125795.40532149812982691598519753
             + 41438.486458846442766513501006246*x
             + 448916.93663750312997056292756767*y
             + 69064.14409807740461085583501041*z)
             + y*(-949138.66603357804622347590400021
             + 911646.7020946217408632970221374*y
             + 663015.7833415430842642160160999*z))
             + y*(642296.54011211986288095926559682
             - 816930.1616172584431112661626946*z
             + y*(-1.123278972223730359277990973705e6
             + 435104.10781788764904839176056559*y
             + 870208.2156357752980967835211312*z))));
            grad[1]= -246.65765749313358789591369646575
             + y*(1252.2619534266782154715618435954
             - 1195.3409555436473874955817597956*y
             - 1593.7879407248631833274423463941*z)
             + 455.36798306424662380784067039831*z
             + x*(9372.9909847390763400447204656986
             - 16848.615373377125080890104804738*z
             + y*(-46333.692276787093972447788213028
             + 43032.27439957130594984094335264*y
             + 57376.36586609507459978792447019*z)
             + x*(-75723.900850392011484045504814986
             + y*(338110.72742520311817732169777075
             - 279709.78359721348867396613179216*y
             - 372946.37812961798489862150905622*z)
             + 122949.35542734658842811698100754*z
             + x*(214098.84670403995429365308853227
             - 272310.05387241948103708872089819*z
             + x*(-237284.66650839451155586897600005
             + 89783.38732750062599411258551353*x
             + 455823.35104731087043164851106871*y
             + 165753.94583538577106605400402499*z)
             + y*(-748852.64814915357285199398247002
             + 435104.10781788764904839176056559*y
             + 580138.8104238501987311890140874*z))));
            grad[2]= -37.947331922020551983986722533193
             + (455.36798306424662380784067039831
             - 796.893970362431591663721173197*y)*y
             + x*(1441.9986130367809753914954562613
             + y*(-16848.615373377125080890104804738
             + 28688.182933047537299893962235094*y)
             + x*(-11649.83090006030945908392381769
             + (122949.35542734658842811698100754
             - 186473.18906480899244931075452811*y)*y
             + x*(32938.284108313839122100475158811
             + x*(-36505.333308983771008595227076931
             + 13812.828819615480922171167002082*x
             + 165753.94583538577106605400402499*y)
             + y*(-272310.05387241948103708872089819
             + 290069.40521192509936559450704372*y))));
            return;
          case ( 64 ):
            grad[0]= -955.3009996854394582969407891353
             + (5584.8366135456460638898076903294
             - 5437.867228978655377997970645847*z)*z
             + y*(8377.2549203184690958347115354941
             + z*(-43502.937831829243023983765166777
             + 37036.284910881652844742935209553*z)
             + y*(-13594.668072446638444994926614618
             + 6172.714151813608807457155868259*y
             + 37036.284910881652844742935209553*z))
             + x*(16901.479225203928877561260115471
             + z*(-90239.202124132281137587945312165
             + 79363.46766617497038159200402047*z)
             + y*(-135358.80318619842170638191796825
             + y*(198408.66916543742595398001005118
             - 80245.28397357691449694302628737*y
             - 481471.70384146148698165815772419*z)
             + (634907.74132939976305273603216377
             - 481471.70384146148698165815772419*z)*z)
             + x*(-86344.513433107027961454263633383
             + (382708.27741244374606234366383205
             - 263663.07591318129048995565780134*z)*z
             + y*(574062.41611866561909351549574807
             + z*(-2.1093046073054503239196452624107e6
             + 1.1234339756300768029572023680231e6*z)
             + y*(-659157.68978295322622488914450336
             + 187238.99593834613382620039467052*y
             + 1.1234339756300768029572023680231e6*z))
             + x*(179302.64917172863678804119426847
             + z*(-565538.1918137801593117889471681
             + 213987.42392953843865851473676631*z)
             + x*(-162401.169946524707910479934153
             + 53496.85598238460966462868419158*x
             + 401226.41986788457248471513143683*y
             + 267484.27991192304832314342095788*z)
             + y*(-848307.28772067023896768342075214
             + 534968.5598238460966462868419158*y
             + 1.7118993914363075092681178941305e6*z))));
            grad[1]= -220.45407685048602883775556672353
             + y*(734.84692283495342945918522241177
             - 514.3928459844674006214296556882*y
             - 2057.5713839378696024857186227529*z)
             + (1175.7550765359254871346963558588
             - 1028.7856919689348012428593113765*z)*z
             + x*(8377.2549203184690958347115354941
             + z*(-43502.937831829243023983765166777
             + 37036.284910881652844742935209553*z)
             + y*(-27189.336144893276889989853229235
             + 18518.142455440826422371467604777*y
             + 74072.56982176330568948587041911*z)
             + x*(-67679.401593099210853190958984124
             + y*(198408.66916543742595398001005118
             - 120367.92596036537174541453943105*y
             - 481471.70384146148698165815772419*z)
             + (317453.87066469988152636801608188
             - 240735.8519207307434908290788621*z)*z
             + x*(191354.13870622187303117183191602
             + z*(-703101.53576848344130654842080358
             + 374477.99187669226765240078934104*z)
             + x*(-212076.82193016755974192085518804
             + 80245.28397357691449694302628737*x
             + 267484.27991192304832314342095788*y
             + 427974.84785907687731702947353261*z)
             + y*(-439438.45985530215081659276300224
             + 187238.99593834613382620039467052*y
             + 748955.9837533845353048015786821*z))));
            grad[2]= -146.96938456699068589183704448235
             + y*(1175.7550765359254871346963558588
             - 1028.7856919689348012428593113765*y
             - 2057.5713839378696024857186227529*z)
             + 293.93876913398137178367408896471*z
             + x*(5584.8366135456460638898076903294
             - 10875.734457957310755995941291694*z
             + y*(-43502.937831829243023983765166777
             + 37036.284910881652844742935209553*y
             + 74072.56982176330568948587041911*z)
             + x*(-45119.601062066140568793972656083
             + y*(317453.87066469988152636801608188
             - 240735.8519207307434908290788621*y
             - 481471.70384146148698165815772419*z)
             + 79363.46766617497038159200402047*z
             + x*(127569.42580414791535411455461068
             - 175775.38394212086032663710520089*z
             + x*(-141384.54795344503982794723679202
             + 53496.85598238460966462868419158*x
             + 427974.84785907687731702947353261*y
             + 106993.71196476921932925736838315*z)
             + y*(-703101.53576848344130654842080358
             + 374477.99187669226765240078934104*y
             + 748955.9837533845353048015786821*z))));
            return;
          case ( 65 ):
            grad[0]= -1130.3273862027762087500558042592
             + z*(13216.135592524767979231421711339
             + z*(-32170.856376540553633655434428917
             + 20867.582514512791546154876386324*z))
             + y*(3304.0338981311919948078554278347
             + y*(-3217.0856376540553633655434428917
             + 1043.3791257256395773077438193162*y
             + 12520.549508707674927692925831795*z)
             + z*(-25736.685101232442906924347543134
             + 31301.373771769187319232314579487*z))
             + x*(19998.099909741425231731756536894
             + y*(-53386.231932961891705579558755013
             + y*(46952.06065765378097884847186923
             - 13563.928634433314505000669651111*y
             - 162767.14361319977406000803581333*z)
             + (375616.48526123024783078777495384
             - 406917.85903299943515002008953333*z)*z)
             + z*(-213544.92773184756682231823502005
             + (469520.6065765378097884847186923
             - 271278.57268866629010001339302222*z)*z)
             + x*(-102164.20606063554194471658230805
             + z*(905653.08112985515310312163516648
             + z*(-1.5598517929598311680750770098778e6
             + 632983.3362735546769000312503852*z))
             + y*(226413.27028246378827578040879162
             + y*(-155985.17929598311680750770098778
             + 31649.166813677733845001562519259*y
             + 379790.00176413280614001875023111*z)
             + z*(-1.2478814343678649344600616079022e6
             + 949475.0044103320153500468755778*z))
             + x*(212153.75556421338071924124326097
             + x*(-192155.65565447195548750948672407
             + 63298.33362735546769000312503852*x
             + 158245.83406838866922500781259629*y
             + 632983.3362735546769000312503852*z)
             + y*(-334576.90631602175779001651806074
             + 126596.66725471093538000625007704*y
             + 1.0127733380376874830400500006163e6*z)
             + z*(-1.3383076252640870311600660722429e6
             + 1.2659666725471093538000625007704e6*z))));
            grad[1]= -86.948260477136631442311984943019
             + y*(173.89652095427326288462396988604
             - 86.94826047713663144231198494302*y
             - 695.5860838170930515384958795441*z)
             + (695.58608381709305153849587954415
             - 869.4826047713663144231198494302*z)*z
             + x*(3304.0338981311919948078554278347
             + y*(-6434.1712753081107267310868857834
             + 3130.1373771769187319232314579487*y
             + 25041.099017415349855385851663589*z)
             + z*(-25736.685101232442906924347543134
             + 31301.373771769187319232314579487*z)
             + x*(-26693.115966480945852789779377507
             + y*(46952.06065765378097884847186923
             - 20345.892951649971757501004476666*y
             - 162767.14361319977406000803581333*z)
             + (187808.24263061512391539388747692
             - 203458.92951649971757501004476666*z)*z
             + x*(75471.09009415459609192680293054
             + y*(-103990.11953065541120500513399185
             + 31649.166813677733845001562519259*y
             + 253193.33450942187076001250015407*z)
             + x*(-83644.226579005439447504129515184
             + 31649.166813677733845001562519259*x
             + 63298.33362735546769000312503852*y
             + 253193.33450942187076001250015407*z)
             + z*(-415960.4781226216448200205359674
             + 316491.66813677733845001562519259*z))));
            grad[2]= -347.79304190854652576924793977207
             + y*(695.58608381709305153849587954415
             - 347.79304190854652576924793977207*y
             - 1738.9652095427326288462396988604*z)
             + (1738.9652095427326288462396988604
             - 1738.9652095427326288462396988604*z)*z
             + x*(13216.135592524767979231421711339
             + z*(-64341.712753081107267310868857834
             + 62602.74754353837463846462915897*z)
             + y*(-25736.685101232442906924347543134
             + 12520.549508707674927692925831795*y
             + 62602.74754353837463846462915897*z)
             + x*(-106772.46386592378341115911751003
             + y*(187808.24263061512391539388747692
             - 81383.57180659988703000401790667*y
             - 406917.85903299943515002008953333*z)
             + (469520.6065765378097884847186923
             - 406917.85903299943515002008953333*z)*z
             + x*(301884.36037661838436770721172216
             + z*(-1.0399011953065541120500513399185e6
             + 632983.3362735546769000312503852*z)
             + y*(-415960.4781226216448200205359674
             + 126596.66725471093538000625007704*y
             + 632983.3362735546769000312503852*z)
             + x*(-334576.90631602175779001651806074
             + 126596.66725471093538000625007704*x
             + 253193.33450942187076001250015407*y
             + 632983.3362735546769000312503852*z))));
            return;
          case ( 66 ):
            grad[0]= -367.42346141747671472959261120588
             + y*(8524.2243048854597817265485799765
             + y*(-43208.999062695261652200091077812
             + (74072.569821763305689485870419106
             - 40122.641986788457248471513143683*y)*y))
             + x*(4923.4743829941879773765409901588
             + y*(-101114.93658208959189358388660386
             + y*(444435.41893057983413691522251464
             + y*(-641962.27178861531597554421029892
             + 280858.49390751920073930059200578*y)))
             + x*(-19252.989378275779851830652827188
             + x*(31892.356451036978838528638652671
             + x*(-23882.524992135986457423519728382
             + 6687.106997798076208078585523947*x
             + 133742.13995596152416157171047894*y)
             + y*(-351550.76788424172065327421040179
             + 561716.9878150384014786011840116*y))
             + y*(310399.34020548432860355983794673
             + y*(-962943.40768292297396331631544838
             + 748955.9837533845353048015786821*y))));
            grad[1]= -293.93876913398137178367408896471
             + y*(3086.3570759068044037285779341294
             + y*(-8230.2855357514784099428744910118
             + 6172.714151813608807457155868259*y))
             + x*(8524.2243048854597817265485799765
             + y*(-86417.998125390523304400182155624
             + (222217.70946528991706845761125732
             - 160490.56794715382899388605257473*y)*y)
             + x*(-50557.46829104479594679194330193
             + y*(444435.41893057983413691522251464
             + y*(-962943.40768292297396331631544838
             + 561716.9878150384014786011840116*y))
             + x*(103466.44673516144286785327931558
             + x*(-87887.691971060430163318552600447
             + 26748.427991192304832314342095788*x
             + 280858.49390751920073930059200578*y)
             + y*(-641962.27178861531597554421029892
             + 748955.9837533845353048015786821*y))));
            grad[2]= 0;
            return;
          case ( 67 ):
            grad[0]= -636.39610306789277196075992589436
             + 1230.3657992645926924574691900624*z
             + y*(13534.023791910519617032161090687
             - 24946.727240261396660861789095059*z
             + y*(-62366.818100653491652154472737648
             + y*(96223.090783865387120466900795228
             - 46329.63630334259379874332260511*y
             - 92659.27260668518759748664521022*z)
             + 96223.09078386538712046690079523*z))
             + x*(8527.7077811097631442741830069845
             - 14594.683963690340903633427633844*z
             + y*(-160541.52360059374993996770397228
             + 256594.90875697436565457840212061*z
             + y*(641487.27189243591413644600530152
             - 833933.453460166688377379806892*z
             + y*(-833933.45346016668837737980689197
             + 324307.45412339815659120325823577*y
             + 648614.9082467963131824065164715*z)))
             + x*(-33347.155800757581250743820116865
             + 44802.285655979651146037498782963*z
             + x*(55239.181746293092606193961567631
             - 50741.98261794665035100459142464*z
             + x*(-41365.746699413030177449395183134
             + 11582.409075835648449685830651277*x
             + 212344.16639032022157757356194009*y
             + 19304.015126392747416143051085462*z)
             + y*(-558161.80879741315386105050567108
             + 810768.6353084953914780081455894*y
             + 324307.45412339815659120325823577*z))
             + y*(492825.1422157761626064124866126
             - 555955.6356401111255849198712613*z
             + y*(-1.3898890891002778139622996781533e6
             + 972922.3623701944697736097747073*y
             + 972922.3623701944697736097747073*z))));
            grad[1]= -466.6904755831213661045572789892
             + 890.9545442950498807450638962521*z
             + y*(4454.7727214752494037253194812605
             - 7127.636354360399045960511170017*z
             + y*(-10691.454531540598568940766755025
             + 7127.636354360399045960511170017*y
             + 10691.454531540598568940766755025*z))
             + x*(13534.023791910519617032161090687
             - 24946.727240261396660861789095059*z
             + y*(-124733.6362013069833043089454753
             + y*(288669.27235159616136140070238568
             - 185318.54521337037519497329042044*y
             - 277977.81782005556279245993563066*z)
             + 192446.18156773077424093380159046*z)
             + x*(-80270.761800296874969983851986142
             + 128297.4543784871828272892010603*z
             + x*(164275.0474052587208688041622042
             - 185318.54521337037519497329042044*z
             + x*(-139540.45219935328846526262641777
             + 42468.833278064044315514712388017*x
             + 405384.31765424769573900407279471*y
             + 81076.86353084953914780081455894*z)
             + y*(-926592.72606685187597486645210219
             + 972922.3623701944697736097747073*y
             + 648614.9082467963131824065164715*z))
             + y*(641487.27189243591413644600530152
             - 833933.453460166688377379806892*z
             + y*(-1.250900180190250032566069710338e6
             + 648614.9082467963131824065164715*y
             + 972922.3623701944697736097747073*z))));
            grad[2]= -42.426406871192851464050661726291
             + y*(890.95454429504988074506389625211
             + y*(-3563.8181771801995229802555850084
             + 3563.8181771801995229802555850084*y))
             + x*(1230.3657992645926924574691900624
             + y*(-24946.727240261396660861789095059
             + (96223.090783865387120466900795228
             - 92659.27260668518759748664521022*y)*y)
             + x*(-7297.341981845170451816713816922
             + y*(128297.4543784871828272892010603
             + y*(-416966.72673008334418868990344599
             + 324307.45412339815659120325823577*y))
             + x*(14934.095218659883715345832927654
             + x*(-12685.495654486662587751147856161
             + 3860.8030252785494832286102170925*x
             + 81076.86353084953914780081455894*y)
             + y*(-185318.54521337037519497329042044
             + 324307.45412339815659120325823577*y))));
            return;
          case ( 68 ):
            grad[0]= -821.5838362577491701854546742012
             + (4765.186250294945187075637110367
             - 4600.8694830433953530385461755267*z)*z
             + y*(14295.558750884835561226911331101
             + z*(-78214.781211737721001655284983955
             + 70984.84345266952830402328385098*z)
             + y*(-52909.999054999046559943281018557
             + y*(65069.439831613734278688010196735
             - 25633.415691241774109786185835078*y
             - 153800.49414745064465871711501047*z)
             + (230700.7412211759669880756725157
             - 153800.49414745064465871711501047*z)*z))
             + x*(11009.223405853838880485092634296
             + z*(-56524.967934533142908759281585043
             + 47323.228968446352202682189233989*z)
             + y*(-169574.90380359942872627784475513
             + (804494.89246358798744559721697782
             - 615201.9765898025786348684600419*z)*z
             + y*(544217.13313713305033084517619088
             + z*(-1.999406423916858380563322495136e6
             + 1.0766034590321545126110198050733e6*z)
             + y*(-563935.14520731903041529608837171
             + 179433.90983869241876850330084554*y
             + 1.0766034590321545126110198050733e6*z)))
             + x*(-43050.993019906056517717824928143
             + (173518.50621763662474316802719129
             - 102533.66276496709643914474334031*z)*z
             + x*(71313.476987172627972097465720664
             + z*(-196522.85363285360150836075806893
             + 59811.30327956413958950110028185*z)
             + x*(-53402.949356753696062054553823078
             + 14952.825819891034897375275070462*x
             + 224292.38729836552346062912605693*y
             + 74764.12909945517448687637535231*z)
             + y*(-589568.56089856080452508227420678
             + 687829.9877149876052792626532412*y
             + 1.0167921557525903730215187047914e6*z))
             + y*(520555.51865290987422950408157388
             + z*(-1.7430722670044406394654606367853e6
             + 717735.6393547696750740132033822*z)
             + y*(-1.1791371217971216090501645484136e6
             + 657924.3360752055354845121031003*y
             + 2.3326408279030014439905429109921e6*z))));
            grad[1]= -492.95030175464950211127280452072
             + (2793.3850432763471786305458922841
             - 2629.0682760247973445934549574439*z)*z
             + y*(3779.2856467856461828530915013255
             + z*(-17088.943794161182739857457223385
             + 11830.807242111588050670547308497*z)
             + y*(-7229.9377590681926976320011329706
             + 3943.6024140371960168901824361658*y
             + 17746.210863167382076005820962746*z))
             + x*(14295.558750884835561226911331101
             + z*(-78214.781211737721001655284983955
             + 70984.84345266952830402328385098*z)
             + y*(-105819.99810999809311988656203711
             + y*(195208.31949484120283606403059021
             - 102533.66276496709643914474334031*y
             - 461401.4824423519339761513450314*z)
             + (461401.4824423519339761513450314
             - 307600.98829490128931743423002093*z)*z)
             + x*(-84787.451901799714363138922377564
             + (402247.44623179399372279860848891
             - 307600.98829490128931743423002093*z)*z
             + x*(173518.50621763662474316802719129
             + z*(-581024.08900148021315515354559509
             + 239245.21311825655835800440112739*z)
             + x*(-147392.1402246402011312705685517
             + 44858.477459673104692125825211386*x
             + 343914.99385749380263963132662062*y
             + 254198.03893814759325537967619785*z)
             + y*(-786091.41453141440603344303227571
             + 657924.3360752055354845121031003*y
             + 1.555093885268667629327028607328e6*z))
             + y*(544217.13313713305033084517619088
             + z*(-1.999406423916858380563322495136e6
             + 1.0766034590321545126110198050733e6*z)
             + y*(-845902.71781097854562294413255756
             + 358867.81967738483753700660169109*y
             + 1.6149051885482317689165297076099e6*z))));
            grad[2]= -164.31676725154983403709093484024
             + 328.63353450309966807418186968048*z
             + y*(2793.3850432763471786305458922841
             - 5258.136552049594689186909914888*z
             + y*(-8544.4718970805913699287286116925
             + 5915.403621055794025335273654249*y
             + 11830.807242111588050670547308497*z))
             + x*(4765.186250294945187075637110367
             - 9201.738966086790706077092351053*z
             + y*(-78214.781211737721001655284983955
             + y*(230700.7412211759669880756725157
             - 153800.49414745064465871711501047*y
             - 307600.98829490128931743423002093*z)
             + 141969.68690533905660804656770197*z)
             + x*(-28262.483967266571454379640792521
             + 47323.228968446352202682189233989*z
             + x*(57839.502072545541581056009063765
             - 68355.77517664473095942982889354*z
             + x*(-49130.713408213400377090189517232
             + 14952.825819891034897375275070462*x
             + 254198.03893814759325537967619785*y
             + 29905.651639782069794750550140924*z)
             + y*(-581024.08900148021315515354559509
             + 777546.942634333814663514303664*y
             + 478490.42623651311671600880225478*z))
             + y*(402247.44623179399372279860848891
             - 615201.9765898025786348684600419*z
             + y*(-999703.21195842919028166124756802
             + 538301.7295160772563055099025366*y
             + 1.0766034590321545126110198050733e6*z))));
            return;
          case ( 69 ):
            grad[0]= -972.1111047611790346448951154132
             + z*(11276.488815229676801880783338793
             + z*(-27219.11093331301297005706323157
             + 17497.999885701222623608112077438*z))
             + y*(11276.488815229676801880783338793
             + y*(-27219.11093331301297005706323157
             + y*(24497.199839981711673051356908413
             - 7582.466617137196470230181900223*y
             - 90989.59940564635764276218280268*z)
             + (199477.19869699393790913247768279
             - 227473.99851411589410690545700669*z)*z)
             + z*(-119764.08810657725706825107821891
             + (262469.99828551833935412168116156
             - 151649.33234274392940460363800446*z)*z))
             + x*(13026.288803799799064241594546537
             + z*(-133762.48801513823516713756788086
             + (279967.998171219561977729793239
             - 151649.33234274392940460363800446*z)*z)
             + y*(-133762.48801513823516713756788086
             + z*(1.2318591919533660727020110902516e6
             + z*(-2.2747399851411589410690545700669e6
             + 1.0615453263992075058322254660312e6*z))
             + y*(279967.998171219561977729793239
             + y*(-212309.06527984150116644509320624
             + 53077.26631996037529161127330156*y
             + 636927.1958395245034993352796187*z)
             + z*(-1.7288023887072807952124814732508e6
             + 1.5923179895988112587483381990468e6*z)))
             + x*(-50938.621889485781415392504047652
             + z*(410619.73065112202423400369675054
             + z*(-606597.32937097571761841455201784
             + 176924.2210665345843053709110052*z))
             + x*(84379.243893270340207176896017866
             + x*(-63187.221809476637251918182501858
             + 17692.42210665345843053709110052*x
             + 176924.2210665345843053709110052*y
             + 176924.2210665345843053709110052*z)
             + z*(-465057.95251774805017411782321367
             + 353848.4421330691686107418220104*z)
             + y*(-465057.95251774805017411782321367
             + 353848.4421330691686107418220104*y
             + 1.5569331453855043418872640168458e6*z))
             + y*(410619.73065112202423400369675054
             + y*(-606597.32937097571761841455201784
             + 247693.90949314841802751927540728*y
             + 2.0169361201584942610812283854593e6*z)
             + z*(-2.6690282492322931575210240288785e6
             + 2.653863315998018764580563665078e6*z))));
            grad[1]= -388.84444190447161385795804616528
             + z*(4277.2888609491877524375385078181
             + z*(-9721.111047611790346448951154132
             + 5832.666628567074207869370692479*z))
             + y*(1944.2222095223580692897902308264
             + y*(-2721.911093331301297005706323157
             + 1166.5333257134148415738741384958*y
             + 10498.799931420733574164867246463*z)
             + z*(-14776.088792369921326602405754281
             + 17497.999885701222623608112077438*z))
             + x*(11276.488815229676801880783338793
             + y*(-54438.221866626025940114126463139
             + y*(73491.599519945135019154070725238
             - 30329.866468548785880920727600892*y
             - 272968.79821693907292828654840803*z)
             + (398954.39739398787581826495536558
             - 454947.99702823178821381091401338*z)*z)
             + z*(-119764.08810657725706825107821891
             + (262469.99828551833935412168116156
             - 151649.33234274392940460363800446*z)*z)
             + x*(-66881.244007569117583568783940428
             + z*(615929.5959766830363510055451258
             + z*(-1.1373699925705794705345272850334e6
             + 530772.6631996037529161127330156*z))
             + x*(136873.24355037400807800123225018
             + x*(-116264.48812943701254352945580342
             + 35384.84421330691686107418220104*x
             + 176924.2210665345843053709110052*y
             + 389233.28634637608547181600421145*z)
             + z*(-889676.08307743105250700800962616
             + 884621.105332672921526854555026*z)
             + y*(-404398.21958065047841227636801189
             + 247693.90949314841802751927540728*y
             + 1.3446240801056628407208189236395e6*z))
             + y*(279967.998171219561977729793239
             + y*(-318463.59791976225174966763980936
             + 106154.53263992075058322254660312*y
             + 955390.7937592867552490029194281*z)
             + z*(-1.7288023887072807952124814732508e6
             + 1.5923179895988112587483381990468e6*z))));
            grad[2]= -388.84444190447161385795804616528
             + (1944.2222095223580692897902308264
             - 1944.2222095223580692897902308264*z)*z
             + y*(4277.2888609491877524375385078181
             + z*(-19442.222095223580692897902308264
             + 17497.999885701222623608112077438*z)
             + y*(-7388.0443961849606633012028771403
             + 3499.5999771402445247216224154875*y
             + 17497.999885701222623608112077438*z))
             + x*(11276.488815229676801880783338793
             + z*(-54438.221866626025940114126463139
             + 52493.99965710366787082433623231*z)
             + y*(-119764.08810657725706825107821891
             + y*(199477.19869699393790913247768279
             - 90989.59940564635764276218280268*y
             - 454947.99702823178821381091401338*z)
             + (524939.99657103667870824336232313
             - 454947.99702823178821381091401338*z)*z)
             + x*(-66881.244007569117583568783940428
             + (279967.998171219561977729793239
             - 227473.99851411589410690545700669*z)*z
             + y*(615929.5959766830363510055451258
             + z*(-2.2747399851411589410690545700669e6
             + 1.5923179895988112587483381990468e6*z)
             + y*(-864401.19435364039760624073662542
             + 318463.59791976225174966763980936*y
             + 1.5923179895988112587483381990468e6*z))
             + x*(136873.24355037400807800123225018
             + z*(-404398.21958065047841227636801189
             + 176924.2210665345843053709110052*z)
             + x*(-116264.48812943701254352945580342
             + 35384.84421330691686107418220104*x
             + 389233.28634637608547181600421145*y
             + 176924.2210665345843053709110052*z)
             + y*(-889676.08307743105250700800962616
             + 672312.0400528314203604094618198*y
             + 1.769242210665345843053709110052e6*z))));
            return;
          case ( 70 ):
            grad[0]= -1102.2703842524301441887778336177
             + y*(4262.1121524427298908632742899883
             + z*(-61727.141518136088074571558682588
             + (178567.80224889368335858200904606
             - 133742.13995596152416157171047894*z)*z)
             + y*(-6172.7141518136088074571558682588
             + y*(3968.1733833087485190796002010235
             - 955.3009996854394582969407891353*y
             - 19106.019993708789165938815782706*z)
             + (59522.600749631227786194003015353
             - 85977.08997168955124672467102218*z)*z))
             + z*(21310.560762213649454316371449941
             + z*(-92590.712277204132111857338023883
             + (138886.06841580619816778600703582
             - 66871.06997798076208078585523947*z)*z))
             + x*(14770.423148982563932129622970477
             + z*(-252787.34145522397973395971650965
             + z*(952361.61199409964457910404824565
             + z*(-1.2036792596036537174541453943105e6
             + 468097.4898458653345655009866763*z)))
             + y*(-50557.46829104479594679194330193
             + y*(63490.774132939976305273603216377
             + y*(-34390.835988675820498689868408871
             + 6687.106997798076208078585523947*y
             + 133742.13995596152416157171047894*z)
             + z*(-515862.53983013730748034802613306
             + 601839.6298018268587270726971552*z))
             + z*(634907.74132939976305273603216377
             + z*(-1.5475876194904119224410440783992e6
             + 936194.9796917306691310019733526*z)))
             + x*(-57758.968134827339555491958481565
             + x*(95677.069353110936515585915958012
             + x*(-71647.574976407959372270559185147
             + 20061.320993394228624235756571841*x
             + 66871.06997798076208078585523947*y
             + 334355.34988990381040392927619735*z)
             + y*(-175775.38394212086032663710520089
             + 80245.28397357691449694302628737*y
             + 802452.8397357691449694302628737*z)
             + z*(-878876.91971060430163318552600447
             + 1.2036792596036537174541453943105e6*z))
             + z*(775998.35051371082150889959486683
             + z*(-2.0634501593205492299213921045322e6
             + 1.4042924695375960036965029600289e6*z))
             + y*(155199.67010274216430177991897337
             + y*(-137563.34395470328199475947363548
             + 40122.641986788457248471513143683*y
             + 601839.6298018268587270726971552*z)
             + z*(-1.3756334395470328199475947363548e6
             + 1.8055188894054805761812180914657e6*z))));
            grad[1]= -146.96938456699068589183704448235
             + z*(2204.5407685048602883775556672353
             + z*(-6613.6223055145808651326670017059
             + 5143.928459844674006214296556882*z))
             + y*(440.90815370097205767551113344706
             + y*(-440.90815370097205767551113344706
             + 146.96938456699068589183704448235*y
             + 2204.5407685048602883775556672353*z)
             + z*(-4409.0815370097205767551113344706
             + 6613.622305514580865132667001706*z))
             + x*(4262.1121524427298908632742899883
             + y*(-12345.428303627217614914311736518
             + y*(11904.520149926245557238800603071
             - 3821.2039987417578331877631565412*y
             - 57318.05998112636749781644734812*z)
             + (119045.20149926245557238800603071
             - 171954.17994337910249344934204435*z)*z)
             + z*(-61727.141518136088074571558682588
             + (178567.80224889368335858200904606
             - 133742.13995596152416157171047894*z)*z)
             + x*(-25278.734145522397973395971650965
             + z*(317453.87066469988152636801608188
             + z*(-773793.80974520596122052203919959
             + 468097.4898458653345655009866763*z))
             + y*(63490.774132939976305273603216377
             + y*(-51586.253983013730748034802613306
             + 13374.213995596152416157171047894*y
             + 200613.20993394228624235756571841*z)
             + z*(-515862.53983013730748034802613306
             + 601839.6298018268587270726971552*z))
             + x*(51733.223367580721433926639657788
             + x*(-43943.845985530215081659276300224
             + 13374.213995596152416157171047894*x
             + 40122.641986788457248471513143683*y
             + 200613.20993394228624235756571841*z)
             + y*(-91708.895969802187996506315756989
             + 40122.641986788457248471513143683*y
             + 401226.41986788457248471513143683*z)
             + z*(-458544.47984901093998253157878494
             + 601839.6298018268587270726971552*z))));
            grad[2]= -734.84692283495342945918522241177
             + z*(6613.6223055145808651326670017059
             + z*(-15431.785379534022018642889670647
             + 10287.856919689348012428593113765*z))
             + y*(2204.5407685048602883775556672353
             + y*(-2204.5407685048602883775556672353
             + 734.8469228349534294591852224118*y
             + 6613.622305514580865132667001706*z)
             + z*(-13227.244611029161730265334003412
             + 15431.785379534022018642889670647*z))
             + x*(21310.560762213649454316371449941
             + y*(-61727.141518136088074571558682588
             + y*(59522.600749631227786194003015353
             - 19106.019993708789165938815782706*y
             - 171954.17994337910249344934204435*z)
             + (357135.60449778736671716401809212
             - 401226.41986788457248471513143683*z)*z)
             + z*(-185181.42455440826422371467604777
             + (416658.20524741859450335802110747
             - 267484.27991192304832314342095788*z)*z)
             + x*(-126393.67072761198986697985825482
             + z*(952361.61199409964457910404824565
             + z*(-1.8055188894054805761812180914657e6
             + 936194.9796917306691310019733526*z))
             + y*(317453.87066469988152636801608188
             + y*(-257931.26991506865374017401306653
             + 66871.06997798076208078585523947*y
             + 601839.6298018268587270726971552*z)
             + z*(-1.5475876194904119224410440783992e6
             + 1.4042924695375960036965029600289e6*z))
             + x*(258666.11683790360716963319828894
             + x*(-219719.22992765107540829638150112
             + 66871.06997798076208078585523947*x
             + 200613.20993394228624235756571841*y
             + 601839.6298018268587270726971552*z)
             + y*(-458544.47984901093998253157878494
             + 200613.20993394228624235756571841*y
             + 1.2036792596036537174541453943105e6*z)
             + z*(-1.3756334395470328199475947363548e6
             + 1.4042924695375960036965029600289e6*z))));
            return;
          case ( 71 ):
            grad[0]= -254.91174943497602539064579823537
             + y*(8452.3369549492050524266764678042
             + y*(-63862.101437393993729445999978965
             + y*(180316.52170558304111843576464649
             + y*(-211308.42387373012631066691169511
             + 86777.32607081183853824721173612*y))))
             + x*(2146.625258399798108552806721982
             + y*(-58227.210134094523694494882333762
             + y*(338093.47819796820209706705871217
             + y*(-653647.39118273852405432964684353
             + 394442.3912309629024465782351642*y)))
             + x*(-6037.3835392494321803047689055744
             + x*(7781.5165616992681435039243671848
             + x*(-4762.8247920745520533515399143976
             + 1126.9782606598940069902235290406*x
             + 32870.19926924690853721485293035*y)
             + y*(-107062.93476268993066407123525885
             + 210369.27532318021463817505875424*y))
             + y*(123967.60867258834076892458819446
             + y*(-484600.65208375442300579611748744
             + 473330.86947715548293589388219704*y))));
            grad[1]= -469.57427527495583624592647043357
             + y*(7513.1884043992933799348235269371
             + y*(-33809.347819796820209706705871217
             + (56348.913032994700349511176452028
             - 30991.902168147085192231147048615*y)*y))
             + x*(8452.3369549492050524266764678042
             + y*(-127724.20287478798745889199995793
             + y*(540949.56511674912335530729393947
             + y*(-845233.69549492050524266764678042
             + 433886.63035405919269123605868062*y)))
             + x*(-29113.605067047261847247441166881
             + x*(41322.536224196113589641529398154
             + x*(-26765.733690672482666017808814713
             + 6574.03985384938170744297058607*x
             + 105184.63766159010731908752937712*y)
             + y*(-323067.10138916961533719741165829
             + 473330.86947715548293589388219704*y))
             + y*(338093.47819796820209706705871217
             + y*(-980471.08677410778608149447026529
             + 788884.7824619258048931564703284*y))));
            grad[2]= 0;
            return;
          case ( 72 ):
            grad[0]= -441.52010146764552491043625557519
             + 836.564402780802047198721326353*z
             + y*(13803.312645883233778778901884824
             - 25282.83528404201742645024452978*z
             + y*(-97970.986725662817527494697552896
             + 160620.36533391399306215449465978*z
             + y*(258777.25526019476660013779695186
             - 334625.7611123208188794885305412*z
             + y*(-282340.48593852069092956844764414
             + 107359.09835686959605716923688197*y
             + 214718.19671373919211433847376394*z))))
             + x*(3718.0640123591202097720947837911
             - 5762.999219156636325146746914876*z
             + x*(-10457.055034760025589984016579412
             + 12269.611240785096692247912786511*z
             + x*(13477.982044801810760423843591243
             - 10596.482435223492597850470133805*z
             + x*(-8249.4545274217979654318353015365
             + 1951.9836064885381101303497614903*x
             + 53679.54917843479802858461844098*y
             + 3253.3060108142301835505829358172*z)
             + y*(-174841.96018118762786453275720778
             + 322727.95627277163420821782723307*y
             + 83284.63387684429269889492315692*z))
             + y*(202448.58547295409542209056097743
             - 191852.10303773060282424009084362*z
             + y*(-743426.89927120608594393035201903
             + 679290.2950580112623253617169986*y
             + 421628.45900152423178815554848191*z)))
             + y*(-95089.487116084499364921324095457
             + 133850.30444492832755179541221648*z
             + y*(518669.92972409726926320722233886
             - 582248.8243354382248503100431417*z
             + y*(-938067.5503182060289254995139505
             + 527035.5737519052897351944356024*y
             + 624634.7540763321952417119236769*z))));
            grad[1]= -766.85070254906854326549454915692
             + 1487.2256049436480839088379135164*z
             + y*(11525.998438313272650293493829752
             - 20077.545666739249132769311832472*z
             + y*(-48520.735361286518737525836928474
             + y*(75290.79625027218424788491937177
             - 38342.535127453427163274727457846*y
             - 61348.05620392548346123956393255*z)
             + 66925.15222246416377589770610824*z))
             + x*(13803.312645883233778778901884824
             - 25282.83528404201742645024452978*z
             + y*(-195941.97345132563505498939510579
             + 321240.73066782798612430898931955*z
             + y*(776331.76578058429980041339085558
             - 1.0038772833369624566384655916236e6*z
             + y*(-1.1293619437540827637182737905765e6
             + 536795.4917843479802858461844098*y
             + 858872.7868549567684573538950557*z)))
             + x*(-47544.743558042249682460662047729
             + 66925.15222246416377589770610824*z
             + x*(67482.861824318031807363520325809
             - 63950.70101257686760808003028121*z
             + x*(-43710.490045296906966133189301944
             + 10735.909835686959605716923688197*x
             + 161363.97813638581710410891361653*y
             + 20821.15846921107317472373078923*z)
             + y*(-495617.93284747072396262023467935
             + 679290.2950580112623253617169986*y
             + 281085.63933434948785877036565461*z))
             + y*(518669.92972409726926320722233886
             - 582248.8243354382248503100431417*z
             + y*(-1.4071013254773090433882492709257e6
             + 1.0540711475038105794703888712048e6*y
             + 936952.1311144982928625678855154*z))));
            grad[2]= -46.475800154489002622151184797389
             + y*(1487.2256049436480839088379135164
             + y*(-10038.772833369624566384655916236
             + (22308.384074154721258632568702747
             - 15337.014050981370865309890983138*y)*y))
             + x*(836.564402780802047198721326353
             + y*(-25282.83528404201742645024452978
             + y*(160620.36533391399306215449465978
             + y*(-334625.7611123208188794885305412
             + 214718.19671373919211433847376394*y)))
             + x*(-2881.4996095783181625733734574381
             + x*(4089.8704135950322307493042621702
             + x*(-2649.1206088058731494626175334512
             + 650.6612021628460367101165871634*x
             + 20821.15846921107317472373078923*y)
             + y*(-63950.701012576867608080030281207
             + 140542.8196671747439293851828273*y))
             + y*(66925.15222246416377589770610824
             + y*(-291124.41216771911242515502157084
             + 312317.37703816609762085596183845*y))));
            return;
          case ( 73 ):
            grad[0]= -570.
             + (3240.
             - 3060.*z)*z
             + y*(15660.
             + z*(-85680.
             + 77760.*z)
             + y*(-96900.
             + (466560.
             - 364500.*z)*z
             + y*(221760.
             + z*(-810000.
             + 415800.*z)
             + y*(-209250.
             + 69300.*y
             + 415800.*z))))
             + x*(4800.
             + z*(-22320.
             + 16200.*z)
             + x*(-13500.
             + (47520.
             - 23220.*z)*z
             + x*(17400.
             + z*(-41040.
             + 10080.*z)
             + x*(-10650.
             + 2520.*x
             + 60900.*y
             + 12600.*z)
             + y*(-198360.
             + 319200.*y
             + 282240.*z))
             + y*(229680.
             + z*(-650160.
             + 204120.*z)
             + y*(-735300.
             + 582120.*y
             + 1.22472e6*z)))
             + y*(-107880.
             + (453600.
             - 281880.*z)*z
             + y*(513000.
             + z*(-1.69128e6
             + 680400.*z)
             + y*(-803880.
             + 390600.*y
             + 1.512e6*z))));
            grad[1]= -870.
             + (5040.
             - 4860.*z)*z
             + y*(11400.
             + z*(-58320.
             + 48600.*z)
             + y*(-41580.
             + y*(55800.
             - 24750.*y
             - 118800.*z)
             + (162000.
             - 89100.*z)*z))
             + x*(15660.
             + z*(-85680.
             + 77760.*z)
             + y*(-193800.
             + (933120.
             - 729000.*z)*z
             + y*(665280.
             + z*(-2.43e6
             + 1.2474e6*z)
             + y*(-837000.
             + 346500.*y
             + 1.6632e6*z)))
             + x*(-53940.
             + (226800.
             - 140940.*z)*z
             + x*(76560.
             + z*(-216720.
             + 68040.*z)
             + x*(-49590.
             + 12180.*x
             + 159600.*y
             + 70560.*z)
             + y*(-490200.
             + 582120.*y
             + 816480.*z))
             + y*(513000.
             + z*(-1.69128e6
             + 680400.*z)
             + y*(-1.20582e6
             + 781200.*y
             + 2.268e6*z))));
            grad[2]= -180.
             + 360.*z
             + y*(5040.
             - 9720.*z
             + y*(-29160.
             + y*(54000.
             - 29700.*y
             - 59400.*z)
             + 48600.*z))
             + x*(3240.
             - 6120.*z
             + x*(-11160.
             + 16200.*z
             + x*(15840.
             - 15480.*z
             + x*(-10260.
             + 2520.*x
             + 70560.*y
             + 5040.*z)
             + y*(-216720.
             + 408240.*y
             + 136080.*z))
             + y*(226800.
             - 281880.*z
             + y*(-845640.
             + 756000.*y
             + 680400.*z)))
             + y*(-85680.
             + 155520.*z
             + y*(466560.
             - 729000.*z
             + y*(-810000.
             + 415800.*y
             + 831600.*z))));
            return;
          case ( 74 ):
            grad[0]= -674.43309527335622885267542523802
             + z*(7667.2393988971023911672574658639
             + z*(-18103.204136284825090256024572179
             + 11358.873183551262801729270319798*z))
             + y*(14695.542181219446249737243476239
             + z*(-159308.19639930646079425301623517
             + (357804.50528186477825447201507365
             - 212978.87219158617753242381849622*z)*z)
             + y*(-71205.936269386978688340363317236
             + z*(654271.09537255273737960597042038
             + z*(-1.1980061560776722486198839790412e6
             + 546645.7719584045223332211341403*z))
             + y*(128355.26697412926965954075461372
             + y*(-98502.728388608607108746016054501
             + 27332.288597920226116661056707015*y
             + 327987.46317504271339993268048418*z)
             + z*(-830617.60154718609237645289213525
             + 819968.6579376067834998317012104*z))))
             + x*(5679.4365917756314008646351598992
             + z*(-52818.760303513372028041106987062
             + (95840.492486213779889590718323298
             - 41175.915290373327656268604909269*z)*z)
             + x*(-15973.415414368963314931786387216
             + z*(112452.844517157501737119776166
             + z*(-137371.37256357308450841336293006
             + 29817.042106822064854539334589471*z))
             + x*(20587.957645186663828134302454634
             + x*(-12601.249938002182170668409261026
             + 2981.7042106822064854539334589471*x
             + 57149.33070474229097120039129649*y
             + 29817.042106822064854539334589471*z)
             + z*(-97118.365719363296954785261234276
             + 59634.08421364412970907866917894*z)
             + y*(-186143.53429544631916333841736569
             + 234560.73124033357685570943210383*y
             + 524779.9410800683414398922887747*z))
             + y*(215534.61865788521166281290431817
             + z*(-1.2088680785594431436740375937845e6
             + 939236.8263648950429179890395683*z)
             + y*(-540327.39875005413239975922752491
             + 336932.57580708933285629448086102*y
             + 1.7174616253529509356214656723535e6*z)))
             + y*(-101235.9572484006297204121217252
             + z*(843396.33387868126302839832124502
             + z*(-1.297041331646759821172461054642e6
             + 397560.56142429419806052446119294*z))
             + y*(376972.60377910753423239015873831
             + y*(-465287.84278121860251583523547474
             + 183871.75965873606660299256330174*y
             + 1.5504861895547473724360453986525e6*z)
             + z*(-2.3717327207255036730010716427739e6
             + 2.2362781580116548640904500942103e6*z))));
            grad[1]= -816.4190100677470138742913042355
             + z*(9371.0703764297918114266480138336
             + z*(-22362.781580116548640904500942103
             + 14198.591479439078502161587899748*z))
             + y*(8377.1689728690563162753368608512
             + y*(-24066.612557649238061163891490073
             + y*(26267.394236962295228998937614534
             - 9761.531642114366470236091681077*y
             - 93710.70376429791811426648013834*z)
             + (166123.52030943721847529057842705
             - 175707.56955805859646424965025938*z)*z)
             + z*(-81783.886921569092172450746302548
             + (159734.15414368963314931786387216
             - 78092.25313691493176188873344861*z)*z))
             + x*(14695.542181219446249737243476239
             + z*(-159308.19639930646079425301623517
             + (357804.50528186477825447201507365
             - 212978.87219158617753242381849622*z)*z)
             + x*(-50617.978624200314860206060862601
             + z*(421698.16693934063151419916062251
             + z*(-648520.66582337991058623052732098
             + 198780.28071214709903026223059647*z))
             + x*(71844.872885961737220937634772724
             + x*(-46535.883573861579790834604341424
             + 11429.866140948458194240078259297*x
             + 117280.36562016678842785471605192*y
             + 131194.98527001708535997307219367*z)
             + z*(-402956.02618648104789134586459484
             + 313078.94212163168097266301318944*z)
             + y*(-360218.2658333694215998394850166
             + 336932.57580708933285629448086102*y
             + 1.1449744169019672904143104482357e6*z))
             + y*(376972.60377910753423239015873831
             + z*(-2.3717327207255036730010716427739e6
             + 2.2362781580116548640904500942103e6*z)
             + y*(-697931.76417182790377375285321211
             + 367743.51931747213320598512660347*y
             + 2.3257292843321210586540680979787e6*z)))
             + y*(-142411.87253877395737668072663447
             + z*(1.3085421907451054747592119408408e6
             + z*(-2.3960123121553444972397679580825e6
             + 1.0932915439168090446664422682806e6*z))
             + y*(385065.80092238780897862226384116
             + y*(-394010.913554434428434984064218
             + 136661.44298960113058330528353507*y
             + 1.3119498527001708535997307219367e6*z)
             + z*(-2.4918528046415582771293586764058e6
             + 2.4599059738128203504994951036313e6*z))));
            grad[2]= -425.95774438317235506484763699244
             + (2129.7887219158617753242381849622
             - 2129.7887219158617753242381849622*z)*z
             + y*(9371.0703764297918114266480138336
             + z*(-44725.563160233097281809001884206
             + 42595.774438317235506484763699244*z)
             + y*(-40891.943460784546086225373151274
             + y*(55374.506769812406158430192809017
             - 23427.675941074479528566620034584*y
             - 117138.37970537239764283310017292*z)
             + (159734.15414368963314931786387216
             - 117138.37970537239764283310017292*z)*z))
             + x*(7667.2393988971023911672574658639
             + z*(-36206.408272569650180512049144357
             + 34076.619550653788405187810959395*z)
             + y*(-159308.19639930646079425301623517
             + (715609.01056372955650894403014729
             - 638936.6165747585325972714554887*z)*z
             + y*(654271.09537255273737960597042038
             + z*(-2.3960123121553444972397679580825e6
             + 1.6399373158752135669996634024209e6*z)
             + y*(-830617.60154718609237645289213525
             + 327987.46317504271339993268048418*y
             + 1.6399373158752135669996634024209e6*z)))
             + x*(-26409.380151756686014020553493531
             + (95840.492486213779889590718323298
             - 61763.8729355599914844029073639*z)*z
             + x*(37484.281505719167245706592055334
             + z*(-91580.915042382056338942241953374
             + 29817.042106822064854539334589471*z)
             + x*(-24279.591429840824238696315308569
             + 5963.408421364412970907866917894*x
             + 131194.98527001708535997307219367*y
             + 29817.042106822064854539334589471*z)
             + y*(-402956.02618648104789134586459484
             + 572487.2084509836452071552241178*y
             + 626157.8842432633619453260263789*z))
             + y*(421698.16693934063151419916062251
             + z*(-1.297041331646759821172461054642e6
             + 596340.8421364412970907866917894*z)
             + y*(-1.1858663603627518365005358213869e6
             + 775243.0947773736862180226993262*y
             + 2.2362781580116548640904500942103e6*z))));
            return;
          case ( 75 ):
            grad[0]= -764.7352483049280761719373947061
             + z*(14489.720494198637232731445373379
             + z*(-61581.312100344208239108642836859
             + (90158.260852791520559217882323245
             - 42261.684774746025262133382339021*z)*z))
             + y*(10867.290370648977924548584030034
             + z*(-191586.3043121819811883379999369
             + z*(753465.46569832913610203515941569
             + z*(-1.0142804345939046062912011761365e6
             + 433886.63035405919269123605868062*z)))
             + y*(-34211.840055746782355060357131589
             + y*(45079.130426395760279608941161623
             + y*(-27168.225926622444811371460075085
             + 6198.380433629417038446229409723*y
             + 123967.60867258834076892458819446*z)
             + z*(-410542.08066896138826072428557906
             + 557854.2390266475334601606468751*z))
             + z*(463671.05581435639144740625194812
             + z*(-1.2497383926246324613230871634539e6
             + 867773.2607081183853824721173612*z))))
             + x*(6439.8757751993943256584201659461
             + z*(-99818.074515590612047705512572164
             + z*(326018.71111946933773645752090102
             + z*(-326823.69559136926202716482342176
             + 78888.47824619258048931564703284*z)))
             + x*(-18112.150617748296540914306716723
             + z*(212515.90058158001274672786547622
             + z*(-467293.48593790605075558911329146
             + 236665.43473857774146794694109852*z))
             + x*(23344.549685097804430511773101555
             + x*(-14288.474376223656160054619743193
             + 3380.9347819796820209706705871217*x
             + 42261.684774746025262133382339021*y
             + 56348.91303299470034951117645203*z)
             + z*(-183536.45959318273828126497472946
             + 202856.0869187809212582402352273*z)
             + y*(-137652.3446948870537109487310471
             + 112697.82606598940069902235290406*y
             + 631107.8259695406439145251762627*z))
             + y*(159386.92543618500956004589910717
             + y*(-259607.4921877255837531050629397
             + 118332.71736928887073397347054926*y
             + 1.2171365215126855275494414113638e6*z)
             + z*(-1.4538019562512632690173883524623e6
             + 1.9778468474581139822678422934662e6*z)))
             + y*(-74863.555886692959035779134429123
             + z*(1.0142804345939046062912011761365e6
             + z*(-2.7313123131564431183698774528819e6
             + 1.8933234779086219317435755287881e6*z))
             + y*(181121.50617748296540914306716723
             + y*(-163411.84779568463101358241171088
             + 50714.02172969523031456005880683*y
             + 766345.2172487279247533519997476*z)
             + z*(-1.6808075773270419189968476633119e6
             + 2.332844999565980594469762705114e6*z))));
            grad[1]= -603.73835392494321803047689055744
             + y*(4024.9223594996214535365126037163
             + z*(-57958.881976794548930925781493515
             + (166631.78568328432817641162179385
             - 123967.60867258834076892458819446*z)*z)
             + y*(-8452.3369549492050524266764678042
             + y*(7244.8602470993186163657226866893
             - 2213.707297724791799445081932044*y
             - 35419.316763596668791121310912703*z)
             + (82108.416133792277652144857115812
             - 119540.19407713875717003442433037*z)*z))
             + z*(11269.782606598940069902235290406
             + z*(-47091.591606145571006377197463481
             + (67618.695639593640419413411742434
             - 30991.902168147085192231147048615*z)*z))
             + x*(10867.290370648977924548584030034
             + z*(-191586.3043121819811883379999369
             + z*(753465.46569832913610203515941569
             + z*(-1.0142804345939046062912011761365e6
             + 433886.63035405919269123605868062*z)))
             + y*(-68423.680111493564710120714263177
             + y*(135237.39127918728083882682348487
             + y*(-108672.90370648977924548584030034
             + 30991.902168147085192231147048615*y
             + 495870.43469035336307569835277785*z)
             + z*(-1.2316262420068841647821728567372e6
             + 1.6735627170799426003804819406252e6*z))
             + z*(927342.11162871278289481250389623
             + z*(-2.4994767852492649226461743269078e6
             + 1.7355465214162367707649442347225e6*z)))
             + x*(-37431.777943346479517889567214562
             + x*(53128.975145395003186681966369055
             + x*(-34413.086173721763427737182761774
             + 8452.336954949205052426676467804*x
             + 56348.91303299470034951117645203*y
             + 157776.95649238516097863129406568*z)
             + z*(-484600.65208375442300579611748744
             + 659282.2824860379940892807644887*z)
             + y*(-173071.6614584837225020700419598
             + 118332.71736928887073397347054926*y
             + 811424.3476751236850329609409092*z))
             + z*(507140.21729695230314560058806825
             + z*(-1.3656561565782215591849387264409e6
             + 946661.7389543109658717877643941*z))
             + y*(181121.50617748296540914306716723
             + y*(-245117.77169352694652037361756632
             + 101428.04345939046062912011761365*y
             + 1.1495178258730918871300279996214e6*z)
             + z*(-1.6808075773270419189968476633119e6
             + 2.332844999565980594469762705114e6*z))));
            grad[2]= -804.98447189992429070730252074326
             + z*(7244.8602470993186163657226866893
             + z*(-16904.673909898410104853352935608
             + 11269.782606598940069902235290406*z))
             + y*(11269.782606598940069902235290406
             + y*(-28979.440988397274465462890746757
             + y*(27369.472044597425884048285705271
             - 8854.829190899167197780327728176*y
             - 79693.46271809250478002294955358*z)
             + (166631.78568328432817641162179385
             - 185951.41300888251115338688229169*z)*z)
             + z*(-94183.183212291142012754394926961
             + (202856.0869187809212582402352273
             - 123967.60867258834076892458819446*z)*z))
             + x*(14489.720494198637232731445373379
             + z*(-123162.62420068841647821728567372
             + (270474.78255837456167765364696974
             - 169046.73909898410104853352935608*z)*z)
             + y*(-191586.3043121819811883379999369
             + z*(1.5069309313966582722040703188314e6
             + z*(-3.0428413037817138188736035284095e6
             + 1.7355465214162367707649442347225e6*z))
             + y*(463671.05581435639144740625194812
             + y*(-410542.08066896138826072428557906
             + 123967.60867258834076892458819446*y
             + 1.1157084780532950669203212937502e6*z)
             + z*(-2.4994767852492649226461743269078e6
             + 2.6033197821243551561474163520837e6*z)))
             + x*(-49909.037257795306023852756286082
             + z*(326018.71111946933773645752090102
             + z*(-490235.54338705389304074723513265
             + 157776.95649238516097863129406568*z))
             + x*(70838.633527193337582242621825407
             + x*(-45884.114898295684570316243682366
             + 11269.782606598940069902235290406*x
             + 157776.95649238516097863129406568*y
             + 101428.04345939046062912011761365*z)
             + z*(-311528.99062527070050372607552764
             + 236665.43473857774146794694109852*z)
             + y*(-484600.65208375442300579611748744
             + 405712.1738375618425164804704546*y
             + 1.3185645649720759881785615289775e6*z))
             + y*(507140.21729695230314560058806825
             + y*(-840403.78866352095949842383165596
             + 383172.60862436396237667599987379*y
             + 2.332844999565980594469762705114e6*z)
             + z*(-2.7313123131564431183698774528819e6
             + 2.8399852168629328976153632931822e6*z))));
            return;
          case ( 76 ):
            grad[0]= -845.44662752890557615309930825128
             + z*(24028.483098189947953824927708194
             + z*(-158854.97159358910036139813318195
             + z*(398694.83066626284012272472641745
             + z*(-420498.4542183240891919362348934
             + 156986.08957484099329832286102687*z))))
             + y*(4004.7471830316579923041546180324
             + y*(-7564.5224568375762076856253896167
             + y*(7119.5505476118364307629415431687
             + y*(-3337.2893191930483269201288483603
             + 622.9606729160356876917573850273*y
             + 18688.820187481070630752721550818*z)
             + z*(-80094.943660633159846083092360648
             + 130821.74131236749441526905085572*z))
             + z*(128151.90985701305575373294777704
             + z*(-420498.4542183240891919362348934
             + 348857.97683297998510738413561527*z)))
             + z*(-90774.269482050914492227504675401
             + z*(448531.68449954569513806531721963
             + z*(-747552.80749924282523010886203271
             + 392465.22393710248324580715256717*z))))
             + x*(7119.5505476118364307629415431687
             + z*(-165529.55023197519701523839087867
             + z*(840996.9084366481783838724697868
             + z*(-1.4452687611652027954448771332632e6
             + 784930.4478742049664916143051343*z)))
             + x*(-20023.735915158289961520773090162
             + x*(25808.370735092907061515663093986
             + x*(-15796.502777513762080755276548906
             + 3737.7640374962141261505443101636*x
             + 15574.016822900892192293934625681*y
             + 93444.10093740535315376360775409*z)
             + y*(-50726.797651734334569185958495077
             + 24918.42691664142750767029540109*y
             + 299021.12299969713009204354481308*z)
             + z*(-304360.78591040600741511575097046
             + 523286.9652494699776610762034229*z))
             + z*(352417.75210678590332276560638685
             + z*(-1.2054289020925290556835505400277e6
             + 1.0465739304989399553221524068458e6*z))
             + y*(58736.292017797650553794267731142
             + y*(-57401.376290120431223026216191798
             + 18688.820187481070630752721550818*y
             + 336398.76337465927135354898791472*z)
             + z*(-688816.51548144517467631459430157
             + 1.1773956718113074497374214577015e6*z)))
             + y*(-27588.258371995866169206398479779
             + y*(40047.471830316579923041546180324
             + y*(-25808.370735092907061515663093986
             + 6229.606729160356876917573850273*y
             + 149510.56149984856504602177240654*z)
             + z*(-464550.67323167232710728193569176
             + 784930.4478742049664916143051343*z))
             + z*(480569.66196379895907649855416389
             + z*(-1.6259273563108531448754867749211e6
             + 1.3954319073319199404295365424611e6*z))));
            grad[1]= -222.48595461286988846134192322402
             + y*(889.94381845147955384536769289609
             + z*(-16018.98873212663196921661847213
             + (56066.460562443211892258164652453
             - 49836.853833282855015340590802181*z)*z)
             + y*(-1334.9157276772193307680515393441
             + y*(889.94381845147955384536769289609
             - 222.48595461286988846134192322402*y
             - 5339.662910708877323072206157377*z)
             + (16018.98873212663196921661847213
             - 28033.230281221605946129082326227*z)*z))
             + z*(5339.6629107088773230722061573765
             + z*(-28033.230281221605946129082326227
             + (49836.853833282855015340590802181
             - 28033.230281221605946129082326227*z)*z))
             + x*(4004.7471830316579923041546180324
             + z*(-90774.269482050914492227504675401
             + z*(448531.68449954569513806531721963
             + z*(-747552.80749924282523010886203271
             + 392465.22393710248324580715256717*z)))
             + y*(-15129.044913675152415371250779233
             + y*(21358.651642835509292288824629506
             + y*(-13349.157276772193307680515393441
             + 3114.8033645801784384587869251363*y
             + 74755.28074992428252301088620327*z)
             + z*(-240284.83098189947953824927708194
             + 392465.22393710248324580715256717*z))
             + z*(256303.81971402611150746589555407
             + z*(-840996.9084366481783838724697868
             + 697715.9536659599702147682712305*z)))
             + x*(-13794.129185997933084603199239889
             + x*(19578.764005932550184598089243714
             + x*(-12681.699412933583642296489623769
             + 3114.8033645801784384587869251363*x
             + 12459.213458320713753835147700545*y
             + 74755.28074992428252301088620327*z)
             + y*(-38267.584193413620815350810794532
             + 18688.820187481070630752721550818*y
             + 224265.84224977284756903265860981*z)
             + z*(-229605.50516048172489210486476719
             + 392465.22393710248324580715256717*z))
             + z*(240284.83098189947953824927708194
             + z*(-812963.67815542657243774338746057
             + 697715.9536659599702147682712305*z))
             + y*(40047.471830316579923041546180324
             + y*(-38712.55610263936059227349464098
             + 12459.213458320713753835147700545*y
             + 224265.84224977284756903265860981*z)
             + z*(-464550.67323167232710728193569176
             + 784930.4478742049664916143051343*z))));
            grad[2]= -1334.9157276772193307680515393441
             + y*(5339.6629107088773230722061573765
             + z*(-56066.460562443211892258164652453
             + (149510.56149984856504602177240654
             - 112132.92112488642378451632930491*z)*z)
             + y*(-8009.4943660633159846083092360648
             + y*(5339.6629107088773230722061573765
             - 1334.9157276772193307680515393441*y
             - 18688.820187481070630752721550818*z)
             + (56066.460562443211892258164652453
             - 74755.28074992428252301088620327*z)*z))
             + z*(18688.820187481070630752721550818
             + z*(-74755.280749924282523010886203271
             + (112132.92112488642378451632930491
             - 56066.46056244321189225816465245*z)*z))
             + x*(24028.483098189947953824927708194
             + z*(-317709.9431871782007227962663639
             + z*(1.1960844919987885203681741792523e6
             + z*(-1.6819938168732963567677449395736e6
             + 784930.4478742049664916143051343*z)))
             + y*(-90774.269482050914492227504675401
             + y*(128151.90985701305575373294777704
             + y*(-80094.943660633159846083092360648
             + 18688.820187481070630752721550818*y
             + 261643.48262473498883053810171145*z)
             + z*(-840996.9084366481783838724697868
             + 1.0465739304989399553221524068458e6*z))
             + z*(897063.36899909139027613063443925
             + z*(-2.2426584224977284756903265860981e6
             + 1.5698608957484099329832286102687e6*z)))
             + x*(-82764.775115987598507619195439336
             + x*(117472.58403559530110758853546228
             + x*(-76090.196477601501853778937742615
             + 18688.820187481070630752721550818*x
             + 74755.28074992428252301088620327*y
             + 261643.48262473498883053810171145*z)
             + y*(-229605.50516048172489210486476719
             + 112132.92112488642378451632930491*y
             + 784930.4478742049664916143051343*z)
             + z*(-803619.26806168603712236702668517
             + 1.0465739304989399553221524068458e6*z))
             + z*(840996.9084366481783838724697868
             + z*(-2.1679031417478041931673156998949e6
             + 1.5698608957484099329832286102687e6*z))
             + y*(240284.83098189947953824927708194
             + y*(-232275.33661583616355364096784588
             + 74755.28074992428252301088620327*y
             + 784930.4478742049664916143051343*z)
             + z*(-1.6259273563108531448754867749211e6
             + 2.0931478609978799106443048136916e6*z))));
            return;
          case ( 77 ):
            grad[0]= -86.948260477136631442311984943019
             + y*(3477.9304190854652576924793977207
             + y*(-31301.373771769187319232314579487
             + y*(104337.91257256395773077438193162
             + y*(-143464.62978727544187981477515598
             + 68863.02229789221210231109207487*y))))
             + x*(434.74130238568315721155992471509
             + x*(-869.48260477136631442311984943019
             + x*(869.48260477136631442311984943019
             + x*(-434.74130238568315721155992471509
             + 86.94826047713663144231198494302*x
             + 3477.9304190854652576924793977207*y)
             + y*(-13911.721676341861030769917590883
             + 31301.373771769187319232314579487*y))
             + y*(20867.582514512791546154876386324
             + y*(-93904.12131530756195769694373846
             + 104337.91257256395773077438193162*y)))
             + y*(-13911.721676341861030769917590883
             + y*(93904.12131530756195769694373846
             + y*(-208675.82514512791546154876386324
             + 143464.62978727544187981477515598*y))));
            grad[1]= -695.58608381709305153849587954415
             + y*(15650.686885884593659616157289743
             + y*(-104337.91257256395773077438193162
             + y*(286929.25957455088375962955031196
             + y*(-344315.11148946106051155546037435
             + 149203.21497876645955500736616222*y))))
             + x*(3477.9304190854652576924793977207
             + x*(-6955.8608381709305153849587954415
             + x*(6955.8608381709305153849587954415
             + x*(-3477.9304190854652576924793977207
             + 695.5860838170930515384958795441*x
             + 15650.686885884593659616157289743*y)
             + y*(-62602.747543538374638464629158973
             + 104337.91257256395773077438193162*y))
             + y*(93904.12131530756195769694373846
             + y*(-313013.73771769187319232314579487
             + 286929.25957455088375962955031196*y)))
             + y*(-62602.747543538374638464629158973
             + y*(313013.73771769187319232314579487
             + y*(-573858.51914910176751925910062392
             + 344315.11148946106051155546037435*y))));
            grad[2]= 0;
            return;
          case ( 78 ):
            grad[0]= -150.59880477613359863607096464133
             + 250.99800796022266439345160773556*z
             + y*(5772.9541830851212810493869779178
             - 9035.92828656801591816425787848*z
             + y*(-49697.60557612408754990341833164
             + 67769.4621492601193862319340886*z
             + y*(158128.7450149402785678745128734
             - 165658.68525374695849967806110547*z
             + y*(-207073.35656718369812459757638183
             + 94425.45059463576634481649483012*y
             + 124244.0139403102188747585458291*z))))
             + x*(752.99402388066799318035482320667
             - 1003.9920318408906575738064309422*z
             + x*(-1505.9880477613359863607096464133
             + 1505.9880477613359863607096464133*z
             + x*(1505.9880477613359863607096464133
             - 1003.9920318408906575738064309422*z
             + x*(-752.99402388066799318035482320667
             + 150.59880477613359863607096464133*x
             + 5772.954183085121281049386977918*y
             + 250.99800796022266439345160773556*z)
             + y*(-23091.816732340485124197547911671
             + 49697.60557612408754990341833164*y
             + 9035.92828656801591816425787848*z))
             + y*(34637.725098510727686296321867507
             - 27107.78485970404775449277363544*z
             + y*(-149092.81672837226264971025499492
             + 158128.7450149402785678745128734*y
             + 67769.4621492601193862319340886*z)))
             + y*(-23091.816732340485124197547911671
             + 27107.78485970404775449277363544*z
             + y*(149092.81672837226264971025499492
             - 135538.9242985202387724638681772*z
             + y*(-316257.4900298805571357490257468
             + 207073.35656718369812459757638183*y
             + 165658.68525374695849967806110547*z))));
            grad[1]= -1154.5908366170242562098773955836
             + 2258.98207164200397954106446962*z
             + y*(24848.80278806204377495170916582
             - 45179.6414328400795908212893924*z
             + y*(-158128.7450149402785678745128734
             + 248488.0278806204377495170916582*z
             + y*(414146.71313436739624919515276367
             - 496976.0557612408754990341833164*z
             + y*(-472127.25297317883172408247415058
             + 193820.6617468839414446233314934*y
             + 323034.43624480656907437221915566*z))))
             + x*(5772.9541830851212810493869779178
             - 9035.92828656801591816425787848*z
             + x*(-11545.908366170242562098773955836
             + 13553.89242985202387724638681772*z
             + x*(11545.908366170242562098773955836
             - 9035.92828656801591816425787848*z
             + x*(-5772.9541830851212810493869779178
             + 1154.5908366170242562098773955836*x
             + 24848.80278806204377495170916582*y
             + 2258.98207164200397954106446962*z)
             + y*(-99395.21115224817509980683666328
             + 158128.7450149402785678745128734*y
             + 45179.6414328400795908212893924*z))
             + y*(149092.81672837226264971025499492
             - 135538.9242985202387724638681772*z
             + y*(-474386.2350448208357036235386202
             + 414146.71313436739624919515276367*y
             + 248488.0278806204377495170916582*z)))
             + y*(-99395.21115224817509980683666328
             + 135538.9242985202387724638681772*z
             + y*(474386.2350448208357036235386202
             - 496976.0557612408754990341833164*z
             + y*(-828293.42626873479249839030552734
             + 472127.25297317883172408247415058*y
             + 496976.0557612408754990341833164*z))));
            grad[2]= -50.199601592044532878690321547111
             + y*(2258.98207164200397954106446962
             + y*(-22589.8207164200397954106446962
             + y*(82829.342626873479249839030552734
             + y*(-124244.0139403102188747585458291
             + 64606.88724896131381487444383113*y))))
             + x*(250.99800796022266439345160773556
             + x*(-501.99601592044532878690321547111
             + x*(501.99601592044532878690321547111
             + x*(-250.99800796022266439345160773556
             + 50.19960159204453287869032154711*x
             + 2258.98207164200397954106446962*y)
             + y*(-9035.92828656801591816425787848
             + 22589.8207164200397954106446962*y))
             + y*(13553.89242985202387724638681772
             + y*(-67769.4621492601193862319340886
             + 82829.34262687347924983903055273*y)))
             + y*(-9035.92828656801591816425787848
             + y*(67769.4621492601193862319340886
             + y*(-165658.68525374695849967806110547
             + 124244.0139403102188747585458291*y))));
            return;
          case ( 79 ):
            grad[0]= -194.42222095223580692897902308264
             + (972.1111047611790346448951154132
             - 777.6888838089432277159160923306*z)*z
             + y*(6804.7777333282532425142658078924
             + z*(-31885.244236166672336352559785553
             + 23330.666514268296831477482769917*z)
             + y*(-53271.688540912611098540252324643
             + (215808.66525698174569116671562173
             - 128318.66582847563257312615523454*z)*z
             + y*(153593.55455226628747389342823529
             + z*(-470501.77470441065276812923585999
             + 171091.55443796751009750154031272*z)
             + y*(-181784.77659034047947859538658227
             + 74852.55506661078566765692388682*y
             + 310103.44241881611205172154181681*z))))
             + x*(972.1111047611790346448951154132
             + z*(-3888.4444190447161385795804616528
             + 2333.0666514268296831477482769917*z)
             + x*(-1944.2222095223580692897902308264
             + (5832.6666285670742078693706924792
             - 2333.0666514268296831477482769917*z)*z
             + x*(1944.2222095223580692897902308264
             + z*(-3888.4444190447161385795804616528
             + 777.6888838089432277159160923306*z)
             + x*(-972.1111047611790346448951154132
             + 194.42222095223580692897902308264*x
             + 6804.777733328253242514265807892*y
             + 972.1111047611790346448951154132*z)
             + y*(-27219.11093331301297005706323157
             + 53271.68854091261109854025232464*y
             + 31885.244236166672336352559785553*z))
             + y*(40828.666399969519455085594847354
             + z*(-95655.732708500017009057679356659
             + 23330.666514268296831477482769917*z)
             + y*(-159815.06562273783329562075697393
             + 153593.55455226628747389342823529*y
             + 215808.66525698174569116671562173*z)))
             + y*(-27219.11093331301297005706323157
             + (95655.732708500017009057679356659
             - 46661.333028536593662954965539834*z)*z
             + y*(159815.06562273783329562075697393
             + z*(-431617.33051396349138233343124346
             + 128318.66582847563257312615523454*z)
             + y*(-307187.10910453257494778685647057
             + 181784.77659034047947859538658227*y
             + 470501.77470441065276812923585999*z))));
            grad[1]= -1360.9555466656506485028531615785
             + (7971.3110590416680840881399463882
             - 7776.888838089432277159160923306*z)*z
             + y*(26635.844270456305549270126162322
             + z*(-143872.44350465449712744447708115
             + 128318.66582847563257312615523454*z)
             + y*(-153593.55455226628747389342823529
             + (705752.66205661597915219385378998
             - 513274.6633139025302925046209382*z)*z
             + y*(363569.55318068095895719077316454
             + z*(-1.2404137696752644482068861672672e6
             + 556047.5519233944078168800060164*z)
             + y*(-374262.77533305392833828461943408
             + 139011.88798084860195422000150409*y
             + 695059.4399042430097711000075204*z))))
             + x*(6804.7777333282532425142658078924
             + z*(-31885.244236166672336352559785553
             + 23330.666514268296831477482769917*z)
             + x*(-13609.555466656506485028531615785
             + (47827.866354250008504528839678329
             - 23330.666514268296831477482769917*z)*z
             + x*(13609.555466656506485028531615785
             + z*(-31885.244236166672336352559785553
             + 7776.888838089432277159160923306*z)
             + x*(-6804.7777333282532425142658078924
             + 1360.9555466656506485028531615785*x
             + 26635.844270456305549270126162322*y
             + 7971.311059041668084088139946388*z)
             + y*(-106543.37708182522219708050464929
             + 153593.55455226628747389342823529*y
             + 143872.44350465449712744447708115*z))
             + y*(159815.06562273783329562075697393
             + z*(-431617.33051396349138233343124346
             + 128318.66582847563257312615523454*z)
             + y*(-460780.66365679886242168028470586
             + 363569.55318068095895719077316454*y
             + 705752.66205661597915219385379*z)))
             + y*(-106543.37708182522219708050464929
             + (431617.33051396349138233343124346
             - 256637.33165695126514625231046908*z)*z
             + y*(460780.66365679886242168028470586
             + z*(-1.41150532411323195830438770758e6
             + 513274.6633139025302925046209382*z)
             + y*(-727139.10636136191791438154632907
             + 374262.77533305392833828461943408*y
             + 1.2404137696752644482068861672672e6*z))));
            grad[2]= -194.42222095223580692897902308264
             + 388.84444190447161385795804616528*z
             + y*(7971.3110590416680840881399463882
             - 15553.777676178864554318321846611*z
             + y*(-71936.221752327248563722238540577
             + 128318.66582847563257312615523454*z
             + y*(235250.88735220532638406461792999
             - 342183.10887593502019500308062545*z
             + y*(-310103.44241881611205172154181681
             + 139011.88798084860195422000150409*y
             + 278023.77596169720390844000300818*z))))
             + x*(972.1111047611790346448951154132
             - 1555.3777676178864554318321846611*z
             + x*(-1944.2222095223580692897902308264
             + 2333.0666514268296831477482769917*z
             + x*(1944.2222095223580692897902308264
             - 1555.3777676178864554318321846611*z
             + x*(-972.1111047611790346448951154132
             + 194.42222095223580692897902308264*x
             + 7971.311059041668084088139946388*y
             + 388.84444190447161385795804616528*z)
             + y*(-31885.244236166672336352559785553
             + 71936.22175232724856372223854058*y
             + 15553.777676178864554318321846611*z))
             + y*(47827.866354250008504528839678329
             - 46661.333028536593662954965539834*z
             + y*(-215808.66525698174569116671562173
             + 235250.88735220532638406461792999*y
             + 128318.66582847563257312615523454*z)))
             + y*(-31885.244236166672336352559785553
             + 46661.333028536593662954965539834*z
             + y*(215808.66525698174569116671562173
             - 256637.33165695126514625231046908*z
             + y*(-470501.77470441065276812923585999
             + 310103.44241881611205172154181681*y
             + 342183.10887593502019500308062545*z))));
            return;
          case ( 80 ):
            grad[0]= -230.04347415216976765192730877634
             + z*(2300.4347415216976765192730877634
             + z*(-4600.8694830433953530385461755267
             + 2300.4347415216976765192730877634*z))
             + y*(6901.3042245650930295578192632901
             + z*(-64412.172762607534942539646457374
             + (117322.17181760658150248292747593
             - 50609.56431347734888342400793079*z)*z)
             + y*(-46008.694830433953530385461755267
             + z*(365769.12390194993056656442095438
             + z*(-531400.42529151216327595208327334
             + 151828.69294043204665027202379238*z))
             + y*(112721.30233456318614944438130041
             + y*(-113871.51970532403498770401784429
             + 40487.651450781879106739206344635*y
             + 354266.95019434144218396805551556*z)
             + z*(-657924.33607520553548451210310032
             + 556705.2074482508377176640872387*z))))
             + x*(1150.2173707608488382596365438817
             + z*(-9201.7389660867907060770923510535
             + (13802.60844913018605911563852658
             - 4600.8694830433953530385461755267*z)*z)
             + x*(-2300.4347415216976765192730877634
             + z*(13802.60844913018605911563852658
             + z*(-13802.60844913018605911563852658
             + 2300.4347415216976765192730877634*z))
             + x*(2300.4347415216976765192730877634
             + x*(-1150.2173707608488382596365438817
             + 230.04347415216976765192730877634*x
             + 6901.30422456509302955781926329*y
             + 2300.4347415216976765192730877634*z)
             + z*(-9201.7389660867907060770923510535
             + 4600.8694830433953530385461755267*z)
             + y*(-27605.21689826037211823127705316
             + 46008.694830433953530385461755267*y
             + 64412.17276260753494253964645737*z))
             + y*(41407.825347390558177346915579741
             + z*(-193236.51828782260482761893937212
             + 117322.17181760658150248292747593*z)
             + y*(-138026.0844913018605911563852658
             + 112721.30233456318614944438130041*y
             + 365769.12390194993056656442095438*z)))
             + y*(-27605.21689826037211823127705316
             + z*(193236.51828782260482761893937212
             + z*(-234644.34363521316300496585495186
             + 50609.56431347734888342400793079*z))
             + y*(138026.0844913018605911563852658
             + z*(-731538.24780389986113312884190875
             + 531400.4252915121632759520832733*z)
             + y*(-225442.60466912637229888876260081
             + 113871.51970532403498770401784429*y
             + 657924.3360752055354845121031003*z))));
            grad[1]= -1380.260844913018605911563852658
             + z*(16103.043190651883735634911614344
             + z*(-39107.390605868860500827642491977
             + 25304.782156738674441712003965397*z))
             + y*(23004.347415216976765192730877634
             + z*(-243846.08260129995371104294730292
             + (531400.42529151216327595208327334
             - 303657.38588086409330054404758476*z)*z)
             + y*(-112721.30233456318614944438130041
             + z*(986886.50411280830322676815465049
             + z*(-1.6701156223447525131529922617162e6
             + 657924.3360752055354845121031003*z))
             + y*(227743.03941064806997540803568857
             + y*(-202438.25725390939553369603172318
             + 65792.43360752055354845121031003*y
             + 657924.3360752055354845121031003*z)
             + z*(-1.4170678007773657687358722220622e6
             + 1.3158486721504110709690242062006e6*z))))
             + x*(6901.3042245650930295578192632901
             + z*(-64412.172762607534942539646457374
             + (117322.17181760658150248292747593
             - 50609.56431347734888342400793079*z)*z)
             + x*(-13802.60844913018605911563852658
             + z*(96618.259143911302413809469686061
             + z*(-117322.17181760658150248292747593
             + 25304.782156738674441712003965397*z))
             + x*(13802.60844913018605911563852658
             + x*(-6901.3042245650930295578192632901
             + 1380.260844913018605911563852658*x
             + 23004.347415216976765192730877634*y
             + 16103.043190651883735634911614344*z)
             + z*(-64412.172762607534942539646457374
             + 39107.390605868860500827642491977*z)
             + y*(-92017.389660867907060770923510535
             + 112721.30233456318614944438130041*y
             + 243846.08260129995371104294730292*z))
             + y*(138026.0844913018605911563852658
             + z*(-731538.24780389986113312884190875
             + 531400.4252915121632759520832733*z)
             + y*(-338163.90700368955844833314390122
             + 227743.03941064806997540803568857*y
             + 986886.5041128083032267681546505*z)))
             + y*(-92017.389660867907060770923510535
             + z*(731538.24780389986113312884190875
             + z*(-1.0628008505830243265519041665467e6
             + 303657.38588086409330054404758476*z))
             + y*(338163.90700368955844833314390122
             + y*(-455486.07882129613995081607137715
             + 202438.25725390939553369603172318*y
             + 1.4170678007773657687358722220622e6*z)
             + z*(-1.973773008225616606453536309301e6
             + 1.6701156223447525131529922617162e6*z))));
            grad[2]= -460.08694830433953530385461755267
             + (2300.4347415216976765192730877634
             - 2300.4347415216976765192730877634*z)*z
             + y*(16103.043190651883735634911614344
             + z*(-78214.781211737721001655284983955
             + 75914.34647021602332513601189619*z)
             + y*(-121923.04130064997685552147365146
             + (531400.42529151216327595208327334
             - 455486.07882129613995081607137715*z)*z
             + y*(328962.16803760276774225605155016
             + z*(-1.1134104148965016754353281744775e6
             + 657924.3360752055354845121031003*z)
             + y*(-354266.95019434144218396805551556
             + 131584.86721504110709690242062006*y
             + 657924.3360752055354845121031003*z))))
             + x*(2300.4347415216976765192730877634
             + z*(-9201.7389660867907060770923510535
             + 6901.30422456509302955781926329*z)
             + x*(-4600.8694830433953530385461755267
             + (13802.60844913018605911563852658
             - 6901.30422456509302955781926329*z)*z
             + x*(4600.8694830433953530385461755267
             + z*(-9201.7389660867907060770923510535
             + 2300.4347415216976765192730877634*z)
             + x*(-2300.4347415216976765192730877634
             + 460.08694830433953530385461755267*x
             + 16103.043190651883735634911614344*y
             + 2300.4347415216976765192730877634*z)
             + y*(-64412.172762607534942539646457374
             + 121923.04130064997685552147365146*y
             + 78214.78121173772100165528498395*z))
             + y*(96618.259143911302413809469686061
             + z*(-234644.34363521316300496585495186
             + 75914.34647021602332513601189619*z)
             + y*(-365769.12390194993056656442095438
             + 328962.16803760276774225605155016*y
             + 531400.4252915121632759520832733*z)))
             + y*(-64412.172762607534942539646457374
             + (234644.34363521316300496585495186
             - 151828.69294043204665027202379238*z)*z
             + y*(365769.12390194993056656442095438
             + z*(-1.0628008505830243265519041665467e6
             + 455486.07882129613995081607137715*z)
             + y*(-657924.33607520553548451210310032
             + 354266.95019434144218396805551556*y
             + 1.1134104148965016754353281744775e6*z))));
            return;
          case ( 81 ):
            grad[0]= -260.84478143140989432693595482906
             + z*(4347.4130238568315721155992471509
             + z*(-15650.686885884593659616157289743
             + (18259.134700198692602885516838034
             - 6086.378233399564200961838946011*z)*z))
             + y*(6086.3782333995642009618389460113
             + z*(-93904.12131530756195769694373846
             + z*(305188.39427474957636251506715
             + z*(-304318.91166997821004809194730057
             + 73036.53880079477041154206735214*z)))
             + y*(-31301.373771769187319232314579487
             + z*(399092.51559005713832021201088846
             + z*(-993818.6172536716973856259878987
             + 620810.5798067555484981075724932*z))
             + y*(59994.299729224275695195269610683
             + y*(-49125.767169582196764906271492806
             + 14607.307760158954082308413470427*y
             + 224326.51203101250912116492115299*z)
             + z*(-533862.31932961891705579558755013
             + 704280.9098648067146827270780385*z))))
             + x*(1304.2239071570494716346797741453
             + z*(-17389.652095427326288462396988604
             + z*(46952.06065765378097884847186923
             + z*(-36518.269400397385205771033676068
             + 6086.378233399564200961838946011*z)))
             + x*(-2608.4478143140989432693595482906
             + z*(26084.478143140989432693595482906
             + z*(-46952.06065765378097884847186923
             + 18259.134700198692602885516838034*z))
             + x*(2608.4478143140989432693595482906
             + x*(-1304.2239071570494716346797741453
             + 260.84478143140989432693595482906*x
             + 6086.378233399564200961838946011*y
             + 4347.4130238568315721155992471509*z)
             + z*(-17389.652095427326288462396988604
             + 15650.686885884593659616157289743*z)
             + y*(-24345.512933598256803847355784045
             + 31301.373771769187319232314579487*y
             + 93904.12131530756195769694373846*z))
             + y*(36518.269400397385205771033676068
             + z*(-281712.36394592268587309083121538
             + 305188.39427474957636251506715*z)
             + y*(-93904.12131530756195769694373846
             + 59994.29972922427569519526961068*y
             + 399092.51559005713832021201088846*z)))
             + y*(-24345.512933598256803847355784045
             + z*(281712.36394592268587309083121538
             + z*(-610376.78854949915272503013429999
             + 304318.91166997821004809194730057*z))
             + y*(93904.12131530756195769694373846
             + y*(-119988.59945844855139039053922137
             + 49125.767169582196764906271492806*y
             + 533862.3193296189170557955875501*z)
             + z*(-798185.03118011427664042402177691
             + 993818.6172536716973856259878987*z))));
            grad[1]= -1217.2756466799128401923677892023
             + z*(23476.030328826890489424235934615
             + z*(-101729.46475824985878750502238333
             + (152159.45583498910502404597365028
             - 73036.53880079477041154206735214*z)*z))
             + y*(15650.686885884593659616157289743
             + z*(-266061.67706003809221347467392564
             + z*(993818.6172536716973856259878987
             + z*(-1.2416211596135110969962151449863e6
             + 474737.50220516600767502343778888*z)))
             + y*(-59994.299729224275695195269610683
             + y*(98251.534339164393529812542985611
             + y*(-73036.538800794770411542067352136
             + 20345.892951649971757501004476666*y
             + 339098.21586083286262501674127777*z)
             + z*(-897306.04812405003648465968461195
             + 1.2207535770989983054500602686e6*z))
             + z*(800793.4789944283755836933813252
             + z*(-2.1128427295944201440481812341154e6
             + 1.4242125066154980230250703133666e6*z))))
             + x*(6086.3782333995642009618389460113
             + z*(-93904.12131530756195769694373846
             + z*(305188.39427474957636251506715
             + z*(-304318.91166997821004809194730057
             + 73036.53880079477041154206735214*z)))
             + x*(-12172.756466799128401923677892023
             + z*(140856.18197296134293654541560769
             + z*(-305188.39427474957636251506715
             + 152159.45583498910502404597365028*z))
             + x*(12172.756466799128401923677892023
             + x*(-6086.3782333995642009618389460113
             + 1217.2756466799128401923677892023*x
             + 15650.686885884593659616157289743*y
             + 23476.030328826890489424235934615*z)
             + z*(-93904.12131530756195769694373846
             + 101729.46475824985878750502238333*z)
             + y*(-62602.747543538374638464629158973
             + 59994.29972922427569519526961068*y
             + 266061.67706003809221347467392564*z))
             + y*(93904.12131530756195769694373846
             + y*(-179982.89918767282708558580883205
             + 98251.53433916439352981254298561*y
             + 800793.4789944283755836933813252*z)
             + z*(-798185.03118011427664042402177691
             + 993818.6172536716973856259878987*z)))
             + y*(-62602.747543538374638464629158973
             + z*(798185.03118011427664042402177691
             + z*(-1.9876372345073433947712519757974e6
             + 1.2416211596135110969962151449863e6*z))
             + y*(179982.89918767282708558580883205
             + y*(-196503.06867832878705962508597122
             + 73036.53880079477041154206735214*y
             + 897306.048124050036484659684612*z)
             + z*(-1.6015869579888567511673867626504e6
             + 2.1128427295944201440481812341154e6*z))));
            grad[2]= -869.48260477136631442311984943019
             + z*(7825.3434429422968298080786448717
             + z*(-18259.134700198692602885516838034
             + 12172.756466799128401923677892023*z))
             + y*(23476.030328826890489424235934615
             + z*(-203458.92951649971757501004476666
             + (456478.36750496731507213792095085
             - 292146.15520317908164616826940854*z)*z)
             + y*(-133030.83853001904610673733696282
             + z*(993818.6172536716973856259878987
             + z*(-1.8624317394202666454943227174795e6
             + 949475.0044103320153500468755778*z))
             + y*(266931.15966480945852789779377507
             + y*(-224326.51203101250912116492115299
             + 67819.64317216657252500334825555*y
             + 610376.7885494991527250301343*z)
             + z*(-1.4085618197296134293654541560769e6
             + 1.4242125066154980230250703133666e6*z))))
             + x*(4347.4130238568315721155992471509
             + z*(-31301.373771769187319232314579487
             + (54777.404100596077808656550514102
             - 24345.512933598256803847355784045*z)*z)
             + x*(-8694.8260477136631442311984943019
             + z*(46952.06065765378097884847186923
             + z*(-54777.404100596077808656550514102
             + 12172.756466799128401923677892023*z))
             + x*(8694.8260477136631442311984943019
             + x*(-4347.4130238568315721155992471509
             + 869.4826047713663144231198494302*x
             + 23476.030328826890489424235934615*y
             + 7825.343442942296829808078644872*z)
             + z*(-31301.373771769187319232314579487
             + 18259.134700198692602885516838034*z)
             + y*(-93904.12131530756195769694373846
             + 133030.83853001904610673733696282*y
             + 203458.92951649971757501004476666*z))
             + y*(140856.18197296134293654541560769
             + z*(-610376.78854949915272503013429999
             + 456478.36750496731507213792095085*z)
             + y*(-399092.51559005713832021201088846
             + 266931.15966480945852789779377507*y
             + 993818.6172536716973856259878987*z)))
             + y*(-93904.12131530756195769694373846
             + z*(610376.78854949915272503013429999
             + z*(-912956.7350099346301442758419017
             + 292146.15520317908164616826940854*z))
             + y*(399092.51559005713832021201088846
             + y*(-533862.31932961891705579558755013
             + 224326.51203101250912116492115299*y
             + 1.4085618197296134293654541560769e6*z)
             + z*(-1.9876372345073433947712519757974e6
             + 1.8624317394202666454943227174795e6*z))));
            return;
          case ( 82 ):
            grad[0]= -288.37475617674997871304561246848
             + z*(7209.368904418749467826140311712
             + z*(-40372.465864744997019826385745587
             + z*(80744.931729489994039652771491175
             + z*(-60558.698797117495529739578618381
             + 12111.739759423499105947915723676*z))))
             + y*(4325.6213426512496806956841870272
             + z*(-98047.417100094992762435508239284
             + z*(484469.59037693996423791662894705
             + z*(-807449.31729489994039652771491175
             + 423910.89157982246870817705032867*z)))
             + y*(-14418.737808837498935652280623424
             + y*(20186.232932372498509913192872794
             + y*(-12976.864027953749042087052561082
             + 3172.1223179442497658435017371533*y
             + 76419.31038683874435895708730415*z)
             + z*(-236467.30006493498254469740222415
             + 403724.65864744997019826385745587*z))
             + z*(250886.03787377248148034968284758
             + z*(-847821.78315964493741635410065734
             + 726704.3855654099463568749434206*z))))
             + x*(1441.8737808837498935652280623424
             + z*(-28837.475617674997871304561246848
             + z*(121117.39759423499105947915723676
             + z*(-161489.86345897998807930554298235
             + 60558.69879711749552973957861838*z)))
             + x*(-2883.7475617674997871304561246848
             + z*(43256.213426512496806956841870272
             + z*(-121117.39759423499105947915723676
             + 80744.93172948999403965277149117*z))
             + x*(2883.7475617674997871304561246848
             + x*(-1441.8737808837498935652280623424
             + 288.37475617674997871304561246848*x
             + 4325.6213426512496806956841870272*y
             + 7209.368904418749467826140311712*z)
             + z*(-28837.475617674997871304561246848
             + 40372.465864744997019826385745587*z)
             + y*(-17302.485370604998722782736748109
             + 14418.737808837498935652280623424*y
             + 98047.41710009499276243550823928*z))
             + y*(25953.728055907498084174105122163
             + y*(-43256.213426512496806956841870272
             + 20186.232932372498509913192872794*y
             + 250886.03787377248148034968284758*z)
             + z*(-294142.25130028497828730652471785
             + 484469.59037693996423791662894705*z)))
             + y*(-17302.485370604998722782736748109
             + z*(294142.25130028497828730652471785
             + z*(-968939.1807538799284758332578941
             + 807449.3172948999403965277149117*z))
             + y*(43256.213426512496806956841870272
             + y*(-40372.465864744997019826385745587
             + 12976.864027953749042087052561082*y
             + 236467.30006493498254469740222415*z)
             + z*(-501772.07574754496296069936569516
             + 847821.7831596449374163541006573*z))));
            grad[1]= -865.12426853024993613913683740545
             + z*(24511.854275023748190608877059821
             + z*(-161489.86345897998807930554298235
             + z*(403724.65864744997019826385745587
             + z*(-423910.89157982246870817705032867
             + 157452.61687250548837732290440779*z))))
             + y*(7209.368904418749467826140311712
             + z*(-167257.35858251498765356645523172
             + z*(847821.78315964493741635410065734
             + z*(-1.4534087711308198927137498868411e6
             + 787263.084362527441886614522039*z)))
             + y*(-20186.232932372498509913192872794
             + y*(25953.728055907498084174105122163
             + y*(-15860.611589721248829217508685766
             + 3748.8718302977497232695929620903*y
             + 93721.79575744374308173982405226*z)
             + z*(-305677.24154735497743582834921659
             + 524842.0562416849612577430146926*z))
             + z*(354700.95009740247381704610333623
             + z*(-1.2111739759423499105947915723676e6
             + 1.0496841124833699225154860293853e6*z))))
             + x*(4325.6213426512496806956841870272
             + z*(-98047.417100094992762435508239284
             + z*(484469.59037693996423791662894705
             + z*(-807449.31729489994039652771491175
             + 423910.89157982246870817705032867*z)))
             + x*(-8651.2426853024993613913683740545
             + x*(8651.2426853024993613913683740545
             + x*(-4325.6213426512496806956841870272
             + 865.1242685302499361391368374054*x
             + 7209.368904418749467826140311712*y
             + 24511.854275023748190608877059821*z)
             + z*(-98047.417100094992762435508239284
             + 161489.86345897998807930554298235*z)
             + y*(-28837.475617674997871304561246848
             + 20186.232932372498509913192872794*y
             + 167257.35858251498765356645523172*z))
             + z*(147071.12565014248914365326235893
             + z*(-484469.59037693996423791662894705
             + 403724.65864744997019826385745587*z))
             + y*(43256.213426512496806956841870272
             + y*(-60558.698797117495529739578618381
             + 25953.728055907498084174105122163*y
             + 354700.95009740247381704610333623*z)
             + z*(-501772.07574754496296069936569516
             + 847821.7831596449374163541006573*z)))
             + y*(-28837.475617674997871304561246848
             + y*(60558.698797117495529739578618381
             + y*(-51907.456111814996168348210244327
             + 15860.611589721248829217508685766*y
             + 305677.24154735497743582834921659*z)
             + z*(-709401.90019480494763409220667246
             + 1.2111739759423499105947915723676e6*z))
             + z*(501772.07574754496296069936569516
             + z*(-1.6956435663192898748327082013147e6
             + 1.4534087711308198927137498868411e6*z))));
            grad[2]= -1441.8737808837498935652280623424
             + z*(20186.232932372498509913192872794
             + z*(-80744.931729489994039652771491175
             + (121117.39759423499105947915723676
             - 60558.69879711749552973957861838*z)*z))
             + y*(24511.854275023748190608877059821
             + z*(-322979.7269179599761586110859647
             + z*(1.2111739759423499105947915723676e6
             + z*(-1.6956435663192898748327082013147e6
             + 787263.084362527441886614522039*z)))
             + y*(-83628.67929125749382678322761586
             + y*(118233.65003246749127234870111208
             + y*(-76419.310386838744358957087304148
             + 18744.359151488748616347964810451*y
             + 262421.02812084248062887150734632*z)
             + z*(-807449.31729489994039652771491175
             + 1.0496841124833699225154860293853e6*z))
             + z*(847821.78315964493741635410065734
             + z*(-2.1801131566962298390706248302617e6
             + 1.5745261687250548837732290440779e6*z))))
             + x*(7209.368904418749467826140311712
             + z*(-80744.931729489994039652771491175
             + z*(242234.79518846998211895831447352
             + z*(-242234.79518846998211895831447352
             + 60558.69879711749552973957861838*z)))
             + x*(-14418.737808837498935652280623424
             + z*(121117.39759423499105947915723676
             + z*(-242234.79518846998211895831447352
             + 121117.39759423499105947915723676*z))
             + x*(14418.737808837498935652280623424
             + x*(-7209.368904418749467826140311712
             + 1441.8737808837498935652280623424*x
             + 24511.854275023748190608877059821*y
             + 20186.232932372498509913192872794*z)
             + z*(-80744.931729489994039652771491175
             + 80744.93172948999403965277149117*z)
             + y*(-98047.417100094992762435508239284
             + 83628.67929125749382678322761586*y
             + 322979.7269179599761586110859647*z))
             + y*(147071.12565014248914365326235893
             + y*(-250886.03787377248148034968284758
             + 118233.65003246749127234870111208*y
             + 847821.7831596449374163541006573*z)
             + z*(-968939.1807538799284758332578941
             + 1.2111739759423499105947915723676e6*z)))
             + y*(-98047.417100094992762435508239284
             + z*(968939.1807538799284758332578941
             + z*(-2.4223479518846998211895831447352e6
             + 1.6956435663192898748327082013147e6*z))
             + y*(250886.03787377248148034968284758
             + y*(-236467.30006493498254469740222415
             + 76419.31038683874435895708730415*y
             + 807449.3172948999403965277149117*z)
             + z*(-1.6956435663192898748327082013147e6
             + 2.1801131566962298390706248302617e6*z))));
            return;
          case ( 83 ):
            grad[0]= -313.49641146271515176276561636484
             + z*(10972.374401195030311696796572769
             + z*(-87778.995209560242493574372582155
             + z*(263336.98562868072748072311774647
             + z*(-329171.23203585090935090389718308
             + 144835.34209577440011439771476056*z))))
             + y*(1567.4820573135757588138280818242
             + y*(-3134.9641146271515176276561636484
             + y*(3134.9641146271515176276561636484
             + y*(-1567.4820573135757588138280818242
             + 313.49641146271515176276561636484*y
             + 10972.374401195030311696796572769*z)
             + z*(-43889.497604780121246787186291078
             + 87778.99520956024249357437258216*z))
             + z*(65834.246407170181870180779436617
             + z*(-263336.98562868072748072311774647
             + 263336.98562868072748072311774647*z)))
             + z*(-43889.497604780121246787186291078
             + z*(263336.98562868072748072311774647
             + z*(-526673.97125736145496144623549293
             + 329171.23203585090935090389718308*z))))
             + x*(1567.4820573135757588138280818242
             + x*(-3134.9641146271515176276561636484
             + x*(3134.9641146271515176276561636484
             + x*(-1567.4820573135757588138280818242
             + 313.49641146271515176276561636484*x
             + 1567.4820573135757588138280818242*y
             + 10972.374401195030311696796572769*z)
             + y*(-6269.9282292543030352553123272968
             + 3134.9641146271515176276561636484*y
             + 43889.497604780121246787186291078*z)
             + z*(-43889.497604780121246787186291078
             + 87778.99520956024249357437258216*z))
             + z*(65834.246407170181870180779436617
             + z*(-263336.98562868072748072311774647
             + 263336.98562868072748072311774647*z))
             + y*(9404.8923438814545528829684909452
             + y*(-9404.8923438814545528829684909452
             + 3134.9641146271515176276561636484*y
             + 65834.24640717018187018077943662*z)
             + z*(-131668.49281434036374036155887323
             + 263336.98562868072748072311774647*z)))
             + z*(-43889.497604780121246787186291078
             + z*(263336.98562868072748072311774647
             + z*(-526673.97125736145496144623549293
             + 329171.23203585090935090389718308*z)))
             + y*(-6269.9282292543030352553123272968
             + y*(9404.8923438814545528829684909452
             + y*(-6269.9282292543030352553123272968
             + 1567.4820573135757588138280818242*y
             + 43889.497604780121246787186291078*z)
             + z*(-131668.49281434036374036155887323
             + 263336.98562868072748072311774647*z))
             + z*(131668.49281434036374036155887323
             + z*(-526673.97125736145496144623549293
             + 526673.9712573614549614462354929*z))));
            grad[1]= -313.49641146271515176276561636484
             + z*(10972.374401195030311696796572769
             + z*(-87778.995209560242493574372582155
             + z*(263336.98562868072748072311774647
             + z*(-329171.23203585090935090389718308
             + 144835.34209577440011439771476056*z))))
             + y*(1567.4820573135757588138280818242
             + y*(-3134.9641146271515176276561636484
             + y*(3134.9641146271515176276561636484
             + y*(-1567.4820573135757588138280818242
             + 313.49641146271515176276561636484*y
             + 10972.374401195030311696796572769*z)
             + z*(-43889.497604780121246787186291078
             + 87778.99520956024249357437258216*z))
             + z*(65834.246407170181870180779436617
             + z*(-263336.98562868072748072311774647
             + 263336.98562868072748072311774647*z)))
             + z*(-43889.497604780121246787186291078
             + z*(263336.98562868072748072311774647
             + z*(-526673.97125736145496144623549293
             + 329171.23203585090935090389718308*z))))
             + x*(1567.4820573135757588138280818242
             + x*(-3134.9641146271515176276561636484
             + x*(3134.9641146271515176276561636484
             + x*(-1567.4820573135757588138280818242
             + 313.49641146271515176276561636484*x
             + 1567.4820573135757588138280818242*y
             + 10972.374401195030311696796572769*z)
             + y*(-6269.9282292543030352553123272968
             + 3134.9641146271515176276561636484*y
             + 43889.497604780121246787186291078*z)
             + z*(-43889.497604780121246787186291078
             + 87778.99520956024249357437258216*z))
             + z*(65834.246407170181870180779436617
             + z*(-263336.98562868072748072311774647
             + 263336.98562868072748072311774647*z))
             + y*(9404.8923438814545528829684909452
             + y*(-9404.8923438814545528829684909452
             + 3134.9641146271515176276561636484*y
             + 65834.24640717018187018077943662*z)
             + z*(-131668.49281434036374036155887323
             + 263336.98562868072748072311774647*z)))
             + z*(-43889.497604780121246787186291078
             + z*(263336.98562868072748072311774647
             + z*(-526673.97125736145496144623549293
             + 329171.23203585090935090389718308*z)))
             + y*(-6269.9282292543030352553123272968
             + y*(9404.8923438814545528829684909452
             + y*(-6269.9282292543030352553123272968
             + 1567.4820573135757588138280818242*y
             + 43889.497604780121246787186291078*z)
             + z*(-131668.49281434036374036155887323
             + 263336.98562868072748072311774647*z))
             + z*(131668.49281434036374036155887323
             + z*(-526673.97125736145496144623549293
             + 526673.9712573614549614462354929*z))));
            grad[2]= -2194.4748802390060623393593145539
             + z*(43889.497604780121246787186291078
             + z*(-263336.98562868072748072311774647
             + z*(658342.46407170181870180779436617
             + z*(-724176.71047887200057198857380278
             + 289670.68419154880022879542952111*z))))
             + y*(10972.374401195030311696796572769
             + y*(-21944.748802390060623393593145539
             + y*(21944.748802390060623393593145539
             + y*(-10972.374401195030311696796572769
             + 2194.4748802390060623393593145539*y
             + 43889.497604780121246787186291078*z)
             + z*(-175557.99041912048498714874516431
             + 263336.98562868072748072311774647*z))
             + z*(263336.98562868072748072311774647
             + z*(-790010.9568860421824421693532394
             + 658342.4640717018187018077943662*z)))
             + z*(-175557.99041912048498714874516431
             + z*(790010.9568860421824421693532394
             + z*(-1.3166849281434036374036155887323e6
             + 724176.7104788720005719885738028*z))))
             + x*(10972.374401195030311696796572769
             + z*(-175557.99041912048498714874516431
             + z*(790010.9568860421824421693532394
             + z*(-1.3166849281434036374036155887323e6
             + 724176.7104788720005719885738028*z)))
             + x*(-21944.748802390060623393593145539
             + x*(21944.748802390060623393593145539
             + x*(-10972.374401195030311696796572769
             + 2194.4748802390060623393593145539*x
             + 10972.374401195030311696796572769*y
             + 43889.497604780121246787186291078*z)
             + y*(-43889.497604780121246787186291078
             + 21944.748802390060623393593145539*y
             + 175557.99041912048498714874516431*z)
             + z*(-175557.99041912048498714874516431
             + 263336.98562868072748072311774647*z))
             + z*(263336.98562868072748072311774647
             + z*(-790010.9568860421824421693532394
             + 658342.4640717018187018077943662*z))
             + y*(65834.246407170181870180779436617
             + y*(-65834.246407170181870180779436617
             + 21944.748802390060623393593145539*y
             + 263336.98562868072748072311774647*z)
             + z*(-526673.97125736145496144623549293
             + 790010.9568860421824421693532394*z)))
             + y*(-43889.497604780121246787186291078
             + y*(65834.246407170181870180779436617
             + y*(-43889.497604780121246787186291078
             + 10972.374401195030311696796572769*y
             + 175557.99041912048498714874516431*z)
             + z*(-526673.97125736145496144623549293
             + 790010.9568860421824421693532394*z))
             + z*(526673.97125736145496144623549293
             + z*(-1.5800219137720843648843387064788e6
             + 1.3166849281434036374036155887323e6*z))));
             return;
          #endif
          #if (PMAX3D>=7)
          case ( 84 ):
            grad[0]= 408.16663263917103296119070142819
             + x*(-13469.49887709264408771929314713
             + x*(134694.9887709264408771929314713
             + x*(-583678.28467401457713450270304231
             + x*(1.2257243978154306119824556763889e6
             + x*(-1.2257243978154306119824556763889e6
             + 466942.62773921166170760216243385*x)))));
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 85 ):
            grad[0]= 552.49615383276651367606892070053
             - 1632.7498277445935777292783029657*y
             + x*(-17415.998162608998162445635231635
             + 48982.494832337807331878349088972*y
             + x*(165996.23248736701373580996080152
             - 424514.95521359433020961235877109*y
             + x*(-683940.76117745753200437546690898
             + 1.4858023432475801557336432556988e6*y
             + x*(1.3619854813102818094225063177239e6
             - 2.2287035148713702336004648835482e6*y
             + x*(-1.287695364147902801635824154939e6
             + 462249.61789924715956157790177297*x
             + 1.1886418745980641245869146045591e6*y)))));
            grad[1]= 24.738633753705963298928459135844
             + x*(-1632.7498277445935777292783029657
             + x*(24491.247416168903665939174544486
             + x*(-141504.98507119811006987078625703
             + x*(371450.5858118950389334108139247
             + x*(-445740.70297427404672009297670965
             + 198106.97909967735409781910075984*x)))));
            grad[2]= 0;
            return;
          case ( 86 ):
            grad[0]= 956.95140942474189973191957472321
             - 942.6685525676561997359207751005*y
             - 1885.337105135312399471841550201*z
             + x*(-30165.393682164998391549464803215
             + 28280.056577029685992077623253014*y
             + 56560.11315405937198415524650603*z
             + x*(287513.90853313514091945583640565
             - 245093.82366759061193133940152612*y
             - 490187.64733518122386267880305225*z
             + x*(-1.1846201477266879576681404407096e6
             + 857828.3828365671417596879053414*y
             + 1.7156567656731342835193758106829e6*z
             + x*(2.3590280528005596398391417396889e6
             - 1.2867425742548507126395318580122e6*y
             - 2.5734851485097014252790637160243e6*z
             + x*(-2.2303537953750745685751885538877e6
             + 800639.823980795998975708711652*x
             + 686262.7062692537134077503242731*y
             + 1.3725254125385074268155006485463e6*z)))));
            grad[1]= 14.282856857085699995998799622735
             + x*(-942.66855256765619973592077510048
             + x*(14140.028288514842996038811626507
             + x*(-81697.941222530203977113133842042
             + x*(214457.09570914178543992197633536
             + x*(-257348.51485097014252790637160243
             + 114377.11771154228556795838737886*x)))));
            grad[2]= 28.565713714171399991997599245469
             + x*(-1885.337105135312399471841550201
             + x*(28280.056577029685992077623253014
             + x*(-163395.88244506040795422626768408
             + x*(428914.19141828357087984395267072
             + x*(-514697.02970194028505581274320486
             + 228754.23542308457113591677475772*x)))));
            return;
          case ( 87 ):
            grad[0]= 626.16930617844883310852992685832
             + y*(-4928.55840992069404124133232753
             + 6059.702963017246772018031550242*y)
             + x*(-18199.307898928464471960821422559
             + (135737.34637158632769320390672542
             - 157552.27703844841607246882030629*y)*y
             + x*(159370.18792735359010407422977136
             + y*(-1.0713554838614492292927879780827e6
             + 1.102865939269138912507281742144e6*y)
             + x*(-601324.52403007812134325599750232
             + (3.3821222137586926650223306759083e6
             - 2.75716484817284728126820435536e6*y)*y
             + x*(1.0936753897752294215697210609595e6
             + x*(-942950.37807511377019372588953312
             + 308802.46299535889550203888780032*x
             + 2.1175026033967467120139809449165e6*y)
             + y*(-4.5217503510034695412798551427904e6
             + 2.205731878538277825014563484288e6*y)))));
            grad[1]= 80.796039506896623626907087336557
             - 201.99009876724155906726771834139*y
             + x*(-4928.55840992069404124133232753
             + 12119.405926034493544036063100484*y
             + x*(67868.673185793163846601953362708
             - 157552.27703844841607246882030629*y
             + x*(-357118.49462048307643092932602758
             + 735243.9595127592750048544947627*y
             + x*(845530.55343967316625558266897707
             - 1.37858242408642364063410217768e6*y
             + x*(-904350.07020069390825597102855808
             + 352917.10056612445200233015748608*x
             + 882292.7514153111300058253937152*y)))));
            grad[2]= 0;
            return;
          case ( 88 ):
            grad[0]= 1084.5570524412258875825924352235
             - 2134.1283935133799723399399531817*z
             + y*(-6402.3851805401399170198198595451
             + 5247.856705360770423786737589791*y
             + 10495.713410721540847573475179582*z)
             + x*(-31522.125943533694345545670456011
             + y*(176327.98530012188623923438301698
             - 136444.27433938003101845517733457*y
             - 272888.54867876006203691035466913*z)
             + 58775.99510004062874641146100566*z
             + x*(276037.26270197652429118239722301
             - 463910.53275389210546274760293753*z
             + y*(-1.3917315982616763163882428088126e6
             + 955109.920375660217129186241342*y
             + 1.9102198407513204342583724826839e6*z)
             + x*(-1.0415246274572675701075411869872e6
             + y*(4.393505633728036998794256710173e6
             - 2.3877748009391505428229656033549e6*y
             - 4.7755496018783010856459312067098e6*z)
             + 1.4645018779093456662647522367243e6*z
             + x*(1.8943013420783927639728860453282e6
             - 1.957975336770103445114831794751e6*z
             + x*(-1.6332379638423789712909084726948e6
             + 534861.5554103697215923442951515*x
             + 2.7507165706819014253320563750649e6*y
             + 916905.5235606338084440187916883*z)
             + y*(-5.8739260103103103353444953842531e6
             + 1.9102198407513204342583724826839e6*y
             + 3.8204396815026408685167449653679e6*z)))));
            grad[1]= 104.95713410721540847573475179582
             - 174.92855684535901412622458632637*y
             - 174.92855684535901412622458632637*z
             + x*(-6402.3851805401399170198198595451
             + 10495.713410721540847573475179582*y
             + 10495.713410721540847573475179582*z
             + x*(88163.992650060943119617191508489
             - 136444.27433938003101845517733457*y
             - 136444.27433938003101845517733457*z
             + x*(-463910.53275389210546274760293753
             + 636739.946917106811419457494228*y
             + 636739.946917106811419457494228*z
             + x*(1.0983764084320092496985641775433e6
             - 1.1938874004695752714114828016775e6*y
             - 1.1938874004695752714114828016775e6*z
             + x*(-1.1747852020620620670688990768506e6
             + 458452.76178031690422200939584414*x
             + 764087.9363005281737033489930736*y
             + 764087.9363005281737033489930736*z)))));
            grad[2]= 34.985711369071802825244917265273
             - 174.92855684535901412622458632637*y
             + x*(-2134.1283935133799723399399531817
             + 10495.713410721540847573475179582*y
             + x*(29387.99755002031437320573050283
             - 136444.27433938003101845517733457*y
             + x*(-154636.84425129736848758253431251
             + 636739.946917106811419457494228*y
             + x*(366125.46947733641656618805918109
             - 1.1938874004695752714114828016775e6*y
             + x*(-391595.06735402068902296635895021
             + 152817.58726010563474066979861471*x
             + 764087.9363005281737033489930736*y)))));
            return;
          case ( 89 ):
            grad[0]= 1400.1571340388906506826709913009
             + z*(-8265.443726745709324997702948647
             + 8129.944649258074745899379949489*z)
             + y*(-2755.1479089152364416659009828823
             + 1354.9907748763457909832299915815*y
             + 8129.944649258074745899379949489*z)
             + x*(-40694.889605452918589196340747163
             + y*(75879.483393075364295060879528562
             - 35229.760146784990565563979781118*y
             - 211378.56088070994339338387868671*z)
             + (227638.45017922609288518263858569
             - 211378.56088070994339338387868671*z)*z
             + x*(356362.57379247894302858948778593
             + z*(-1.796717767486034518843762968837e6
             + 1.479649926164969603753687150807e6*z)
             + y*(-598905.92249534483961458765627901
             + 246608.32102749493395894785846783*y
             + 1.479649926164969603753687150807e6*z)
             + x*(-1.344602512268960473252358561646e6
             + y*(1.8906637945441278270186002482533e6
             - 616520.8025687373348973696461696*y
             - 3.6991248154124240093842178770174e6*z)
             + (5.67199138363238348105580074476e6
             - 3.6991248154124240093842178770174e6*z)*z
             + x*(2.445532516855991428426232929806e6
             + z*(-7.5832058715954692192376466478857e6
             + 2.9592998523299392075073743016139e6*z)
             + y*(-2.5277352905318230730792155492952e6
             + 493216.64205498986791789571693565*y
             + 2.9592998523299392075073743016139e6*z)
             + x*(-2.1085011447850816853490041898999e6
             + 690503.2988769858150850540037099*x
             + 1.1837199409319756830029497206456e6*y
             + 3.5511598227959270490088491619367e6*z)))));
            grad[1]= 45.166359162544859699440999719382
             - 45.166359162544859699440999719382*y
             - 135.49907748763457909832299915815*z
             + x*(-2755.1479089152364416659009828823
             + 2709.9815497526915819664599831629*y
             + 8129.944649258074745899379949489*z
             + x*(37939.741696537682147530439764281
             - 35229.760146784990565563979781118*y
             - 105689.28044035497169669193934335*z
             + x*(-199635.30749844827987152921875967
             + 164405.54735166328930596523897855*y
             + 493216.64205498986791789571693565*z
             + x*(472665.94863603195675465006206334
             - 308260.40128436866744868482308478*y
             - 924781.2038531060023460544692544*z
             + x*(-505547.05810636461461584310985905
             + 197286.65682199594716715828677426*x
             + 197286.65682199594716715828677426*y
             + 591859.9704659878415014748603228*z)))));
            grad[2]= 135.49907748763457909832299915815
             - 135.49907748763457909832299915815*y
             - 270.99815497526915819664599831629*z
             + x*(-8265.443726745709324997702948647
             + 8129.944649258074745899379949489*y
             + 16259.889298516149491798759898978*z
             + x*(113819.22508961304644259131929284
             - 105689.28044035497169669193934335*y
             - 211378.56088070994339338387868671*z
             + x*(-598905.92249534483961458765627901
             + 493216.64205498986791789571693565*y
             + 986433.2841099797358357914338713*z
             + x*(1.41799784590809587026395018619e6
             - 924781.2038531060023460544692544*y
             - 1.8495624077062120046921089385087e6*z
             + x*(-1.5166411743190938438475293295771e6
             + 591859.9704659878415014748603228*x
             + 591859.9704659878415014748603228*y
             + 1.1837199409319756830029497206456e6*z)))));
            return;
          case ( 90 ):
            grad[0]= 641.40470843298305179615681653001
             + y*(-9446.1420696493867628161276616238
             + (27813.640538412083246069709225892
             - 21224.664897236893713981916474266*y)*y)
             + x*(-16443.284343463747327865111114679
             + y*(227756.98101265743639234441139693
             + y*(-627643.66196114814268489381573901
             + 445717.96284197476799362024595958*y))
             + x*(126473.34659919456721326037591396
             + y*(-1.5554647274689323536103890216141e6
             + (3.7249286894650748468038263412337e6
             - 2.2285898142098738399681012297979e6*y)*y)
             + x*(-418429.10797409876178992921049267
             + y*(4.2024836496529049553684194619047e6
             + y*(-7.6408793630052817370334899307357e6
             + 2.9714530856131651199574683063972e6*y))
             + x*(668576.94426296215199043036893938
             + x*(-509391.95753368544913556599538238
             + 148572.65428065825599787341531986*x
             + 1.9102198407513204342583724826839e6*y)
             + y*(-4.7755496018783010856459312067098e6
             + 4.7755496018783010856459312067098e6*y)))));
            grad[1]= 174.92855684535901412622458632637
             + y*(-1049.5713410721540847573475179582
             + 1224.4998979175130988835721042846*y)
             + x*(-9446.1420696493867628161276616238
             + (55627.281076824166492139418451785
             - 63673.9946917106811419457494228*y)*y
             + x*(113878.49050632871819617220569847
             + y*(-627643.66196114814268489381573901
             + 668576.9442629621519904303689394*y)
             + x*(-518488.24248964411787012967387135
             + (2.4832857929767165645358842274891e6
             - 2.2285898142098738399681012297979e6*y)*y
             + x*(1.0506209124132262388421048654762e6
             + x*(-955109.92037566021712918624134197
             + 318369.97345855340570972874711399*x
             + 1.9102198407513204342583724826839e6*y)
             + y*(-3.8204396815026408685167449653679e6
             + 2.2285898142098738399681012297979e6*y)))));
            grad[2]= 0;
            return;
          case ( 91 ):
            grad[0]= 1110.9455432198285748699724508777
             - 2181.493066686208837926491358087*z
             + y*(-14179.704933460357446522193827566
             + y*(35328.068274390548680865123937909
             - 22057.31878538277825014563484288*y
             - 44114.63757076555650029126968576*z)
             + 25693.140563193126313356453773025*z)
             + x*(-28480.603926181059828484748286136
             + 52598.2217189897019811165138561*z
             + y*(341888.44117343306287725734006464
             - 579792.3795014901711466852587271*z
             + y*(-797214.52181454898532669223074981
             + 463203.69449303834325305833170048*y
             + 926407.388986076686506116663401*z))
             + x*(219058.26211307347080845184054124
             - 359219.19164766238864522891029833*z
             + y*(-2.3349247457098055261939879169392e6
             + y*(4.7312948794646059346562386737978e6
             - 2.3160184724651917162652916585024e6*y
             - 4.6320369449303834325305833170048e6*z)
             + 3.4409417305197134070227190354893e6*z)
             + x*(-724740.47437686271393335657340891
             + 970522.0265568422430064079330867*z
             + x*(1.1580092362325958581326458292512e6
             - 1.102865939269138912507281742144e6*z
             + x*(-882292.7514153111300058253937152
             + 257335.38582946574625169907316693*x
             + 2.8674514420997611725189325295744e6*y
             + 441146.3757076555650029126968576*z)
             + y*(-7.168628605249402931297331323936e6
             + 6.065762665980264018790049581792e6*y
             + 4.411463757076555650029126968576e6*z))
             + y*(6.3083931726194745795416515650637e6
             - 7.058342011322489040046603149722e6*z
             + y*(-9.7052202655684224300640793308672e6
             + 3.0880246299535889550203888780032e6*y
             + 6.176049259907177910040777756006e6*z)))));
            grad[1]= 262.58712839741402678744803384381
             - 484.77623704137974176144252401934*z
             + y*(-1333.1346518637942898439669410532
             + 1272.5376222336218221237866255508*y
             + 1696.7168296448290961650488340677*z)
             + x*(-14179.704933460357446522193827566
             + y*(70656.136548781097361730247875819
             - 66171.95635614833475043690452864*y
             - 88229.27514153111300058253937152*z)
             + 25693.140563193126313356453773025*z
             + x*(170944.22058671653143862867003232
             - 289896.18975074508557334262936357*z
             + y*(-797214.52181454898532669223074981
             + 694805.5417395575148795874975507*y
             + 926407.388986076686506116663401*z)
             + x*(-778308.24856993517539799597231305
             + y*(3.1541965863097372897708257825318e6
             - 2.3160184724651917162652916585024e6*y
             - 3.0880246299535889550203888780032e6*z)
             + 1.1469805768399044690075730118298e6*z
             + x*(1.5770982931548686448854128912659e6
             - 1.7645855028306222600116507874304e6*z
             + x*(-1.4337257210498805862594662647872e6
             + 477908.57368329352875315542159573*x
             + 2.4263050663921056075160198327168e6*y
             + 882292.7514153111300058253937152*z)
             + y*(-4.8526101327842112150320396654336e6
             + 2.3160184724651917162652916585024e6*y
             + 3.0880246299535889550203888780032e6*z)))));
            grad[2]= 40.398019753448311813453543668278
             + y*(-484.77623704137974176144252401934
             + 848.3584148224145480825244170338*y)
             + x*(-2181.493066686208837926491358087
             + (25693.140563193126313356453773025
             - 44114.63757076555650029126968576*y)*y
             + x*(26299.110859494850990558256928049
             + y*(-289896.18975074508557334262936357
             + 463203.69449303834325305833170048*y)
             + x*(-119739.73054922079621507630343278
             + (1.1469805768399044690075730118298e6
             - 1.5440123149767944775101944390016e6*y)*y
             + x*(242630.50663921056075160198327168
             + x*(-220573.1878538277825014563484288
             + 73524.39595127592750048544947627*x
             + 882292.7514153111300058253937152*y)
             + y*(-1.7645855028306222600116507874304e6
             + 1.5440123149767944775101944390016e6*y)))));
            return;
          case ( 92 ):
            grad[0]= 1434.2245291445827172082537426344
             + z*(-8448.8863171426327340995311384282
             + 8292.42545941776916494953982105*z)
             + y*(-12673.329475713949101149296707642
             + y*(20731.063648544422912373849552625
             - 9491.958701975056528432806587617*y
             - 56951.7522118503391705968395257*z)
             + (66339.403675342153319596318568399
             - 56951.7522118503391705968395257*z)*z)
             + x*(-36768.301565342938750247959583901
             + (203712.03675777236703328869522655
             - 187127.18583893682870338961558445*z)*z
             + y*(305568.05513665855054993304283982
             + z*(-1.4970174867114946296271169246756e6
             + 1.1959867964488571225825336300397e6*z)
             + y*(-467817.96459734207175847403896112
             + 199331.13274147618709708893833995*y
             + 1.1959867964488571225825336300397e6*z))
             + x*(282803.00033769090123860930616128
             + z*(-1.3912499468894868568817227941278e6
             + 1.1105591681310816138266383707512e6*z)
             + y*(-2.0868749203342302853225841911918e6
             + y*(2.7763979203277040345665959268779e6
             - 996655.6637073809354854446916998*y
             - 5.979933982244285612912668150199e6*z)
             + (8.8844733450486529106131069660094e6
             - 5.979933982244285612912668150199e6*z)*z)
             + x*(-935635.92919468414351694807792224
             + (3.7588156459821223852593914086963e6
             - 2.2780700884740135668238735810281e6*z)*z
             + y*(5.6382234689731835778890871130444e6
             + z*(-1.8224560707792108534590988648224e7
             + 7.973245309659047483883557533598e6*z)
             + y*(-5.6951752211850339170596839525701e6
             + 1.3288742182765079139805929222664e6*y
             + 7.973245309659047483883557533598e6*z))
             + x*(1.4949834955610714032281670375497e6
             + z*(-4.2713814158887754377947629644276e6
             + 1.4237938052962584792649209881425e6*z)
             + x*(-1.139035044237006783411936790514e6
             + 332218.55456912697849514823056659*x
             + 2.5628288495332652626768577786566e6*y
             + 1.708552566355510175117905185771e6*z)
             + y*(-6.4070721238331631566921444466414e6
             + 3.5594845132406461981623024703563e6*y
             + 1.139035044237006783411936790514e7*z)))));
            grad[1]= 234.69128658729535372498697606745
             + z*(-1251.6868617989085531999305390264
             + 1095.2260040740449840499392216481*z)
             + y*(-782.3042886243178457499565868915
             + 547.6130020370224920249696108241*y
             + 2190.4520081480899680998784432962*z)
             + x*(-12673.329475713949101149296707642
             + y*(41462.12729708884582474769910525
             - 28475.876105925169585298419762851*y
             - 113903.5044237006783411936790514*z)
             + (66339.403675342153319596318568399
             - 56951.7522118503391705968395257*z)*z
             + x*(152784.02756832927527496652141991
             + z*(-748508.74335574731481355846233779
             + 597993.3982244285612912668150199*z)
             + y*(-467817.96459734207175847403896112
             + 298996.69911221428064563340750993*y
             + 1.1959867964488571225825336300397e6*z)
             + x*(-695624.97344474342844086139706392
             + y*(1.8509319468851360230443972845853e6
             - 996655.6637073809354854446916998*y
             - 3.9866226548295237419417787667991e6*z)
             + (2.9614911150162176368710356553365e6
             - 1.9933113274147618709708893833995e6*z)*z
             + x*(1.4095558672432958944722717782611e6
             + z*(-4.5561401769480271336477471620561e6
             + 1.9933113274147618709708893833995e6*z)
             + x*(-1.2814144247666326313384288893283e6
             + 427138.14158887754377947629644276*x
             + 1.4237938052962584792649209881425e6*y
             + 2.2780700884740135668238735810281e6*z)
             + y*(-2.8475876105925169585298419762851e6
             + 996655.6637073809354854446916998*y
             + 3.9866226548295237419417787667991e6*z)))));
            grad[2]= 156.4608577248635691499913173783
             - 312.9217154497271382999826347566*z
             + y*(-1251.6868617989085531999305390264
             + 1095.2260040740449840499392216481*y
             + 2190.4520081480899680998784432962*z)
             + x*(-8448.8863171426327340995311384282
             + y*(66339.403675342153319596318568399
             - 56951.7522118503391705968395257*y
             - 113903.5044237006783411936790514*z)
             + 16584.8509188355383298990796421*z
             + x*(101856.01837888618351664434761327
             - 187127.18583893682870338961558445*z
             + y*(-748508.74335574731481355846233779
             + 597993.3982244285612912668150199*y
             + 1.1959867964488571225825336300397e6*z)
             + x*(-463749.98229649561896057426470928
             + y*(2.9614911150162176368710356553365e6
             - 1.9933113274147618709708893833995e6*y
             - 3.9866226548295237419417787667991e6*z)
             + 740372.7787540544092177589138341*z
             + x*(939703.91149553059631484785217407
             - 1.139035044237006783411936790514e6*z
             + x*(-854276.28317775508755895259288552
             + 284758.76105925169585298419762851*x
             + 2.2780700884740135668238735810281e6*y
             + 569517.522118503391705968395257*z)
             + y*(-4.5561401769480271336477471620561e6
             + 1.9933113274147618709708893833995e6*y
             + 3.9866226548295237419417787667991e6*z)))));
            return;
          case ( 93 ):
            grad[0]= 1696.9973482595663737986658590798
             + y*(-4998.4285530554500464615248940168
             + y*(4905.8650613322009715270522107942
             - 1604.4338565363172988641931758572*y
             - 19253.206278435807586370318110287*z)
             + (39246.920490657607772216417686354
             - 48133.015696089518965925795275717*z)*z)
             + z*(-19993.714212221800185846099576067
             + (49058.650613322009715270522107942
             - 32088.677130726345977283863517145*z)*z)
             + x*(-43504.84110992706521920216111459
             + z*(482070.66489468118225873373422295
             + z*(-1.1070593610100589362162932913415e6
             + 673862.21974525326552296113386*z))
             + y*(120517.66622367029556468343355574
             + y*(-110705.93610100589362162932913415
             + 33693.110987262663276148056693002*y
             + 404317.33184715195931377668031602*z)
             + z*(-885647.48880804714897303463307319
             + 1.0107933296178798982844417007901e6*z))
             + x*(334617.02257954540588811874984946
             + y*(-823074.56840313077431733109921476
             + y*(657015.66425162193388488710551354
             - 168465.55493631331638074028346501*y
             - 2.0215866592357597965688834015801e6*z)
             + (5.2561253140129754710790968441083e6
             - 5.05396664808939949142220850395e6*z)*z)
             + z*(-3.292298273612523097269324396859e6
             + (6.5701566425162193388488710551354e6
             - 3.3693110987262663276148056693002e6*z)*z)
             + x*(-1.1070593610100589362162932913415e6
             + z*(8.8949813006373431049030869669525e6
             + z*(-1.3477244394905065310459222677201e7
             + 4.4924147983016884368197408924003e6*z))
             + y*(2.2237453251593357762257717417381e6
             + y*(-1.3477244394905065310459222677201e6
             + 224620.73991508442184098704462001*y
             + 2.6954488789810130620918445354402e6*z)
             + z*(-1.0781795515924052248367378141761e7
             + 6.7386221974525326552296113386e6*z))
             + x*(1.7688883268312898219977729763826e6
             + x*(-1.3477244394905065310459222677201e6
             + 393086.29485139773822172732808502*x
             + 1.0107933296178798982844417007901e6*y
             + 4.0431733184715195931377668031602e6*z)
             + y*(-2.5269833240446997457111042519751e6
             + 842327.774681566581903701417325*y
             + 6.7386221974525326552296113386e6*z)
             + z*(-1.0107933296178798982844417007901e7
             + 8.42327774681566581903701417325e6*z)))));
            grad[1]= 92.563491723249074934472683222533
             + y*(-185.12698344649814986894536644507
             + 92.56349172324907493447268322253*y
             + 740.5079337859925994757814657803*z)
             + z*(-740.50793378599259947578146578026
             + 925.6349172324907493447268322253*z)
             + x*(-4998.4285530554500464615248940168
             + y*(9811.7301226644019430541044215885
             - 4813.3015696089518965925795275717*y
             - 38506.412556871615172740636220574*z)
             + (39246.920490657607772216417686354
             - 48133.015696089518965925795275717*z)*z
             + x*(60258.833111835147782341716777869
             + y*(-110705.93610100589362162932913415
             + 50539.6664808939949142220850395*y
             + 404317.33184715195931377668031602*z)
             + z*(-442823.7444040235744865173165366
             + 505396.664808939949142220850395*z)
             + x*(-274358.18946771025810577703307159
             + y*(438010.44283441462258992473700902
             - 168465.55493631331638074028346501*y
             - 1.3477244394905065310459222677201e6*z)
             + (1.7520417713376584903596989480361e6
             - 1.6846555493631331638074028346501e6*z)*z
             + x*(555936.33128983394405644293543453
             + y*(-673862.21974525326552296113386004
             + 168465.55493631331638074028346501*y
             + 1.3477244394905065310459222677201e6*z)
             + x*(-505396.66480893994914222085039503
             + 168465.55493631331638074028346501*x
             + 336931.10987262663276148056693002*y
             + 1.3477244394905065310459222677201e6*z)
             + z*(-2.6954488789810130620918445354402e6
             + 1.6846555493631331638074028346501e6*z)))));
            grad[2]= 370.25396689299629973789073289013
             + z*(-1851.2698344649814986894536644507
             + 1851.2698344649814986894536644507*z)
             + y*(-740.50793378599259947578146578026
             + 370.25396689299629973789073289013*y
             + 1851.2698344649814986894536644507*z)
             + x*(-19993.714212221800185846099576067
             + y*(39246.920490657607772216417686354
             - 19253.206278435807586370318110287*y
             - 96266.03139217903793185159055143*z)
             + (98117.301226644019430541044215885
             - 96266.03139217903793185159055143*z)*z
             + x*(241035.33244734059112936686711148
             + z*(-1.1070593610100589362162932913415e6
             + 1.0107933296178798982844417007901e6*z)
             + y*(-442823.7444040235744865173165366
             + 202158.66592357597965688834015801*y
             + 1.0107933296178798982844417007901e6*z)
             + x*(-1.0974327578708410324231081322863e6
             + y*(1.7520417713376584903596989480361e6
             - 673862.21974525326552296113386*y
             - 3.3693110987262663276148056693002e6*z)
             + (4.3801044283441462258992473700902e6
             - 3.3693110987262663276148056693002e6*z)*z
             + x*(2.2237453251593357762257717417381e6
             + z*(-6.7386221974525326552296113386004e6
             + 3.3693110987262663276148056693002e6*z)
             + y*(-2.6954488789810130620918445354402e6
             + 673862.21974525326552296113386*y
             + 3.3693110987262663276148056693002e6*z)
             + x*(-2.0215866592357597965688834015801e6
             + 673862.21974525326552296113386*x
             + 1.3477244394905065310459222677201e6*y
             + 3.3693110987262663276148056693002e6*z)))));
            return;
          case ( 94 ):
            grad[0]= 599.76662127864368174163338328348
             + y*(-14081.477195237721223499218564047
             + y*(72284.916268886968947295988628775
             + y*(-125585.91513382382483772636408232
             + 68999.23825666483399514617096383*y)))
             + x*(-12751.559904576380885724292366331
             + y*(277874.48331935769881038457966386
             + y*(-1.3142712048888539808599270659777e6
             + (2.085310311756981649631084278018e6
             - 1.0349885738499725099271925644575e6*y)*y))
             + x*(81203.185159204192388845493719338
             + y*(-1.5320647188418640691167149797683e6
             + y*(6.0719329665865053915728630448171e6
             + y*(-7.6665820285183148883495745515367e6
             + 2.7599695302665933598058468385532e6*y)))
             + x*(-224208.4091197294945919375578031
             + x*(303925.21613054748307385813400735
             + x*(-199878.74574351320958911390795078
             + 51110.54685678876592233049701024*x
             + 1.0514169639110831846879416527822e6*y)
             + y*(-3.1213941116110282045423267816971e6
             + 4.599949217110988933009744730922e6*y))
             + y*(3.3382488604176891113842147475834e6
             + y*(-9.4298958950775273126699766983902e6
             + 6.542149997668962038058303617311e6*y)))));
            grad[1]= 312.9217154497271382999826347566
             + y*(-3285.6780122221349521498176649443
             + (8761.8080325923598723995137731848
             - 6571.356024444269904299635329889*y)*y)
             + x*(-14081.477195237721223499218564047
             + y*(144569.83253777393789459197725755
             + y*(-376757.74540147147451317909224695
             + 275996.95302665933598058468385532*y))
             + x*(138937.24165967884940519228983193
             + y*(-1.3142712048888539808599270659777e6
             + (3.127965467635472474446626417027e6
             - 2.0699771476999450198543851289149e6*y)*y)
             + x*(-510688.23961395468970557165992277
             + y*(4.0479553110576702610485753632114e6
             + y*(-7.6665820285183148883495745515367e6
             + 3.6799593736887911464077957847376e6*y))
             + x*(834562.21510442227784605368689585
             + x*(-624278.82232220564090846535633942
             + 175236.1606518471974479902754637*x
             + 1.8399796868443955732038978923688e6*y)
             + y*(-4.7149479475387636563349883491951e6
             + 4.9066124982517215285437277129835e6*y)))));
            grad[2]= 0;
            return;
          case ( 95 ):
            grad[0]= 1038.8262607385317730871429935458
             - 2032.4861623145186864748449873722*z
             + y*(-22357.347785459705551223294861094
             + 41733.715866191450362283483740709*z
             + y*(104334.28966547862590570870935177
             - 163140.88929511203323438089098641*z
             + y*(-163140.88929511203323438089098641
             + 79673.45756272913250981392350499*y
             + 159346.91512545826501962784700998*z)))
             + x*(-22086.349630484436393026648862778
             + 40107.726936339835413103607750811*z
             + y*(441184.99629973818954413968525893
             - 758794.8339307536429506087952856*z
             + y*(-1.8969870848268841073765219882141e6
             + y*(2.7088975571327905053336733991697e6
             - 1.1951018634409369876472088525749e6*y
             - 2.3902037268818739752944177051497e6*z)
             + 2.7088975571327905053336733991697e6*z))
             + x*(140648.04243216469310405927312616
             - 221134.4944598196330884631346261*z
             + y*(-2.4324794390580159639730944808871e6
             + 3.5056321327600818304318126342196e6*z
             + y*(8.7640803319002045760795315855489e6
             - 9.959182195341141563726740438124e6*z
             + y*(-9.9591821953411415637267404381238e6
             + 3.1869383025091653003925569401996e6*y
             + 6.373876605018330600785113880399e6*z)))
             + x*(-388340.35607956070369579371558725
             + 481834.71954602856327363658500637*z
             + x*(526413.9160394603397969848517294
             - 450534.43264638497550192397220084*z
             + x*(-346200.14298090634959621526284907
             + 88526.06395858792501090435944999*x
             + 1.6693486346476580144913393496284e6*y
             + 151758.96678615072859012175905712*z)
             + y*(-4.9558787591102347305211636942092e6
             + 6.639454796894094375817826958749e6*y
             + 2.6557819187576377503271307834997e6*z))
             + y*(5.3001819150063141960100024350701e6
             - 5.444352933453157388170618106174e6*z
             + y*(-1.3610882333632893470426545265436e7
             + 8.498502140024440801046818507199e6*y
             + 8.498502140024440801046818507199e6*z)))));
            grad[1]= 496.82995078799345669385099691321
             - 948.493542413442053688260994107*z
             + y*(-4742.4677120672102684413049705351
             + y*(11381.922508961304644259131929284
             - 7587.948339307536429506087952856*y
             - 11381.922508961304644259131929284*z)
             + 7587.948339307536429506087952856*z)
             + x*(-22357.347785459705551223294861094
             + 41733.715866191450362283483740709*z
             + y*(208668.57933095725181141741870355
             - 326281.77859022406646876178197282*z
             + y*(-489422.66788533609970314267295923
             + 318693.83025091653003925569401996*y
             + 478040.74537637479505888354102994*z))
             + x*(220592.49814986909477206984262946
             - 379397.41696537682147530439764281*z
             + y*(-1.8969870848268841073765219882141e6
             + y*(4.0633463356991857580005100987545e6
             - 2.3902037268818739752944177051497e6*y
             - 3.5853055903228109629416265577246e6*z)
             + 2.7088975571327905053336733991697e6*z)
             + x*(-810826.47968600532132436482696235
             + 1.1685440442533606101439375447399e6*z
             + x*(1.3250454787515785490025006087675e6
             - 1.3610882333632893470426545265436e6*z
             + x*(-991175.75182204694610423273884184
             + 278224.7724412763357485565582714*x
             + 2.6557819187576377503271307834997e6*y
             + 531156.3837515275500654261566999*z)
             + y*(-6.8054411668164467352132726327179e6
             + 6.373876605018330600785113880399e6*y
             + 4.2492510700122204005234092535995e6*z))
             + y*(5.8427202212668030507196877236993e6
             - 6.639454796894094375817826958749e6*z
             + y*(-9.9591821953411415637267404381238e6
             + 4.2492510700122204005234092535995e6*y
             + 6.373876605018330600785113880399e6*z)))));
            grad[2]= 45.166359162544859699440999719382
             + y*(-948.49354241344205368826099410703
             + (3793.9741696537682147530439764281
             - 3793.9741696537682147530439764281*y)*y)
             + x*(-2032.4861623145186864748449873722
             + y*(41733.715866191450362283483740709
             + y*(-163140.88929511203323438089098641
             + 159346.91512545826501962784700998*y))
             + x*(20053.863468169917706551803875406
             + y*(-379397.41696537682147530439764281
             + (1.3544487785663952526668366995848e6
             - 1.1951018634409369876472088525749e6*y)*y)
             + x*(-73711.498153273211029487711542032
             + y*(1.1685440442533606101439375447399e6
             + y*(-3.3197273984470471879089134793746e6
             + 2.1246255350061102002617046267997e6*y))
             + x*(120458.67988650714081840914625159
             + x*(-90106.886529276995100384794440168
             + 25293.161131025121431686959842854*x
             + 531156.3837515275500654261566999*y)
             + y*(-1.3610882333632893470426545265436e6
             + 2.1246255350061102002617046267997e6*y)))));
            return;
          case ( 96 ):
            grad[0]= 1341.1189358144191083010551618355
             + z*(-7871.7850580411556356801063846865
             + 7696.85650119579662155388179836*z)
             + y*(-23615.35517412346690704031915406
             + (130846.56052032854256641599057212
             - 120350.84710960700171884251539254*z)*z
             + y*(88513.849763751661147869640681142
             + z*(-391140.25310622275558623817502576
             + 264491.97795018282935885157452547*z)
             + y*(-110321.60985047308490893897244316
             + 44081.996325030471559808595754245*y
             + 264491.97795018282935885157452547*z)))
             + x*(-28513.354765793519302574607571198
             + (155336.55847867880454408743265781
             - 139942.84547628721130097966906109*z)*z
             + y*(466009.67543603641363226229797344
             + z*(-2.3790283730968825921166543740386e6
             + 1.9983838334013813773779896741924e6*z)
             + y*(-1.6093427229773029299612661942026e6
             + y*(1.8318518472845995959298238680097e6
             - 661229.9448754570733971289363137*y
             - 3.967379669252742440382773617882e6*z)
             + (6.4947474585544894764784664411254e6
             - 3.967379669252742440382773617882e6*z)*z))
             + x*(181575.84200548265666302112060677
             + z*(-856450.2143148777331619955746539
             + 646535.9461004469162105260710623*z)
             + y*(-2.5693506429446331994859867239617e6
             + (1.0991111083707597575578943208058e7
             - 7.346999387505078593301432625707e6*z)*z
             + y*(7.4351633801551395364210498172159e6
             + z*(-2.3877748009391505428229656033549e7
             + 1.0579679118007313174354062981019e7*z)
             + y*(-6.7347494385463220438596465735651e6
             + 1.7632798530012188623923438301698e6*y
             + 1.0579679118007313174354062981019e7*z)))
             + x*(-501345.24391879893448575966441137
             + (1.8661378444262899626985638869297e6
             - 1.0040899162923607410845291255133e6*z)*z
             + x*(679597.44334421976988038251787794
             + z*(-1.7449123545324561659090902486055e6
             + 489799.95916700523955342884171383*z)
             + x*(-446942.46273989228109250381806387
             + 114286.65713896788922913339639989*x
             + 1.7632798530012188623923438301698e6*y
             + 587759.9510004062874641146100566*z)
             + y*(-5.2347370635973684977272707458165e6
             + 5.632699530420560254864431679709e6*y
             + 8.326599305839089072408290309135e6*z))
             + y*(5.5984135332788698880956916607891e6
             + z*(-1.7069528576970132598436995133727e7
             + 6.269439477337667066283889173937e6*z)
             + y*(-1.1547034037362148522472084943404e7
             + 5.746986187559528144093565076109e6*y
             + 2.0375678301347417965422639815295e7*z)))));
            grad[1]= 524.7856705360770423786737589791
             + z*(-2973.7854663711032401458179675482
             + 2798.8569095257442260195933812219*z)
             + y*(-4023.3568074432573249031654855065
             + y*(7696.8565011957966215538817983602
             - 4198.2853642886163390293900718328*y
             - 18892.284139298773525632255323248*z)
             + (18192.569911917337469127356977942
             - 12594.856092865849017088170215498*z)*z)
             + x*(-23615.35517412346690704031915406
             + (130846.56052032854256641599057212
             - 120350.84710960700171884251539254*z)*z
             + y*(177027.69952750332229573928136228
             + z*(-782280.50621244551117247635005152
             + 528983.9559003656587177031490509*z)
             + y*(-330964.82955141925472681691732949
             + 176327.98530012188623923438301698*y
             + 793475.9338505484880765547235764*z))
             + x*(233004.83771801820681613114898672
             + z*(-1.1895141865484412960583271870193e6
             + 999191.9167006906886889948370962*z)
             + y*(-1.6093427229773029299612661942026e6
             + y*(2.7477777709268993938947358020146e6
             - 1.3224598897509141467942578726273e6*y
             - 5.951069503879113660574160426823e6*z)
             + (6.4947474585544894764784664411254e6
             - 3.967379669252742440382773617882e6*z)*z)
             + x*(-856450.2143148777331619955746539
             + (3.6637036945691991918596477360194e6
             - 2.4489997958350261977671442085691e6*z)*z
             + x*(1.3996033833197174720239229151973e6
             + z*(-4.2673821442425331496092487834317e6
             + 1.5673598693344167665709722934843e6*z)
             + x*(-1.0469474127194736995454541491633e6
             + 293879.9755002031437320573050283*x
             + 2.2530798121682241019457726718836e6*y
             + 1.665319861167817814481658061827e6*z)
             + y*(-5.7735170186810742612360424717018e6
             + 4.3102396406696461080701738070817e6*y
             + 1.0187839150673708982711319907648e7*z))
             + y*(4.9567755867700930242806998781439e6
             + z*(-1.5918498672927670285486437355699e7
             + 7.053119412004875449569375320679e6*z)
             + y*(-6.7347494385463220438596465735651e6
             + 2.3510398040016251498564584402264e6*y
             + 1.0579679118007313174354062981019e7*z)))));
            grad[2]= 174.92855684535901412622458632637
             - 349.85711369071802825244917265273*z
             + y*(-2973.7854663711032401458179675482
             + y*(9096.2849559586687345636784889711
             - 6297.428046432924508544085107749*y
             - 12594.856092865849017088170215498*z)
             + 5597.713819051488452039186762444*z)
             + x*(-7871.7850580411556356801063846865
             + 15393.71300239159324310776359672*z
             + y*(130846.56052032854256641599057212
             - 240701.69421921400343768503078508*z
             + y*(-391140.25310622275558623817502576
             + 264491.97795018282935885157452547*y
             + 528983.9559003656587177031490509*z))
             + x*(77668.279239339402272043716328907
             - 139942.84547628721130097966906109*z
             + y*(-1.1895141865484412960583271870193e6
             + y*(3.2473737292772447382392332205627e6
             - 1.983689834626371220191386808941e6*y
             - 3.967379669252742440382773617882e6*z)
             + 1.9983838334013813773779896741924e6*z)
             + x*(-285483.40477162591105399852488463
             + 431023.96406696461080701738070817*z
             + x*(466534.46110657249067464097173242
             - 502044.9581461803705422645627567*z
             + x*(-348982.4709064912331818180497211
             + 97959.99183340104791068576834277*x
             + 1.665319861167817814481658061827e6*y
             + 195919.98366680209582137153668553*z)
             + y*(-4.2673821442425331496092487834317e6
             + 5.093919575336854491355659953824e6*y
             + 3.1347197386688335331419445869685e6*z))
             + y*(3.6637036945691991918596477360194e6
             - 4.8979995916700523955342884171383e6*z
             + y*(-7.9592493364638351427432186778497e6
             + 3.5265597060024377247846876603396e6*y
             + 7.053119412004875449569375320679e6*z)))));
            return;
          case ( 97 ):
            grad[0]= 1586.8333245807512975013398226475
             + z*(-18628.043375513167405450510961514
             + (45535.217140143298102212360128145
             - 29666.88389433578512719896190167*z)*z)
             + y*(-18628.043375513167405450510961514
             + z*(200354.95541663051164973438456384
             + z*(-445003.25841503677690798442852505
             + 260792.60725718434367630715346119*z))
             + y*(45535.217140143298102212360128145
             + y*(-41533.637452070099178078546662338
             + 13039.63036285921718381535767306*y
             + 156475.56435431060620578429207672*z)
             + z*(-338202.47639542795045006816567904
             + 391188.91088577651551446073019179*z)))
             + x*(-33737.456335651625412093703185853
             + z*(367593.38927679317013422341630721
             + z*(-827913.03891169632913113382051172
             + 492608.25815245931583302462320448*z))
             + y*(367593.38927679317013422341630721
             + y*(-827913.03891169632913113382051172
             + y*(689651.56141344304216623447248627
             - 195594.45544288825775723036509589*y
             - 2.3471334653146590930867643811507e6*z)
             + (5.615734142938036200496480704531e6
             - 5.867833663286647732716910952877e6*z)*z)
             + z*(-3.6428173712114638481769888102516e6
             + (7.3891238722868897374953693480671e6
             - 3.9118891088577651551446073019179e6*z)*z))
             + x*(214843.43359758519740952922642279
             + z*(-2.0267311192558326137130155926127e6
             + (3.8249582397720370405858382507642e6
             - 1.8110597726193357199743552323694e6*z)*z)
             + y*(-2.0267311192558326137130155926127e6
             + z*(1.6829816254996962978577688303362e7
             + z*(-2.7165896589290035799615328485541e7
             + 1.0431704290287373747052286138448e7*z))
             + y*(3.8249582397720370405858382507642e6
             + y*(-2.5354836816670700079640973253172e6
             + 521585.2145143686873526143069224*y
             + 6.259022574172424248231371683069e6*z)
             + z*(-2.0646081407860427207707649649011e7
             + 1.5647556435431060620578429207672e7*z)))
             + x*(-593199.69238023041982245738239665
             + z*(4.4160881495549882195854677986095e6
             + z*(-5.9402760541914211615158851621716e6
             + 1.5454376726351664810447831316219e6*z))
             + x*(804110.53904298505966861372317201
             + x*(-528829.45360484603023251172785186
             + 135225.79635557706709141852401691*x
             + 1.3908939053716498329403048184597e6*y
             + 1.3908939053716498329403048184597e6*z)
             + z*(-4.1292162815720854415415299298022e6
             + 2.897695636190937151958968371791e6*z)
             + y*(-4.1292162815720854415415299298022e6
             + 2.897695636190937151958968371791e6*y
             + 1.2749860799240123468619460835881e7*z))
             + y*(4.4160881495549882195854677986095e6
             + y*(-5.9402760541914211615158851621716e6
             + 2.1636127416892330734626963842706e6*y
             + 1.7617989468040897883910527700489e7*z)
             + z*(-2.6137214638442253110669894713555e7
             + 2.3181565089527497215671746974328e7*z)))));
            grad[1]= 413.95651945584816456556691025586
             + y*(-2069.7825972792408228278345512793
             + y*(2897.695636190937151958968371791
             - 1241.8695583675444936967007307676*y
             - 11176.826025307900443270306576908*z)
             + (15730.347739322230253491542589723
             - 18628.043375513167405450510961514*z)*z)
             + z*(-4553.5217140143298102212360128145
             + (10348.912986396204114139172756397
             - 6209.347791837722468483503653838*z)*z)
             + x*(-18628.043375513167405450510961514
             + z*(200354.95541663051164973438456384
             + z*(-445003.25841503677690798442852505
             + 260792.60725718434367630715346119*z))
             + y*(91070.43428028659620442472025629
             + y*(-124600.91235621029753423563998701
             + 52158.52145143686873526143069224*y
             + 469426.69306293181861735287623015*z)
             + z*(-676404.95279085590090013633135808
             + 782377.8217715530310289214603836*z))
             + x*(183796.6946383965850671117081536
             + y*(-827913.03891169632913113382051172
             + y*(1.0344773421201645632493517087294e6
             - 391188.91088577651551446073019179*y
             - 3.5207001979719886396301465717261e6*z)
             + (5.615734142938036200496480704531e6
             - 5.867833663286647732716910952877e6*z)*z)
             + z*(-1.8214086856057319240884944051258e6
             + (3.6945619361434448687476846740336e6
             - 1.9559445544288825775723036509589e6*z)*z)
             + x*(-675577.03975194420457100519753757
             + z*(5.6099387516656543261925627677874e6
             + z*(-9.055298863096678599871776161847e6
             + 3.4772347634291245823507620461492e6*z))
             + x*(1.1040220373887470548963669496524e6
             + x*(-825843.25631441708830830598596044
             + 231815.65089527497215671746974328*x
             + 1.1590782544763748607835873487164e6*y
             + 2.5499721598480246937238921671761e6*z)
             + z*(-6.5343036596105632776674736783888e6
             + 5.795391272381874303917936743582e6*z)
             + y*(-2.9701380270957105807579425810858e6
             + 1.622709556266924805097022288203e6*y
             + 8.808994734020448941955263850245e6*z))
             + y*(2.5499721598480246937238921671761e6
             + y*(-2.5354836816670700079640973253172e6
             + 695446.9526858249164701524092298*y
             + 6.259022574172424248231371683069e6*z)
             + z*(-1.3764054271906951471805099766007e7
             + 1.0431704290287373747052286138448e7*z)))));
            grad[2]= 413.95651945584816456556691025586
             + z*(-2069.7825972792408228278345512793
             + 2069.7825972792408228278345512793*z)
             + y*(-4553.5217140143298102212360128145
             + y*(7865.1738696611151267457712948614
             - 3725.6086751026334810901021923028*y
             - 18628.043375513167405450510961514*z)
             + (20697.825972792408228278345512793
             - 18628.043375513167405450510961514*z)*z)
             + x*(-18628.043375513167405450510961514
             + (91070.43428028659620442472025629
             - 89000.65168300735538159688570501*z)*z
             + y*(200354.95541663051164973438456384
             + z*(-890006.5168300735538159688570501
             + 782377.8217715530310289214603836*z)
             + y*(-338202.47639542795045006816567904
             + 156475.56435431060620578429207672*y
             + 782377.8217715530310289214603836*z))
             + x*(183796.6946383965850671117081536
             + z*(-827913.03891169632913113382051172
             + 738912.3872286889737495369348067*z)
             + y*(-1.8214086856057319240884944051258e6
             + y*(2.8078670714690181002482403522655e6
             - 1.1735667326573295465433821905754e6*y
             - 5.867833663286647732716910952877e6*z)
             + (7.3891238722868897374953693480671e6
             - 5.867833663286647732716910952877e6*z)*z)
             + x*(-675577.03975194420457100519753757
             + (2.5499721598480246937238921671761e6
             - 1.8110597726193357199743552323694e6*z)*z
             + y*(5.6099387516656543261925627677874e6
             + z*(-1.8110597726193357199743552323694e7
             + 1.0431704290287373747052286138448e7*z)
             + y*(-6.8820271359534757359025498830037e6
             + 2.0863408580574747494104572276895e6*y
             + 1.0431704290287373747052286138448e7*z))
             + x*(1.1040220373887470548963669496524e6
             + z*(-2.9701380270957105807579425810858e6
             + 1.1590782544763748607835873487164e6*z)
             + x*(-825843.25631441708830830598596044
             + 231815.65089527497215671746974328*x
             + 2.5499721598480246937238921671761e6*y
             + 1.1590782544763748607835873487164e6*z)
             + y*(-6.5343036596105632776674736783888e6
             + 4.4044973670102244709776319251224e6*y
             + 1.1590782544763748607835873487164e7*z)))));
            return;
          case ( 98 ):
            grad[0]= 1799.2998638359310452249001498505
             + z*(-35203.692988094303058748046410118
             + z*(154896.24914761493345849140420452
             + z*(-235473.59087591967157073693265434
             + 114998.73042777472332524361827305*z)))
             + y*(-7040.7385976188606117496092820235
             + y*(10326.416609840995563899426946968
             + y*(-6727.8168821691334734496266472669
             + 1642.8390061110674760749088324722*y
             + 32856.780122221349521498176649443*z)
             + z*(-100917.253232537002101744399709
             + 147855.51054999607284674179492249*z))
             + z*(103264.16609840995563899426946968
             + z*(-302751.75969761100630523319912701
             + 229997.4608555494466504872365461*z)))
             + x*(-38254.679713729142657172877098994
             + y*(138937.24165967884940519228983193
             + z*(-1.8775302926983628297998958085396e6
             + (5.0270873586998664767892210273648e6
             - 3.4499619128332416997573085481915e6*z)*z)
             + y*(-187753.02926983628297998958085396
             + y*(111713.05241555258837309380060811
             - 24642.585091666012141123632487082*y
             - 492851.70183332024282247264974165*z)
             + (1.6756957862332888255964070091216e6
             - 2.2178326582499410927011269238374e6*z)*z))
             + z*(694686.20829839424702596144915965
             + z*(-2.8162954390475442446998437128094e6
             + (3.9099568345443405930582830212837e6
             - 1.7249809564166208498786542740958e6*z)*z))
             + x*(243609.55547761257716653648115801
             + z*(-3.8301617971046601727917874494208e6
             + z*(1.3011284928399654410513277953179e7
             + z*(-1.4374841303471840415655452284131e7
             + 4.599949217110988933009744730922e6*z)))
             + y*(-766032.35942093203455835748988416
             + y*(867418.9952266436273675518635453
             + y*(-410709.75152776686901872720811804
             + 65713.56024444269904299635329889*y
             + 1.3142712048888539808599270659777e6*z)
             + z*(-6.1606462729165030352809081217706e6
             + 5.9142204219998429138696717969e6*z))
             + z*(8.674189952266436273675518635453e6
             + z*(-1.8481938818749509105842724365312e7
             + 9.199898434221977866019489461844e6*z)))
             + x*(-672625.22735918848377581267340931
             + x*(911775.64839164244922157440202205
             + x*(-599636.23723053962876734172385234
             + 153331.64057036629776699149103073*x
             + 525708.4819555415923439708263911*y
             + 2.6285424097777079617198541319554e6*z)
             + y*(-1.5606970558055141022711633908485e6
             + 657135.6024444269904299635329889*y
             + 6.571356024444269904299635329889e6*z)
             + z*(-7.8034852790275705113558169542427e6
             + 9.857034036666404856449452994833e6*z))
             + z*(8.3456221510442227784605368689585e6
             + z*(-2.0206919775166129955721378639408e7
             + 1.2266531245629303821359319282459e7*z))
             + y*(1.6691244302088445556921073737917e6
             + y*(-1.3471279850110753303814252426272e6
             + 350472.32130369439489598055092739*y
             + 5.257084819555415923439708263911e6*z)
             + z*(-1.3471279850110753303814252426272e7
             + 1.5771254458666247770319124791733e7*z)))));
            grad[1]= 156.4608577248635691499913173783
             + y*(-469.3825731745907074499739521349
             + y*(469.3825731745907074499739521349
             - 156.4608577248635691499913173783*y
             - 2346.9128658729535372498697606745*z)
             + (4693.825731745907074499739521349
             - 7040.738597618860611749609282024*z)*z)
             + z*(-2346.9128658729535372498697606745
             + (7040.7385976188606117496092820235
             - 5476.130020370224920249696108241*z)*z)
             + x*(-7040.7385976188606117496092820235
             + z*(103264.16609840995563899426946968
             + z*(-302751.75969761100630523319912701
             + 229997.4608555494466504872365461*z))
             + y*(20652.833219681991127798853893936
             + y*(-20183.450646507400420348879941801
             + 6571.356024444269904299635329889*y
             + 98570.34036666404856449452994833*z)
             + z*(-201834.50646507400420348879941801
             + 295711.02109999214569348358984499*z))
             + x*(69468.620829839424702596144915965
             + y*(-187753.02926983628297998958085396
             + y*(167569.57862332888255964070091216
             - 49285.170183332024282247264974165*y
             - 739277.5527499803642337089746125*z)
             + (1.6756957862332888255964070091216e6
             - 2.2178326582499410927011269238374e6*z)*z)
             + z*(-938765.1463491814148999479042698
             + (2.5135436793499332383946105136824e6
             - 1.7249809564166208498786542740958e6*z)*z)
             + x*(-255344.11980697734485278582996139
             + z*(2.891396650755478757891839545151e6
             + z*(-6.1606462729165030352809081217706e6
             + 3.0666328114073259553398298206147e6*z))
             + y*(578279.3301510957515783679090302
             + y*(-410709.75152776686901872720811804
             + 87618.08032592359872399513773185*y
             + 1.3142712048888539808599270659777e6*z)
             + z*(-4.1070975152776686901872720811804e6
             + 3.9428136146665619425797811979332e6*z))
             + x*(417281.10755221113892302684344793
             + x*(-312139.41116110282045423267816971
             + 87618.08032592359872399513773185*x
             + 262854.24097777079617198541319554*y
             + 1.3142712048888539808599270659777e6*z)
             + y*(-673563.99250553766519071262131358
             + 262854.24097777079617198541319554*y
             + 2.6285424097777079617198541319554e6*z)
             + z*(-3.3678199625276883259535631065679e6
             + 3.9428136146665619425797811979332e6*z)))));
            grad[2]= 782.3042886243178457499565868915
             + y*(-2346.9128658729535372498697606745
             + y*(2346.9128658729535372498697606745
             - 782.3042886243178457499565868915*y
             - 7040.738597618860611749609282024*z)
             + (14081.477195237721223499218564047
             - 16428.390061110674760749088324722*z)*z)
             + z*(-7040.7385976188606117496092820235
             + (16428.390061110674760749088324722
             - 10952.260040740449840499392216481*z)*z)
             + x*(-35203.692988094303058748046410118
             + z*(309792.49829522986691698280840903
             + z*(-706420.77262775901471221079796303
             + 459994.9217110988933009744730922*z))
             + y*(103264.16609840995563899426946968
             + y*(-100917.253232537002101744399709
             + 32856.780122221349521498176649443*y
             + 295711.02109999214569348358984499*z)
             + z*(-605503.51939522201261046639825402
             + 689992.3825666483399514617096383*z))
             + x*(347343.10414919712351298072457983
             + y*(-938765.1463491814148999479042698
             + y*(837847.8931166444127982035045608
             - 246425.85091666012141123632487082*y
             - 2.2178326582499410927011269238374e6*z)
             + (5.0270873586998664767892210273648e6
             - 5.174942869249862549635962822287e6*z)*z)
             + z*(-2.8162954390475442446998437128094e6
             + (5.8649352518165108895874245319256e6
             - 3.4499619128332416997573085481915e6*z)*z)
             + x*(-1.2767205990348867242639291498069e6
             + z*(8.674189952266436273675518635453e6
             + z*(-1.4374841303471840415655452284131e7
             + 6.133265622814651910679659641229e6*z))
             + y*(2.891396650755478757891839545151e6
             + y*(-2.0535487576388343450936360405902e6
             + 438090.40162961799361997568865924*y
             + 3.9428136146665619425797811979332e6*z)
             + z*(-1.2321292545833006070561816243541e7
             + 9.199898434221977866019489461844e6*z))
             + x*(2.0864055377610556946151342172396e6
             + x*(-1.5606970558055141022711633908485e6
             + 438090.40162961799361997568865924*x
             + 1.3142712048888539808599270659777e6*y
             + 3.9428136146665619425797811979332e6*z)
             + y*(-3.3678199625276883259535631065679e6
             + 1.3142712048888539808599270659777e6*y
             + 7.885627229333123885159562395866e6*z)
             + z*(-1.0103459887583064977860689319704e7
             + 9.199898434221977866019489461844e6*z)))));
            return;
          case ( 99 ):
            grad[0]= 499.89998999799949985995798679571
             + y*(-16996.599659931982995238571551054
             + y*(131973.59735947186796302890851407
             + y*(-383923.1923184636158924477338591
             + (464906.99069813953486976092772001
             - 197960.3960392078019445433627711*y)*y)))
             + x*(-7998.3998399679919977593277887313
             + y*(245950.79507901575393109932950349
             + y*(-1.7036591659131822955227368189998e6
             + y*(4.3431311131026196547833149892811e6
             + y*(-4.4990999099819954987396218811614e6
             + 1.5836831683136624155563469021688e6*y))))
             + x*(38992.199219843960989076722970065
             + y*(-995800.78007601500372103630969705
             + y*(5.4109174917383465864841852490767e6
             + y*(-9.7180558055611102772775832633086e6
             + 5.398919891978394598487546257394e6*y)))
             + x*(-85982.798279655913975912773728862
             + x*(96480.698069613903472971891451572
             + x*(-53989.198919783945984875462573937
             + 11997.599759951987996638991683097*x
             + 359927.99279855963989916975049291*y)
             + y*(-1.2747449744948987246428928663291e6
             + 2.3995199519903975993277983366194e6*y))
             + y*(1.6816635663532703175288986675808e6
             + y*(-6.2387518751750337582522756752104e6
             + 5.758847884776954238386716007887e6*y)))));
            grad[1]= 499.89998999799949985995798679571
             + y*(-7998.3998399679919977593277887313
             + y*(35992.799279855963989916975049291
             + y*(-59987.998799759939983194958415485
             + 32993.399339867966990757227128517*y)))
             + x*(-16996.599659931982995238571551054
             + y*(263947.19471894373592605781702813
             + y*(-1.1517695769553908476773432015773e6
             + (1.85962796279255813947904371088e6
             - 989801.9801960390097227168138555*y)*y))
             + x*(122975.39753950787696554966475174
             + y*(-1.7036591659131822955227368189998e6
             + y*(6.5146966696539294821749724839217e6
             + y*(-8.9981998199639909974792437623228e6
             + 3.959207920784156038890867255422e6*y)))
             + x*(-331933.59335867166790701210323235
             + x*(420415.89158831757938222466689519
             + x*(-254948.99489897974492857857326581
             + 59987.99879975993998319495841549*x
             + 959807.9807961590397311193346478*y)
             + y*(-3.1193759375875168791261378376052e6
             + 4.3191359135827156787900370059149e6*y))
             + y*(3.6072783278255643909894568327178e6
             + y*(-9.7180558055611102772775832633086e6
             + 7.198559855971192797983395009858e6*y)))));
            grad[2]= 0;
            return;
          case ( 100 ):
            grad[0]= 865.85218137970871546249606975456
             - 1682.2270952520055043271352212374*z
             + y*(-27756.747071658090821397731150417
             + 52247.9944878269944873369056949*z
             + y*(202460.97864032960363843050956775
             - 341986.87301123123664438701909391*z
             + y*(-550978.85096253921459373464187353
             + y*(621187.09355555673843609360890105
             - 244912.47416168903665939174544486*y
             - 489824.94832337807331878349088972*z)
             + 736221.7405102894677761109438827*z)))
             + x*(-13853.634902075339447399937116073
             + 24342.815613646667886145603789671*z
             + y*(401656.45762517002012140246252957
             - 674474.1106610393833819855098797*z
             + y*(-2.6135871788115276106051938507837e6
             + 3.8687265009395533645396281534999e6*z
             + y*(6.2329482515137248650916231361943e6
             - 7.124726521067317430091396231123e6*z
             + y*(-6.0114880021505490816396155700102e6
             + 1.9592997932935122932751339635589e6*y
             + 3.9185995865870245865502679271178e6*z))))
             + x*(67536.470147617279806074693440855
             - 98558.7168747645577829309811972*z
             + x*(-148926.57519730989905954932399778
             + 166441.52789493372107519067306596*z
             + x*(167109.47100628378208426174146263
             - 126167.03214390041282453514159281*z
             + x*(-93512.035589008541269949575533492
             + 20780.452353113009171099905674109*x
             + 587789.9379880536879825401890677*y
             + 35623.632605336587150456981155616*z)
             + y*(-2.0817560303743568116048298362813e6
             + 3.6811087025514473388805547194137e6*y
             + 949963.5361423089906788528308164*z))
             + y*(2.7462852102664063977406461055884e6
             - 2.4699051939700033757650173601227e6*z
             + y*(-9.5708826266337630810894422704755e6
             + 8.264682764438088218906019628103e6*y
             + 5.129803095168468549665805286409e6*z)))
             + y*(-1.6262188284336152034183611897539e6
             + 2.142167774000906773980813133491e6*z
             + y*(8.3009001242535137491756508922778e6
             - 8.656542723096790677561046420815e6*z
             + y*(-1.3946652164989273869403908122424e7
             + 7.213785602580658897967538684012e6*y
             + 8.549671825280780916109675477348e6*z)))));
            grad[1]= 816.37491387229678886463915148287
             - 1583.272560237181651131421384694*z
             + y*(-12270.362341838157796268515731379
             + 21374.17956320195229027418869337*z
             + y*(51654.267277738051368162622675643
             - 71247.26521067317430091396231123*z
             + y*(-80153.173362007321088528207600136
             + 40818.745693614839443231957574143*y
             + 65309.99310978374310917113211863*z)))
             + x*(-27756.747071658090821397731150417
             + 52247.9944878269944873369056949*z
             + y*(404921.9572806592072768610191355
             - 683973.7460224624732887740381878*z
             + y*(-1.6529365528876176437812039256206e6
             + y*(2.4847483742222269537443744356042e6
             - 1.2245623708084451832969587272243e6*y
             - 1.9592997932935122932751339635589e6*z)
             + 2.2086652215308684033283328316482e6*z))
             + x*(200828.22881258501006070123126479
             - 337237.05533051969169099275493983*z
             + y*(-2.6135871788115276106051938507837e6
             + 3.8687265009395533645396281534999e6*z
             + y*(9.3494223772705872976374347042914e6
             - 1.0687089781600976145137094346685e7*z
             + y*(-1.202297600430109816327923114002e7
             + 4.8982494832337807331878349088972e6*y
             + 7.837199173174049173100535854236e6*z)))
             + x*(-542072.94281120506780612039658462
             + 714055.924666968924660271044497*z
             + x*(686571.30256660159943516152639709
             - 617476.2984925008439412543400307*z
             + x*(-416351.20607487136232096596725626
             + 97964.98966467561466375669817794*x
             + 1.4724434810205789355522218877655e6*y
             + 189992.70722846179813577056616329*z)
             + y*(-4.7854413133168815405447211352378e6
             + 6.198512073328566164179514721077e6*y
             + 2.5649015475842342748329026432044e6*z))
             + y*(5.5339334161690091661171005948519e6
             - 5.77102848206452711837403094721e6*z
             + y*(-1.3946652164989273869403908122424e7
             + 9.618380803440878530623384912016e6*y
             + 8.549671825280780916109675477348e6*z)))));
            grad[2]= 49.477267507411926597856918271689
             + y*(-1583.272560237181651131421384694
             + y*(10687.089781600976145137094346685
             + y*(-23749.088403557724766971320770411
             + 16327.498277445935777292783029657*y)))
             + x*(-1682.2270952520055043271352212374
             + y*(52247.994487826994487336905694904
             + y*(-341986.87301123123664438701909391
             + (736221.74051028946777611094388273
             - 489824.94832337807331878349088972*y)*y))
             + x*(12171.407806823333943072801894835
             + y*(-337237.05533051969169099275493983
             + y*(1.93436325046977668226981407675e6
             + y*(-3.5623632605336587150456981155616e6
             + 1.9592997932935122932751339635589e6*y)))
             + x*(-32852.905624921519260976993732401
             + x*(41610.38197373343026879766826649
             + x*(-25233.406428780082564907028318561
             + 5937.272100889431191742830192603*x
             + 189992.70722846179813577056616329*y)
             + y*(-617476.29849250084394125434003068
             + 1.2824507737921171374164513216022e6*y))
             + y*(714055.92466696892466027104449701
             + y*(-2.8855142410322635591870154736049e6
             + 2.8498906084269269720365584924493e6*y)))));
            return;
          case ( 101 ):
            grad[0]= 1117.8103595869918399349171623886
             + z*(-6515.2375244498952956206600322081
             + 6323.612891377839551631817090084*z)
             + y*(-31490.314701507827262166523489006
             + (177061.16095857950744569087852236
             - 165563.68297425616280636030199494*z)*z
             + y*(200247.74156029825246834087451934
             + z*(-993382.09784553697683816181196961
             + 801949.089406553288593307712788*z)
             + y*(-472163.09588954535318850900939296
             + y*(460378.18095561392493319516845235
             - 158090.32228444598879079542725211*y
             - 948541.9337066759327447725635126*z)
             + (1.782109087570118419096239361751e6
             - 948541.9337066759327447725635126*z)*z)))
             + x*(-17884.965753391869438958674598218
             + (94279.319471451426042510727524894
             - 81632.09368869574693924709334472*z)*z
             + y*(455683.37744534855920546851637032
             + z*(-2.2856986232834809142989186136523e6
             + 1.8729391636462728417469509163177e6*z)
             + y*(-2.5850163001420319864094912892496e6
             + (1.1237634981877637050481705497906e7
             - 7.760797639418257631548139156013e6*z)*z
             + y*(5.3413450222504818079450081687579e6
             + z*(-1.7246216976485016958995864791139e7
             + 7.588335469653407461958180508101e6*z)
             + y*(-4.4552727189252960477405984043776e6
             + 1.2647225782755679103263634180169e6*y
             + 7.588335469653407461958180508101e6*z))))
             + x*(87189.208047785363514923538666314
             + z*(-381716.26907953504202577514071054
             + 259268.12854649142161690450069346*z)
             + x*(-192263.38184896259646880575193085
             + (644625.26565439552277846765730435
             - 298934.42759240696062259498971308*z)*z
             + x*(215737.39940028942510743901234101
             + z*(-488642.81433374214717154950241561
             + 114974.77984323344639330576527426*z)
             + x*(-120723.51883539511871297105353797
             + 26827.448630087804158438011897327*x
             + 666853.7230907539890811734385907*y
             + 137969.73581188013567196691832911*z)
             + y*(-2.3617736026130870446624892616754e6
             + 3.6408680283690591357880159003516e6*y
             + 3.2192938356105364990125614276793e6*z))
             + y*(3.115688783996245026762593676971e6
             + z*(-8.3701639725873948974326597119662e6
             + 2.483455244613842442095404529924e6*z)
             + y*(-9.4662568737595537530488413409141e6
             + 7.082446438343180297827635140894e6*y
             + 1.4900731467683054652572427179544e7*z)))
             + y*(-1.8449619672177527031245798467676e6
             + (7.2595075993017598052733260194168e6
             - 4.1908307252858591210359951442468e6*z)*z
             + y*(8.2101574039722283512019758552928e6
             + z*(-2.5144984351715154726215970865481e7
             + 9.312957167301909157857766987215e6*z)
             + y*(-1.1951628364704116752584134300259e7
             + 5.346327262710355257288718085253e6*y
             + 2.0695460371782020350795037749367e7*z)))));
            grad[1]= 926.18572651493609594607422026488
             + z*(-5365.4897260175608316876023794655
             + 5173.865092945505087698759437342*z)
             + y*(-12136.226761230197119293386334505
             + (62086.381115346061052385113248101
             - 51738.65092945505087698759437342*z)*z
             + y*(44265.29023964487686142271963059
             + z*(-172462.16976485016958995864791139
             + 94854.19337066759327447725635126*z)
             + y*(-59403.636252337280636541312058368
             + 26348.387047407664798465904542018*y
             + 126472.25782755679103263634180169*z)))
             + x*(-31490.314701507827262166523489006
             + (177061.16095857950744569087852236
             - 165563.68297425616280636030199494*z)*z
             + y*(400495.48312059650493668174903867
             + z*(-1.9867641956910739536763236239392e6
             + 1.6038981788131065771866154255759e6*z)
             + y*(-1.4164892876686360595655270281789e6
             + y*(1.8415127238224556997327806738094e6
             - 790451.6114222299439539771362605*y
             - 3.7941677348267037309790902540506e6*z)
             + (5.3463272627103552572887180852531e6
             - 2.8456258011200277982343176905379e6*z)*z))
             + x*(227841.68872267427960273425818516
             + z*(-1.1428493116417404571494593068261e6
             + 936469.5818231364208734754581589*z)
             + y*(-2.5850163001420319864094912892496e6
             + (1.1237634981877637050481705497906e7
             - 7.760797639418257631548139156013e6*z)*z
             + y*(8.0120175333757227119175122531368e6
             + z*(-2.5869325464727525438493797186709e7
             + 1.1382503204480111192937270762152e7*z)
             + y*(-8.9105454378505920954811968087552e6
             + 3.1618064456889197758159085450422e6*y
             + 1.5176670939306814923916361016202e7*z)))
             + x*(-614987.32240591756770819328225588
             + (2.4198358664339199350911086731389e6
             - 1.3969435750952863736786650480823e6*z)*z
             + x*(778922.19599906125669064841924276
             + z*(-2.0925409931468487243581649279915e6
             + 620863.811153460610523851132481*z)
             + x*(-472354.72052261740893249785233509
             + 111142.28718179233151352890643179*x
             + 1.4563472113476236543152063601406e6*y
             + 643858.7671221072998025122855359*z)
             + y*(-4.7331284368797768765244206704571e6
             + 5.311834828757385223370726355671e6*y
             + 7.450365733841527326286213589772e6*z))
             + y*(5.4734382693148189008013172368619e6
             + z*(-1.6763322901143436484143980576987e7
             + 6.20863811153460610523851132481e6*z)
             + y*(-1.1951628364704116752584134300259e7
             + 7.128436350280473676384957447004e6*y
             + 2.0695460371782020350795037749367e7*z)))));
            grad[2]= 191.62463307205574398884294212377
             - 383.24926614411148797768588424753*z
             + y*(-5365.4897260175608316876023794655
             + 10347.730185891010175397518874683*z
             + y*(31043.19055767303052619255662405
             - 51738.65092945505087698759437342*z
             + y*(-57487.38992161672319665288263713
             + 31618.064456889197758159085450422*y
             + 63236.12891377839551631817090084*z)))
             + x*(-6515.2375244498952956206600322081
             + 12647.225782755679103263634180169*z
             + y*(177061.16095857950744569087852236
             - 331127.36594851232561272060398987*z
             + y*(-993382.09784553697683816181196961
             + y*(1.782109087570118419096239361751e6
             - 948541.9337066759327447725635126*y
             - 1.8970838674133518654895451270253e6*z)
             + 1.6038981788131065771866154255759e6*z))
             + x*(47139.659735725713021255363762447
             - 81632.09368869574693924709334472*z
             + x*(-127238.75635984501400859171357018
             + 172845.41903099428107793633379564*z
             + x*(161156.31641359888069461691432609
             - 149467.21379620348031129749485654*z
             + x*(-97728.562866748429434309900483121
             + 22994.955968646689278661153054852*x
             + 643858.7671221072998025122855359*y
             + 45989.911937293378557322306109704*z)
             + y*(-2.0925409931468487243581649279915e6
             + 3.725182866920763663143106794886e6*y
             + 1.241727622306921221047702264962e6*z))
             + y*(2.4198358664339199350911086731389e6
             - 2.7938871501905727473573300961645e6*z
             + y*(-8.3816614505717182420719902884936e6
             + 6.898486790594006783598345916456e6*y
             + 6.20863811153460610523851132481e6*z)))
             + y*(-1.1428493116417404571494593068261e6
             + 1.8729391636462728417469509163177e6*z
             + y*(5.6188174909388185252408527489531e6
             - 7.760797639418257631548139156013e6*z
             + y*(-8.6231084882425084794979323955695e6
             + 3.7941677348267037309790902540506e6*y
             + 7.588335469653407461958180508101e6*z)))));
            return;
          case ( 102 ):
            grad[0]= 1322.6110539383828996775507567124
             + z*(-15417.866000196006373384020249676
             + (37410.998382828544876593578547009
             - 24184.887843444715879818070979884*z)*z)
             + y*(-29550.909833709012215652705478546
             + z*(329216.78576889119491402349121368
             + z*(-761823.96706850855021426923586636
             + 468582.20196674137017147512523526*z))
             + y*(147149.92697245894318126807561823
             + y*(-273289.23263092528944194420207269
             + y*(216719.26840961788370430724542131
             - 62351.66397138090812765596424501*y
             - 748219.9676565708975318715709402*z)
             + (1.8274705876702913436687529884175e6
             - 1.8705499191414272438296789273504e6*z)*z)
             + z*(-1.3930495397824156346775208884413e6
             + (2.6357748860629202072145475794483e6
             - 1.2470332794276181625531192849003e6*z)*z)))
             + x*(-21161.776863014126394840812107399
             + z*(223105.59035577750399132170478943
             + z*(-482941.97912378667022511710487957
             + 273591.54372896834839044192795994*z))
             + y*(427619.04818190688265003326751308
             + z*(-4.2498894162893226979810305229402e6
             + (8.6181336274625029742989207307382e6
             - 4.5346664706458842274658883087283e6*z)*z)
             + y*(-1.8995717845535609028854606125263e6
             + z*(1.5758872918788576867289455050493e7
             + z*(-2.5507498897383098779495621736597e7
             + 9.976266235420945300424954279202e6*z))
             + y*(3.0915844441373423368119937859474e6
             + y*(-2.0972832426737214552029733427869e6
             + 498813.31177104726502124771396012*y
             + 5.985759741252567180254972567521e6*z)
             + z*(-1.7685199235518948487116964404041e7
             + 1.4964399353131417950637431418804e7*z))))
             + x*(103163.66220719386617484895902357
             + z*(-903305.56095266013811120495109868
             + (1.5338509336959703399403367204274e6
             - 612179.9735371943707078949216783*z)*z)
             + x*(-227489.10127740185874453873015454
             + z*(1.5254618007252754541195248270562e6
             + z*(-1.7685199235518948487116964404041e6
             + 362773.31765167073819727106469827*z))
             + x*(255263.9334101078996377672960455
             + x*(-142841.99382534535316517548172494
             + 31742.665294521189592261218161098*x
             + 625783.9729491320233902925866045*y
             + 326495.98588650366437754395822844*z)
             + z*(-1.1563399500147004780038015187257e6
             + 680199.9705968826341198832463093*z)
             + y*(-2.216318237528175916173952910891e6
             + 2.6754532176810716942048741021497e6*y
             + 5.985759741252567180254972567521e6*z))
             + y*(2.9238017847234446203957559185244e6
             + z*(-1.5562975327256674668662928675556e7
             + 1.1427359506027628253214038537995e7*z)
             + y*(-6.9561783659707864049326726655893e6
             + 4.0993384894638793416291630310904e6*y
             + 2.089574309673623452016281332662e7*z)))
             + y*(-1.7313356584925985980464761562725e6
             + z*(1.3497888216524538991474963139761e7
             + z*(-1.9283669166421622677298690032867e7
             + 5.441599764775061072959065970474e6*z))
             + y*(6.0331470058708166704319911003476e6
             + y*(-6.9176337009702963889992126149651e6
             + 2.5167398912084657462435680113442e6*y
             + 2.1222239082622738184540357284849e7*z)
             + z*(-3.5261566475742395752774747488672e7
             + 3.0608998676859718535394746083916e7*z)))));
            grad[1]= 869.1444068737944769309619258396
             + z*(-9976.2662354209453004249542792023
             + (23806.998970890892194195913620824
             - 15115.554902152947424886294362428*z)*z)
             + y*(-8918.1773922702389806829136738324
             + z*(87065.596236400977167345055527584
             + z*(-170049.99264922065852997081157731
             + 83135.55196184121083687461899335*z))
             + y*(25620.865559149245885182268944315
             + y*(-27963.776568982952736039644570491
             + 10391.943995230151354609327374169*y
             + 99762.66235420945300424954279202*z)
             + z*(-176851.99235518948487116964404041
             + 187054.99191414272438296789273504*z)))
             + x*(-29550.909833709012215652705478546
             + z*(329216.78576889119491402349121368
             + z*(-761823.96706850855021426923586636
             + 468582.20196674137017147512523526*z))
             + y*(294299.85394491788636253615123647
             + y*(-819867.69789277586832583260621808
             + y*(866877.07363847153481722898168523
             - 311758.31985690454063827982122507*y
             - 2.9928798706262835901274862837607e6*z)
             + (5.4824117630108740310062589652526e6
             - 5.611649757424281731489036782051e6*z)*z)
             + z*(-2.7860990795648312693550417768827e6
             + (5.2715497721258404144290951588967e6
             - 2.4940665588552363251062385698006e6*z)*z))
             + x*(213809.52409095344132501663375654
             + z*(-2.1249447081446613489905152614701e6
             + (4.3090668137312514871494603653691e6
             - 2.2673332353229421137329441543642e6*z)*z)
             + x*(-577111.88616419953268215871875749
             + z*(4.4992960721748463304916543799203e6
             + z*(-6.4278897221405408924328966776224e6
             + 1.8138665882583536909863553234913e6*z))
             + x*(730950.4461808611550989389796311
             + x*(-443263.64750563518323479058217819
             + 104297.32882485533723171543110075*x
             + 1.0701812870724286776819496408599e6*y
             + 1.1971519482505134360509945135043e6*z)
             + z*(-3.8907438318141686671657321688889e6
             + 2.8568398765069070633035096344989e6*z)
             + y*(-3.4780891829853932024663363327946e6
             + 3.0745038670979095062218722733178e6*y
             + 1.044787154836811726008140666331e7*z))
             + y*(4.0220980039138777802879940668984e6
             + z*(-2.3507710983828263835183164992448e7
             + 2.0405999117906479023596497389278e7*z)
             + y*(-6.9176337009702963889992126149651e6
             + 3.355653188277954328324757348459e6*y
             + 2.1222239082622738184540357284849e7*z)))
             + y*(-1.8995717845535609028854606125263e6
             + z*(1.5758872918788576867289455050493e7
             + z*(-2.5507498897383098779495621736597e7
             + 9.976266235420945300424954279202e6*z))
             + y*(4.637376666206013505217990678921e6
             + y*(-4.1945664853474429104059466855737e6
             + 1.2470332794276181625531192849003e6*y
             + 1.1971519482505134360509945135043e7*z)
             + z*(-2.6527798853278422730675446606061e7
             + 2.2446599029697126925956147128205e7*z)))));
            grad[2]= 453.46664706458842274658883087283
             + z*(-2267.3332353229421137329441543642
             + 2267.3332353229421137329441543642*z)
             + y*(-9976.2662354209453004249542792023
             + (47613.997941781784388391827241648
             - 45346.664706458842274658883087283*z)*z
             + y*(43532.798118200488583672527763792
             + z*(-170049.99264922065852997081157731
             + 124703.32794276181625531192849003*z)
             + y*(-58950.664118396494957056548013468
             + 24940.665588552363251062385698006*y
             + 124703.32794276181625531192849003*z)))
             + x*(-15417.866000196006373384020249676
             + (74821.996765657089753187157094018
             - 72554.66353033414763945421293965*z)*z
             + y*(329216.78576889119491402349121368
             + z*(-1.5236479341370171004285384717327e6
             + 1.4057466059002241105144253757058e6*z)
             + y*(-1.3930495397824156346775208884413e6
             + y*(1.8274705876702913436687529884175e6
             - 748219.9676565708975318715709402*y
             - 3.7410998382828544876593578547009e6*z)
             + (5.2715497721258404144290951588967e6
             - 3.7410998382828544876593578547009e6*z)*z))
             + x*(111552.79517788875199566085239472
             + z*(-482941.97912378667022511710487957
             + 410387.31559345252258566289193991*z)
             + y*(-2.1249447081446613489905152614701e6
             + (8.6181336274625029742989207307382e6
             - 6.801999705968826341198832463093e6*z)*z
             + y*(7.8794364593942884336447275252464e6
             + z*(-2.5507498897383098779495621736597e7
             + 1.4964399353131417950637431418804e7*z)
             + y*(-8.8425996177594742435584822020203e6
             + 2.9928798706262835901274862837607e6*y
             + 1.4964399353131417950637431418804e7*z)))
             + x*(-301101.85365088671270373498369956
             + (1.0225672891306468932935578136182e6
             - 612179.9735371943707078949216783*z)*z
             + x*(381365.45018131886352988120676405
             + z*(-884259.96177594742435584822020203
             + 272079.9882387530536479532985237*z)
             + x*(-231267.99000294009560076030374515
             + 54415.99764775061072959065970474*x
             + 1.1971519482505134360509945135043e6*y
             + 272079.9882387530536479532985237*z)
             + y*(-3.8907438318141686671657321688889e6
             + 5.223935774184058630040703331655e6*y
             + 5.713679753013814126607019268998e6*z))
             + y*(4.4992960721748463304916543799203e6
             + z*(-1.2855779444281081784865793355245e7
             + 5.441599764775061072959065970474e6*z)
             + y*(-1.1753855491914131917591582496224e7
             + 7.074079694207579394846785761616e6*y
             + 2.0405999117906479023596497389278e7*z)))));
            return;
          case ( 103 ):
            grad[0]= 1499.6999699939984995798739603871
             + z*(-29137.027988454827991837551230378
             + z*(127260.25459663358696434930463856
             + z*(-191961.59615923180794622386692955
             + 92981.398139627906973952185544*z)))
             + y*(-21852.770991341120993878163422784
             + y*(70700.141442574214980194058132536
             + z*(-987231.06596176358372343702992341
             + (2.7495927735575681062297289153726e6
             - 1.979603960392078019445433627711e6*z)*z)
             + y*(-95980.798079615903973111933464776
             + y*(59773.755946903654483254976421144
             - 14140.028288514842996038811626507*y
             - 282800.56577029685992077623253014*z)
             + (903247.86764209966774696408814173
             - 1.2726025459663358696434930463856e6*z)*z))
             + z*(395920.7920784156038890867255422
             + z*(-1.6042504821878658235505851736255e6
             + (2.231553555351069767374852453056e6
             - 989801.9801960390097227168138555*z)*z)))
             + x*(-23995.199519903975993277983366194
             + z*(421629.93442116986388188456486312
             + z*(-1.6428141957019972135397819326069e6
             + (2.1715655565513098273916574946406e6
             - 899819.9819963990997479243762323*z)*z))
             + y*(316222.45081587739791141342364734
             + z*(-5.1109774977395468865682104569993e6
             + z*(1.8148083579750232128915994776639e7
             + z*(-2.1595679567913578393950185029575e7
             + 7.918415841568312077781734510844e6*z)))
             + y*(-912674.55316777622974432329589274
             + y*(1.0857827782756549136958287473203e6
             + y*(-578455.70271197084983795138472075
             + 113120.22630811874396831049301206*y
             + 2.2624045261623748793662098602411e6*z)
             + z*(-8.7411083965364483975512653691135e6
             + 1.0180820367730686957147944371085e7*z))
             + z*(1.1168051433692450540871381401009e7
             + z*(-2.6608962324750659092545763697154e7
             + 1.5836831683136624155563469021688e7*z))))
             + x*(116976.5976595318829672301689102
             + z*(-1.7070870515588828635217765309092e6
             + z*(5.2176704384619770655383214901812e6
             + z*(-4.8590279027805551386387916316543e6
             + 1.0797839783956789196975092514787e6*z)))
             + x*(-257948.39483896774192773832118659
             + z*(2.8828518280341776871923977158527e6
             + z*(-6.0159393082044968383146944010958e6
             + 2.8794239423884771191933580039433e6*z))
             + x*(289442.09420884171041891567435472
             + x*(-161967.59675935183795462638772181
             + 35992.799279855963989916975049291*x
             + 462764.5621695766798703611077766*y
             + 617019.4162261022398271481437021*z)
             + z*(-2.1852770991341120993878163422784e6
             + 2.313822810847883399351805538883e6*z)
             + y*(-1.6389578243505840745408622567088e6
             + 1.2854571171377129996398919660461e6*y
             + 7.198559855971192797983395009858e6*z))
             + y*(2.1621388710256332653942982868896e6
             + y*(-3.3421885045580537990637191117199e6
             + 1.4397119711942385595966790019716e6*y
             + 1.4808465989426453755851555448851e7*z)
             + z*(-1.8716255625525101274756827025631e7
             + 2.4063757232817987353258777604383e7*z)))
             + y*(-1.2803152886691621476413323981819e6
             + z*(1.623275247521503975945255574723e7
             + z*(-4.0607590330380353658624187207397e7
             + 2.591481548149629407274022203549e7*z))
             + y*(2.898705799145542814187956383434e6
             + y*(-2.4295139513902775693193958158271e6
             + 694146.8432543650198055416616649*y
             + 1.0489330075843738077061518442936e7*z)
             + z*(-2.4989286357157140712999499819936e7
             + 3.1930754789700790911054916436585e7*z)))));
            grad[1]= 642.72855856885649981994598302305
             + z*(-11997.599759951987996638991683097
             + z*(50132.827568370806985955786675798
             + z*(-71985.598559711927979833950098582
             + 32993.399339867966990757227128517*z)))
             + y*(-4284.8570571257099987996398868204
             + y*(8998.1998199639909974792437623228
             + y*(-7712.7427028262779978393517962766
             + 2356.6713814191404993398019377512*y
             + 37706.742102706247989436831004019*z)
             + z*(-87411.083965364483975512653691135
             + 127260.25459663358696434930463856*z))
             + z*(61701.941622610223982714814370213
             + z*(-177393.08216500439395030509131436
             + 131973.59735947186796302890851407*z)))
             + x*(-21852.770991341120993878163422784
             + y*(141400.28288514842996038811626507
             + z*(-1.9744621319235271674468740598468e6
             + (5.4991855471151362124594578307452e6
             - 3.959207920784156038890867255422e6*z)*z)
             + y*(-287942.39423884771191933580039433
             + y*(239095.02378761461793301990568458
             - 70700.14144257421498019405813254*y
             - 1.1312022630811874396831049301206e6*z)
             + (2.7097436029262990032408922644252e6
             - 3.8178076378990076089304791391569e6*z)*z))
             + z*(395920.7920784156038890867255422
             + z*(-1.6042504821878658235505851736255e6
             + (2.231553555351069767374852453056e6
             - 989801.9801960390097227168138555*z)*z))
             + x*(158111.22540793869895570671182367
             + z*(-2.5554887488697734432841052284997e6
             + z*(9.0740417898751160644579973883195e6
             + z*(-1.0797839783956789196975092514787e7
             + 3.959207920784156038890867255422e6*z)))
             + y*(-912674.55316777622974432329589274
             + y*(1.6286741674134823705437431209804e6
             + y*(-1.1569114054239416996759027694415e6
             + 282800.56577029685992077623253014*y
             + 4.5248090523247497587324197204823e6*z)
             + z*(-1.311166259480467259632689805367e7
             + 1.5271230551596030435721916556628e7*z))
             + z*(1.1168051433692450540871381401009e7
             + z*(-2.6608962324750659092545763697154e7
             + 1.5836831683136624155563469021688e7*z)))
             + x*(-426771.76288972071588044413272731
             + x*(540534.71775640831634857457172239
             + x*(-327791.56487011681490817245134176
             + 77127.42702826277997839351796277*x
             + 514182.8468550851998559567864184*y
             + 1.4397119711942385595966790019716e6*z)
             + z*(-4.6790639063812753186892067564078e6
             + 6.015939308204496838314694401096e6*z)
             + y*(-1.6710942522790268995318595558599e6
             + 1.0797839783956789196975092514787e6*y
             + 7.404232994713226877925777724426e6*z))
             + z*(5.4109174917383465864841852490767e6
             + z*(-1.3535863443460117886208062402466e7
             + 8.63827182716543135758007401183e6*z))
             + y*(1.932470532763695209458637588956e6
             + y*(-2.4295139513902775693193958158271e6
             + 925529.1243391533597407222155532*y
             + 1.0489330075843738077061518442936e7*z)
             + z*(-1.6659524238104760475332999879958e7
             + 2.1287169859800527274036610957724e7*z)))));
            grad[2]= 856.97141142514199975992797736407
             + z*(-7712.7427028262779978393517962766
             + (17996.399639927981994958487524646
             - 11997.599759951987996638991683097*z)*z)
             + y*(-11997.599759951987996638991683097
             + z*(100265.6551367416139719115733516
             + z*(-215956.79567913578393950185029575
             + 131973.59735947186796302890851407*z))
             + y*(30850.970811305111991357407185107
             + y*(-29137.027988454827991837551230378
             + 9426.685525676561997359207751005*y
             + 84840.16973108905797623286975904*z)
             + z*(-177393.08216500439395030509131436
             + 197960.3960392078019445433627711*z)))
             + x*(-29137.027988454827991837551230378
             + z*(254520.50919326717392869860927713
             + z*(-575884.78847769542383867160078866
             + 371925.59255851162789580874217601*z))
             + y*(395920.7920784156038890867255422
             + y*(-987231.06596176358372343702992341
             + y*(903247.86764209966774696408814173
             - 282800.56577029685992077623253014*y
             - 2.5452050919326717392869860927713e6*z)
             + (5.4991855471151362124594578307452e6
             - 5.938811881176234058336300883133e6*z)*z)
             + z*(-3.2085009643757316471011703472511e6
             + (6.6946606660532093021245573591681e6
             - 3.959207920784156038890867255422e6*z)*z))
             + x*(210814.96721058493194094228243156
             + z*(-1.6428141957019972135397819326069e6
             + (3.2573483348269647410874862419608e6
             - 1.7996399639927981994958487524646e6*z)*z)
             + y*(-2.5554887488697734432841052284997e6
             + z*(1.8148083579750232128915994776639e7
             + z*(-3.2393519351870367590925277544362e7
             + 1.5836831683136624155563469021688e7*z))
             + y*(5.5840257168462252704356907005043e6
             + y*(-4.3705541982682241987756326845568e6
             + 1.1312022630811874396831049301206e6*y
             + 1.0180820367730686957147944371085e7*z)
             + z*(-2.6608962324750659092545763697154e7
             + 2.3755247524704936233345203532532e7*z)))
             + x*(-569029.01718629428784059217696974
             + z*(3.4784469589746513770255476601208e6
             + z*(-4.8590279027805551386387916316543e6
             + 1.4397119711942385595966790019716e6*z))
             + x*(720712.95700854442179809942896318
             + x*(-437055.41982682241987756326845568
             + 102836.56937101703997119135728369*x
             + 1.4397119711942385595966790019716e6*y
             + 925529.1243391533597407222155532*z)
             + z*(-3.0079696541022484191573472005479e6
             + 2.1595679567913578393950185029575e6*z)
             + y*(-4.6790639063812753186892067564078e6
             + 3.7021164973566134389628888622128e6*y
             + 1.2031878616408993676629388802192e7*z))
             + y*(5.4109174917383465864841852490767e6
             + y*(-8.3297621190523802376664999399788e6
             + 3.4964433586145793590205061476454e6*y
             + 2.1287169859800527274036610957724e7*z)
             + z*(-2.7071726886920235772416124804931e7
             + 2.591481548149629407274022203549e7*z)))));
            return;
          case ( 104 ):
            grad[0]= 1657.9806995257815726609835938296
             + z*(-48318.294671894205831834379020176
             + z*(328280.17850610475138687475157825
             + z*(-848886.11815720016520242360004074
             + (925153.2303353861175448288453569
             - 358123.83109756881969477245626719*z)*z)))
             + y*(-8053.0491119823676386390631700293
             + z*(187588.67343205985793535700090186
             + z*(-954996.88292685018585272655004583
             + (1.6447168539295753200796957250789e6
             - 895309.577743922049236931140668*z)*z))
             + y*(15632.389452671654827946416741822
             + z*(-272856.25226481433881506472858452
             + (925153.2303353861175448288453569
             - 795830.7357723751548772721250382*z)*z)
             + y*(-15158.680681378574378614707143585
             + y*(7342.4859550427469646414987726738
             - 1421.1263138792413479951287947111*y
             - 42633.789416377240439853863841332*z)
             + (176219.66292102592715139597054417
             - 298436.52591464068307897704688932*z)*z)))
             + x*(-26527.691192412505162575737501273
             + z*(699194.14642858674321360336699784
             + z*(-4.2377986679878976997214740658284e6
             + z*(9.6030242116533268688524169754608e6
             + z*(-8.9530957774392204923693114066796e6
             + 2.8649906487805505575581796501375e6*z))))
             + y*(116532.35773809779053560056116631
             + y*(-201799.93657085227141530828884897
             + y*(171482.5752080951226580788745618
             + y*(-71056.315693962067399756439735553
             + 11369.010511033930783961030357688*y
             + 341070.31533101792351883091073065*z)
             + z*(-1.7053515766550896175941545536533e6
             + 2.3874922073171254646318163751146e6*z))
             + z*(3.0866863537457122078454197421124e6
             + z*(-8.9530957774392204923693114066796e6
             + 6.366645886179001239018177000306e6*z)))
             + z*(-2.4215992388502272569836994661876e6
             + z*(1.0803402238109992727458969097393e7
             + z*(-1.5916614715447503097545442500764e7
             + 7.162476621951376393895449125344e6*z))))
             + x*(129322.49456301096266755672031871
             + z*(-2.8308836172474487652062965590644e6
             + z*(1.3459487318750294806861864814708e7
             + z*(-2.1487429865854129181686347376031e7
             + 1.0743714932927064590843173688016e7*z)))
             + x*(-285172.68031843443049768917813868
             + x*(319990.27500847584352356983360911
             + x*(-179061.91554878440984738622813359
             + 39791.53678861875774386360625191*x
             + 170535.15766550896175941545536533*y
             + 1.023210945993053770556492732192e6*z)
             + y*(-603978.6833986775728979297377522
             + 284225.26277584826959902575894221*y
             + 3.4107031533101792351883091073065e6*z)
             + z*(-3.6238721003920654373875784265132e6
             + 5.968730518292813661579540937786e6*z))
             + z*(4.780668919889767894655613265408e6
             + z*(-1.5518699347561315520106806438245e7
             + 1.2733291772358002478036354000611e7*z))
             + y*(796778.15331496131577593554423466
             + y*(-738985.68321720550095746697324975
             + 227380.21022067861567922060715377*y
             + 4.0928437839722150822259709287678e6*z)
             + z*(-8.867828198606466011489603678997e6
             + 1.4324953243902752787790898250687e7*z)))
             + y*(-471813.93620790812753438275984407
             + y*(640927.96755953784794580308641469
             + y*(-383704.10474739516395868477457198
             + 85267.57883275448087970772768266*y
             + 2.0464218919861075411129854643839e6*z)
             + z*(-6.9066738854531129512563259422957e6
             + 1.0743714932927064590843173688016e7*z))
             + z*(7.6911356107144541753496370369762e6
             + z*(-2.4173358599085895329397140798035e7
             + 1.9099937658537003717054531000917e7*z)))));
            grad[1]= 236.85438564654022466585479911851
             + z*(-5684.5052555169653919805151788442
             + z*(29843.652591464068307897704688932
             + z*(-53055.382384825010325151475002546
             + 29843.652591464068307897704688932*z)))
             + y*(-947.41754258616089866341919647404
             + y*(1421.1263138792413479951287947111
             + y*(-947.41754258616089866341919647404
             + 236.85438564654022466585479911851*y
             + 5684.505255516965391980515178844*z)
             + z*(-17053.515766550896175941545536533
             + 29843.652591464068307897704688932*z))
             + z*(17053.515766550896175941545536533
             + z*(-59687.305182928136615795409377864
             + 53055.38238482501032515147500255*z)))
             + x*(-8053.0491119823676386390631700293
             + y*(31264.778905343309655892833483643
             + z*(-545712.50452962867763012945716904
             + (1.8503064606707722350896576907138e6
             - 1.5916614715447503097545442500764e6*z)*z)
             + y*(-45476.042044135723135844121430754
             + y*(29369.943820170987858565995090695
             - 7105.631569396206739975643973555*y
             - 170535.15766550896175941545536533*z)
             + (528658.98876307778145418791163251
             - 895309.577743922049236931140668*z)*z))
             + z*(187588.67343205985793535700090186
             + z*(-954996.88292685018585272655004583
             + (1.6447168539295753200796957250789e6
             - 895309.577743922049236931140668*z)*z))
             + x*(58266.178869048895267800280583153
             + z*(-1.2107996194251136284918497330938e6
             + z*(5.4017011190549963637294845486967e6
             + z*(-7.9583073577237515487727212503819e6
             + 3.5812383109756881969477245626719e6*z)))
             + y*(-201799.93657085227141530828884897
             + y*(257223.8628121426839871183118427
             + y*(-142112.63138792413479951287947111
             + 28422.526277584826959902575894221*y
             + 682140.6306620358470376618214613*z)
             + z*(-2.5580273649826344263912318304799e6
             + 3.5812383109756881969477245626719e6*z))
             + z*(3.0866863537457122078454197421124e6
             + z*(-8.9530957774392204923693114066796e6
             + 6.366645886179001239018177000306e6*z)))
             + x*(-157271.31206930270917812758661469
             + x*(199194.53832874032894398388605867
             + x*(-120795.73667973551457958594755044
             + 28422.526277584826959902575894221*x
             + 113690.10511033930783961030357688*y
             + 682140.6306620358470376618214613*z)
             + y*(-369492.84160860275047873348662487
             + 170535.15766550896175941545536533*y
             + 2.0464218919861075411129854643839e6*z)
             + z*(-2.2169570496516165028724009197492e6
             + 3.5812383109756881969477245626719e6*z))
             + z*(2.5637118702381513917832123456587e6
             + z*(-8.0577861996952984431323802660117e6
             + 6.366645886179001239018177000306e6*z))
             + y*(427285.31170635856529720205760979
             + y*(-383704.10474739516395868477457198
             + 113690.10511033930783961030357688*y
             + 2.0464218919861075411129854643839e6*z)
             + z*(-4.6044492569687419675042172948638e6
             + 7.162476621951376393895449125344e6*z)))));
            grad[2]= 1421.1263138792413479951287947111
             + z*(-19895.768394309378871931803125955
             + z*(79583.073577237515487727212503819
             + z*(-119374.61036585627323159081875573
             + 59687.30518292813661579540937786*z)))
             + y*(-5684.5052555169653919805151788442
             + y*(8526.7578832754480879707727682663
             + y*(-5684.5052555169653919805151788442
             + 1421.1263138792413479951287947111*y
             + 19895.768394309378871931803125955*z)
             + z*(-59687.305182928136615795409377864
             + 79583.07357723751548772721250382*z))
             + z*(59687.305182928136615795409377864
             + z*(-159166.14715447503097545442500764
             + 119374.61036585627323159081875573*z)))
             + x*(-48318.294671894205831834379020176
             + y*(187588.67343205985793535700090186
             + z*(-1.9099937658537003717054531000917e6
             + (4.9341505617887259602390871752368e6
             - 3.5812383109756881969477245626719e6*z)*z)
             + y*(-272856.25226481433881506472858452
             + y*(176219.66292102592715139597054417
             - 42633.789416377240439853863841332*y
             - 596873.0518292813661579540937786*z)
             + (1.8503064606707722350896576907138e6
             - 2.3874922073171254646318163751146e6*z)*z))
             + z*(656560.35701220950277374950315651
             + z*(-2.5466583544716004956072708001222e6
             + (3.7006129213415444701793153814276e6
             - 1.7906191554878440984738622813359e6*z)*z))
             + x*(349597.07321429337160680168349892
             + z*(-4.2377986679878976997214740658284e6
             + z*(1.4404536317479990303278625463191e7
             + z*(-1.7906191554878440984738622813359e7
             + 7.162476621951376393895449125344e6*z)))
             + y*(-1.2107996194251136284918497330938e6
             + y*(1.5433431768728561039227098710562e6
             + y*(-852675.78832754480879707727682663
             + 170535.15766550896175941545536533*y
             + 2.3874922073171254646318163751146e6*z)
             + z*(-8.9530957774392204923693114066796e6
             + 9.549968829268501858527265500458e6*z))
             + z*(1.0803402238109992727458969097393e7
             + z*(-2.3874922073171254646318163751146e7
             + 1.4324953243902752787790898250687e7*z)))
             + x*(-943627.87241581625506876551968814
             + x*(1.195167229972441973663903316352e6
             + x*(-724774.42007841308747751568530264
             + 170535.15766550896175941545536533*x
             + 682140.6306620358470376618214613*y
             + 2.3874922073171254646318163751146e6*z)
             + y*(-2.2169570496516165028724009197492e6
             + 1.023210945993053770556492732192e6*y
             + 7.162476621951376393895449125344e6*z)
             + z*(-7.7593496737806577600534032191224e6
             + 9.549968829268501858527265500458e6*z))
             + z*(8.9729915458335298712412432098056e6
             + z*(-2.1487429865854129181686347376031e7
             + 1.4324953243902752787790898250687e7*z))
             + y*(2.5637118702381513917832123456587e6
             + y*(-2.3022246284843709837521086474319e6
             + 682140.6306620358470376618214613*y
             + 7.162476621951376393895449125344e6*z)
             + z*(-1.6115572399390596886264760532023e7
             + 1.9099937658537003717054531000917e7*z)))));
            return;
          case ( 105 ):
            grad[0]= 339.39946965191327475973317181595
             + y*(-15550.666609505844588991410781385
             + y*(166614.28510184833488205082980056
             + y*(-703482.53709669296950199239249125
             + y*(1.3745678520902487627769193458546e6
             + y*(-1.2462748525618255449177402069082e6
             + 423570.53812558776690014699842631*y)))))
             + x*(-3424.8491937602157725754892792337
             + y*(133291.42808147866790564066384045
             + y*(-1.1662999957129383441743558086039e6
             + y*(3.7765904623085622573264854754793e6
             + y*(-5.0400821243309121301820376014669e6
             + 2.3459291342340245551392756835919e6*y))))
             + x*(12033.253924022379741481448818929
             + x*(-20672.513151525626735365565919699
             + x*(18975.515803266060361566900060619
             + x*(-8978.6586971551602686438502725857
             + 1727.8518455006493987768234201539*x
             + 71088.76164345528954967502071491*y)
             + y*(-299905.71318332700278769149364101
             + 666457.1404073933395282033192022*y))
             + y*(488735.23629875511565401576741497
             + y*(-2.1659857063240283534666607874073e6
             + 2.3696253881151763183225006904968e6*y)))
             + y*(-377659.04623085622573264854754793
             + y*(2.4992142765277250232307624470084e6
             + y*(-5.4427333133270456061469937734849e6
             + 3.6655142722406633674051182556123e6*y)))));
            grad[1]= 740.50793378599259947578146578026
             + y*(-16661.428510184833488205082980056
             + y*(111076.19006789888992136721986704
             + y*(-305459.52268672194728375985463436
             + (366551.42722406633674051182556123
             - 158838.95179709541258755512440987*y)*y)))
             + x*(-15550.666609505844588991410781385
             + y*(333228.57020369666976410165960112
             + y*(-2.1104476112900789085059771774737e6
             + y*(5.4982714083609950511076773834184e6
             + y*(-6.2313742628091277245887010345409e6
             + 2.5414232287535266014008819905579e6*y))))
             + x*(66645.714040739333952820331920224
             + x*(-125886.34874361874191088284918264
             + x*(122183.80907468877891350394185374
             + x*(-59981.142636665400557538298728201
             + 11848.126940575881591612503452484*x
             + 266582.85616295733581128132768089*y)
             + y*(-1.0829928531620141767333303937036e6
             + 1.7772190410863822387418755178726e6*y))
             + y*(1.6661428510184833488205082980056e6
             + y*(-5.4427333133270456061469937734849e6
             + 4.8873523629875511565401576741497e6*y)))
             + y*(-1.1662999957129383441743558086039e6
             + y*(5.664885693462843385989728213219e6
             + y*(-1.0080164248661824260364075202934e7
             + 5.86482283558506138784818920898e6*y)))));
            grad[2]= 0;
            return;
          case ( 106 ):
            grad[0]= 587.85712549904504836183965594151
             - 1122.2726941345405468726029795247*z
             + y*(-25812.271965094432578069868529068
             + 48097.401177194594865968699122487*z
             + y*(264535.70647457027176282784517368
             - 456925.31118334865122670264166363*z
             + y*(-1.0661590594278135195289728305485e6
             + 1.5872142388474216305769670710421e6*z
             + y*(1.9840177985592770382212088388026e6
             - 2.2485535050338473099840366839763e6*z
             + y*(-1.708900663825723955587867879822e6
             + 550234.2694671061652666819179613*y
             + 1.1004685389342123305333638359225e6*z)))))
             + x*(-5932.0128118540000334694728917734
             + 9619.480235438918973193739824497*z
             + y*(221248.04541509513638345601596344
             - 336681.80824036216406178089385741*z
             + y*(-1.8517499453219919023397949162158e6
             + 2.4529674600369243381644036552468e6*z
             + y*(5.723590740086156789050275195576e6
             - 5.819785542440545978782212593821e6*z
             + y*(-7.2747319280506824734777657422762e6
             + 3.2167541907307745046359865973119e6*y
             + 4.2325713035931243482052455227789e6*z))))
             + x*(20842.207176784324441919769619744
             - 27255.194000410270424048929502743*z
             + x*(-35805.843098578198400221142680074
             + 35271.427529942702901710379356491*z
             + x*(32866.557471082973158411944400366
             - 21643.830529737567689685914605119*z
             + x*(-15551.493047292919006663212716271
             + 2992.7271843587747916602746120659*x
             + 117998.95755471740607117654184717*y
             + 5130.389458900756785703327906399*z)
             + y*(-497808.10218396405686277603591774
             + 1.0581428258982810870513113806947e6*y
             + 192389.60470877837946387479648995*z))
             + y*(811242.83318868216673933872519928
             - 625266.2153035297332575930885923*z
             + y*(-3.4389641841694135329167619872578e6
             + 3.591272621230529749992329534479e6*y
             + 1.5391168376702270357109983719196e6*z)))
             + y*(-626869.46200943621975312537856308
             + 721461.0176579189229895304868373*z
             + y*(3.9680355971185540764424176776052e6
             - 3.5351589865238027226486993855028e6*z
             + y*(-8.2487043018888730195136318995065e6
             + 5.290714129491405435256556903474e6*y
             + 4.2325713035931243482052455227789e6*z)))));
            grad[1]= 1229.1558078616396465747556442413
             - 2404.8700588597297432984349561244*z
             + y*(-26453.570647457027176282784517368
             + 48097.401177194594865968699122487*z
             + y*(168340.9041201810820308904469287
             - 264535.70647457027176282784517368*z
             + y*(-440892.84412428378627137974195613
             + y*(502617.84230168351634937290582999
             - 206337.85105016481197500571923547*y
             - 343896.41841694135329167619872578*z)
             + 529071.4129491405435256556903474*z)))
             + x*(-25812.271965094432578069868529068
             + 48097.401177194594865968699122487*z
             + y*(529071.41294914054352565569034736
             - 913850.6223666973024534052833273*z
             + y*(-3.1984771782834405585869184916454e6
             + 4.7616427165422648917309012131262e6*z
             + y*(7.9360711942371081528848353552104e6
             - 8.994214020135389239936146735905e6*z
             + y*(-8.5445033191286197779393393991098e6
             + 3.3014056168026369916000915077675e6*y
             + 5.502342694671061652666819179613e6*z))))
             + x*(110624.02270754756819172800798172
             - 168340.9041201810820308904469287*z
             + x*(-208956.48733647873991770845952103
             + 240487.00588597297432984349561244*z
             + x*(202810.70829717054168483468129982
             - 156316.55382588243331439827214808*z
             + x*(-99561.620436792811372555207183548
             + 19666.492925786234345196090307861*x
             + 423257.13035931243482052455227789*y
             + 38477.92094175567589277495929799*z)
             + y*(-1.7194820920847067664583809936289e6
             + 2.6934544659228973124942471508593e6*y
             + 769558.4188351135178554991859598*z))
             + y*(2.6453570647457027176282784517368e6
             - 2.3567726576825351484324662570019e6*z
             + y*(-8.2487043018888730195136318995065e6
             + 7.054285505988540580342075871298e6*y
             + 4.2325713035931243482052455227789e6*z)))
             + y*(-1.8517499453219919023397949162158e6
             + 2.4529674600369243381644036552468e6*z
             + y*(8.5853861101292351835754127933639e6
             - 8.729678313660818968173318890731e6*z
             + y*(-1.4549463856101364946955531484552e7
             + 8.04188547682693626158996649328e6*y
             + 8.465142607186248696410491045558e6*z)))));
            grad[2]= 53.441556863549549851076332358319
             + y*(-2404.8700588597297432984349561244
             + y*(24048.700588597297432984349561244
             + y*(-88178.568824856757254275948391226
             + (132267.85323728513588141392258684
             - 68779.28368338827065833523974516*y)*y)))
             + x*(-1122.2726941345405468726029795247
             + y*(48097.401177194594865968699122487
             + y*(-456925.31118334865122670264166363
             + y*(1.5872142388474216305769670710421e6
             + y*(-2.2485535050338473099840366839763e6
             + 1.1004685389342123305333638359225e6*y))))
             + x*(4809.7401177194594865968699122487
             + x*(-9085.0646668034234746829765009142
             + x*(8817.8568824856757254275948391226
             + x*(-4328.7661059475135379371829210238
             + 855.0649098167927976172213177331*x
             + 38477.92094175567589277495929799*y)
             + y*(-156316.55382588243331439827214808
             + 384779.2094175567589277495929799*y))
             + y*(240487.00588597297432984349561244
             + y*(-1.1783863288412675742162331285009e6
             + 1.4108571011977081160684151742596e6*y)))
             + y*(-168340.9041201810820308904469287
             + y*(1.2264837300184621690822018276234e6
             + y*(-2.9098927712202729893911062969105e6
             + 2.1162856517965621741026227613894e6*y)))));
            return;
          case ( 107 ):
            grad[0]= 758.92028566905496837020600213575
             + z*(-4346.5434542864057279384525576865
             + 4139.5651945584816456556691025586*z)
             + y*(-30425.804180004840095569167903806
             + (169722.1729768977474718824332049
             - 157303.47739322230253491542589723*z)*z
             + y*(283560.21582725599272741333352527
             + z*(-1.4550571658873062984479676895494e6
             + 1.2294508627838690487597337234599e6*z)
             + y*(-1.0355812261720468250215265538234e6
             + (4.5079864968741865121190236526863e6
             - 3.0963947655297442709504404887138e6*z)*z
             + y*(1.7417220556104811524096227749015e6
             + z*(-5.6122155125226614910976733857938e6
             + 2.3678312912874515013150427266635e6*z)
             + y*(-1.3546727099192631185408177138123e6
             + 394638.54854790858355250712111059*y
             + 2.3678312912874515013150427266635e6*z)))))
             + x*(-7658.1956099331910444629878397334
             + (37256.086751026334810901021923028
             - 28976.95636190937151958968371791*z)*z
             + y*(260792.60725718434367630715346119
             + z*(-1.1880552108382842323031770324343e6
             + 844471.299689930255713756496922*z)
             + y*(-1.9849215107907919490918933346769e6
             + (7.8113595221318548653522475965281e6
             - 4.5079864968741865121190236526863e6*z)*z
             + y*(5.5594360562920408501155636047362e6
             + z*(-1.6529283821872017211103086726517e7
             + 5.828507793938342157083182096403e6*z)
             + y*(-6.3863142039050975588352835079723e6
             + 2.5499721598480246937238921671761e6*y
             + 1.056417037651324515971326754973e7*z))))
             + x*(26907.173764630130696761849166631
             + z*(-105558.91246124128196421956211524
             + 62093.47791837722468483503653838*z)
             + x*(-46225.144672569711709821638311905
             + (136605.65142042989430663708038443
             - 53814.34752926026139352369833326*z)*z
             + x*(42430.543244224436867970608301226
             + z*(-83826.195189809253324527299326812
             + 16558.260778233926582622676410234*z)
             + x*(-20076.891193608635981429995147409
             + 3863.5941815879162026119578290547*x
             + 139089.39053716498329403048184597*y
             + 19869.912933880711899147211692281*z)
             + y*(-586783.36632866477327169109528768
             + 1.1342408633090239709096533341011e6*y
             + 678888.6919075909898875297328196*z))
             + y*(956239.55994300926014645956269104
             + z*(-2.2063882486996707171344716316637e6
             + 529864.3449034856506439256451275*z)
             + y*(-3.6862828057543279054563733358284e6
             + 3.4882736039479472000725104970894e6*y
             + 4.9012451903572422684563122174294e6*z)))
             + y*(-738912.38722868897374953693480671
             + (2.5458325946534662120782364980735e6
             - 1.2170321672001936038227667161522e6*z)*z
             + y*(4.253403237408839890911200002879e6
             + z*(-1.1257547546601790835360592124408e7
             + 3.2785356340903174633592899292264e6*z)
             + y*(-8.0121284340679412251665475480022e6
             + 4.6445921482946164064256607330708e6*y
             + 1.202129732499783069898406307383e7*z)))));
            grad[1]= 1448.8478180954685759794841858955
             + z*(-8486.1086488448873735941216602452
             + 8279.130389116963291311338205117*z)
             + y*(-28356.021582725599272741333352527
             + (153163.91219866382088925975679467
             - 136605.65142042989430663708038443*z)*z
             + y*(163512.82518506002500339892955107
             + z*(-751331.08281236441868650394211439
             + 546422.6056817195772265483215377*z)
             + y*(-387049.34569121803386880506108923
             + y*(398433.14997625385839435815112127
             - 147989.45570546571883219017041647*y
             - 739947.2785273285941609508520824*z)
             + (1.3205212970641556449641584437162e6
             - 591957.8228218628753287606816659*z)*z)))
             + x*(-30425.804180004840095569167903806
             + (169722.1729768977474718824332049
             - 157303.47739322230253491542589723*z)*z
             + y*(567120.43165451198545482666705053
             + z*(-2.9101143317746125968959353790987e6
             + 2.4589017255677380975194674469198e6*z)
             + y*(-3.1067436785161404750645796614702e6
             + (1.3523959490622559536357070958059e7
             - 9.289184296589232812851321466142e6*z)*z
             + y*(6.9668882224419246096384910996062e6
             + z*(-2.2448862050090645964390693543175e7
             + 9.471325165149806005260170906654e6*z)
             + y*(-6.7733635495963155927040885690615e6
             + 2.3678312912874515013150427266635e6*y
             + 1.1839156456437257506575213633318e7*z))))
             + x*(130396.3036285921718381535767306
             + z*(-594027.60541914211615158851621716
             + 422235.64984496512785687824846098*z)
             + x*(-246304.12907622965791651231160224
             + (848610.86488448873735941216602452
             - 405677.38906673120127425557205074*z)*z
             + x*(239059.88998575231503661489067276
             + z*(-551597.06217491767928361790791594
             + 132466.08622587141266098141128188*z)
             + x*(-117356.67326573295465433821905754
             + 23181.565089527497215671746974328*x
             + 453696.34532360958836386133364042*y
             + 135777.73838151819797750594656392*z)
             + y*(-1.8431414028771639527281866679142e6
             + 2.616205202960960400054382872817e6*y
             + 2.4506225951786211342281561087147e6*z))
             + y*(2.8356021582725599272741333352527e6
             + z*(-7.5050316977345272235737280829388e6
             + 2.1856904227268783089061932861509e6*z)
             + y*(-8.0121284340679412251665475480022e6
             + 6.192789531059488541900880977428e6*y
             + 1.202129732499783069898406307383e7*z)))
             + y*(-1.9849215107907919490918933346769e6
             + (7.8113595221318548653522475965281e6
             - 4.5079864968741865121190236526863e6*z)*z
             + y*(8.3391540844380612751733454071043e6
             + z*(-2.4793925732808025816654630089775e7
             + 8.742761690907513235624773144604e6*z)
             + y*(-1.2772628407810195117670567015945e7
             + 6.37493039962006173430973041794e6*y
             + 2.1128340753026490319426535099459e7*z)))));
            grad[2]= 206.97825972792408228278345512793
             - 413.95651945584816456556691025586*z
             + y*(-8486.1086488448873735941216602452
             + 16558.260778233926582622676410234*z
             + y*(76581.956099331910444629878397334
             - 136605.65142042989430663708038443*z
             + y*(-250443.6942707881395621679807048
             + y*(330130.32426603891124103961092905
             - 147989.45570546571883219017041647*y
             - 295978.91141093143766438034083294*z)
             + 364281.73712114638481769888102516*z)))
             + x*(-4346.5434542864057279384525576865
             + 8279.130389116963291311338205117*z
             + y*(169722.1729768977474718824332049
             - 314606.95478644460506983085179445*z
             + y*(-1.4550571658873062984479676895494e6
             + 2.4589017255677380975194674469198e6*z
             + y*(4.5079864968741865121190236526863e6
             - 6.192789531059488541900880977428e6*z
             + y*(-5.6122155125226614910976733857938e6
             + 2.3678312912874515013150427266635e6*y
             + 4.7356625825749030026300854533271e6*z))))
             + x*(18628.043375513167405450510961514
             - 28976.95636190937151958968371791*z
             + x*(-35186.304153747093988073187371748
             + 41395.651945584816456556691025586*z
             + x*(34151.412855107473576659270096109
             - 26907.173764630130696761849166631*z
             + x*(-16765.239037961850664905459865362
             + 3311.6521556467853165245352820469*x
             + 135777.73838151819797750594656392*y
             + 6623.304311293570633049070564094*z)
             + y*(-551597.06217491767928361790791594
             + 1.2253112975893105671140780543574e6*y
             + 264932.17245174282532196282256375*z))
             + y*(848610.86488448873735941216602452
             - 811354.7781334624025485111441015*z
             + y*(-3.7525158488672636117868640414694e6
             + 4.0070991083326102329946876912767e6*y
             + 2.1856904227268783089061932861509e6*z)))
             + y*(-594027.60541914211615158851621716
             + 844471.299689930255713756496922*z
             + y*(3.9056797610659274326761237982641e6
             - 4.5079864968741865121190236526863e6*z
             + y*(-8.2646419109360086055515433632583e6
             + 5.282085188256622579856633774865e6*y
             + 5.828507793938342157083182096403e6*z)))));
            return;
          case ( 108 ):
            grad[0]= 897.96659180617627251461954314202
             + z*(-10285.79914250711003062200567599
             + (24489.997958350261977671442085691
             - 15510.332040288499252525246654271*z)*z)
             + y*(-30857.397427521330091866017027971
             + z*(342859.97141690366768740018919968
             + z*(-791026.93405471346187878757936783
             + 484901.95957533518715789455329669*z))
             + y*(244899.97958350261977671442085691
             + z*(-2.4661427944058713811515142180291e6
             + (5.0914705755410194651578928096153e6
             - 2.7477777709268993938947358020146e6*z)*z)
             + y*(-760006.26997413646337373708605929
             + z*(6.303725474479357433052629192857e6
             + z*(-1.0075185160065297777614031274053e7
             + 3.7355410219136932936608172994708e6*z))
             + y*(1.0910294090445041711052627449176e6
             + y*(-732740.73891383983837192954720389
             + 186777.05109568466468304086497354*y
             + 2.2413246131482159761964903796825e6*z)
             + z*(-6.411481465496098585754383538034e6
             + 5.603311532870539940491225949206e6*z)))))
             + x*(-9061.2992445895969317384335717058
             + z*(88163.992650060943119617191508489
             + z*(-171429.98570845183384370009459984
             + 83265.99305839089072408290309135*z))
             + x*(31836.997345855340570972874711399
             + z*(-249797.97917517267217224870927405
             + (367349.96937525392966507163128537
             - 120000.98999591628369059006621989*z)*z)
             + x*(-54694.328773648918416799553991378
             + z*(323267.97305022345810526303553113
             + z*(-318369.97345855340570972874711399
             + 52245.32897781389221903240978281*z))
             + x*(50204.495814618037054226456275667
             + x*(-23755.298019599754118341298823121
             + 4571.4662855587155691653358559957*x
             + 141062.38824009750899138750641358*y
             + 47020.796080032502997129168804528*z)
             + z*(-198368.9834626371220191386808941
             + 97959.99183340104791068576834277*z)
             + y*(-595106.9503879113660574160426823
             + 979599.9183340104791068576834277*y
             + 1.3714398856676146707496007567987e6*z))
             + y*(969803.91915067037431578910659338
             + z*(-4.4571796284197476799362024595958e6
             + 2.6645117778685085031706528989232e6*z)
             + y*(-3.1836997345855340570972874711399e6
             + 2.5600211199128807187325880793576e6*y
             + 8.307007307472408862826153155467e6*z)))
             + y*(-749393.93752551801651674612782216
             + z*(5.1428995712535550153110028379952e6
             + z*(-6.1200504897917304682200933772143e6
             + 1.2930718922008938324210521421245e6*z))
             + y*(3.6734996937525392966507163128537e6
             + z*(-1.9080157409350689106803820528962e7
             + 1.3577254868109385240421047492307e7*z)
             + y*(-5.8800485097998979008389132447745e6
             + 2.9094117574520111229473673197801e6*y
             + 1.6809934598611619821473677847619e7*z))))
             + y*(264491.97795018282935885157452547
             + z*(-2.4000197999183256738118013243978e6
             + (4.2465656459779354269282280576589e6
             - 1.7779738517762290195789466954212e6*z)*z)
             + y*(-1.7142998570845183384370009459984e6
             + z*(1.3239292896284151625129181591525e7
             + z*(-1.8668725443650404705578940301923e7
             + 5.172287568803575329684208568498e6*z))
             + y*(4.0800336598611536454800622514762e6
             + y*(-4.0004411664965152940526300646977e6
             + 1.3792766850142867545824556182661e6*y
             + 1.2068670993875009102596486659829e7*z)
             + z*(-2.3113660073090977254526307040476e7
             + 1.8965054418946442875508764751159e7*z)))));
            grad[1]= 1469.3998775010157186602865251415
             + z*(-17142.998570845183384370009459984
             + (41632.996529195445362041451545675
             - 26938.997754185288175438586294261*z)*z)
             + y*(-24489.997958350261977671442085691
             + z*(259593.97835851277696331728610833
             + z*(-565718.95283789105168421031217947
             + 323267.97305022345810526303553113*z))
             + y*(120000.98999591628369059006621989
             + y*(-242450.97978766759357894727664835
             + y*(215511.98203348230540350869035408
             - 70041.39416088174925614032436508*y
             - 700413.9416088174925614032436508*z)
             + (1.5085838742343761378245608324786e6
             - 1.4008278832176349851228064873016e6*z)*z)
             + z*(-1.0506209124132262388421048654762e6
             + (1.7779738517762290195789466954212e6
             - 700413.9416088174925614032436508*z)*z)))
             + x*(-30857.397427521330091866017027971
             + z*(342859.97141690366768740018919968
             + z*(-791026.93405471346187878757936783
             + 484901.95957533518715789455329669*z))
             + y*(489799.95916700523955342884171383
             + z*(-4.9322855888117427623030284360583e6
             + (1.0182941151082038930315785619231e7
             - 5.495555541853798787789471604029e6*z)*z)
             + y*(-2.2800188099224093901212112581779e6
             + z*(1.8911176423438072299157887578571e7
             + z*(-3.022555548019589333284209382216e7
             + 1.1206623065741079880982451898412e7*z))
             + y*(4.3641176361780166844210509796702e6
             + y*(-3.6637036945691991918596477360194e6
             + 1.1206623065741079880982451898412e6*y
             + 1.1206623065741079880982451898412e7*z)
             + z*(-2.5645925861984394343017534152136e7
             + 2.2413246131482159761964903796825e7*z))))
             + x*(132245.98897509141467942578726273
             + z*(-1.2000098999591628369059006621989e6
             + (2.1232828229889677134641140288294e6
             - 888986.9258881145097894733477106*z)*z)
             + x*(-249797.97917517267217224870927405
             + z*(1.7142998570845183384370009459984e6
             + z*(-2.0400168299305768227400311257381e6
             + 431023.96406696461080701738070817*z))
             + x*(242450.97978766759357894727664835
             + x*(-119021.39007758227321148320853646
             + 23510.398040016251498564584402264*x
             + 391839.96733360419164274307337106*y
             + 274287.97713352293414992015135974*z)
             + z*(-1.114294907104936919984050614899e6
             + 666127.9444671271257926632247308*z)
             + y*(-1.5918498672927670285486437355699e6
             + 1.9200158399346605390494410595182e6*y
             + 4.1535036537362044314130765777333e6*z))
             + y*(2.4489997958350261977671442085691e6
             + z*(-1.2720104939567126071202547019308e7
             + 9.051503245406256826947364994872e6*z)
             + y*(-5.8800485097998979008389132447745e6
             + 3.8792156766026814972631564263735e6*y
             + 1.6809934598611619821473677847619e7*z)))
             + y*(-1.7142998570845183384370009459984e6
             + z*(1.3239292896284151625129181591525e7
             + z*(-1.8668725443650404705578940301923e7
             + 5.172287568803575329684208568498e6*z))
             + y*(6.1200504897917304682200933772143e6
             + y*(-8.0008823329930305881052601293954e6
             + 3.4481917125357168864561390456654e6*y
             + 2.4137341987750018205192973319657e7*z)
             + z*(-3.4670490109636465881789460560713e7
             + 2.8447581628419664313263147126739e7*z)))));
            grad[2]= 489.79995916700523955342884171383
             + z*(-2448.9997958350261977671442085691
             + 2448.9997958350261977671442085691*z)
             + y*(-17142.998570845183384370009459984
             + (83265.993058390890724082903091351
             - 80816.99326255586452631575888278*z)*z
             + y*(129796.98917925638848165864305416
             + z*(-565718.95283789105168421031217947
             + 484901.95957533518715789455329669*z)
             + y*(-350206.97080440874628070162182539
             + y*(377145.96855859403445614020811965
             - 140082.78832176349851228064873016*y
             - 700413.9416088174925614032436508*z)
             + (1.1853159011841526797192977969475e6
             - 700413.9416088174925614032436508*z)*z)))
             + x*(-10285.79914250711003062200567599
             + (48979.995916700523955342884171383
             - 46530.996120865497757575739962814*z)*z
             + y*(342859.97141690366768740018919968
             + z*(-1.5820538681094269237575751587357e6
             + 1.4547058787260055614736836598901e6*z)
             + y*(-2.4661427944058713811515142180291e6
             + (1.0182941151082038930315785619231e7
             - 8.243333312780698181684207406044e6*z)*z
             + y*(6.303725474479357433052629192857e6
             + z*(-2.0150370320130595555228062548107e7
             + 1.1206623065741079880982451898412e7*z)
             + y*(-6.411481465496098585754383538034e6
             + 2.2413246131482159761964903796825e6*y
             + 1.1206623065741079880982451898412e7*z))))
             + x*(44081.996325030471559808595754245
             + z*(-171429.98570845183384370009459984
             + 124898.98958758633608612435463703*z)
             + x*(-83265.993058390890724082903091351
             + (244899.97958350261977671442085691
             - 120000.98999591628369059006621989*z)*z
             + x*(80816.993262555864526315758882782
             + z*(-159184.98672927670285486437355699
             + 39183.996733360419164274307337106*z)
             + x*(-39673.79669252742440382773617882
             + 7836.799346672083832854861467421*x
             + 274287.97713352293414992015135974*y
             + 39183.996733360419164274307337106*z)
             + y*(-1.114294907104936919984050614899e6
             + 2.0767518268681022157065382888666e6*y
             + 1.3322558889342542515853264494616e6*z))
             + y*(1.7142998570845183384370009459984e6
             + z*(-4.0800336598611536454800622514762e6
             + 1.2930718922008938324210521421245e6*z)
             + y*(-6.3600524697835630356012735096541e6
             + 5.603311532870539940491225949206e6*y
             + 9.051503245406256826947364994872e6*z)))
             + y*(-1.2000098999591628369059006621989e6
             + (4.2465656459779354269282280576589e6
             - 2.6669607776643435293684200431318e6*z)*z
             + y*(6.6196464481420758125645907957624e6
             + z*(-1.8668725443650404705578940301923e7
             + 7.758431353205362994526312852747e6*z)
             + y*(-1.1556830036545488627263153520238e7
             + 6.034335496937504551298243329914e6*y
             + 1.8965054418946442875508764751159e7*z)))));
            return;
          case ( 109 ):
            grad[0]= 1018.1984089557398242791995154479
             + z*(-19438.333261882305736239263476732
             + z*(83307.142550924167441025414900279
             + z*(-123109.44399192126966284866868597
             + 58314.9997856469172087177904302*z)))
             + y*(-27213.666566635228030734968867425
             + z*(499842.85530554500464615248940168
             + z*(-2.0576864210078269357933277480369e6
             + (2.9157499892823458604358895215098e6
             - 1.3218066618079967900642699164178e6*z)*z))
             + y*(166614.28510184833488205082980056
             + z*(-2.690820704394850608345120901279e6
             + z*(9.5220063935706323385092049231019e6
             + z*(-1.1235356625367972715546294289551e7
             + 4.0431733184715195931377668031602e6*z)))
             + y*(-404502.45883059845746364562568247
             + y*(470685.35541272154604179359418658
             + y*(-264361.33236159935801285398328355
             + 57759.61883530742275911095433086*y
             + 1.1551923767061484551822190866172e6*z)
             + z*(-4.0598347469817044266259718861403e6
             + 5.198365695177668048319985889777e6*z))
             + z*(5.1150585526267438808789604748772e6
             + z*(-1.2745992810291397618476888479743e7
             + 8.08634663694303918627553360632e6*z)))))
             + x*(-10274.547581280647317726467837701
             + z*(166614.28510184833488205082980056
             + z*(-583149.99785646917208717790430196
             + (660903.33090399839503213495820888
             - 213821.66588070536309863189824405*z)*z))
             + y*(233259.99914258766883487116172078
             + z*(-3.4988999871388150325230674258117e6
             + z*(1.1046527102252544602679970015777e7
             + z*(-1.0691083294035268154931594912203e7
             + 2.4881066575209351342386257250217e6*z)))
             + y*(-1.1662999957129383441743558086039e6
             + z*(1.4445458518330250634273806943708e7
             + z*(-3.4914023443092318574533751384707e7
             + 2.1148906588927948641028318662684e7*z))
             + y*(2.1715395158274232979627291484006e6
             + y*(-1.7258463031799790021532431786841e6
             + 497621.33150418702684772514500434*y
             + 7.642041876671443626590064726852e6*z)
             + z*(-1.875521469296472756322285507455e7
             + 2.399245705466616022301531949128e7*z))))
             + x*(36099.761772067139224444346456788
             + z*(-472073.80778857028216581068443492
             + z*(1.2496071382638625116153812235042e6
             + z*(-952478.32983223298107572391035986
             + 155506.66609505844588991410781385*z)))
             + x*(-62017.539454576880206096697759097
             + z*(610919.04537344389456751970926872
             + z*(-1.0829928531620141767333303937036e6
             + 414684.44292015585570643762083695*z))
             + x*(56926.547409798181084700700181858
             + x*(-26935.976091465480805931550817757
             + 5183.555536501948196330470260462*x
             + 124405.33287604675671193128625108*y
             + 88860.95205431911193709377589363*z)
             + z*(-374882.14147915875348461436705126
             + 333228.57020369666976410165960112*z)
             + y*(-524834.99807082225487846011387176
             + 666457.1404073933395282033192022*y
             + 1.9993714212221800185846099576067e6*z))
             + y*(855286.6635228214523945275929762
             + z*(-6.4979571189720850603999823622218e6
             + 6.931154260236890731093314519703e6*z)
             + y*(-2.1659857063240283534666607874073e6
             + 1.3625345981662263830354378970357e6*y
             + 9.06381710954054941758356514115e6*z)))
             + y*(-660903.33090399839503213495820888
             + z*(7.4976428295831750696922873410252e6
             + z*(-1.5919994941481608397979956787443e7
             + 7.775333304752922294495705390693e6*z))
             + y*(2.4992142765277250232307624470084e6
             + y*(-3.1295716551630512235345214197538e6
             + 1.2551609477672574561114495844975e6*y
             + 1.3640156140337983682343894599672e7*z)
             + z*(-2.081845492347594944351225118358e7
             + 2.5392017049521686236024546461605e7*z)))));
            grad[1]= 1295.8888841254870490826175651155
             + z*(-24992.142765277250232307624470084
             + z*(108299.28531620141767333303937036
             + z*(-161986.11051568588113532719563943
             + 77753.33304752922294495705390693*z)))
             + y*(-16661.428510184833488205082980056
             + y*(63868.809289041861704786151423548
             + z*(-852509.75877112398014649341247953
             + (2.2492928488749525209076862023075e6
             - 1.5161899944268198474266625511851e6*z)*z)
             + y*(-104596.74564727145467595413204146
             + y*(77753.333047529222944957053906927
             - 21659.857063240283534666607874073*y
             - 360997.61772067139224444346456788*z)
             + (955255.23458393045332375809085654
             - 1.2995914237944170120799964724444e6*z)*z))
             + z*(283244.28467314216929948641066095
             + z*(-1.0580007103967369265010227692335e6
             + (1.3218066618079967900642699164178e6
             - 505396.664808939949142220850395*z)*z)))
             + x*(-27213.666566635228030734968867425
             + z*(499842.85530554500464615248940168
             + z*(-2.0576864210078269357933277480369e6
             + (2.9157499892823458604358895215098e6
             - 1.3218066618079967900642699164178e6*z)*z))
             + y*(333228.57020369666976410165960112
             + z*(-5.3816414087897012166902418025581e6
             + z*(1.9044012787141264677018409846204e7
             + z*(-2.2470713250735945431092588579102e7
             + 8.08634663694303918627553360632e6*z)))
             + y*(-1.2135073764917953723909368770474e6
             + y*(1.8827414216508861841671743767463e6
             + y*(-1.3218066618079967900642699164178e6
             + 346557.71301184453655466572598516*y
             + 5.775961883530742275911095433086e6*z)
             + z*(-1.6239338987926817706503887544561e7
             + 2.079346278071067219327994355911e7*z))
             + z*(1.5345175657880231642636881424631e7
             + z*(-3.8237978430874192855430665439228e7
             + 2.4259039910829117558826600818961e7*z))))
             + x*(116629.99957129383441743558086039
             + z*(-1.7494499935694075162615337129059e6
             + z*(5.5232635511262723013399850078885e6
             + z*(-5.3455416470176340774657974561013e6
             + 1.2440533287604675671193128625108e6*z)))
             + x*(-220301.11030133279834404498606963
             + z*(2.4992142765277250232307624470084e6
             + z*(-5.3066649804938694659933189291478e6
             + 2.5917777682509740981652351302309e6*z))
             + x*(213821.66588070536309863189824405
             + x*(-104966.99961416445097569202277435
             + 20734.222146007792785321881041847*x
             + 266582.85616295733581128132768089*y
             + 399874.28424443600371692199152134*z)
             + z*(-1.6244892797430212650999955905554e6
             + 1.7327885650592226827733286299258e6*z)
             + y*(-1.0829928531620141767333303937036e6
             + 1.0219009486246697872765784227768e6*y
             + 4.5319085547702747087917825705752e6*z))
             + y*(1.6661428510184833488205082980056e6
             + y*(-3.1295716551630512235345214197538e6
             + 1.6735479303563432748152661126634e6*y
             + 1.3640156140337983682343894599672e7*z)
             + z*(-1.3878969948983966295674834122387e7
             + 1.6928011366347790824016364307737e7*z)))
             + y*(-1.1662999957129383441743558086039e6
             + z*(1.4445458518330250634273806943708e7
             + z*(-3.4914023443092318574533751384707e7
             + 2.1148906588927948641028318662684e7*z))
             + y*(3.2573092737411349469440937226009e6
             + y*(-3.4516926063599580043064863573682e6
             + 1.2440533287604675671193128625108e6*y
             + 1.5284083753342887253180129453705e7*z)
             + z*(-2.8132822039447091344834282611824e7
             + 3.5988685581999240334522979236921e7*z)))));
            grad[2]= 925.63491723249074934472683222533
             + z*(-8330.7142550924167441025414900279
             + (19438.333261882305736239263476732
             - 12958.888841254870490826175651155*z)*z)
             + y*(-24992.142765277250232307624470084
             + z*(216598.57063240283534666607874073
             + z*(-485958.3315470576434059815869183
             + 311013.33219011689177982821562771*z))
             + y*(141622.14233657108464974320533048
             + y*(-284169.91959037466004883113749318
             + y*(238813.80864598261333093952271413
             - 72199.52354413427844888869291358*y
             - 649795.7118972085060399982362222*z)
             + (1.499528565916635013938457468205e6
             - 1.5161899944268198474266625511851e6*z)*z)
             + z*(-1.0580007103967369265010227692335e6
             + (1.9827099927119951850964048746267e6
             - 1.0107933296178798982844417007901e6*z)*z)))
             + x*(-19438.333261882305736239263476732
             + z*(166614.28510184833488205082980056
             + z*(-369328.33197576380898854600605791
             + 233259.99914258766883487116172078*z))
             + y*(499842.85530554500464615248940168
             + z*(-4.1153728420156538715866554960738e6
             + (8.7472499678470375813076685645293e6
             - 5.287226647231987160257079665671e6*z)*z)
             + y*(-2.690820704394850608345120901279e6
             + z*(1.9044012787141264677018409846204e7
             + z*(-3.3706069876103918146638882868653e7
             + 1.6172693273886078372551067212641e7*z))
             + y*(5.1150585526267438808789604748772e6
             + y*(-4.0598347469817044266259718861403e6
             + 1.1551923767061484551822190866172e6*y
             + 1.0396731390355336096639971779555e7*z)
             + z*(-2.5491985620582795236953776959486e7
             + 2.4259039910829117558826600818961e7*z))))
             + x*(83307.142550924167441025414900279
             + z*(-583149.99785646917208717790430196
             + (991354.99635599759254820243731333
             - 427643.3317614107261972637964881*z)*z)
             + x*(-157357.93592952342738860356147831
             + z*(833071.42550924167441025414900279
             + z*(-952478.32983223298107572391035986
             + 207342.22146007792785321881041847*z))
             + x*(152729.76134336097364187992731718
             + x*(-74976.428295831750696922873410252
             + 14810.158675719851989515629315605*x
             + 399874.28424443600371692199152134*y
             + 133291.42808147866790564066384045*z)
             + z*(-541496.42658100708836666519685182
             + 311013.33219011689177982821562771*z)
             + y*(-1.6244892797430212650999955905554e6
             + 2.2659542773851373543958912852876e6*y
             + 3.4655771301184453655466572598516e6*z))
             + y*(2.4992142765277250232307624470084e6
             + z*(-1.0613329960987738931986637858296e7
             + 7.775333304752922294495705390693e6*z)
             + y*(-6.9394849744919831478374170611933e6
             + 4.5467187134459945607812981998908e6*y
             + 1.6928011366347790824016364307737e7*z)))
             + y*(-1.7494499935694075162615337129059e6
             + z*(1.1046527102252544602679970015777e7
             + z*(-1.6036624941052902232397392368304e7
             + 4.9762133150418702684772514500434e6*z))
             + y*(7.2227292591651253171369034718542e6
             + y*(-9.3776073464823637816114275372748e6
             + 3.8210209383357218132950323634262e6*y
             + 2.399245705466616022301531949128e7*z)
             + z*(-3.4914023443092318574533751384707e7
             + 3.1723359883391922961542477994026e7*z)))));
            return;
          case ( 110 ):
            grad[0]= 1125.6606948810107583021905017125
             + z*(-32234.828989774398987744546185403
             + z*(214898.85993182932658496364123602
             + z*(-544410.44516063429401524122446459
             + (580226.92181593918177940183133726
             - 219196.83713046591311666291406074*z)*z)))
             + y*(-19340.897393864639392646727711242
             + z*(521897.23126301407884919741443034
             + z*(-3.2664626709638057640914473467875e6
             + z*(7.7363589575458557570586910844968e6
             + z*(-7.671889299566306959083201992126e6
             + 2.6819377719492299957803462426256e6*z))))
             + y*(76749.592832796188066058443298579
             + y*(-136102.61129015857350381030611615
             + y*(124334.3403891298246670146781437
             + y*(-57408.695438931548673411715587337
             + 10642.610206147738078493437470736*y
             + 319278.30618443214235480312412209*z)
             + z*(-1.3830276628469873089503731482404e6
             + 2.2349481432910249964836218688546e6*z))
             + z*(2.2656479804241434717100452461741e6
             + z*(-7.3065612376821971038887638020248e6
             + 5.959861715442733323956324983612e6*z)))
             + z*(-1.6915610260348279849759280903007e6
             + z*(8.1231769054231485449116256387217e6
             + z*(-1.3151810227827954786999774843645e7
             + 6.704844429873074989450865606564e6*z)))))
             + x*(-11358.93973925383583377664960819
             + z*(276298.53419806627703781039587489
             + z*(-1.5042920195228052860947454886522e6
             + z*(2.9226244950728788415555055208099e6
             + z*(-2.1274987133251103331911400482366e6
             + 412605.81106911230704313019117316*z))))
             + x*(39909.788273054017794350390515261
             + z*(-782845.84689452111827379612164551
             + z*(3.2234828989774398987744546185403e6
             + z*(-4.212017654663854801065287368226e6
             + 1.5472717915091711514117382168994e6*z)))
             + x*(-68562.969597297928005678876013398
             + z*(1.0130946253929096824719714515412e6
             + z*(-2.7936851791137812456045273360683e6
             + 1.8338036047516102535250230718807e6*z))
             + x*(62934.666122892874214167923504835
             + x*(-29778.842019124920969630675999849
             + 5730.636264848782042265697099627*x
             + 88415.53094338120865209932667996*y
             + 147359.21823896868108683221113327*z)
             + z*(-621671.70194564912333507339071849
             + 859595.4397273173063398545649441*z)
             + y*(-373003.0211673894740010440344311
             + 306998.37133118475226423377319432*y
             + 2.0875889250520563153967896577214e6*z))
             + y*(607856.77523574580948318287092475
             + y*(-997744.70682635044485875976288153
             + 458450.90118790256338125576797018*y
             + 5.697889771906789002024178830487e6*z)
             + z*(-6.7846640064191830250395663875944e6
             + 1.1002821628509661521150138431284e7*z)))
             + y*(-469707.50813671267096427767298731
             + z*(7.8284584689452111827379612164551e6
             + z*(-2.5272105927983128806391724209356e7
             + 2.0630290553455615352156509558658e7*z))
             + y*(1.1512438924919428209908766494787e6
             + y*(-1.0530044136659637002663218420565e6
             + 331558.24103767953244537247504986*y
             + 6.041727947797715924560120656464e6*z)
             + z*(-1.3087340569848405989024285751274e7
             + 2.1661805081128396119764335036591e7*z))))
             + y*(165779.12051883976622268623752493
             + z*(-3.6532806188410985519443819010124e6
             + z*(1.7535746970437273049333033124859e7
             + z*(-2.8366649511001471109215200643155e7
             + 1.4441203387418930746509556691061e7*z)))
             + y*(-537247.14982957331646240910309006
             + y*(730656.12376821971038887638020248
             + y*(-455892.58142680935711238715319356
             + 108063.4267085770327970102881644*y
             + 2.6033461888884466992007023966878e6*z)
             + z*(-8.3073759282218593962701659026382e6
             + 1.3753527035637076901437673039105e7*z))
             + z*(9.0810118239764449719760350110879e6
             + z*(-2.9784981986551544664675960675313e7
             + 2.475634866414673842258781147039e7*z)))));
            grad[1]= 920.99511399355425679270131958295
             + y*(-7674.9592832796188066058443298579
             + z*(178059.0553720871563132555884527
             + z*(-902575.21171368317165684729319129
             + (1.5472717915091711514117382168994e6
             - 838105.5537341343736813582008205*z)*z))
             + y*(21489.885993182932658496364123602
             + z*(-377607.99673735724528500754102901
             + (1.2893931595909759595097818474161e6
             - 1.1174740716455124982418109344273e6*z)*z)
             + y*(-27629.853419806627703781039587489
             + y*(16884.910423215161374532857525687
             - 3990.9788273054017794350390515261*y
             - 99774.47068263504448587597628815*z)
             + (325418.27361105583740008779958598
             - 558737.0358227562491209054672137*z)*z)))
             + z*(-26094.861563150703942459870721517
             + z*(171919.08794546346126797091298882
             + z*(-429797.71986365865316992728247205
             + (451287.60585684158582842364659565
             - 167621.1107468268747362716401641*z)*z)))
             + x*(-19340.897393864639392646727711242
             + z*(521897.23126301407884919741443034
             + z*(-3.2664626709638057640914473467875e6
             + z*(7.7363589575458557570586910844968e6
             + z*(-7.671889299566306959083201992126e6
             + 2.6819377719492299957803462426256e6*z))))
             + y*(153499.18566559237613211688659716
             + z*(-3.3831220520696559699518561806014e6
             + z*(1.6246353810846297089823251277443e7
             + z*(-2.6303620455655909573999549687289e7
             + 1.3409688859746149978901731213128e7*z)))
             + y*(-408307.83387047572051143091834844
             + y*(497337.36155651929866805871257479
             + y*(-287043.47719465774336705857793669
             + 63855.66123688642847096062482442*y
             + 1.5963915309221607117740156206105e6*z)
             + z*(-5.5321106513879492358014925929616e6
             + 8.939792573164099985934487475419e6*z))
             + z*(6.7969439412724304151301357385222e6
             + z*(-2.1919683713046591311666291406074e7
             + 1.7879585146328199971868974950837e7*z))))
             + x*(82889.560259419883111343118762466
             + z*(-1.8266403094205492759721909505062e6
             + z*(8.7678734852186365246665165624297e6
             + z*(-1.4183324755500735554607600321577e7
             + 7.22060169370946537325477834553e6*z)))
             + x*(-156569.1693789042236547592243291
             + x*(151964.19380893645237079571773119
             + x*(-74600.604233477894800208806886219
             + 14735.921823896868108683221113327*x
             + 122799.34853247390090569350927773*y
             + 417517.78501041126307935793154427*z)
             + z*(-1.6961660016047957562598915968986e6
             + 2.7507054071274153802875346078211e6*z)
             + y*(-498872.35341317522242937988144077
             + 343838.17589092692253594182597764*y
             + 2.8489448859533945010120894152433e6*z))
             + z*(2.6094861563150703942459870721517e6
             + z*(-8.4240353093277096021305747364521e6
             + 6.876763517818538450718836519553e6*z))
             + y*(767495.92832796188066058443298579
             + y*(-1.0530044136659637002663218420565e6
             + 442077.65471690604326049663339982*y
             + 6.041727947797715924560120656464e6*z)
             + z*(-8.7248937132322706593495238341825e6
             + 1.4441203387418930746509556691061e7*z)))
             + y*(-537247.14982957331646240910309006
             + y*(1.0959841856523295655833145703037e6
             + y*(-911785.16285361871422477430638712
             + 270158.566771442581992525720411*y
             + 5.206692377776893398401404793376e6*z)
             + z*(-1.2461063892332789094405248853957e7
             + 2.0630290553455615352156509558658e7*z))
             + z*(9.0810118239764449719760350110879e6
             + z*(-2.9784981986551544664675960675313e7
             + 2.475634866414673842258781147039e7*z)))));
            grad[2]= 1534.9918566559237613211688659716
             + z*(-21489.885993182932658496364123602
             + z*(85959.543972731730633985456494409
             + z*(-128939.31595909759595097818474161
             + 64469.65797954879797548909237081*z)))
             + y*(-26094.861563150703942459870721517
             + y*(89029.527686043578156627794226352
             + z*(-902575.21171368317165684729319129
             + (2.320907687263756727117607325349e6
             - 1.676211107468268747362716401641e6*z)*z)
             + y*(-125869.33224578574842833584700967
             + y*(81354.568402763959350021949896494
             - 19954.894136527008897175195257631*y
             - 279368.51791137812456045273360683*z)
             + (859595.43972731730633985456494409
             - 1.1174740716455124982418109344273e6*z)*z))
             + z*(343838.17589092692253594182597764
             + z*(-1.2893931595909759595097818474161e6
             + (1.8051504234273663433136945863826e6
             - 838105.5537341343736813582008205*z)*z)))
             + x*(-32234.828989774398987744546185403
             + z*(429797.71986365865316992728247205
             + z*(-1.6332313354819028820457236733938e6
             + (2.320907687263756727117607325349e6
             - 1.0959841856523295655833145703037e6*z)*z))
             + y*(521897.23126301407884919741443034
             + z*(-6.5329253419276115281828946935751e6
             + z*(2.320907687263756727117607325349e7
             + z*(-3.0687557198265227836332807968504e7
             + 1.3409688859746149978901731213128e7*z)))
             + y*(-1.6915610260348279849759280903007e6
             + y*(2.2656479804241434717100452461741e6
             + y*(-1.3830276628469873089503731482404e6
             + 319278.30618443214235480312412209*y
             + 4.4698962865820499929672437377093e6*z)
             + z*(-1.461312247536439420777752760405e7
             + 1.7879585146328199971868974950837e7*z))
             + z*(1.6246353810846297089823251277443e7
             + z*(-3.9455430683483864360999324530934e7
             + 2.6819377719492299957803462426256e7*z))))
             + x*(138149.26709903313851890519793744
             + z*(-1.5042920195228052860947454886522e6
             + z*(4.3839367426093182623332582812149e6
             + z*(-4.2549974266502206663822800964732e6
             + 1.0315145276727807676078254779329e6*z)))
             + x*(-260948.61563150703942459870721517
             + z*(2.1489885993182932658496364123602e6
             + z*(-4.212017654663854801065287368226e6
             + 2.0630290553455615352156509558658e6*z))
             + x*(253273.65634822742061799286288531
             + x*(-124334.3403891298246670146781437
             + 24559.869706494780181138701855545*x
             + 417517.78501041126307935793154427*y
             + 343838.17589092692253594182597764*z)
             + z*(-1.3968425895568906228022636680341e6
             + 1.3753527035637076901437673039105e6*z)
             + y*(-1.6961660016047957562598915968986e6
             + 1.4244724429766972505060447076216e6*y
             + 5.501410814254830760575069215642e6*z))
             + y*(2.6094861563150703942459870721517e6
             + y*(-4.3624468566161353296747619170913e6
             + 2.0139093159325719748533735521547e6*y
             + 1.4441203387418930746509556691061e7*z)
             + z*(-1.6848070618655419204261149472904e7
             + 2.0630290553455615352156509558658e7*z)))
             + y*(-1.8266403094205492759721909505062e6
             + z*(1.7535746970437273049333033124859e7
             + z*(-4.2549974266502206663822800964732e7
             + 2.8882406774837861493019113382121e7*z))
             + y*(4.540505911988222485988017505544e6
             + y*(-4.1536879641109296981350829513191e6
             + 1.3016730944442233496003511983439e6*y
             + 1.3753527035637076901437673039105e7*z)
             + z*(-2.9784981986551544664675960675313e7
             + 3.7134522996220107633881717205585e7*z)))));
            return;
          case ( 111 ):
            grad[0]= 1223.7221906952574340082110877046
             + z*(-49060.135099691684399783735425248
             + z*(467239.38190182556571222605166903
             + z*(-1.7755096512269371497064589963423e6
             + z*(3.153865827837322568557525848766e6
             + z*(-2.6212129324692414236455881498633e6
             + 822341.3121472129956535178509375*z)))))
             + y*(-7008.5907285273834856833907750355
             + z*(233619.69095091278285611302583452
             + z*(-1.7755096512269371497064589963423e6
             + z*(5.0461853245397161096920413580255e6
             + z*(-5.9573021192482759628308821587801e6
             + 2.4670239364416389869605535528125e6*z))))
             + y*(16687.120782208055918293787559608
             + y*(-21137.01965746353749650546424217
             + y*(15018.408703987250326464408803647
             + y*(-5673.6210659507390122198877702668
             + 889.9797750510963156423353365124*y
             + 37379.150552146045256978084133522*z)
             + z*(-198576.73730827586542769607195934
             + 373791.50552146045256978084133522*z))
             + z*(420515.44371164300914100344650213
             + z*(-1.5886138984662069234215685756747e6
             + 1.4951660220858418102791233653409e6*z)))
             + z*(-443877.41280673428742661474908558
             + z*(2.5230926622698580548460206790128e6
             + z*(-4.7658416953986207702647057270241e6
             + 2.8034362914109533942733563100142e6*z)))))
             + x*(-12348.46937883396137953740279411
             + z*(420515.44371164300914100344650213
             + z*(-3.2706756733127789599855823616832e6
             + z*(9.5316833907972415405294114540482e6
             + z*(-1.1564174702070182751377594778808e7
             + 4.934047872883277973921107105625e6*z))))
             + y*(60073.63481594900130585763521459
             + y*(-116809.84547545639142805651291726
             + y*(113472.42131901478024439775540534
             + y*(-55067.498581286584530369498946707
             + 10679.757300613155787708024038149*y
             + 373791.50552146045256978084133522*z)
             + z*(-1.5418899602760243668503459705078e6
             + 2.9903320441716836205582467306818e6*z))
             + z*(2.3829208476993103851323528635121e6
             + z*(-9.2513397616561462011020758230468e6
             + 8.970996132515050861674740192045e6*z)))
             + z*(-1.6353378366563894799927911808416e6
             + z*(9.5316833907972415405294114540482e6
             + z*(-1.8502679523312292402204151646094e7
             + 1.1213745165643813577093425240057e7*z))))
             + x*(43386.514033740945387563847654981
             + x*(-74535.806160529316435045584432917
             + x*(68417.195207053029265004528994394
             + x*(-32373.01431748362848148994786564
             + 6229.858425357674209496347355587*x
             + 32039.271901839467363124072114448*y
             + 224274.90331287627154186850480113*z)
             + y*(-135165.67833588525293817967923283
             + 66748.48312883222367317515023843*y
             + 934478.7638036511314244521033381*z)
             + z*(-946159.74835119677056725775462979
             + 1.8689575276073022628489042066761e6*z))
             + z*(1.5418899602760243668503459705078e6
             + z*(-6.0741119647237323542589386716974e6
             + 5.980664088343367241116493461364e6*z))
             + y*(220269.99432514633812147799578683
             + y*(-216932.57016870472693781923827491
             + 71198.382004087705251386826921*y
             + 1.4951660220858418102791233653409e6*z)
             + z*(-3.0370559823618661771294693358487e6
             + 5.980664088343367241116493461364e6*z)))
             + z*(-1.191460423849655192566176431756e6
             + z*(7.0085907285273834856833907750355e6
             + z*(-1.3736837827913671631939445919069e7
             + 8.410308874232860182820068930043e6*z)))
             + y*(-170208.631978522170366596633108
             + y*(250306.81173312083877440681339412
             + y*(-163533.78366563894799927911808416
             + 40049.08987729933420390509014306*y
             + 1.1213745165643813577093425240057e6*z)
             + z*(-3.4342094569784179079848614797674e6
             + 6.728247099386288146256055144034e6*z))
             + z*(3.5042953642636917428416953875177e6
             + z*(-1.3736837827913671631939445919069e7
             + 1.3456494198772576292512110288068e7*z)))));
            grad[1]= 333.74241564416111836587575119216
             + z*(-11680.984547545639142805651291726
             + z*(93447.876380365113142445210333806
             + z*(-280343.62914109533942733563100142
             + (350429.53642636917428416953875177
             - 154188.99602760243668503459705078*z)*z)))
             + y*(-1668.7120782208055918293787559608
             + z*(46723.938190182556571222605166903
             + z*(-280343.62914109533942733563100142
             + (560687.25828219067885467126200284
             - 350429.53642636917428416953875177*z)*z))
             + y*(3337.4241564416111836587575119216
             + z*(-70085.907285273834856833907750355
             + (280343.62914109533942733563100142
             - 280343.62914109533942733563100142*z)*z)
             + y*(-3337.4241564416111836587575119216
             + y*(1668.7120782208055918293787559608
             - 333.74241564416111836587575119216*y
             - 11680.984547545639142805651291726*z)
             + (46723.938190182556571222605166903
             - 93447.87638036511314244521033381*z)*z)))
             + x*(-7008.5907285273834856833907750355
             + z*(233619.69095091278285611302583452
             + z*(-1.7755096512269371497064589963423e6
             + z*(5.0461853245397161096920413580255e6
             + z*(-5.9573021192482759628308821587801e6
             + 2.4670239364416389869605535528125e6*z))))
             + y*(33374.241564416111836587575119216
             + y*(-63411.058972390612489516392726511
             + y*(60073.63481594900130585763521459
             + y*(-28368.105329753695061099438851334
             + 5339.878650306577893854012019075*y
             + 186895.75276073022628489042066761*z)
             + z*(-794306.94923310346171078428783735
             + 1.4951660220858418102791233653409e6*z))
             + z*(1.2615463311349290274230103395064e6
             + z*(-4.7658416953986207702647057270241e6
             + 4.4854980662575254308373700960227e6*z)))
             + z*(-887754.82561346857485322949817116
             + z*(5.0461853245397161096920413580255e6
             + z*(-9.5316833907972415405294114540482e6
             + 5.606872582821906788546712620028e6*z))))
             + x*(30036.817407974500652928817607295
             + x*(-56736.210659507390122198877702668
             + x*(55067.498581286584530369498946707
             + x*(-27033.135667177050587635935846565
             + 5339.878650306577893854012019075*x
             + 26699.393251532889469270060095373*y
             + 186895.75276073022628489042066761*z)
             + y*(-108466.28508435236346890961913745
             + 53398.78650306577893854012019075*y
             + 747583.0110429209051395616826704*z)
             + z*(-759263.99559046654428236733396217
             + 1.4951660220858418102791233653409e6*z))
             + z*(1.1680984547545639142805651291726e6
             + z*(-4.5789459426378905439798153063565e6
             + 4.4854980662575254308373700960227e6*z))
             + y*(166871.20782208055918293787559608
             + y*(-163533.78366563894799927911808416
             + 53398.78650306577893854012019075*y
             + 1.1213745165643813577093425240057e6*z)
             + z*(-2.2894729713189452719899076531782e6
             + 4.4854980662575254308373700960227e6*z)))
             + z*(-817668.9183281947399963955904208
             + z*(4.7658416953986207702647057270241e6
             + z*(-9.2513397616561462011020758230468e6
             + 5.606872582821906788546712620028e6*z)))
             + y*(-116809.84547545639142805651291726
             + y*(170208.631978522170366596633108
             + y*(-110134.99716257316906073899789341
             + 26699.393251532889469270060095373*y
             + 747583.0110429209051395616826704*z)
             + z*(-2.3128349404140365502755189557617e6
             + 4.4854980662575254308373700960227e6*z))
             + z*(2.3829208476993103851323528635121e6
             + z*(-9.2513397616561462011020758230468e6
             + 8.970996132515050861674740192045e6*z)))));
            grad[2]= 2336.1969095091278285611302583452
             + z*(-46723.938190182556571222605166903
             + z*(280343.62914109533942733563100142
             + z*(-700859.07285273834856833907750355
             + (770944.9801380121834251729852539
             - 308377.99205520487337006919410156*z)*z)))
             + y*(-11680.984547545639142805651291726
             + z*(186895.75276073022628489042066761
             + z*(-841030.88742328601828200689300425
             + (1.4017181457054766971366781550071e6
             - 770944.9801380121834251729852539*z)*z))
             + y*(23361.969095091278285611302583452
             + z*(-280343.62914109533942733563100142
             + (841030.88742328601828200689300425
             - 700859.0728527383485683390775035*z)*z)
             + y*(-23361.969095091278285611302583452
             + y*(11680.984547545639142805651291726
             - 2336.1969095091278285611302583452*y
             - 46723.938190182556571222605166903*z)
             + (186895.75276073022628489042066761
             - 280343.62914109533942733563100142*z)*z)))
             + x*(-49060.135099691684399783735425248
             + z*(934478.76380365113142445210333806
             + z*(-5.3265289536808114491193769890269e6
             + z*(1.2615463311349290274230103395064e7
             + z*(-1.3106064662346207118227940749316e7
             + 4.934047872883277973921107105625e6*z))))
             + y*(233619.69095091278285611302583452
             + y*(-443877.41280673428742661474908558
             + y*(420515.44371164300914100344650213
             + y*(-198576.73730827586542769607195934
             + 37379.150552146045256978084133522*y
             + 747583.0110429209051395616826704*z)
             + z*(-3.1772277969324138468431371513494e6
             + 4.4854980662575254308373700960227e6*z))
             + z*(5.0461853245397161096920413580255e6
             + z*(-1.4297525086195862310794117181072e7
             + 1.1213745165643813577093425240057e7*z)))
             + z*(-3.5510193024538742994129179926846e6
             + z*(1.5138555973619148329076124074077e7
             + z*(-2.3829208476993103851323528635121e7
             + 1.2335119682208194934802767764062e7*z))))
             + x*(210257.72185582150457050172325106
             + z*(-3.2706756733127789599855823616832e6
             + z*(1.4297525086195862310794117181072e7
             + z*(-2.3128349404140365502755189557617e7
             + 1.2335119682208194934802767764062e7*z)))
             + x*(-397153.47461655173085539214391868
             + x*(385472.49006900609171258649262695
             + x*(-189231.94967023935411345155092596
             + 37379.150552146045256978084133522*x
             + 186895.75276073022628489042066761*y
             + 747583.0110429209051395616826704*z)
             + y*(-759263.99559046654428236733396217
             + 373791.50552146045256978084133522*y
             + 2.9903320441716836205582467306818e6*z)
             + z*(-3.0370559823618661771294693358487e6
             + 4.4854980662575254308373700960227e6*z))
             + z*(4.6723938190182556571222605166903e6
             + z*(-1.3736837827913671631939445919069e7
             + 1.1213745165643813577093425240057e7*z))
             + y*(1.1680984547545639142805651291726e6
             + y*(-1.1447364856594726359949538265891e6
             + 373791.50552146045256978084133522*y
             + 4.4854980662575254308373700960227e6*z)
             + z*(-9.157891885275781087959630612713e6
             + 1.3456494198772576292512110288068e7*z)))
             + y*(-817668.9183281947399963955904208
             + y*(1.191460423849655192566176431756e6
             + y*(-770944.9801380121834251729852539
             + 186895.75276073022628489042066761*y
             + 2.9903320441716836205582467306818e6*z)
             + z*(-9.2513397616561462011020758230468e6
             + 1.3456494198772576292512110288068e7*z))
             + z*(9.5316833907972415405294114540482e6
             + z*(-2.775401928496843860330622746914e7
             + 2.2427490331287627154186850480113e7*z)))));
            return;
          case ( 112 ):
            grad[0]= 115.44695751729449539499947596727
             + y*(-6234.1357059339027513299717022328
             + y*(77926.69632417378439162464627791
             + y*(-380974.959807071834803498270692
             + y*(857193.65956591162830787110905701
             + y*(-891481.40594854809344018595341929
             + 346687.21342443536967118342632972*y)))))
             + x*(-692.68174510376697236999685580364
             + x*(1731.7043627594174309249921395091
             + x*(-2308.9391503458899078999895193455
             + x*(1731.7043627594174309249921395091
             + x*(-692.68174510376697236999685580364
             + 115.44695751729449539499947596727*x
             + 6234.135705933902751329971702233*y)
             + y*(-31170.678529669513756649858511164
             + 77926.69632417378439162464627791*y))
             + y*(62341.357059339027513299717022328
             + y*(-311706.78529669513756649858511164
             + 380974.959807071834803498270692*y)))
             + y*(-62341.357059339027513299717022328
             + y*(467560.17794504270634974787766746
             + y*(-1.142924879421215504410494812076e6
             + 857193.659565911628307871109057*y))))
             + y*(31170.678529669513756649858511164
             + y*(-311706.78529669513756649858511164
             + y*(1.142924879421215504410494812076e6
             + y*(-1.714387319131823256615742218114e6
             + 891481.4059485480934401859534193*y)))));
            grad[1]= 1039.0226176556504585549952837055
             + y*(-31170.678529669513756649858511164
             + y*(285731.219855303876102623703019
             + y*(-1.142924879421215504410494812076e6
             + y*(2.2287035148713702336004648835482e6
             + y*(-2.0801232805466122180271005579783e6
             + 742901.1716237900778668216278494*y)))))
             + x*(-6234.1357059339027513299717022328
             + y*(155853.39264834756878324929255582
             + y*(-1.142924879421215504410494812076e6
             + y*(3.428774638263646513231484436228e6
             + y*(-4.4574070297427404672009297670965e6
             + 2.0801232805466122180271005579783e6*y))))
             + x*(15585.339264834756878324929255582
             + x*(-20780.452353113009171099905674109
             + x*(15585.339264834756878324929255582
             + x*(-6234.1357059339027513299717022328
             + 1039.0226176556504585549952837055*x
             + 31170.678529669513756649858511164*y)
             + y*(-155853.39264834756878324929255582
             + 285731.219855303876102623703019*y))
             + y*(311706.78529669513756649858511164
             + y*(-1.142924879421215504410494812076e6
             + 1.142924879421215504410494812076e6*y)))
             + y*(-311706.78529669513756649858511164
             + y*(1.714387319131823256615742218114e6
             + y*(-3.428774638263646513231484436228e6
             + 2.2287035148713702336004648835482e6*y)))));
            grad[2]= 0;
            return;
          case ( 113 ):
            grad[0]= 199.95999599919979994398319471828
             - 342.78856457005679990397119094563*z
             + y*(-10455.051219386732397071121323842
             + 17139.428228502839995198559547281*z
             + y*(126403.2831852084449645893766612
             - 188533.7105135312399471841550201*z
             + y*(-597023.4166261822598327498242303
             + 754134.8420541249597887366200804*z
             + y*(1.2961692597805272746368910657632e6
             - 1.2254691183379530596566970076306e6*z
             + y*(-1.2989972654382302432360988280885e6
             + 486102.75027405471366382314636015*y
             + 686262.7062692537134077503242731*z)))))
             + x*(-1199.7599759951987996638991683097
             + 1713.9428228502839995198559547281*z
             + x*(2999.3999399879969991597479207743
             - 3427.8856457005679990397119094563*z
             + x*(-3999.1999199839959988796638943657
             + 3427.8856457005679990397119094563*z
             + x*(2999.3999399879969991597479207743
             - 1713.9428228502839995198559547281*z
             + x*(-1199.7599759951987996638991683097
             + 199.95999599919979994398319471828*x
             + 10455.051219386732397071121323842*y
             + 342.78856457005679990397119094563*z)
             + y*(-52275.256096933661985355606619208
             + 126403.2831852084449645893766612*y
             + 17139.428228502839995198559547281*z))
             + y*(104550.51219386732397071121323842
             - 68557.71291401135998079423818913*z
             + y*(-505613.1327408337798583575066448
             + 597023.4166261822598327498242303*y
             + 188533.7105135312399471841550201*z)))
             + y*(-104550.51219386732397071121323842
             + 102836.56937101703997119135728369*z
             + y*(758419.6991112506697875362599672
             - 565601.1315405937198415524650603*z
             + y*(-1.7910702498785467794982494726909e6
             + 1.2961692597805272746368910657632e6*y
             + 754134.8420541249597887366200804*z))))
             + y*(52275.256096933661985355606619208
             - 68557.71291401135998079423818913*z
             + y*(-505613.1327408337798583575066448
             + 565601.1315405937198415524650603*z
             + y*(1.7910702498785467794982494726909e6
             - 1.5082696841082499195774732401608e6*z
             + y*(-2.5923385195610545492737821315263e6
             + 1.2989972654382302432360988280885e6*y
             + 1.2254691183379530596566970076306e6*z)))));
            grad[1]= 1742.5085365644553995118535539736
             - 3427.8856457005679990397119094563*z
             + y*(-50561.31327408337798583575066448
             + 94266.85525676561997359207751005*z
             + y*(447767.56246963669487456236817273
             - 754134.8420541249597887366200804*z
             + y*(-1.7282256797073696995158547543509e6
             + 2.4509382366759061193133940152612e6*z
             + y*(3.2474931635955756080902470702212e6
             - 3.4313135313462685670387516213657e6*z
             + y*(-2.9166165016443282819829388781609e6
             + 1.000799779975994998719635889565e6*y
             + 1.7156567656731342835193758106829e6*z)))))
             + x*(-10455.051219386732397071121323842
             + 17139.428228502839995198559547281*z
             + x*(26137.628048466830992677803309604
             - 34278.856457005679990397119094563*z
             + x*(-34850.170731289107990237071079472
             + 34278.856457005679990397119094563*z
             + x*(26137.628048466830992677803309604
             - 17139.428228502839995198559547281*z
             + x*(-10455.051219386732397071121323842
             + 1742.5085365644553995118535539736*x
             + 50561.31327408337798583575066448*y
             + 3427.8856457005679990397119094563*z)
             + y*(-252806.5663704168899291787533224
             + 447767.56246963669487456236817273*y
             + 94266.85525676561997359207751005*z))
             + y*(505613.1327408337798583575066448
             - 377067.42102706247989436831004019*z
             + y*(-1.7910702498785467794982494726909e6
             + 1.7282256797073696995158547543509e6*y
             + 754134.8420541249597887366200804*z)))
             + y*(-505613.1327408337798583575066448
             + 565601.1315405937198415524650603*z
             + y*(2.6866053748178201692473742090364e6
             - 2.2624045261623748793662098602411e6*z
             + y*(-5.1846770391221090985475642630526e6
             + 3.2474931635955756080902470702212e6*y
             + 2.4509382366759061193133940152612e6*z))))
             + y*(252806.5663704168899291787533224
             - 377067.42102706247989436831004019*z
             + y*(-1.7910702498785467794982494726909e6
             + 2.2624045261623748793662098602411e6*z
             + y*(5.1846770391221090985475642630526e6
             - 4.9018764733518122386267880305225e6*z
             + y*(-6.4949863271911512161804941404423e6
             + 2.9166165016443282819829388781609e6*y
             + 3.4313135313462685670387516213657e6*z)))));
            grad[2]= 57.131427428342799983995198490938
             + y*(-3427.8856457005679990397119094563
             + y*(47133.427628382809986796038755024
             + y*(-251378.28068470831992957887336013
             + y*(612734.55916897652982834850381531
             + y*(-686262.70626925371340775032427315
             + 285942.79427885571391989596844715*y)))))
             + x*(-342.78856457005679990397119094563
             + x*(856.97141142514199975992797736407
             + x*(-1142.6285485668559996799039698188
             + x*(856.97141142514199975992797736407
             + x*(-342.78856457005679990397119094563
             + 57.13142742834279998399519849094*x
             + 3427.8856457005679990397119094563*y)
             + y*(-17139.428228502839995198559547281
             + 47133.427628382809986796038755024*y))
             + y*(34278.856457005679990397119094563
             + y*(-188533.7105135312399471841550201
             + 251378.28068470831992957887336013*y)))
             + y*(-34278.856457005679990397119094563
             + y*(282800.56577029685992077623253014
             + y*(-754134.84205412495978873662008038
             + 612734.5591689765298283485038153*y))))
             + y*(17139.428228502839995198559547281
             + y*(-188533.7105135312399471841550201
             + y*(754134.84205412495978873662008038
             + y*(-1.2254691183379530596566970076306e6
             + 686262.7062692537134077503242731*y)))));
            return;
          case ( 114 ):
            grad[0]= 258.14724480420084468006367988936
             + z*(-1327.6144018501757726403274965738
             + 1106.3453348751464772002729138115*z)
             + y*(-12612.336817576669840083111217452
             + (61955.338753008202723215283173446
             - 48679.194734506444996812008207708*z)*z
             + y*(142165.37553145632232023506942478
             + z*(-632829.5315485837849585561067002
             + 438112.75261055800497130807386937*z)
             + y*(-624716.33242616604412575410533225
             + (2.33660134725630935984697639397e6
             - 1.2656590630971675699171122134004e6*z)*z
             + y*(1.2595741637553542642925107123744e6
             + z*(-3.4805624235172108172720585868511e6
             + 1.1074516802100216236774731867253e6*z)
             + y*(-1.1707346333648800021733287973954e6
             + 406065.61607700792868174016846596*y
             + 1.7719226883360345978839570987606e6*z)))))
             + x*(-1548.8834688252050680803820793361
             + (6638.0720092508788632016374828692
             - 4425.3813395005859088010916552461*z)*z
             + x*(3872.2086720630126702009551983404
             + z*(-13276.144018501757726403274965738
             + 6638.072009250878863201637482869*z)
             + x*(-5162.9448960840168936012735977872
             + (13276.144018501757726403274965738
             - 4425.3813395005859088010916552461*z)*z
             + x*(3872.2086720630126702009551983404
             + z*(-6638.0720092508788632016374828692
             + 1106.3453348751464772002729138115*z)
             + x*(-1548.8834688252050680803820793361
             + 258.14724480420084468006367988936*x
             + 12612.336817576669840083111217452*y
             + 1327.6144018501757726403274965738*z)
             + y*(-63061.684087883349200415556087258
             + 142165.37553145632232023506942478*y
             + 61955.33875300820272321528317345*z))
             + y*(126123.36817576669840083111217452
             + z*(-247821.35501203281089286113269378
             + 48679.194734506444996812008207708*z)
             + y*(-568661.50212582528928094027769913
             + 624716.3324261660441257541053322*y
             + 632829.5315485837849585561067002*z)))
             + y*(-126123.36817576669840083111217452
             + (371732.03251804921633929169904068
             - 146037.58420351933499043602462312*z)*z
             + y*(852992.25318873793392141041654869
             + z*(-1.8984885946457513548756683201006e6
             + 438112.75261055800497130807386937*z)
             + y*(-1.8741489972784981323772623159967e6
             + 1.2595741637553542642925107123744e6*y
             + 2.33660134725630935984697639397e6*z))))
             + y*(63061.684087883349200415556087258
             + z*(-247821.35501203281089286113269378
             + 146037.58420351933499043602462312*z)
             + y*(-568661.50212582528928094027769913
             + (1.8984885946457513548756683201006e6
             - 876225.5052211160099426161477387*z)*z
             + y*(1.8741489972784981323772623159967e6
             + z*(-4.6732026945126187196939527879399e6
             + 1.2656590630971675699171122134004e6*z)
             + y*(-2.5191483275107085285850214247489e6
             + 1.1707346333648800021733287973954e6*y
             + 3.4805624235172108172720585868511e6*z)))));
            grad[1]= 2102.0561362627783066805185362419
             + z*(-12391.067750601640544643056634689
             + 12169.798683626611249203002051927*z)
             + y*(-56866.150212582528928094027769913
             + (316414.7657742918924792780533501
             - 292075.16840703866998087204924625*z)*z
             + y*(468537.24931962453309431557899919
             + z*(-2.33660134725630935984697639397e6
             + 1.8984885946457513548756683201006e6*z)
             + y*(-1.6794322183404723523900142831659e6
             + (6.9611248470344216345441171737022e6
             - 4.4298067208400864947098927469014e6*z)*z
             + y*(2.9268365834122000054333219934884e6
             + z*(-8.8596134416801729894197854938028e6
             + 3.322355040630064871032419560176e6*z)
             + y*(-2.4363936964620475720904410107958e6
             + 775216.1761470151365742312307077*y
             + 3.9868260487560778452389034722112e6*z)))))
             + x*(-12612.336817576669840083111217452
             + (61955.338753008202723215283173446
             - 48679.194734506444996812008207708*z)*z
             + x*(31530.842043941674600207778043629
             + z*(-123910.67750601640544643056634689
             + 73018.79210175966749521801231156*z)
             + x*(-42041.122725255566133610370724838
             + (123910.67750601640544643056634689
             - 48679.194734506444996812008207708*z)*z
             + x*(31530.842043941674600207778043629
             + z*(-61955.338753008202723215283173446
             + 12169.798683626611249203002051927*z)
             + x*(-12612.336817576669840083111217452
             + 2102.0561362627783066805185362419*x
             + 56866.15021258252892809402776991*y
             + 12391.067750601640544643056634689*z)
             + y*(-284330.75106291264464047013884956
             + 468537.24931962453309431557899919*y
             + 316414.7657742918924792780533501*z))
             + y*(568661.50212582528928094027769913
             + z*(-1.2656590630971675699171122134004e6
             + 292075.16840703866998087204924625*z)
             + y*(-1.8741489972784981323772623159967e6
             + 1.6794322183404723523900142831659e6*y
             + 2.33660134725630935984697639397e6*z)))
             + y*(-568661.50212582528928094027769913
             + (1.8984885946457513548756683201006e6
             - 876225.5052211160099426161477387*z)*z
             + y*(2.8112234959177471985658934739951e6
             + z*(-7.0098040417689280795409291819099e6
             + 1.8984885946457513548756683201006e6*z)
             + y*(-5.0382966550214170571700428494977e6
             + 2.9268365834122000054333219934884e6*y
             + 6.961124847034421634544117173702e6*z))))
             + y*(284330.75106291264464047013884956
             + z*(-1.2656590630971675699171122134004e6
             + 876225.5052211160099426161477387*z)
             + y*(-1.8741489972784981323772623159967e6
             + (7.0098040417689280795409291819099e6
             - 3.7969771892915027097513366402012e6*z)*z
             + y*(5.0382966550214170571700428494977e6
             + z*(-1.3922249694068843269088234347404e7
             + 4.4298067208400864947098927469014e6*z)
             + y*(-5.8536731668244000108666439869768e6
             + 2.4363936964620475720904410107958e6*y
             + 8.859613441680172989419785493803e6*z)))));
            grad[2]= 221.26906697502929544005458276231
             - 442.53813395005859088010916552461*z
             + y*(-12391.067750601640544643056634689
             + 24339.597367253222498406004103854*z
             + y*(158207.38288714594623963902667505
             - 292075.16840703866998087204924625*z
             + y*(-778867.11575210311994899213132332
             + 1.2656590630971675699171122134004e6*z
             + y*(1.7402812117586054086360292934255e6
             - 2.2149033604200432473549463734507e6*z
             + y*(-1.7719226883360345978839570987606e6
             + 664471.0081260129742064839120352*y
             + 1.3289420162520259484129678240704e6*z)))))
             + x*(-1327.6144018501757726403274965738
             + 2212.6906697502929544005458276231*z
             + x*(3319.0360046254394316008187414346
             - 4425.3813395005859088010916552461*z
             + x*(-4425.3813395005859088010916552461
             + 4425.3813395005859088010916552461*z
             + x*(3319.0360046254394316008187414346
             - 2212.6906697502929544005458276231*z
             + x*(-1327.6144018501757726403274965738
             + 221.26906697502929544005458276231*x
             + 12391.067750601640544643056634689*y
             + 442.53813395005859088010916552461*z)
             + y*(-61955.338753008202723215283173446
             + 158207.38288714594623963902667505*y
             + 24339.597367253222498406004103854*z))
             + y*(123910.67750601640544643056634689
             - 97358.38946901288999362401641542*z
             + y*(-632829.5315485837849585561067002
             + 778867.1157521031199489921313233*y
             + 292075.16840703866998087204924625*z)))
             + y*(-123910.67750601640544643056634689
             + 146037.58420351933499043602462312*z
             + y*(949244.2973228756774378341600503
             - 876225.5052211160099426161477387*z
             + y*(-2.33660134725630935984697639397e6
             + 1.7402812117586054086360292934255e6*y
             + 1.2656590630971675699171122134004e6*z))))
             + y*(61955.338753008202723215283173446
             - 97358.38946901288999362401641542*z
             + y*(-632829.5315485837849585561067002
             + 876225.5052211160099426161477387*z
             + y*(2.33660134725630935984697639397e6
             - 2.5313181261943351398342244268008e6*z
             + y*(-3.4805624235172108172720585868511e6
             + 1.7719226883360345978839570987606e6*y
             + 2.2149033604200432473549463734507e6*z)))));
            return;
          case ( 115 ):
            grad[0]= 305.44393920980000352206032564644
             + z*(-3141.7090890150857505126204923634
             + (6545.2272687814286469012926924237
             - 3490.7878766834286116806894359593*z)*z)
             + y*(-13352.263628314114439678637092544
             + z*(130904.54537562857293802585384847
             + z*(-256572.90893623200295853067354301
             + 125668.36356060343002050481969454*z))
             + y*(134177.15901001928726147650019469
             + z*(-1.1833770901956822993597537187902e6
             + (2.0264023624147303090806402175744e6
             - 816844.3631439222951332813280145*z)*z)
             + y*(-524490.87847168514890502358775289
             + z*(3.8328850885984046156253970006833e6
             + z*(-5.0372069060541874866552348560893e6
             + 1.2706467871127680146517709546892e6*z))
             + y*(940549.15852389129655971575990129
             + y*(-779405.66316649252327300593381382
             + 242217.04379337140279299383823763*y
             + 2.1918657077695248252743048968389e6*z)
             + z*(-4.9691365424588606287274614120881e6
             + 3.6928172250464820425817093370655e6*z)))))
             + x*(-1832.6636352588000211323619538786
             + z*(15708.545445075428752563102461817
             + z*(-26180.909075125714587605170769695
             + 10472.363630050285835042068307878*z))
             + x*(4581.6590881470000528309048846966
             + z*(-31417.090890150857505126204923634
             + (39271.363612688571881407756154542
             - 10472.363630050285835042068307878*z)*z)
             + x*(-6108.8787841960000704412065129288
             + z*(31417.090890150857505126204923634
             + z*(-26180.909075125714587605170769695
             + 3490.7878766834286116806894359593*z))
             + x*(4581.6590881470000528309048846966
             + x*(-1832.6636352588000211323619538786
             + 305.44393920980000352206032564644*x
             + 13352.263628314114439678637092544*y
             + 3141.7090890150857505126204923634*z)
             + z*(-15708.545445075428752563102461817
             + 6545.227268781428646901292692424*z)
             + y*(-66761.318141570572198393185462722
             + 134177.15901001928726147650019469*y
             + 130904.54537562857293802585384847*z))
             + y*(133522.63628314114439678637092544
             + z*(-523618.1815025142917521034153939
             + 256572.90893623200295853067354301*z)
             + y*(-536708.63604007714904590600077875
             + 524490.8784716851489050235877529*y
             + 1.1833770901956822993597537187902e6*z)))
             + y*(-133522.63628314114439678637092544
             + z*(785427.27225377143762815512309085
             + z*(-769718.72680869600887559202062903
             + 125668.36356060343002050481969454*z))
             + y*(805062.95406011572356885900116812
             + z*(-3.5501312705870468980792611563706e6
             + 2.0264023624147303090806402175744e6*z)
             + y*(-1.5734726354150554467150707632587e6
             + 940549.1585238912965597157599013*y
             + 3.8328850885984046156253970006833e6*z))))
             + y*(66761.318141570572198393185462722
             + z*(-523618.1815025142917521034153939
             + (769718.72680869600887559202062903
             - 251336.72712120686004100963938907*z)*z)
             + y*(-536708.63604007714904590600077875
             + z*(3.5501312705870468980792611563706e6
             + z*(-4.0528047248294606181612804351488e6
             + 816844.3631439222951332813280145*z))
             + y*(1.5734726354150554467150707632587e6
             + y*(-1.8810983170477825931194315198026e6
             + 779405.6631664925232730059338138*y
             + 4.9691365424588606287274614120881e6*z)
             + z*(-7.6657701771968092312507940013667e6
             + 5.037206906054187486655234856089e6*z)))));
            grad[1]= 2225.3772713856857399464395154241
             + z*(-26180.909075125714587605170769695
             + (64143.227234058000739632668385753
             - 41889.454520201143340168273231512*z)*z)
             + y*(-53670.863604007714904590600077875
             + z*(591688.54509784114967987685939511
             + z*(-1.3509349082764868727204268117163e6
             + 816844.3631439222951332813280145*z))
             + y*(393368.15885376386167876769081467
             + z*(-3.8328850885984046156253970006833e6
             + (7.555810359081281229982852284134e6
             - 3.8119403613383040439553128640676e6*z)*z)
             + y*(-1.2540655446985217287462876798684e6
             + z*(9.9382730849177212574549228241762e6
             + z*(-1.4771268900185928170326837348262e7
             + 4.7649254516728800549441410800845e6*z))
             + y*(1.9485141579162313081825148345345e6
             + y*(-1.4533022627602284167579630294258e6
             + 416930.97702137700480761234450739*y
             + 4.288432906505592049449726972076e6*z)
             + z*(-1.0959328538847624126371524484194e7
             + 8.934235221886650103020264525158e6*z)))))
             + x*(-13352.263628314114439678637092544
             + z*(130904.54537562857293802585384847
             + z*(-256572.90893623200295853067354301
             + 125668.36356060343002050481969454*z))
             + x*(33380.659070785286099196592731361
             + z*(-261809.09075125714587605170769695
             + (384859.36340434800443779601031452
             - 125668.36356060343002050481969454*z)*z)
             + x*(-44507.545427713714798928790308481
             + z*(261809.09075125714587605170769695
             + z*(-256572.90893623200295853067354301
             + 41889.454520201143340168273231512*z))
             + x*(33380.659070785286099196592731361
             + x*(-13352.263628314114439678637092544
             + 2225.3772713856857399464395154241*x
             + 53670.86360400771490459060007787*y
             + 26180.909075125714587605170769695*z)
             + z*(-130904.54537562857293802585384847
             + 64143.22723405800073963266838575*z)
             + y*(-268354.31802003857452295300038937
             + 393368.15885376386167876769081467*y
             + 591688.5450978411496798768593951*z))
             + y*(536708.63604007714904590600077875
             + z*(-2.3667541803913645987195074375804e6
             + 1.3509349082764868727204268117163e6*z)
             + y*(-1.5734726354150554467150707632587e6
             + 1.2540655446985217287462876798684e6*y
             + 3.8328850885984046156253970006833e6*z)))
             + y*(-536708.63604007714904590600077875
             + z*(3.5501312705870468980792611563706e6
             + z*(-4.0528047248294606181612804351488e6
             + 816844.3631439222951332813280145*z))
             + y*(2.360208953122583170072606144888e6
             + z*(-1.149865526579521384687619100205e7
             + 7.555810359081281229982852284134e6*z)
             + y*(-3.7621966340955651862388630396052e6
             + 1.9485141579162313081825148345345e6*y
             + 9.938273084917721257454922824176e6*z))))
             + y*(268354.31802003857452295300038937
             + z*(-2.3667541803913645987195074375804e6
             + (4.0528047248294606181612804351488e6
             - 1.633688726287844590266562656029e6*z)*z)
             + y*(-1.5734726354150554467150707632587e6
             + z*(1.149865526579521384687619100205e7
             + z*(-1.5111620718162562459965704568268e7
             + 3.8119403613383040439553128640676e6*z))
             + y*(3.7621966340955651862388630396052e6
             + y*(-3.8970283158324626163650296690691e6
             + 1.4533022627602284167579630294258e6*y
             + 1.0959328538847624126371524484194e7*z)
             + z*(-1.9876546169835442514909845648352e7
             + 1.4771268900185928170326837348262e7*z)))));
            grad[2]= 523.6181815025142917521034153939
             + z*(-2618.0909075125714587605170769695
             + 2618.0909075125714587605170769695*z)
             + y*(-26180.909075125714587605170769695
             + (128286.45446811600147926533677151
             - 125668.36356060343002050481969454*z)*z
             + y*(295844.27254892057483993842969755
             + z*(-1.3509349082764868727204268117163e6
             + 1.2252665447158834426999219920217e6*z)
             + y*(-1.2776283628661348718751323335611e6
             + (5.0372069060541874866552348560893e6
             - 3.8119403613383040439553128640676e6*z)*z
             + y*(2.4845682712294303143637307060441e6
             + z*(-7.3856344500929640851634186741309e6
             + 3.5736940887546600412081058100634e6*z)
             + y*(-2.1918657077695248252743048968389e6
             + 714738.8177509320082416211620127*y
             + 3.5736940887546600412081058100634e6*z)))))
             + x*(-3141.7090890150857505126204923634
             + (13090.454537562857293802585384847
             - 10472.363630050285835042068307878*z)*z
             + x*(7854.2727225377143762815512309085
             + z*(-26180.909075125714587605170769695
             + 15708.545445075428752563102461817*z)
             + x*(-10472.363630050285835042068307878
             + (26180.909075125714587605170769695
             - 10472.363630050285835042068307878*z)*z
             + x*(7854.2727225377143762815512309085
             + z*(-13090.454537562857293802585384847
             + 2618.0909075125714587605170769695*z)
             + x*(-3141.7090890150857505126204923634
             + 523.6181815025142917521034153939*x
             + 26180.909075125714587605170769695*y
             + 2618.0909075125714587605170769695*z)
             + y*(-130904.54537562857293802585384847
             + 295844.27254892057483993842969755*y
             + 128286.45446811600147926533677151*z))
             + y*(261809.09075125714587605170769695
             + z*(-513145.81787246400591706134708602
             + 125668.36356060343002050481969454*z)
             + y*(-1.1833770901956822993597537187902e6
             + 1.2776283628661348718751323335611e6*y
             + 1.3509349082764868727204268117163e6*z)))
             + y*(-261809.09075125714587605170769695
             + (769718.72680869600887559202062903
             - 377005.09068181029006151445908361*z)*z
             + y*(1.7750656352935234490396305781853e6
             + z*(-4.0528047248294606181612804351488e6
             + 1.2252665447158834426999219920217e6*z)
             + y*(-3.8328850885984046156253970006833e6
             + 2.4845682712294303143637307060441e6*y
             + 5.037206906054187486655234856089e6*z))))
             + y*(130904.54537562857293802585384847
             + z*(-513145.81787246400591706134708602
             + 377005.09068181029006151445908361*z)
             + y*(-1.1833770901956822993597537187902e6
             + (4.0528047248294606181612804351488e6
             - 2.4505330894317668853998439840434e6*z)*z
             + y*(3.8328850885984046156253970006833e6
             + z*(-1.0074413812108374973310469712179e7
             + 3.8119403613383040439553128640676e6*z)
             + y*(-4.9691365424588606287274614120881e6
             + 2.1918657077695248252743048968389e6*y
             + 7.385634450092964085163418674131e6*z)))));
            return;
          case ( 116 ):
            grad[0]= 346.34087255188348618499842790182
             + z*(-5937.2721008894311917428301926027
             + z*(22264.77037833536696903561322226
             + z*(-27707.269804150678894799874232146
             + 10390.226176556504585549952837055*z)))
             + y*(-12765.135016912277062247084914096
             + z*(207804.52353113009171099905674109
             + z*(-730284.46840940003658436811369013
             + (831218.09412452036684399622696437
             - 270145.88059046911922429877376342*z)*z))
             + y*(107613.05682862094035033879724092
             + z*(-1.5555652904330309722366215104619e6
             + z*(4.7023195039044295038603215125413e6
             + z*(-4.3223340894475059075887803802147e6
             + 945510.582066641917285045708172*z)))
             + y*(-353267.69000292115590869839645986
             + z*(4.1323413822190441094530098140515e6
             + z*(-9.2621444773875126591188151004602e6
             + 5.042723104355423558853577110251e6*z))
             + y*(536580.96611788234395375827865647
             + y*(-382063.45969223489718865112289398
             + 103555.92089301316236931452994264*y
             + 1.6208752835428147153457926425805e6*z)
             + z*(-4.3995186267590685130814371727186e6
             + 5.267844671514147824873826088387e6*z)))))
             + x*(-2078.0452353113009171099905674109
             + z*(29686.360504447155958714150963013
             + z*(-89059.08151334146787614245288904
             + (83121.809412452036684399622696437
             - 20780.452353113009171099905674109*z)*z))
             + x*(5195.1130882782522927749764185273
             + z*(-59372.721008894311917428301926027
             + z*(133588.62227001220181421367933356
             + z*(-83121.809412452036684399622696437
             + 10390.226176556504585549952837055*z)))
             + x*(-6926.8174510376697236999685580364
             + z*(59372.721008894311917428301926027
             + z*(-89059.08151334146787614245288904
             + 27707.269804150678894799874232146*z))
             + x*(5195.1130882782522927749764185273
             + x*(-2078.0452353113009171099905674109
             + 346.34087255188348618499842790182*x
             + 12765.135016912277062247084914096*y
             + 5937.272100889431191742830192603*z)
             + z*(-29686.360504447155958714150963013
             + 22264.77037833536696903561322226*z)
             + y*(-63825.675084561385311235424570479
             + 107613.05682862094035033879724092*y
             + 207804.52353113009171099905674109*z))
             + y*(127651.35016912277062247084914096
             + z*(-831218.09412452036684399622696437
             + 730284.4684094000365843681136901*z)
             + y*(-430452.22731448376140135518896369
             + 353267.69000292115590869839645986*y
             + 1.5555652904330309722366215104619e6*z)))
             + y*(-127651.35016912277062247084914096
             + z*(1.2468271411867805502659943404466e6
             + z*(-2.1908534052282001097531043410704e6
             + 831218.0941245203668439962269644*z))
             + y*(645678.34097172564210203278344554
             + y*(-1.0598030700087634677260951893796e6
             + 536580.9661178823439537582786565*y
             + 4.1323413822190441094530098140515e6*z)
             + z*(-4.6666958712990929167098645313857e6
             + 4.7023195039044295038603215125413e6*z))))
             + y*(63825.675084561385311235424570479
             + z*(-831218.09412452036684399622696437
             + z*(2.1908534052282001097531043410704e6
             + z*(-1.6624361882490407336879924539287e6
             + 270145.88059046911922429877376342*z)))
             + y*(-430452.22731448376140135518896369
             + z*(4.6666958712990929167098645313857e6
             + z*(-9.4046390078088590077206430250826e6
             + 4.3223340894475059075887803802147e6*z))
             + y*(1.0598030700087634677260951893796e6
             + y*(-1.0731619322357646879075165573129e6
             + 382063.45969223489718865112289398*y
             + 4.3995186267590685130814371727186e6*z)
             + z*(-8.2646827644380882189060196281029e6
             + 9.26214447738751265911881510046e6*z)))));
            grad[1]= 2127.5225028187128437078474856826
             + z*(-41560.904706226018342199811348219
             + z*(182571.11710235000914609202842253
             + z*(-277072.69804150678894799874232146
             + 135072.94029523455961214938688171*z)))
             + y*(-43045.222731448376140135518896369
             + z*(777782.64521651548611831075523095
             + z*(-3.1348796692696196692402143416942e6
             + (4.3223340894475059075887803802147e6
             - 1.891021164133283834570091416344e6*z)*z))
             + y*(264950.76750219086693152379734489
             + z*(-4.1323413822190441094530098140515e6
             + z*(1.389321671608126898867822265069e7
             + z*(-1.5128169313066270676560731330752e7
             + 4.7275529103332095864252285408599e6*z)))
             + y*(-715441.28815717645860501103820862
             + y*(955158.64923058724297162780723495
             + y*(-621335.52535807897421588717965587
             + 157585.09701110698621417428469533*y
             + 2.7014588059046911922429877376342e6*z)
             + z*(-8.1043764177140735767289632129026e6
             + 1.0130470522142591970911204016128e7*z))
             + z*(8.7990372535181370261628743454372e6
             + z*(-2.1071378686056591299495304353547e7
             + 1.2606807760888558897133942775626e7*z)))))
             + x*(-12765.135016912277062247084914096
             + z*(207804.52353113009171099905674109
             + z*(-730284.46840940003658436811369013
             + (831218.09412452036684399622696437
             - 270145.88059046911922429877376342*z)*z))
             + x*(31912.837542280692655617712285239
             + z*(-415609.04706226018342199811348219
             + z*(1.0954267026141000548765521705352e6
             + z*(-831218.09412452036684399622696437
             + 135072.94029523455961214938688171*z)))
             + x*(-42550.450056374256874156949713652
             + z*(415609.04706226018342199811348219
             + z*(-730284.46840940003658436811369013
             + 277072.69804150678894799874232146*z))
             + x*(31912.837542280692655617712285239
             + x*(-12765.135016912277062247084914096
             + 2127.5225028187128437078474856826*x
             + 43045.222731448376140135518896369*y
             + 41560.904706226018342199811348219*z)
             + z*(-207804.52353113009171099905674109
             + 182571.11710235000914609202842253*z)
             + y*(-215226.11365724188070067759448185
             + 264950.76750219086693152379734489*y
             + 777782.6452165154861183107552309*z))
             + y*(430452.22731448376140135518896369
             + z*(-3.1111305808660619444732430209238e6
             + 3.1348796692696196692402143416942e6*z)
             + y*(-1.0598030700087634677260951893796e6
             + 715441.2881571764586050110382086*y
             + 4.1323413822190441094530098140515e6*z)))
             + y*(-430452.22731448376140135518896369
             + z*(4.6666958712990929167098645313857e6
             + z*(-9.4046390078088590077206430250826e6
             + 4.3223340894475059075887803802147e6*z))
             + y*(1.5897046050131452015891427840694e6
             + y*(-2.1463238644715293758150331146259e6
             + 955158.649230587242971627807235*y
             + 8.799037253518137026162874345437e6*z)
             + z*(-1.2397024146657132328359029442154e7
             + 1.389321671608126898867822265069e7*z))))
             + y*(215226.11365724188070067759448185
             + z*(-3.1111305808660619444732430209238e6
             + z*(9.4046390078088590077206430250826e6
             + z*(-8.6446681788950118151775607604295e6
             + 1.891021164133283834570091416344e6*z)))
             + y*(-1.0598030700087634677260951893796e6
             + z*(1.2397024146657132328359029442154e7
             + z*(-2.778643343216253797735644530138e7
             + 1.5128169313066270676560731330752e7*z))
             + y*(2.1463238644715293758150331146259e6
             + y*(-1.9103172984611744859432556144699e6
             + 621335.5253580789742158871796559*y
             + 8.104376417714073576728963212903e6*z)
             + z*(-1.7598074507036274052325748690874e7
             + 2.1071378686056591299495304353547e7*z)))));
            grad[2]= 989.54535014823853195713836543378
             + z*(-8905.908151334146787614245288904
             + (20780.452353113009171099905674109
             - 13853.634902075339447399937116073*z)*z)
             + y*(-41560.904706226018342199811348219
             + z*(365142.23420470001829218405684506
             + z*(-831218.09412452036684399622696437
             + 540291.7611809382384485975475268*z))
             + y*(388891.32260825774305915537761547
             + z*(-3.1348796692696196692402143416942e6
             + (6.4835011341712588613831705703221e6
             - 3.7820423282665676691401828326879e6*z)*z)
             + y*(-1.3774471274063480364843366046838e6
             + z*(9.2621444773875126591188151004602e6
             + z*(-1.5128169313066270676560731330752e7
             + 6.303403880444279448566971387813e6*z))
             + y*(2.1997593133795342565407185863593e6
             + y*(-1.6208752835428147153457926425805e6
             + 450243.13431744853204049795627237*y
             + 4.0521882088570367883644816064513e6*z)
             + z*(-1.0535689343028295649747652176773e7
             + 9.45510582066641917285045708172e6*z)))))
             + x*(-5937.2721008894311917428301926027
             + z*(44529.54075667073393807122644452
             + z*(-83121.809412452036684399622696437
             + 41560.904706226018342199811348219*z))
             + x*(14843.180252223577979357075481507
             + z*(-89059.08151334146787614245288904
             + (124682.71411867805502659943404466
             - 41560.904706226018342199811348219*z)*z)
             + x*(-19790.907002964770639142767308676
             + z*(89059.08151334146787614245288904
             + z*(-83121.809412452036684399622696437
             + 13853.634902075339447399937116073*z))
             + x*(14843.180252223577979357075481507
             + x*(-5937.2721008894311917428301926027
             + 989.5453501482385319571383654338*x
             + 41560.904706226018342199811348219*y
             + 8905.908151334146787614245288904*z)
             + z*(-44529.54075667073393807122644452
             + 20780.452353113009171099905674109*z)
             + y*(-207804.52353113009171099905674109
             + 388891.32260825774305915537761547*y
             + 365142.23420470001829218405684506*z))
             + y*(415609.04706226018342199811348219
             + z*(-1.4605689368188000731687362273803e6
             + 831218.0941245203668439962269644*z)
             + y*(-1.5555652904330309722366215104619e6
             + 1.3774471274063480364843366046838e6*y
             + 3.1348796692696196692402143416942e6*z)))
             + y*(-415609.04706226018342199811348219
             + z*(2.1908534052282001097531043410704e6
             + z*(-2.4936542823735611005319886808931e6
             + 540291.7611809382384485975475268*z))
             + y*(2.3333479356495464583549322656928e6
             + z*(-9.4046390078088590077206430250826e6
             + 6.483501134171258861383170570322e6*z)
             + y*(-4.1323413822190441094530098140515e6
             + 2.1997593133795342565407185863593e6*y
             + 9.26214447738751265911881510046e6*z))))
             + y*(207804.52353113009171099905674109
             + z*(-1.4605689368188000731687362273803e6
             + (2.4936542823735611005319886808931e6
             - 1.0805835223618764768971950950537e6*z)*z)
             + y*(-1.5555652904330309722366215104619e6
             + z*(9.4046390078088590077206430250826e6
             + z*(-1.2967002268342517722766341140644e7
             + 3.7820423282665676691401828326879e6*z))
             + y*(4.1323413822190441094530098140515e6
             + y*(-4.3995186267590685130814371727186e6
             + 1.6208752835428147153457926425805e6*y
             + 1.0535689343028295649747652176773e7*z)
             + z*(-1.852428895477502531823763020092e7
             + 1.5128169313066270676560731330752e7*z)))));
            return;
          case ( 117 ):
            grad[0]= 382.89424127296560844002061734975
             + z*(-9845.8519184476870741719587318508
             + z*(57434.136190944841266003092602463
             + z*(-122526.15720734899470080659755192
             + (103381.44514370071427880556668443
             - 27568.385371653523807681484449182*z)*z)))
             + y*(-10830.437110292455781589154605036
             + z*(262556.05115860498864458556618269
             + z*(-1.4243665775354320633968766965411e6
             + z*(2.7568385371653523807681484449182e6
             + z*(-1.9987079394448804760569076225657e6
             + 385957.39520314933330754078228855*z))))
             + y*(69741.451089004450108718041017276
             + z*(-1.4637499852092228116935645314685e6
             + z*(6.6164124891968457138435562678037e6
             + z*(-9.9246187337952685707653344017056e6
             + 4.5832440680373983330270467896765e6*z)))
             + y*(-178319.31807855255478778103036574
             + y*(219070.20518546103740032608178368
             + y*(-130293.44038745772561487558721816
             + 30248.64506056428306676162877063*y
             + 735156.9432440939682048395853115*z)
             + z*(-2.4384893251355438320365884459217e6
             + 3.9399817426988161108478121525289e6*z))
             + z*(2.9143721678605153739548997846278e6
             + z*(-9.189461790551174602560494816394e6
             + 7.290306353837265184697992554339e6*z)))))
             + x*(-2297.3654476377936506401237040985
             + z*(49229.259592238435370859793659254
             + z*(-229736.54476377936506401237040985
             + z*(367578.47162204698410241979265576
             + z*(-206762.89028740142855761113336887
             + 27568.385371653523807681484449182*z))))
             + x*(5743.4136190944841266003092602463
             + z*(-98458.519184476870741719587318508
             + z*(344604.81714566904759601855561478
             + z*(-367578.47162204698410241979265576
             + 103381.44514370071427880556668443*z)))
             + x*(-7657.884825459312168800412346995
             + z*(98458.519184476870741719587318508
             + z*(-229736.54476377936506401237040985
             + 122526.15720734899470080659755192*z))
             + x*(5743.4136190944841266003092602463
             + x*(-2297.3654476377936506401237040985
             + 382.89424127296560844002061734975*x
             + 10830.437110292455781589154605036*y
             + 9845.851918447687074171958731851*z)
             + z*(-49229.259592238435370859793659254
             + 57434.13619094484126600309260246*z)
             + y*(-54152.185551462278907945773025179
             + 69741.45108900445010871804101728*y
             + 262556.05115860498864458556618269*z))
             + y*(108304.37110292455781589154605036
             + z*(-1.0502242046344199545783422647307e6
             + 1.4243665775354320633968766965411e6*z)
             + y*(-278965.8043560178004348721640691
             + 178319.31807855255478778103036574*y
             + 1.4637499852092228116935645314685e6*z)))
             + y*(-108304.37110292455781589154605036
             + z*(1.5753363069516299318675133970961e6
             + z*(-4.2730997326062961901906300896232e6
             + 2.7568385371653523807681484449182e6*z))
             + y*(418448.70653402670065230824610366
             + y*(-534957.95423565766436334309109722
             + 219070.20518546103740032608178368*y
             + 2.9143721678605153739548997846278e6*z)
             + z*(-4.3912499556276684350806935944054e6
             + 6.616412489196845713843556267804e6*z))))
             + y*(54152.185551462278907945773025179
             + z*(-1.0502242046344199545783422647307e6
             + z*(4.2730997326062961901906300896232e6
             + z*(-5.5136770743307047615362968898364e6
             + 1.9987079394448804760569076225657e6*z)))
             + y*(-278965.8043560178004348721640691
             + y*(534957.95423565766436334309109722
             + y*(-438140.41037092207480065216356736
             + 130293.44038745772561487558721816*y
             + 2.4384893251355438320365884459217e6*z)
             + z*(-5.8287443357210307479097995692557e6
             + 9.189461790551174602560494816394e6*z))
             + z*(4.3912499556276684350806935944054e6
             + z*(-1.3232824978393691427687112535607e7
             + 9.924618733795268570765334401706e6*z)))));
            grad[1]= 1805.072851715409296931525767506
             + z*(-52511.210231720997728917113236537
             + z*(356091.64438385801584921917413527
             + z*(-918946.1790551174602560494816394
             + (999353.96972244023802845381128285
             - 385957.39520314933330754078228855*z)*z)))
             + y*(-27896.58043560178004348721640691
             + z*(731874.99260461140584678226573424
             + z*(-4.4109416594645638092290375118691e6
             + z*(9.9246187337952685707653344017056e6
             + z*(-9.1664881360747966660540935793531e6
             + 2.8946804640236199998065558671641e6*z))))
             + y*(133739.48855891441609083577277431
             + z*(-2.9143721678605153739548997846278e6
             + z*(1.3784192685826761903840742224591e7
             + z*(-2.1870919061511795554093977663018e7
             + 1.0855051740088574999274584501865e7*z)))
             + y*(-292093.60691394804986710144237824
             + y*(325733.6009686443140371889680454
             + y*(-181491.87036338569840056977262378
             + 40203.895333661388886202164821724*y
             + 1.0338144514370071427880556668443e6*z)
             + z*(-3.6757847162204698410241979265576e6
             + 6.030584300049208332930324723259e6*z))
             + z*(4.8769786502710876640731768918434e6
             + z*(-1.5759926970795264443391248610116e7
             + 1.2865246506771644443584692742952e7*z)))))
             + x*(-10830.437110292455781589154605036
             + z*(262556.05115860498864458556618269
             + z*(-1.4243665775354320633968766965411e6
             + z*(2.7568385371653523807681484449182e6
             + z*(-1.9987079394448804760569076225657e6
             + 385957.39520314933330754078228855*z))))
             + x*(27076.09277573113945397288651259
             + z*(-525112.10231720997728917113236537
             + z*(2.1365498663031480950953150448116e6
             + z*(-2.7568385371653523807681484449182e6
             + 999353.9697224402380284538112829*z)))
             + x*(-36101.457034308185938630515350119
             + x*(27076.09277573113945397288651259
             + x*(-10830.437110292455781589154605036
             + 1805.072851715409296931525767506*x
             + 27896.58043560178004348721640691*y
             + 52511.21023172099772891711323654*z)
             + z*(-262556.05115860498864458556618269
             + 356091.64438385801584921917413527*z)
             + y*(-139482.90217800890021743608203455
             + 133739.48855891441609083577277431*y
             + 731874.9926046114058467822657342*z))
             + z*(525112.10231720997728917113236537
             + z*(-1.4243665775354320633968766965411e6
             + 918946.1790551174602560494816394*z))
             + y*(278965.8043560178004348721640691
             + y*(-534957.95423565766436334309109722
             + 292093.60691394804986710144237824*y
             + 2.9143721678605153739548997846278e6*z)
             + z*(-2.927499970418445623387129062937e6
             + 4.4109416594645638092290375118691e6*z)))
             + y*(-278965.8043560178004348721640691
             + z*(4.3912499556276684350806935944054e6
             + z*(-1.3232824978393691427687112535607e7
             + 9.924618733795268570765334401706e6*z))
             + y*(802436.93135348649654501463664584
             + y*(-876280.82074184414960130432713472
             + 325733.6009686443140371889680454*y
             + 4.8769786502710876640731768918434e6*z)
             + z*(-8.7431165035815461218646993538835e6
             + 1.3784192685826761903840742224591e7*z))))
             + y*(139482.90217800890021743608203455
             + z*(-2.927499970418445623387129062937e6
             + z*(1.3232824978393691427687112535607e7
             + z*(-1.9849237467590537141530668803411e7
             + 9.166488136074796666054093579353e6*z)))
             + y*(-534957.95423565766436334309109722
             + y*(876280.82074184414960130432713472
             + y*(-651467.20193728862807437793609079
             + 181491.87036338569840056977262378*y
             + 3.6757847162204698410241979265576e6*z)
             + z*(-9.7539573005421753281463537836868e6
             + 1.5759926970795264443391248610116e7*z))
             + z*(8.7431165035815461218646993538835e6
             + z*(-2.7568385371653523807681484449182e7
             + 2.1870919061511795554093977663018e7*z)))));
            grad[2]= 1640.9753197412811790286597886418
             + z*(-22973.654476377936506401237040985
             + z*(91894.61790551174602560494816394
             + z*(-137841.92685826761903840742224591
             + 68920.96342913380951920371112296*z)))
             + y*(-52511.210231720997728917113236537
             + z*(712183.28876771603169843834827054
             + z*(-2.7568385371653523807681484449182e6
             + (3.9974158788897609521138152451314e6
             - 1.9297869760157466665377039114427e6*z)*z))
             + y*(365937.49630230570292339113286712
             + z*(-4.4109416594645638092290375118691e6
             + z*(1.4886928100692902856148001602558e7
             + z*(-1.8332976272149593332108187158706e7
             + 7.23670116005904999951638966791e6*z)))
             + y*(-971457.38928683845798496659487594
             + y*(1.2192446625677719160182942229609e6
             + y*(-735156.94324409396820483958531152
             + 172302.40857283452379800927780739*y
             + 2.4122337200196833331721298893034e6*z)
             + z*(-7.8799634853976322216956243050579e6
             + 9.648934880078733332688519557214e6*z))
             + z*(9.189461790551174602560494816394e6
             + z*(-2.1870919061511795554093977663018e7
             + 1.4473402320118099999032779335821e7*z)))))
             + x*(-9845.8519184476870741719587318508
             + z*(114868.27238188968253200618520493
             + z*(-367578.47162204698410241979265576
             + (413525.78057480285711522226673773
             - 137841.92685826761903840742224591*z)*z))
             + x*(24614.629796119217685429896829627
             + z*(-229736.54476377936506401237040985
             + z*(551367.70743307047615362968898364
             + z*(-413525.78057480285711522226673773
             + 68920.96342913380951920371112296*z)))
             + x*(-32819.506394825623580573195772836
             + z*(229736.54476377936506401237040985
             + z*(-367578.47162204698410241979265576
             + 137841.92685826761903840742224591*z))
             + x*(24614.629796119217685429896829627
             + x*(-9845.8519184476870741719587318508
             + 1640.9753197412811790286597886418*x
             + 52511.21023172099772891711323654*y
             + 22973.654476377936506401237040985*z)
             + z*(-114868.27238188968253200618520493
             + 91894.61790551174602560494816394*z)
             + y*(-262556.05115860498864458556618269
             + 365937.49630230570292339113286712*y
             + 712183.2887677160316984383482705*z))
             + y*(525112.10231720997728917113236537
             + z*(-2.8487331550708641267937533930822e6
             + 2.7568385371653523807681484449182e6*z)
             + y*(-1.4637499852092228116935645314685e6
             + 971457.3892868384579849665948759*y
             + 4.4109416594645638092290375118691e6*z)))
             + y*(-525112.10231720997728917113236537
             + z*(4.2730997326062961901906300896232e6
             + z*(-8.2705156114960571423044453347546e6
             + 3.9974158788897609521138152451314e6*z))
             + y*(2.1956249778138342175403467972027e6
             + y*(-2.9143721678605153739548997846278e6
             + 1.2192446625677719160182942229609e6*y
             + 9.189461790551174602560494816394e6*z)
             + z*(-1.3232824978393691427687112535607e7
             + 1.4886928100692902856148001602558e7*z))))
             + y*(262556.05115860498864458556618269
             + z*(-2.8487331550708641267937533930822e6
             + z*(8.2705156114960571423044453347546e6
             + z*(-7.9948317577795219042276304902628e6
             + 1.9297869760157466665377039114427e6*z)))
             + y*(-1.4637499852092228116935645314685e6
             + z*(1.3232824978393691427687112535607e7
             + z*(-2.9773856201385805712296003205117e7
             + 1.8332976272149593332108187158706e7*z))
             + y*(2.9143721678605153739548997846278e6
             + y*(-2.4384893251355438320365884459217e6
             + 735156.9432440939682048395853115*y
             + 7.879963485397632221695624305058e6*z)
             + z*(-1.8378923581102349205120989632788e7
             + 2.1870919061511795554093977663018e7*z)))));
            return;
          case ( 118 ):
            grad[0]= 416.24992492491815463313622999008
             + z*(-14984.997297297053566792904279643
             + z*(124874.97747747544638994086899702
             + z*(-399599.92792792142844781078079048
             + z*(561937.39864863950875473391048661
             + z*(-329669.94054053517846944389415214
             + 54944.99009008919641157398235869*z)))))
             + y*(-7492.4986486485267833964521398214
             + z*(249749.95495495089277988173799405
             + z*(-1.8980996576576267851271012087548e6
             + z*(5.3945990270269392840454455406714e6
             + z*(-6.3686238513512477658869843188482e6
             + 2.6373595243242814277555511532171e6*z))))
             + y*(31218.744369368861597485217249256
             + y*(-58274.989489488541648639072198611
             + y*(56193.739864863950875473391048661
             + y*(-27472.495045044598205786991179345
             + 5411.249024023936010230770989871*y
             + 189809.96576576267851271012087548*z)
             + z*(-774224.86036034776761763338778155
             + 1.5234747252252004459572786017637e6*z))
             + z*(1.1987997837837642853434323423714e6
             + z*(-4.6952991531530767842617766742881e6
             + 4.5953991711710964271498239790905e6*z)))
             + z*(-849149.84684683303545159790917976
             + z*(4.9450491081080276770416584122821e6
             + z*(-9.5903982702701142827474587389714e6
             + 5.806686452702608257132250408362e6*z)))))
             + x*(-2497.4995495495089277988173799405
             + z*(74924.986486485267833964521398214
             + z*(-499499.90990990178555976347598809
             + z*(1.1987997837837642853434323423714e6
             + z*(-1.1238747972972790175094678209732e6
             + 329669.94054053517846944389415214*z))))
             + x*(6243.7488738737723194970434498512
             + z*(-149849.97297297053566792904279643
             + z*(749249.86486485267833964521398214
             + z*(-1.1987997837837642853434323423714e6
             + 561937.3986486395087547339104866*z)))
             + x*(-8324.9984984983630926627245998016
             + x*(6243.7488738737723194970434498512
             + x*(-2497.4995495495089277988173799405
             + 416.24992492491815463313622999008*x
             + 7492.498648648526783396452139821*y
             + 14984.997297297053566792904279643*z)
             + z*(-74924.986486485267833964521398214
             + 124874.97747747544638994086899702*z)
             + y*(-37462.493243242633916982260699107
             + 31218.744369368861597485217249256*y
             + 249749.95495495089277988173799405*z))
             + z*(149849.97297297053566792904279643
             + z*(-499499.90990990178555976347598809
             + 399599.92792792142844781078079048*z))
             + y*(74924.986486485267833964521398214
             + y*(-124874.97747747544638994086899702
             + 58274.98948948854164863907219861*y
             + 849149.8468468330354515979091798*z)
             + z*(-998999.81981980357111952695197619
             + 1.8980996576576267851271012087548e6*z)))
             + y*(-74924.986486485267833964521398214
             + y*(187312.46621621316958491130349554
             + y*(-174824.96846846562494591721659583
             + 56193.73986486395087547339104866*y
             + 1.1987997837837642853434323423714e6*z)
             + z*(-2.5474495405404991063547937275393e6
             + 4.9450491081080276770416584122821e6*z))
             + z*(1.4984997297297053566792904279643e6
             + z*(-5.6942989729728803553813036262643e6
             + 5.394599027026939284045445540671e6*z))))
             + y*(37462.493243242633916982260699107
             + z*(-998999.81981980357111952695197619
             + z*(5.6942989729728803553813036262643e6
             + z*(-1.0789198054053878568090891081343e7
             + 6.368623851351247765886984318848e6*z)))
             + y*(-124874.97747747544638994086899702
             + y*(174824.96846846562494591721659583
             + y*(-112387.47972972790175094678209732
             + 27472.495045044598205786991179345*y
             + 774224.8603603477676176333877815*z)
             + z*(-2.3975995675675285706868646847429e6
             + 4.6952991531530767842617766742881e6*z))
             + z*(2.5474495405404991063547937275393e6
             + z*(-9.8900982162160553540833168245643e6
             + 9.590398270270114282747458738971e6*z)))));
            grad[1]= 1248.7497747747544638994086899702
             + z*(-49949.990990990178555976347598809
             + z*(474524.91441440669628177530218869
             + z*(-1.7981996756756464280151485135571e6
             + z*(3.1843119256756238829434921594241e6
             + z*(-2.6373595243242814277555511532171e6
             + 824174.8513513379461736097353804*z)))))
             + y*(-12487.497747747544638994086899702
             + z*(424574.92342341651772579895458988
             + z*(-3.2966994054053517846944389415214e6
             + z*(9.5903982702701142827474587389714e6
             + z*(-1.1613372905405216514264500816723e7
             + 4.9450491081080276770416584122821e6*z))))
             + y*(43706.242117116406236479304148958
             + y*(-74924.986486485267833964521398214
             + y*(68681.237612611495514467477948363
             + y*(-32467.494144143616061384625939226
             + 6243.748873873772319497043449851*y
             + 224774.95945945580350189356419464*z)
             + z*(-949049.82882881339256355060437738
             + 1.8731246621621316958491130349554e6*z))
             + z*(1.5484497207206955352352667755631e6
             + z*(-6.0938989009008017838291144070548e6
             + 5.993998918918821426717161711857e6*z)))
             + z*(-1.1987997837837642853434323423714e6
             + z*(7.0429487297296151763926650114321e6
             + z*(-1.3786197513513289281449471937271e7
             + 8.429060979729592631321008657299e6*z)))))
             + x*(-7492.4986486485267833964521398214
             + z*(249749.95495495089277988173799405
             + z*(-1.8980996576576267851271012087548e6
             + z*(5.3945990270269392840454455406714e6
             + z*(-6.3686238513512477658869843188482e6
             + 2.6373595243242814277555511532171e6*z))))
             + x*(18731.246621621316958491130349554
             + z*(-499499.90990990178555976347598809
             + z*(2.8471494864864401776906518131321e6
             + z*(-5.3945990270269392840454455406714e6
             + 3.1843119256756238829434921594241e6*z)))
             + x*(-24974.995495495089277988173799405
             + x*(18731.246621621316958491130349554
             + x*(-7492.4986486485267833964521398214
             + 1248.7497747747544638994086899702*x
             + 12487.497747747544638994086899702*y
             + 49949.990990990178555976347598809*z)
             + y*(-62437.488738737723194970434498512
             + 43706.242117116406236479304148958*y
             + 424574.92342341651772579895458988*z)
             + z*(-249749.95495495089277988173799405
             + 474524.91441440669628177530218869*z))
             + z*(499499.90990990178555976347598809
             + z*(-1.8980996576576267851271012087548e6
             + 1.7981996756756464280151485135571e6*z))
             + y*(124874.97747747544638994086899702
             + y*(-174824.96846846562494591721659583
             + 74924.98648648526783396452139821*y
             + 1.1987997837837642853434323423714e6*z)
             + z*(-1.6982996936936660709031958183595e6
             + 3.2966994054053517846944389415214e6*z)))
             + y*(-124874.97747747544638994086899702
             + y*(262237.45270269843741887582489375
             + y*(-224774.95945945580350189356419464
             + 68681.23761261149551446747794836*y
             + 1.5484497207206955352352667755631e6*z)
             + z*(-3.5963993513512928560302970271143e6
             + 7.042948729729615176392665011432e6*z))
             + z*(2.5474495405404991063547937275393e6
             + z*(-9.8900982162160553540833168245643e6
             + 9.590398270270114282747458738971e6*z))))
             + y*(62437.488738737723194970434498512
             + z*(-1.6982996936936660709031958183595e6
             + z*(9.8900982162160553540833168245643e6
             + z*(-1.9180796540540228565494917477943e7
             + 1.1613372905405216514264500816723e7*z)))
             + y*(-174824.96846846562494591721659583
             + y*(224774.95945945580350189356419464
             + y*(-137362.47522522299102893495589673
             + 32467.494144143616061384625939226*y
             + 949049.8288288133925635506043774*z)
             + z*(-3.0968994414413910704705335511262e6
             + 6.093898900900801783829114407055e6*z))
             + z*(3.5963993513512928560302970271143e6
             + z*(-1.4085897459459230352785330022864e7
             + 1.3786197513513289281449471937271e7*z)))));
            grad[2]= 2497.4995495495089277988173799405
             + z*(-49949.990990990178555976347598809
             + z*(299699.94594594107133585808559286
             + z*(-749249.86486485267833964521398214
             + (824174.85135133794617360973538036
             - 329669.94054053517846944389415214*z)*z)))
             + y*(-49949.990990990178555976347598809
             + z*(949049.82882881339256355060437738
             + z*(-5.3945990270269392840454455406714e6
             + z*(1.2737247702702495531773968637696e7
             + z*(-1.3186797621621407138777755766086e7
             + 4.9450491081080276770416584122821e6*z))))
             + y*(212287.46171170825886289947729494
             + y*(-399599.92792792142844781078079048
             + y*(387112.43018017388380881669389077
             + y*(-189809.96576576267851271012087548
             + 37462.493243242633916982260699107*y
             + 749249.8648648526783396452139821*z)
             + z*(-3.0469494504504008919145572035274e6
             + 4.4954991891891160700378712838929e6*z))
             + z*(4.6952991531530767842617766742881e6
             + z*(-1.3786197513513289281449471937271e7
             + 1.1238747972972790175094678209732e7*z)))
             + z*(-3.2966994054053517846944389415214e6
             + z*(1.4385597405405171424121188108457e7
             + z*(-2.3226745810810433028529001633446e7
             + 1.2362622770270069192604146030705e7*z)))))
             + x*(-14984.997297297053566792904279643
             + z*(249749.95495495089277988173799405
             + z*(-1.1987997837837642853434323423714e6
             + z*(2.2477495945945580350189356419464e6
             + z*(-1.6483497027026758923472194707607e6
             + 329669.94054053517846944389415214*z))))
             + x*(37462.493243242633916982260699107
             + z*(-499499.90990990178555976347598809
             + z*(1.7981996756756464280151485135571e6
             + z*(-2.2477495945945580350189356419464e6
             + 824174.8513513379461736097353804*z)))
             + x*(-49949.990990990178555976347598809
             + z*(499499.90990990178555976347598809
             + z*(-1.1987997837837642853434323423714e6
             + 749249.8648648526783396452139821*z))
             + x*(37462.493243242633916982260699107
             + x*(-14984.997297297053566792904279643
             + 2497.4995495495089277988173799405*x
             + 49949.990990990178555976347598809*y
             + 49949.990990990178555976347598809*z)
             + z*(-249749.95495495089277988173799405
             + 299699.94594594107133585808559286*z)
             + y*(-249749.95495495089277988173799405
             + 212287.46171170825886289947729494*y
             + 949049.8288288133925635506043774*z))
             + y*(499499.90990990178555976347598809
             + y*(-849149.84684683303545159790917976
             + 399599.92792792142844781078079048*y
             + 3.2966994054053517846944389415214e6*z)
             + z*(-3.7961993153152535702542024175095e6
             + 5.394599027026939284045445540671e6*z)))
             + y*(-499499.90990990178555976347598809
             + z*(5.6942989729728803553813036262643e6
             + z*(-1.6183797081080817852136336622014e7
             + 1.2737247702702495531773968637696e7*z))
             + y*(1.2737247702702495531773968637696e6
             + y*(-1.1987997837837642853434323423714e6
             + 387112.43018017388380881669389077*y
             + 4.6952991531530767842617766742881e6*z)
             + z*(-9.8900982162160553540833168245643e6
             + 1.4385597405405171424121188108457e7*z))))
             + y*(249749.95495495089277988173799405
             + z*(-3.7961993153152535702542024175095e6
             + z*(1.6183797081080817852136336622014e7
             + z*(-2.5474495405404991063547937275393e7
             + 1.3186797621621407138777755766086e7*z)))
             + y*(-849149.84684683303545159790917976
             + y*(1.1987997837837642853434323423714e6
             + y*(-774224.86036034776761763338778155
             + 189809.96576576267851271012087548*y
             + 3.0469494504504008919145572035274e6*z)
             + z*(-9.3905983063061535685235533485762e6
             + 1.3786197513513289281449471937271e7*z))
             + z*(9.8900982162160553540833168245643e6
             + z*(-2.8771194810810342848242376216914e7
             + 2.3226745810810433028529001633446e7*z)))));
            return;
          case ( 119 ):
            grad[0]= 447.12414383479673597396686495546
             + z*(-21461.958904070243326750409517862
             + z*(241447.03767079023742594210707595
             + z*(-1.0730979452035121663375204758931e6
             + z*(2.2132645119822438430711359815295e6
             + z*(-2.1247339315029540893482905422683e6
             + 767265.0308205111989313271402636*z)))))
             + y*(-2682.7448630087804158438011897327
             + z*(107309.79452035121663375204758931
             + z*(-965788.15068316094970376842830379
             + z*(3.2192938356105364990125614276793e6
             + z*(-4.426529023964487686142271963059e6
             + 2.1247339315029540893482905422683e6*z))))
             + y*(6706.8621575219510396095029743319
             + y*(-8942.4828766959347194793372991091
             + y*(6706.8621575219510396095029743319
             + y*(-2682.7448630087804158438011897327
             + 447.12414383479673597396686495546*y
             + 21461.958904070243326750409517862*z)
             + z*(-107309.79452035121663375204758931
             + 241447.03767079023742594210707595*z))
             + z*(214619.58904070243326750409517862
             + z*(-965788.15068316094970376842830379
             + 1.0730979452035121663375204758931e6*z)))
             + z*(-214619.58904070243326750409517862
             + z*(1.4486822260247414245556526424557e6
             + z*(-3.2192938356105364990125614276793e6
             + 2.2132645119822438430711359815295e6*z)))))
             + x*(-2682.7448630087804158438011897327
             + z*(107309.79452035121663375204758931
             + z*(-965788.15068316094970376842830379
             + z*(3.2192938356105364990125614276793e6
             + z*(-4.426529023964487686142271963059e6
             + 2.1247339315029540893482905422683e6*z))))
             + x*(6706.8621575219510396095029743319
             + x*(-8942.4828766959347194793372991091
             + x*(6706.8621575219510396095029743319
             + x*(-2682.7448630087804158438011897327
             + 447.12414383479673597396686495546*x
             + 2682.7448630087804158438011897327*y
             + 21461.958904070243326750409517862*z)
             + y*(-13413.724315043902079219005948664
             + 6706.862157521951039609502974332*y
             + 107309.79452035121663375204758931*z)
             + z*(-107309.79452035121663375204758931
             + 241447.03767079023742594210707595*z))
             + y*(26827.448630087804158438011897327
             + y*(-26827.448630087804158438011897327
             + 8942.482876695934719479337299109*y
             + 214619.58904070243326750409517862*z)
             + z*(-429239.17808140486653500819035724
             + 965788.1506831609497037684283038*z))
             + z*(214619.58904070243326750409517862
             + z*(-965788.15068316094970376842830379
             + 1.0730979452035121663375204758931e6*z)))
             + z*(-214619.58904070243326750409517862
             + z*(1.4486822260247414245556526424557e6
             + z*(-3.2192938356105364990125614276793e6
             + 2.2132645119822438430711359815295e6*z)))
             + y*(-26827.448630087804158438011897327
             + y*(40241.172945131706237657017845991
             + y*(-26827.448630087804158438011897327
             + 6706.862157521951039609502974332*y
             + 214619.58904070243326750409517862*z)
             + z*(-643858.76712210729980251228553586
             + 1.4486822260247414245556526424557e6*z))
             + z*(643858.76712210729980251228553586
             + z*(-2.8973644520494828491113052849114e6
             + 3.2192938356105364990125614276793e6*z))))
             + y*(13413.724315043902079219005948664
             + y*(-26827.448630087804158438011897327
             + y*(26827.448630087804158438011897327
             + y*(-13413.724315043902079219005948664
             + 2682.7448630087804158438011897327*y
             + 107309.79452035121663375204758931*z)
             + z*(-429239.17808140486653500819035724
             + 965788.1506831609497037684283038*z))
             + z*(643858.76712210729980251228553586
             + z*(-2.8973644520494828491113052849114e6
             + 3.2192938356105364990125614276793e6*z)))
             + z*(-429239.17808140486653500819035724
             + z*(2.8973644520494828491113052849114e6
             + z*(-6.4385876712210729980251228553586e6
             + 4.426529023964487686142271963059e6*z)))));
            grad[1]= 447.12414383479673597396686495546
             + z*(-21461.958904070243326750409517862
             + z*(241447.03767079023742594210707595
             + z*(-1.0730979452035121663375204758931e6
             + z*(2.2132645119822438430711359815295e6
             + z*(-2.1247339315029540893482905422683e6
             + 767265.0308205111989313271402636*z)))))
             + y*(-2682.7448630087804158438011897327
             + z*(107309.79452035121663375204758931
             + z*(-965788.15068316094970376842830379
             + z*(3.2192938356105364990125614276793e6
             + z*(-4.426529023964487686142271963059e6
             + 2.1247339315029540893482905422683e6*z))))
             + y*(6706.8621575219510396095029743319
             + y*(-8942.4828766959347194793372991091
             + y*(6706.8621575219510396095029743319
             + y*(-2682.7448630087804158438011897327
             + 447.12414383479673597396686495546*y
             + 21461.958904070243326750409517862*z)
             + z*(-107309.79452035121663375204758931
             + 241447.03767079023742594210707595*z))
             + z*(214619.58904070243326750409517862
             + z*(-965788.15068316094970376842830379
             + 1.0730979452035121663375204758931e6*z)))
             + z*(-214619.58904070243326750409517862
             + z*(1.4486822260247414245556526424557e6
             + z*(-3.2192938356105364990125614276793e6
             + 2.2132645119822438430711359815295e6*z)))))
             + x*(-2682.7448630087804158438011897327
             + z*(107309.79452035121663375204758931
             + z*(-965788.15068316094970376842830379
             + z*(3.2192938356105364990125614276793e6
             + z*(-4.426529023964487686142271963059e6
             + 2.1247339315029540893482905422683e6*z))))
             + x*(6706.8621575219510396095029743319
             + x*(-8942.4828766959347194793372991091
             + x*(6706.8621575219510396095029743319
             + x*(-2682.7448630087804158438011897327
             + 447.12414383479673597396686495546*x
             + 2682.7448630087804158438011897327*y
             + 21461.958904070243326750409517862*z)
             + y*(-13413.724315043902079219005948664
             + 6706.862157521951039609502974332*y
             + 107309.79452035121663375204758931*z)
             + z*(-107309.79452035121663375204758931
             + 241447.03767079023742594210707595*z))
             + y*(26827.448630087804158438011897327
             + y*(-26827.448630087804158438011897327
             + 8942.482876695934719479337299109*y
             + 214619.58904070243326750409517862*z)
             + z*(-429239.17808140486653500819035724
             + 965788.1506831609497037684283038*z))
             + z*(214619.58904070243326750409517862
             + z*(-965788.15068316094970376842830379
             + 1.0730979452035121663375204758931e6*z)))
             + z*(-214619.58904070243326750409517862
             + z*(1.4486822260247414245556526424557e6
             + z*(-3.2192938356105364990125614276793e6
             + 2.2132645119822438430711359815295e6*z)))
             + y*(-26827.448630087804158438011897327
             + y*(40241.172945131706237657017845991
             + y*(-26827.448630087804158438011897327
             + 6706.862157521951039609502974332*y
             + 214619.58904070243326750409517862*z)
             + z*(-643858.76712210729980251228553586
             + 1.4486822260247414245556526424557e6*z))
             + z*(643858.76712210729980251228553586
             + z*(-2.8973644520494828491113052849114e6
             + 3.2192938356105364990125614276793e6*z))))
             + y*(13413.724315043902079219005948664
             + y*(-26827.448630087804158438011897327
             + y*(26827.448630087804158438011897327
             + y*(-13413.724315043902079219005948664
             + 2682.7448630087804158438011897327*y
             + 107309.79452035121663375204758931*z)
             + z*(-429239.17808140486653500819035724
             + 965788.1506831609497037684283038*z))
             + z*(643858.76712210729980251228553586
             + z*(-2.8973644520494828491113052849114e6
             + 3.2192938356105364990125614276793e6*z)))
             + z*(-429239.17808140486653500819035724
             + z*(2.8973644520494828491113052849114e6
             + z*(-6.4385876712210729980251228553586e6
             + 4.426529023964487686142271963059e6*z)))));
            grad[2]= 3576.9931506783738877917349196437
             + z*(-96578.815068316094970376842830379
             + z*(804823.45890263412475314035691982
             + z*(-2.951019349309658457428181308706e6
             + z*(5.3118348287573852233707263556708e6
             + z*(-4.6035901849230671935879628415814e6
             + 1.5345300616410223978626542805271e6*z)))))
             + y*(-21461.958904070243326750409517862
             + z*(482894.07534158047485188421415189
             + z*(-3.2192938356105364990125614276793e6
             + z*(8.8530580479289753722845439261181e6
             + z*(-1.0623669657514770446741452711342e7
             + 4.6035901849230671935879628415814e6*z))))
             + y*(53654.897260175608316876023794655
             + y*(-71539.863013567477755834698392873
             + y*(53654.897260175608316876023794655
             + y*(-21461.958904070243326750409517862
             + 3576.9931506783738877917349196437*y
             + 96578.81506831609497037684283038*z)
             + z*(-482894.07534158047485188421415189
             + 804823.4589026341247531403569198*z))
             + z*(965788.15068316094970376842830379
             + z*(-3.2192938356105364990125614276793e6
             + 2.951019349309658457428181308706e6*z)))
             + z*(-965788.15068316094970376842830379
             + z*(4.8289407534158047485188421415189e6
             + z*(-8.8530580479289753722845439261181e6
             + 5.311834828757385223370726355671e6*z)))))
             + x*(-21461.958904070243326750409517862
             + z*(482894.07534158047485188421415189
             + z*(-3.2192938356105364990125614276793e6
             + z*(8.8530580479289753722845439261181e6
             + z*(-1.0623669657514770446741452711342e7
             + 4.6035901849230671935879628415814e6*z))))
             + x*(53654.897260175608316876023794655
             + x*(-71539.863013567477755834698392873
             + x*(53654.897260175608316876023794655
             + x*(-21461.958904070243326750409517862
             + 3576.9931506783738877917349196437*x
             + 21461.958904070243326750409517862*y
             + 96578.81506831609497037684283038*z)
             + y*(-107309.79452035121663375204758931
             + 53654.89726017560831687602379465*y
             + 482894.07534158047485188421415189*z)
             + z*(-482894.07534158047485188421415189
             + 804823.4589026341247531403569198*z))
             + z*(965788.15068316094970376842830379
             + z*(-3.2192938356105364990125614276793e6
             + 2.951019349309658457428181308706e6*z))
             + y*(214619.58904070243326750409517862
             + y*(-214619.58904070243326750409517862
             + 71539.86301356747775583469839287*y
             + 965788.1506831609497037684283038*z)
             + z*(-1.9315763013663218994075368566076e6
             + 3.2192938356105364990125614276793e6*z)))
             + z*(-965788.15068316094970376842830379
             + z*(4.8289407534158047485188421415189e6
             + z*(-8.8530580479289753722845439261181e6
             + 5.311834828757385223370726355671e6*z)))
             + y*(-214619.58904070243326750409517862
             + y*(321929.38356105364990125614276793
             + y*(-214619.58904070243326750409517862
             + 53654.89726017560831687602379465*y
             + 965788.1506831609497037684283038*z)
             + z*(-2.8973644520494828491113052849114e6
             + 4.8289407534158047485188421415189e6*z))
             + z*(2.8973644520494828491113052849114e6
             + z*(-9.6578815068316094970376842830379e6
             + 8.853058047928975372284543926118e6*z))))
             + y*(107309.79452035121663375204758931
             + y*(-214619.58904070243326750409517862
             + y*(214619.58904070243326750409517862
             + y*(-107309.79452035121663375204758931
             + 21461.958904070243326750409517862*y
             + 482894.07534158047485188421415189*z)
             + z*(-1.9315763013663218994075368566076e6
             + 3.2192938356105364990125614276793e6*z))
             + z*(2.8973644520494828491113052849114e6
             + z*(-9.6578815068316094970376842830379e6
             + 8.853058047928975372284543926118e6*z)))
             + z*(-1.9315763013663218994075368566076e6
             + z*(9.6578815068316094970376842830379e6
             + z*(-1.7706116095857950744569087852236e7
             + 1.0623669657514770446741452711342e7*z)))));
             return;
          #endif
          #if (PMAX3D>=8)
          case ( 120 ):
            grad[0]= -542.46843226126992762201692956797
             + x*(22783.674154973336960124711041855
             + x*(-296187.76401465338048162124354411
             + x*(1.727761956752144719476123920674e6
             + x*(-5.183285870256434158428371762022e6
             + x*(8.2932573924102946534853948192352e6
             + x*(-6.7135893176654766242500815203332e6
             + 2.1579394235353317720803833458214e6*x))))));
            grad[1]= 0;
            grad[2]= 0;
            return;
          case ( 121 ):
            grad[0]= -741.01282040191450388028693725613
             + 2196.8850675444994703274389198652*y
             + x*(30024.095923108159427808331904825
             - 85678.51763423547934277011787474*y
             + x*(-376033.4940613668260043799617836
             + 999582.7057327472589989847085387*y
             + x*(2.1102301565469108801089677180261e6
             - 4.9979135286637362949949235426934e6*y
             + x*(-6.0807947932075458255771569769437e6
             + 1.1994992468792967107987816502464e7*y
             + x*(9.3294385868389744173238572796944e6
             - 1.3594324797965362722386192036126e7*y
             + x*(-7.228728265584756368252975130321e6
             + 2.2194815996678143220222354344696e6*x
             + 5.826139199128012595308368015483e6*y))))));
            grad[1]= -26.153393661244041313421891903158
             + x*(2196.8850675444994703274389198652
             + x*(-42839.258817117739671385058937372
             + x*(333194.23524424908633299490284623
             + x*(-1.2494783821659340737487308856734e6
             + x*(2.3989984937585934215975633004928e6
             + x*(-2.2657207996608937870643653393544e6
             + 832305.5998754303707583382879261*x))))));
            grad[2]= 0;
            return;
          case ( 122 ):
            grad[0]= -1283.4718539960274485302364171808
             + 1268.3721851254859491357630475669*y
             + 2536.7443702509718982715260951339*z
             + x*(52003.259590144923914566284950245
             - 49466.515219893952016294758855111*y
             - 98933.03043978790403258951771022*z
             + x*(-651309.11706193703488121432492563
             + 577109.344232096106856772186643*y
             + 1.1542186884641922137135443732859e6*z
             + x*(3.6550258468032753434262238487388e6
             - 2.8855467211604805342838609332148e6*y
             - 5.77109344232096106856772186643e6*z
             + x*(-1.0532245532235753950136092406234e7
             + 6.925312130785153282281266239716e6*y
             + 1.3850624261570306564562532479431e7*z
             + x*(1.6159061638498690991989621226003e7
             - 7.848687081556507053252101738344e6*y
             - 1.5697374163113014106504203476689e7*z
             + x*(-1.2520524630102046965902162296883e7
             + 3.8442548970889014138377641167401e6*x
             + 3.3637230349527887371080436021475e6*y
             + 6.727446069905577474216087204295e6*z))))));
            grad[1]= -15.099668870541499394473369613892
             + x*(1268.3721851254859491357630475669
             + x*(-24733.257609946976008147379427555
             + x*(192369.78141069870228559072888099
             + x*(-721386.6802901201335709652333037
             + x*(1.3850624261570306564562532479431e6
             + x*(-1.3081145135927511755420169563907e6
             + 480531.86213611267672972051459251*x))))));
            grad[2]= -30.199337741082998788946739227784
             + x*(2536.7443702509718982715260951339
             + x*(-49466.515219893952016294758855111
             + x*(384739.56282139740457118145776197
             + x*(-1.4427733605802402671419304666074e6
             + x*(2.7701248523140613129125064958862e6
             + x*(-2.6162290271855023510840339127814e6
             + 961063.724272225353459441029185*x))))));
            return;
          case ( 123 ):
            grad[0]= -854.16626016250489686492191724766
             + (6747.9134552837886852328831462565
             - 8328.121036584422744432988693165*y)*y
             + x*(32501.026199183311325710278951273
             + y*(-246512.38268289891323521646531767
             + 291484.23628045479605515460426076*y)
             + x*(-381427.94347556656169503088214694
             + (2.681654973780184123707422359199e6
             - 2.9148423628045479605515460426076e6*y)*y
             + x*(2.0015250891257895995787282825906e6
             + y*(-1.2436660747966071298353263115126e7
             + 1.1659369451218191842206184170431e7*y)
             + x*(-5.3827422299790652338185216920154e6
             + (2.7516111904874932747606594642216e7
             - 1.9820928067070926131750513089732e7*y)*y
             + x*(7.6951838378040066158560815524841e6
             + x*(-5.5498598587798593168901436651249e6
             + 1.5856742453656740905400410471786e6*x
             + 1.109971971755971863378028733025e7*y)
             + y*(-2.8542136416582133629720738849214e7
             + 1.1892556840242555679050307853839e7*y))))));
            grad[1]= -85.416626016250489686492191724766
             + 213.54156504062622421623047931191*y
             + x*(6747.9134552837886852328831462565
             - 16656.242073168845488865977386329*y
             + x*(-123256.19134144945661760823265884
             + 291484.23628045479605515460426076*y
             + x*(893884.99126006137456914078639967
             - 1.9432282418696986403676973617384e6*y
             + x*(-3.1091651869915178245883157787815e6
             + 5.829684725609095921103092085215e6*y
             + x*(5.5032223809749865495213189284432e6
             - 7.928371226828370452700205235893e6*y
             + x*(-4.7570227360970222716201231415357e6
             + 1.5856742453656740905400410471786e6*x
             + 3.9641856134141852263501026179464e6*y))))));
            grad[2]= 0;
            return;
          case ( 124 ):
            grad[0]= -1479.459360712554348060046171549
             + y*(8765.7967122218845122557735664279
             - 7212.364383473702446792725086301*y
             - 14424.728766947404893585450172603*z)
             + 2921.9322374072948374185911888093*z
             + x*(56293.42867511269294368475682744
             - 106742.99287541079621253233127726*z
             + y*(-320228.97862623238863759699383179
             + 252432.75342157958563774537802055*y
             + 504865.5068431591712754907560411*z)
             + x*(-660652.57752619114412621361790521
             + y*(3.4835719972177982818008862166836e6
             - 2.5243275342157958563774537802055e6*y
             - 5.048655068431591712754907560411e6*z)
             + 1.1611906657392660939336287388945e6*z
             + x*(3.4667431469896929760917031914822e6
             - 5.385232072993697826938568064438e6*z
             + y*(-1.6155696218981093480815704193315e7
             + 1.0097310136863183425509815120822e7*y
             + 2.0194620273726366851019630241644e7*z)
             + x*(-9.323183026370339362887395961559e6
             + y*(3.574447788449566932630474552771e7
             - 1.7165427232667411823366685705397e7*y
             - 3.4330854465334823646733371410795e7*z)
             + 1.191482596149855644210158184257e7*z
             + x*(1.3328449380659402121672955959485e7
             - 1.2359107607520536512824013707886e7*z
             + x*(-9.6126392502937506210853439950226e6
             + 2.7464683572267858917386697128636e6*x
             + 1.4418958875440625931628015992534e7*y
             + 4.8063196251468753105426719975113e6*z)
             + y*(-3.7077322822561609538472041123659e7
             + 1.0299256339600447094020011423238e7*y
             + 2.0598512679200894188040022846477e7*z))))));
            grad[1]= -110.95945205344157610450346286618
             + 184.93242008906929350750577144363*y
             + 184.93242008906929350750577144363*z
             + x*(8765.7967122218845122557735664279
             - 14424.728766947404893585450172603*y
             - 14424.728766947404893585450172603*z
             + x*(-160114.48931311619431879849691589
             + 252432.75342157958563774537802055*y
             + 252432.75342157958563774537802055*z
             + x*(1.1611906657392660939336287388945e6
             - 1.682885022810530570918302520137e6*y
             - 1.682885022810530570918302520137e6*z
             + x*(-4.0389240547452733702039260483288e6
             + 5.048655068431591712754907560411e6*y
             + 5.048655068431591712754907560411e6*z
             + x*(7.148895576899133865260949105542e6
             - 6.866170893066964729346674282159e6*y
             - 6.866170893066964729346674282159e6*z
             + x*(-6.1795538037602682564120068539431e6
             + 2.0598512679200894188040022846477e6*x
             + 3.4330854465334823646733371410795e6*y
             + 3.4330854465334823646733371410795e6*z))))));
            grad[2]= -36.986484017813858701501154288725
             + 184.93242008906929350750577144363*y
             + x*(2921.9322374072948374185911888093
             - 14424.728766947404893585450172603*y
             + x*(-53371.496437705398106266165638631
             + 252432.75342157958563774537802055*y
             + x*(387063.55524642203131120957963151
             - 1.682885022810530570918302520137e6*y
             + x*(-1.3463080182484244567346420161096e6
             + 5.048655068431591712754907560411e6*y
             + x*(2.382965192299711288420316368514e6
             - 6.866170893066964729346674282159e6*y
             + x*(-2.0598512679200894188040022846477e6
             + 686617.0893066964729346674282159*x
             + 3.4330854465334823646733371410795e6*y))))));
            return;
          case ( 125 ):
            grad[0]= -1909.9738218101315118349171691427
             + y*(3772.1982980750097358739614090569
             - 1862.2244762648782240390442399142*y
             - 11173.346857589269344234265439485*z)
             + (11316.594894225029207621884227171
             - 11173.346857589269344234265439485*z)*z
             + x*(72674.503919875504025318598285881
             + z*(-413413.83373080296573666782126094
             + 391067.14001562442704819929038197*z)
             + y*(-137804.61124360098857888927375365
             + 65177.856669270737841366548397*y
             + 391067.14001562442704819929038197*z)
             + x*(-852898.81012931422660988226188068
             + y*(1.4990907033932269703514306131309e6
             - 651778.56669270737841366548397*y
             - 3.9106714001562442704819929038197e6*z)
             + (4.4972721101796809110542918393927e6
             - 3.9106714001562442704819929038197e6*z)*z
             + x*(4.4755461579565906651071696565937e6
             + z*(-2.0856914134166636109237295487039e7
             + 1.5642685600624977081927971615279e7*z)
             + y*(-6.9523047113888787030790984956795e6
             + 2.6071142667708295136546619358798e6*y
             + 1.5642685600624977081927971615279e7*z)
             + x*(-1.2036177531591996254705689270645e7
             + y*(1.5381974173947894130562505421691e7
             - 4.4320942535104101732129252909957e6*y
             - 2.6592565521062461039277551745974e7*z)
             + (4.6145922521843682391687516265073e7
             - 2.6592565521062461039277551745974e7*z)*z
             + x*(1.7206954160687474790120768776807e7
             + z*(-4.7866617937912429870699593142754e7
             + 1.5955539312637476623566531047585e7*z)
             + y*(-1.5955539312637476623566531047585e7
             + 2.6592565521062461039277551745974e6*y
             + 1.5955539312637476623566531047585e7*z)
             + x*(-1.2409863909829148484996190814788e7
             + 3.5456754028083281385703402327966e6*x
             + 6.204931954914574242498095407394e6*y
             + 1.8614795864743722727494286222182e7*z))))));
            grad[1]= -47.749345545253287795872929228568
             + 47.749345545253287795872929228568*y
             + 143.2480366357598633876187876857*z
             + x*(3772.1982980750097358739614090569
             - 3724.4489525297564480780884798283*y
             - 11173.346857589269344234265439485*z
             + x*(-68902.305621800494289444636876824
             + 65177.856669270737841366548397*y
             + 195533.57000781221352409964519099*z
             + x*(499696.90113107565678381020437697
             - 434519.04446180491894244365597997*y
             - 1.3035571333854147568273309679399e6*z
             + x*(-1.7380761778472196757697746239199e6
             + 1.3035571333854147568273309679399e6*y
             + 3.9106714001562442704819929038197e6*z
             + x*(3.0763948347895788261125010843382e6
             - 1.7728377014041640692851701163983e6*y
             - 5.318513104212492207855510349195e6*z
             + x*(-2.6592565521062461039277551745974e6
             + 886418.8507020820346425850581991*x
             + 886418.8507020820346425850581991*y
             + 2.6592565521062461039277551745974e6*z))))));
            grad[2]= -143.2480366357598633876187876857
             + 143.2480366357598633876187876857*y
             + 286.49607327151972677523757537141*z
             + x*(11316.594894225029207621884227171
             - 11173.346857589269344234265439485*y
             - 22346.69371517853868846853087897*z
             + x*(-206706.91686540148286833391063047
             + 195533.57000781221352409964519099*y
             + 391067.14001562442704819929038197*z
             + x*(1.4990907033932269703514306131309e6
             - 1.3035571333854147568273309679399e6*y
             - 2.6071142667708295136546619358798e6*z
             + x*(-5.2142285335416590273093238717596e6
             + 3.9106714001562442704819929038197e6*y
             + 7.821342800312488540963985807639e6*z
             + x*(9.2291845043687364783375032530146e6
             