# Generated by Django 4.0.2 on 2022-03-25 10:15

from django.db import migrations, models
import django.utils.timezone
import paper_uploads.models.fields.base
import paper_uploads.models.mixins


class Migration(migrations.Migration):

    dependencies = [
        ('paper_uploads', '0006_svgitem_description_svgitem_title'),
    ]

    operations = [
        migrations.CreateModel(
            name='UploadedSVGFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('owner_app_label', models.CharField(editable=False, max_length=100)),
                ('owner_model_name', models.CharField(editable=False, max_length=100)),
                ('owner_fieldname', models.CharField(editable=False, max_length=255)),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='changed at')),
                ('resource_name', models.CharField(editable=False, help_text='Human-readable resource name', max_length=255, verbose_name='resource name')),
                ('extension', models.CharField(editable=False, help_text='Lowercase, without leading dot', max_length=32, verbose_name='extension')),
                ('size', models.PositiveIntegerField(default=0, editable=False, verbose_name='size')),
                ('checksum', models.CharField(editable=False, max_length=64, verbose_name='checksum')),
                ('uploaded_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='uploaded at')),
                ('file', paper_uploads.models.fields.base.DynamicStorageFileField(verbose_name='file')),
                ('display_name', models.CharField(blank=True, max_length=255, verbose_name='display name')),
                ('title', models.CharField(blank=True, help_text='The title is being used as a tooltip when the user hovers the mouse over the image', max_length=255, verbose_name='title')),
                ('description', models.TextField(blank=True, help_text='This text will be used by screen readers, search engines, or when the image cannot be loaded', verbose_name='description')),
            ],
            options={
                'verbose_name': 'SVG file',
                'verbose_name_plural': 'SVG files',
                'abstract': False,
                'default_permissions': (),
            },
            bases=(paper_uploads.models.mixins.EditableResourceMixin, paper_uploads.models.mixins.FileFieldProxyMixin, paper_uploads.models.mixins.FileProxyMixin, models.Model),
        ),
    ]
