# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite import InteractionChannelInviteList
from twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_participant import InteractionChannelParticipantList


class InteractionChannelList(ListResource):

    def __init__(self, version, interaction_sid):
        """
        Initialize the InteractionChannelList

        :param Version version: Version that contains the resource
        :param interaction_sid: The Interaction Sid for this channel.

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelList
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelList
        """
        super(InteractionChannelList, self).__init__(version)

        # Path Solution
        self._solution = {'interaction_sid': interaction_sid, }
        self._uri = '/Interactions/{interaction_sid}/Channels'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams InteractionChannelInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists InteractionChannelInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of InteractionChannelInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return InteractionChannelPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of InteractionChannelInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return InteractionChannelPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a InteractionChannelContext

        :param sid: The Channel Sid for this Participant.

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        """
        return InteractionChannelContext(
            self._version,
            interaction_sid=self._solution['interaction_sid'],
            sid=sid,
        )

    def __call__(self, sid):
        """
        Constructs a InteractionChannelContext

        :param sid: The Channel Sid for this Participant.

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        """
        return InteractionChannelContext(
            self._version,
            interaction_sid=self._solution['interaction_sid'],
            sid=sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InteractionChannelList>'


class InteractionChannelPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the InteractionChannelPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param interaction_sid: The Interaction Sid for this channel.

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelPage
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelPage
        """
        super(InteractionChannelPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InteractionChannelInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        """
        return InteractionChannelInstance(
            self._version,
            payload,
            interaction_sid=self._solution['interaction_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InteractionChannelPage>'


class InteractionChannelContext(InstanceContext):

    def __init__(self, version, interaction_sid, sid):
        """
        Initialize the InteractionChannelContext

        :param Version version: Version that contains the resource
        :param interaction_sid: The Interaction Sid for this channel.
        :param sid: The Channel Sid for this Participant.

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        """
        super(InteractionChannelContext, self).__init__(version)

        # Path Solution
        self._solution = {'interaction_sid': interaction_sid, 'sid': sid, }
        self._uri = '/Interactions/{interaction_sid}/Channels/{sid}'.format(**self._solution)

        # Dependents
        self._invites = None
        self._participants = None

    def fetch(self):
        """
        Fetch the InteractionChannelInstance

        :returns: The fetched InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return InteractionChannelInstance(
            self._version,
            payload,
            interaction_sid=self._solution['interaction_sid'],
            sid=self._solution['sid'],
        )

    def update(self, status, routing=values.unset):
        """
        Update the InteractionChannelInstance

        :param InteractionChannelInstance.Status status: The Interaction Channels's status
        :param dict routing: The Interaction Channels's optional routing parameters

        :returns: The updated InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        """
        data = values.of({'Status': status, 'Routing': serialize.object(routing), })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return InteractionChannelInstance(
            self._version,
            payload,
            interaction_sid=self._solution['interaction_sid'],
            sid=self._solution['sid'],
        )

    @property
    def invites(self):
        """
        Access the invites

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteList
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteList
        """
        if self._invites is None:
            self._invites = InteractionChannelInviteList(
                self._version,
                interaction_sid=self._solution['interaction_sid'],
                channel_sid=self._solution['sid'],
            )
        return self._invites

    @property
    def participants(self):
        """
        Access the participants

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_participant.InteractionChannelParticipantList
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_participant.InteractionChannelParticipantList
        """
        if self._participants is None:
            self._participants = InteractionChannelParticipantList(
                self._version,
                interaction_sid=self._solution['interaction_sid'],
                channel_sid=self._solution['sid'],
            )
        return self._participants

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.InteractionChannelContext {}>'.format(context)


class InteractionChannelInstance(InstanceResource):

    class Status(object):
        CLOSE = "close"
        CLOSED = "closed"
        WRAPUP = "wrapup"

    class Type(object):
        VOICE = "voice"
        SMS = "sms"
        EMAIL = "email"
        WEB = "web"
        WHATSAPP = "whatsapp"
        CHAT = "chat"

    def __init__(self, version, payload, interaction_sid, sid=None):
        """
        Initialize the InteractionChannelInstance

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        """
        super(InteractionChannelInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'interaction_sid': payload.get('interaction_sid'),
            'type': payload.get('type'),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'interaction_sid': interaction_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: InteractionChannelContext for this InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelContext
        """
        if self._context is None:
            self._context = InteractionChannelContext(
                self._version,
                interaction_sid=self._solution['interaction_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def interaction_sid(self):
        """
        :returns: The Interaction Sid for this channel.
        :rtype: unicode
        """
        return self._properties['interaction_sid']

    @property
    def type(self):
        """
        :returns: The Interaction Channel's type.
        :rtype: InteractionChannelInstance.Type
        """
        return self._properties['type']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The links
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the InteractionChannelInstance

        :returns: The fetched InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        """
        return self._proxy.fetch()

    def update(self, status, routing=values.unset):
        """
        Update the InteractionChannelInstance

        :param InteractionChannelInstance.Status status: The Interaction Channels's status
        :param dict routing: The Interaction Channels's optional routing parameters

        :returns: The updated InteractionChannelInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.InteractionChannelInstance
        """
        return self._proxy.update(status, routing=routing, )

    @property
    def invites(self):
        """
        Access the invites

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteList
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteList
        """
        return self._proxy.invites

    @property
    def participants(self):
        """
        Access the participants

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_participant.InteractionChannelParticipantList
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_participant.InteractionChannelParticipantList
        """
        return self._proxy.participants

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.InteractionChannelInstance {}>'.format(context)
