import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::QuickSight::Analysis`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export interface CfnAnalysisProps {
    /**
     * `AWS::QuickSight::Analysis.AnalysisId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     */
    readonly analysisId: string;
    /**
     * `AWS::QuickSight::Analysis.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Analysis.Errors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     */
    readonly errors?: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Analysis.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     */
    readonly parameters?: CfnAnalysis.ParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     */
    readonly permissions?: Array<CfnAnalysis.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     */
    readonly sourceEntity?: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Analysis.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     */
    readonly themeArn?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare class CfnAnalysis extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Analysis";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnalysis;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute DataSetArns
     */
    readonly attrDataSetArns: string[];
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Sheets
     */
    readonly attrSheets: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::QuickSight::Analysis.AnalysisId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     */
    analysisId: string;
    /**
     * `AWS::QuickSight::Analysis.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Analysis.Errors`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     */
    errors: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Analysis.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     */
    parameters: CfnAnalysis.ParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     */
    permissions: Array<CfnAnalysis.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     */
    sourceEntity: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Analysis.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     */
    themeArn: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Analysis`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnalysisProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html
     */
    interface AnalysisErrorProperty {
        /**
         * `CfnAnalysis.AnalysisErrorProperty.Message`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message
         */
        readonly message?: string;
        /**
         * `CfnAnalysis.AnalysisErrorProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html
     */
    interface AnalysisSourceEntityProperty {
        /**
         * `CfnAnalysis.AnalysisSourceEntityProperty.SourceTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnAnalysis.AnalysisSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html
     */
    interface AnalysisSourceTemplateProperty {
        /**
         * `CfnAnalysis.AnalysisSourceTemplateProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn
         */
        readonly arn: string;
        /**
         * `CfnAnalysis.AnalysisSourceTemplateProperty.DataSetReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences
         */
        readonly dataSetReferences: Array<CfnAnalysis.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnAnalysis.DataSetReferenceProperty.DataSetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * `CfnAnalysis.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html
     */
    interface DateTimeParameterProperty {
        /**
         * `CfnAnalysis.DateTimeParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.DateTimeParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-values
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html
     */
    interface DecimalParameterProperty {
        /**
         * `CfnAnalysis.DecimalParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.DecimalParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html
     */
    interface IntegerParameterProperty {
        /**
         * `CfnAnalysis.IntegerParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.IntegerParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html
     */
    interface ParametersProperty {
        /**
         * `CfnAnalysis.ParametersProperty.DateTimeParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-datetimeparameters
         */
        readonly dateTimeParameters?: Array<CfnAnalysis.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.DecimalParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-decimalparameters
         */
        readonly decimalParameters?: Array<CfnAnalysis.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.IntegerParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-integerparameters
         */
        readonly integerParameters?: Array<CfnAnalysis.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.StringParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-stringparameters
         */
        readonly stringParameters?: Array<CfnAnalysis.StringParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnAnalysis.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnAnalysis.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html
     */
    interface SheetProperty {
        /**
         * `CfnAnalysis.SheetProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-name
         */
        readonly name?: string;
        /**
         * `CfnAnalysis.SheetProperty.SheetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-sheetid
         */
        readonly sheetId?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare namespace CfnAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html
     */
    interface StringParameterProperty {
        /**
         * `CfnAnalysis.StringParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-name
         */
        readonly name: string;
        /**
         * `CfnAnalysis.StringParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export interface CfnDashboardProps {
    /**
     * `AWS::QuickSight::Dashboard.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid
     */
    readonly dashboardId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardPublishOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions
     */
    readonly dashboardPublishOptions?: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Dashboard.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters
     */
    readonly parameters?: CfnDashboard.ParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions
     */
    readonly permissions?: Array<CfnDashboard.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity
     */
    readonly sourceEntity?: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Dashboard.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn
     */
    readonly themeArn?: string;
    /**
     * `AWS::QuickSight::Dashboard.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Dashboard";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDashboard;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastPublishedTime
     */
    readonly attrLastPublishedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * `AWS::QuickSight::Dashboard.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid
     */
    dashboardId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardPublishOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions
     */
    dashboardPublishOptions: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters
     */
    parameters: CfnDashboard.ParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions
     */
    permissions: Array<CfnDashboard.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity
     */
    sourceEntity: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Dashboard.ThemeArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn
     */
    themeArn: string | undefined;
    /**
     * `AWS::QuickSight::Dashboard.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Dashboard`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html
     */
    interface AdHocFilteringOptionProperty {
        /**
         * `CfnDashboard.AdHocFilteringOptionProperty.AvailabilityStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html#cfn-quicksight-dashboard-adhocfilteringoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html
     */
    interface DashboardPublishOptionsProperty {
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.AdHocFilteringOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-adhocfilteringoption
         */
        readonly adHocFilteringOption?: CfnDashboard.AdHocFilteringOptionProperty | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.ExportToCSVOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-exporttocsvoption
         */
        readonly exportToCsvOption?: CfnDashboard.ExportToCSVOptionProperty | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.SheetControlsOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-sheetcontrolsoption
         */
        readonly sheetControlsOption?: CfnDashboard.SheetControlsOptionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html
     */
    interface DashboardSourceEntityProperty {
        /**
         * `CfnDashboard.DashboardSourceEntityProperty.SourceTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html#cfn-quicksight-dashboard-dashboardsourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnDashboard.DashboardSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html
     */
    interface DashboardSourceTemplateProperty {
        /**
         * `CfnDashboard.DashboardSourceTemplateProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-arn
         */
        readonly arn: string;
        /**
         * `CfnDashboard.DashboardSourceTemplateProperty.DataSetReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-datasetreferences
         */
        readonly dataSetReferences: Array<CfnDashboard.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnDashboard.DataSetReferenceProperty.DataSetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * `CfnDashboard.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html
     */
    interface DateTimeParameterProperty {
        /**
         * `CfnDashboard.DateTimeParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.DateTimeParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-values
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html
     */
    interface DecimalParameterProperty {
        /**
         * `CfnDashboard.DecimalParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.DecimalParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html
     */
    interface ExportToCSVOptionProperty {
        /**
         * `CfnDashboard.ExportToCSVOptionProperty.AvailabilityStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html#cfn-quicksight-dashboard-exporttocsvoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html
     */
    interface IntegerParameterProperty {
        /**
         * `CfnDashboard.IntegerParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.IntegerParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-values
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html
     */
    interface ParametersProperty {
        /**
         * `CfnDashboard.ParametersProperty.DateTimeParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-datetimeparameters
         */
        readonly dateTimeParameters?: Array<CfnDashboard.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.DecimalParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-decimalparameters
         */
        readonly decimalParameters?: Array<CfnDashboard.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.IntegerParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-integerparameters
         */
        readonly integerParameters?: Array<CfnDashboard.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.StringParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-stringparameters
         */
        readonly stringParameters?: Array<CfnDashboard.StringParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnDashboard.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html#cfn-quicksight-dashboard-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnDashboard.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html#cfn-quicksight-dashboard-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html
     */
    interface SheetControlsOptionProperty {
        /**
         * `CfnDashboard.SheetControlsOptionProperty.VisibilityState`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html#cfn-quicksight-dashboard-sheetcontrolsoption-visibilitystate
         */
        readonly visibilityState?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare namespace CfnDashboard {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html
     */
    interface StringParameterProperty {
        /**
         * `CfnDashboard.StringParameterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-name
         */
        readonly name: string;
        /**
         * `CfnDashboard.StringParameterProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Template`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export interface CfnTemplateProps {
    /**
     * `AWS::QuickSight::Template.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Template.TemplateId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-templateid
     */
    readonly templateId: string;
    /**
     * `AWS::QuickSight::Template.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Template.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-permissions
     */
    readonly permissions?: Array<CfnTemplate.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-sourceentity
     */
    readonly sourceEntity?: CfnTemplate.TemplateSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Template.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-versiondescription
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare class CfnTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Template";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * `AWS::QuickSight::Template.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Template.TemplateId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-templateid
     */
    templateId: string;
    /**
     * `AWS::QuickSight::Template.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Template.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-permissions
     */
    permissions: Array<CfnTemplate.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Template.SourceEntity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-sourceentity
     */
    sourceEntity: CfnTemplate.TemplateSourceEntityProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Template.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Template.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-versiondescription
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Template`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnTemplate.DataSetReferenceProperty.DataSetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html#cfn-quicksight-template-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * `CfnTemplate.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html#cfn-quicksight-template-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnTemplate.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html#cfn-quicksight-template-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnTemplate.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html#cfn-quicksight-template-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html
     */
    interface TemplateSourceAnalysisProperty {
        /**
         * `CfnTemplate.TemplateSourceAnalysisProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-arn
         */
        readonly arn: string;
        /**
         * `CfnTemplate.TemplateSourceAnalysisProperty.DataSetReferences`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-datasetreferences
         */
        readonly dataSetReferences: Array<CfnTemplate.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html
     */
    interface TemplateSourceEntityProperty {
        /**
         * `CfnTemplate.TemplateSourceEntityProperty.SourceAnalysis`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html#cfn-quicksight-template-templatesourceentity-sourceanalysis
         */
        readonly sourceAnalysis?: CfnTemplate.TemplateSourceAnalysisProperty | cdk.IResolvable;
        /**
         * `CfnTemplate.TemplateSourceEntityProperty.SourceTemplate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html#cfn-quicksight-template-templatesourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnTemplate.TemplateSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 */
export declare namespace CfnTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html
     */
    interface TemplateSourceTemplateProperty {
        /**
         * `CfnTemplate.TemplateSourceTemplateProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html#cfn-quicksight-template-templatesourcetemplate-arn
         */
        readonly arn: string;
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Theme`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export interface CfnThemeProps {
    /**
     * `AWS::QuickSight::Theme.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Theme.ThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid
     */
    readonly themeId: string;
    /**
     * `AWS::QuickSight::Theme.BaseThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid
     */
    readonly baseThemeId?: string;
    /**
     * `AWS::QuickSight::Theme.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration
     */
    readonly configuration?: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Theme.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Theme.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions
     */
    readonly permissions?: Array<CfnTheme.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Theme.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Theme.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare class CfnTheme extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Theme";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTheme;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::QuickSight::Theme.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Theme.ThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid
     */
    themeId: string;
    /**
     * `AWS::QuickSight::Theme.BaseThemeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid
     */
    baseThemeId: string | undefined;
    /**
     * `AWS::QuickSight::Theme.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration
     */
    configuration: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Theme.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Theme.Permissions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions
     */
    permissions: Array<CfnTheme.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Theme.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Theme.VersionDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Theme`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThemeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html
     */
    interface BorderStyleProperty {
        /**
         * `CfnTheme.BorderStyleProperty.Show`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html#cfn-quicksight-theme-borderstyle-show
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html
     */
    interface DataColorPaletteProperty {
        /**
         * `CfnTheme.DataColorPaletteProperty.Colors`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-colors
         */
        readonly colors?: string[];
        /**
         * `CfnTheme.DataColorPaletteProperty.EmptyFillColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-emptyfillcolor
         */
        readonly emptyFillColor?: string;
        /**
         * `CfnTheme.DataColorPaletteProperty.MinMaxGradient`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-minmaxgradient
         */
        readonly minMaxGradient?: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html
     */
    interface FontProperty {
        /**
         * `CfnTheme.FontProperty.FontFamily`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html#cfn-quicksight-theme-font-fontfamily
         */
        readonly fontFamily?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html
     */
    interface GutterStyleProperty {
        /**
         * `CfnTheme.GutterStyleProperty.Show`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html#cfn-quicksight-theme-gutterstyle-show
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html
     */
    interface MarginStyleProperty {
        /**
         * `CfnTheme.MarginStyleProperty.Show`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html#cfn-quicksight-theme-marginstyle-show
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnTheme.ResourcePermissionProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html#cfn-quicksight-theme-resourcepermission-actions
         */
        readonly actions: string[];
        /**
         * `CfnTheme.ResourcePermissionProperty.Principal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html#cfn-quicksight-theme-resourcepermission-principal
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html
     */
    interface SheetStyleProperty {
        /**
         * `CfnTheme.SheetStyleProperty.Tile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html#cfn-quicksight-theme-sheetstyle-tile
         */
        readonly tile?: CfnTheme.TileStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.SheetStyleProperty.TileLayout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html#cfn-quicksight-theme-sheetstyle-tilelayout
         */
        readonly tileLayout?: CfnTheme.TileLayoutStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html
     */
    interface ThemeConfigurationProperty {
        /**
         * `CfnTheme.ThemeConfigurationProperty.DataColorPalette`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-datacolorpalette
         */
        readonly dataColorPalette?: CfnTheme.DataColorPaletteProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.Sheet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-sheet
         */
        readonly sheet?: CfnTheme.SheetStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.Typography`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-typography
         */
        readonly typography?: CfnTheme.TypographyProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.UIColorPalette`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-uicolorpalette
         */
        readonly uiColorPalette?: CfnTheme.UIColorPaletteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html
     */
    interface TileLayoutStyleProperty {
        /**
         * `CfnTheme.TileLayoutStyleProperty.Gutter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html#cfn-quicksight-theme-tilelayoutstyle-gutter
         */
        readonly gutter?: CfnTheme.GutterStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.TileLayoutStyleProperty.Margin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html#cfn-quicksight-theme-tilelayoutstyle-margin
         */
        readonly margin?: CfnTheme.MarginStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html
     */
    interface TileStyleProperty {
        /**
         * `CfnTheme.TileStyleProperty.Border`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html#cfn-quicksight-theme-tilestyle-border
         */
        readonly border?: CfnTheme.BorderStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html
     */
    interface TypographyProperty {
        /**
         * `CfnTheme.TypographyProperty.FontFamilies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html#cfn-quicksight-theme-typography-fontfamilies
         */
        readonly fontFamilies?: Array<CfnTheme.FontProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 */
export declare namespace CfnTheme {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html
     */
    interface UIColorPaletteProperty {
        /**
         * `CfnTheme.UIColorPaletteProperty.Accent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-accent
         */
        readonly accent?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.AccentForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-accentforeground
         */
        readonly accentForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Danger`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-danger
         */
        readonly danger?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.DangerForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dangerforeground
         */
        readonly dangerForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Dimension`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dimension
         */
        readonly dimension?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.DimensionForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dimensionforeground
         */
        readonly dimensionForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Measure`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-measure
         */
        readonly measure?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.MeasureForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-measureforeground
         */
        readonly measureForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.PrimaryBackground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-primarybackground
         */
        readonly primaryBackground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.PrimaryForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-primaryforeground
         */
        readonly primaryForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SecondaryBackground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-secondarybackground
         */
        readonly secondaryBackground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SecondaryForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-secondaryforeground
         */
        readonly secondaryForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Success`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-success
         */
        readonly success?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SuccessForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-successforeground
         */
        readonly successForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Warning`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-warning
         */
        readonly warning?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.WarningForeground`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-warningforeground
         */
        readonly warningForeground?: string;
    }
}
