#!/usr/bin/env python
"""
_ListJobsBySub_

Retrieve a list of all jobs generated by a particular subscription.  For each
job return the couch record, outcome, state and name.  The response is a list
of dictionaries with each dictionary having the following keys:
    couch_record
    outcome
    jobstate
    jobname
"""




from WMCore.WMBS.MySQL.Monitoring.DefaultFormatter import DefaultFormatter

class ListJobsBySub(DefaultFormatter):
    sql = """SELECT wmbs_job.name AS jobName, wmbs_job_state.name as jobState,
                    wmbs_job.couch_record, wmbs_job.outcome FROM wmbs_job
               INNER JOIN wmbs_jobgroup ON
                 wmbs_job.jobgroup = wmbs_jobgroup.id
               INNER JOIN wmbs_job_state ON
                 wmbs_job.state = wmbs_job_state.id
              WHERE wmbs_jobgroup.subscription = :subscriptionId"""

    def execute(self, subscriptionId, conn = None, transaction = False):
        """
        _execute_

        Execute the SQL for the given job ID and then format and return
        the result.
        """
        result = self.dbi.processData(self.sql, {"subscriptionId": subscriptionId},
                                      conn = conn, transaction = transaction)

        return self.formatDict(result)
