import concurrent.futures as futures
from typing import Union, TypeVar, Optional, Callable, Any

from .amount import Type, CurrencyAmount, PlainAmount
from .particular import WrappedRequestPayload
from .qiwi import (
    Bill,
    BillError,
    Statistic,
    Balance,
    Identification,
    Limit,
    Account,
    QiwiAccountInfo,
    Transaction,
    PaymentInfo,
    OrderDetails,
    RefundBill,
    Polygon,
    Terminal,
    Partner,
    WebHookConfig,
    WebHook,
    Notification,
    P2PKeys,
    CrossRate,
    FreePaymentDetailsFields,
    PaymentMethod,
    Card,
    Restriction,
    Commission,
    InvoiceStatus,
    TransactionType,
    QiwiPayment,
    Source,
    TransactionStatus,
)
from .yoomoney import (
    OperationType,
    OperationDetails,
    PreProcessPaymentResponse,
    Operation,
    Payment,
    IncomingTransaction,
    AccountInfo,
)

ALL_TYPES = Union[
    QiwiAccountInfo,
    Transaction,
    Bill,
    BillError,
    P2PKeys,
    Statistic,
    Limit,
    Account,
    Identification,
    Balance,
    AccountInfo,
    Operation,
    OperationDetails,
    PreProcessPaymentResponse,
    Payment,
    IncomingTransaction,
    Commission,
    PaymentInfo,
    OrderDetails,
    RefundBill,
    Polygon,
    Terminal,
    Partner,
    WebHookConfig,
    WebHook,
    Notification,
    CrossRate,
    FreePaymentDetailsFields,
    PaymentMethod,
    Card,
    Restriction,
    InvoiceStatus,
    QiwiPayment,
]

AnyExecutor = TypeVar(
    "AnyExecutor",
    futures.ThreadPoolExecutor,
    futures.ProcessPoolExecutor,
    Optional[None],
)

FuncT = TypeVar("FuncT", bound=Callable[..., Any])

N = TypeVar("N")

__all__ = (
    "QiwiAccountInfo",
    "Transaction",
    "Bill",
    "BillError",
    "P2PKeys",
    "InvoiceStatus",
    "Statistic",
    "Limit",
    "Account",
    "Identification",
    "Balance",
    "AccountInfo",
    "OperationType",
    "Operation",
    "OperationDetails",
    "PreProcessPaymentResponse",
    "Payment",
    "IncomingTransaction",
    "WrappedRequestPayload",
    "CurrencyAmount",
    "Type",
    "PlainAmount",
    "Commission",
    "ALL_TYPES",
    "PaymentInfo",
    "OrderDetails",
    "RefundBill",
    "Polygon",
    "Terminal",
    "Partner",
    "WebHookConfig",
    "WebHook",
    "Notification",
    "AnyExecutor",
    "FuncT",
    "N",
    "CrossRate",
    "FreePaymentDetailsFields",
    "PaymentMethod",
    "Card",
    "Restriction",
    "TransactionType",
    "QiwiPayment",
    "Source",
    "TransactionStatus"
)
