class Avatar(object):
    def handle_turn(self, world_state, avatar_state):
        from simulation.action import MoveAction
        from simulation import direction
        import random
        from simulation.action import WaitAction

        self.world_state = world_state
        self.avatar_state = avatar_state

        if world_state.get_cell(avatar_state.location).generates_score:
            return WaitAction()

        possible_directions = self.get_possible_directions()
        directions_to_emphasise = [d for d in possible_directions if self.is_towards(d, self.get_closest_pickup_location())]
        return MoveAction(random.choice(possible_directions + (directions_to_emphasise * 5)))

    def is_towards(self, direction, location):
        if location:
            return self.distance_between(self.avatar_state.location, location) > \
                self.distance_between(self.avatar_state.location + direction, location)
        else:
            return None

    def distance_between(self, a, b):
        return abs(a.x - b.x) + abs(a.y - b.y)

    def get_closest_pickup_location(self):
        pickup_cells = list(self.world_state.pickup_cells())
        if pickup_cells:
            c = min(pickup_cells, key=lambda cell: self.distance_between(cell.location, self.avatar_state.location))
            print 'targetting', c
            return c.location
        else:
            return None

    def get_possible_directions(self):
        from simulation import direction
        directions = (direction.EAST, direction.SOUTH, direction.WEST, direction.NORTH)
        return [d for d in directions if self.world_state.can_move_to(self.avatar_state.location + d)]
