import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::OpsWorksCM::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 * @external
 */
export interface CfnServerProps {
    /**
     * `AWS::OpsWorksCM::Server.InstanceProfileArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instanceprofilearn
     * @external
     */
    readonly instanceProfileArn: string;
    /**
     * `AWS::OpsWorksCM::Server.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::OpsWorksCM::Server.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servicerolearn
     * @external
     */
    readonly serviceRoleArn: string;
    /**
     * `AWS::OpsWorksCM::Server.AssociatePublicIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-associatepublicipaddress
     * @external
     */
    readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorksCM::Server.BackupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupid
     * @external
     */
    readonly backupId?: string;
    /**
     * `AWS::OpsWorksCM::Server.BackupRetentionCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupretentioncount
     * @external
     */
    readonly backupRetentionCount?: number;
    /**
     * `AWS::OpsWorksCM::Server.CustomCertificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customcertificate
     * @external
     */
    readonly customCertificate?: string;
    /**
     * `AWS::OpsWorksCM::Server.CustomDomain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customdomain
     * @external
     */
    readonly customDomain?: string;
    /**
     * `AWS::OpsWorksCM::Server.CustomPrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customprivatekey
     * @external
     */
    readonly customPrivateKey?: string;
    /**
     * `AWS::OpsWorksCM::Server.DisableAutomatedBackup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-disableautomatedbackup
     * @external
     */
    readonly disableAutomatedBackup?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorksCM::Server.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engine
     * @external
     */
    readonly engine?: string;
    /**
     * `AWS::OpsWorksCM::Server.EngineAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineattributes
     * @external
     */
    readonly engineAttributes?: Array<CfnServer.EngineAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorksCM::Server.EngineModel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-enginemodel
     * @external
     */
    readonly engineModel?: string;
    /**
     * `AWS::OpsWorksCM::Server.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::OpsWorksCM::Server.KeyPair`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-keypair
     * @external
     */
    readonly keyPair?: string;
    /**
     * `AWS::OpsWorksCM::Server.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredbackupwindow
     * @external
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::OpsWorksCM::Server.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::OpsWorksCM::Server.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::OpsWorksCM::Server.ServerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servername
     * @external
     */
    readonly serverName?: string;
    /**
     * `AWS::OpsWorksCM::Server.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-subnetids
     * @external
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::OpsWorksCM::Server.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::OpsWorksCM::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 * @external
 * @cloudformationResource AWS::OpsWorksCM::Server
 */
export declare class CfnServer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorksCM::Server";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnServer;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::OpsWorksCM::Server.InstanceProfileArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instanceprofilearn
     * @external
     */
    instanceProfileArn: string;
    /**
     * `AWS::OpsWorksCM::Server.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::OpsWorksCM::Server.ServiceRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servicerolearn
     * @external
     */
    serviceRoleArn: string;
    /**
     * `AWS::OpsWorksCM::Server.AssociatePublicIpAddress`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-associatepublicipaddress
     * @external
     */
    associatePublicIpAddress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorksCM::Server.BackupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupid
     * @external
     */
    backupId: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.BackupRetentionCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupretentioncount
     * @external
     */
    backupRetentionCount: number | undefined;
    /**
     * `AWS::OpsWorksCM::Server.CustomCertificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customcertificate
     * @external
     */
    customCertificate: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.CustomDomain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customdomain
     * @external
     */
    customDomain: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.CustomPrivateKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customprivatekey
     * @external
     */
    customPrivateKey: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.DisableAutomatedBackup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-disableautomatedbackup
     * @external
     */
    disableAutomatedBackup: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorksCM::Server.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engine
     * @external
     */
    engine: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.EngineAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineattributes
     * @external
     */
    engineAttributes: Array<CfnServer.EngineAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorksCM::Server.EngineModel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-enginemodel
     * @external
     */
    engineModel: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.KeyPair`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-keypair
     * @external
     */
    keyPair: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredbackupwindow
     * @external
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::OpsWorksCM::Server.ServerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servername
     * @external
     */
    serverName: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-subnetids
     * @external
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::OpsWorksCM::Server.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::OpsWorksCM::Server`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnServerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::OpsWorksCM::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 * @external
 * @cloudformationResource AWS::OpsWorksCM::Server
 */
export declare namespace CfnServer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworkscm-server-engineattribute.html
     * @external
     */
    interface EngineAttributeProperty {
        /**
         * `CfnServer.EngineAttributeProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworkscm-server-engineattribute.html#cfn-opsworkscm-server-engineattribute-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnServer.EngineAttributeProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworkscm-server-engineattribute.html#cfn-opsworkscm-server-engineattribute-value
         * @external
         */
        readonly value?: string;
    }
}
