"""
Defines the avaliable functions in the Free@Home System.

See: https://github.com/Busch-Jaeger/node-free-at-home/blob/master/src/functionIds.ts
Converted With: https://github.com/nitzano/enum-converter?tab=readme-ov-file
"""

import enum


class Function(enum.Enum):
    """An Enum class for all Free@Home functions."""

    FID_SWITCH_SENSOR = 0
    FID_DIMMING_SENSOR = 1
    FID_SHUTTER_SENSOR = 2
    FID_BLIND_SENSOR = 3
    FID_STAIRCASE_LIGHT_SENSOR = 4
    FID_FORCE_ON_OFF_SENSOR = 5
    FID_SCENE_SENSOR = 6
    FID_SWITCH_ACTUATOR = 7
    FID_STAIRCASE_LIGHT_ACTUATOR = 8
    FID_SHUTTER_ACTUATOR = 9
    FID_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITH_FAN = 10
    FID_ROOM_TEMPERATURE_CONTROLLER_SLAVE = 11
    FID_WIND_ALARM_SENSOR = 12
    FID_FROST_ALARM_SENSOR = 13
    FID_RAIN_ALARM_SENSOR = 14
    FID_WINDOW_DOOR_SENSOR = 15
    FID_NOTIFICATION_SENSOR = 16
    FID_MOVEMENT_DETECTOR = 17
    FID_DIMMING_ACTUATOR = 18
    FID_NOTIFICATION_CENTER = 19
    FID_RADIATOR_ACTUATOR = 20
    FID_UNDERFLOOR_HEATING = 21
    FID_FAN_COIL = 22
    FID_TWO_LEVEL_CONTROLLER = 23
    FID_PUSH_BUTTON_SENSOR = 24
    FID_RING_INDICATION_SENSOR = 25
    FID_DES_DOOR_OPENER_ACTUATOR = 26
    FID_PROXY = 27
    FID_FAN_COIL_SENSOR = 28
    FID_DES_LEVEL_CALL_ACTUATOR = 29
    FID_DES_LEVEL_CALL_SENSOR = 30
    FID_DES_DOOR_RINGING_SENSOR = 31
    FID_DES_AUTOMATIC_DOOR_OPENER_ACTUATOR = 32
    FID_DES_LIGHT_SWITCH_ACTUATOR = 33
    FID_DES_UNKNOWN_HVAC_ACTUATOR = 34
    FID_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITHOUT_FAN = 35
    FID_COOLING_ACTUATOR = 36
    FID_DAY_NIGHT_SENSOR = 37
    FID_DATE_AND_TIME = 38
    FID_HEATING_ACTUATOR = 39
    FID_FORCE_UP_DOWN_SENSOR = 40
    FID_HEATING_COOLING_ACTUATOR = 41
    FID_HEATING_COOLING_SENSOR = 42
    FID_DES_DEVICE_SETTINGS = 43
    FID_SACE_BLIND_ACTUATOR = 44
    FID_RGB_SENSOR = 45
    FID_RGB_W_ACTUATOR = 46
    FID_RGB_ACTUATOR = 47
    FID_PANEL_SWITCH_SENSOR = 48
    FID_PANEL_DIMMING_SENSOR = 49
    FID_PANEL_SHUTTER_SENSOR = 50
    FID_PANEL_BLIND_SENSOR = 51
    FID_PANEL_STAIRCASE_LIGHT_SENSOR = 52
    FID_PANEL_FORCE_ON_OFF_SENSOR = 53
    FID_PANEL_FORCE_UP_DOWN_SENSOR = 54
    FID_PANEL_SCENE_SENSOR = 55
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_SLAVE = 56
    FID_PANEL_FAN_COIL_SENSOR = 57
    FID_PANEL_RGB_CT_SENSOR = 58
    FID_PANEL_RGB_SENSOR = 59
    FID_PANEL_CT_SENSOR = 60
    FID_ADDITIONAL_HEATING_ACTUATOR = 61
    FID_RADIATOR_ACTUATOR_MASTER = 62
    FID_RADIATOR_ACTUATOR_SLAVE = 63
    FID_COLORTEMPERATURE_ACTUATOR = 64
    FID_BRIGHTNESS_SENSOR = 65
    FID_RAIN_SENSOR = 66
    FID_TEMPERATURE_SENSOR = 67
    FID_WIND_SENSOR = 68
    FID_TRIGGER = 69
    FID_FCA_2_PIPE_HEATING = 71
    FID_FCA_2_PIPE_COOLING = 72
    FID_FCA_2_PIPE_HEATING_COOLING = 73
    FID_FCA_4_PIPE_HEATING_AND_COOLING = 74
    FID_WINDOW_DOOR_ACTUATOR = 75
    DEPRECATED_004C = 76
    DEPRECATED_004D = 77
    FID_INVERTER_INFO = 78
    FID_METER_INFO = 79
    FID_BATTERY_INFO = 80
    FID_PANEL_TIMER_PROGRAM_SWITCH_SENSOR = 81
    DEPRECATED_0052 = 82
    FID_SAFETY_SENSOR = 83
    FID_CENTRAL_UNIT_ACTUATOR = 84
    FID_DOMUSTECH_ZONE = 85
    FID_CENTRAL_HEATING_ACTUATOR = 86
    FID_CENTRAL_COOLING_ACTUATOR = 87
    FID_LINK_ACTUATOR = 88
    FID_HOUSE_KEEPING = 89
    FID_MEDIA_PLAYER = 90
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_SLAVE_FOR_BATTERY_DEVICE = 91
    FID_WELCOME_IP_MUTE_SENSOR = 92
    FID_WELCOME_IP_MUTE_ACTUATOR = 93
    FID_WELCOME_IP_DOOR_OPEN_SENSOR = 94
    FID_WELCOME_IP_SWITCH_SENSOR = 95
    FID_PANEL_MEDIA_PLAYER_SENSOR = 96
    FID_BLIND_ACTUATOR = 97
    FID_ATTIC_WINDOW_ACTUATOR = 98
    FID_AWNING_ACTUATOR = 99
    FID_WINDOW_DOOR_POSITION_SENSOR = 100
    FID_WINDOW_DOOR_POSITION_ACTUATOR = 101
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR = 102
    FID_MEDIA_VOLUME_SENSOR = 103
    FID_DISHWASHER = 104
    FID_LAUNDRY = 105
    FID_DRYER = 106
    FID_OVEN = 107
    FID_FRIDGE = 108
    FID_FREEZER = 109
    FID_HOOD = 110
    FID_COFFEE_MACHINE = 111
    FID_FRIDGE_FREEZER = 112
    FID_TIMER_PROGRAM_OR_ALERT_SWITCH_SENSOR = 113
    FID_WELCOME_IP_BELL_INDICATOR_SENSOR = 114
    FID_CEILING_FAN_ACTUATOR = 115
    FID_CEILING_FAN_SENSOR = 116
    FID_SPLIT_UNIT_GATEWAY = 117
    FID_ZONE = 118
    FID_24H_ZONE = 119
    FID_EXTERNAL_IR_SENSOR_BX80 = 120
    FID_EXTERNAL_IR_SENSOR_VXI = 121
    FID_EXTERNAL_IR_SENSOR_MINI = 122
    FID_EXTERNAL_IR_SENSOR_HIGH_ALTITUDE = 123
    FID_EXTERNAL_IR_SENSOR_CURTAIN = 124
    FID_SMOKE_DETECTOR = 125
    FID_CARBON_MONOXIDE_SENSOR = 126
    FID_METHANE_DETECTOR = 127
    FID_GAS_SENSOR_LPG = 128
    FID_FLOOD_DETECTION = 129
    FID_DOMUS_CENTRAL_UNIT_NEXTGEN = 130
    FID_THERMOSTAT = 131
    FID_PANEL_DOMUS_ZONE_SENSOR = 132
    FID_THERMOSTAT_SLAVE = 133
    FID_DOMUS_SECURE_INTEGRATION = 134
    FID_ADDITIONAL_COOLING_ACTUATOR = 135
    FID_TWO_LEVEL_HEATING_ACTUATOR = 136
    FID_TWO_LEVEL_COOLING_ACTUATOR = 137
    FID_DOOR_LOCK_SENSOR = 138
    FID_DOOR_LOCK_ACTUATOR = 139
    FID_AC_ROUTING = 140
    FID_EXTERNAL_SIREN = 141
    FID_GLOBAL_ZONE = 142
    FID_VOLUME_UP_SENSOR = 143
    FID_VOLUME_DOWN_SENSOR = 144
    FID_PLAY_PAUSE_SENSOR = 145
    FID_NEXT_FAVORITE_SENSOR = 146
    FID_NEXT_SONG_SENSOR = 147
    FID_PREVIOUS_SONG_SENSOR = 148
    FID_HOME_APPLIANCE_SENSOR = 149
    FID_HEAT_SENSOR = 150
    FID_ZONE_SWITCHING = 151
    FID_SECURE_AT_HOME_FUNCTION = 152
    FID_COMPLEX_CONFIGURATION = 153
    FID_DOMUS_CENTRAL_UNIT_BASIC = 154
    FID_DOMUS_REPEATER = 155
    FID_DOMUS_SCENE_TRIGGER = 156
    FID_DOMUS_WINDOW_CONTACT = 157
    FID_DOMUS_MOVEMENT_DETECTOR = 158
    FID_DOMUS_CURTAIN_DETECTOR = 159
    FID_DOMUS_SMOKE_DETECTOR = 160
    FID_DOMUS_FLOOD_DETECTOR = 161
    FID_HOB = 162
    FID_PANEL_SUG_SENSOR = 163
    FID_TWO_LEVEL_HEATING_COOLING_ACTUATOR = 164
    FID_PANEL_THERMOSTAT_CONTROLLER_SLAVE = 165
    FID_WALLBOX = 166
    FID_PANEL_WALLBOX = 167
    FID_DOOR_LOCK_CONTROL = 168
    FID_DOOR_LOCK_SETTINGS = 169
    FID_VRV_GATEWAY = 170
    FID_DOMUS_PARAMETRABLE_BUTTON = 171
    FID_DOMUS_CENTRAL_UNIT_BASIC_25 = 172
    FID_DOMUS_CENTRAL_UNIT_NEXTGEN_25 = 173
    FID_PANEL_RGB_W_SENSOR = 174
    FID_INVERTER_METER_BATTERY = 175
    FID_INVERTER_METER = 176
    FID_METER_BATTERY = 177
    FID_INVERTER_BATTERY = 178
    FID_DES_VIDEO_CAMERA_LINK = 179
    FID_FINGERPRINT_SENSOR = 180
    FID_FLOOD_ALARM_SENSOR = 181
    FID_DOMUS_PRE_PROGRAMMED_REMOTE = 182
    FID_HVAC = 183
    FID_TIMED_START_STOP_ACTUATOR = 184
    FID_VENTILATION = 185
    FID_CO_2 = 186
    FID_VOC = 187
    FID_TEMPERATURE_SENSOR_TYPE1 = 188
    FID_AIRQUALITY_SENSOR = 189
    FID_VACUUM_CLEANER = 190
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_SLAVE_1X1 = 191
    FID_SMOKE_DETECTOR_TYPE1 = 192
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITHOUT_FAN = 193
    FID_PANEL_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITH_FAN = 194
    FID_DES_VIDEO_CAMERA_ACTUATOR = 195
    FID_ENERGY_ONE_WAY_METER = 196
    FID_ENERGY_TWO_WAY_METER = 197
    FID_ENERGY_INVERTER = 198
    FID_ENERGY_BATTERY = 199
    FID_WATER_METER = 200
    FID_GAS_METER = 201
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_UNDERFLOOR = 207
    FID_CWA_UNDERFLOOR_TEMPERATURE_CONTROLLER = 208
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_UNDERFLOOR_LIMITER = 209
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_HEATING_COOLING = 210
    FID_CWA_ROOM_TEMPERATURE_CONTROLLER_RADIATOR = 211
    FID_PANEL_LIGHT_SWITCH_SENSOR = 212
    FID_FLASHING_ACTUATOR = 213
    FID_PB_SWITCH_SENSOR = 214
    FID_PB_BLIND_SENSOR = 215
    FID_PB_STAIRCASE_LIGHT_SENSOR = 216
    FID_PB_SCENE_SENSOR = 217
    FID_DALI_DT0_ACTUATOR = 218
    FID_DALI_DT8_CT_ACTUATOR = 219
    FID_DALI_DT8_RGB_ACTUATOR = 220
    FID_COLORTEMPERATURE_ACTUATOR_TYPE8 = 222
    FID_RGB_ACTUATOR_TYPE8 = 223
    FID_RGB_W_ACTUATOR_TYPE8 = 224
    FID_CEILING_FAN_ACTUATOR_TYPE8 = 225
    FID_MEDIA_PLAYER_TYPE1 = 226
    FID_PANEL_MEDIA_PLAYER_SENSOR_TYPE1 = 227
    FID_ROOM_TEMPERATURE_CONTROLLER_WITH_FAN_TYPE1 = 228
    FID_ROOM_TEMPERATURE_CONTROLLER_WITHOUT_FAN_TYPE1 = 229
    FID_HEATING_ACTUATOR_TYPE1 = 230
    FID_TWO_LEVEL_HEATING_ACTUATOR_TYPE1 = 231
    FID_COOLING_ACTUATOR_TYPE1 = 232
    FID_TWO_LEVEL_COOLING_ACTUATOR_TYPE1 = 233
    FID_HEATING_COOLING_ACTUATOR_TYPE1 = 234
    FID_TWO_LEVEL_HEATING_COOLING_ACTUATOR_TYPE1 = 235
    FID_RGB_CT_ACTUATOR_TYPE8 = 236
    FID_ROOM_TEMPERATURE_CONTROLLER_PROXY_WITHOUT_FAN = 237
    FID_ROOM_TEMPERATURE_CONTROLLER_EXTENSION_PROXY = 238
    FID_HVAC_WITH_ENERGY = 239
    FID_SWITCH_ACTUATOR_TYPE1 = 240
    FID_SPLIT_UNIT = 241
    FID_SENSOR_ZONE = 242
    FID_AIRQUALITY_SENSOR_TYPE1 = 243
    FID_ENERGY_SUBMETER = 244
    FID_PANEL_SWITCH_SENSOR_PUSHBUTTON_TYPE4 = 245
    FID_PANEL_DIMMING_SENSOR_PUSHBUTTON_TYPE2 = 246
    FID_PANEL_BLIND_SENSOR_PUSHBUTTON_TYPE2 = 247
    FID_PANEL_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE2 = 248
    FID_PANEL_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE4 = 249
    FID_PANEL_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE4 = 250
    FID_PANEL_SCENE_SENSOR_PUSHBUTTON_TYPE2 = 251
    FID_PANEL_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE4 = 252
    FID_PANEL_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE2 = 253
    FID_PANEL_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE2 = 254
    FID_PANEL_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE2 = 255
    FID_PANEL_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE2 = 256
    FID_PANEL_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE2 = 257
    FID_PANEL_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE2 = 258
    FID_PANEL_MOVEMENT_DETECTOR_TYPE2 = 259
    FID_PANEL_WINDOW_DOOR_SENSOR = 260
    FID_PANEL_HEATING_COOLING_SENSOR = 261
    FID_PANEL_FROST_ALARM_SENSOR = 262
    FID_PANEL_RAIN_ALARM_SENSOR = 263
    FID_PANEL_WIND_ALARM_SENSOR = 264
    FID_PANEL_FLOOD_ALARM_SENSOR = 265
    FID_AIRQUALITY_ACTUATOR = 266
    FID_DOOR_OPENER_ACTUATOR_TYPE0 = 267
    FID_DOOR_OPENER_ACTUATOR_TYPE1 = 268
    FID_SPLIT_UNIT_EXTENSION_UNIT = 269
    FID_DOOR_RINGING_SENSOR = 270
    FID_CARD_READER = 271
    FID_AIRQUALITY_SENSOR_TYPE2 = 272
    FID_ROOM_TEMPERATURE_CONTROLLER_API = 273
    FID_WINDOW_DOOR_SENSOR_TYPE0 = 274
    FID_WINDOW_DOOR_SENSOR_TYPE1 = 275
    FID_WINDOW_DOOR_SENSOR_API = 276
    FID_MOVEMENT_DETECTOR_API = 277
    FID_ENVIRONMENT_SENSOR_API = 278
    FID_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITH_FAN_TYPE1 = 279
    FID_ROOM_TEMPERATURE_CONTROLLER_MASTER_WITHOUT_FAN_TYPE1 = 280
    FID_ROOM_TEMPERATURE_CONTROLLER_SLAVE_TYPE1 = 281
    FID_ROOM_TEMPERATURE_CONTROLLER_SLAVE_API = 282
    FID_CLOCK = 283
    FID_SWITCH_SENSOR_ROCKER_TYPE0 = 4096
    FID_SWITCH_SENSOR_ROCKER_TYPE1 = 4097
    FID_SWITCH_SENSOR_ROCKER_TYPE2 = 4098
    FID_SWITCH_SENSOR_ROCKER_TYPE3 = 4099
    FID_SWITCH_SENSOR_ROCKER_TYPE4 = 4100
    FID_SWITCH_SENSOR_ROCKER_TYPE5 = 4101
    FID_SWITCH_SENSOR_ROCKER_TYPE6 = 4102
    FID_SWITCH_SENSOR_ROCKER_TYPE7 = 4103
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE0 = 4104
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE1 = 4105
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE2 = 4106
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE3 = 4107
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE4 = 4108
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE5 = 4109
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE6 = 4110
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE7 = 4111
    FID_DIMMING_SENSOR_ROCKER_TYPE0 = 4112
    FID_DIMMING_SENSOR_ROCKER_TYPE1 = 4113
    FID_DIMMING_SENSOR_ROCKER_TYPE2 = 4114
    FID_DIMMING_SENSOR_ROCKER_TYPE3 = 4115
    FID_DIMMING_SENSOR_ROCKER_TYPE4 = 4116
    FID_DIMMING_SENSOR_ROCKER_TYPE5 = 4117
    FID_DIMMING_SENSOR_ROCKER_TYPE6 = 4118
    FID_DIMMING_SENSOR_ROCKER_TYPE7 = 4119
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE0 = 4120
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE1 = 4121
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE2 = 4122
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE3 = 4123
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE4 = 4124
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE5 = 4125
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE6 = 4126
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE7 = 4127
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE0 = 4128
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE1 = 4129
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE2 = 4130
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE3 = 4131
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE4 = 4132
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE5 = 4133
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE6 = 4134
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE7 = 4135
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE0 = 4136
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE1 = 4137
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE2 = 4138
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE3 = 4139
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE4 = 4140
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE5 = 4141
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE6 = 4142
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE7 = 4143
    FID_SCENE_SENSOR_ROCKER_TYPE0 = 4144
    FID_SCENE_SENSOR_ROCKER_TYPE1 = 4145
    FID_SCENE_SENSOR_ROCKER_TYPE2 = 4146
    FID_SCENE_SENSOR_ROCKER_TYPE3 = 4147
    FID_SCENE_SENSOR_ROCKER_TYPE4 = 4148
    FID_SCENE_SENSOR_ROCKER_TYPE5 = 4149
    FID_SCENE_SENSOR_ROCKER_TYPE6 = 4150
    FID_SCENE_SENSOR_ROCKER_TYPE7 = 4151
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE0 = 4152
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE1 = 4153
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE2 = 4154
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE3 = 4155
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE4 = 4156
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE5 = 4157
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE6 = 4158
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE7 = 4159
    FID_BLIND_SENSOR_ROCKER_TYPE0 = 4160
    FID_BLIND_SENSOR_ROCKER_TYPE1 = 4161
    FID_BLIND_SENSOR_ROCKER_TYPE2 = 4162
    FID_BLIND_SENSOR_ROCKER_TYPE3 = 4163
    FID_BLIND_SENSOR_ROCKER_TYPE4 = 4164
    FID_BLIND_SENSOR_ROCKER_TYPE5 = 4165
    FID_BLIND_SENSOR_ROCKER_TYPE6 = 4166
    FID_BLIND_SENSOR_ROCKER_TYPE7 = 4167
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE0 = 4168
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE1 = 4169
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE2 = 4170
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE3 = 4171
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE4 = 4172
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE5 = 4173
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE6 = 4174
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE7 = 4175
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE0 = 4176
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE1 = 4177
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE2 = 4178
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE3 = 4179
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE4 = 4180
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE5 = 4181
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE6 = 4182
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE7 = 4183
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE0 = 4184
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE1 = 4185
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE2 = 4186
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE3 = 4187
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE4 = 4188
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE5 = 4189
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE6 = 4190
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE7 = 4191
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE0 = 4192
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE1 = 4193
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE2 = 4194
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE3 = 4195
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE4 = 4196
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE5 = 4197
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE6 = 4198
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE7 = 4199
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE0 = 4200
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE1 = 4201
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE2 = 4202
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE3 = 4203
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE4 = 4204
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE5 = 4205
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE6 = 4206
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE7 = 4207
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE0 = 4208
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE1 = 4209
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE2 = 4210
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE3 = 4211
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE4 = 4212
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE5 = 4213
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE6 = 4214
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE7 = 4215
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE0 = 4216
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE1 = 4217
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE2 = 4218
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE3 = 4219
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE4 = 4220
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE5 = 4221
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE6 = 4222
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE7 = 4223
    FID_SWITCH_FORCE_ON_OFF_SENSOR_ROCKER_TYPE0 = 4224
    FID_SWITCH_FORCE_ON_OFF_SENSOR_ROCKER_TYPE1 = 4225
    FID_MOVEMENT_DETECTOR_TYPE0 = 4240
    FID_MOVEMENT_DETECTOR_SLAVE_TYPE0 = 4241
    FID_MOVEMENT_DETECTOR_TYPE2 = 4242
    FID_MOVEMENT_DETECTOR_TYPE3 = 4243
    FID_MOVEMENT_DETECTOR_TYPE4 = 4244
    FID_MOVEMENT_DETECTOR_SLAVE_TYPE3 = 4245
    FID_MOVEMENT_DETECTOR_SLAVE_TYPE4 = 4246
    FID_MOVEMENT_DETECTOR_TYPE5 = 4247
    FID_MOVEMENT_DETECTOR_TYPE6 = 4248
    FID_MOVEMENT_DETECTOR_TYPE7 = 4249
    FID_MOVEMENT_DETECTOR_TYPE8 = 4250
    FID_MOVEMENT_DETECTOR_TYPE9 = 4251
    FID_MOVEMENT_DETECTOR_TYPE10 = 4252
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE0 = 4256
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE1 = 4257
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE2 = 4258
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE3 = 4259
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE4 = 4260
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE5 = 4261
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE6 = 4262
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE7 = 4263
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE0 = 4264
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE1 = 4265
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE2 = 4266
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE3 = 4267
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE4 = 4268
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE5 = 4269
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE6 = 4270
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE7 = 4271
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE0 = 4272
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE1 = 4273
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE2 = 4274
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE3 = 4275
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE4 = 4276
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE5 = 4277
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE6 = 4278
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE7 = 4279
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE0 = 4280
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE1 = 4281
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE2 = 4282
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE3 = 4283
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE4 = 4284
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE5 = 4285
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE6 = 4286
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE7 = 4287
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE0 = 4288
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE1 = 4289
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE2 = 4290
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE3 = 4291
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE4 = 4292
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE5 = 4293
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE6 = 4294
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE7 = 4295
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE0 = 4296
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE1 = 4297
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE2 = 4298
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE3 = 4299
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE4 = 4300
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE5 = 4301
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE6 = 4302
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE7 = 4303
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE0 = 4304
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE1 = 4305
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE2 = 4306
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE3 = 4307
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE4 = 4308
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE5 = 4309
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE6 = 4310
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE7 = 4311
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE0 = 4312
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE1 = 4313
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE2 = 4314
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE3 = 4315
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE4 = 4316
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE5 = 4317
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE6 = 4318
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE7 = 4319
    FID_MWIRE_SWITCH_INPUT_TYPE0 = 4320
    FID_MWIRE_SWITCH_OUTPUT_TYPE0 = 4328
    FID_MWIRE_SWITCH_OUTPUT_TYPE1 = 4329
    FID_MWIRE_BLIND_INPUT_TYPE0 = 4336
    FID_MWIRE_BLIND_OUTPUT_TYPE0 = 4344
    FID_MWIRE_BLIND_OUTPUT_TYPE1 = 4345
    FID_MWIRE_MOVEMENT_INPUT_TYPE0 = 4352
    FID_MWIRE_MOVEMENT_OUTPUT_TYPE0 = 4360
    FID_MWIRE_PRESET_INPUT_TYPE0 = 4368
    FID_MWIRE_PRESET_OUTPUT_TYPE0 = 4376
    FID_MWIRE_PRESET_OUTPUT_TYPE1 = 4377
    FID_MWIRE_SWITCH_REMOTE_CONTROL_ROCKER = 4384
    FID_MWIRE_BLIND_REMOTE_CONTROL_ROCKER = 4400
    FID_MWIRE_PRESET_REMOTE_CONTROL_ROCKER = 4416
    FID_MWIRE_DIMMING_INPUT_TYPE0 = 4432
    FID_PRESENCE_DETECTOR_TYPE0 = 4448
    FID_PRESENCE_DETECTOR_TYPE1 = 4449
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE0 = 4464
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE1 = 4465
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE2 = 4466
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE3 = 4467
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE4 = 4468
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE5 = 4469
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE6 = 4470
    FID_LOCK_SENSOR_SENSOR_ROCKER_TYPE7 = 4471
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE0 = 4472
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE1 = 4473
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE2 = 4474
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE3 = 4475
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE4 = 4476
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE5 = 4477
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE6 = 4478
    FID_LOCK_SENSOR_SENSOR_PUSHBUTTON_TYPE7 = 4479
    FID_TEMPERATURE_ADJUSTMENT_SENSOR_ROCKER_TYPE0 = 4480
    FID_TEMPERATURE_ADJUSTMENT_SENSOR_ROCKER_TYPE7 = 4487
    FID_OPERATION_MODE_ADJUSTMENT_SENSOR_ROCKER_TYPE0 = 4496
    FID_OPERATION_MODE_ADJUSTMENT_SENSOR_ROCKER_TYPE7 = 4503
    FID_OPERATION_MODE_ADJUSTMENT_SENSOR_PUSHBUTTON_TYPE2 = 4514
    FID_FAN_STAGE_ADJUSTMENT_SENSOR_ROCKER_TYPE0 = 4528
    FID_FAN_STAGE_ADJUSTMENT_SENSOR_ROCKER_TYPE7 = 4535
    FID_FAN_STAGE_ADJUSTMENT_SENSOR_PUSHBUTTON_TYPE0 = 4536
    FID_FAN_STAGE_ADJUSTMENT_SENSOR_PUSHBUTTON_TYPE7 = 4543
    FID_SWITCH_SENSOR_ROCKER_TYPE8 = 4608
    FID_SWITCH_SENSOR_PUSHBUTTON_TYPE8 = 4609
    FID_DIMMING_SENSOR_ROCKER_TYPE8 = 4610
    FID_DIMMING_SENSOR_PUSHBUTTON_TYPE8 = 4611
    FID_STAIRCASE_LIGHT_SENSOR_ROCKER_TYPE8 = 4612
    FID_STAIRCASE_LIGHT_SENSOR_PUSHBUTTON_TYPE8 = 4613
    FID_SCENE_SENSOR_ROCKER_TYPE8 = 4614
    FID_SCENE_SENSOR_PUSHBUTTON_TYPE8 = 4615
    FID_BLIND_SENSOR_ROCKER_TYPE8 = 4616
    FID_BLIND_SENSOR_PUSHBUTTON_TYPE8 = 4617
    FID_FORCE_ON_OFF_SENSOR_ROCKER_TYPE8 = 4618
    FID_FORCE_ON_OFF_SENSOR_PUSHBUTTON_TYPE8 = 4619
    FID_FORCE_UP_DOWN_SENSOR_ROCKER_TYPE8 = 4620
    FID_FORCE_UP_DOWN_SENSOR_PUSHBUTTON_TYPE8 = 4621
    FID_TIMER_ACTION_SENSOR_ROCKER_TYPE8 = 4622
    FID_TIMER_ACTION_SENSOR_PUSHBUTTON_TYPE8 = 4623
    FID_MEDIA_PLAYBACK_CONTROL_SENSOR_ROCKER_TYPE8 = 4624
    FID_MEDIA_PLAY_PAUSE_SENSOR_PUSHBUTTON_TYPE8 = 4625
    FID_MEDIA_VOLUME_SENSOR_ROCKER_TYPE8 = 4626
    FID_MEDIA_VOLUME_UP_SENSOR_PUSHBUTTON_TYPE8 = 4627
    FID_MEDIA_VOLUME_DOWN_SENSOR_PUSHBUTTON_TYPE8 = 4628
    FID_MEDIA_NEXT_FAVORITE_SENSOR_PUSHBUTTON_TYPE8 = 4629
    FID_MEDIA_NEXT_SONG_SENSOR_PUSHBUTTON_TYPE8 = 4630
    FID_MEDIA_PREVIOUS_SONG_SENSOR_PUSHBUTTON_TYPE8 = 4631
    FID_SWITCH_ACTUATOR_TYPE8 = 6152
    FID_SWITCH_ACTUATOR_TYPE9 = 6153
    FID_SWITCH_ACTUATOR_TYPE10 = 6154
    FID_DIMMING_ACTUATOR_TYPE0 = 6160
    FID_DIMMING_ACTUATOR_TYPE1 = 6161
    FID_DIMMING_ACTUATOR_TYPE2 = 6162
    FID_DIMMING_ACTUATOR_TYPE8 = 6168
    FID_DIMMING_ACTUATOR_TYPE9 = 6169
    FID_BLINDS_ACTUATOR_TYPE0 = 6176
    FID_BLINDS_ACTUATOR_TYPE1 = 6177
    FID_BLINDS_ACTUATOR_TYPE2 = 6178
    FID_BLINDS_ACTUATOR_TYPE3 = 6179
    FID_BLINDS_ACTUATOR_TYPE5 = 6181
    FID_BLINDS_ACTUATOR_TYPE8 = 6184
    FID_E_CONTACT_SWITCH_ACTUATOR_TYPE0 = 6192
    FID_E_CONTACT_SWITCH_ACTUATOR_TYPE1 = 6193
    FID_E_CONTACT_SWITCH_ACTUATOR_TYPE2 = 6194
    FID_VENTILATION_SWITCH_ACTUATOR_TYPE0 = 6208
    FID_PROXY_ROOM_TEMPERATURE_CONTROLLER_TYPE0 = 7168
    FID_HOUSEKEEPING_TYPE0 = 7936
    FID_HOUSEKEEPING_TYPE1 = 7937
    FID_PROXY_CLIENT_TYPE0 = 7938
    FID_HOUSEKEEPING_TYPE2 = 7939
    FID_LIGHT_GROUP = 16384
    FID_BLIND_GROUP = 16385
    FID_DIMMER_GROUP = 16386
    FID_RGB_W_GROUP = 16387
    FID_SACE_BLIND_GROUP = 16388
    FID_SHUTTER_GROUP = 16389
    FID_RGB_GROUP = 16390
    FID_RGBW_GROUP = 16391
    FID_LOCK_SENSOR_GROUP = 16392
    FID_SCENE = 18432
    FID_SPECIAL_SCENE_PANIC = 18433
    FID_SPECIAL_SCENE_ALL_OFF = 18434
    FID_SPECIAL_SCENE_ALL_BLINDS_UP = 18435
    FID_SPECIAL_SCENE_ALL_BLINDS_DOWN = 18436
    FID_TIMER_PROGRAM_SWITCH_ACTUATOR = 18944
    FID_ALERT_SWITCH_ACTUATOR = 18945
    FID_MOVEMENT_DETECTOR_ICON2 = 62970
    FID_DALI_ACTUATOR_ICON = 62971
    FID_SUPER_DEVICE_ICON = 63230
    FID_83221_ICON = 63741
    FID_PILL_DEVICE = 63995
    FID_SU_F_4_0_PB_1_ICON = 64511
    FID_SU_F_2_0_PB_1_ICON = 64767
    FID_PURE_PANEL_DEVICE = 65251
    FID_KEYPAD_DEVICE = 65252
    FID_SIMPLE_ROCKER_DEVICE = 65253
    FID_DIMMER_ROCKER_DEVICE = 65254
    FID_THERMOSTAT_DEVICE = 65255
    FID_CEILING_FAN_DEVICE = 65256
    FID_WEATHER_STATION_DEVICE = 65263
    FID_HUE_DEVICE = 65264
    FID_ACTUATOR_DEVICE = 65275
    FID_MOVEMENT_DETECTOR_DEVICE = 65276
    FID_PANEL_SENSOR = 65277
    FID_REG_DEVICE = 65278
    FID_PANEL_DEVICE = 65279
    FID_RTC_DEVICE = 65280
    FID_ROCKER_SENSOR = 65281
    FID_KEYPAD_ICON = 65508
    FID_SIMPLE_ROCKER_ICON = 65509
    FID_DIMMER_ROCKER_ICON = 65510
    FID_THERMOSTAT_ICON = 65511
    FID_CEILING_FAN_ACTUATOR_ICON = 65512
    FID_MEDIA_PLAYER_ICON = 65513
    FID_WINDOW_SENSOR_ICON = 65514
    FID_BINARY_SENSOR_ICON = 65515
    FID_SOLAR_ICON = 65516
    FID_WEATHER_STATION_ICON = 65517
    FID_HUE_ICON = 65518
    FID_REG_HEATING_ACTUATOR_ICON = 65519
    FID_REG_BINARY_OUTPUT_ICON = 65520
    FID_REG_BINARY_INPUT_ICON = 65521
    FID_REG_SHUTTER_ICON = 65522
    FID_REG_SWITCH_ICON = 65523
    FID_REG_DIMMER_ICON = 65524
    FID_MOVEMENT_DETECTOR_ICON = 65525
    FID_RTC_ICON = 65526
    FID_4_INCH_PANEL_ICON = 65527
    FID_7_INCH_PANEL_ICON = 65528
    FID_PILL_ICON = 65529
    FID_DIN_RAIL_DEVICE_ICON = 65530
    FID_4_PUSH_BUTTON_SENSOR_ICON = 65531
    FID_2_PUSH_BUTTON_SENSOR_ICON = 65532
    FID_2_ROCKER_SWITCH_SENSOR_ICON = 65534
    FID_1_ROCKER_SWITCH_SENSOR_ICON = 65535
    # Functions below this line are custom to this python package
    # as they are not in the official API-documentation
