#
# Copyright 2020 Red Hat, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

IDENTITY_COLS = ("identity/LineItemId", "identity/TimeInterval")

BILL_COLS = (
    "bill/InvoiceId",
    "bill/BillingEntity",
    "bill/BillType",
    "bill/PayerAccountId",
    "bill/BillingPeriodStartDate",
    "bill/BillingPeriodEndDate",
)

LINE_ITEM_COLS = (
    "lineItem/UsageAccountId",
    "lineItem/LineItemType",
    "lineItem/UsageStartDate",
    "lineItem/UsageEndDate",
    "lineItem/ProductCode",
    "lineItem/UsageType",
    "lineItem/Operation",
    "lineItem/AvailabilityZone",
    "lineItem/ResourceId",
    "lineItem/UsageAmount",
    "lineItem/NormalizationFactor",
    "lineItem/NormalizedUsageAmount",
    "lineItem/CurrencyCode",
    "lineItem/UnblendedRate",
    "lineItem/UnblendedCost",
    "lineItem/BlendedRate",
    "lineItem/BlendedCost",
    "lineItem/LineItemDescription",
    "lineItem/TaxType",
)

PRODUCT_COLS = (
    "product/ProductName",
    "product/accountAssistance",
    "product/architecturalReview",
    "product/architectureSupport",
    "product/availability",
    "product/bestPractices",
    "product/caseSeverityresponseTimes",
    "product/clockSpeed",
    "product/comments",
    "product/contentType",
    "product/currentGeneration",
    "product/customerServiceAndCommunities",
    "product/databaseEngine",
    "product/dedicatedEbsThroughput",
    "product/deploymentOption",
    "product/description",
    "product/directorySize",
    "product/directoryType",
    "product/directoryTypeDescription",
    "product/durability",
    "product/ebsOptimized",
    "product/ecu",
    "product/endpointType",
    "product/engineCode",
    "product/enhancedNetworkingSupported",
    "product/feeCode",
    "product/feeDescription",
    "product/fromLocation",
    "product/fromLocationType",
    "product/group",
    "product/groupDescription",
    "product/includedServices",
    "product/instanceFamily",
    "product/instanceType",
    "product/isshadow",
    "product/iswebsocket",
    "product/launchSupport",
    "product/licenseModel",
    "product/location",
    "product/locationType",
    "product/maxIopsBurstPerformance",
    "product/maxIopsvolume",
    "product/maxThroughputvolume",
    "product/maxVolumeSize",
    "product/memory",
    "product/memoryGib",
    "product/messageDeliveryFrequency",
    "product/messageDeliveryOrder",
    "product/minVolumeSize",
    "product/networkPerformance",
    "product/operatingSystem",
    "product/operation",
    "product/operationsSupport",
    "product/origin",
    "product/physicalProcessor",
    "product/preInstalledSw",
    "product/proactiveGuidance",
    "product/processorArchitecture",
    "product/processorFeatures",
    "product/productFamily",
    "product/programmaticCaseManagement",
    "product/protocol",
    "product/provisioned",
    "product/queueType",
    "product/recipient",
    "product/region",
    "product/requestDescription",
    "product/requestType",
    "product/resourceEndpoint",
    "product/routingTarget",
    "product/routingType",
    "product/servicecode",
    "product/sku",
    "product/softwareType",
    "product/storage",
    "product/storageClass",
    "product/storageMedia",
    "product/storageType",
    "product/technicalSupport",
    "product/tenancy",
    "product/thirdpartySoftwareSupport",
    "product/toLocation",
    "product/toLocationType",
    "product/training",
    "product/transferType",
    "product/usagetype",
    "product/vcpu",
    "product/version",
    "product/virtualInterfaceType",
    "product/volumeType",
    "product/whoCanOpenCases",
)

PRICING_COLS = (
    "pricing/LeaseContractLength",
    "pricing/OfferingClass" "pricing/PurchaseOption",
    "pricing/publicOnDemandCost",
    "pricing/publicOnDemandRate",
    "pricing/term",
    "pricing/unit",
)

RESERVE_COLS = (
    "reservation/AvailabilityZone",
    "reservation/NormalizedUnitsPerReservation",
    "reservation/NumberOfReservations",
    "reservation/ReservationARN",
    "reservation/TotalReservedNormalizedUnits",
    "reservation/TotalReservedUnits",
    "reservation/UnitsPerReservation",
)

# TODO: fetch this from boto
REGIONS = (
    ("US East (N. Virginia)", "us-east-1", "us-east-1a", "USE1-EBS"),
    ("US East (N. Virginia)", "us-east-1", "us-east-1b", "USE1-EBS"),
    ("US East (N. Virginia)", "us-east-1", "us-east-1c", "USE1-EBS"),
    ("US East (N. Virginia)", "us-east-1", "us-east-1d", "USE1-EBS"),
    ("US East (N. Virginia)", "us-east-1", "us-east-1e", "USE1-EBS"),
    ("US East (N. Virginia)", "us-east-1", "us-east-1f", "USE1-EBS"),
    ("US West (N. California)", "us-west-1", "us-west-1a", "USW1-EBS"),
    ("US West (N. California)", "us-west-1", "us-west-1b", "USW1-EBS"),
    ("US West (Oregon)", "us-west-2", "us-west-2a", "USW2-EBS"),
    ("US West (Oregon)", "us-west-2", "us-west-2b", "USW2-EBS"),
    ("US West (Oregon)", "us-west-2", "us-west-2c", "USW2-EBS"),
    ("Europe (Stockholm)", "eu-north-1", "eu-north-1a", "EUN1-EBS"),
    ("Europe (Ireland)", "eu-west-1", "eu-west-1a", "EUW1-EBS"),
    ("Europe (Ireland)", "eu-west-1", "eu-west-1b", "EUW1-EBS"),
    ("Europe (Ireland)", "eu-west-1", "eu-west-1c", "EUW1-EBS"),
    ("Europe (Frankfurt)", "eu-central-1", "eu-central-1a", "EUC1-EBS"),
    ("Europe (Frankfurt)", "eu-central-1", "eu-central-1b", "EUC1-EBS"),
    ("Europe (London)", "eu-west-2", "eu-west-2a", "EUW2_EBS"),
    ("Europe (Paris)", "eu-west-3", "eu-west-3a", "EUW3_EBS"),
    ("Europe (Milan)", "eu-south-1", "eu-south-1", "EUN1-EBS"),
    ("Middle East (Bahrain)", "me-south-1", "me-south-1a", "MES1-EBS"),
    ("Asia Pacific (Hong Kong)", "ap-east-1", "ap-east-1a", "APE1-EBS"),
    ("Asia Pacific (Singapore)", "ap-southeast-1", "ap-southeast-1a", "APSE1-EBS"),
    ("Asia Pacific (Singapore)", "ap-southeast-1", "ap-southeast-1b", "APSE1-EBS"),
    ("Asia Pacific (Sydney)", "ap-southeast-2", "ap-southeast-2a", "APSE2-EBS"),
    ("Asia Pacific (Sydney)", "ap-southeast-2", "ap-southeast-2b", "APSE2-EBS"),
    ("Asia Pacific (Sydney)", "ap-southeast-2", "ap-southeast-2c", "APSE2-EBS"),
    ("Asia Pacific (Tokyo)", "ap-northeast-1", "ap-northeast-1a", "APNE1-EBS"),
    ("Asia Pacific (Tokyo)", "ap-northeast-1", "ap-northeast-1c", "APNE1-EBS"),
    ("Asia Pacific (Seoul)", "ap-northeast-2", "ap-northeast-2a", "APNE2-EBS"),
    ("Asia Pacific (Osaka-Local)", "ap-northeast-3", "ap-northeast-3a", "APNE3-EBS"),
    ("China (Beijing)", "cn-north-1", "cn-north-1a", "CNN1-EBS"),
    ("China (Ningxia)", "cn-northwest-1", "cn-northwest-1a", "CNNW1-EBS"),
    ("SA East (Sao Paulo)", "sa-east-1", "sa-east-1a", "SA1-EBS"),
    ("SA East (Sao Paulo)", "sa-east-1", "sa-east-1b", "SA1-EBS"),
    ("SA East (Sao Paulo)", "sa-east-1", "sa-east-1c", "SA1-EBS"),
    ("Asia Pacific (Mumbai)	", "ap-south-1", "ap-south-1a", "APS1-EBS"),
    ("Asia Pacific (Mumbai)	", "ap-south-1", "ap-south-1b", "APS1-EBS"),
    ("Canada (Central)", "ca-central-1", "ca-central-1a", "CAC1-EBS"),
    ("Africa (Cape Town)", "af-south-1", "af-south-1a", "AFS1-EBS"),
    ("AWS GovCloud (US-East)", "us-gov-east-1", "us-gov-east-1a", "USGE1-EBS"),
    ("AWS GovCloud (US)", "us-gov-west-1", "us-gov-west-1a", "USGW1-EBS"),
)

ARCHS = ("32-bit", "64-bit")

# TODO: fetch this from boto
EC2_INSTANCE_TYPES = [
    {
        "inst_type": "m5.large",
        "vcpu": "2",
        "memory": "8 GiB",
        "storage": "EBS Only",
        "family": "General Purpose",
        "cost": "0.096",
        "rate": "0.096",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
    {
        "inst_type": "c5d.2xlarge",
        "vcpu": "8",
        "memory": "16 GiB",
        "storage": "1 x 200 NVMe SSD",
        "family": "Compute Optimized",
        "cost": "0.34",
        "rate": "0.34",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
    {
        "inst_type": "c4.xlarge",
        "vcpu": "4",
        "memory": "7.5 GiB",
        "storage": "EBS-Only",
        "family": "Compute Optimized",
        "cost": "0.199",
        "rate": "0.199",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
    {
        "inst_type": "r4.large",
        "vcpu": "2",
        "memory": "15.25 GiB",
        "storage": "EBS-Only",
        "family": "Memory Optimized",
        "cost": "0.133",
        "rate": "0.133",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
]

# TODO: fetch this from boto
RDS_INSTANCE_TYPES = [
    {
        "inst_type": "db.t3.medium",
        "vcpu": "2",
        "memory": "4 GiB",
        "storage": "EBS-Only",
        "family": "Memory Optimized",
        "cost": "0.072",
        "rate": "0.072",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
    {
        "inst_type": "db.t3.large",
        "vcpu": "2",
        "memory": "8 GiB",
        "storage": "EBS Only",
        "family": "General Purpose",
        "cost": "0.145",
        "rate": "0.145",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
    {
        "inst_type": "db.m5.xlarge",
        "vcpu": "4",
        "memory": "16 GiB",
        "storage": "1 x 200 NVMe SSD",
        "family": "Compute Optimized",
        "cost": "0.356",
        "rate": "0.356",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
    {
        "inst_type": "db.r5.2xlarge",
        "vcpu": "8",
        "memory": "64 GiB",
        "storage": "EBS-Only",
        "family": "Compute Optimized",
        "cost": "1.00",
        "rate": "1.00",
        "desc": "${} per On Demand Linux {} Instance Hour",
    },
]

ROUTE_53_PRODUCTS = ["DNS Zone", "DNS Query"]

ROUTE_53_PRODUCTS_DICT = {
    "DNS Zone": ("DNS Zone", "HostedZone", 0.500000000, 0.500000000),
    "DNS Query": ("DNS Query", "DNS-Queries", 0.000000400, 0.000000400),
}
