function [F,x1,x2]=quadrat(a,b,c,rg,mx,ncnt)
%QUADRAT 3-D plot for a quadratic function
%
%  [F,X1,X2] = QUADRAT(a,b,c,rg,mx)
%
%     1/2 xTax + bTx +c
%
%	  a   - Quadratic matrix (hessian).
%     b   - Linear vector.
%     c   - Scalar offset.
%     rg  - Ranges for two elements of the x vector.
%     mx  - Maximum F value to be plotted.
%     ncnt- Number of contour lines.
%	Returns:
%	  F  - function evaluated on a 3-D grid.
%	  x1 - points along x1 axis.
%	  x2 - points along x2 axis.

%  evaluate the quadratic function

[F,x1,x2]=quadr(a,b,c,rg,mx);


%  clear figures

figure(1)
clf reset
figure(2)
clf reset

figure(1)
set(gcf,'inverthardcopy','off')

%  create the 3-d surface plot

mesh(x1,x2,F)

colormap(gray)
set(gca,'XColor',[0 0 0])
set(gca,'YColor',[0 0 0])
set(gca,'ZColor',[0 0 0])
set(gcf,'Color',[1 1 1])
ch=get(gca,'Children');


  set(ch,'facecolor',[1 1 1])

% set(ch,'facecolor','interp')


set(ch,'edgecolor',[0 0 0])

figure(2)
set(gcf,'inverthardcopy','off')

%  create the contour plot

c=contour(x1,x2,F,ncnt);

set(gca,'XColor',[0 0 0]);
set(gca,'YColor',[0 0 0]);
set(gcf,'Color',[1 1 1]);

%  convert contour colors to grey scale

ch1=get(gca,'Children');
ch = get(ch1,'Children');
for i=1:length(ch),
    set(ch(i),'EdgeColor',zeros(1,3));
%   col = get(ch(i),'Color');
%   if col==([1     1     0])
%     set(ch(i),'color',0*ones(1,3)/7);
%   elseif col==([1     0     1])
%     set(ch(i),'color',0*ones(1,3)/7);
%   elseif col==([0     1     1])
%     set(ch(i),'color',0*ones(1,3)/7);
%   elseif col==([1     0     0])
%     set(ch(i),'color',0*ones(1,3)/7);
%   elseif col==([0     1     0])
%     set(ch(i),'color',0*ones(1,3)/7);
%   elseif col==([0     0     1])
%     set(ch(i),'color',0*ones(1,3)/7);
%   end
end

axis('square')
hold;

%  draw the eigenvectors of the hessian matrix on the contour plot


  [ev,eval]=eig(a);
sol=-pinv(a)*b;
nndrwvec([sol(1) sol(1)+ev(1,1)],[sol(2) sol(2)+ev(2,1)],1,.08,[0 0 1]);
nndrwvec([sol(1) sol(1)+ev(1,2)],[sol(2) sol(2)+ev(2,2)],1,.08,[0 0 1]);
%  h1=line([0 ev(1,1)],[0 ev(2,1)],'LineWidth',2,'Color',[0 0 0]);

%  text('position',[1.2*ev(1,1) 1.2*ev(2,1)],'string','v1','color',[0 0 0], ...
%         'fontname','times','fontsize',[14],'fontweight','bold')
%  h2=line([0 ev(1,2)],[0 ev(2,2)],'LineWidth',2,'Color',[0 0 0]);
%  text('position',[1.2*ev(1,2) 1.2*ev(2,2)],'string','v2','color',[0 0 0], ...
%         'fontname','times','fontsize',[14],'fontweight','bold')



