"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const service_deployment_1 = require("./service-deployment");
class Redis extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        const primary = new service_deployment_1.ServiceDeployment(this, 'primary', {
            image: 'registry.k8s.io/redis:e2e',
            containerPort: 6379,
            externalPort: 6379,
            containerName: 'primary',
            env: { GET_HOSTS_FROM: 'dns' },
            labels: {
                app: 'redis',
                role: 'primary',
                ...options.labels,
            },
        });
        this.primaryHost = primary.host;
        const replicas = options.replicas ?? 2;
        if (replicas > 0) {
            const replica = new service_deployment_1.ServiceDeployment(this, 'replica', {
                image: 'gcr.io/google_samples/gb-redisslave:v1',
                containerName: 'replica',
                containerPort: 6379,
                externalPort: 6379,
                env: { GET_HOSTS_FROM: 'env', REDIS_MASTER_SERVICE_HOST: this.primaryHost },
                replicas: replicas,
                labels: {
                    app: 'redis',
                    role: 'replica',
                    ...options.labels,
                },
            });
            this.replicaHost = replica.host;
        }
        else {
            // if we have no slave, then use the same host as the primary
            this.replicaHost = primary.host;
        }
    }
}
exports.Redis = Redis;
_a = JSII_RTTI_SYMBOL_1;
Redis[_a] = { fqn: "cdk8s-redis.Redis", version: "0.1.575" };
//# sourceMappingURL=data:application/json;base64,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