
complete --command yt-dlp --long-option help --short-option h --description 'Print this help text and exit'
complete --command yt-dlp --long-option version --description 'Print program version and exit'
complete --command yt-dlp --long-option update --short-option U --description 'Update this program to latest version. Make sure that you have sufficient permissions (run with sudo if needed)'
complete --command yt-dlp --long-option ignore-errors --short-option i --description 'Continue on download errors, for example to skip unavailable videos in a playlist (default) (Alias: --no-abort-on-error)'
complete --command yt-dlp --long-option abort-on-error --description 'Abort downloading of further videos if an error occurs (Alias: --no-ignore-errors)'
complete --command yt-dlp --long-option dump-user-agent --description 'Display the current browser identification'
complete --command yt-dlp --long-option list-extractors --description 'List all supported extractors'
complete --command yt-dlp --long-option extractor-descriptions --description 'Output descriptions of all supported extractors'
complete --command yt-dlp --long-option force-generic-extractor --description 'Force extraction to use the generic extractor'
complete --command yt-dlp --long-option default-search --description 'Use this prefix for unqualified URLs. For example "gvsearch2:" downloads two videos from google videos for youtube-dl "large apple". Use the value "auto" to let youtube-dl guess ("auto_warning" to emit a warning when guessing). "error" just throws an error. The default value "fixup_error" repairs broken URLs, but emits an error if this is not possible instead of searching'
complete --command yt-dlp --long-option ignore-config --description 'Disable loading any configuration files except the one provided by --config-location. When given inside a configuration file, no further configuration files are loaded. Additionally, (for backward compatibility) if this option is found inside the system configuration file, the user configuration is not loaded'
complete --command yt-dlp --long-option config-location --description 'Location of the main configuration file; either the path to the config or its containing directory'
complete --command yt-dlp --long-option flat-playlist --description 'Do not extract the videos of a playlist, only list them'
complete --command yt-dlp --long-option flat-videos
complete --command yt-dlp --long-option no-flat-playlist --description 'Extract the videos of a playlist'
complete --command yt-dlp --long-option mark-watched --description 'Mark videos watched (YouTube only)'
complete --command yt-dlp --long-option no-mark-watched --description 'Do not mark videos watched (default)'
complete --command yt-dlp --long-option no-colors --description 'Do not emit color codes in output'
complete --command yt-dlp --long-option proxy --description 'Use the specified HTTP/HTTPS/SOCKS proxy. To enable SOCKS proxy, specify a proper scheme. For example socks5://127.0.0.1:1080/. Pass in an empty string (--proxy "") for direct connection'
complete --command yt-dlp --long-option socket-timeout --description 'Time to wait before giving up, in seconds'
complete --command yt-dlp --long-option source-address --description 'Client-side IP address to bind to'
complete --command yt-dlp --long-option force-ipv4 --short-option 4 --description 'Make all connections via IPv4'
complete --command yt-dlp --long-option force-ipv6 --short-option 6 --description 'Make all connections via IPv6'
complete --command yt-dlp --long-option geo-verification-proxy --description 'Use this proxy to verify the IP address for some geo-restricted sites. The default proxy specified by --proxy (or none, if the option is not present) is used for the actual downloading'
complete --command yt-dlp --long-option cn-verification-proxy
complete --command yt-dlp --long-option geo-bypass --description 'Bypass geographic restriction via faking X-Forwarded-For HTTP header'
complete --command yt-dlp --long-option no-geo-bypass --description 'Do not bypass geographic restriction via faking X-Forwarded-For HTTP header'
complete --command yt-dlp --long-option geo-bypass-country --description 'Force bypass geographic restriction with explicitly provided two-letter ISO 3166-2 country code'
complete --command yt-dlp --long-option geo-bypass-ip-block --description 'Force bypass geographic restriction with explicitly provided IP block in CIDR notation'
complete --command yt-dlp --long-option playlist-start --description 'Playlist video to start at (default is %default)'
complete --command yt-dlp --long-option playlist-end --description 'Playlist video to end at (default is last)'
complete --command yt-dlp --long-option playlist-items --description 'Playlist video items to download. Specify indices of the videos in the playlist separated by commas like: "--playlist-items 1,2,5,8" if you want to download videos indexed 1, 2, 5, 8 in the playlist. You can specify range: "--playlist-items 1-3,7,10-13", it will download the videos at index 1, 2, 3, 7, 10, 11, 12 and 13'
complete --command yt-dlp --long-option match-title --description 'Download only matching titles (regex or caseless sub-string)'
complete --command yt-dlp --long-option reject-title --description 'Skip download for matching titles (regex or caseless sub-string)'
complete --command yt-dlp --long-option max-downloads --description 'Abort after downloading NUMBER files'
complete --command yt-dlp --long-option min-filesize --description 'Do not download any videos smaller than SIZE (e.g. 50k or 44.6m)'
complete --command yt-dlp --long-option max-filesize --description 'Do not download any videos larger than SIZE (e.g. 50k or 44.6m)'
complete --command yt-dlp --long-option date --description 'Download only videos uploaded in this date. The date can be "YYYYMMDD" or in the format "(now|today)[+-][0-9](day|week|month|year)(s)?"'
complete --command yt-dlp --long-option datebefore --description 'Download only videos uploaded on or before this date. The date formats accepted is the same as --date'
complete --command yt-dlp --long-option dateafter --description 'Download only videos uploaded on or after this date. The date formats accepted is the same as --date'
complete --command yt-dlp --long-option min-views --description 'Do not download any videos with less than COUNT views'
complete --command yt-dlp --long-option max-views --description 'Do not download any videos with more than COUNT views'
complete --command yt-dlp --long-option match-filter --description 'Generic video filter. Specify any key (see "OUTPUT TEMPLATE" for a list of available keys) to match if the key is present, !key to check if the key is not present, key>NUMBER (like "view_count > 12", also works with >=, <, <=, !=, =) to compare against a number, key = '"'"'LITERAL'"'"' (like "uploader = '"'"'Mike Smith'"'"'", also works with !=) to match against a string literal and & to require multiple matches. Values which are not known are excluded unless you put a question mark (?) after the operator. For example, to only match videos that have been liked more than 100 times and disliked less than 50 times (or the dislike functionality is not available at the given service), but who also have a description, use --match-filter "like_count > 100 & dislike_count <? 50 & description"'
complete --command yt-dlp --long-option no-match-filter --description 'Do not use generic video filter (default)'
complete --command yt-dlp --long-option no-playlist --description 'Download only the video, if the URL refers to a video and a playlist'
complete --command yt-dlp --long-option yes-playlist --description 'Download the playlist, if the URL refers to a video and a playlist'
complete --command yt-dlp --long-option age-limit --description 'Download only videos suitable for the given age'
complete --command yt-dlp --long-option download-archive --description 'Download only videos not listed in the archive file. Record the IDs of all downloaded videos in it' --require-parameter
complete --command yt-dlp --long-option break-on-existing --description 'Stop the download process when encountering a file that is in the archive'
complete --command yt-dlp --long-option break-on-reject --description 'Stop the download process when encountering a file that has been filtered out'
complete --command yt-dlp --long-option no-download-archive --description 'Do not use archive file (default)'
complete --command yt-dlp --long-option include-ads --description 'Download advertisements as well (experimental)'
complete --command yt-dlp --long-option no-include-ads --description 'Do not download advertisements (default)'
complete --command yt-dlp --long-option concurrent-fragments --short-option N --description 'Number of fragments to download concurrently (default is %default)'
complete --command yt-dlp --long-option limit-rate --short-option r --description 'Maximum download rate in bytes per second (e.g. 50K or 4.2M)'
complete --command yt-dlp --long-option retries --short-option R --description 'Number of retries (default is %default), or "infinite"'
complete --command yt-dlp --long-option fragment-retries --description 'Number of retries for a fragment (default is %default), or "infinite" (DASH, hlsnative and ISM)'
complete --command yt-dlp --long-option skip-unavailable-fragments --description 'Skip unavailable fragments for DASH, hlsnative and ISM (default) (Alias: --no-abort-on-unavailable-fragment)'
complete --command yt-dlp --long-option abort-on-unavailable-fragment --description 'Abort downloading if a fragment is unavailable (Alias: --no-skip-unavailable-fragments)'
complete --command yt-dlp --long-option keep-fragments --description 'Keep downloaded fragments on disk after downloading is finished'
complete --command yt-dlp --long-option no-keep-fragments --description 'Delete downloaded fragments after downloading is finished (default)'
complete --command yt-dlp --long-option buffer-size --description 'Size of download buffer (e.g. 1024 or 16K) (default is %default)'
complete --command yt-dlp --long-option resize-buffer --description 'The buffer size is automatically resized from an initial value of --buffer-size (default)'
complete --command yt-dlp --long-option no-resize-buffer --description 'Do not automatically adjust the buffer size'
complete --command yt-dlp --long-option http-chunk-size --description 'Size of a chunk for chunk-based HTTP downloading (e.g. 10485760 or 10M) (default is disabled). May be useful for bypassing bandwidth throttling imposed by a webserver (experimental)'
complete --command yt-dlp --long-option test
complete --command yt-dlp --long-option playlist-reverse --description 'Download playlist videos in reverse order'
complete --command yt-dlp --long-option no-playlist-reverse --description 'Download playlist videos in default order (default)'
complete --command yt-dlp --long-option playlist-random --description 'Download playlist videos in random order'
complete --command yt-dlp --long-option xattr-set-filesize --description 'Set file xattribute ytdl.filesize with expected file size'
complete --command yt-dlp --long-option hls-prefer-native --description 'Use the native HLS downloader instead of ffmpeg'
complete --command yt-dlp --long-option hls-prefer-ffmpeg --description 'Use ffmpeg instead of the native HLS downloader'
complete --command yt-dlp --long-option hls-use-mpegts --description 'Use the mpegts container for HLS videos; allowing some players to play the video while downloading, and reducing the chance of file corruption if download is interrupted. This is enabled by default for live streams'
complete --command yt-dlp --long-option no-hls-use-mpegts --description 'Do not use the mpegts container for HLS videos. This is default when not downloading live streams'
complete --command yt-dlp --long-option external-downloader --description 'Name or path of the external downloader to use. Currently supports aria2c, avconv, axel, curl, ffmpeg, httpie, wget (Recommended: aria2c)'
complete --command yt-dlp --long-option downloader-args --description 'Give these arguments to the external downloader. Specify the downloader name and the arguments separated by a colon ":". You can use this option multiple times (Alias: --external-downloader-args)'
complete --command yt-dlp --long-option batch-file --short-option a --description 'File containing URLs to download ('"'"'-'"'"' for stdin), one URL per line. Lines starting with '"'"'#'"'"', '"'"';'"'"' or '"'"']'"'"' are considered as comments and ignored' --require-parameter
complete --command yt-dlp --long-option id
complete --command yt-dlp --long-option paths --short-option P --description 'The paths where the files should be downloaded. Specify the type of file and the path separated by a colon ":". All the same types as --output are supported. Additionally, you can also provide "home" and "temp" paths. All intermediary files are first downloaded to the temp path and then the final files are moved over to the home path after download is finished. This option is ignored if --output is an absolute path'
complete --command yt-dlp --long-option output --short-option o --description 'Output filename template, see "OUTPUT TEMPLATE" for details'
complete --command yt-dlp --long-option output-na-placeholder --description 'Placeholder value for unavailable meta fields in output filename template (default: "%default")'
complete --command yt-dlp --long-option autonumber-size
complete --command yt-dlp --long-option autonumber-start --description 'Specify the start value for %(autonumber)s (default is %default)'
complete --command yt-dlp --long-option restrict-filenames --description 'Restrict filenames to only ASCII characters, and avoid "&" and spaces in filenames'
complete --command yt-dlp --long-option no-restrict-filenames --description 'Allow Unicode characters, "&" and spaces in filenames (default)'
complete --command yt-dlp --long-option windows-filenames --description 'Force filenames to be windows compatible'
complete --command yt-dlp --long-option no-windows-filenames --description 'Make filenames windows compatible only if using windows (default)'
complete --command yt-dlp --long-option trim-filenames --description 'Limit the filename length (excluding extension) to the specified number of characters'
complete --command yt-dlp --long-option auto-number --short-option A
complete --command yt-dlp --long-option title --short-option t
complete --command yt-dlp --long-option literal --short-option l
complete --command yt-dlp --long-option no-overwrites --short-option w --description 'Do not overwrite any files'
complete --command yt-dlp --long-option force-overwrites --description 'Overwrite all video and metadata files. This option includes --no-continue'
complete --command yt-dlp --long-option no-force-overwrites --description 'Do not overwrite the video, but overwrite related files (default)'
complete --command yt-dlp --long-option continue --short-option c --description 'Resume partially downloaded files/fragments (default)'
complete --command yt-dlp --long-option no-continue --description 'Do not resume partially downloaded fragments. If the file is unfragmented, restart download of the entire file'
complete --command yt-dlp --long-option part --description 'Use .part files instead of writing directly into output file (default)'
complete --command yt-dlp --long-option no-part --description 'Do not use .part files - write directly into output file'
complete --command yt-dlp --long-option mtime --description 'Use the Last-modified header to set the file modification time (default)'
complete --command yt-dlp --long-option no-mtime --description 'Do not use the Last-modified header to set the file modification time'
complete --command yt-dlp --long-option write-description --description 'Write video description to a .description file'
complete --command yt-dlp --long-option no-write-description --description 'Do not write video description (default)'
complete --command yt-dlp --long-option write-info-json --description 'Write video metadata to a .info.json file (this may contain personal information)'
complete --command yt-dlp --long-option no-write-info-json --description 'Do not write video metadata (default)'
complete --command yt-dlp --long-option write-annotations --description 'Write video annotations to a .annotations.xml file'
complete --command yt-dlp --long-option no-write-annotations --description 'Do not write video annotations (default)'
complete --command yt-dlp --long-option write-playlist-metafiles --description 'Write playlist metadata in addition to the video metadata when using --write-info-json, --write-description etc. (default)'
complete --command yt-dlp --long-option no-write-playlist-metafiles --description 'Do not write playlist metadata when using --write-info-json, --write-description etc.'
complete --command yt-dlp --long-option get-comments --description 'Retrieve video comments to be placed in the .info.json file. The comments are fetched even without this option if the extraction is known to be quick'
complete --command yt-dlp --long-option load-info-json --description 'JSON file containing the video information (created with the "--write-info-json" option)'
complete --command yt-dlp --long-option cookies --description 'File to read cookies from and dump cookie jar in' --require-parameter
complete --command yt-dlp --long-option no-cookies --description 'Do not read/dump cookies (default)'
complete --command yt-dlp --long-option cache-dir --description 'Location in the filesystem where youtube-dl can store some downloaded information permanently. By default $XDG_CACHE_HOME/youtube-dl or ~/.cache/youtube-dl . At the moment, only YouTube player files (for videos with obfuscated signatures) are cached, but that may change'
complete --command yt-dlp --long-option no-cache-dir --description 'Disable filesystem caching'
complete --command yt-dlp --long-option rm-cache-dir --description 'Delete all filesystem cache files'
complete --command yt-dlp --long-option write-thumbnail --description 'Write thumbnail image to disk'
complete --command yt-dlp --long-option no-write-thumbnail --description 'Do not write thumbnail image to disk (default)'
complete --command yt-dlp --long-option write-all-thumbnails --description 'Write all thumbnail image formats to disk'
complete --command yt-dlp --long-option list-thumbnails --description 'Simulate and list all available thumbnail formats'
complete --command yt-dlp --long-option write-link --description 'Write an internet shortcut file, depending on the current platform (.url, .webloc or .desktop). The URL may be cached by the OS'
complete --command yt-dlp --long-option write-url-link --description 'Write a .url Windows internet shortcut. The OS caches the URL based on the file path'
complete --command yt-dlp --long-option write-webloc-link --description 'Write a .webloc macOS internet shortcut'
complete --command yt-dlp --long-option write-desktop-link --description 'Write a .desktop Linux internet shortcut'
complete --command yt-dlp --long-option quiet --short-option q --description 'Activate quiet mode'
complete --command yt-dlp --long-option no-warnings --description 'Ignore warnings'
complete --command yt-dlp --long-option simulate --short-option s --description 'Do not download the video and do not write anything to disk'
complete --command yt-dlp --long-option skip-download --description 'Do not download the video'
complete --command yt-dlp --long-option get-url --short-option g --description 'Simulate, quiet but print URL'
complete --command yt-dlp --long-option get-title --short-option e --description 'Simulate, quiet but print title'
complete --command yt-dlp --long-option get-id --description 'Simulate, quiet but print id'
complete --command yt-dlp --long-option get-thumbnail --description 'Simulate, quiet but print thumbnail URL'
complete --command yt-dlp --long-option get-description --description 'Simulate, quiet but print video description'
complete --command yt-dlp --long-option get-duration --description 'Simulate, quiet but print video length'
complete --command yt-dlp --long-option get-filename --description 'Simulate, quiet but print output filename'
complete --command yt-dlp --long-option get-format --description 'Simulate, quiet but print output format'
complete --command yt-dlp --long-option dump-json --short-option j --description 'Simulate, quiet but print JSON information. See "OUTPUT TEMPLATE" for a description of available keys'
complete --command yt-dlp --long-option dump-single-json --short-option J --description 'Simulate, quiet but print JSON information for each command-line argument. If the URL refers to a playlist, dump the whole playlist information in a single line'
complete --command yt-dlp --long-option print-json --description 'Be quiet and print the video information as JSON (video is still being downloaded)'
complete --command yt-dlp --long-option force-write-archive --description 'Force download archive entries to be written as far as no errors occur,even if -s or another simulation switch is used (Alias: --force-download-archive)'
complete --command yt-dlp --long-option newline --description 'Output progress bar as new lines'
complete --command yt-dlp --long-option no-progress --description 'Do not print progress bar'
complete --command yt-dlp --long-option console-title --description 'Display progress in console titlebar'
complete --command yt-dlp --long-option verbose --short-option v --description 'Print various debugging information'
complete --command yt-dlp --long-option dump-pages --description 'Print downloaded pages encoded using base64 to debug problems (very verbose)'
complete --command yt-dlp --long-option write-pages --description 'Write downloaded intermediary pages to files in the current directory to debug problems'
complete --command yt-dlp --long-option youtube-print-sig-code
complete --command yt-dlp --long-option print-traffic --description 'Display sent and read HTTP traffic'
complete --command yt-dlp --long-option call-home --short-option C
complete --command yt-dlp --long-option no-call-home
complete --command yt-dlp --long-option encoding --description 'Force the specified encoding (experimental)'
complete --command yt-dlp --long-option no-check-certificate --description 'Suppress HTTPS certificate validation'
complete --command yt-dlp --long-option prefer-insecure --description 'Use an unencrypted connection to retrieve information about the video. (Currently supported only for YouTube)'
complete --command yt-dlp --long-option user-agent --description 'Specify a custom user agent'
complete --command yt-dlp --long-option referer --description 'Specify a custom referer, use if the video access is restricted to one domain'
complete --command yt-dlp --long-option add-header --description 'Specify a custom HTTP header and its value, separated by a colon ":". You can use this option multiple times'
complete --command yt-dlp --long-option bidi-workaround --description 'Work around terminals that lack bidirectional text support. Requires bidiv or fribidi executable in PATH'
complete --command yt-dlp --long-option sleep-requests --description 'Number of seconds to sleep between requests during data extraction'
complete --command yt-dlp --long-option sleep-interval --description 'Number of seconds to sleep before each download when used alone or a lower bound of a range for randomized sleep before each download (minimum possible number of seconds to sleep) when used along with --max-sleep-interval'
complete --command yt-dlp --long-option max-sleep-interval --description 'Upper bound of a range for randomized sleep before each download (maximum possible number of seconds to sleep). Must only be used along with --min-sleep-interval'
complete --command yt-dlp --long-option sleep-subtitles --description 'Number of seconds to sleep before each subtitle download'
complete --command yt-dlp --long-option format --short-option f --description 'Video format code, see "FORMAT SELECTION" for more details'
complete --command yt-dlp --long-option format-sort --short-option S --description 'Sort the formats by the fields given, see "Sorting Formats" for more details'
complete --command yt-dlp --long-option format-sort-force --description 'Force user specified sort order to have precedence over all fields, see "Sorting Formats" for more details'
complete --command yt-dlp --long-option no-format-sort-force --description 'Some fields have precedence over the user specified sort order (default), see "Sorting Formats" for more details'
complete --command yt-dlp --long-option video-multistreams --description 'Allow multiple video streams to be merged into a single file'
complete --command yt-dlp --long-option no-video-multistreams --description 'Only one video stream is downloaded for each output file (default)'
complete --command yt-dlp --long-option audio-multistreams --description 'Allow multiple audio streams to be merged into a single file'
complete --command yt-dlp --long-option no-audio-multistreams --description 'Only one audio stream is downloaded for each output file (default)'
complete --command yt-dlp --long-option all-formats --description 'Download all available video formats'
complete --command yt-dlp --long-option prefer-free-formats --description 'Prefer video formats with free containers over non-free ones of same quality. Use with "-S ext" to strictly prefer free containers irrespective of quality'
complete --command yt-dlp --long-option no-prefer-free-formats --description 'Don'"'"'t give any special preference to free containers (default)'
complete --command yt-dlp --long-option list-formats --short-option F --description 'List all available formats of requested videos'
complete --command yt-dlp --long-option list-formats-as-table --description 'Present the output of -F in tabular form (default)'
complete --command yt-dlp --long-option list-formats-old --description 'Present the output of -F in the old form (Alias: --no-list-formats-as-table)'
complete --command yt-dlp --long-option merge-output-format --description 'If a merge is required (e.g. bestvideo+bestaudio), output to given container format. One of mkv, mp4, ogg, webm, flv. Ignored if no merge is required'
complete --command yt-dlp --long-option allow-unplayable-formats --description 'Allow unplayable formats to be listed and downloaded. All video postprocessing will also be turned off'
complete --command yt-dlp --long-option no-allow-unplayable-formats --description 'Do not allow unplayable formats to be listed or downloaded (default)'
complete --command yt-dlp --long-option write-subs --description 'Write subtitle file'
complete --command yt-dlp --long-option no-write-subs --description 'Do not write subtitle file (default)'
complete --command yt-dlp --long-option write-auto-subs --description 'Write automatically generated subtitle file (YouTube only)'
complete --command yt-dlp --long-option no-write-auto-subs --description 'Do not write automatically generated subtitle file (default)'
complete --command yt-dlp --long-option all-subs --description 'Download all the available subtitles of the video'
complete --command yt-dlp --long-option list-subs --description 'List all available subtitles for the video'
complete --command yt-dlp --long-option sub-format --description 'Subtitle format, accepts formats preference, for example: "srt" or "ass/srt/best"'
complete --command yt-dlp --long-option sub-lang --description 'Languages of the subtitles to download (optional) separated by commas, use --list-subs for available language tags'
complete --command yt-dlp --long-option username --short-option u --description 'Login with this account ID'
complete --command yt-dlp --long-option password --short-option p --description 'Account password. If this option is left out, yt-dlp will ask interactively'
complete --command yt-dlp --long-option twofactor --short-option 2 --description 'Two-factor authentication code'
complete --command yt-dlp --long-option netrc --short-option n --description 'Use .netrc authentication data'
complete --command yt-dlp --long-option video-password --description 'Video password (vimeo, youku)'
complete --command yt-dlp --long-option ap-mso --description 'Adobe Pass multiple-system operator (TV provider) identifier, use --ap-list-mso for a list of available MSOs'
complete --command yt-dlp --long-option ap-username --description 'Multiple-system operator account login'
complete --command yt-dlp --long-option ap-password --description 'Multiple-system operator account password. If this option is left out, yt-dlp will ask interactively'
complete --command yt-dlp --long-option ap-list-mso --description 'List all supported multiple-system operators'
complete --command yt-dlp --long-option extract-audio --short-option x --description 'Convert video files to audio-only files (requires ffmpeg and ffprobe)'
complete --command yt-dlp --long-option audio-format --description 'Specify audio format: "best", "aac", "flac", "mp3", "m4a", "opus", "vorbis", or "wav"; "%default" by default; No effect without -x'
complete --command yt-dlp --long-option audio-quality --description 'Specify ffmpeg audio quality, insert a value between 0 (better) and 9 (worse) for VBR or a specific bitrate like 128K (default %default)'
complete --command yt-dlp --long-option remux-video --description 'Remux the video into another container if necessary (currently supported: mp4|mkv|flv|webm|mov|avi|mp3|mka|m4a|ogg|opus). If target container does not support the video/audio codec, remuxing will fail. You can specify multiple rules; eg. "aac>m4a/mov>mp4/mkv" will remux aac to m4a, mov to mp4 and anything else to mkv.' --arguments 'mp4 mkv' --exclusive
complete --command yt-dlp --long-option recode-video --description 'Re-encode the video into another format if re-encoding is necessary. The supported formats are the same as --remux-video' --arguments 'mp4 flv ogg webm mkv' --exclusive
complete --command yt-dlp --long-option postprocessor-args --description 'Give these arguments to the postprocessors. Specify the postprocessor/executable name and the arguments separated by a colon ":" to give the argument to the specified postprocessor/executable. Supported postprocessors are: SponSkrub, ExtractAudio, VideoRemuxer, VideoConvertor, EmbedSubtitle, Metadata, Merger, FixupStretched, FixupM4a, FixupM3u8, SubtitlesConvertor and EmbedThumbnail. The supported executables are: SponSkrub, FFmpeg, FFprobe, and AtomicParsley. You can also specify "PP+EXE:ARGS" to give the arguments to the specified executable only when being used by the specified postprocessor. Additionally, for ffmpeg/ffprobe, "_i"/"_o" can be appended to the prefix optionally followed by a number to pass the argument before the specified input/output file. Eg: --ppa "Merger+ffmpeg_i1:-v quiet". You can use this option multiple times to give different arguments to different postprocessors. (Alias: --ppa)'
complete --command yt-dlp --long-option keep-video --short-option k --description 'Keep the intermediate video file on disk after post-processing'
complete --command yt-dlp --long-option no-keep-video --description 'Delete the intermediate video file after post-processing (default)'
complete --command yt-dlp --long-option post-overwrites --description 'Overwrite post-processed files (default)'
complete --command yt-dlp --long-option no-post-overwrites --description 'Do not overwrite post-processed files'
complete --command yt-dlp --long-option embed-subs --description 'Embed subtitles in the video (only for mp4, webm and mkv videos)'
complete --command yt-dlp --long-option no-embed-subs --description 'Do not embed subtitles (default)'
complete --command yt-dlp --long-option embed-thumbnail --description 'Embed thumbnail in the audio as cover art'
complete --command yt-dlp --long-option no-embed-thumbnail --description 'Do not embed thumbnail (default)'
complete --command yt-dlp --long-option add-metadata --description 'Write metadata to the video file'
complete --command yt-dlp --long-option no-add-metadata --description 'Do not write metadata (default)'
complete --command yt-dlp --long-option metadata-from-title
complete --command yt-dlp --long-option parse-metadata --description 'Parse additional metadata like title/artist from other fields. Give field name to extract data from, and format of the field seperated by a ":". Either regular expression with named capture groups or a similar syntax to the output template can also be used. The parsed parameters replace any existing values and can be use in output template. This option can be used multiple times. Example: --parse-metadata "title:%(artist)s - %(title)s" matches a title like "Coldplay - Paradise". Example (regex): --parse-metadata "description:Artist - (?P<artist>.+?)"'
complete --command yt-dlp --long-option xattrs --description 'Write metadata to the video file'"'"'s xattrs (using dublin core and xdg standards)'
complete --command yt-dlp --long-option fixup --description 'Automatically correct known faults of the file. One of never (do nothing), warn (only emit a warning), detect_or_warn (the default; fix file if we can, warn otherwise)'
complete --command yt-dlp --long-option prefer-avconv
complete --command yt-dlp --long-option prefer-ffmpeg
complete --command yt-dlp --long-option ffmpeg-location --description 'Location of the ffmpeg binary; either the path to the binary or its containing directory'
complete --command yt-dlp --long-option exec --description 'Execute a command on the file after downloading and post-processing, similar to find'"'"'s -exec syntax. Example: --exec '"'"'adb push {} /sdcard/Music/ && rm {}'"'"''
complete --command yt-dlp --long-option convert-subs --description 'Convert the subtitles to other format (currently supported: srt|ass|vtt|lrc)'
complete --command yt-dlp --long-option split-chapters --description 'Split video into multiple files based on internal chapters. The "chapter:" prefix can be used with "--paths" and "--output" to set the output filename for the split files. See "OUTPUT TEMPLATE" for details'
complete --command yt-dlp --long-option no-split-chapters --description 'Do not split video based on chapters (default)'
complete --command yt-dlp --long-option sponskrub --description 'Use sponskrub to mark sponsored sections. This is enabled by default if the sponskrub binary exists (Youtube only)'
complete --command yt-dlp --long-option no-sponskrub --description 'Do not use sponskrub'
complete --command yt-dlp --long-option sponskrub-cut --description 'Cut out the sponsor sections instead of simply marking them'
complete --command yt-dlp --long-option no-sponskrub-cut --description 'Simply mark the sponsor sections, not cut them out (default)'
complete --command yt-dlp --long-option sponskrub-force --description 'Run sponskrub even if the video was already downloaded'
complete --command yt-dlp --long-option no-sponskrub-force --description 'Do not cut out the sponsor sections if the video was already downloaded (default)'
complete --command yt-dlp --long-option sponskrub-location --description 'Location of the sponskrub binary; either the path to the binary or its containing directory'
complete --command yt-dlp --long-option sponskrub-args
complete --command yt-dlp --long-option extractor-retries --description 'Number of retries for known extractor errors (default is %default), or "infinite"'
complete --command yt-dlp --long-option allow-dynamic-mpd --description 'Process dynamic DASH manifests (default) (Alias: --no-ignore-dynamic-mpd)'
complete --command yt-dlp --long-option ignore-dynamic-mpd --description 'Do not process dynamic DASH manifests (Alias: --no-allow-dynamic-mpd)'
complete --command yt-dlp --long-option hls-split-discontinuity --description 'Split HLS playlists to different formats at discontinuities such as ad breaks'
complete --command yt-dlp --long-option no-hls-split-discontinuity --description 'Do not split HLS playlists to different formats at discontinuities such as ad breaks (default)'
complete --command yt-dlp --long-option youtube-include-dash-manifest --description 'Download the DASH manifests and related data on YouTube videos (default) (Alias: --no-youtube-skip-dash-manifest)'
complete --command yt-dlp --long-option youtube-skip-dash-manifest --description 'Do not download the DASH manifests and related data on YouTube videos (Alias: --no-youtube-include-dash-manifest)'
complete --command yt-dlp --long-option youtube-include-hls-manifest --description 'Download the HLS manifests and related data on YouTube videos (default) (Alias: --no-youtube-skip-hls-manifest)'
complete --command yt-dlp --long-option youtube-skip-hls-manifest --description 'Do not download the HLS manifests and related data on YouTube videos (Alias: --no-youtube-include-hls-manifest)'


complete --command yt-dlp --arguments ":ytfavorites :ytrecommended :ytsubscriptions :ytwatchlater :ythistory"
