from django.http import HttpResponse


class PDFResponse(HttpResponse):
    def __init__(self, content, filename=None):
        super(PDFResponse, self).__init__(content_type="application/pdf")
        self["Content-Disposition"] = 'filename="{}"'.format(filename)
        self.write(content)
