import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 */
export interface CfnBrokerProps {
    /**
     * `AWS::AmazonMQ::Broker.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade
     * @external
     */
    readonly autoMinorVersionUpgrade: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.BrokerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername
     * @external
     */
    readonly brokerName: string;
    /**
     * `AWS::AmazonMQ::Broker.DeploymentMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode
     * @external
     */
    readonly deploymentMode: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype
     * @external
     */
    readonly engineType: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion
     * @external
     */
    readonly engineVersion: string;
    /**
     * `AWS::AmazonMQ::Broker.HostInstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype
     * @external
     */
    readonly hostInstanceType: string;
    /**
     * `AWS::AmazonMQ::Broker.PubliclyAccessible`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible
     * @external
     */
    readonly publiclyAccessible: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Users`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users
     * @external
     */
    readonly users: Array<CfnBroker.UserProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.AuthenticationStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy
     * @external
     */
    readonly authenticationStrategy?: string;
    /**
     * `AWS::AmazonMQ::Broker.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration
     * @external
     */
    readonly configuration?: CfnBroker.ConfigurationIdProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.EncryptionOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions
     * @external
     */
    readonly encryptionOptions?: CfnBroker.EncryptionOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.LdapMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapmetadata
     * @external
     */
    readonly ldapMetadata?: CfnBroker.LdapMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.LdapServerMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata
     * @external
     */
    readonly ldapServerMetadata?: CfnBroker.LdapServerMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Logs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs
     * @external
     */
    readonly logs?: CfnBroker.LogListProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.MaintenanceWindowStartTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime
     * @external
     */
    readonly maintenanceWindowStartTime?: CfnBroker.MaintenanceWindowProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups
     * @external
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::AmazonMQ::Broker.StorageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype
     * @external
     */
    readonly storageType?: string;
    /**
     * `AWS::AmazonMQ::Broker.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids
     * @external
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::AmazonMQ::Broker.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags
     * @external
     */
    readonly tags?: CfnBroker.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare class CfnBroker extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::Broker";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBroker;
    /**
     * @external
     * @cloudformationAttribute AmqpEndpoints
     */
    readonly attrAmqpEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ConfigurationId
     */
    readonly attrConfigurationId: string;
    /**
     * @external
     * @cloudformationAttribute ConfigurationRevision
     */
    readonly attrConfigurationRevision: number;
    /**
     * @external
     * @cloudformationAttribute IpAddresses
     */
    readonly attrIpAddresses: string[];
    /**
     * @external
     * @cloudformationAttribute MqttEndpoints
     */
    readonly attrMqttEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute OpenWireEndpoints
     */
    readonly attrOpenWireEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute StompEndpoints
     */
    readonly attrStompEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute WssEndpoints
     */
    readonly attrWssEndpoints: string[];
    /**
     * `AWS::AmazonMQ::Broker.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade
     * @external
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.BrokerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername
     * @external
     */
    brokerName: string;
    /**
     * `AWS::AmazonMQ::Broker.DeploymentMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode
     * @external
     */
    deploymentMode: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype
     * @external
     */
    engineType: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion
     * @external
     */
    engineVersion: string;
    /**
     * `AWS::AmazonMQ::Broker.HostInstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype
     * @external
     */
    hostInstanceType: string;
    /**
     * `AWS::AmazonMQ::Broker.PubliclyAccessible`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible
     * @external
     */
    publiclyAccessible: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Users`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users
     * @external
     */
    users: Array<CfnBroker.UserProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.AuthenticationStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy
     * @external
     */
    authenticationStrategy: string | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration
     * @external
     */
    configuration: CfnBroker.ConfigurationIdProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.EncryptionOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions
     * @external
     */
    encryptionOptions: CfnBroker.EncryptionOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.LdapMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapmetadata
     * @external
     */
    ldapMetadata: CfnBroker.LdapMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.LdapServerMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata
     * @external
     */
    ldapServerMetadata: CfnBroker.LdapServerMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Logs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs
     * @external
     */
    logs: CfnBroker.LogListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.MaintenanceWindowStartTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime
     * @external
     */
    maintenanceWindowStartTime: CfnBroker.MaintenanceWindowProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups
     * @external
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::AmazonMQ::Broker.StorageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype
     * @external
     */
    storageType: string | undefined;
    /**
     * `AWS::AmazonMQ::Broker.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids
     * @external
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AmazonMQ::Broker`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBrokerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html
     * @external
     */
    interface ConfigurationIdProperty {
        /**
         * `CfnBroker.ConfigurationIdProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnBroker.ConfigurationIdProperty.Revision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-revision
         * @external
         */
        readonly revision: number;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html
     * @external
     */
    interface EncryptionOptionsProperty {
        /**
         * `CfnBroker.EncryptionOptionsProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnBroker.EncryptionOptionsProperty.UseAwsOwnedKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-useawsownedkey
         * @external
         */
        readonly useAwsOwnedKey: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-interbrokercred.html
     * @external
     */
    interface InterBrokerCredProperty {
        /**
         * `CfnBroker.InterBrokerCredProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-interbrokercred.html#cfn-amazonmq-broker-interbrokercred-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnBroker.InterBrokerCredProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-interbrokercred.html#cfn-amazonmq-broker-interbrokercred-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapmetadata.html
     * @external
     */
    interface LdapMetadataProperty {
        /**
         * `CfnBroker.LdapMetadataProperty.InterBrokerCreds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapmetadata.html#cfn-amazonmq-broker-ldapmetadata-interbrokercreds
         * @external
         */
        readonly interBrokerCreds?: Array<CfnBroker.InterBrokerCredProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBroker.LdapMetadataProperty.ServerMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapmetadata.html#cfn-amazonmq-broker-ldapmetadata-servermetadata
         * @external
         */
        readonly serverMetadata: CfnBroker.ServerMetadataProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html
     * @external
     */
    interface LdapServerMetadataProperty {
        /**
         * `CfnBroker.LdapServerMetadataProperty.Hosts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-hosts
         * @external
         */
        readonly hosts: string[];
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleBase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolebase
         * @external
         */
        readonly roleBase: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolename
         * @external
         */
        readonly roleName?: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleSearchMatching`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchmatching
         * @external
         */
        readonly roleSearchMatching: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleSearchSubtree`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchsubtree
         * @external
         */
        readonly roleSearchSubtree?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.LdapServerMetadataProperty.ServiceAccountPassword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountpassword
         * @external
         */
        readonly serviceAccountPassword: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.ServiceAccountUsername`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountusername
         * @external
         */
        readonly serviceAccountUsername: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserBase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userbase
         * @external
         */
        readonly userBase: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserRoleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userrolename
         * @external
         */
        readonly userRoleName?: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserSearchMatching`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchmatching
         * @external
         */
        readonly userSearchMatching: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserSearchSubtree`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchsubtree
         * @external
         */
        readonly userSearchSubtree?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html
     * @external
     */
    interface LogListProperty {
        /**
         * `CfnBroker.LogListProperty.Audit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-audit
         * @external
         */
        readonly audit?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.LogListProperty.General`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-general
         * @external
         */
        readonly general?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html
     * @external
     */
    interface MaintenanceWindowProperty {
        /**
         * `CfnBroker.MaintenanceWindowProperty.DayOfWeek`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-dayofweek
         * @external
         */
        readonly dayOfWeek: string;
        /**
         * `CfnBroker.MaintenanceWindowProperty.TimeOfDay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timeofday
         * @external
         */
        readonly timeOfDay: string;
        /**
         * `CfnBroker.MaintenanceWindowProperty.TimeZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timezone
         * @external
         */
        readonly timeZone: string;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html
     * @external
     */
    interface ServerMetadataProperty {
        /**
         * `CfnBroker.ServerMetadataProperty.Hosts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-hosts
         * @external
         */
        readonly hosts: string[];
        /**
         * `CfnBroker.ServerMetadataProperty.RoleBase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolebase
         * @external
         */
        readonly roleBase: string;
        /**
         * `CfnBroker.ServerMetadataProperty.RoleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolename
         * @external
         */
        readonly roleName?: string;
        /**
         * `CfnBroker.ServerMetadataProperty.RoleSearchMatching`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolesearchmatching
         * @external
         */
        readonly roleSearchMatching: string;
        /**
         * `CfnBroker.ServerMetadataProperty.RoleSearchSubtree`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-rolesearchsubtree
         * @external
         */
        readonly roleSearchSubtree?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.ServerMetadataProperty.ServiceAccountPassword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-serviceaccountpassword
         * @external
         */
        readonly serviceAccountPassword: string;
        /**
         * `CfnBroker.ServerMetadataProperty.ServiceAccountUsername`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-serviceaccountusername
         * @external
         */
        readonly serviceAccountUsername: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserBase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-userbase
         * @external
         */
        readonly userBase: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserRoleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-userrolename
         * @external
         */
        readonly userRoleName?: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserSearchMatching`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-usersearchmatching
         * @external
         */
        readonly userSearchMatching: string;
        /**
         * `CfnBroker.ServerMetadataProperty.UserSearchSubtree`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-servermetadata.html#cfn-amazonmq-broker-servermetadata-usersearchsubtree
         * @external
         */
        readonly userSearchSubtree?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html
     * @external
     */
    interface TagsEntryProperty {
        /**
         * `CfnBroker.TagsEntryProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnBroker.TagsEntryProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 */
export declare namespace CfnBroker {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html
     * @external
     */
    interface UserProperty {
        /**
         * `CfnBroker.UserProperty.ConsoleAccess`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-consoleaccess
         * @external
         */
        readonly consoleAccess?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.UserProperty.Groups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-groups
         * @external
         */
        readonly groups?: string[];
        /**
         * `CfnBroker.UserProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnBroker.UserProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * Properties for defining a `AWS::AmazonMQ::Configuration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 * @external
 */
export interface CfnConfigurationProps {
    /**
     * `AWS::AmazonMQ::Configuration.Data`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-data
     * @external
     */
    readonly data: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-enginetype
     * @external
     */
    readonly engineType: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-engineversion
     * @external
     */
    readonly engineVersion: string;
    /**
     * `AWS::AmazonMQ::Configuration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AmazonMQ::Configuration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AmazonMQ::Configuration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-tags
     * @external
     */
    readonly tags?: CfnConfiguration.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::AmazonMQ::Configuration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Configuration
 */
export declare class CfnConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::Configuration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfiguration;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute Revision
     */
    readonly attrRevision: number;
    /**
     * `AWS::AmazonMQ::Configuration.Data`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-data
     * @external
     */
    data: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-enginetype
     * @external
     */
    engineType: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-engineversion
     * @external
     */
    engineVersion: string;
    /**
     * `AWS::AmazonMQ::Configuration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-name
     * @external
     */
    name: string;
    /**
     * `AWS::AmazonMQ::Configuration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AmazonMQ::Configuration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AmazonMQ::Configuration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AmazonMQ::Configuration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::Configuration
 */
export declare namespace CfnConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html
     * @external
     */
    interface TagsEntryProperty {
        /**
         * `CfnConfiguration.TagsEntryProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html#cfn-amazonmq-configuration-tagsentry-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnConfiguration.TagsEntryProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html#cfn-amazonmq-configuration-tagsentry-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::AmazonMQ::ConfigurationAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 * @external
 */
export interface CfnConfigurationAssociationProps {
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Broker`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-broker
     * @external
     */
    readonly broker: string;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-configuration
     * @external
     */
    readonly configuration: CfnConfigurationAssociation.ConfigurationIdProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AmazonMQ::ConfigurationAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::ConfigurationAssociation
 */
export declare class CfnConfigurationAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::ConfigurationAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationAssociation;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Broker`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-broker
     * @external
     */
    broker: string;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-configuration
     * @external
     */
    configuration: CfnConfigurationAssociation.ConfigurationIdProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::AmazonMQ::ConfigurationAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AmazonMQ::ConfigurationAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 * @external
 * @cloudformationResource AWS::AmazonMQ::ConfigurationAssociation
 */
export declare namespace CfnConfigurationAssociation {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html
     * @external
     */
    interface ConfigurationIdProperty {
        /**
         * `CfnConfigurationAssociation.ConfigurationIdProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html#cfn-amazonmq-configurationassociation-configurationid-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnConfigurationAssociation.ConfigurationIdProperty.Revision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html#cfn-amazonmq-configurationassociation-configurationid-revision
         * @external
         */
        readonly revision: number;
    }
}
