/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.PublicClonable;
import com.sas.collection.AVLNode;
import com.sas.util.Comparator;
import com.sas.util.Countable;
import com.sas.util.Enumerable;
import com.sas.util.Util;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class AVLTree
implements Serializable,
PublicClonable,
Enumerable,
Countable {
    static final long serialVersionUID = 90136725763567088L;
    public static final String RB_KEY = "AVLTree.";
    private AVLNode root;
    private AVLNode here;
    private int index;
    private Comparator comparator;
    private boolean duplicatesAllowed;
    private int count;

    public AVLTree() {
        this(null);
    }

    public AVLTree(Comparator comparator) {
        this(comparator, true);
    }

    public AVLTree(Comparator comparator, boolean duplicatesAllowed) {
        this.setComparator(comparator);
        this.setDuplicatesAllowed(duplicatesAllowed);
        this.reset();
    }

    @Override
    public int count() {
        return this.count;
    }

    public void setComparator(Comparator newComparator) {
        if (Util.equal(this.comparator, newComparator)) {
            return;
        }
        this.comparator = newComparator;
        if (this.count() > 0) {
            Enumeration e = this.getItems();
            this.removeAll();
            while (e.hasMoreElements()) {
                this.add(e.nextElement());
            }
        }
    }

    public void removeAll() {
        this.root = null;
        this.count = 0;
        this.reset();
    }

    private void reset() {
        this.here = null;
        this.index = -1;
    }

    public AVLNode root() {
        return this.root;
    }

    public AVLNode firstNode() {
        AVLNode node = this.root();
        if (node == null) {
            return null;
        }
        return node.leftMostDescendent();
    }

    public AVLNode lastNode() {
        AVLNode node = this.root();
        if (node == null) {
            return null;
        }
        return node.rightMostDescendent();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setDuplicatesAllowed(boolean duplicatesAllowed) {
        this.duplicatesAllowed = duplicatesAllowed;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    public void add(Object object) {
        AVLNode newRoot = AVLNode.add(new AVLNode(object), this.root, this.getComparator(), this.isDuplicatesAllowed());
        if (newRoot != null) {
            this.root = newRoot;
            ++this.count;
        }
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object query) {
        return AVLNode.find(this.root, query, this.comparator);
    }

    public synchronized boolean remove(Object object) {
        boolean deleted;
        if (this.root == null) {
            return false;
        }
        AVLNode[] del = AVLNode.remove(this.root, object, this.getComparator(), -1L);
        boolean bl = deleted = del != null;
        if (deleted) {
            this.root = del[0];
            --this.count;
        }
        return deleted;
    }

    @Override
    public Enumeration getItems() {
        return this.getItems(false);
    }

    public Enumeration getItems(int start, int end) {
        if (this.root == null) {
            return new Vector().elements();
        }
        if (start == 0 && end == this.count()) {
            return this.root.getItems(false);
        }
        return this.root.getItems(start, end);
    }

    public AVLNode.Cursor getItems(boolean backwards) {
        if (this.root != null) {
            return this.root.getItems(backwards);
        }
        return new AVLNode.Cursor(null, backwards);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AVLTree clone = (AVLTree)super.clone();
        if (this.root != null) {
            AVLNode[] nodeRef = new AVLNode[2];
            clone.root = this.root.clone(nodeRef);
        }
        clone.reset();
        return clone;
    }
}

