/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.util.macrovar.MacroInfoSourceFacade;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
public abstract class BaseRangeDataType
extends BaseDataType {
    public static final String RANGE_DELIMITER = "--";

    public abstract DataTypeInterface getRangeMinMaxDataType();

    public abstract Object[] getRangeDefaultValue();

    public Object coerceRangeValues(Object min, Object max, Locale locale) {
        Object[] valueHolder = this.getRangeDefaultValue();
        valueHolder[0] = this.getRangeMinMaxDataType().coerceValue(min, locale);
        valueHolder[1] = this.getRangeMinMaxDataType().coerceValue(max, locale);
        return valueHolder;
    }

    public Object getMinimumValue(Object value) {
        Object[] values = (Object[])value;
        if (values.length != 2) {
            throw new IllegalArgumentException("Range value must be an array of length 2.");
        }
        return values[0];
    }

    public Object getMaximumValue(Object value) {
        Object[] values = (Object[])value;
        if (values.length != 2) {
            throw new IllegalArgumentException("Range value must be an array of length 2.");
        }
        return values[1];
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        String stringValue = null;
        if (value instanceof Object[]) {
            String value1 = this.getRangeMinMaxDataType().getValueAsString(((Object[])value)[0], outputLocale);
            String value2 = this.getRangeMinMaxDataType().getValueAsString(((Object[])value)[1], outputLocale);
            stringValue = this.replaceNull(value1) + " " + RANGE_DELIMITER + " " + this.replaceNull(value2);
        } else {
            stringValue = this.getRangeMinMaxDataType().getValueAsString(value, outputLocale);
        }
        return stringValue;
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        String stringValue = null;
        if (value instanceof Object[]) {
            String value1 = this.getRangeMinMaxDataType().getDisplayString(((Object[])value)[0], outputLocale);
            String value2 = this.getRangeMinMaxDataType().getDisplayString(((Object[])value)[1], outputLocale);
            stringValue = this.replaceNull(value1) + " " + RANGE_DELIMITER + " " + this.replaceNull(value2);
        } else {
            stringValue = this.getRangeMinMaxDataType().getDisplayString(value, outputLocale);
        }
        return stringValue;
    }

    protected String replaceNull(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        Object[] rangeValue = (Object[])value;
        HashMap map = new HashMap(2);
        Map minValueMap = this.getRangeMinMaxDataType().getMacroVariableValues(new MacroInfoSourceFacade(macroInfoSource, "_min"), rangeValue[0], locale);
        map.putAll(minValueMap);
        Map maxValueMap = this.getRangeMinMaxDataType().getMacroVariableValues(new MacroInfoSourceFacade(macroInfoSource, "_max"), rangeValue[1], locale);
        map.putAll(maxValueMap);
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        Collection baseExtensions = this.getRangeMinMaxDataType().getPossibleMacroVariableExtensions();
        for (String ext : baseExtensions) {
            extensions.add("_min" + ext);
            extensions.add("_max" + ext);
        }
        this.addExtensions(extensions, new String[]{"_min", "_max"});
        return extensions;
    }

    @Override
    public Map getUnsetMacroVariableValues(MacroVariableOptionInterface macroInfoSource) {
        HashMap<String, String> macros = new HashMap<String, String>(2);
        macros.put(macroInfoSource.getMacroVariableBaseName() + "_min", "");
        macros.put(macroInfoSource.getMacroVariableBaseName() + "_max", "");
        return macros;
    }

    @Override
    protected Map getMacroVariablesForNull(MacroVariableOptionInterface macroInfoSource) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        HashMap<String, String> macros = new HashMap<String, String>(2);
        macros.put(baseMacroVariableName + "_min", "");
        macros.put(baseMacroVariableName + "_max", "");
        return macros;
    }
}

