/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.RB;
import com.sas.util.ValueItem;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

@SASScope
public class IntegerRangeType
extends BaseRangeDataType {
    public static final IntegerRangeType DEFAULT_INSTANCE = new IntegerRangeType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof Integer[] && ((Integer[])inputValue).length == 2) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof int[] && ((int[])inputValue).length == 2) {
            int[] intArray = (int[])inputValue;
            Integer[] values = new Integer[]{new Integer(intArray[0]), new Integer(intArray[1])};
            return values;
        }
        if (inputValue instanceof String) {
            String toDecode = (String)inputValue;
            String[] minMaxValues = toDecode.split("--");
            if (minMaxValues.length == 2) {
                return this.coerceValue(new String[]{minMaxValues[0].trim(), minMaxValues[1].trim()}, inputLocale);
            }
        } else if (inputValue instanceof Object[]) {
            Object[] toDecode = (Object[])inputValue;
            if (toDecode.length == 2) {
                Object upper;
                Integer[] values = new Integer[2];
                Object lower = IntegerType.DEFAULT_INSTANCE.coerceValue(toDecode[0], inputLocale);
                if (lower instanceof Integer) {
                    values[0] = (Integer)lower;
                }
                if ((upper = IntegerType.DEFAULT_INSTANCE.coerceValue(toDecode[1], inputLocale)) instanceof Integer) {
                    values[1] = (Integer)upper;
                }
                return values;
            }
        } else if (inputValue == null) {
            return null;
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("IntegerRangeType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        String[] values = (input = input.trim()).split("--");
        if (values.length != 2) {
            throw new IllegalArgumentException("Unable to convert value to range with 2 values");
        }
        Integer[] returnValue = new Integer[]{(Integer)IntegerType.DEFAULT_INSTANCE.coerceValueFromPersistedString(values[0]), (Integer)IntegerType.DEFAULT_INSTANCE.coerceValueFromPersistedString(values[1])};
        return returnValue;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 4;
    }

    @Override
    public DataTypeInterface getRangeMinMaxDataType() {
        return IntegerType.DEFAULT_INSTANCE;
    }

    @Override
    public Object[] getRangeDefaultValue() {
        return new Integer[2];
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (null != retVal && retVal instanceof Integer[] && retVal == value && ((Integer[])value).length == 2) {
            Integer[] castRetVal = (Integer[])retVal;
            Integer[] copiedRetVal = new Integer[]{castRetVal[0], castRetVal[1]};
            return copiedRetVal;
        }
        return retVal;
    }
}

