/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DateType;
import com.sas.datatypes.RB;
import com.sas.util.DateTypes;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class WeekdayType
extends DateType {
    public static final String RB_KEY = "WeekdayType.";
    public static final WeekdayType DEFAULT_INSTANCE = new WeekdayType();
    public static final WeekdayType DEFAULT_LOCAL_INSTANCE = new WeekdayType(TimeZone.getDefault());

    public WeekdayType() {
    }

    public WeekdayType(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        Object obj = super.coerceValue(inputValue, inputLocale);
        if (obj instanceof Date) {
            Date date = (Date)obj;
            Calendar cal = Calendar.getInstance(inputLocale);
            cal.setFirstDayOfWeek(2);
            cal.setMinimalDaysInFirstWeek(4);
            cal.setTime(date);
            int dayOfWeek = cal.get(7);
            if (dayOfWeek == 7 || dayOfWeek == 1) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notAWeekday.txt", inputLocale));
            }
        }
        return obj;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        return this.getMacroVariableValuesForDatePeriod(DateTypes.WEEKDAY, macroInfoSource, value, locale);
    }

    @Override
    public DateTypes getDateType() {
        return DateTypes.WEEKDAY;
    }
}

