/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class InputStreamAdapter
extends InputStream
implements Serializable {
    static final long serialVersionUID = 4866449630932653718L;
    private RemoteInputStreamInterface rin;

    public InputStreamAdapter(InputStream in) throws RemoteException {
        this(new RemoteInputStream(in));
    }

    public InputStreamAdapter(InputStream in, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this(new RemoteInputStream(in, port, csf, ssf));
    }

    public InputStreamAdapter(RemoteInputStreamInterface rin) {
        this.rin = rin;
    }

    @Override
    public int available() throws IOException {
        return this.rin.available();
    }

    @Override
    public void close() throws IOException {
        this.rin.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.rin.mark(readlimit);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.rin.markSupported();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public int read() throws IOException {
        return this.rin.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        byte[] tempbuf = this.rin.read(b.length);
        if (tempbuf == null) {
            return -1;
        }
        System.arraycopy(tempbuf, 0, b, 0, tempbuf.length);
        return tempbuf.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] tempbuf = this.rin.read(len);
        if (tempbuf == null) {
            return -1;
        }
        System.arraycopy(tempbuf, 0, b, off, tempbuf.length);
        return tempbuf.length;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.rin.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.rin.skip(n);
    }
}

