/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import com.sas.GlobalInfoTable;
import com.sas.util.Strings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class BaseSecuritySupport {
    private static final boolean DEBUG = false;
    public static BaseSecuritySupport securitySupport = null;
    private static final String delimiterDefault = ",";
    private static final String[][] SecurityClassDefaults = new String[][]{{"Sun Microsystems Inc.", "1.4*", "com.sas.security.BaseJDK_1_2_SecuritySupport"}, {"Sun Microsystems Inc.", "1.3*", "com.sas.security.BaseJDK_1_2_SecuritySupport"}, {"Sun Microsystems Inc.", "1.2*", "com.sas.security.BaseJDK_1_2_SecuritySupport"}};

    static BaseSecuritySupport newBaseSecuritySupport() {
        if (securitySupport != null) {
            return securitySupport;
        }
        String vendor = null;
        String version = null;
        try {
            vendor = System.getProperty("java.vendor");
        }
        catch (SecurityException e) {
            version = "unknown";
        }
        try {
            version = System.getProperty("java.version");
        }
        catch (SecurityException e) {
            version = "unknown";
        }
        Vector classes = BaseSecuritySupport.parseSelections();
        securitySupport = BaseSecuritySupport.newBaseSecuritySupport(classes, vendor, version);
        if (securitySupport == null) {
            securitySupport = new BaseSecuritySupport();
        }
        return securitySupport;
    }

    private static Vector parseSelections() {
        Vector<String> list = new Vector<String>();
        Properties classes = new Properties();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.sas.security.BaseSecurityClasses");
            int count = Integer.parseInt(bundle.getString("count"));
            String delimiter = bundle.getString("delimiter");
            list.addElement(delimiter);
            for (int i = 0; i < count; ++i) {
                String key = Integer.toString(i);
                String spec = null;
                try {
                    spec = bundle.getString(key);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                if (spec == null) continue;
                list.addElement(spec);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (list.size() <= 1) {
            list.removeAllElements();
            list.addElement(delimiterDefault);
            for (int i = 0; i < SecurityClassDefaults.length; ++i) {
                String item = SecurityClassDefaults[i][0] + delimiterDefault + SecurityClassDefaults[i][1] + delimiterDefault + SecurityClassDefaults[i][2];
                list.addElement(item);
            }
        }
        return list;
    }

    private static BaseSecuritySupport newBaseSecuritySupport(Vector classes, String vendor, String version) {
        String vers = version;
        BaseSecuritySupport securitySupport = null;
        String delimiter = (String)classes.elementAt(0);
        classes.removeElementAt(0);
        for (int i = 0; i < classes.size(); ++i) {
            String className;
            Class secClass;
            String spec = (String)classes.elementAt(i);
            int pos = spec.lastIndexOf(delimiter);
            String pattern = spec.substring(0, pos);
            String config = vendor + delimiter + vers;
            if (!Strings.match(config, pattern, true) || (secClass = GlobalInfoTable._loadClass(className = spec.substring(pos + delimiter.length(), spec.length()))) == null) continue;
            try {
                securitySupport = (BaseSecuritySupport)secClass.newInstance();
                return securitySupport;
            }
            catch (ClassCastException e) {
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return new BaseSecuritySupport();
    }

    public Object invokeMethod(Method method, Object object, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(object, args);
    }

    public Method getMethod(Class cls, String name, Class[] paramTypes) throws NoSuchMethodException, SecurityException {
        return cls.getMethod(name, paramTypes);
    }

    public Method[] getDeclaredMethods(Class cls) throws SecurityException {
        return cls.getDeclaredMethods();
    }

    public Constructor getConstructor(Class c, Class[] args) throws NoSuchMethodException {
        return c.getConstructor(args);
    }

    public int getMethodModifiers(Member method) {
        return method.getModifiers();
    }

    public String getMethodName(Method method) {
        return method.getName();
    }

    public Class[] getMethodParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    public Class getMethodReturnType(Method method) {
        return method.getReturnType();
    }

    public Class[] getMethodExceptionTypes(Method method) {
        return method.getExceptionTypes();
    }

    public BeanInfo getBeanInfo(Class startClass, Class stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(startClass, stopClass);
    }

    public String getPrivilegedLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public String getProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public void setProperties(Properties properties) {
        System.setProperties(properties);
    }

    public InputStream getResourceAsStream(Class aClass, String resourceName) {
        return aClass.getResourceAsStream(resourceName);
    }

    public URL getResource(Class aClass, String resourceName) {
        return aClass.getResource(resourceName);
    }

    public Thread createThread(Runnable p) {
        if (p instanceof Thread) {
            return (Thread)p;
        }
        return new Thread(p);
    }

    public Object doThreadPrivileged(PrivilegedAction p) {
        return p.run();
    }

    public void stop(Thread thread) {
        thread.stop();
    }

    public void interrupt(Thread thread) {
        thread.interrupt();
    }

    public Socket socketAccept(ServerSocket serverSocket) throws IOException {
        return serverSocket.accept();
    }

    static {
        securitySupport = BaseSecuritySupport.newBaseSecuritySupport();
    }
}

