/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.DateTimeValue;
import com.sas.text.DateValue;
import com.sas.text.FormatDescription;
import com.sas.text.InvalidFormatException;
import com.sas.text.SASFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SASFormatInfo;
import com.sas.text.SingleEntry;
import com.sas.text.TimeValue;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public abstract class SASDateTimeFormat
extends SASFormat {
    protected SASFormatInfo info;
    SimpleDateFormat formatter;
    protected Date date = new Date();
    private StringBuffer valueBuffer = new StringBuffer(32);
    protected FieldPosition position = new FieldPosition(0);
    private static Object[] dateTimeFormat;
    private static FormatDescription[] descriptions;
    public static final long SAS_EPOCH;

    protected SASDateTimeFormat() {
    }

    @Override
    protected void init() {
        this.info = (SASFormatInfo)this.formatInfo;
        if (this.info.isPattern()) {
            if (this.info.getBaseFormat().startsWith("EUR") && !this.isEURformatLocale()) {
                this.formatter = new SimpleDateFormat(this.info.getPattern(), new DateFormatSymbols(Locale.US));
            } else if (this.info.getBaseFormat().equals("NLDATEYW")) {
                this.formatter = new SimpleDateFormat(this.info.getPattern(), this.info.getFormatLocale());
            } else {
                try {
                    this.formatter = new SimpleDateFormat(this.info.getPattern(), new DateFormatSymbols(this.info.getFormatLocale()));
                }
                catch (IllegalArgumentException iae) {
                    this.formatter = new SimpleDateFormat();
                }
            }
        } else {
            this.formatter = new SimpleDateFormat("M/d/yy h:mm a", new DateFormatSymbols(Locale.US));
        }
        this.formatter.setLenient(false);
        this.setTimeZone(timezone);
        this.initCalendar();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (super.format(obj, toAppendTo, pos) == null) {
            if (obj instanceof Number) {
                toAppendTo.append(this.format(((Number)obj).doubleValue()));
            } else if (obj instanceof Date) {
                toAppendTo.append(this.format((Date)obj));
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Date");
            }
        }
        return toAppendTo;
    }

    protected final StringBuffer checkSASDateLimits(double date) {
        StringBuffer result = null;
        if (!this.isDateInLimits(date)) {
            int width = this.info.width;
            result = new StringBuffer(width);
            for (int i = 0; i < width; ++i) {
                result.append('*');
            }
        }
        return result;
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        if (this.info.isPattern()) {
            this.formatter.applyPattern(this.info.getPattern());
            return this.formatter.parseObject(source, status);
        }
        return null;
    }

    public double informat(String formatted) throws UnsupportedOperationException, IllegalArgumentException {
        String baseFormat = this.info.getBaseFormat().toUpperCase();
        if (!(this.info.isPattern() || baseFormat != null && baseFormat.equalsIgnoreCase("TIME"))) {
            throw new UnsupportedOperationException();
        }
        if (baseFormat != null && baseFormat.equalsIgnoreCase("TIME")) {
            try {
                return new SASTimeInformat().informat(formatted);
            }
            catch (ParseException e) {
                throw new UnsupportedOperationException();
            }
        }
        this.formatter.applyPattern(this.info.getPattern());
        Date d = null;
        try {
            d = this.formatter.parse(formatted);
        }
        catch (ParseException x) {
            // empty catch block
        }
        if (d == null) {
            throw new IllegalArgumentException("Cannot informat as a Date: " + formatted);
        }
        double date = this.convertFromJavaDate(d.getTime());
        if (this.isDateFormat() && !this.isDateInLimits(date)) {
            throw new IllegalArgumentException("\n>Error.. The DATE " + formatted + " is out of Range of SAS.< \n" + ">Date should be between 22 Dec 1581 and 26 Dec 20000<");
        }
        if (this.isDateTimeFormat() && !this.isDateInLimits(date)) {
            throw new IllegalArgumentException("\n>Error.. The DATETIME " + formatted + " is out of Range of SAS.< \n" + ">DateTime should be between 22 Dec 1581:00:00:00 and 26 Dec 20000:23:59:59<");
        }
        return date;
    }

    private String getTextPart(String newInformat) {
        String informat = null;
        int numberPart = 0;
        String textPart = null;
        Object message = null;
        StringBuffer charBuffer = new StringBuffer();
        StringBuffer numBuffer = new StringBuffer();
        boolean valid = false;
        if (informat != null) {
            String s = informat.trim();
            if (charBuffer != null && numBuffer != null) {
                charBuffer.setLength(0);
                numBuffer.setLength(0);
                int length = s.length();
                for (int ii = 0; ii < length; ++ii) {
                    char c = s.charAt(ii);
                    if (Character.isDigit(c)) {
                        numBuffer.append(c);
                    }
                    if (!Character.isLetter(c)) continue;
                    charBuffer.append(c);
                }
                textPart = charBuffer.toString();
                try {
                    numberPart = new Double(numBuffer.toString()).intValue();
                }
                catch (NumberFormatException e) {
                    numberPart = -1;
                }
            }
        }
        if (numberPart == -1) {
            valid = false;
        } else {
            int ii = numberPart;
            if (textPart.equalsIgnoreCase("DATETIME") && (ii == 13 || ii == 16 || ii == 18 || ii == 20 || ii == 22)) {
                valid = true;
            } else if (textPart.equalsIgnoreCase("TIME") && (ii == 5 || ii == 8 || ii == 12)) {
                valid = true;
            } else if (textPart.equalsIgnoreCase("DATE") && (ii == 5 || ii == 7 || ii == 9)) {
                valid = true;
            }
        }
        if (!valid) {
            return null;
        }
        return textPart;
    }

    public abstract double convertFromJavaDate(long var1);

    public abstract long convertToJavaDate(double var1);

    protected StringBuffer formatValue(long value, boolean insertBlanks) {
        this.date.setTime(value);
        this.valueBuffer.setLength(0);
        if (this.info.isPattern()) {
            this.formatter.format(this.date, this.valueBuffer, this.position);
            if (insertBlanks) {
                this.insertLeadingBlanks(this.valueBuffer);
            }
        }
        return this.valueBuffer;
    }

    protected StringBuffer formatValue(long value) {
        return this.formatValue(value, true);
    }

    public TimeZone getTimeZone() {
        return this.formatter.getTimeZone();
    }

    public void setTimeZone(TimeZone zone) {
        this.formatter.setTimeZone(zone);
        timezone = zone;
    }

    protected StringBuffer insertTrailingZeros(StringBuffer input, int numOfZeros) {
        int insertIndex;
        for (insertIndex = input.length() - 1; insertIndex > -1 && !Character.isDigit(input.charAt(insertIndex)); --insertIndex) {
        }
        if (insertIndex > -1) {
            ++insertIndex;
            for (int i = 0; i < numOfZeros; ++i) {
                input.insert(insertIndex + i, '0');
            }
        }
        return input;
    }

    public abstract StringBuffer format(double var1);

    public abstract StringBuffer format(Date var1);

    static Object[] getSupportedFormats(Locale locale) {
        Object[] dv = DateValue.getDefinedFormats(locale);
        Object[] dtv = DateTimeValue.getDefinedFormats(locale);
        Object[] tv = TimeValue.getDefinedFormats(locale);
        dateTimeFormat = new Object[dv.length + dtv.length + tv.length];
        int count = 0;
        int i = 0;
        for (i = 0; i < dv.length; ++i) {
            SASDateTimeFormat.dateTimeFormat[count++] = dv[i];
        }
        for (i = 0; i < dtv.length; ++i) {
            SASDateTimeFormat.dateTimeFormat[count++] = dtv[i];
        }
        for (i = 0; i < tv.length; ++i) {
            SASDateTimeFormat.dateTimeFormat[count++] = tv[i];
        }
        Vector<FormatDescription> temp = new Vector<FormatDescription>(dateTimeFormat.length, 20);
        for (i = 0; i < dateTimeFormat.length; ++i) {
            FormatDescription[] fds = ((SASFormatEntry)dateTimeFormat[i]).getFormatDescription();
            for (int j = 0; j < fds.length; ++j) {
                temp.addElement(fds[j]);
            }
        }
        temp.trimToSize();
        descriptions = new FormatDescription[temp.size()];
        temp.copyInto(descriptions);
        temp.removeAllElements();
        return dateTimeFormat;
    }

    public static FormatDescription[] getDescriptions() {
        return descriptions;
    }

    public static long SASDateToJavaDate(double date) {
        long javaDate = ((long)Math.floor(date) - 3653L) * 86400L * 1000L - (long)timezone.getRawOffset();
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTimeInMillis(javaDate);
        return javaDate - (long)cal.get(16);
    }

    public static long SASDateTimeToJavaDate(double datetime) {
        long javaDate = (long)((datetime - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTimeInMillis(javaDate);
        return javaDate - (long)cal.get(16);
    }

    public static long SASTimeToJavaDate(double time) {
        Calendar cal = Calendar.getInstance(timezone);
        long date = (long)(time - 3.156192E8) * 1000L;
        cal.setTimeInMillis(date);
        long javaDate = date - (long)(timezone.getRawOffset() + cal.get(16));
        return javaDate;
    }

    public static double javaDateToSASDate(long date) {
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTimeInMillis(date);
        date = date + (long)timezone.getRawOffset() + (long)cal.get(16);
        return Math.floor((double)date / 8.64E7 + 3653.0);
    }

    public static double javaDateToSASDateTime(long date) {
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTimeInMillis(date);
        date = date + (long)timezone.getRawOffset() + (long)cal.get(16);
        return (double)date / 1000.0 + 3.156192E8;
    }

    public static double javaDateToSASTime(long date) {
        return ((double)date + (double)timezone.getRawOffset()) / 1000.0;
    }

    public static double javaDateToSASTimeWithEpoch(long date) {
        return SASDateTimeFormat.javaDateToSASDateTime(date);
    }

    public static long SASTimeWithEpochToJavaDate(double time) {
        return SASDateTimeFormat.SASDateTimeToJavaDate(time);
    }

    protected StringBuffer formatValueWithQuarter(long javaDate, boolean insertBlanks) {
        SimpleDateFormat sdfMonth = new SimpleDateFormat("MM", Locale.US);
        this.date.setTime(javaDate);
        Integer iMonth = Integer.valueOf(sdfMonth.format(this.date));
        int iQuarter = (int)(iMonth.doubleValue() / 3.0 + 0.67);
        String pattern = this.info.getPattern();
        String strQuarter = null;
        if (pattern.indexOf("QQQ") >= 0) {
            strQuarter = this.info.getEntry().getString("q" + iQuarter);
            pattern = pattern.replace("QQQ", strQuarter);
        } else if (pattern.indexOf("QQ") >= 0) {
            strQuarter = this.info.getEntry().getString("q" + iQuarter + "_s");
            pattern = pattern.replace("QQ", strQuarter);
        }
        String oldpattern = pattern;
        if (pattern.indexOf("''") >= 0) {
            pattern = pattern.replace("''", "");
        }
        try {
            this.formatter.applyPattern(pattern);
        }
        catch (IllegalArgumentException iae) {
            this.formatter.applyPattern(oldpattern);
        }
        this.valueBuffer.setLength(0);
        if (this.info.isPattern()) {
            this.formatter.format(this.date, this.valueBuffer, this.position);
            if (this.valueBuffer.length() > this.info.getWidth()) {
                this.valueBuffer = this.info.getEntry().isUniform() ? this.qtr_order(javaDate, false) : this.valueBuffer.delete(this.info.getWidth(), this.valueBuffer.length());
            }
            if (insertBlanks) {
                this.insertLeadingBlanks(this.valueBuffer);
            }
        }
        return this.valueBuffer;
    }

    protected StringBuffer formatbest(long value) {
        StringBuffer re = null;
        SingleEntry entry = (SingleEntry)this.info.getEntry();
        String pattn = null;
        if (entry.isUniform()) {
            try {
                boolean isSupportDecimal;
                pattn = entry.getPattern(null, this.info.getWidth(), this.info.getDValue());
                if (pattn != null && !(isSupportDecimal = entry.isSupportDecimal(null, this.info.getWidth(), this.info.getDValue()))) {
                    this.info.setDValue(0);
                }
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
        } else {
            pattn = entry.getPattern(0);
        }
        if (pattn != null) {
            if ((this.info.baseFormat.equals("NLDATEWN") || this.info.baseFormat.equals("NLDATMWN")) && pattn.equals("E")) {
                re = this.formatValueWithWeekNumber(value);
            } else {
                this.formatter.applyPattern(pattn);
                re = this.formatValue(value, false);
                if (re.length() > this.info.getWidth() && (pattn = entry.getPattern(3)) != null) {
                    this.formatter.applyPattern(pattn);
                    re = this.formatValue(value, false);
                }
            }
            return re;
        }
        String[] patterns = entry.getPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            this.formatter.applyPattern(patterns[i]);
            re = this.formatValue(value, false);
            if (re.length() <= this.info.getWidth()) break;
        }
        return re;
    }

    protected StringBuffer formatValueWithDayofWeek(long value) {
        StringBuffer re = null;
        SingleEntry entry = (SingleEntry)this.info.getEntry();
        String pattn = null;
        if (entry.isUniform()) {
            try {
                boolean isSupportDecimal;
                pattn = entry.getPattern(null, this.info.getWidth(), this.info.getDValue());
                if (pattn != null && !(isSupportDecimal = entry.isSupportDecimal(null, this.info.getWidth(), this.info.getDValue()))) {
                    this.info.setDValue(0);
                }
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
        } else {
            pattn = entry.getPattern(0);
        }
        if (pattn != null) {
            if (pattn.length() == 1) {
                re = this.formatValueWithWeekNumber(value);
            } else {
                this.formatter.applyPattern(pattn);
                re = this.formatValue(value, false);
                if (re.length() > this.info.getWidth() && (pattn = entry.getPattern(3)) != null) {
                    this.formatter.applyPattern(pattn);
                    re = this.formatValue(value, false);
                }
            }
            return re;
        }
        return re;
    }

    protected void initCalendar() {
        Locale aLocale = this.info.getFormatLocale();
        if (!"java.util.GregorianCalendar".equals(this.formatter.getCalendar().getClass().getName())) {
            this.formatter.setCalendar(new GregorianCalendar(this.getTimeZone(), aLocale));
        }
    }

    public void setFormatTimeZone(TimeZone zone) {
        this.formatter.setTimeZone(zone);
    }

    public static void setDefaultTimeZone(TimeZone zone) {
        timezone = zone;
    }

    protected double javaDateToSASDate(long date, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(date);
        date = date + (long)tz.getRawOffset() + (long)cal.get(16);
        return Math.floor((double)date / 8.64E7 + 3653.0);
    }

    protected double javaDateToSASDateTime(long date, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(date);
        date = date + (long)tz.getRawOffset() + (long)cal.get(16);
        return (double)date / 1000.0 + 3.156192E8;
    }

    protected double javaDateToSASTime(long date, TimeZone tz) {
        return ((double)date + (double)tz.getRawOffset()) / 1000.0;
    }

    protected long SASDateToJavaDate(double date, TimeZone tz) {
        long javaDate = ((long)Math.floor(date) - 3653L) * 86400L * 1000L - (long)tz.getRawOffset();
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(javaDate);
        return javaDate - (long)cal.get(16);
    }

    protected long SASDateTimeToJavaDate(double datetime, TimeZone tz) {
        long javaDate = (long)((datetime - 3.156192E8) * 1000.0 - (double)tz.getRawOffset());
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(javaDate);
        return javaDate - (long)cal.get(16);
    }

    protected long SASTimeToJavaDate(double time, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        long date = (long)(time - 3.156192E8) * 1000L;
        cal.setTimeInMillis(date);
        long javaDate = date - (long)(tz.getRawOffset() + cal.get(16));
        return javaDate;
    }

    protected StringBuffer formatValueWithWeek(long javaDate) {
        StringBuffer result = new StringBuffer();
        int start = 0;
        GregorianCalendar gcal = new GregorianCalendar(this.info.getFormatLocale());
        if (gcal.getFirstDayOfWeek() == 1) {
            this.getWeekNumber(javaDate, true, result, 11, true);
        } else {
            this.getISOWeekNumber(javaDate, result, 11, true);
        }
        String year = result.substring(0, 4);
        String week = result.substring(6, 8);
        try {
            result.setLength(0);
            result.append(this.info.getPattern());
            start = result.indexOf("ww");
            if (start != -1) {
                result.replace(start, start + 2, week);
            }
            int w = (start = result.indexOf("yyyy")) > -1 ? 4 : 2;
            String string = year = w == 4 ? year : year.substring(2, 4);
            if (start == -1) {
                start = result.indexOf("yy");
            }
            result.replace(start, start + w, year);
            this.formatter.applyPattern(result.toString());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        result.setLength(0);
        if (this.info.isPattern()) {
            this.formatter.format(javaDate, result, this.position);
            if (result.length() > this.info.getWidth()) {
                result = result.delete(this.info.getWidth(), result.length());
            }
        }
        return result;
    }

    protected StringBuffer formatValueWithWeekNumber(long date) {
        StringBuffer re = new StringBuffer();
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeZone(TimeZone.getDefault());
        gcal.setFirstDayOfWeek(1);
        gcal.setTimeInMillis(date);
        int weekday = gcal.get(7) - 1;
        if (weekday == 0) {
            weekday = 7;
        }
        re.append(weekday);
        return re;
    }

    protected void getISOWeekNumber(long date, StringBuffer result, int w, boolean dateRequired) {
        int weekday;
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeZone(TimeZone.getDefault());
        gcal.setFirstDayOfWeek(2);
        gcal.setTimeInMillis(date);
        int y = gcal.get(1);
        int m = gcal.get(2);
        int d = gcal.get(5);
        boolean leapYear = gcal.isLeapYear(y);
        boolean lastLeapYear = gcal.isLeapYear(y - 1);
        int doy = gcal.get(6);
        GregorianCalendar jan1 = new GregorianCalendar(y, 0, 1);
        jan1.setTimeZone(TimeZone.getDefault());
        int jan1Weekday = jan1.get(7) - 2 + 1;
        if (jan1Weekday == 0) {
            jan1Weekday = 7;
        }
        if ((weekday = gcal.get(7) - 2 + 1) == 0) {
            weekday = 7;
        }
        int yearNumber = -1;
        int weekNumber = -1;
        if (doy <= 8 - jan1Weekday && jan1Weekday > 4) {
            yearNumber = y - 1;
            weekNumber = jan1Weekday == 5 || jan1Weekday == 6 && lastLeapYear ? 53 : 52;
        } else {
            yearNumber = y;
        }
        if (yearNumber == y) {
            int i = 365;
            if (leapYear) {
                i = 366;
            }
            if (i - doy < 4 - weekday) {
                yearNumber = y + 1;
                weekNumber = 1;
            }
        }
        if (yearNumber == y) {
            int j = doy + (7 - weekday) + (jan1Weekday - 1);
            weekNumber = j / 7;
            if (jan1Weekday > 4) {
                --weekNumber;
            }
        }
        if (!dateRequired) {
            this.buildResultWithoutDate(yearNumber, weekNumber, result, w);
            return;
        }
        String yearString = String.valueOf(yearNumber);
        String weekString = String.valueOf(weekNumber);
        String dowString = String.valueOf(weekday);
        result.setLength(0);
        if (w >= 9) {
            result.append(yearString);
        } else if (w >= 5) {
            result.append(yearString.substring(2));
        }
        if (w >= 11) {
            result.append("-");
        }
        result.append("W");
        if (weekNumber < 10) {
            result.append("0");
        }
        result.append(weekString);
        if (w >= 11) {
            result.append("-");
        }
        if (w >= 7) {
            if (weekday < 10) {
                result.append("0");
            }
            result.append(dowString);
        }
    }

    protected void getWeekNumber(long date, boolean sundayFirst, StringBuffer result, int w, boolean dateRequired) {
        int weekday;
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeZone(TimeZone.getDefault());
        if (sundayFirst) {
            gcal.setFirstDayOfWeek(1);
        } else {
            gcal.setFirstDayOfWeek(2);
        }
        gcal.setTimeInMillis(date);
        int y = gcal.get(1);
        int m = gcal.get(2);
        int d = gcal.get(5);
        boolean leapYear = gcal.isLeapYear(y);
        boolean lastLeapYear = gcal.isLeapYear(y - 1);
        int doy = gcal.get(6);
        GregorianCalendar jan1 = new GregorianCalendar(y, 1, 1);
        int jan1Weekday = jan1.get(7) - (sundayFirst ? 1 : 2) + 1;
        if (jan1Weekday == 0) {
            jan1Weekday = 7;
        }
        if ((weekday = gcal.get(7) - (sundayFirst ? 1 : 2) + 1) == 0) {
            weekday = 7;
        }
        int yearNumber = y;
        int weekNumber = -1;
        if (yearNumber == y) {
            int j = doy + (7 - weekday) + (jan1Weekday - 1);
            weekNumber = j / 7;
            if (jan1Weekday > 4) {
                --weekNumber;
            }
        }
        if (!dateRequired) {
            this.buildResultWithoutDate(yearNumber, weekNumber, result, w);
            return;
        }
        String yearString = String.valueOf(yearNumber);
        String weekString = String.valueOf(weekNumber);
        String dowString = String.valueOf(weekday);
        result.setLength(0);
        if (w >= 9) {
            result.append(yearString);
        } else if (w >= 5) {
            result.append(yearString.substring(2));
        }
        if (w >= 11) {
            result.append("-");
        }
        result.append("W");
        if (weekNumber < 10) {
            result.append("0");
        }
        result.append(weekString);
        if (w >= 11) {
            result.append("-");
        }
        if (w >= 7) {
            if (weekday < 10) {
                result.append("0");
            }
            result.append(dowString);
        }
    }

    protected StringBuffer getDayofWeek(long date) {
        StringBuffer re = new StringBuffer();
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeZone(TimeZone.getDefault());
        gcal.setFirstDayOfWeek(2);
        gcal.setTimeInMillis(date);
        int weekday = gcal.get(7) - 1;
        if (weekday == 0) {
            weekday = 7;
        }
        re.append(weekday);
        return re;
    }

    protected void buildResultWithoutDate(int yearNumber, int weekNumber, StringBuffer result, int w) {
        result.setLength(0);
        if (w >= 7) {
            result.append(yearNumber);
        } else if (w >= 5) {
            String yearString = String.valueOf(yearNumber);
            result.append(yearString.substring(2));
        }
        if (w >= 3) {
            result.append("W");
        }
        if (w >= 2) {
            if (weekNumber < 10) {
                result.append("0");
            }
            result.append(weekNumber);
        }
    }

    public StringBuffer qtr_order(long value, boolean use_roman) {
        int romanl;
        SingleEntry entry = (SingleEntry)this.info.getEntry();
        String yc = null;
        this.date.setTime(value);
        String romanp = null;
        String delim = entry.getDatetimeString("date_sep");
        SimpleDateFormat sdf = new SimpleDateFormat();
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeZone(TimeZone.getDefault());
        gcal.setTimeInMillis(value);
        int dy = gcal.get(1);
        int dm = gcal.get(2);
        int dd = gcal.get(5);
        StringBuffer result = new StringBuffer();
        long im = dm;
        long iq = im / 3L + 1L;
        if (use_roman) {
            if (iq == 4L) {
                romanp = "IV";
                romanl = 2;
            } else {
                romanp = "III";
                romanl = (int)iq;
            }
        } else {
            romanl = 0;
        }
        int digitw = delim.length() + Math.max(romanl, 1);
        long iy = dy;
        int ydigits = 4;
        if (ydigits + digitw > this.getWidth()) {
            ydigits = 2;
            iy %= 100L;
        }
        yc = iy > 9999L && ydigits == 4 ? "****" : String.valueOf(iy);
        if (ydigits == 2 && iy < 10L) {
            yc = "0" + yc;
        }
        digitw += ydigits;
        result.append(yc);
        result.append(delim);
        if (use_roman) {
            result.append(romanp);
        } else {
            result.append("1234".charAt((int)iq - 1));
        }
        if (digitw > this.getWidth()) {
            result.delete(this.getWidth(), result.length());
        } else {
            this.insertLeadingBlanks(result);
        }
        return result;
    }

    static int checkWidth(Locale locale, String pattern, int type) {
        Calendar c = Calendar.getInstance();
        FieldPosition position = new FieldPosition(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        int width = 0;
        StringBuffer valueBuffer = new StringBuffer();
        valueBuffer.setLength(0);
        int size = 0;
        if (type == 2) {
            size = 12;
        } else if (type == 7) {
            size = 7;
        }
        for (int index = 0; index < size; ++index) {
            c.set(type, index);
            valueBuffer.setLength(0);
            simpleDateFormat.format(c.getTime(), valueBuffer, position);
            width = Math.max(width, valueBuffer.length());
        }
        return width;
    }

    static {
        SAS_EPOCH = SASDateTimeFormat.SASDateToJavaDate(0.0);
    }

    final class SASTimeInformat {
        private SimpleDateFormat formatter;
        private String[] patterns;
        private String[] timePatterns = new String[]{"HH:mm", "HH:mm:ss", "HH:mm:ss.SSS"};
        private String userPattern;
        private TimeZone timeZone = new SimpleTimeZone(0, "GMT");
        private int patternIndex;
        private int patternType;
        ParsePosition status;
        private StringBuffer temp = new StringBuffer();

        public SASTimeInformat() {
            this.userPattern = null;
            this.patternIndex = 1;
            this.patternType = 0;
            this.patterns = this.timePatterns;
            this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
            this.formatter.setTimeZone(this.timeZone);
            this.status = new ParsePosition(0);
        }

        public SASTimeInformat(int patternType) {
            this.userPattern = null;
            this.patternType = patternType;
            switch (patternType) {
                default: 
            }
            this.patterns = this.timePatterns;
            this.patternIndex = 1;
            this.formatter = new SimpleDateFormat(this.patterns[this.patternIndex], Locale.US);
            this.formatter.setTimeZone(this.timeZone);
            this.status = new ParsePosition(0);
        }

        public SASTimeInformat(String pattern) {
            this.patternType = -1;
            this.userPattern = pattern;
            this.formatter = new SimpleDateFormat(this.userPattern, Locale.US);
            this.formatter.setTimeZone(this.timeZone);
            this.status = new ParsePosition(0);
        }

        public void setTimeZone(TimeZone newTimeZone) {
            this.formatter.setTimeZone(this.timeZone);
        }

        public TimeZone getTimeZone() {
            return this.formatter.getTimeZone();
        }

        public double informat(String dateString) throws ParseException {
            int index = dateString.indexOf(46);
            String s = this.process(dateString);
            int length = s.length();
            if (this.userPattern == null) {
                int pi = 1;
                pi = length <= 7 ? 0 : (length > 8 && index != -1 ? 2 : (length <= 20 ? 1 : 1));
                if (this.patternIndex != pi) {
                    this.patternIndex = pi;
                    this.formatter.applyPattern(this.patterns[this.patternIndex]);
                }
            }
            this.status.setIndex(0);
            Date date = this.formatter.parse(s, this.status);
            return this.convert(date.getTime());
        }

        private double convert(long javaDateValue) {
            return (double)javaDateValue / 1000.0;
        }

        private String process(String value) {
            String s = value.trim();
            int length = s.length();
            int size = 2;
            this.temp.setLength(0);
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (Character.isDigit(c)) {
                    this.temp.append(c);
                    continue;
                }
                if (Character.isLetter(c)) {
                    this.temp.append(c);
                    continue;
                }
                if (c == ':') {
                    this.temp.append(c);
                    continue;
                }
                if (c != '.') continue;
                this.temp.append(c);
            }
            return this.temp.toString();
        }
    }
}

