/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.MissingValues;
import com.sas.util.ConditionEvaluationInterface;
import com.sas.util.transforms.ObjectToStringTransform;

public abstract class AbstractCondition {
    public static final int OPERATOR_EQ = 1;
    public static final int OPERATOR_GT = 2;
    public static final int OPERATOR_GE = 3;
    public static final int OPERATOR_LT = 4;
    public static final int OPERATOR_LE = 5;
    public static final int OPERATOR_NE = 6;
    public static final int DATATYPE_NUMERIC = 1;
    public static final int DATATYPE_CHARACTER = 2;
    private Object _identifier = null;
    private int _operator = 0;
    private String _leftExpression = null;
    private String _rightExpression = null;

    public Object getIdentifier() {
        return this._identifier;
    }

    public String getLeftExpression() {
        return this._leftExpression;
    }

    public int getOperator() {
        return this._operator;
    }

    public String getRightExpression() {
        return this._rightExpression;
    }

    public void setIdentifier(Object identifier) {
        this._identifier = identifier;
    }

    public void setLeftExpression(String leftExpression) {
        this._leftExpression = leftExpression;
    }

    public void setOperator(int operator) {
        this._operator = operator;
    }

    public void setRightExpression(String rightExpression) {
        this._rightExpression = rightExpression;
    }

    private boolean isNumeric(Object value) {
        boolean numeric = true;
        if (value instanceof String) {
            try {
                String s = (String)ObjectToStringTransform.defaultInstance.transform(value);
                double testConvert = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                numeric = false;
            }
        }
        return numeric;
    }

    protected boolean evaluateCondition(ConditionEvaluationInterface conditionEvaluationInterface, Object[] values) {
        boolean applyFormatting = true;
        if (this._leftExpression != null && this._rightExpression != null) {
            Object lside = null;
            Object rside = null;
            boolean lside_MissingValue = false;
            boolean rside_MissingValue = false;
            int columnIndex = conditionEvaluationInterface.getColumnIndex(this.getLeftExpression());
            int columnType = conditionEvaluationInterface.getColumnType(this.getLeftExpression());
            Object value = values[columnIndex];
            try {
                if (columnType == 1) {
                    applyFormatting = this.isNumeric(value);
                }
                if (applyFormatting) {
                    if (columnType == 1) {
                        if (this.getRightExpression().equals(".")) {
                            rside_MissingValue = true;
                        } else {
                            rside = Double.valueOf(this.getRightExpression());
                        }
                        if (value instanceof MissingValues) {
                            lside_MissingValue = true;
                        } else {
                            lside = Double.valueOf((String)ObjectToStringTransform.defaultInstance.transform(value));
                        }
                    } else if (columnType == 2) {
                        rside = this.getRightExpression();
                        lside = (String)ObjectToStringTransform.defaultInstance.transform(value);
                    }
                }
            }
            catch (ClassCastException e) {
                applyFormatting = false;
            }
            catch (NullPointerException e) {
                applyFormatting = false;
            }
            catch (NumberFormatException e) {
                applyFormatting = false;
            }
            if (applyFormatting) {
                if (lside != null && rside != null) {
                    switch (this.getOperator()) {
                        case 1: {
                            applyFormatting = lside.compareTo(rside) == 0;
                            break;
                        }
                        case 2: {
                            applyFormatting = lside.compareTo(rside) > 0;
                            break;
                        }
                        case 3: {
                            applyFormatting = lside.compareTo(rside) >= 0;
                            break;
                        }
                        case 4: {
                            applyFormatting = lside.compareTo(rside) < 0;
                            break;
                        }
                        case 5: {
                            applyFormatting = lside.compareTo(rside) <= 0;
                            break;
                        }
                        case 6: {
                            applyFormatting = lside.compareTo(rside) != 0;
                            break;
                        }
                        default: {
                            applyFormatting = false;
                            break;
                        }
                    }
                } else if (rside_MissingValue && lside_MissingValue) {
                    boolean equals = false;
                    if (columnType == 1 && MissingValues.Dot.equals(value)) {
                        equals = true;
                    }
                    switch (this.getOperator()) {
                        case 1: 
                        case 3: 
                        case 5: {
                            applyFormatting = equals;
                            break;
                        }
                        case 6: {
                            applyFormatting = !equals;
                            break;
                        }
                        default: {
                            applyFormatting = false;
                            break;
                        }
                    }
                } else {
                    applyFormatting = false;
                }
            }
        } else {
            applyFormatting = false;
        }
        return applyFormatting;
    }

    public abstract Object evaluate(ConditionEvaluationInterface var1, Object[] var2);
}

