/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.GlobalInfoTable;

public class Classes {
    private Classes() {
    }

    public static boolean implementsInterface(Class thisClass, String interfaceName) {
        Class interfaceClass = null;
        try {
            interfaceClass = GlobalInfoTable.loadClass(interfaceName);
            return Classes.implementsInterface(thisClass, interfaceClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean implementsInterface(Class thisClass, Class interfaceClass) {
        return interfaceClass.isInterface() && Classes.implementsInterfaceInternal(thisClass, interfaceClass);
    }

    private static boolean implementsInterfaceInternal(Class thisClass, Class interfaceClass) {
        while (thisClass != null) {
            Class<?>[] interfaces = thisClass.getInterfaces();
            if (interfaces != null) {
                for (int i = 0; i < interfaces.length; ++i) {
                    if (interfaces[i] != interfaceClass && !Classes.implementsInterfaceInternal(interfaces[i], interfaceClass)) continue;
                    return true;
                }
            }
            thisClass = thisClass.getSuperclass();
        }
        return false;
    }

    public static boolean extendsClass(Class thisClass, String className) {
        Class superClass = null;
        try {
            superClass = GlobalInfoTable.loadClass(className);
            return Classes.extendsClass(thisClass, superClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean extendsClass(Class thisClass, Class superClass) {
        while (thisClass != null) {
            if (thisClass == superClass) {
                return true;
            }
            thisClass = thisClass.getSuperclass();
        }
        return false;
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static Class loadClass(String className, ClassLoader loader, Object object) throws ClassNotFoundException {
        if (loader != null) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (object != null && (loader = object instanceof Class ? ((Class)object).getClassLoader() : object.getClass().getClassLoader()) != null) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, ClassLoader.getSystemClassLoader());
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException(className);
            }
        }
    }
}

