/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.RB;
import com.sas.security.sspi.SSPIAuth;
import com.sas.text.Message;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class SASURI {
    public static final String schemeIOM = "IOM";
    public static final String schemeIOMS = "IOMS";
    public static final String schemeOMA = "SAS-OMA";
    @SASScope
    public static final String schemeBRG = "BRIDGE";
    public static final String schemeBRGS = "BRIDGES";
    public static final String protocolBRG = "BRIDGE";
    public static final String protocolINT = "INTERNAL";
    public static final String protocolCOM = "COM";
    public static final String encrLevelEverything = "everything";
    public static final String encrLevelCredentials = "credentials";
    public static final String encrLevelNone = "none";
    @SASScope
    public static final String encryptionContentAll = "all";
    @SASScope
    public static final String encryptionContentAuthentication = "authentication";
    @SASScope
    public static final String encryptionPolicyRequired = "required";
    @SASScope
    public static final String encryptionPolicyOptional = "optional";
    @SASScope
    public static final String encryptionPolicyNone = "none";
    @SASScope
    public static final String transcodingPreferenceClient = "client";
    @SASScope
    public static final String transcodingPreferenceServer = "server";
    public static final String hostKey = "host";
    public static final String portKey = "port";
    public static final String protocolKey = "protocol";
    public static final String majorKey = "major";
    public static final String minorKey = "minor";
    public static final String localeKey = "locale";
    public static final String encrKey = "encr";
    public static final String encrLevelKey = "encrlvl";
    @SASScope
    public static final String debugLevelKey = "debuglevel";
    @SASScope
    public static final String logFileKey = "logfile";
    @SASScope
    public static final String encryptionAlgorithmsKey = "encryptionalgorithms";
    @SASScope
    public static final String encryptionContentKey = "encryptioncontent";
    @SASScope
    public static final String encryptionPolicyKey = "encryptionpolicy";
    @SASScope
    public static final String userNameKey = "username";
    @SASScope
    public static final String passwordKey = "password";
    public static final String userKey = "user";
    public static final String passKey = "pass";
    public static final String classFactoryKey = "classfactory";
    public static final String clsidKey = "clsid";
    @SASScope
    public static final String transcodingPreferenceKey = "transcodingpreference";
    public static final String serverNameKey = "servername";
    public static final String interfaceIIDKey = "interfaceiid";
    public static final String timeoutKey = "timeout";
    public static final String trustedSASKey = "trustedsas";
    public static final String iidKey = "iid";
    public static final String classNameKey = "classname";
    public static final String domainKey = "domain";
    public static final String securityPackageKey = "securitypackage";
    public static final String securityPackageListKey = "securitypackagelist";
    public static final String spnKey = "spn";
    @SASScope
    public static final String connectionIDKey = "connectionid";
    public static final String svidKey = "svid";
    public static final String noRedirectKey = "noredirect";
    public static final String zeroConfigKey = "zeroconfig";
    public static final String applicationNameKey = "applicationname";
    public static final String sasCommandKey = "sascommand";
    public static final String tenantIDKey = "tenantid";
    public static final String proxyListKey = "proxylist";
    public static final String ticketAuthenticationKey = "ticketauthentication";
    public static final String authServiceKey = "authservice";
    @SASScope
    public static final String blot = "xxxxxxxx";
    @SASScope
    public static final String amper = "&";
    @SASScope
    public static final String eql = "=";
    @SASScope
    public static final String hook = "?";
    @SASScope
    public static final String semi = ";";
    @SASScope
    public static final String colon = ":";
    @SASScope
    public static final String slash = "/";
    @SASScope
    public static final String comma = ",";
    @SASScope
    public static final String css = "://";
    @SASScope
    public static final String empty = "";
    @SASScope
    public static final String space = " ";
    @SASScope
    public static final String ubar = "_";
    @SASScope
    public static final String dot = ".";
    @SASScope
    public static final String lParen = "(";
    @SASScope
    public static final String rParen = ")";
    @SASScope
    public static final String lSquare = "[";
    @SASScope
    public static final String rSquare = "]";
    @SASScope
    public static final int iidKeyL = "iid".length();
    @SASScope
    public static final int classNameKeyL = "classname".length();
    @SASScope
    public static final int blotL = "xxxxxxxx".length();
    @SASScope
    public static final int amperL = "&".length();
    @SASScope
    public static final int eqlL = "=".length();
    @SASScope
    public static final int hookL = "?".length();
    @SASScope
    public static final int semiL = ";".length();
    @SASScope
    public static final int colonL = ":".length();
    @SASScope
    public static final int slashL = "/".length();
    @SASScope
    public static final int commaL = ",".length();
    @SASScope
    public static final int cssL = "://".length();
    @SASScope
    public static final int emptyL = "".length();
    @SASScope
    public static final int spaceL = " ".length();
    @SASScope
    public static final int ubarL = "_".length();
    @SASScope
    public static final int dotL = ".".length();
    @SASScope
    public static final int lParenL = "(".length();
    @SASScope
    public static final int rParenL = ")".length();
    @SASScope
    public static final int lSquareL = "[".length();
    @SASScope
    public static final int rSquareL = "]".length();
    private static final String _urlEncoding = "UTF8";
    private static final String[] _iomInvalidAttrNameArr = new String[]{"debuglevel", "logfile", "encryptionalgorithms", "encryptioncontent", "encryptionpolicy", "username", "password", "transcodingpreference", "connectionid"};
    private static final String[] _brgInvalidAttrNameArr = new String[]{"encr", "encrlvl", "user", "pass", "interfaceiid", "iid", "timeout", "classname", "protocol"};
    private static final String[] _schemeEnumArr = new String[]{"BRIDGE", "BRIDGES", "IOM", "IOMS", "SAS-OMA"};
    private static final String[] _protocolEnumArr = new String[]{"BRIDGE", "INTERNAL", "COM"};
    private static final String[] _encryptionPolicyEnumArr = new String[]{"none", "optional", "required"};
    private static final String[] _encryptionContentEnumArr = new String[]{"all", "authentication"};
    private static final String[] _encrLevelEnumArr = new String[]{"everything", "credentials", "none"};
    private static final String[] _transcodingPreferenceEnumArr = new String[]{"client", "server"};
    private static Pattern _localeDelim;
    private static Pattern _listDelim;
    private static Pattern _plusPattern;
    private static Pattern _p20Pattern;
    private String _orig;
    private Map _attributes = new HashMap(32);
    private Map _roAttrs = Collections.unmodifiableMap(this._attributes);
    private String _scheme;
    private boolean _brgURI;

    public SASURI(String str) throws URISyntaxException {
        this();
        this._orig = str.trim();
        this.parse();
    }

    @SASScope
    public SASURI(String scheme, Map attrMap) {
        this();
        SASURI.validateScheme(scheme);
        this.setScheme(scheme);
        attrMap = SASURI.selectAttributes(this._brgURI, attrMap);
        Set attrEntrySet = attrMap.entrySet();
        for (Map.Entry attrEntry : attrEntrySet) {
            String name = (String)attrEntry.getKey();
            Object val = attrEntry.getValue();
            this.addParm(name, val);
        }
    }

    private SASURI() {
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        SASURI thatURI = (SASURI)that;
        Map thatAttrMap = thatURI.getAttributes();
        boolean result = ((Object)this._attributes).equals(thatAttrMap);
        return result;
    }

    public int hashCode() {
        int hc = this.getClass().hashCode();
        return hc ^= ((Object)this._attributes).hashCode();
    }

    public String toString() {
        String str = this._orig != null ? this._orig : SASURI.compose(this._scheme, this._attributes);
        return str;
    }

    public String toBlottedString() {
        String str = this.toString();
        String key = null;
        String delim = null;
        if (!this._brgURI) {
            key = passKey;
            delim = comma;
        } else {
            key = passwordKey;
            delim = amper;
        }
        boolean done = false;
        int passStrt = 0;
        int passStop = 0;
        do {
            int keyx;
            if ((keyx = str.indexOf(key, passStrt)) < 0) {
                return str;
            }
            passStrt = keyx + key.length();
            if (str.indexOf(eql, passStrt) != passStrt) continue;
            passStop = str.indexOf(delim, passStrt += eql.length());
            done = true;
        } while (!done);
        int l = str.length() + blot.length();
        StringBuffer blotBuf = new StringBuffer(l);
        String blotStrt = str.substring(0, passStrt);
        blotBuf.append(blotStrt);
        blotBuf.append(blot);
        if (passStop >= 0) {
            String blotStop = str.substring(passStop);
            blotBuf.append(blotStop);
        }
        String blot = blotBuf.toString();
        return blot;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        String h = (String)this._attributes.get(hostKey);
        return h;
    }

    public int getPort() {
        Integer _port = (Integer)this._attributes.get(portKey);
        int port = _port != null ? _port : -1;
        return port;
    }

    public Integer getPortNumber() {
        Integer portNumber = (Integer)this._attributes.get(portKey);
        return portNumber;
    }

    public String getProtocol() {
        return (String)this._attributes.get(protocolKey);
    }

    public byte getMajor() {
        Byte _major = (Byte)this._attributes.get(majorKey);
        byte major = _major != null ? (byte)_major : (byte)-1;
        return major;
    }

    public byte getMinor() {
        Byte _minor = (Byte)this._attributes.get(minorKey);
        byte minor = _minor != null ? (byte)_minor : (byte)-1;
        return minor;
    }

    public Locale getLocale() {
        return (Locale)this._attributes.get(localeKey);
    }

    public String getEncrLevel() {
        return (String)this._attributes.get(encrLevelKey);
    }

    @SASScope
    public String getEncryptionContent() {
        return (String)this._attributes.get(encryptionContentKey);
    }

    public String getEncr() {
        return (String)this._attributes.get(encrKey);
    }

    @SASScope
    public String getEncryptionAlgorithms() {
        return (String)this._attributes.get(encryptionAlgorithmsKey);
    }

    @SASScope
    public String getEncryptionPolicy() {
        return (String)this._attributes.get(encryptionPolicyKey);
    }

    @SASScope
    public int getDebugLevel() {
        Integer _dl = (Integer)this._attributes.get(debugLevelKey);
        int dl = _dl != null ? _dl : 0;
        return dl;
    }

    @SASScope
    public String getLogFileName() {
        return (String)this._attributes.get(logFileKey);
    }

    public String getUser() {
        return (String)this._attributes.get(userKey);
    }

    @SASScope
    public String getUserName() {
        return (String)this._attributes.get(userNameKey);
    }

    public String getPass() {
        return (String)this._attributes.get(passKey);
    }

    @SASScope
    public String getPassword() {
        return (String)this._attributes.get(passwordKey);
    }

    public String getClassFactory() {
        return (String)this._attributes.get(classFactoryKey);
    }

    public String getClsid() {
        return (String)this._attributes.get(clsidKey);
    }

    @SASScope
    public String getTranscodingPreference() {
        return (String)this._attributes.get(transcodingPreferenceKey);
    }

    public String getServerName() {
        return (String)this._attributes.get(serverNameKey);
    }

    public String getInterfaceIID() {
        return (String)this._attributes.get(interfaceIIDKey);
    }

    public String getIID() {
        return (String)this._attributes.get(iidKey);
    }

    public int getTimeout() {
        Integer _to = (Integer)this._attributes.get(timeoutKey);
        int to = _to != null ? _to : -1;
        return to;
    }

    public boolean isTrustedSAS() {
        Boolean _ts = (Boolean)this._attributes.get(trustedSASKey);
        boolean ts = _ts != null ? _ts : false;
        return ts;
    }

    public String getClassName() {
        return (String)this._attributes.get(classNameKey);
    }

    public String getSecurityPackage() {
        return (String)this._attributes.get(securityPackageKey);
    }

    public String getSecurityPackageList() {
        return (String)this._attributes.get(securityPackageListKey);
    }

    public String getSPN() {
        return (String)this._attributes.get(spnKey);
    }

    public String getDomain() {
        return (String)this._attributes.get(domainKey);
    }

    @SASScope
    public String getConnectionID() {
        return (String)this._attributes.get(connectionIDKey);
    }

    public String getSVID() {
        return (String)this._attributes.get(svidKey);
    }

    public boolean isNoRedirect() {
        Boolean _ts = (Boolean)this._attributes.get(noRedirectKey);
        boolean ts = _ts != null ? _ts : false;
        return ts;
    }

    public boolean isZeroConfig() {
        Boolean _ts = (Boolean)this._attributes.get(zeroConfigKey);
        boolean ts = _ts != null ? _ts : false;
        return ts;
    }

    public String getApplicationName() {
        return (String)this._attributes.get(applicationNameKey);
    }

    public String getSasCommand() {
        return (String)this._attributes.get(sasCommandKey);
    }

    public String getTenantID() {
        return (String)this._attributes.get(tenantIDKey);
    }

    public String getProxyList() {
        return (String)this._attributes.get(proxyListKey);
    }

    public boolean isTicketAuthentication() {
        Boolean taBool = (Boolean)this._attributes.get(ticketAuthenticationKey);
        boolean ta = taBool != null ? taBool : false;
        return ta;
    }

    public String getAuthService() {
        return (String)this._attributes.get(authServiceKey);
    }

    public Map getAttributes() {
        return this._roAttrs;
    }

    public Map getAttributesForScheme(String scheme) {
        SASURI.validateScheme(scheme);
        boolean brgUri = "BRIDGE".equals(scheme);
        Map attrMap = SASURI.selectAttributes(brgUri, this._attributes);
        return attrMap;
    }

    @SASScope
    public static Object normalizeAttribute(String name, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String valS = (String)value;
        String nrm = null;
        if (classFactoryKey.equals(name) || clsidKey.equals(name) || interfaceIIDKey.equals(name) || iidKey.equals(name) || transcodingPreferenceKey.equals(name) || encryptionPolicyKey.equals(name) || encrLevelKey.equals(name)) {
            nrm = valS.toLowerCase(Locale.US);
        } else if (encryptionContentKey.equals(name)) {
            nrm = valS.toLowerCase(Locale.US);
            if (encrLevelEverything.equals(nrm)) {
                nrm = encryptionContentAll;
            } else if (encrLevelCredentials.equals(nrm)) {
                nrm = encryptionContentAuthentication;
            }
        } else if (encrKey.equals(name) || encryptionAlgorithmsKey.equals(name)) {
            Pattern delim = SASURI.getListDelim();
            String[] encrArr = delim.split(valS);
            int valSL = valS.length();
            StringBuffer buf = new StringBuffer(valSL);
            for (int i = 0; i < encrArr.length; ++i) {
                String rawEncr = encrArr[i];
                if (rawEncr == null || rawEncr.length() <= 0) continue;
                String nrmEncr = rawEncr.toUpperCase(Locale.US);
                buf.append(nrmEncr).append(comma);
            }
            int bufL = buf.length();
            if (bufL > 0) {
                buf.setLength(bufL - 1);
            }
            nrm = buf.toString();
        } else {
            nrm = securityPackageKey.equals(name) ? SSPIAuth.normalizeSecurityPackage((String)valS) : (securityPackageListKey.equals(name) ? SSPIAuth.normalizeSecurityPackageList((String)valS) : (protocolKey.equals(name) ? valS.toUpperCase(Locale.US) : valS));
        }
        return nrm;
    }

    public static void updateAttribute(String name, Object value, Map attrMap) {
        try {
            SASURI.validateParm(name, value, 0, null);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
        SASURI.updateParm(name, value, attrMap);
        if (classFactoryKey.equals(name)) {
            SASURI.updateParm(clsidKey, value, attrMap);
        } else if (clsidKey.equals(name)) {
            SASURI.updateParm(classFactoryKey, value, attrMap);
        } else if (userKey.equals(name)) {
            SASURI.updateParm(userNameKey, value, attrMap);
        } else if (passKey.equals(name)) {
            SASURI.updateParm(passwordKey, value, attrMap);
        } else if (encrKey.equals(name)) {
            SASURI.updateParm(encryptionAlgorithmsKey, value, attrMap);
        } else if (encrLevelKey.equals(name)) {
            if (encrLevelEverything.equals(value)) {
                SASURI.updateParm(encryptionPolicyKey, encryptionPolicyRequired, attrMap);
                SASURI.updateParm(encryptionContentKey, encryptionContentAll, attrMap);
            } else if (encrLevelCredentials.equals(value)) {
                SASURI.updateParm(encryptionPolicyKey, encryptionPolicyRequired, attrMap);
                SASURI.updateParm(encryptionContentKey, encryptionContentAuthentication, attrMap);
            } else {
                SASURI.updateParm(encryptionPolicyKey, "none", attrMap);
            }
        } else if (interfaceIIDKey.equals(name)) {
            SASURI.updateParm(iidKey, value, attrMap);
        } else if (iidKey.equals(name)) {
            SASURI.updateParm(interfaceIIDKey, value, attrMap);
        } else if (encryptionAlgorithmsKey.equals(name)) {
            SASURI.updateParm(encrKey, value, attrMap);
        } else if (encryptionContentKey.equals(name)) {
            boolean policyNone;
            String policy = (String)attrMap.get(encryptionPolicyKey);
            boolean bl = policyNone = policy == null || "none".equals(policy);
            String encrLevel = policyNone ? "none" : (encryptionContentAll.equals(value) ? encrLevelEverything : encrLevelCredentials);
            SASURI.updateParm(encrLevelKey, encrLevel, attrMap);
        } else if (encryptionPolicyKey.equals(name)) {
            String content;
            String encrLevel = null;
            encrLevel = "none".equals(value) ? "none" : ((content = (String)attrMap.get(encryptionContentKey)) == null || encryptionContentAll.equals(content) ? encrLevelEverything : encrLevelCredentials);
            SASURI.updateParm(encrLevelKey, encrLevel, attrMap);
        } else if (userNameKey.equals(name)) {
            SASURI.updateParm(userKey, value, attrMap);
        } else if (passwordKey.equals(name)) {
            SASURI.updateParm(passKey, value, attrMap);
        }
    }

    @SASScope
    public static String urlEncode(String plain) {
        try {
            String pre = URLEncoder.encode(plain, _urlEncoding);
            Pattern plusPattern = SASURI.getPlusPattern();
            Matcher plusMatcher = plusPattern.matcher(pre);
            String post = plusMatcher.replaceAll("%20");
            return post;
        }
        catch (UnsupportedEncodingException uee) {
            UnsupportedCharsetException uce = new UnsupportedCharsetException(_urlEncoding);
            uce.initCause(uee);
            throw uce;
        }
    }

    @SASScope
    public static String urlDecode(String enc) {
        try {
            Pattern p20Pattern = SASURI.getP20Pattern();
            Matcher p20Matcher = p20Pattern.matcher(enc);
            String pre = p20Matcher.replaceAll("+");
            return URLDecoder.decode(pre, _urlEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            UnsupportedCharsetException uce = new UnsupportedCharsetException(_urlEncoding);
            uce.initCause(uee);
            throw uce;
        }
    }

    @SASScope
    public static Locale parseLocaleName(String localeName) {
        Pattern delim = SASURI.getLocaleDelim();
        String[] localeArray = delim.split(localeName, 3);
        Locale locale = null;
        locale = localeArray.length == 1 ? new Locale(localeArray[0]) : (localeArray.length == 2 ? new Locale(localeArray[0], localeArray[1]) : new Locale(localeArray[0], localeArray[1], localeArray[2]));
        return locale;
    }

    public static SASURI create(String str) {
        SASURI uri = null;
        try {
            uri = new SASURI(str);
        }
        catch (URISyntaxException use) {
            IllegalArgumentException iae = new IllegalArgumentException(use);
            throw iae;
        }
        return uri;
    }

    @SASScope
    public static String compose(String scheme, Map attrMap) {
        String schemeU = scheme.toUpperCase(Locale.US);
        SASURI.validateScheme(scheme);
        boolean brgURI = "BRIDGE".equals(schemeU) || schemeBRGS.equals(schemeU);
        attrMap = SASURI.selectAttributes(brgURI, attrMap);
        int bufL = scheme.length();
        bufL += cssL;
        String host = (String)attrMap.remove(hostKey);
        if (host != null) {
            bufL += host.length();
            bufL += lSquareL + rSquareL;
        }
        Integer port = (Integer)attrMap.remove(portKey);
        String portS = null;
        if (port != null) {
            portS = port.toString();
            bufL += colonL;
            bufL += portS.length();
        }
        bufL += slashL;
        String classID = null;
        String protocol = null;
        String attrDelim = null;
        if (brgURI) {
            attrDelim = amper;
            bufL += hookL;
            classID = (String)attrMap.remove(classFactoryKey);
            String altClassID = (String)attrMap.remove(clsidKey);
            if (classID == null) {
                classID = altClassID;
            }
            if (classID != null) {
                bufL += classID.length();
            }
        } else {
            attrDelim = comma;
            bufL += semiL * 2;
            protocol = (String)attrMap.remove(protocolKey);
            if (protocol != null) {
                bufL += protocol.length();
            }
        }
        int attrMapL = attrMap.size();
        HashMap<String, String> encodedAttrMap = new HashMap<String, String>(attrMapL);
        Set attrEntrySet = attrMap.entrySet();
        for (Map.Entry attrEntry : attrEntrySet) {
            String key = (String)attrEntry.getKey();
            Object val = attrEntry.getValue();
            String valE = null;
            if (val instanceof Boolean) {
                if (!((Boolean)val).booleanValue()) {
                    continue;
                }
            } else {
                String valS = val.toString();
                valE = SASURI.urlEncode(valS);
            }
            String keyE = SASURI.urlEncode(key);
            encodedAttrMap.put(keyE, valE);
            bufL += attrDelim.length();
            bufL += keyE.length();
            if (valE == null) continue;
            bufL += eqlL;
            bufL += valE.length();
        }
        StringBuffer buf = new StringBuffer(bufL);
        buf.append(scheme).append(css);
        if (host != null) {
            boolean ipv6Literal;
            boolean bl = ipv6Literal = host.indexOf(colon) >= 0;
            if (ipv6Literal) {
                buf.append(lSquare);
            }
            buf.append(host);
            if (ipv6Literal) {
                buf.append(rSquare);
            }
        }
        if (portS != null) {
            buf.append(colon).append(portS);
        }
        int encodedAttrMapL = encodedAttrMap.size();
        if (brgURI) {
            buf.append(slash);
            if (classID != null) {
                buf.append(classID);
            }
            if (encodedAttrMapL > 0) {
                buf.append(hook);
            }
        } else {
            buf.append(semi);
            if (protocol != null) {
                buf.append(protocol);
            }
            buf.append(semi);
        }
        if (encodedAttrMapL > 0) {
            Set encodedAttrEntrySet = encodedAttrMap.entrySet();
            for (Map.Entry encodedAttrEntry : encodedAttrEntrySet) {
                String keyE = (String)encodedAttrEntry.getKey();
                buf.append(keyE);
                String valE = (String)encodedAttrEntry.getValue();
                if (valE != null) {
                    buf.append(eql).append(valE);
                }
                buf.append(attrDelim);
            }
            int strL = buf.length();
            buf.setLength(strL - 1);
        }
        if (!brgURI) {
            buf.append(slash);
        }
        String str = buf.toString();
        return str;
    }

    private void setScheme(String scheme) {
        this._scheme = scheme;
        if ("BRIDGE".equals(scheme) || schemeBRGS.equals(scheme)) {
            this._brgURI = true;
            this.addParm(protocolKey, "BRIDGE");
        }
    }

    private void parse() throws URISyntaxException {
        int ndx = this._orig.indexOf(css);
        String rawScheme = ndx >= 0 ? this._orig.substring(0, ndx) : this._orig;
        String scheme = rawScheme.toUpperCase(Locale.US);
        try {
            SASURI.validateScheme(scheme);
        }
        catch (IllegalArgumentException iae) {
            String msgIndex = "SASURI.007.ex.fmt";
            String msgPattern = RB.getStringResource(msgIndex);
            String msg = Message.format((String)msgPattern, (Object)rawScheme, (Object)Integer.toString(0));
            throw new LocalizableURISyntaxException(this._orig, msg, 0);
        }
        this.setScheme(scheme);
        int off = ndx + cssL;
        String spec = this._orig.substring(off);
        if (this._brgURI) {
            this.parseBRG(spec, off);
        } else {
            this.parseIOM(spec, off);
        }
    }

    private void parseIOM(String spec, int off) throws URISyntaxException {
        int semi1Ndx = spec.indexOf(semi);
        String hostPort = semi1Ndx >= 0 ? spec.substring(0, semi1Ndx) : spec;
        this.parseHostPort(hostPort, off);
        int protocolNdx = semi1Ndx + semiL;
        int specL = spec.length();
        if (semi1Ndx < 0 || protocolNdx >= specL) {
            return;
        }
        int semi2Ndx = spec.indexOf(semi, protocolNdx);
        String protocolVal = semi2Ndx >= 0 ? spec.substring(protocolNdx, semi2Ndx) : spec.substring(protocolNdx);
        off += protocolNdx;
        if (protocolVal.length() > 0) {
            this.addEncodedParm(protocolKey, protocolVal, off);
        }
        int nvPairsNdx = semi2Ndx + semiL;
        if (semi2Ndx < 0 || nvPairsNdx >= specL) {
            return;
        }
        int slashNdx = spec.indexOf(slash, nvPairsNdx);
        String nvPairs = slashNdx >= 0 ? spec.substring(nvPairsNdx, slashNdx) : spec.substring(nvPairsNdx);
        this.parseNameValuePairs(nvPairs, off += nvPairsNdx - protocolNdx);
    }

    private void parseBRG(String spec, int off) throws URISyntaxException {
        int slashNdx = spec.indexOf(slash);
        String hostPort = slashNdx >= 0 ? spec.substring(0, slashNdx) : spec;
        this.parseHostPort(hostPort, off);
        int classIDNdx = slashNdx + slashL;
        int specL = spec.length();
        if (slashNdx < 0 || classIDNdx >= specL) {
            return;
        }
        int hookNdx = spec.indexOf(hook, classIDNdx);
        String classIDVal = hookNdx >= 0 ? spec.substring(classIDNdx, hookNdx) : spec.substring(classIDNdx);
        off += classIDNdx;
        if (classIDVal.length() > 0) {
            this.addEncodedParm(classFactoryKey, classIDVal, off);
        }
        int nvPairsNdx = hookNdx + hookL;
        if (hookNdx < 0 || nvPairsNdx >= specL) {
            return;
        }
        String nvPairs = spec.substring(nvPairsNdx);
        this.parseNameValuePairs(nvPairs, off += nvPairsNdx - classIDNdx);
    }

    private void parseHostPort(String hostPort, int off) throws URISyntaxException {
        int colonNdx;
        int hostStrt = 0;
        int hostStop = 0;
        int hostPortL = hostPort.length();
        if (hostPort.startsWith(lSquare)) {
            hostStop = hostPort.indexOf(rSquare);
            if (hostStop >= 0) {
                hostStrt = lSquareL;
            }
        } else {
            hostStop = hostPort.indexOf(colon);
            if (hostStop < 0) {
                hostStop = hostPortL;
            }
        }
        off += hostStrt;
        String host = hostPort.substring(hostStrt, hostStop);
        int hostL = host.length();
        if (hostL > 0) {
            this.addEncodedParm(hostKey, host, off);
        }
        if ((colonNdx = hostPort.indexOf(colon, hostStop)) >= 0) {
            int portNdx = colonNdx + colonL;
            String port = portNdx < hostPortL ? hostPort.substring(portNdx) : null;
            this.addEncodedParm(portKey, port, off += portNdx);
        }
    }

    private void parseNameValuePairs(String nvPairs, int off) throws URISyntaxException {
        String nvSep = eql;
        String pairSep = this._brgURI ? amper : comma;
        String delim = nvSep + pairSep;
        StringTokenizer izr = new StringTokenizer(nvPairs, delim, true);
        int state = 0;
        String name = null;
        String val = null;
        int ndx = off;
        int nameIndex = 0;
        while (izr.hasMoreTokens()) {
            String tok = izr.nextToken();
            switch (state) {
                case 0: {
                    if (name != null) {
                        this.addEncodedParm(name, val, nameIndex);
                        val = null;
                    }
                    if (nvSep.equals(tok)) {
                        name = empty;
                        state = 2;
                    } else {
                        if (pairSep.equals(tok)) {
                            throw this.nvPairSyntaxException(ndx, tok, nvSep);
                        }
                        name = tok;
                        state = 1;
                    }
                    nameIndex = ndx;
                    break;
                }
                case 1: {
                    if (nvSep.equals(tok)) {
                        state = 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (pairSep.equals(tok)) {
                        state = 0;
                        break;
                    }
                    if (nvSep.equals(tok)) {
                        throw SASURI.syntaxException(this._orig, ndx, tok, nvSep, name);
                    }
                    val = tok;
                    state = 3;
                    break;
                }
                case 3: {
                    if (!pairSep.equals(tok)) {
                        throw SASURI.syntaxException(this._orig, ndx, tok, pairSep, null);
                    }
                    state = 0;
                }
            }
            ndx += tok.length();
        }
        if (name != null) {
            this.addEncodedParm(name, val, nameIndex);
        }
    }

    private void addEncodedParm(String nameE, String valE, int nameIndex) throws URISyntaxException {
        String[] invalidAttrNameArr;
        String name = SASURI.urlDecode(nameE).toLowerCase(Locale.US);
        boolean validAttr = SASURI.validateAttrName(name, invalidAttrNameArr = this._brgURI ? _brgInvalidAttrNameArr : _iomInvalidAttrNameArr);
        if (validAttr) {
            Object val = this.decodeParm(name, valE, nameIndex);
            Object nrm = SASURI.normalizeAttribute(name, val);
            SASURI.validateParm(name, nrm, nameIndex, this._orig);
            this.addParm(name, nrm);
        }
    }

    private Object decodeParm(String name, String valE, int nameIndex) throws URISyntaxException {
        String valS = valE != null ? SASURI.urlDecode(valE) : empty;
        Object val = null;
        if (majorKey.equals(name) || minorKey.equals(name)) {
            try {
                val = Byte.valueOf(valS);
            }
            catch (NumberFormatException nfe) {
                throw this.numericSyntaxException(nameIndex, name, valS, nfe);
            }
        } else if (portKey.equals(name) || timeoutKey.equals(name) || debugLevelKey.equals(name)) {
            try {
                val = Integer.valueOf(valS);
            }
            catch (NumberFormatException nfe) {
                throw this.numericSyntaxException(nameIndex, name, valS, nfe);
            }
        } else {
            val = localeKey.equals(name) ? SASURI.parseLocaleName(valS) : (trustedSASKey.equals(name) || noRedirectKey.equals(name) || zeroConfigKey.equals(name) || ticketAuthenticationKey.equals(name) ? Boolean.TRUE : valS);
        }
        return val;
    }

    private static void validateParm(String name, Object val, int nameIndex, String uri) throws URISyntaxException {
        if (transcodingPreferenceKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _transcodingPreferenceEnumArr, nameIndex, uri);
        } else if (encryptionPolicyKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _encryptionPolicyEnumArr, nameIndex, uri);
        } else if (encryptionContentKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _encryptionContentEnumArr, nameIndex, uri);
        } else if (encrLevelKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _encrLevelEnumArr, nameIndex, uri);
        } else if (protocolKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _protocolEnumArr, nameIndex, uri);
        }
    }

    private void addParm(String name, Object val) {
        SASURI.updateAttribute(name, val, this._attributes);
    }

    private static void updateParm(String name, Object val, Map attrMap) {
        if (val != null) {
            attrMap.put(name, val);
        } else {
            attrMap.remove(name);
        }
    }

    private static Map selectAttributes(boolean brgURI, Map attrMap) {
        String[] invalidAttrNameArr = brgURI ? _brgInvalidAttrNameArr : _iomInvalidAttrNameArr;
        HashMap<String, Object> selectedAttrMap = new HashMap<String, Object>(32);
        Set attrEntrySet = attrMap.entrySet();
        for (Map.Entry attrEntry : attrEntrySet) {
            Object val;
            String key = (String)attrEntry.getKey();
            boolean validAttr = SASURI.validateAttrName(key, invalidAttrNameArr);
            if (!validAttr || (val = attrMap.get(key)) == null) continue;
            Object nrm = SASURI.normalizeAttribute(key, val);
            selectedAttrMap.put(key, nrm);
        }
        if (selectedAttrMap.containsKey(classFactoryKey) && selectedAttrMap.containsKey(clsidKey)) {
            selectedAttrMap.remove(clsidKey);
        }
        if (selectedAttrMap.containsKey(iidKey) && selectedAttrMap.containsKey(interfaceIIDKey)) {
            selectedAttrMap.remove(iidKey);
        }
        return selectedAttrMap;
    }

    private static void validateScheme(String scheme) {
        if (!SASURI.arrayContains(scheme, _schemeEnumArr)) {
            throw new IllegalArgumentException(scheme);
        }
    }

    private static boolean validateAttrName(String name, String[] invalidNameArr) {
        for (String invalidName : invalidNameArr) {
            if (!invalidName.equals(name)) continue;
            return false;
        }
        return true;
    }

    private static void validateEnumValue(String name, Object value, String[] enumArr, int nameIndex, String uri) throws URISyntaxException {
        if (SASURI.arrayContains(value, enumArr)) {
            return;
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        int bufL = 0;
        for (int i = 0; i < enumArr.length; ++i) {
            bufL += enumArr[i].length();
            ++bufL;
        }
        StringBuffer buf = new StringBuffer(bufL);
        for (int i = 0; i < enumArr.length; ++i) {
            buf.append(enumArr[i]).append(comma);
        }
        buf.setLength(bufL - 1);
        String enumValues = buf.toString();
        String ndx = Integer.toString(nameIndex);
        String messageIndex = "SASURI.005.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)name, (Object)enumValues, (Object)value, (Object)ndx);
        throw new LocalizableURISyntaxException(uri, message, nameIndex);
    }

    private static boolean arrayContains(Object val, Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            Object item = arr[i];
            if (!(val != null ? val.equals(item) : item == null)) continue;
            return true;
        }
        return false;
    }

    private static synchronized Pattern getLocaleDelim() {
        if (_localeDelim == null) {
            _localeDelim = Pattern.compile(ubar);
        }
        return _localeDelim;
    }

    private static synchronized Pattern getListDelim() {
        if (_listDelim == null) {
            _listDelim = Pattern.compile("([\\s]*,[\\s]*)+");
        }
        return _listDelim;
    }

    private static synchronized Pattern getPlusPattern() {
        if (_plusPattern == null) {
            _plusPattern = Pattern.compile("\\+");
        }
        return _plusPattern;
    }

    private static synchronized Pattern getP20Pattern() {
        if (_p20Pattern == null) {
            _p20Pattern = Pattern.compile("\\%20");
        }
        return _p20Pattern;
    }

    private static URISyntaxException syntaxException(String orig, int ndx, String err, String exDelims, String exName) {
        String _ndx = Integer.toString(ndx);
        String message = null;
        if (exDelims != null) {
            if (exName == null) {
                String messageIndex = "SASURI.000.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                message = Message.format((String)messagePattern, (Object)exDelims, (Object)err, (Object)_ndx);
            } else {
                String messageIndex = "SASURI.001.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                message = Message.format((String)messagePattern, (Object)exDelims, (Object)exName, (Object)err, (Object)_ndx);
            }
        } else {
            String messageIndex = "SASURI.002.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            message = Message.format((String)messagePattern, (Object)exName, (Object)err, (Object)_ndx);
        }
        return new LocalizableURISyntaxException(orig, message, ndx);
    }

    private URISyntaxException nvPairSyntaxException(int ndx, String err, String exDelims) {
        String _ndx = Integer.toString(ndx);
        String messageIndex = "SASURI.003.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)exDelims, (Object)err, (Object)_ndx);
        return new LocalizableURISyntaxException(this._orig, message, ndx);
    }

    private URISyntaxException numericSyntaxException(int ndx, String name, Object val, NumberFormatException nfe) {
        String _ndx = Integer.toString(ndx);
        String messageIndex = "SASURI.004.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)name, (Object)val, (Object)_ndx);
        LocalizableURISyntaxException use = new LocalizableURISyntaxException(this._orig, message, ndx);
        use.initCause(nfe);
        return use;
    }

    @SASScope
    private static class LocalizableURISyntaxException
    extends URISyntaxException {
        private static final long serialVersionUID = -8779270928912084502L;
        private int _index;

        private LocalizableURISyntaxException(String input, String reason, int index) {
            super(input, reason);
            this._index = index;
        }

        @Override
        public int getIndex() {
            return this._index;
        }
    }
}

