/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SelectionHandlerInterface;
import com.sas.iom.orb.SelectionHubActivation;
import com.sas.iom.orb.SelectionHubKey;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.ThreadPoolEvent;
import com.sas.iom.orb.ThreadPoolEventListenerInterface;
import com.sas.iom.orb.ThreadPoolFactoryInterface;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

@SASScope
public class SelectionHub {
    public static final String CLIENT_THREAD_COUNT_KEY = SelectionHub.class.getName() + ".clientThreadCount";
    public static final String SERVER_THREAD_COUNT_KEY = SelectionHub.class.getName() + ".serverThreadCount";
    public static final String THREAD_POOL_FACTORY_KEY = SelectionHub.class.getName() + ".threadPoolFactory";
    public static final String THREAD_NAME_BASE = SelectionHub.class.getName() + " pool ";
    private static final Logger _logger = Logger.getLogger(SelectionHub.class);
    private static final int keyCount = 3;
    private static final int PURPOSE_CLIENT = 0;
    private static final int PURPOSE_SERVER = 1;
    private static SelectionHub singleton;
    private Spoke[] clientSpokeArray;
    private Spoke[] serverSpokeArray;
    private int clientRoundRobinIndex;
    private int serverRoundRobinIndex;
    private ThreadPoolFactoryInterface threadPoolFactory;
    private WeakReference threadPoolRef;
    private ThreadPoolEventListener listener;

    public SelectionHub(Map options) {
        options = SelectionHub.overrideOptions(options);
        this.threadPoolFactory = (ThreadPoolFactoryInterface)options.get(THREAD_POOL_FACTORY_KEY);
        if (this.threadPoolFactory == null) {
            this.threadPoolFactory = new ThreadPoolFactoryInterface(){

                @Override
                public ThreadPool getThreadPool() {
                    return new ThreadPool(THREAD_NAME_BASE);
                }
            };
        }
        String _clientThreadCount = (String)options.get(CLIENT_THREAD_COUNT_KEY);
        int clientThreadCount = 0;
        clientThreadCount = _clientThreadCount == null ? 1 : Integer.parseInt(_clientThreadCount);
        this.clientSpokeArray = new Spoke[clientThreadCount];
        for (int i = 0; i < clientThreadCount; ++i) {
            this.clientSpokeArray[i] = new Spoke(this, 0, i);
        }
        String _serverThreadCount = (String)options.get(SERVER_THREAD_COUNT_KEY);
        int serverThreadCount = 0;
        serverThreadCount = _serverThreadCount == null ? 1 : Integer.parseInt(_serverThreadCount);
        this.serverSpokeArray = new Spoke[serverThreadCount];
        for (int i = 0; i < serverThreadCount; ++i) {
            this.serverSpokeArray[i] = new Spoke(this, 1, i);
        }
        this.listener = new ThreadPoolEventListener();
    }

    public static synchronized SelectionHub getInstance() {
        if (singleton == null) {
            singleton = new SelectionHub(null);
        }
        return singleton;
    }

    public SelectionHubActivation activateClient(SelectableChannel channel, int initialInterestOps, SelectionHandlerInterface handler) throws IOException, WorkException {
        Spoke spoke = this.selectSpoke(0);
        SelectionHubActivation act = spoke.activate(channel, initialInterestOps, handler);
        return act;
    }

    public SelectionHubActivation activateServer(SelectableChannel channel, int initialInterestOps, SelectionHandlerInterface handler) throws IOException {
        Spoke spoke = this.selectSpoke(1);
        SelectionHubActivation act = null;
        try {
            act = spoke.activate(channel, initialInterestOps, handler);
        }
        catch (WorkException we) {
            throw new Error(we);
        }
        return act;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getThreadPool() {
        ThreadPoolFactoryInterface threadPoolFactoryInterface = this.threadPoolFactory;
        synchronized (threadPoolFactoryInterface) {
            ThreadPool threadPool;
            ThreadPool threadPool2 = threadPool = this.threadPoolRef != null ? (ThreadPool)this.threadPoolRef.get() : null;
            if (threadPool == null) {
                threadPool = this.threadPoolFactory.getThreadPool();
                threadPool.addListener(this.listener);
                this.threadPoolRef = new WeakReference<ThreadPool>(threadPool);
            }
            return threadPool;
        }
    }

    private synchronized Spoke selectSpoke(int purpose) {
        Spoke spoke = null;
        if (purpose == 0) {
            if (this.clientSpokeArray.length == 1) {
                spoke = this.clientSpokeArray[0];
            } else {
                spoke = this.clientSpokeArray[this.clientRoundRobinIndex++];
                if (this.clientRoundRobinIndex >= this.clientSpokeArray.length) {
                    this.clientRoundRobinIndex = 0;
                }
            }
        } else if (this.serverSpokeArray.length == 1) {
            spoke = this.serverSpokeArray[0];
        } else {
            spoke = this.serverSpokeArray[this.serverRoundRobinIndex++];
            if (this.serverRoundRobinIndex >= this.serverSpokeArray.length) {
                this.serverRoundRobinIndex = 0;
            }
        }
        return spoke;
    }

    private static Map overrideOptions(Map userOptionMap) {
        final HashMap optionMap = userOptionMap != null ? new HashMap(userOptionMap) : new HashMap(3);
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                try {
                    this.addOption(CLIENT_THREAD_COUNT_KEY, optionMap);
                    this.addOption(SERVER_THREAD_COUNT_KEY, optionMap);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return optionMap;
            }

            private void addOption(String key, Map map) {
                String val = System.getProperty(key);
                if (val != null) {
                    map.put(key, val);
                }
            }
        };
        AccessController.doPrivileged(action);
        return optionMap;
    }

    private class ThreadPoolEventListener
    implements ThreadPoolEventListenerInterface {
        private ThreadPoolEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleThreadPoolEvent(ThreadPoolEvent event) {
            ThreadPoolEvent.Type type = event.getType();
            if (ThreadPoolEvent.Type.TERMINATION.equals((Object)type)) {
                ThreadPoolFactoryInterface threadPoolFactoryInterface = SelectionHub.this.threadPoolFactory;
                synchronized (threadPoolFactoryInterface) {
                    ThreadPool threadPool = SelectionHub.this.threadPoolRef != null ? (ThreadPool)SelectionHub.this.threadPoolRef.get() : null;
                    ThreadPool source = event.getThreadPool();
                    if (source.equals(threadPool)) {
                        SelectionHub.this.threadPoolRef = null;
                        threadPool.removeListener(SelectionHub.this.listener);
                    }
                }
            }
        }
    }

    @SASScope
    protected static class Spoke
    implements WorkInterface {
        private static final ThreadLocal localActiveMapRef = new ThreadLocal();
        private SelectionHub hub;
        private int purpose;
        private ThreadPool threadPool;
        private Thread spokeThread;
        private boolean released;
        private Selector selector;
        private IOException fatalException;
        private Set activateSet;
        private Set deactivateSet;
        private Set registerSet;
        private Set updateSet;

        protected Spoke(SelectionHub hub, int purpose, int index) {
            this.hub = hub;
            this.purpose = purpose;
            this.activateSet = new HashSet();
            this.deactivateSet = new HashSet();
            this.registerSet = new HashSet();
            this.updateSet = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.spokeThread = Thread.currentThread();
            WeakHashMap localActiveMap = new WeakHashMap();
            localActiveMapRef.set(localActiveMap);
            while (true) {
                IOException fatal = null;
                int selectedCount = 0;
                if (!this.released) {
                    try {
                        selectedCount = this.selector.select();
                    }
                    catch (IOException ioe) {
                        fatal = ioe;
                    }
                }
                Spoke ioe = this;
                synchronized (ioe) {
                    boolean interrupted;
                    boolean bl = interrupted = Thread.currentThread().isInterrupted() || this.released;
                    if (fatal == null && !interrupted) {
                        this.changeActivationStatus(this.activateSet, localActiveMap, true);
                    }
                    this.changeActivationStatus(this.deactivateSet, localActiveMap, false);
                    if (fatal != null || localActiveMap.isEmpty() || interrupted) {
                        try {
                            this.selector.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                        this.selector = null;
                        this.spokeThread = null;
                        this.threadPool = null;
                        this.fatalException = fatal;
                        this.released = false;
                        if (!localActiveMap.isEmpty()) {
                            ioe = fatal;
                            if (ioe == null) {
                                ioe = new ClosedByInterruptException();
                            }
                            Set activeSet = localActiveMap.keySet();
                            for (SelectionHubKey hubKey : activeSet) {
                                SelectionHandlerInterface handler = hubKey.getHandler();
                                try {
                                    handler.handleException(hubKey, ioe);
                                }
                                catch (Throwable t) {}
                            }
                            localActiveMap.clear();
                        }
                        Spoke.restartOperations(this.activateSet);
                        this.registerSet.clear();
                        this.updateSet.clear();
                        return;
                    }
                    this.doOperations(this.registerSet, true);
                    this.doOperations(this.updateSet, false);
                }
                if (selectedCount == 0) continue;
                Set<SelectionKey> selKeySet = this.selector.selectedKeys();
                for (SelectionKey selKey : selKeySet) {
                    SelectionHubKey hubKey = (SelectionHubKey)selKey.attachment();
                    SelectionHandlerInterface handler = hubKey.getHandler();
                    hubKey.setSpokeThread(this.spokeThread);
                    try {
                        handler.handleSelection(hubKey);
                    }
                    catch (Throwable t) {
                        String msg = "Selection handler " + handler + " failed.";
                        _logger.warn((Object)msg, t);
                    }
                    hubKey.setSpokeThread(null);
                }
                selKeySet.clear();
            }
        }

        @Override
        public synchronized void release() {
            this.released = true;
            if (this.selector != null) {
                this.selector.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SelectionHubActivation activate(SelectableChannel channel, int initialInterestOps, SelectionHandlerInterface handler) throws IOException, WorkException {
            SelectionHubKey hubKey = new SelectionHubKey(this.hub, channel, initialInterestOps, handler);
            SelectionHubActivation act = null;
            while (true) {
                Object object = this;
                synchronized (object) {
                    if (this.fatalException != null) {
                        throw this.fatalException;
                    }
                    if (this.selector == null) {
                        this.init();
                    }
                    this.activateSet.add(hubKey);
                    if (Thread.currentThread() == this.spokeThread) {
                        SelectionHubKey selectionHubKey = hubKey;
                        synchronized (selectionHubKey) {
                            Map localActiveMap = (Map)localActiveMapRef.get();
                            this.changeActivationStatus(this.activateSet, localActiveMap, true);
                            act = hubKey.getActivation();
                            return act;
                        }
                    }
                    this.selector.wakeup();
                }
                object = hubKey;
                synchronized (object) {
                    act = hubKey.getActivation();
                    int restarts = hubKey.getRestarts();
                    while (act == null && restarts == 0) {
                        try {
                            hubKey.wait();
                        }
                        catch (InterruptedException ie) {
                            InterruptedIOException iioe = new InterruptedIOException();
                            iioe.initCause(ie);
                            throw iioe;
                        }
                        act = hubKey.getActivation();
                        restarts = hubKey.getRestarts();
                    }
                    if (restarts <= 0) {
                        break;
                    }
                    hubKey.removeRestart();
                }
            }
            return act;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(SelectionHubActivation act) {
            SelectionHubKey hubKey = act.getKey();
            Spoke spoke = this;
            synchronized (spoke) {
                SelectionHubKey selectionHubKey = hubKey;
                synchronized (selectionHubKey) {
                    if (Thread.currentThread() == this.spokeThread) {
                        this.doRegister(hubKey);
                        return;
                    }
                    if (hubKey.getDelegate() == null && this.selector != null) {
                        this.registerSet.add(hubKey);
                        this.selector.wakeup();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void update(SelectionHubActivation act, int ops) {
            SelectionHubKey hubKey = act.getKey();
            Spoke spoke = this;
            synchronized (spoke) {
                SelectionHubKey selectionHubKey = hubKey;
                synchronized (selectionHubKey) {
                    hubKey.setInterestOps(ops);
                    if (hubKey.getDelegate() != null && this.selector != null) {
                        this.updateSet.add(hubKey);
                        this.selector.wakeup();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(SelectionHubActivation act) {
            SelectionHubKey hubKey = act.getKey();
            Spoke spoke = this;
            synchronized (spoke) {
                SelectionHubKey selectionHubKey = hubKey;
                synchronized (selectionHubKey) {
                    if (hubKey.getActivation() != null && this.selector != null) {
                        this.deactivateSet.add(hubKey);
                        this.selector.wakeup();
                    }
                }
            }
        }

        private void init() throws IOException, WorkException {
            this.selector = Selector.open();
            this.threadPool = this.hub.getThreadPool();
            if (this.purpose == 0) {
                this.threadPool.executeDaemon(this);
            } else {
                this.threadPool.executeStandard(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeActivationStatus(Set keySet, Map activeMap, boolean activate) {
            if (keySet.isEmpty()) {
                return;
            }
            Iterator keyItr = keySet.iterator();
            while (keyItr.hasNext()) {
                SelectionHubKey hubKey;
                SelectionHubKey selectionHubKey = hubKey = (SelectionHubKey)keyItr.next();
                synchronized (selectionHubKey) {
                    if (activate) {
                        activeMap.put(hubKey, null);
                        SelectionHubActivation act = new SelectionHubActivation(this, hubKey, this.threadPool);
                        hubKey.setActivation(act);
                    } else {
                        activeMap.remove(hubKey);
                        hubKey.setActivation(null);
                    }
                    hubKey.notifyAll();
                }
            }
            keySet.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void restartOperations(Set keySet) {
            if (keySet.isEmpty()) {
                return;
            }
            Iterator registerItr = keySet.iterator();
            while (registerItr.hasNext()) {
                SelectionHubKey hubKey;
                SelectionHubKey selectionHubKey = hubKey = (SelectionHubKey)registerItr.next();
                synchronized (selectionHubKey) {
                    hubKey.addRestart();
                    hubKey.notifyAll();
                }
            }
            keySet.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doOperations(Set keySet, boolean register) {
            if (keySet.isEmpty()) {
                return;
            }
            Iterator keyItr = keySet.iterator();
            while (keyItr.hasNext()) {
                SelectionHubKey hubKey;
                SelectionHubKey selectionHubKey = hubKey = (SelectionHubKey)keyItr.next();
                synchronized (selectionHubKey) {
                    if (register) {
                        this.doRegister(hubKey);
                        hubKey.notifyAll();
                    } else {
                        SelectionKey selKey = hubKey.getDelegate();
                        if (selKey != null) {
                            int ops = hubKey.getInterestOps();
                            selKey.interestOps(ops);
                        }
                    }
                }
            }
            keySet.clear();
        }

        private void doRegister(SelectionHubKey hubKey) {
            SelectableChannel channel = hubKey.getChannel();
            try {
                int ops = hubKey.getInterestOps();
                SelectionKey del = channel.register(this.selector, ops, hubKey);
                hubKey.setDelegate(del);
            }
            catch (IOException ioe) {
                SelectionHandlerInterface handler = hubKey.getHandler();
                handler.handleException(hubKey, ioe);
            }
        }
    }
}

