/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.Column;
import com.sas.rio.IRowCache;
import com.sas.rio.MVAForwardRowCache;
import com.sas.rio.MVAResultSetMetaData;
import com.sas.rio.MVARowCache;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLExceptionUnsupported;
import com.sas.rio.MVASQLWarning;
import com.sas.rio.MVAStatement;
import com.sas.rio.MVASyntheticRowCache;
import com.sas.rio.Matrix;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class MVAResultSet
implements ResultSet {
    static final double JAVA_DATE_EPOCH = 3653.0;
    static long MAX_SASTIME = 86400L;
    static final double JAVA_DATETIME_EPOCH = 3653.0 * (double)MAX_SASTIME * 1000.0;
    static final long JAVA_DAY = MAX_SASTIME * 1000L;
    static final long Y4K_LEAPDAY = Date.valueOf("4000-02-29").getTime();
    static final long Y8K_LEAPDAY = Date.valueOf("8000-02-29").getTime();
    public static final int NOSUBTYPE = 0;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATETIME = 3;
    public static final int INTEGER = 4;
    public static final int MAYBE_INTEGER = 5;
    public static final int NUMERIC = 1;
    public static final int CHARACTER = 2;
    protected static final int MAX_FIELD_SIZE = Short.MAX_VALUE;
    protected SQLWarning _warnings = null;
    protected final int _concurrency;
    protected final int _type;
    private final int m_bindKey;
    private int m_hashCode = 0;
    protected final MVAStatement m_statement;
    protected IRowCache m_rowCache;
    protected boolean _wasNull;
    protected int m_columnCount = 0;
    boolean _closed = false;
    private int m_maxFieldSize = Short.MAX_VALUE;
    protected int m_maxRows = 0;
    protected int initialFetchSize = 0;
    static final String[] BooleanTrueConstants = new String[]{"T", "Y", "1", "TRUE"};
    static final AtomicLong resultCounterWhenNoStatement = new AtomicLong();
    private long nextCount = 0L;
    private final Logger logger = Logger.getLogger(MVAResultSet.class);
    private final long idForLogger;
    private final String logPrefix;
    private final ResultSetMetaData _metadata;

    MVAResultSet(Column[] columns, List<Object[]> rowData) throws SQLException {
        this.idForLogger = resultCounterWhenNoStatement.incrementAndGet();
        this.logPrefix = "rs(" + this.idForLogger + ")";
        this._concurrency = 1007;
        this._type = 1004;
        this.m_bindKey = 2;
        this.m_rowCache = new MVASyntheticRowCache(columns, rowData);
        this.m_statement = null;
        this._closed = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(this.logPrefix + " created DatabaseMetaData result set " + this.idForLogger));
        }
        this._metadata = new MVAResultSetMetaData(this);
    }

    @SASScope
    public MVARowCache getRowCache() {
        if (this.m_rowCache instanceof MVARowCache) {
            return (MVARowCache)this.m_rowCache;
        }
        return null;
    }

    MVAResultSet(int hashCode, RIOUtil rioUtil) throws SQLException {
        this.idForLogger = resultCounterWhenNoStatement.incrementAndGet();
        this.logPrefix = "rs(" + this.idForLogger + ")";
        this._concurrency = 1007;
        this._type = 1004;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.logPrefix + " type=" + this.getTypeName(this._type) + ", concur=" + this.getConcurrencyName(this._concurrency)));
        }
        this.m_bindKey = 2;
        this.m_statement = null;
        this.m_rowCache = new MVARowCache(hashCode, rioUtil);
        this._metadata = new MVAResultSetMetaData(this);
    }

    MVAResultSet(MVAStatement stmt, String libref, String tableName, String[] password, String options, int bindKey) throws SQLException {
        this.m_bindKey = bindKey;
        this.m_statement = stmt;
        this.idForLogger = this.m_statement.resultSetCounter.incrementAndGet();
        this.logPrefix = "rs(" + this.m_statement.getIdForLogger() + "." + this.idForLogger + ")";
        this.m_maxFieldSize = stmt.maxFieldSize;
        if (this.m_bindKey != 0) {
            this._concurrency = this.m_statement.getResultSetConcurrency();
        } else {
            this._concurrency = 1007;
            if (this.m_statement.getResultSetConcurrency() == 1008) {
                MVASQLWarning w = new MVASQLWarning(MessageCode.MVAResultSet_concurrencyWarning, new Object[0]);
                this.addWarning(w);
            }
        }
        this._type = this.m_statement.getResultSetType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.logPrefix + " type=" + this.getTypeName(this._type) + ", concur=" + this.getConcurrencyName(this._concurrency)));
        }
        this.m_rowCache = this._type == 1003 ? new MVAForwardRowCache(this.m_statement, libref, tableName, password, options, bindKey) : new MVARowCache(this.m_statement, libref, tableName, password, options, bindKey);
        int stmtFetchSize = stmt.getFetchSize();
        if (stmtFetchSize > 0) {
            this.m_rowCache.setFetchSize(stmtFetchSize);
        }
        this.m_columnCount = this.m_rowCache.getColumns().length;
        if (stmt.getMaxRows() > 0) {
            this.m_rowCache.setMaxRows(stmt.getMaxRows());
        }
        this._metadata = new MVAResultSetMetaData(this);
    }

    MVAResultSet(MVAStatement stmt, int hashCode) throws SQLException {
        this.m_statement = stmt;
        this.idForLogger = this.m_statement.resultSetCounter.incrementAndGet();
        this.logPrefix = "rs(" + this.m_statement.getIdForLogger() + "." + this.idForLogger + ")";
        boolean applyFormats = stmt.getMVAConnectionProperties().isApplyFormats();
        this.m_bindKey = applyFormats ? 3 : 2;
        this.m_maxFieldSize = stmt.maxFieldSize;
        this._concurrency = 1007;
        if (this.m_statement.getResultSetConcurrency() == 1008) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.MVAResultSet_concurrencyWarning, new Object[0]);
            this.addWarning(w);
        }
        this._type = this.m_statement.getResultSetType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.logPrefix + " type=" + this.getTypeName(this._type) + ", concur=" + this.getConcurrencyName(this._concurrency)));
        }
        this.m_rowCache = this._type == 1003 ? new MVAForwardRowCache(hashCode, stmt.getRioUtil()) : new MVARowCache(hashCode, stmt.getRioUtil());
        int stmtFetchSize = stmt.getFetchSize();
        if (stmtFetchSize > 0) {
            this.m_rowCache.setFetchSize(stmtFetchSize);
        }
        this.initialFetchSize = this.m_rowCache.getFetchSize();
        this.m_columnCount = this.m_rowCache.getColumns().length;
        if (stmt.getMaxRows() > 0) {
            this.m_rowCache.setMaxRows(stmt.getMaxRows());
        }
        this._metadata = new MVAResultSetMetaData(this);
    }

    String getIdForLogger() {
        String id = this.m_statement.idForLogger + "." + this.idForLogger;
        return id;
    }

    int getBindKey() {
        return this.m_bindKey;
    }

    @Override
    public synchronized boolean absolute(int rowIndex) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.absolute(rowIndex);
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.relative(rows);
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        this.m_rowCache.beforeFirst();
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        this.m_rowCache.afterLast();
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.first();
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.last();
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.isBeforeFirst();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_cantPerformForwardOnly, new Object[0]);
        }
        return this.m_rowCache.isLast();
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.checkClosed();
        ++this.nextCount;
        long startTime = System.nanoTime();
        boolean rc = this.m_rowCache.next();
        if (rc) {
            if (this.nextCount == 1L) {
                long elapsedNanos = System.nanoTime() - startTime;
                double elapsedSeconds = (double)elapsedNanos / 1.0E9;
                DecimalFormat formatter = new DecimalFormat();
                String logMessage = this.logPrefix + "#next (first call to next); time= " + formatter.format(elapsedSeconds) + " secs";
                this.logger.info((Object)String.format(logMessage, new Object[0]));
            } else {
                this.logger.debug((Object)("#next " + this.nextCount));
            }
        } else {
            this.logger.info((Object)("#next (end of result set) " + this.nextCount));
        }
        return rc;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRSType, new Object[0]);
        }
        return this.m_rowCache.previous();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(this.logPrefix + "#close"));
        }
        if (this.m_rowCache != null) {
            this.m_rowCache.close();
        }
        this.m_rowCache = null;
        this._closed = true;
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.checkClosed();
        return this._wasNull;
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        String tempString;
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            if (this.m_bindKey == 3) {
                return o.toString();
            }
            return null;
        }
        if (type == 16) {
            return ((Boolean)o).toString();
        }
        if (type != 12 && this.m_bindKey != 3) {
            double value = ((Number)o).doubleValue();
            switch (type) {
                case 91: {
                    long javaMilliseconds = this.calcJavaDate(value, true, false);
                    Date tempDate = new Date(javaMilliseconds);
                    tempString = tempDate.toString();
                    break;
                }
                case 92: {
                    long javaMilliseconds = this.calcJavaDate(value, false, true);
                    Time tempTime = new Time(javaMilliseconds);
                    tempString = tempTime.toString();
                    break;
                }
                case 93: {
                    long javaMilliseconds = this.calcJavaDate(value, true, true);
                    Timestamp tempTimestamp = new Timestamp(javaMilliseconds);
                    tempString = tempTimestamp.toString();
                    break;
                }
                case 4: 
                case 5: {
                    tempString = Integer.toString((int)value);
                    break;
                }
                default: {
                    tempString = Double.toString(value);
                    break;
                }
            }
        } else {
            tempString = o.toString();
        }
        if (this.m_maxFieldSize > 0 && tempString.length() > this.m_maxFieldSize) {
            tempString = tempString.substring(0, this.m_maxFieldSize);
        }
        return tempString;
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToBoolean, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return false;
        }
        switch (type) {
            case 16: {
                return (Boolean)o;
            }
            case 12: {
                String ctemp = ((String)o).trim().toUpperCase();
                return ctemp.equals(BooleanTrueConstants[0]) || ctemp.equals(BooleanTrueConstants[1]) || ctemp.equals(BooleanTrueConstants[2]) || ctemp.equals(BooleanTrueConstants[3]);
            }
        }
        double d = 0.0;
        d = this.m_bindKey == 3 ? Double.parseDouble((String)o) : ((Number)o).doubleValue();
        return d != 0.0;
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToByte, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return 0;
        }
        switch (type) {
            case 16: {
                return (Boolean)o == true ? (byte)1 : 0;
            }
            case 12: {
                try {
                    byte b = Byte.parseByte(((String)o).trim());
                    return b;
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        byte b = 0;
        b = this.m_bindKey == 3 ? (byte)Double.parseDouble((String)o) : ((Number)o).byteValue();
        return b;
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToShort, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return 0;
        }
        switch (type) {
            case 16: {
                return (Boolean)o == true ? (short)1 : 0;
            }
            case 12: {
                String temp = o.toString().trim();
                try {
                    return Short.parseShort(temp);
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        if (this.m_bindKey == 3) {
            try {
                return Short.parseShort(o.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        return ((Number)o).shortValue();
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToInt, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return 0;
        }
        switch (type) {
            case 16: {
                return (Boolean)o == true ? 1 : 0;
            }
            case 12: {
                try {
                    return Integer.parseInt(((String)o).trim());
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        if (this.m_bindKey == 3) {
            int i = (int)Double.parseDouble((String)o);
            return i;
        }
        return ((Number)o).intValue();
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToLong, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return 0L;
        }
        switch (type) {
            case 16: {
                return (Boolean)o == true ? 1L : 0L;
            }
            case 12: {
                try {
                    long l = Long.parseLong(((String)o).trim());
                    return l;
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        long lValue = 0L;
        if (this.m_bindKey == 3) {
            lValue = (long)Double.parseDouble((String)o);
            return lValue;
        }
        lValue = ((Number)o).longValue();
        return lValue;
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToFloat, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return 0.0f;
        }
        switch (type) {
            case 16: {
                return (Boolean)o == true ? 1.0f : 0.0f;
            }
            case 12: {
                try {
                    return Float.parseFloat((String)o);
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        if (this.m_bindKey == 3) {
            return (float)Double.parseDouble((String)o);
        }
        return ((Number)o).floatValue();
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return 0.0;
        }
        switch (type) {
            case 16: {
                return (Boolean)o == true ? 1.0 : 0.0;
            }
            case 12: {
                try {
                    double d = Double.parseDouble((String)o);
                    return d;
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        double d = 0.0;
        d = this.m_bindKey == 3 ? Double.parseDouble((String)o) : ((Number)o).doubleValue();
        return d;
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93 || type == 16) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToNumeric, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        switch (type) {
            case 12: {
                try {
                    String s = ((String)o).trim();
                    return new BigDecimal(s);
                }
                catch (NumberFormatException e) {
                    throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
                }
            }
        }
        if (this.m_bindKey == 3) {
            String s = ((String)o).trim();
            return new BigDecimal(s);
        }
        String s = ((Number)o).toString();
        return new BigDecimal(s);
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAResultSet_getBytesError, new Object[0]);
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 91 && type != 12 && type != 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToDate, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type == 12 || this.m_bindKey == 3) {
            String temp = o.toString().trim();
            try {
                return Date.valueOf(temp);
            }
            catch (IllegalArgumentException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        double value = ((Number)o).doubleValue();
        switch (type) {
            case 91: {
                long javaMilliseconds = this.calcJavaDate(value, true, false);
                return new Date(javaMilliseconds);
            }
        }
        long javaMilliseconds = this.calcJavaDate(value, true, true);
        Timestamp tempTimestamp = new Timestamp(javaMilliseconds);
        return new Date(tempTimestamp.getTime());
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 92 && type != 12 && type != 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToTime, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type == 12 || this.m_bindKey == 3) {
            String temp = o.toString().trim();
            try {
                return Time.valueOf(temp);
            }
            catch (IllegalArgumentException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        double value = ((Number)o).doubleValue();
        long javaMilliseconds = this.calcJavaDate(value, false, true);
        return new Time(javaMilliseconds);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 91 && type != 12 && type != 93 && type != 92) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToTimestamp, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type == 12 || this.m_bindKey == 3) {
            String temp = o.toString().trim();
            try {
                return Timestamp.valueOf(temp);
            }
            catch (NumberFormatException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        double value = ((Number)o).doubleValue();
        switch (type) {
            case 91: {
                long javaMilliseconds = this.calcJavaDate(value, true, false);
                Date tempDate = new Date(javaMilliseconds);
                return new Timestamp(tempDate.getTime());
            }
            case 92: {
                long javaMilliseconds = this.calcJavaDate(value, false, true);
                Time tempTime = new Time(javaMilliseconds);
                return new Timestamp(tempTime.getTime());
            }
        }
        long javaMilliseconds = this.calcJavaDate(value, true, true);
        return new Timestamp(javaMilliseconds);
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 12) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToInputStream, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        String temp = o.toString().trim();
        byte[] outbytes = temp.getBytes();
        return new ByteArrayInputStream(outbytes);
    }

    @Override
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkClosed();
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosed();
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getString(columnIndex);
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getBoolean(columnIndex);
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getByte(columnIndex);
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getShort(columnIndex);
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getInt(columnIndex);
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getLong(columnIndex);
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getFloat(columnIndex);
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getDouble(columnIndex);
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getBytes(columnIndex);
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getDate(columnIndex);
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getTime(columnIndex);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getTimestamp(columnIndex);
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getAsciiStream(columnIndex);
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getUnicodeStream(columnIndex);
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this._warnings;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this._warnings = null;
    }

    private void checkClosed() throws SQLException {
        if (this._closed) {
            throw new MVASQLException(MessageCode.MVAResultSet_notOpenError, new Object[0]);
        }
    }

    @Override
    public synchronized String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this._metadata;
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type != 12 && this.m_bindKey != 3) {
            switch (type) {
                case 91: {
                    long javaMilliseconds = this.calcJavaDate(((Number)o).doubleValue(), true, false);
                    return new Date(javaMilliseconds);
                }
                case 92: {
                    long javaMilliseconds = this.calcJavaDate(((Number)o).doubleValue(), false, true);
                    return new Time(javaMilliseconds);
                }
                case 93: {
                    long javaMilliseconds = this.calcJavaDate(((Number)o).doubleValue(), true, true);
                    return new Timestamp(javaMilliseconds);
                }
                case 16: {
                    return o;
                }
                case 4: 
                case 5: {
                    Integer itemp = (int)((Number)o).doubleValue();
                    return itemp;
                }
            }
            return o;
        }
        return o;
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getObject(columnIndex);
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        if (columnName == null) {
            throw new MVASQLException(MessageCode.MVAResultSet_findColumnError, new Object[0]);
        }
        int index = 0;
        boolean found = false;
        for (Column c : this.m_rowCache.getColumns()) {
            String s = c.getName();
            ++index;
            if (!s.equalsIgnoreCase(columnName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new MVASQLException(MessageCode.MVAResultSet_findColumnError, new Object[0]);
        }
        return index;
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex, null);
    }

    public synchronized Reader getCharacterStream(int columnIndex, String charsetName) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 12) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToReader, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        String temp = o.toString().trim();
        if (charsetName == null) {
            charsetName = System.getProperty("file.encoding");
        }
        InputStreamReader reader = null;
        try {
            byte[] outbytes = temp.getBytes(charsetName);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(outbytes), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new MVASQLException(MessageCode.MVAResultSet_encodingError, charsetName);
        }
        return reader;
    }

    public synchronized Reader getCharacterStream(String columnName, String charsetName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getCharacterStream(columnIndex, charsetName);
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, 0);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getBigDecimal(columnIndex, 0);
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.checkClosed();
        return this.m_rowCache.getRow();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidFetchDirection, new Object[0]);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0 || this.m_statement.getMaxRows() != 0 && rows > this.m_statement.getMaxRows()) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidFetchSize, new Object[0]);
        }
        if (rows == 0) {
            this.m_rowCache.setFetchSize(this.initialFetchSize);
            return;
        }
        this.m_rowCache.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.m_rowCache.getFetchSize();
    }

    @Override
    public synchronized int getType() throws SQLException {
        this.checkClosed();
        return this._type;
    }

    @Override
    public synchronized int getConcurrency() throws SQLException {
        this.checkClosed();
        return this._concurrency;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAResultSet_rowUpdatedError, new Object[0]);
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAResultSet_rowInsertedError, new Object[0]);
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVAResultSet_rowDeletedError, new Object[0]);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        try {
            if (this.m_rowCache.getSqlType(columnIndex) != 12) {
                this.m_rowCache.updateData(columnIndex, Double.NaN);
            } else {
                this.m_rowCache.updateData(columnIndex, null);
            }
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateNullError, e.getClass().getName(), e.getMessage());
        }
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToBoolean, new Object[0]);
        }
        switch (type) {
            case 12: {
                this.m_rowCache.updateData(columnIndex, Boolean.toString(x));
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x ? 1.0 : 0.0);
            }
        }
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToByte, new Object[0]);
        }
        switch (type) {
            case 12: {
                String s = Byte.toString(x);
                this.m_rowCache.updateData(columnIndex, s);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x);
            }
        }
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToShort, new Object[0]);
        }
        switch (type) {
            case 12: {
                String s = Short.toString(x);
                this.m_rowCache.updateData(columnIndex, s);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x);
            }
        }
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToInt, new Object[0]);
        }
        switch (type) {
            case 12: {
                String s = Integer.toString(x);
                this.m_rowCache.updateData(columnIndex, s);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x);
            }
        }
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToInt, new Object[0]);
        }
        switch (type) {
            case 12: {
                String fs = Float.toString(x);
                this.m_rowCache.updateData(columnIndex, fs);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x);
            }
        }
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        int type = this.m_rowCache.getSqlType(columnIndex);
        switch (type) {
            case 12: {
                String s = Double.toString(x);
                this.m_rowCache.updateData(columnIndex, s);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x);
            }
        }
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type == 91 || type == 92 || type == 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToBigDecimal, new Object[0]);
        }
        switch (type) {
            case 12: {
                String s = x.toString();
                if (s.length() == 0) {
                    this.m_rowCache.updateData(columnIndex, null);
                    break;
                }
                this.m_rowCache.updateData(columnIndex, s);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x.doubleValue());
            }
        }
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int type = this.m_rowCache.getSqlType(columnIndex);
        switch (type) {
            case 91: {
                this.m_rowCache.updateData(columnIndex, Date.valueOf(x.trim()));
                break;
            }
            case 92: {
                this.m_rowCache.updateData(columnIndex, Time.valueOf(x.trim()));
                break;
            }
            case 93: {
                this.m_rowCache.updateData(columnIndex, Timestamp.valueOf(x.trim()));
                break;
            }
            case 12: {
                this.m_rowCache.updateData(columnIndex, x);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, Double.valueOf(x.trim()));
            }
        }
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateString(columnIndex, new String(x));
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 91 && type != 93 && type != 12) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToDate, new Object[0]);
        }
        switch (type) {
            case 91: 
            case 93: {
                double d = this.dateToDouble(x);
                this.m_rowCache.updateData(columnIndex, d);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x.toString());
            }
        }
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 92 && type != 93 && type != 12) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToTime, new Object[0]);
        }
        switch (type) {
            case 92: 
            case 93: {
                double d = this.timeToDouble(x);
                this.m_rowCache.updateData(columnIndex, d);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x.toString());
            }
        }
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 91 && type != 93 && type != 12) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToTimestamp, new Object[0]);
        }
        switch (type) {
            case 91: 
            case 93: {
                double d = this.timestampToDouble(x);
                this.m_rowCache.updateData(columnIndex, d);
                break;
            }
            default: {
                this.m_rowCache.updateData(columnIndex, x.toString());
            }
        }
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        char[] value = new char[length];
        try {
            InputStreamReader reader = new InputStreamReader(x, "ASCII");
            int charsRead = reader.read(value, 0, length);
            String newString = new String(value, 0, charsRead);
            this.updateString(columnIndex, newString);
        }
        catch (UnsupportedEncodingException e) {
            throw new MVASQLException(MessageCode.MVAResultSet_encodingError, "ASCII");
        }
        catch (IOException e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateAsciiStreamFailedError, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] value = new byte[length];
        try {
            int bytesRead = x.read(value, 0, length);
            ByteBuffer bb = ByteBuffer.wrap(value, 0, bytesRead);
            this.updateBytes(columnIndex, bb.array());
        }
        catch (IOException e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateBinaryStreamFailedError, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        char[] value = new char[length];
        try {
            int charsRead = x.read(value, 0, length);
            String newString = new String(value, 0, charsRead);
            this.updateString(columnIndex, newString);
        }
        catch (IOException e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateCharStreamFailedError, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.throwGenericExceptions(columnIndex, true);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        if (x instanceof Date) {
            this.updateDate(columnIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.updateTime(columnIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.updateTimestamp(columnIndex, (Timestamp)x);
            return;
        }
        if (x instanceof String || x instanceof Character) {
            this.updateString(columnIndex, x.toString());
            return;
        }
        if (x instanceof Integer) {
            this.updateInt(columnIndex, (int)((Integer)x));
            return;
        }
        if (x instanceof Float) {
            this.updateFloat(columnIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.updateDouble(columnIndex, (double)((Double)x));
            return;
        }
        throw new MVASQLException(MessageCode.MVAResultSet_unknownObjectType, new Object[0]);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateObject(columnIndex, x, 0);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkClosed();
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        this.m_rowCache.insertRow();
    }

    @SASScope
    public synchronized void insertMultipleRows(Matrix matrix) throws SQLException {
        this.checkClosed();
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        if (this.m_rowCache.getColumns().length != matrix.getColumnCount()) {
            throw new MVASQLException(MessageCode.MVAResultSet_matrixDataError, matrix.getColumnCount(), this.m_rowCache.getColumns().length);
        }
        if (this.m_hashCode == 0) {
            this.m_hashCode = this.m_rowCache.getHashCode();
        }
        try {
            RIOUtil rioUtil = this.m_rowCache.getRioUtil();
            rioUtil.insertMultipleRows(this.m_hashCode, matrix);
        }
        catch (SQLException se) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)se, new Object[0]);
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkClosed();
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        this.m_rowCache.updateRow();
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkClosed();
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        this.m_rowCache.deleteRow();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.checkClosed();
        this.m_rowCache.refresh();
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        this.m_rowCache.cancelUpdate();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkClosed();
        if (this.m_bindKey == 0) {
            throw new MVASQLException(MessageCode.MVAResultSet_dualNotUpdatable, new Object[0]);
        }
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        this.m_rowCache.moveToInsertRow();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkClosed();
        if (this._concurrency == 1007) {
            throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
        }
        this.m_rowCache.moveToCurrentRow();
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.m_statement;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 91 && type != 12 && type != 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToDate, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type == 12 || this.m_bindKey == 3) {
            String temp = o.toString().trim();
            try {
                if (cal == null) {
                    return Date.valueOf(temp);
                }
                Date tempDate = Date.valueOf(temp);
                return new Date(tempDate.getTime() + (long)cal.getTimeZone().getOffset(tempDate.getTime()));
            }
            catch (IllegalArgumentException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        double value = ((Number)o).doubleValue();
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        if (type == 91) {
            long javaMilliseconds = this.calcJavaDate(value, true, false, cal);
            return new Date(javaMilliseconds);
        }
        long javaMilliseconds = this.calcJavaDate(value, true, true, cal);
        Timestamp tempTimestamp = new Timestamp(javaMilliseconds);
        return new Date(tempTimestamp.getTime());
    }

    @Override
    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkClosed();
        int columnIndex = this.findColumn(columnName);
        return this.getDate(columnIndex, cal);
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 92 && type != 12 && type != 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToTime, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type == 12 || this.m_bindKey == 3) {
            String temp = o.toString().trim();
            try {
                if (cal == null) {
                    return Time.valueOf(temp);
                }
                Time tempTime = Time.valueOf(temp);
                return new Time(tempTime.getTime() + (long)cal.getTimeZone().getOffset(tempTime.getTime()));
            }
            catch (IllegalArgumentException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        double value = ((Number)o).doubleValue();
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        long javaMilliseconds = this.calcJavaDate(value, false, true, cal);
        return new Time(javaMilliseconds);
    }

    @Override
    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkClosed();
        int columnIndex = this.findColumn(columnName);
        return this.getTime(columnIndex, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.throwGenericExceptions(columnIndex, false);
        Object o = this.m_rowCache.getData(columnIndex);
        int type = this.m_rowCache.getSqlType(columnIndex);
        if (type != 91 && type != 12 && type != 93) {
            throw new MVASQLException(MessageCode.MVAResultSet_cannotConvertToTimestamp, new Object[0]);
        }
        boolean bl = this._wasNull = o == null || this.m_rowCache.getIsMissing(columnIndex);
        if (this._wasNull) {
            return null;
        }
        if (type == 12 || this.m_bindKey == 3) {
            String temp = o.toString().trim();
            try {
                if (cal == null) {
                    return Timestamp.valueOf(temp);
                }
                Timestamp tempTS = Timestamp.valueOf(temp);
                return new Timestamp(tempTS.getTime() + (long)cal.getTimeZone().getOffset(tempTS.getTime()));
            }
            catch (NumberFormatException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_numberFormatError, (Throwable)e, new Object[0]);
            }
        }
        double value = ((Number)o).doubleValue();
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        if (type == 91) {
            long javaMilliseconds = this.calcJavaDate(value, true, false, cal);
            Date tempDate = new Date(javaMilliseconds);
            return new Timestamp(tempDate.getTime());
        }
        long javaMilliseconds = this.calcJavaDate(value, true, true, cal);
        return new Timestamp(javaMilliseconds);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkClosed();
        int columnIndex = this.findColumn(columnName);
        return this.getTimestamp(columnIndex, cal);
    }

    private long calcJavaDate(double value, boolean date, boolean time) {
        return this.calcJavaDate(value, date, time, null);
    }

    private long calcJavaDate(double value, boolean date, boolean time, Calendar cal) {
        double sasdate = value;
        long javaMilliseconds = 0L;
        if (date && time) {
            sasdate = sasdate * 1000.0 - JAVA_DATETIME_EPOCH;
        } else if (date) {
            sasdate = sasdate * (double)MAX_SASTIME * 1000.0 - JAVA_DATETIME_EPOCH;
        } else if (time) {
            sasdate *= 1000.0;
        }
        TimeZone tz = null;
        tz = cal == null ? TimeZone.getDefault() : cal.getTimeZone();
        javaMilliseconds = (long)Math.floor(sasdate);
        int off = tz.getOffset(javaMilliseconds);
        javaMilliseconds -= (long)off;
        if (date) {
            javaMilliseconds = this.alignCalendarToJavaDates(javaMilliseconds);
        }
        return javaMilliseconds;
    }

    private double dateToDouble(Date x) {
        double value = x.getTime();
        value = this.adjustForTimeZone(value);
        value += JAVA_DATETIME_EPOCH;
        value = this.alignCalendarToSASDates(value);
        return value / (double)(1000L * MAX_SASTIME);
    }

    private double timestampToDouble(Timestamp x) {
        double value = x.getTime();
        value = this.adjustForTimeZone(value);
        value += JAVA_DATETIME_EPOCH;
        value = this.alignCalendarToSASDates(value);
        return value / 1000.0;
    }

    private double timeToDouble(Time x) {
        double value = x.getTime();
        value = this.adjustForTimeZone(value);
        return value / 1000.0;
    }

    private double adjustForTimeZone(double value) {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        value = (long)Math.floor(value);
        int off = tz.getOffset((long)value);
        return value += (double)off;
    }

    private double alignCalendarToSASDates(double value) {
        if (value >= (double)Y4K_LEAPDAY && (value -= (double)JAVA_DAY) >= (double)Y8K_LEAPDAY) {
            value -= (double)JAVA_DAY;
        }
        return value;
    }

    private long alignCalendarToJavaDates(long value) {
        if (value >= Y4K_LEAPDAY && (value += JAVA_DAY) >= Y8K_LEAPDAY) {
            value += JAVA_DAY;
        }
        return value;
    }

    private void throwGenericExceptions(int columnIndex, boolean updateColumn) throws SQLException {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.m_rowCache.getColumns().length) {
            throw new MVASQLException(MessageCode.General_invalidColumnValue, new Object[0]);
        }
        if (updateColumn) {
            if (this.m_bindKey == 0) {
                throw new MVASQLException(MessageCode.MVAResultSet_dualNotUpdatable, new Object[0]);
            }
            if (this._concurrency == 1007) {
                throw new MVASQLException(MessageCode.MVAResultSet_notUpdatableResultSetError, new Object[0]);
            }
        }
    }

    protected IRowCache getCache() {
        return this.m_rowCache;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new MVASQLException(MessageCode.General_unwrapFailInputParameterIsNull, new Object[0]);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.getName().equals("com.sas.rio.MVAAnnotatedResultSet")) {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_unwrapFail, "com.sas.rio.MVAAnnotatedResultSet");
        }
        if (iface.getName().equals("com.sas.sql.AnnotatedResultSet")) {
            throw new MVASQLException(MessageCode.MVAAnnotatedResultSet_unwrapFail, "com.sas.sql.AnnotatedResultSet");
        }
        throw new MVASQLException(MessageCode.General_unwrapFail, iface.getName(), this.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    private void addWarning(SQLWarning warning) {
        if (warning != null) {
            if (this._warnings == null) {
                this._warnings = warning;
            } else {
                this._warnings.setNextWarning(warning);
            }
        }
    }

    private String getTypeName(int type) {
        switch (type) {
            case 1003: {
                return "TYPE_FORWARD_ONLY";
            }
            case 1004: {
                return "TYPE_SCROLL_INSENSITIVE";
            }
            case 1005: {
                return "TYPE_SCROLL_SENSITIVE";
            }
        }
        return Integer.toString(type);
    }

    private String getConcurrencyName(int concur) {
        switch (concur) {
            case 1007: {
                return "CONCUR_READ_ONLY";
            }
            case 1008: {
                return "CONCUR_UPDATABLE";
            }
        }
        return Integer.toString(concur);
    }
}

