
I recommend using [VS Code](https://code.visualstudio.com) with
[LaTeX Workshop](https://marketplace.visualstudio.com/items?itemName=James-Yu.latex-workshop) for easily visualizing changes to figures. In preview mode, once you run the code to regenerate the tex file for the figure, the figure should update automatically in the pdf preview window.
If `sane_tikz` was useful for you to create figures for your paper, consider mentioning it in the acknowledgements and share it via an issue or email or on Twitter with the hashtag #sane_tikz.
See [tutorial](tutorial.md) for a high-level description of the design decisions or dive right into the examples.

# Examples

Check the [examples](https://github.com/negrinho/sane_tikz/blob/master/examples/):


- segments: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/segments.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/segments.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/segments.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/segments.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093964-d531e380-5f8f-11ea-858b-5ac1f1449309.png" width="320">
  </a>
</p>

- flowchart: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/flowchart.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/flowchart.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/flowchart.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/flowchart.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093958-d4994d00-5f8f-11ea-8cec-45aba35f1b2a.png" width="80">
  </a>
</p>


- pentagon: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/pentagon.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/pentagon.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/pentagon.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/pentagon.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093963-d4994d00-5f8f-11ea-845c-d9c4a663c434.png" width="480">
  </a>
</p>

- boxes: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/boxes.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/boxes.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/boxes.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/boxes.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093939-cea36c00-5f8f-11ea-88d0-213bf4a0c770.png" width="640">
  </a>
</p>

- lda: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/lda.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/lda.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/lda.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/lda.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093960-d4994d00-5f8f-11ea-837d-25ee5d369450.png" width="480">
  </a>
</p>

- tree: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/tree.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/tree.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/tree.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/tree.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093968-d6631080-5f8f-11ea-9679-8dc430257318.png" width="480">
  </a>
</p>

- transformer: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/transformer.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/transformer.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/transformer.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/transformer.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093965-d5ca7a00-5f8f-11ea-9e7f-006571820d44.png" width="640">
  </a>
</p>

- xlnet: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/xlnet.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/xlnet.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/xlnet.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/xlnet.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093969-d6631080-5f8f-11ea-9f36-3cb83a23dacd.png" width="640">
  </a>
</p>

- deep_architect: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/deep_architect.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/deep_architect.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/deep_architect.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/deep_architect.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093942-cf3c0280-5f8f-11ea-9b4d-a61d51a5bd71.png" width="640">
  </a>
</p>

<!-- - factor_graphs: [[py]](https://github.com/negrinho/sane_tikz/blob/master/examples/factor_graphs.py) [[tex]](https://github.com/negrinho/sane_tikz/blob/master/examples/factor_graphs.tex) [[pdf]](https://github.com/negrinho/sane_tikz/blob/master/examples/factor_graphs.pdf)

<p align="center">
  <a href="https://github.com/negrinho/sane_tikz/blob/master/examples/factor_graphs.py">
    <img src="https://user-images.githubusercontent.com/9198933/76093939-cea36c00-5f8f-11ea-88d0-213bf4a0c770.png" width="640">
  </a>
</p> -->


# Roadmap

- Easy GIF generation
- Multiple output formats (png, svg, ...)
- 3D plotting
- More 2D plotting primitives for common plots (bar, line, scatter, ...)
- Slide deck creation (i.e., an alternative to Beamer)

