import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [amplifyuibuilder](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyuibuilder.html).
 *
 * @experimental
 */
export declare class Amplifyuibuilder extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [amplifyuibuilder](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyuibuilder.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a component.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_CreateComponent.html
     *
     * @experimental
     */
    toCreateComponent(): this;
    /**
     * (experimental) Grants permission to create a theme.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_CreateTheme.html
     *
     * @experimental
     */
    toCreateTheme(): this;
    /**
     * (experimental) Grants permission to delete a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_DeleteComponent.html
     *
     * @experimental
     */
    toDeleteComponent(): this;
    /**
     * (experimental) Grants permission to delete a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_DeleteTheme.html
     *
     * @experimental
     */
    toDeleteTheme(): this;
    /**
     * (experimental) Grants permission to exchange a code for a token.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ExchangeCodeForToken.html
     *
     * @experimental
     */
    toExchangeCodeForToken(): this;
    /**
     * (experimental) Grants permission to export components.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ExportComponents.html
     *
     * @experimental
     */
    toExportComponents(): this;
    /**
     * (experimental) Grants permission to export themes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ExportThemes.html
     *
     * @experimental
     */
    toExportThemes(): this;
    /**
     * (experimental) Grants permission to get an existing component.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_GetComponent.html
     *
     * @experimental
     */
    toGetComponent(): this;
    /**
     * (experimental) Grants permission to get an existing theme.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_GetTheme.html
     *
     * @experimental
     */
    toGetTheme(): this;
    /**
     * (experimental) Grants permission to list the components for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ListComponents.html
     *
     * @experimental
     */
    toListComponents(): this;
    /**
     * (experimental) Grants permission to list the tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/welcome.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list the themes for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ListThemes.html
     *
     * @experimental
     */
    toListThemes(): this;
    /**
     * (experimental) Grants permission to refresh an access token.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_RefreshToken.html
     *
     * @experimental
     */
    toRefreshToken(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/welcome.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/welcome.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_UpdateComponent.html
     *
     * @experimental
     */
    toUpdateComponent(): this;
    /**
     * (experimental) Grants permission to update a theme.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_UpdateTheme.html
     *
     * @experimental
     */
    toUpdateTheme(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type ComponentResource to the statement.
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Component.html
     *
     * @param appId - Identifier for the appId.
     * @param environmentName - Identifier for the environmentName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onComponentResource(appId: string, environmentName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ThemeResource to the statement.
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Theme.html
     *
     * @param appId - Identifier for the appId.
     * @param environmentName - Identifier for the environmentName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onThemeResource(appId: string, environmentName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the app ID.
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_App.html
     *
     * Applies to resource types:
     * - ComponentResource
     * - ThemeResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAppId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the component ID.
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Component.html
     *
     * Applies to resource types:
     * - ComponentResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifComponentsId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the backend environment name.
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_BackendEnvironment.html
     *
     * Applies to resource types:
     * - ComponentResource
     * - ThemeResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifEnvironmentName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the theme ID.
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Theme.html
     *
     * Applies to resource types:
     * - ThemeResource
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifThemesId(value: string | string[], operator?: Operator | string): this;
}
