import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
 *
 * @experimental
 */
export declare class Evidently extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [evidently](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchevidently.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an experiment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateExperiment.html
     *
     * @experimental
     */
    toCreateExperiment(): this;
    /**
     * (experimental) Grants permission to create a feature.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateFeature.html
     *
     * @experimental
     */
    toCreateFeature(): this;
    /**
     * (experimental) Grants permission to create a launch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateLaunch.html
     *
     * @experimental
     */
    toCreateLaunch(): this;
    /**
     * (experimental) Grants permission to create a project.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_CreateProject.html
     *
     * @experimental
     */
    toCreateProject(): this;
    /**
     * (experimental) Grants permission to delete an experiment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteExperiment.html
     *
     * @experimental
     */
    toDeleteExperiment(): this;
    /**
     * (experimental) Grants permission to delete a feature.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteFeature.html
     *
     * @experimental
     */
    toDeleteFeature(): this;
    /**
     * (experimental) Grants permission to delete a launch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteLaunch.html
     *
     * @experimental
     */
    toDeleteLaunch(): this;
    /**
     * (experimental) Grants permission to delete a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_DeleteProject.html
     *
     * @experimental
     */
    toDeleteProject(): this;
    /**
     * (experimental) Grants permission to get experiment details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetExperiment.html
     *
     * @experimental
     */
    toGetExperiment(): this;
    /**
     * (experimental) Grants permission to get experiment result.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetExperimentResults.html
     *
     * @experimental
     */
    toGetExperimentResults(): this;
    /**
     * (experimental) Grants permission to get feature details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetFeature.html
     *
     * @experimental
     */
    toGetFeature(): this;
    /**
     * (experimental) Grants permission to get launch details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetLaunch.html
     *
     * @experimental
     */
    toGetLaunch(): this;
    /**
     * (experimental) Grants permission to get project details.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_GetProject.html
     *
     * @experimental
     */
    toGetProject(): this;
    /**
     * (experimental) Grants permission to list experiments.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListExperiments.html
     *
     * @experimental
     */
    toListExperiments(): this;
    /**
     * (experimental) Grants permission to list features.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListFeatures.html
     *
     * @experimental
     */
    toListFeatures(): this;
    /**
     * (experimental) Grants permission to list launches.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListLaunches.html
     *
     * @experimental
     */
    toListLaunches(): this;
    /**
     * (experimental) Grants permission to list projects.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_ListProjects.html
     *
     * @experimental
     */
    toListProjects(): this;
    /**
     * (experimental) Grants permission to start an experiment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StartExperiment.html
     *
     * @experimental
     */
    toStartExperiment(): this;
    /**
     * (experimental) Grants permission to start a launch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StartLaunch.html
     *
     * @experimental
     */
    toStartLaunch(): this;
    /**
     * (experimental) Grants permission to stop an experiment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StopExperiment.html
     *
     * @experimental
     */
    toStopExperiment(): this;
    /**
     * (experimental) Grants permission to stop a launch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_StopLaunch.html
     *
     * @experimental
     */
    toStopLaunch(): this;
    /**
     * (experimental) Grants permission to update experiment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateExperiment.html
     *
     * @experimental
     */
    toUpdateExperiment(): this;
    /**
     * (experimental) Grants permission to update feature.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateFeature.html
     *
     * @experimental
     */
    toUpdateFeature(): this;
    /**
     * (experimental) Grants permission to update a launch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateLaunch.html
     *
     * @experimental
     */
    toUpdateLaunch(): this;
    /**
     * (experimental) Grants permission to update project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateProject.html
     *
     * @experimental
     */
    toUpdateProject(): this;
    /**
     * (experimental) Grants permission to update project data delivery.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/API_UpdateProjectDataDelivery.html
     *
     * @experimental
     */
    toUpdateProjectDataDelivery(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Project to the statement.
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/projects.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProject(ownerAccountId: string, projectName: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Feature to the statement.
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/features.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param featureName - Identifier for the featureName.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFeature(ownerAccountId: string, projectName: string, featureName: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Experiment to the statement.
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/experiments.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param experimentName - Identifier for the experimentName.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onExperiment(ownerAccountId: string, projectName: string, experimentName: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Launch to the statement.
     *
     * https://docs.aws.amazon.com/evidently/latest/dg/launches.html
     *
     * @param ownerAccountId - Identifier for the ownerAccountId.
     * @param projectName - Identifier for the projectName.
     * @param launchName - Identifier for the launchName.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLaunch(ownerAccountId: string, projectName: string, launchName: string, region?: string, partition?: string): this;
}
