import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [mediatailor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediatailor.html).
 *
 * @experimental
 */
export declare class Mediatailor extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [mediatailor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediatailor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a new channel.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @experimental
     */
    toCreateChannel(): this;
    /**
     * (experimental) Grants permission to create a new program on the channel with the specified channel name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     *
     * @experimental
     */
    toCreateProgram(): this;
    /**
     * (experimental) Grants permission to create a new source location.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @experimental
     */
    toCreateSourceLocation(): this;
    /**
     * (experimental) Grants permission to create a new VOD source on the source location with the specified source location name.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @experimental
     */
    toCreateVodSource(): this;
    /**
     * (experimental) Grants permission to delete the channel with the specified channel name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @experimental
     */
    toDeleteChannel(): this;
    /**
     * (experimental) Grants permission to delete the IAM policy on the channel with the specified channel name.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     *
     * @experimental
     */
    toDeleteChannelPolicy(): this;
    /**
     * (experimental) Deletes the playback configuration for the specified name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration-name.html
     *
     * @experimental
     */
    toDeletePlaybackConfiguration(): this;
    /**
     * (experimental) Grants permission to delete the program with the specified program name on the channel with the specified channel name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     *
     * @experimental
     */
    toDeleteProgram(): this;
    /**
     * (experimental) Grants permission to delete the source location with the specified source location name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @experimental
     */
    toDeleteSourceLocation(): this;
    /**
     * (experimental) Grants permission to delete the VOD source with the specified VOD source name on the source location with the specified source location name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @experimental
     */
    toDeleteVodSource(): this;
    /**
     * (experimental) Grants permission to retrieve the channel with the specified channel name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @experimental
     */
    toDescribeChannel(): this;
    /**
     * (experimental) Grants permission to retrieve the program with the specified program name on the channel with the specified channel name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     *
     * @experimental
     */
    toDescribeProgram(): this;
    /**
     * (experimental) Grants permission to retrieve the source location with the specified source location name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @experimental
     */
    toDescribeSourceLocation(): this;
    /**
     * (experimental) Grants permission to retrieve the VOD source with the specified VOD source name on the source location with the specified source location name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @experimental
     */
    toDescribeVodSource(): this;
    /**
     * (experimental) Grants permission to read the IAM policy on the channel with the specified channel name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     *
     * @experimental
     */
    toGetChannelPolicy(): this;
    /**
     * (experimental) Grants permission to retrieve the schedule of programs on the channel with the specified channel name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-schedule.html
     *
     * @experimental
     */
    toGetChannelSchedule(): this;
    /**
     * (experimental) Grants permission to retrieve the configuration for the specified name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration-name.html
     *
     * @experimental
     */
    toGetPlaybackConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve the list of alerts on a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/alerts.html
     *
     * @experimental
     */
    toListAlerts(): this;
    /**
     * (experimental) Grants permission to retrieve the list of existing channels.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channels.html
     *
     * @experimental
     */
    toListChannels(): this;
    /**
     * (experimental) Grants permission to retrieve the list of available configurations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfigurations.html
     *
     * @experimental
     */
    toListPlaybackConfigurations(): this;
    /**
     * (experimental) Grants permission to retrieve the list of existing source locations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocations.html
     *
     * @experimental
     */
    toListSourceLocations(): this;
    /**
     * (experimental) Returns a list of the tags assigned to the specified playback configuration resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to retrieve the list of existing VOD sources on the source location with the specified source location name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsources.html
     *
     * @experimental
     */
    toListVodSources(): this;
    /**
     * (experimental) Grants permission to set the IAM policy on the channel with the specified channel name.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     *
     * @experimental
     */
    toPutChannelPolicy(): this;
    /**
     * (experimental) Grants permission to add a new configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration.html
     *
     * @experimental
     */
    toPutPlaybackConfiguration(): this;
    /**
     * (experimental) Grants permission to start the channel with the specified channel name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-start.html
     *
     * @experimental
     */
    toStartChannel(): this;
    /**
     * (experimental) Grants permission to stop the channel with the specified channel name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-stop.html
     *
     * @experimental
     */
    toStopChannel(): this;
    /**
     * (experimental) Adds tags to the specified playback configuration resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Removes tags from the specified playback configuration resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the channel with the specified channel name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @experimental
     */
    toUpdateChannel(): this;
    /**
     * (experimental) Grants permission to update the source location with the specified source location name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @experimental
     */
    toUpdateSourceLocation(): this;
    /**
     * (experimental) Grants permission to update the VOD source with the specified VOD source name on the source location with the specified source location name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @experimental
     */
    toUpdateVodSource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type playbackConfiguration to the statement.
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPlaybackConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type channel to the statement.
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onChannel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type program to the statement.
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProgram(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type sourceLocation to the statement.
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSourceLocation(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vodSource to the statement.
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVodSource(resourceId: string, account?: string, region?: string, partition?: string): this;
}
