import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [iotfleetwise](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html).
 *
 * @experimental
 */
export declare class Iotfleetwise extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [iotfleetwise](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate the given vehicle to a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_AssociateVehicle.html
     *
     * @experimental
     */
    toAssociateVehicle(): this;
    /**
     * (experimental) Grants permission to create a campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateCampaign.html
     *
     * @experimental
     */
    toCreateCampaign(): this;
    /**
     * (experimental) Grants permission to create a decoder manifest for an existing model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateDecoderManifest.html
     *
     * @experimental
     */
    toCreateDecoderManifest(): this;
    /**
     * (experimental) Grants permission to create a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateFleet.html
     *
     * @experimental
     */
    toCreateFleet(): this;
    /**
     * (experimental) Grants permission to create a model manifest definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateModelManifest.html
     *
     * @experimental
     */
    toCreateModelManifest(): this;
    /**
     * (experimental) Grants permission to create a signal catalog.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateSignalCatalog.html
     *
     * @experimental
     */
    toCreateSignalCatalog(): this;
    /**
     * (experimental) Grants permission to create a vehicle.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:CreateThing
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateVehicle.html
     *
     * @experimental
     */
    toCreateVehicle(): this;
    /**
     * (experimental) Grants permission to delete a campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteCampaign.html
     *
     * @experimental
     */
    toDeleteCampaign(): this;
    /**
     * (experimental) Grants permission to delete the given decoder manifest.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteDecoderManifest.html
     *
     * @experimental
     */
    toDeleteDecoderManifest(): this;
    /**
     * (experimental) Grants permission to delete a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteFleet.html
     *
     * @experimental
     */
    toDeleteFleet(): this;
    /**
     * (experimental) Grants permission to delete the given model manifest.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteModelManifest.html
     *
     * @experimental
     */
    toDeleteModelManifest(): this;
    /**
     * (experimental) Grants permission to delete a specific signal catalog.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteSignalCatalog.html
     *
     * @experimental
     */
    toDeleteSignalCatalog(): this;
    /**
     * (experimental) Grants permission to delete a vehicle.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteVehicle.html
     *
     * @experimental
     */
    toDeleteVehicle(): this;
    /**
     * (experimental) Grants permission to disassociate a vehicle from an existing fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DisassociateVehicle.html
     *
     * @experimental
     */
    toDisassociateVehicle(): this;
    /**
     * (experimental) Grants permission to get summary information for a given campaign.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetCampaign.html
     *
     * @experimental
     */
    toGetCampaign(): this;
    /**
     * (experimental) Grants permission to get summary information for a given decoder manifest definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetDecoderManifest.html
     *
     * @experimental
     */
    toGetDecoderManifest(): this;
    /**
     * (experimental) Grants permission to get summary information for a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetFleet.html
     *
     * @experimental
     */
    toGetFleet(): this;
    /**
     * (experimental) Grants permission to get summary information for a given model manifest definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetModelManifest.html
     *
     * @experimental
     */
    toGetModelManifest(): this;
    /**
     * (experimental) Grants permission to get the account registration status with IoT FleetWise.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetRegisterAccountStatus.html
     *
     * @experimental
     */
    toGetRegisterAccountStatus(): this;
    /**
     * (experimental) Grants permission to get summary information for a specific signal catalog.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetSignalCatalog.html
     *
     * @experimental
     */
    toGetSignalCatalog(): this;
    /**
     * (experimental) Grants permission to get summary information for a vehicle.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetVehicle.html
     *
     * @experimental
     */
    toGetVehicle(): this;
    /**
     * (experimental) Grants permission to get the status of the campaigns running on a specific vehicle.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetVehicleStatus.html
     *
     * @experimental
     */
    toGetVehicleStatus(): this;
    /**
     * (experimental) Grants permission to import an existing decoder manifest.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ImportDecoderManifest.html
     *
     * @experimental
     */
    toImportDecoderManifest(): this;
    /**
     * (experimental) Grants permission to create a signal catalog by importing existing definitions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ImportSignalCatalog.html
     *
     * @experimental
     */
    toImportSignalCatalog(): this;
    /**
     * (experimental) Grants permission to list campaigns.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListCampaigns.html
     *
     * @experimental
     */
    toListCampaigns(): this;
    /**
     * (experimental) Grants permission to list network interfaces associated to the existing decoder manifest.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifestNetworkInterfaces.html
     *
     * @experimental
     */
    toListDecoderManifestNetworkInterfaces(): this;
    /**
     * (experimental) Grants permission to list decoder manifest signals.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifestSignals.html
     *
     * @experimental
     */
    toListDecoderManifestSignals(): this;
    /**
     * (experimental) Grants permission to list all decoder manifests, with an optional filter on model manifest.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifests.html
     *
     * @experimental
     */
    toListDecoderManifests(): this;
    /**
     * (experimental) Grants permission to list all fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListFleets.html
     *
     * @experimental
     */
    toListFleets(): this;
    /**
     * (experimental) Grants permission to list all the fleets that the given vehicle is associated with.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListFleetsForVehicle.html
     *
     * @experimental
     */
    toListFleetsForVehicle(): this;
    /**
     * (experimental) Grants permission to list all nodes for the given model manifest.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListModelManifestNodes.html
     *
     * @experimental
     */
    toListModelManifestNodes(): this;
    /**
     * (experimental) Grants permission to list all model manifests, with an optional filter on signal catalog.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListModelManifests.html
     *
     * @experimental
     */
    toListModelManifests(): this;
    /**
     * (experimental) Grants permission to list all nodes for a given signal catalog.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_.html
     *
     * @experimental
     */
    toListSignalCatalogNodes(): this;
    /**
     * (experimental) Grants permission to list all signal catalogs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListSignalCatalogs.html
     *
     * @experimental
     */
    toListSignalCatalogs(): this;
    /**
     * (experimental) Grants permission to list all vehicles, with an optional filter on model manifest.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListVehicles.html
     *
     * @experimental
     */
    toListVehicles(): this;
    /**
     * (experimental) Grants permission to list vehicles in the given fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListVehiclesInFleet.html
     *
     * @experimental
     */
    toListVehiclesInFleet(): this;
    /**
     * (experimental) Grants permission to register an AWS account to IoT FleetWise.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_RegisterAccount.html
     *
     * @experimental
     */
    toRegisterAccount(): this;
    /**
     * (experimental) Grants permission to update the given campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateCampaign.html
     *
     * @experimental
     */
    toUpdateCampaign(): this;
    /**
     * (experimental) Grants permission to update a decoder manifest defnition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateDecoderManifest.html
     *
     * @experimental
     */
    toUpdateDecoderManifest(): this;
    /**
     * (experimental) Grants permission to update the fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateFleet.html
     *
     * @experimental
     */
    toUpdateFleet(): this;
    /**
     * (experimental) Grants permission to update the given model manifest definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateModelManifest.html
     *
     * @experimental
     */
    toUpdateModelManifest(): this;
    /**
     * (experimental) Grants permission to update a specific signal catalog definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateSignalCatalog.html
     *
     * @experimental
     */
    toUpdateSignalCatalog(): this;
    /**
     * (experimental) Grants permission to update the vehicle.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUpdateToModelManifestArn()
     * - .ifUpdateToDecoderManifestArn()
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateVehicle.html
     *
     * @experimental
     */
    toUpdateVehicle(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type campaign to the statement.
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param campaignName - Identifier for the campaignName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCampaign(campaignName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type decodermanifest to the statement.
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDecodermanifest(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type fleet to the statement.
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type modelmanifest to the statement.
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onModelmanifest(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type signalcatalog to the statement.
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSignalcatalog(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vehicle to the statement.
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param vehicleId - Identifier for the vehicleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVehicle(vehicleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by a list of IoT FleetWise Decoder Manifest ARNs.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html
     *
     * Applies to actions:
     * - .toUpdateVehicle()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifUpdateToDecoderManifestArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a list of IoT FleetWise Model Manifest ARNs.
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html
     *
     * Applies to actions:
     * - .toUpdateVehicle()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifUpdateToModelManifestArn(value: string | string[], operator?: Operator | string): this;
}
