import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [iottwinmaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiottwinmaker.html).
 *
 * @experimental
 */
export declare class Iottwinmaker extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [iottwinmaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiottwinmaker.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to set values for multiple time series properties.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iottwinmaker:GetComponentType
     * - iottwinmaker:GetEntity
     * - iottwinmaker:GetWorkspace
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_BatchPutPropertyValues.html
     *
     * @experimental
     */
    toBatchPutPropertyValues(): this;
    /**
     * (experimental) Grants permission to create a componentType.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateComponentType.html
     *
     * @experimental
     */
    toCreateComponentType(): this;
    /**
     * (experimental) Grants permission to create an entity.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateEntity.html
     *
     * @experimental
     */
    toCreateEntity(): this;
    /**
     * (experimental) Grants permission to create a scene.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateScene.html
     *
     * @experimental
     */
    toCreateScene(): this;
    /**
     * (experimental) Grants permission to create a workspace.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateWorkspace.html
     *
     * @experimental
     */
    toCreateWorkspace(): this;
    /**
     * (experimental) Grants permission to delete a componentType.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteComponentType.html
     *
     * @experimental
     */
    toDeleteComponentType(): this;
    /**
     * (experimental) Grants permission to delete an entity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteEntity.html
     *
     * @experimental
     */
    toDeleteEntity(): this;
    /**
     * (experimental) Grants permission to delete a scene.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteScene.html
     *
     * @experimental
     */
    toDeleteScene(): this;
    /**
     * (experimental) Grants permission to delete a workspace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_DeleteWorkspace.html
     *
     * @experimental
     */
    toDeleteWorkspace(): this;
    /**
     * (experimental) Grants permission to get a componentType.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetComponentType.html
     *
     * @experimental
     */
    toGetComponentType(): this;
    /**
     * (experimental) Grants permission to get an entity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetEntity.html
     *
     * @experimental
     */
    toGetEntity(): this;
    /**
     * (experimental) Grants permission to retrieve the property values.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - iottwinmaker:GetComponentType
     * - iottwinmaker:GetEntity
     * - iottwinmaker:GetWorkspace
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetPropertyValue.html
     *
     * @experimental
     */
    toGetPropertyValue(): this;
    /**
     * (experimental) Grants permission to retrieve the time series value history.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - iottwinmaker:GetComponentType
     * - iottwinmaker:GetEntity
     * - iottwinmaker:GetWorkspace
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetPropertyValueHistory.html
     *
     * @experimental
     */
    toGetPropertyValueHistory(): this;
    /**
     * (experimental) Grants permission to get a scene.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetScene.html
     *
     * @experimental
     */
    toGetScene(): this;
    /**
     * (experimental) Grants permission to get a workspace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_GetWorkspace.html
     *
     * @experimental
     */
    toGetWorkspace(): this;
    /**
     * (experimental) Grants permission to list all componentTypes in a workspace.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListComponentTypes.html
     *
     * @experimental
     */
    toListComponentTypes(): this;
    /**
     * (experimental) Grants permission to list all entities in a workspace.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListEntities.html
     *
     * @experimental
     */
    toListEntities(): this;
    /**
     * (experimental) Grants permission to list all scenes in a workspace.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListScenes.html
     *
     * @experimental
     */
    toListScenes(): this;
    /**
     * (experimental) Grants permission to list all tags for a resource.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list all workspaces.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_ListWorkspaces.html
     *
     * @experimental
     */
    toListWorkspaces(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a componentType.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateComponentType.html
     *
     * @experimental
     */
    toUpdateComponentType(): this;
    /**
     * (experimental) Grants permission to update an entity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateEntity.html
     *
     * @experimental
     */
    toUpdateEntity(): this;
    /**
     * (experimental) Grants permission to update a scene.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateScene.html
     *
     * @experimental
     */
    toUpdateScene(): this;
    /**
     * (experimental) Grants permission to update a workspace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_UpdateWorkspace.html
     *
     * @experimental
     */
    toUpdateWorkspace(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type workspace to the statement.
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateWorkspace.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkspace(workspaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type entity to the statement.
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateEntity.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param entityId - Identifier for the entityId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntity(workspaceId: string, entityId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type componentType to the statement.
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateComponentType.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param componentTypeId - Identifier for the componentTypeId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onComponentType(workspaceId: string, componentTypeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type scene to the statement.
     *
     * https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_CreateScene.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param sceneId - Identifier for the sceneId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onScene(workspaceId: string, sceneId: string, account?: string, region?: string, partition?: string): this;
}
