import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
 *
 * @experimental
 */
export declare class Nimble extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to accept EULAs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_AcceptEulas.html
     *
     * @experimental
     */
    toAcceptEulas(): this;
    /**
     * (experimental) Grants permission to create a launch profile.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:RunInstances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateLaunchProfile.html
     *
     * @experimental
     */
    toCreateLaunchProfile(): this;
    /**
     * (experimental) Grants permission to create a streaming image.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - ec2:DescribeSnapshots
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     * - ec2:RegisterImage
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingImage.html
     *
     * @experimental
     */
    toCreateStreamingImage(): this;
    /**
     * (experimental) Grants permission to create a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileInitialization
     * - nimble:ListEulaAcceptances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSession.html
     *
     * @experimental
     */
    toCreateStreamingSession(): this;
    /**
     * (experimental) Grants permission to create a StreamingSessionStream.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSessionStream.html
     *
     * @experimental
     */
    toCreateStreamingSessionStream(): this;
    /**
     * (experimental) Grants permission to create a studio.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sso:CreateManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudio.html
     *
     * @experimental
     */
    toCreateStudio(): this;
    /**
     * (experimental) Grants permission to create a studio component.
     *
     * A studio component designates a network resource to which a launch profile will provide access
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudioComponent.html
     *
     * @experimental
     */
    toCreateStudioComponent(): this;
    /**
     * (experimental) Grants permission to delete a launch profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfile.html
     *
     * @experimental
     */
    toDeleteLaunchProfile(): this;
    /**
     * (experimental) Grants permission to delete a launch profile member.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfileMember.html
     *
     * @experimental
     */
    toDeleteLaunchProfileMember(): this;
    /**
     * (experimental) Grants permission to delete a streaming image.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DeleteSnapshot
     * - ec2:DeregisterImage
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingImage.html
     *
     * @experimental
     */
    toDeleteStreamingImage(): this;
    /**
     * (experimental) Grants permission to delete a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - ec2:DeleteNetworkInterface
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingSession.html
     *
     * @experimental
     */
    toDeleteStreamingSession(): this;
    /**
     * (experimental) Grants permission to delete a studio.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudio.html
     *
     * @experimental
     */
    toDeleteStudio(): this;
    /**
     * (experimental) Grants permission to delete a studio component.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioComponent.html
     *
     * @experimental
     */
    toDeleteStudioComponent(): this;
    /**
     * (experimental) Grants permission to delete a studio member.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioMember.html
     *
     * @experimental
     */
    toDeleteStudioMember(): this;
    /**
     * (experimental) Grants permission to get a EULA.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetEula.html
     *
     * @experimental
     */
    toGetEula(): this;
    /**
     * (experimental) Grants permission to allow Nimble Studio portal to show the appropriate features for this account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * @experimental
     */
    toGetFeatureMap(): this;
    /**
     * (experimental) Grants permission to get a launch profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfile.html
     *
     * @experimental
     */
    toGetLaunchProfile(): this;
    /**
     * (experimental) Grants permission to get a launch profile's details, which includes the summary of studio components and streaming images used by the launch profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileDetails.html
     *
     * @experimental
     */
    toGetLaunchProfileDetails(): this;
    /**
     * (experimental) Grants permission to get a launch profile initialization.
     *
     * A launch profile initialization is a dereferenced version of a launch profile, including attached studio component connection information
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileInitialization.html
     *
     * @experimental
     */
    toGetLaunchProfileInitialization(): this;
    /**
     * (experimental) Grants permission to get a launch profile member.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileMember.html
     *
     * @experimental
     */
    toGetLaunchProfileMember(): this;
    /**
     * (experimental) Grants permission to get a streaming image.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingImage.html
     *
     * @experimental
     */
    toGetStreamingImage(): this;
    /**
     * (experimental) Grants permission to get a streaming session.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSession.html
     *
     * @experimental
     */
    toGetStreamingSession(): this;
    /**
     * (experimental) Grants permission to get a streaming session stream.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSessionStream.html
     *
     * @experimental
     */
    toGetStreamingSessionStream(): this;
    /**
     * (experimental) Grants permission to get a studio.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudio.html
     *
     * @experimental
     */
    toGetStudio(): this;
    /**
     * (experimental) Grants permission to get a studio component.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioComponent.html
     *
     * @experimental
     */
    toGetStudioComponent(): this;
    /**
     * (experimental) Grants permission to get a studio member.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioMember.html
     *
     * @experimental
     */
    toGetStudioMember(): this;
    /**
     * (experimental) Grants permission to list EULA acceptances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulaAcceptances.html
     *
     * @experimental
     */
    toListEulaAcceptances(): this;
    /**
     * (experimental) Grants permission to list EULAs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulas.html
     *
     * @experimental
     */
    toListEulas(): this;
    /**
     * (experimental) Grants permission to list launch profile members.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfileMembers.html
     *
     * @experimental
     */
    toListLaunchProfileMembers(): this;
    /**
     * (experimental) Grants permission to list launch profiles.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifPrincipalId()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfiles.html
     *
     * @experimental
     */
    toListLaunchProfiles(): this;
    /**
     * (experimental) Grants permission to list streaming images.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingImages.html
     *
     * @experimental
     */
    toListStreamingImages(): this;
    /**
     * (experimental) Grants permission to list streaming sessions.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCreatedBy()
     * - .ifOwnedBy()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingSessions.html
     *
     * @experimental
     */
    toListStreamingSessions(): this;
    /**
     * (experimental) Grants permission to list studio components.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioComponents.html
     *
     * @experimental
     */
    toListStudioComponents(): this;
    /**
     * (experimental) Grants permission to list studio members.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioMembers.html
     *
     * @experimental
     */
    toListStudioMembers(): this;
    /**
     * (experimental) Grants permission to list all studios.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudios.html
     *
     * @experimental
     */
    toListStudios(): this;
    /**
     * (experimental) Grants permission to list all tags on a Nimble Studio resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to add/update launch profile members.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutLaunchProfileMembers.html
     *
     * @experimental
     */
    toPutLaunchProfileMembers(): this;
    /**
     * (experimental) Grants permission to report metrics and logs for the Nimble Studio portal to monitor application health.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * @experimental
     */
    toPutStudioLogEvents(): this;
    /**
     * (experimental) Grants permission to add/update studio members.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutStudioMembers.html
     *
     * @experimental
     */
    toPutStudioMembers(): this;
    /**
     * (experimental) Grants permission to start a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileMember
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStreamingSession.html
     *
     * @experimental
     */
    toStartStreamingSession(): this;
    /**
     * (experimental) Grants permission to repair the studio's AWS SSO configuration.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:CreateManagedApplicationInstance
     * - sso:GetManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStudioSSOConfigurationRepair.html
     *
     * @experimental
     */
    toStartStudioSSOConfigurationRepair(): this;
    /**
     * (experimental) Grants permission to stop a streaming session.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StopStreamingSession.html
     *
     * @experimental
     */
    toStopStreamingSession(): this;
    /**
     * (experimental) Grants permission to add or overwrite one or more tags for the specified Nimble Studio resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to disassociate one or more tags from the specified Nimble Studio resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a launch profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfile.html
     *
     * @experimental
     */
    toUpdateLaunchProfile(): this;
    /**
     * (experimental) Grants permission to update a launch profile member.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfileMember.html
     *
     * @experimental
     */
    toUpdateLaunchProfileMember(): this;
    /**
     * (experimental) Grants permission to update a streaming image.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStreamingImage.html
     *
     * @experimental
     */
    toUpdateStreamingImage(): this;
    /**
     * (experimental) Grants permission to update a studio.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudio.html
     *
     * @experimental
     */
    toUpdateStudio(): this;
    /**
     * (experimental) Grants permission to update a studio component.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudioComponent.html
     *
     * @experimental
     */
    toUpdateStudioComponent(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type studio to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Studio.html
     *
     * @param studioId - Identifier for the studioId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStudio(studioId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type streaming-image to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingImage.html
     *
     * @param streamingImageId - Identifier for the streamingImageId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStreamingImage(streamingImageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type studio-component to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StudioComponent.html
     *
     * @param studioComponentId - Identifier for the studioComponentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStudioComponent(studioComponentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type launch-profile to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_LaunchProfile.html
     *
     * @param launchProfileId - Identifier for the launchProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLaunchProfile(launchProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type streaming-session to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingSession.html
     *
     * @param streamingSessionId - Identifier for the streamingSessionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStreamingSession(streamingSessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type eula to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Eula.html
     *
     * @param eulaId - Identifier for the eulaId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEula(eulaId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type eula-acceptance to the statement.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_EulaAcceptance.html
     *
     * @param eulaAcceptanceId - Identifier for the eulaAcceptanceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEulaAcceptance(eulaAcceptanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the createdBy request parameter or the ID of the creator of the resource.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCreatedBy(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ownedBy request parameter or the ID of the owner of the resource.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOwnedBy(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the principalId request parameter.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListLaunchProfiles()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPrincipalId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of the logged in user.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateStreamingSessionStream()
     * - .toDeleteStreamingSession()
     * - .toGetStreamingSession()
     * - .toGetStreamingSessionStream()
     * - .toListLaunchProfiles()
     * - .toListStreamingSessions()
     * - .toStartStreamingSession()
     * - .toStopStreamingSession()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRequesterPrincipalId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a specific studio.
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to resource types:
     * - studio
     * - streaming-image
     * - studio-component
     * - launch-profile
     * - eula-acceptance
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifStudioId(value: string | string[], operator?: Operator | string): this;
}
