import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [outposts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsoutposts.html).
 *
 * @experimental
 */
export declare class Outposts extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [outposts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsoutposts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel an order.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CancelOrder.html
     *
     * @experimental
     */
    toCancelOrder(): this;
    /**
     * (experimental) Grants permission to create an order.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateOrder.html
     *
     * @experimental
     */
    toCreateOrder(): this;
    /**
     * (experimental) Grants permission to create an Outpost.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateOutpost.html
     *
     * @experimental
     */
    toCreateOutpost(): this;
    /**
     * (experimental) Grants permission to create a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateSite.html
     *
     * @experimental
     */
    toCreateSite(): this;
    /**
     * (experimental) Grants permission to delete an Outpost.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_DeleteOutpost.html
     *
     * @experimental
     */
    toDeleteOutpost(): this;
    /**
     * (experimental) Grants permission to delete a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_DeleteSite.html
     *
     * @experimental
     */
    toDeleteSite(): this;
    /**
     * (experimental) Grants permission to get a catalog item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetCatalogItem.html
     *
     * @experimental
     */
    toGetCatalogItem(): this;
    /**
     * (experimental) Grants permission to get information about the specified Outpost.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOutpost.html
     *
     * @experimental
     */
    toGetOutpost(): this;
    /**
     * (experimental) Grants permission to get the instance types for the specified Outpost.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOutpostInstanceTypes.html
     *
     * @experimental
     */
    toGetOutpostInstanceTypes(): this;
    /**
     * (experimental) Grants permission to get a site.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetSite.html
     *
     * @experimental
     */
    toGetSite(): this;
    /**
     * (experimental) Grants permission to get a site address.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetSiteAddress.html
     *
     * @experimental
     */
    toGetSiteAddress(): this;
    /**
     * (experimental) Grants permission to list all catalog items.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListCatalogItems.html
     *
     * @experimental
     */
    toListCatalogItems(): this;
    /**
     * (experimental) Grants permission to list the orders for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListOrders.html
     *
     * @experimental
     */
    toListOrders(): this;
    /**
     * (experimental) Grants permission to list the Outposts for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListOutposts.html
     *
     * @experimental
     */
    toListOutposts(): this;
    /**
     * (experimental) Grants permission to list the sites for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListSites.html
     *
     * @experimental
     */
    toListSites(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an Outpost.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateOutpost.html
     *
     * @experimental
     */
    toUpdateOutpost(): this;
    /**
     * (experimental) Grants permission to update a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateSite.html
     *
     * @experimental
     */
    toUpdateSite(): this;
    /**
     * (experimental) Grants permission to update the site address.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateSiteAddress.html
     *
     * @experimental
     */
    toUpdateSiteAddress(): this;
    /**
     * (experimental) Grants permission to update the physical properties of a rack at a site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateSiteRackPhysicalProperties.html
     *
     * @experimental
     */
    toUpdateSiteRackPhysicalProperties(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
