import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [personalize](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpersonalize.html).
 *
 * @experimental
 */
export declare class Personalize extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [personalize](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpersonalize.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a batch inference job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateBatchInferenceJob.html
     *
     * @experimental
     */
    toCreateBatchInferenceJob(): this;
    /**
     * (experimental) Grants permission to create a batch segment job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateBatchSegmentJob.html
     *
     * @experimental
     */
    toCreateBatchSegmentJob(): this;
    /**
     * (experimental) Grants permission to create a campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html
     *
     * @experimental
     */
    toCreateCampaign(): this;
    /**
     * (experimental) Grants permission to create a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html
     *
     * @experimental
     */
    toCreateDataset(): this;
    /**
     * (experimental) Grants permission to create a dataset export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html
     *
     * @experimental
     */
    toCreateDatasetExportJob(): this;
    /**
     * (experimental) Grants permission to create a dataset group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html
     *
     * @experimental
     */
    toCreateDatasetGroup(): this;
    /**
     * (experimental) Grants permission to create a dataset import job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html
     *
     * @experimental
     */
    toCreateDatasetImportJob(): this;
    /**
     * (experimental) Grants permission to create an event tracker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html
     *
     * @experimental
     */
    toCreateEventTracker(): this;
    /**
     * (experimental) Grants permission to create a filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateFilter.html
     *
     * @experimental
     */
    toCreateFilter(): this;
    /**
     * (experimental) Grants permission to create a recommender.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html
     *
     * @experimental
     */
    toCreateRecommender(): this;
    /**
     * (experimental) Grants permission to create a schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html
     *
     * @experimental
     */
    toCreateSchema(): this;
    /**
     * (experimental) Grants permission to create a solution.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
     *
     * @experimental
     */
    toCreateSolution(): this;
    /**
     * (experimental) Grants permission to create a solution version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html
     *
     * @experimental
     */
    toCreateSolutionVersion(): this;
    /**
     * (experimental) Grants permission to delete a campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html
     *
     * @experimental
     */
    toDeleteCampaign(): this;
    /**
     * (experimental) Grants permission to delete a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html
     *
     * @experimental
     */
    toDeleteDataset(): this;
    /**
     * (experimental) Grants permission to delete a dataset group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html
     *
     * @experimental
     */
    toDeleteDatasetGroup(): this;
    /**
     * (experimental) Grants permission to delete an event tracker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html
     *
     * @experimental
     */
    toDeleteEventTracker(): this;
    /**
     * (experimental) Grants permission to delete a filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteFilter.html
     *
     * @experimental
     */
    toDeleteFilter(): this;
    /**
     * (experimental) Grants permission to delete a recommender.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html
     *
     * @experimental
     */
    toDeleteRecommender(): this;
    /**
     * (experimental) Grants permission to delete a schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html
     *
     * @experimental
     */
    toDeleteSchema(): this;
    /**
     * (experimental) Grants permission to delete a solution including all versions of the solution.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html
     *
     * @experimental
     */
    toDeleteSolution(): this;
    /**
     * (experimental) Grants permission to describe an algorithm.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeAlgorithm.html
     *
     * @experimental
     */
    toDescribeAlgorithm(): this;
    /**
     * (experimental) Grants permission to describe a batch inference job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeBatchInferenceJob.html
     *
     * @experimental
     */
    toDescribeBatchInferenceJob(): this;
    /**
     * (experimental) Grants permission to describe a batch segment job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeBatchSegmentJob.html
     *
     * @experimental
     */
    toDescribeBatchSegmentJob(): this;
    /**
     * (experimental) Grants permission to describe a campaign.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html
     *
     * @experimental
     */
    toDescribeCampaign(): this;
    /**
     * (experimental) Grants permission to describe a dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html
     *
     * @experimental
     */
    toDescribeDataset(): this;
    /**
     * (experimental) Grants permission to describe a dataset export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html
     *
     * @experimental
     */
    toDescribeDatasetExportJob(): this;
    /**
     * (experimental) Grants permission to describe a dataset group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html
     *
     * @experimental
     */
    toDescribeDatasetGroup(): this;
    /**
     * (experimental) Grants permission to describe a dataset import job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html
     *
     * @experimental
     */
    toDescribeDatasetImportJob(): this;
    /**
     * (experimental) Grants permission to describe an event tracker.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html
     *
     * @experimental
     */
    toDescribeEventTracker(): this;
    /**
     * (experimental) Grants permission to describe a feature transformation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeFeatureTransformation.html
     *
     * @experimental
     */
    toDescribeFeatureTransformation(): this;
    /**
     * (experimental) Grants permission to describe a filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeFilter.html
     *
     * @experimental
     */
    toDescribeFilter(): this;
    /**
     * (experimental) Grants permission to describe a recipe.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html
     *
     * @experimental
     */
    toDescribeRecipe(): this;
    /**
     * (experimental) Grants permission to describe a recommender.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html
     *
     * @experimental
     */
    toDescribeRecommender(): this;
    /**
     * (experimental) Grants permission to describe a schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html
     *
     * @experimental
     */
    toDescribeSchema(): this;
    /**
     * (experimental) Grants permission to describe a solution.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html
     *
     * @experimental
     */
    toDescribeSolution(): this;
    /**
     * (experimental) Grants permission to describe a version of a solution.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html
     *
     * @experimental
     */
    toDescribeSolutionVersion(): this;
    /**
     * (experimental) Grants permission to get a re-ranked list of recommendations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html
     *
     * @experimental
     */
    toGetPersonalizedRanking(): this;
    /**
     * (experimental) Grants permission to get a list of recommendations from a campaign.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html
     *
     * @experimental
     */
    toGetRecommendations(): this;
    /**
     * (experimental) Grants permission to get metrics for a solution version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html
     *
     * @experimental
     */
    toGetSolutionMetrics(): this;
    /**
     * (experimental) Grants permission to list batch inference jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchInferenceJobs.html
     *
     * @experimental
     */
    toListBatchInferenceJobs(): this;
    /**
     * (experimental) Grants permission to list batch segment jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html
     *
     * @experimental
     */
    toListBatchSegmentJobs(): this;
    /**
     * (experimental) Grants permission to list campaigns.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html
     *
     * @experimental
     */
    toListCampaigns(): this;
    /**
     * (experimental) Grants permission to list dataset export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetExportJobs.html
     *
     * @experimental
     */
    toListDatasetExportJobs(): this;
    /**
     * (experimental) Grants permission to list dataset groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html
     *
     * @experimental
     */
    toListDatasetGroups(): this;
    /**
     * (experimental) Grants permission to list dataset import jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html
     *
     * @experimental
     */
    toListDatasetImportJobs(): this;
    /**
     * (experimental) Grants permission to list datasets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html
     *
     * @experimental
     */
    toListDatasets(): this;
    /**
     * (experimental) Grants permission to list event trackers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html
     *
     * @experimental
     */
    toListEventTrackers(): this;
    /**
     * (experimental) Grants permission to list filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListFilters.html
     *
     * @experimental
     */
    toListFilters(): this;
    /**
     * (experimental) Grants permission to list recipes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecipes.html
     *
     * @experimental
     */
    toListRecipes(): this;
    /**
     * (experimental) Grants permission to list recommenders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html
     *
     * @experimental
     */
    toListRecommenders(): this;
    /**
     * (experimental) Grants permission to list schemas.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html
     *
     * @experimental
     */
    toListSchemas(): this;
    /**
     * (experimental) Grants permission to list versions of a solution.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html
     *
     * @experimental
     */
    toListSolutionVersions(): this;
    /**
     * (experimental) Grants permission to list solutions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html
     *
     * @experimental
     */
    toListSolutions(): this;
    /**
     * (experimental) Grants permission to put real time event data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html
     *
     * @experimental
     */
    toPutEvents(): this;
    /**
     * (experimental) Grants permission to ingest Items data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutItems.html
     *
     * @experimental
     */
    toPutItems(): this;
    /**
     * (experimental) Grants permission to ingest Users data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutUsers.html
     *
     * @experimental
     */
    toPutUsers(): this;
    /**
     * (experimental) Grants permission to stop a solution version creation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_StopSolutionVersionCreation.html
     *
     * @experimental
     */
    toStopSolutionVersionCreation(): this;
    /**
     * (experimental) Grants permission to update a campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html
     *
     * @experimental
     */
    toUpdateCampaign(): this;
    /**
     * (experimental) Grants permission to update a recommender.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html
     *
     * @experimental
     */
    toUpdateRecommender(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type schema to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/how-it-works-dataset-schema.html#schema-examples
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSchema(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type featureTransformation to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_FeatureTransformation.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFeatureTransformation(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dataset to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Dataset.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDataset(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasetGroup to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DatasetGroup.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDatasetGroup(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasetImportJob to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DatasetImportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDatasetImportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type datasetExportJob to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_DatasetExportJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDatasetExportJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type solution to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSolution(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type campaign to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Campaign.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCampaign(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type eventTracker to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_EventTracker.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEventTracker(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recipe to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Recipe.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRecipe(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type algorithm to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Algorithm.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAlgorithm(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type batchInferenceJob to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_BatchInferenceJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onBatchInferenceJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type filter to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Filter.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFilter(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recommender to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_Recommender.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRecommender(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type batchSegmentJob to the statement.
     *
     * https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onBatchSegmentJob(resourceId: string, account?: string, region?: string, partition?: string): this;
}
