import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [mobiletargeting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpoint.html).
 *
 * @experimental
 */
export declare class Mobiletargeting extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [mobiletargeting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpoint.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an app.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     *
     * @experimental
     */
    toCreateApp(): this;
    /**
     * (experimental) Grants permission to create a campaign for an app.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaigns.html#rest-api-campaigns-methods
     *
     * @experimental
     */
    toCreateCampaign(): this;
    /**
     * (experimental) Grants permission to create an email template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     *
     * @experimental
     */
    toCreateEmailTemplate(): this;
    /**
     * (experimental) Grants permission to create an export job that exports endpoint definitions to Amazon S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     *
     * @experimental
     */
    toCreateExportJob(): this;
    /**
     * (experimental) Grants permission to import endpoint definitions from to create a segment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-jobs.html#rest-api-import-jobs-methods
     *
     * @experimental
     */
    toCreateImportJob(): this;
    /**
     * (experimental) Grants permission to create a Journey for an app.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     *
     * @experimental
     */
    toCreateJourney(): this;
    /**
     * (experimental) Grants permission to create a push notification template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     *
     * @experimental
     */
    toCreatePushTemplate(): this;
    /**
     * (experimental) Grants permission to create an Amazon Pinpoint configuration for a recommender model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html#CreateRecommenderConfiguration
     *
     * @experimental
     */
    toCreateRecommenderConfiguration(): this;
    /**
     * (experimental) Grants permission to create a segment that is based on endpoint data reported to Pinpoint by your app.
     *
     * To allow a user to create a segment by importing endpoint data from outside of Pinpoint, allow the mobiletargeting:CreateImportJob action
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segments.html#rest-api-segments-methods
     *
     * @experimental
     */
    toCreateSegment(): this;
    /**
     * (experimental) Grants permission to create an sms message template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     *
     * @experimental
     */
    toCreateSmsTemplate(): this;
    /**
     * (experimental) Grants permission to create a voice message template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     *
     * @experimental
     */
    toCreateVoiceTemplate(): this;
    /**
     * (experimental) Grants permission to delete the ADM channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-adm-channel.html#rest-api-adm-channel-methods
     *
     * @experimental
     */
    toDeleteAdmChannel(): this;
    /**
     * (experimental) Grants permission to delete the APNs channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-channel.html#rest-api-apns-channel-methods
     *
     * @experimental
     */
    toDeleteApnsChannel(): this;
    /**
     * (experimental) Grants permission to delete the APNs sandbox channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-sandbox-channel.html#rest-api-apns-sandbox-channel-methods
     *
     * @experimental
     */
    toDeleteApnsSandboxChannel(): this;
    /**
     * (experimental) Grants permission to delete the APNs VoIP channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-channel.html#rest-api-apns-voip-channel-methods
     *
     * @experimental
     */
    toDeleteApnsVoipChannel(): this;
    /**
     * (experimental) Grants permission to delete the APNs VoIP sandbox channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-sandbox-channel.html#rest-api-apns-voip-sandbox-channel-methods
     *
     * @experimental
     */
    toDeleteApnsVoipSandboxChannel(): this;
    /**
     * (experimental) Grants permission to delete a specific campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Grants permission to delete the Baidu channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-baidu-channel.html#rest-api-baidu-channel-methods
     *
     * @experimental
     */
    toDeleteBaiduChannel(): this;
    /**
     * (experimental) Grants permission to delete a specific campaign.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign.html#rest-api-campaign-methods
     *
     * @experimental
     */
    toDeleteCampaign(): this;
    /**
     * (experimental) Grants permission to delete the email channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-email-channel.html#rest-api-email-channel-methods
     *
     * @experimental
     */
    toDeleteEmailChannel(): this;
    /**
     * (experimental) Grants permission to delete an email template or an email template version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     *
     * @experimental
     */
    toDeleteEmailTemplate(): this;
    /**
     * (experimental) Grants permission to delete an endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoint.html#rest-api-endpoint-methods
     *
     * @experimental
     */
    toDeleteEndpoint(): this;
    /**
     * (experimental) Grants permission to delete the event stream for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-event-stream.html#rest-api-event-stream-methods
     *
     * @experimental
     */
    toDeleteEventStream(): this;
    /**
     * (experimental) Grants permission to delete the GCM channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-gcm-channel.html#rest-api-gcm-channel-methods
     *
     * @experimental
     */
    toDeleteGcmChannel(): this;
    /**
     * (experimental) Grants permission to delete a specific journey.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     *
     * @experimental
     */
    toDeleteJourney(): this;
    /**
     * (experimental) Grants permission to delete a push notification template or a push notification template version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     *
     * @experimental
     */
    toDeletePushTemplate(): this;
    /**
     * (experimental) Grants permission to delete an Amazon Pinpoint configuration for a recommender model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#DeleteRecommenderConfiguration
     *
     * @experimental
     */
    toDeleteRecommenderConfiguration(): this;
    /**
     * (experimental) Grants permission to delete a specific segment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment.html#rest-api-segment-methods
     *
     * @experimental
     */
    toDeleteSegment(): this;
    /**
     * (experimental) Grants permission to delete the SMS channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-sms-channel.html#rest-api-sms-channel-methods
     *
     * @experimental
     */
    toDeleteSmsChannel(): this;
    /**
     * (experimental) Grants permission to delete an sms message template or an sms message template version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     *
     * @experimental
     */
    toDeleteSmsTemplate(): this;
    /**
     * (experimental) Grants permission to delete all of the endpoints that are associated with a user ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-user.html#rest-api-user-methods
     *
     * @experimental
     */
    toDeleteUserEndpoints(): this;
    /**
     * (experimental) Grants permission to delete the Voice channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-voice-channel.html#rest-api-voice-channel-methods
     *
     * @experimental
     */
    toDeleteVoiceChannel(): this;
    /**
     * (experimental) Grants permission to delete a voice message template or a voice message template version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     *
     * @experimental
     */
    toDeleteVoiceTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Amazon Device Messaging (ADM) channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-adm-channel.html#rest-api-adm-channel-methods
     *
     * @experimental
     */
    toGetAdmChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about the APNs channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-channel.html#rest-api-apns-channel-methods
     *
     * @experimental
     */
    toGetApnsChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about the APNs sandbox channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-sandbox-channel.html#rest-api-apns-sandbox-channel-methods
     *
     * @experimental
     */
    toGetApnsSandboxChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about the APNs VoIP channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-channel.html#rest-api-apns-voip-channel-methods
     *
     * @experimental
     */
    toGetApnsVoipChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about the APNs VoIP sandbox channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-sandbox-channel.html#rest-api-apns-voip-sandbox-channel-methods
     *
     * @experimental
     */
    toGetApnsVoipSandboxChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific app in your Amazon Pinpoint account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     *
     * @experimental
     */
    toGetApp(): this;
    /**
     * (experimental) Grants permission to retrieve (queries) pre-aggregated data for a standard metric that applies to an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-kpis-daterange-kpi-name.html#GetApplicationDateRangeKpi
     *
     * @experimental
     */
    toGetApplicationDateRangeKpi(): this;
    /**
     * (experimental) Grants permission to retrieve the default settings for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-settings.html#rest-api-settings-methods
     *
     * @experimental
     */
    toGetApplicationSettings(): this;
    /**
     * (experimental) Grants permission to retrieve a list of apps in your Amazon Pinpoint account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apps.html#rest-api-apps-methods
     *
     * @experimental
     */
    toGetApps(): this;
    /**
     * (experimental) Grants permission to retrieve information about the Baidu channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-baidu-channel.html#rest-api-baidu-channel-methods
     *
     * @experimental
     */
    toGetBaiduChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific campaign.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign.html#rest-api-campaign-methods
     *
     * @experimental
     */
    toGetCampaign(): this;
    /**
     * (experimental) Grants permission to retrieve information about the activities performed by a campaign.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign-activities.html#rest-api-campaign-activities-methods
     *
     * @experimental
     */
    toGetCampaignActivities(): this;
    /**
     * (experimental) Grants permission to retrieve (queries) pre-aggregated data for a standard metric that applies to a campaign.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id-kpis-daterange-kpi-name.html#GetCampaignDateRangeKpi
     *
     * @experimental
     */
    toGetCampaignDateRangeKpi(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific campaign version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign-version.html#rest-api-campaign-version-methods
     *
     * @experimental
     */
    toGetCampaignVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about the current and prior versions of a campaign.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign-versions.html#rest-api-campaign-versions-methods
     *
     * @experimental
     */
    toGetCampaignVersions(): this;
    /**
     * (experimental) Grants permission to retrieve information about all campaigns for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaigns.html#rest-api-campaigns-methods
     *
     * @experimental
     */
    toGetCampaigns(): this;
    /**
     * (experimental) Grants permission to get all channels information for your app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-channels.html#rest-api-channels-methods
     *
     * @experimental
     */
    toGetChannels(): this;
    /**
     * (experimental) Grants permission to obtain information about the email channel in an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-email-channel.html#rest-api-email-channel-methods
     *
     * @experimental
     */
    toGetEmailChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific or the active version of an email template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     *
     * @experimental
     */
    toGetEmailTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific endpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoint.html#rest-api-endpoint-methods
     *
     * @experimental
     */
    toGetEndpoint(): this;
    /**
     * (experimental) Grants permission to retrieve information about the event stream for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-event-stream.html#rest-api-event-stream-methods
     *
     * @experimental
     */
    toGetEventStream(): this;
    /**
     * (experimental) Grants permission to obtain information about a specific export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     *
     * @experimental
     */
    toGetExportJob(): this;
    /**
     * (experimental) Grants permission to retrieve a list of all of the export jobs for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     *
     * @experimental
     */
    toGetExportJobs(): this;
    /**
     * (experimental) Grants permission to retrieve information about the GCM channel for an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-gcm-channel.html#rest-api-gcm-channel-methods
     *
     * @experimental
     */
    toGetGcmChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific import job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-job.html#rest-api-import-job-methods
     *
     * @experimental
     */
    toGetImportJob(): this;
    /**
     * (experimental) Grants permission to retrieve information about all import jobs for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-jobs.html#rest-api-import-jobs-methods
     *
     * @experimental
     */
    toGetImportJobs(): this;
    /**
     * (experimental) Grants permission to retrive in-app messages for the given endpoint id.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id-inappmessages.html
     *
     * @experimental
     */
    toGetInAppMessages(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific journey.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     *
     * @experimental
     */
    toGetJourney(): this;
    /**
     * (experimental) Grants permission to retrieve (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-kpis-daterange-kpi-name.html#GetJourneyDateRangeKpi
     *
     * @experimental
     */
    toGetJourneyDateRangeKpi(): this;
    /**
     * (experimental) Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-activities-journey-activity-id-execution-metrics.html#GetJourneyExecutionActivityMetrics
     *
     * @experimental
     */
    toGetJourneyExecutionActivityMetrics(): this;
    /**
     * (experimental) Grants permission to retrieve (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-execution-metrics.html#GetJourneyExecutionMetrics
     *
     * @experimental
     */
    toGetJourneyExecutionMetrics(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific or the active version of an push notification template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     *
     * @experimental
     */
    toGetPushTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve information about an Amazon Pinpoint configuration for a recommender model.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#GetRecommenderConfiguration
     *
     * @experimental
     */
    toGetRecommenderConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve information about all the recommender model configurations that are associated with an Amazon Pinpoint account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html#GetRecommenderConfigurations
     *
     * @experimental
     */
    toGetRecommenderConfigurations(): this;
    /**
     * (experimental) Grants permission to mobiletargeting:GetReports.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetReports(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific segment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment.html#rest-api-segment-methods
     *
     * @experimental
     */
    toGetSegment(): this;
    /**
     * (experimental) Grants permission to retrieve information about jobs that export endpoint definitions from segments to Amazon S3.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-export-jobs.html#rest-api-export-jobs-methods
     *
     * @experimental
     */
    toGetSegmentExportJobs(): this;
    /**
     * (experimental) Grants permission to retrieve information about jobs that create segments by importing endpoint definitions from.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-import-jobs.html#rest-api-import-jobs-methods
     *
     * @experimental
     */
    toGetSegmentImportJobs(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific segment version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment-version.html#rest-api-segment-version-methods
     *
     * @experimental
     */
    toGetSegmentVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about the current and prior versions of a segment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment-versions.html#rest-api-segment-versions-methods
     *
     * @experimental
     */
    toGetSegmentVersions(): this;
    /**
     * (experimental) Grants permission to retrieve information about the segments for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segments.html#rest-api-segments-methods
     *
     * @experimental
     */
    toGetSegments(): this;
    /**
     * (experimental) Grants permission to obtain information about the SMS channel in an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-sms-channel.html#rest-api-sms-channel-methods
     *
     * @experimental
     */
    toGetSmsChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific or the active version of an sms message template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     *
     * @experimental
     */
    toGetSmsTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve information about the endpoints that are associated with a user ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-user.html#rest-api-user-methods
     *
     * @experimental
     */
    toGetUserEndpoints(): this;
    /**
     * (experimental) Grants permission to obtain information about the Voice channel in an app.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-voice-channel.html#rest-api-voice-channel-methods
     *
     * @experimental
     */
    toGetVoiceChannel(): this;
    /**
     * (experimental) Grants permission to retrieve information about a specific or the active version of a voice message template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     *
     * @experimental
     */
    toGetVoiceTemplate(): this;
    /**
     * (experimental) Grants permission to retrieve information about all journeys for an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html#apps-application-id-journeys-http-methods
     *
     * @experimental
     */
    toListJourneys(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-tags.html#rest-api-tags-methods-get
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to retrieve all versions about a specific template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-template-type-versions.html#templates-template-name-template-type-versions-http-methods
     *
     * @experimental
     */
    toListTemplateVersions(): this;
    /**
     * (experimental) Grants permission to retrieve metadata about the queried templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html#templates-http-methods
     *
     * @experimental
     */
    toListTemplates(): this;
    /**
     * (experimental) Grants permission to obtain metadata for a phone number, such as the number type (mobile, landline, or VoIP), location, and provider.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-phone-number-validate.html#rest-api-phone-number-validate-methods
     *
     * @experimental
     */
    toPhoneNumberValidate(): this;
    /**
     * (experimental) Grants permission to create or update an event stream for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-event-stream.html#rest-api-event-stream-methods
     *
     * @experimental
     */
    toPutEventStream(): this;
    /**
     * (experimental) Grants permission to create or update events for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-events.html#rest-api-events-methods
     *
     * @experimental
     */
    toPutEvents(): this;
    /**
     * (experimental) Grants permission to remove the attributes for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-app.html#rest-api-app-methods
     *
     * @experimental
     */
    toRemoveAttributes(): this;
    /**
     * (experimental) Grants permission to send an SMS message or push notification to specific endpoints.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-messages.html#rest-api-messages-methods
     *
     * @experimental
     */
    toSendMessages(): this;
    /**
     * (experimental) Grants permission to send an SMS message or push notification to all endpoints that are associated with a specific user ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-users-messages.html#rest-api-users-messages-methods
     *
     * @experimental
     */
    toSendUsersMessages(): this;
    /**
     * (experimental) Grants permission to add tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-tags.html#rest-api-tags-methods-post
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-tags.html#rest-api-tags-methods-delete
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the Amazon Device Messaging (ADM) channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-adm-channel.html#rest-api-adm-channel-methods
     *
     * @experimental
     */
    toUpdateAdmChannel(): this;
    /**
     * (experimental) Grants permission to update the Apple Push Notification service (APNs) channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-channel.html#rest-api-apns-channel-methods
     *
     * @experimental
     */
    toUpdateApnsChannel(): this;
    /**
     * (experimental) Grants permission to update the Apple Push Notification service (APNs) sandbox channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-sandbox-channel.html#rest-api-apns-sandbox-channel-methods
     *
     * @experimental
     */
    toUpdateApnsSandboxChannel(): this;
    /**
     * (experimental) Grants permission to update the Apple Push Notification service (APNs) VoIP channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-channel.html#rest-api-apns-voip-channel-methods
     *
     * @experimental
     */
    toUpdateApnsVoipChannel(): this;
    /**
     * (experimental) Grants permission to update the Apple Push Notification service (APNs) VoIP sandbox channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-apns-voip-sandbox-channel.html#rest-api-apns-voip-sandbox-channel-methods
     *
     * @experimental
     */
    toUpdateApnsVoipSandboxChannel(): this;
    /**
     * (experimental) Grants permission to update the default settings for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-settings.html#rest-api-settings-methods
     *
     * @experimental
     */
    toUpdateApplicationSettings(): this;
    /**
     * (experimental) Grants permission to update the Baidu channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-baidu-channel.html#rest-api-baidu-channel-methods
     *
     * @experimental
     */
    toUpdateBaiduChannel(): this;
    /**
     * (experimental) Grants permission to update a specific campaign.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaign.html#rest-api-campaign-methods
     *
     * @experimental
     */
    toUpdateCampaign(): this;
    /**
     * (experimental) Grants permission to update the email channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-email-channel.html#rest-api-email-channel-methods
     *
     * @experimental
     */
    toUpdateEmailChannel(): this;
    /**
     * (experimental) Grants permission to update a specific email template under the same version or generate a new version.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-http-methods
     *
     * @experimental
     */
    toUpdateEmailTemplate(): this;
    /**
     * (experimental) Grants permission to create an endpoint or update the information for an endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoint.html#rest-api-endpoint-methods
     *
     * @experimental
     */
    toUpdateEndpoint(): this;
    /**
     * (experimental) Grants permission to create or update endpoints as a batch operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-endpoints.html#rest-api-endpoints-methods
     *
     * @experimental
     */
    toUpdateEndpointsBatch(): this;
    /**
     * (experimental) Grants permission to update the Firebase Cloud Messaging (FCM) or Google Cloud Messaging (GCM) API key that allows to send push notifications to your Android app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-gcm-channel.html#rest-api-gcm-channel-methods
     *
     * @experimental
     */
    toUpdateGcmChannel(): this;
    /**
     * (experimental) Grants permission to update a specific journey.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id.html#apps-application-id-journeys-journey-id-http-methods
     *
     * @experimental
     */
    toUpdateJourney(): this;
    /**
     * (experimental) Grants permission to update a specific journey state.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys-journey-id-state.html#apps-application-id-journeys-journey-id-state-http-methods
     *
     * @experimental
     */
    toUpdateJourneyState(): this;
    /**
     * (experimental) Grants permission to update a specific push notification template under the same version or generate a new version.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-push.html#templates-template-name-push-http-methods
     *
     * @experimental
     */
    toUpdatePushTemplate(): this;
    /**
     * (experimental) Grants permission to update an Amazon Pinpoint configuration for a recommender model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders-recommender-id.html#UpdateRecommenderConfiguration
     *
     * @experimental
     */
    toUpdateRecommenderConfiguration(): this;
    /**
     * (experimental) Grants permission to update a specific segment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segment.html#rest-api-segment-methods
     *
     * @experimental
     */
    toUpdateSegment(): this;
    /**
     * (experimental) Grants permission to update the SMS channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-sms-channel.html#rest-api-sms-channel-methods
     *
     * @experimental
     */
    toUpdateSmsChannel(): this;
    /**
     * (experimental) Grants permission to update a specific sms message template under the same version or generate a new version.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-sms.html#templates-template-name-sms-http-methods
     *
     * @experimental
     */
    toUpdateSmsTemplate(): this;
    /**
     * (experimental) Grants permission to update the active version parameter of a specific template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-template-type-versions.html#templates-template-name-template-type-versions-http-methods
     *
     * @experimental
     */
    toUpdateTemplateActiveVersion(): this;
    /**
     * (experimental) Grants permission to update the Voice channel for an app.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-voice-channel.html#rest-api-voice-channel-methods
     *
     * @experimental
     */
    toUpdateVoiceChannel(): this;
    /**
     * (experimental) Grants permission to update a specific voice message template under the same version or generate a new version.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-voice.html#templates-template-name-voice-http-methods
     *
     * @experimental
     */
    toUpdateVoiceTemplate(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type apps to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/developerguide/gettingstarted.html#gettingstarted-addapp
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApps(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type campaigns to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-campaigns.html
     *
     * @param appId - Identifier for the appId.
     * @param campaignId - Identifier for the campaignId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCampaigns(appId: string, campaignId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type journeys to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-journeys.html
     *
     * @param appId - Identifier for the appId.
     * @param journeyId - Identifier for the journeyId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onJourneys(appId: string, journeyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type segments to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/rest-api-segments.html
     *
     * @param appId - Identifier for the appId.
     * @param segmentId - Identifier for the segmentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSegments(appId: string, segmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type templates to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param channelType - Identifier for the channelType.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTemplates(templateName: string, channelType: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recommenders to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/recommenders.html
     *
     * @param recommenderId - Identifier for the recommenderId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRecommenders(recommenderId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type phone-number-validate to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint/latest/apireference/phone-number-validate.html
     *
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPhoneNumberValidate(account?: string, region?: string, partition?: string): this;
}
