import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [servicecatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservicecatalog.html).
 *
 * @experimental
 */
export declare class Servicecatalog extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [servicecatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservicecatalog.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to accept a portfolio that has been shared with you.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AcceptPortfolioShare.html
     *
     * @experimental
     */
    toAcceptPortfolioShare(): this;
    /**
     * (experimental) Grants permission to associate an attribute group with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_AssociateAttributeGroup.html
     *
     * @experimental
     */
    toAssociateAttributeGroup(): this;
    /**
     * (experimental) Grants permission to associate a budget with a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateBudgetWithResource.html
     *
     * @experimental
     */
    toAssociateBudgetWithResource(): this;
    /**
     * (experimental) Grants permission to associate an IAM principal with a portfolio, giving the specified principal access to any products associated with the specified portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociatePrincipalWithPortfolio.html
     *
     * @experimental
     */
    toAssociatePrincipalWithPortfolio(): this;
    /**
     * (experimental) Grants permission to associate a product with a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateProductWithPortfolio.html
     *
     * @experimental
     */
    toAssociateProductWithPortfolio(): this;
    /**
     * (experimental) Grants permission to associate a resource with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_AssociateResource.html
     *
     * @experimental
     */
    toAssociateResource(): this;
    /**
     * (experimental) Grants permission to associate an action with a provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateServiceActionWithProvisioningArtifact.html
     *
     * @experimental
     */
    toAssociateServiceActionWithProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to associate the specified TagOption with the specified portfolio or product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateTagOptionWithResource.html
     *
     * @experimental
     */
    toAssociateTagOptionWithResource(): this;
    /**
     * (experimental) Grants permission to associate multiple self-service actions with provisioning artifacts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchAssociateServiceActionWithProvisioningArtifact.html
     *
     * @experimental
     */
    toBatchAssociateServiceActionWithProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to disassociate a batch of self-service actions from the specified provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchDisassociateServiceActionFromProvisioningArtifact.html
     *
     * @experimental
     */
    toBatchDisassociateServiceActionFromProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to copy the specified source product to the specified target product or a new product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CopyProduct.html
     *
     * @experimental
     */
    toCopyProduct(): this;
    /**
     * (experimental) Grants permission to create an application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateApplication.html
     *
     * @experimental
     */
    toCreateApplication(): this;
    /**
     * (experimental) Grants permission to create an attribute group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateAttributeGroup.html
     *
     * @experimental
     */
    toCreateAttributeGroup(): this;
    /**
     * (experimental) Grants permission to create a constraint on an associated product and portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateConstraint.html
     *
     * @experimental
     */
    toCreateConstraint(): this;
    /**
     * (experimental) Grants permission to create a portfolio.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolio.html
     *
     * @experimental
     */
    toCreatePortfolio(): this;
    /**
     * (experimental) Grants permission to share a portfolio you own with another AWS account.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolioShare.html
     *
     * @experimental
     */
    toCreatePortfolioShare(): this;
    /**
     * (experimental) Grants permission to create a product and that product's first provisioning artifact.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html
     *
     * @experimental
     */
    toCreateProduct(): this;
    /**
     * (experimental) Grants permission to add a new provisioned product plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisionedProductPlan.html
     *
     * @experimental
     */
    toCreateProvisionedProductPlan(): this;
    /**
     * (experimental) Grants permission to add a new provisioning artifact to an existing product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisioningArtifact.html
     *
     * @experimental
     */
    toCreateProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to create a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateServiceAction.html
     *
     * @experimental
     */
    toCreateServiceAction(): this;
    /**
     * (experimental) Grants permission to create a TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateTagOption.html
     *
     * @experimental
     */
    toCreateTagOption(): this;
    /**
     * (experimental) Grants permission to delete an application if all associations have been removed from the application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DeleteApplication.html
     *
     * @experimental
     */
    toDeleteApplication(): this;
    /**
     * (experimental) Grants permission to delete an attribute group if all associations have been removed from the attribute group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DeleteAttributeGroup.html
     *
     * @experimental
     */
    toDeleteAttributeGroup(): this;
    /**
     * (experimental) Grants permission to remove and delete an existing constraint from an associated product and portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteConstraint.html
     *
     * @experimental
     */
    toDeleteConstraint(): this;
    /**
     * (experimental) Grants permission to delete a portfolio if all associations and shares have been removed from the portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolio.html
     *
     * @experimental
     */
    toDeletePortfolio(): this;
    /**
     * (experimental) Grants permission to unshare a portfolio you own from an AWS account you previously shared the portfolio with.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolioShare.html
     *
     * @experimental
     */
    toDeletePortfolioShare(): this;
    /**
     * (experimental) Grants permission to delete a product if all associations have been removed from the product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProduct.html
     *
     * @experimental
     */
    toDeleteProduct(): this;
    /**
     * (experimental) Grants permission to delete a provisioned product plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisionedProductPlan.html
     *
     * @experimental
     */
    toDeleteProvisionedProductPlan(): this;
    /**
     * (experimental) Grants permission to delete a provisioning artifact from a product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisioningArtifact.html
     *
     * @experimental
     */
    toDeleteProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to delete a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteServiceAction.html
     *
     * @experimental
     */
    toDeleteServiceAction(): this;
    /**
     * (experimental) Grants permission to delete the specified TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteTagOption.html
     *
     * @experimental
     */
    toDeleteTagOption(): this;
    /**
     * (experimental) Grants permission to describe a constraint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeConstraint.html
     *
     * @experimental
     */
    toDescribeConstraint(): this;
    /**
     * (experimental) Grants permission to get the status of the specified copy product operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeCopyProductStatus.html
     *
     * @experimental
     */
    toDescribeCopyProductStatus(): this;
    /**
     * (experimental) Grants permission to describe a portfolio.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolio.html
     *
     * @experimental
     */
    toDescribePortfolio(): this;
    /**
     * (experimental) Grants permission to get the status of the specified portfolio share operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolioShareStatus.html
     *
     * @experimental
     */
    toDescribePortfolioShareStatus(): this;
    /**
     * (experimental) Grants permission to view a summary of each of the portfolio shares that were created for the specified portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolioShares.html
     *
     * @experimental
     */
    toDescribePortfolioShares(): this;
    /**
     * (experimental) Grants permission to describe a product as an end-user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProduct.html
     *
     * @experimental
     */
    toDescribeProduct(): this;
    /**
     * (experimental) Grants permission to describe a product as an admin.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductAsAdmin.html
     *
     * @experimental
     */
    toDescribeProductAsAdmin(): this;
    /**
     * (experimental) Grants permission to describe a product as an end-user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductView.html
     *
     * @experimental
     */
    toDescribeProductView(): this;
    /**
     * (experimental) Grants permission to describe a provisioned product.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProduct.html
     *
     * @experimental
     */
    toDescribeProvisionedProduct(): this;
    /**
     * (experimental) Grants permission to describe a provisioned product plan.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProductPlan.html
     *
     * @experimental
     */
    toDescribeProvisionedProductPlan(): this;
    /**
     * (experimental) Grants permission to describe a provisioning artifact.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningArtifact.html
     *
     * @experimental
     */
    toDescribeProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to describe the parameters that you need to specify to successfully provision a specified provisioning artifact.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningParameters.html
     *
     * @experimental
     */
    toDescribeProvisioningParameters(): this;
    /**
     * (experimental) Grants permission to describe a record and lists any outputs.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeRecord.html
     *
     * @experimental
     */
    toDescribeRecord(): this;
    /**
     * (experimental) Grants permission to describe a self-service action.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceAction.html
     *
     * @experimental
     */
    toDescribeServiceAction(): this;
    /**
     * (experimental) Grants permission to get the default parameters if you executed the specified Service Action on the specified Provisioned Product.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceActionExecutionParameters.html
     *
     * @experimental
     */
    toDescribeServiceActionExecutionParameters(): this;
    /**
     * (experimental) Grants permission to get information about the specified TagOption.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeTagOption.html
     *
     * @experimental
     */
    toDescribeTagOption(): this;
    /**
     * (experimental) Grants permission to disable portfolio sharing through AWS Organizations feature.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisableAWSOrganizationsAccess.html
     *
     * @experimental
     */
    toDisableAWSOrganizationsAccess(): this;
    /**
     * (experimental) Grants permission to disassociate an attribute group from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DisassociateAttributeGroup.html
     *
     * @experimental
     */
    toDisassociateAttributeGroup(): this;
    /**
     * (experimental) Grants permission to disassociate a budget from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateBudgetFromResource.html
     *
     * @experimental
     */
    toDisassociateBudgetFromResource(): this;
    /**
     * (experimental) Grants permission to disassociate an IAM principal from a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociatePrincipalFromPortfolio.html
     *
     * @experimental
     */
    toDisassociatePrincipalFromPortfolio(): this;
    /**
     * (experimental) Grants permission to disassociate a product from a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateProductFromPortfolio.html
     *
     * @experimental
     */
    toDisassociateProductFromPortfolio(): this;
    /**
     * (experimental) Grants permission to disassociate a resource from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_DisassociateResource.html
     *
     * @experimental
     */
    toDisassociateResource(): this;
    /**
     * (experimental) Grants permission to disassociate the specified self-service action association from the specified provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateServiceActionFromProvisioningArtifact.html
     *
     * @experimental
     */
    toDisassociateServiceActionFromProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to disassociate the specified TagOption from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateTagOptionFromResource.html
     *
     * @experimental
     */
    toDisassociateTagOptionFromResource(): this;
    /**
     * (experimental) Grants permission to enable portfolio sharing feature through AWS Organizations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_EnableAWSOrganizationsAccess.html
     *
     * @experimental
     */
    toEnableAWSOrganizationsAccess(): this;
    /**
     * (experimental) Grants permission to execute a provisioned product plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductPlan.html
     *
     * @experimental
     */
    toExecuteProvisionedProductPlan(): this;
    /**
     * (experimental) Grants permission to executes a provisioned product plan.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductServiceAction.html
     *
     * @experimental
     */
    toExecuteProvisionedProductServiceAction(): this;
    /**
     * (experimental) Grants permission to get the access status of AWS Organization portfolio share feature.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetAWSOrganizationsAccessStatus.html
     *
     * @experimental
     */
    toGetAWSOrganizationsAccessStatus(): this;
    /**
     * (experimental) Grants permission to get an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_GetApplication.html
     *
     * @experimental
     */
    toGetApplication(): this;
    /**
     * (experimental) Grants permission to get information about a resource associated to an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_GetAssociatedResource.html
     *
     * @experimental
     */
    toGetAssociatedResource(): this;
    /**
     * (experimental) Grants permission to get an attribute group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_GetAttributeGroup.html
     *
     * @experimental
     */
    toGetAttributeGroup(): this;
    /**
     * (experimental) Grants permission to get the provisioned product output with either provisioned product id or name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetProvisionedProductOutputs.html
     *
     * @experimental
     */
    toGetProvisionedProductOutputs(): this;
    /**
     * (experimental) Grants permission to import a resource into a provisioned product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ImportAsProvisionedProduct.html
     *
     * @experimental
     */
    toImportAsProvisionedProduct(): this;
    /**
     * (experimental) Grants permission to list the portfolios that have been shared with you and you have accepted.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAcceptedPortfolioShares.html
     *
     * @experimental
     */
    toListAcceptedPortfolioShares(): this;
    /**
     * (experimental) Grants permission to list the applications in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListApplications.html
     *
     * @experimental
     */
    toListApplications(): this;
    /**
     * (experimental) Grants permission to list the attribute groups associated with an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListAssociatedAttributeGroups.html
     *
     * @experimental
     */
    toListAssociatedAttributeGroups(): this;
    /**
     * (experimental) Grants permission to list the resources associated with an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListAssociatedResources.html
     *
     * @experimental
     */
    toListAssociatedResources(): this;
    /**
     * (experimental) Grants permission to list the attribute groups in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListAttributeGroups.html
     *
     * @experimental
     */
    toListAttributeGroups(): this;
    /**
     * (experimental) Grants permission to list all the budgets associated to a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListBudgetsForResource.html
     *
     * @experimental
     */
    toListBudgetsForResource(): this;
    /**
     * (experimental) Grants permission to list constraints associated with a given portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListConstraintsForPortfolio.html
     *
     * @experimental
     */
    toListConstraintsForPortfolio(): this;
    /**
     * (experimental) Grants permission to list the different ways to launch a given product as an end-user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html
     *
     * @experimental
     */
    toListLaunchPaths(): this;
    /**
     * (experimental) Grants permission to list the organization nodes that have access to the specified portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListOrganizationPortfolioAccess.html
     *
     * @experimental
     */
    toListOrganizationPortfolioAccess(): this;
    /**
     * (experimental) Grants permission to list the AWS accounts you have shared a given portfolio with.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolioAccess.html
     *
     * @experimental
     */
    toListPortfolioAccess(): this;
    /**
     * (experimental) Grants permission to list the portfolios in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolios.html
     *
     * @experimental
     */
    toListPortfolios(): this;
    /**
     * (experimental) Grants permission to list the portfolios associated with a given product.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfoliosForProduct.html
     *
     * @experimental
     */
    toListPortfoliosForProduct(): this;
    /**
     * (experimental) Grants permission to list the IAM principals associated with a given portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPrincipalsForPortfolio.html
     *
     * @experimental
     */
    toListPrincipalsForPortfolio(): this;
    /**
     * (experimental) Grants permission to list the provisioned product plans.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisionedProductPlans.html
     *
     * @experimental
     */
    toListProvisionedProductPlans(): this;
    /**
     * (experimental) Grants permission to list the provisioning artifacts associated with a given product.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifacts.html
     *
     * @experimental
     */
    toListProvisioningArtifacts(): this;
    /**
     * (experimental) Grants permission to list all provisioning artifacts for the specified self-service action.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifactsForServiceAction.html
     *
     * @experimental
     */
    toListProvisioningArtifactsForServiceAction(): this;
    /**
     * (experimental) Grants permission to list all the records in your account or all the records related to a given provisioned product.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListRecordHistory.html
     *
     * @experimental
     */
    toListRecordHistory(): this;
    /**
     * (experimental) Grants permission to list the resources associated with the specified TagOption.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListResourcesForTagOption.html
     *
     * @experimental
     */
    toListResourcesForTagOption(): this;
    /**
     * (experimental) Grants permission to list all self-service actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActions.html
     *
     * @experimental
     */
    toListServiceActions(): this;
    /**
     * (experimental) Grants permission to list all the service actions associated with the specified provisioning artifact in your account.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActionsForProvisioningArtifact.html
     *
     * @experimental
     */
    toListServiceActionsForProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to list account, region and status of each stack instances that are associated with a CFN_STACKSET type provisioned product.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListStackInstancesForProvisionedProduct.html
     *
     * @experimental
     */
    toListStackInstancesForProvisionedProduct(): this;
    /**
     * (experimental) Grants permission to list the specified TagOptions or all TagOptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListTagOptions.html
     *
     * @experimental
     */
    toListTagOptions(): this;
    /**
     * (experimental) Grants permission to list the tags for a service catalog appregistry resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to provision a product with a specified provisioning artifact and launch parameters.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisionProduct.html
     *
     * @experimental
     */
    toProvisionProduct(): this;
    /**
     * (experimental) Grants permission to reject a portfolio that has been shared with you that you previously accepted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_RejectPortfolioShare.html
     *
     * @experimental
     */
    toRejectPortfolioShare(): this;
    /**
     * (experimental) Grants permission to list all the provisioned products in your account.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ScanProvisionedProducts.html
     *
     * @experimental
     */
    toScanProvisionedProducts(): this;
    /**
     * (experimental) Grants permission to list the products available to you as an end-user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProducts.html
     *
     * @experimental
     */
    toSearchProducts(): this;
    /**
     * (experimental) Grants permission to list all the products in your account or all the products associated with a given portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProductsAsAdmin.html
     *
     * @experimental
     */
    toSearchProductsAsAdmin(): this;
    /**
     * (experimental) Grants permission to list all the provisioned products in your account.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProvisionedProducts.html
     *
     * @experimental
     */
    toSearchProvisionedProducts(): this;
    /**
     * (experimental) Grants permission to sync a resource with its current state in AppRegistry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_SyncResource.html
     *
     * @experimental
     */
    toSyncResource(): this;
    /**
     * (experimental) Grants permission to tag a service catalog appregistry resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to terminate an existing provisioned product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_TerminateProvisionedProduct.html
     *
     * @experimental
     */
    toTerminateProvisionedProduct(): this;
    /**
     * (experimental) Grants permission to remove a tag from a service catalog appregistry resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the attributes of an existing application.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_UpdateApplication.html
     *
     * @experimental
     */
    toUpdateApplication(): this;
    /**
     * (experimental) Grants permission to update the attributes of an existing attribute group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_UpdateAttributeGroup.html
     *
     * @experimental
     */
    toUpdateAttributeGroup(): this;
    /**
     * (experimental) Grants permission to update the metadata fields of an existing constraint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateConstraint.html
     *
     * @experimental
     */
    toUpdateConstraint(): this;
    /**
     * (experimental) Grants permission to update the metadata fields and/or tags of an existing portfolio.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdatePortfolio.html
     *
     * @experimental
     */
    toUpdatePortfolio(): this;
    /**
     * (experimental) Grants permission to enable or disable resource sharing for an existing portfolio share.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdatePortfolioShare.html
     *
     * @experimental
     */
    toUpdatePortfolioShare(): this;
    /**
     * (experimental) Grants permission to update the metadata fields and/or tags of an existing product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProduct.html
     *
     * @experimental
     */
    toUpdateProduct(): this;
    /**
     * (experimental) Grants permission to update an existing provisioned product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProduct.html
     *
     * @experimental
     */
    toUpdateProvisionedProduct(): this;
    /**
     * (experimental) Grants permission to update the properties of an existing provisioned product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProductProperties.html
     *
     * @experimental
     */
    toUpdateProvisionedProductProperties(): this;
    /**
     * (experimental) Grants permission to update the metadata fields of an existing provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisioningArtifact.html
     *
     * @experimental
     */
    toUpdateProvisioningArtifact(): this;
    /**
     * (experimental) Grants permission to update a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateServiceAction.html
     *
     * @experimental
     */
    toUpdateServiceAction(): this;
    /**
     * (experimental) Grants permission to update the specified TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateTagOption.html
     *
     * @experimental
     */
    toUpdateTagOption(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Application to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateApplication.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type AttributeGroup to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_CreateAttributeGroup.html
     *
     * @param attributeGroupId - Identifier for the attributeGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAttributeGroup(attributeGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Portfolio to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_PortfolioDetail.html
     *
     * @param portfolioId - Identifier for the portfolioId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPortfolio(portfolioId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Product to the statement.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProductViewDetail.html
     *
     * @param productId - Identifier for the productId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProduct(productId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by user to see and perform actions on resources created by anyone in the account.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .toCreateProvisionedProductPlan()
     * - .toDeleteProvisionedProductPlan()
     * - .toDescribeProvisionedProduct()
     * - .toDescribeProvisionedProductPlan()
     * - .toDescribeRecord()
     * - .toDescribeServiceActionExecutionParameters()
     * - .toExecuteProvisionedProductPlan()
     * - .toExecuteProvisionedProductServiceAction()
     * - .toListProvisionedProductPlans()
     * - .toListRecordHistory()
     * - .toListServiceActionsForProvisioningArtifact()
     * - .toListStackInstancesForProvisionedProduct()
     * - .toScanProvisionedProducts()
     * - .toSearchProvisionedProducts()
     * - .toTerminateProvisionedProduct()
     * - .toUpdateProvisionedProduct()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAccountLevel(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by user to see and perform actions on resources created either by them or by anyone federating into the same role as them.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .toCreateProvisionedProductPlan()
     * - .toDeleteProvisionedProductPlan()
     * - .toDescribeProvisionedProduct()
     * - .toDescribeProvisionedProductPlan()
     * - .toDescribeRecord()
     * - .toDescribeServiceActionExecutionParameters()
     * - .toExecuteProvisionedProductPlan()
     * - .toExecuteProvisionedProductServiceAction()
     * - .toListProvisionedProductPlans()
     * - .toListRecordHistory()
     * - .toListServiceActionsForProvisioningArtifact()
     * - .toListStackInstancesForProvisionedProduct()
     * - .toScanProvisionedProducts()
     * - .toSearchProvisionedProducts()
     * - .toTerminateProvisionedProduct()
     * - .toUpdateProvisionedProduct()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRoleLevel(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by user to see and perform actions on only resources that they created.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .toCreateProvisionedProductPlan()
     * - .toDeleteProvisionedProductPlan()
     * - .toDescribeProvisionedProduct()
     * - .toDescribeProvisionedProductPlan()
     * - .toDescribeRecord()
     * - .toDescribeServiceActionExecutionParameters()
     * - .toExecuteProvisionedProductPlan()
     * - .toExecuteProvisionedProductServiceAction()
     * - .toListProvisionedProductPlans()
     * - .toListRecordHistory()
     * - .toListServiceActionsForProvisioningArtifact()
     * - .toListStackInstancesForProvisionedProduct()
     * - .toScanProvisionedProducts()
     * - .toSearchProvisionedProducts()
     * - .toTerminateProvisionedProduct()
     * - .toUpdateProvisionedProduct()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifUserLevel(value: string | string[], operator?: Operator | string): this;
}
