"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an email address as a subscription target
 *
 * Email subscriptions require confirmation.
 */
class EmailSubscription {
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
    }
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
//# sourceMappingURL=data:application/json;base64,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