"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const subs = require("../lib");
class SnsToLambda extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const topic = new sns.Topic(this, 'MyTopic');
        const fction = new lambda.Function(this, 'Echo', {
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_8_10,
            code: lambda.Code.fromInline(`exports.handler = ${handler.toString()}`)
        });
        topic.addSubscription(new subs.LambdaSubscription(fction));
        const fctionFiltered = new lambda.Function(this, 'Filtered', {
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_8_10,
            code: lambda.Code.fromInline(`exports.handler = ${handler.toString()}`)
        });
        topic.addSubscription(new subs.LambdaSubscription(fctionFiltered, {
            filterPolicy: {
                color: sns.SubscriptionFilter.stringFilter({
                    whitelist: ['red'],
                    matchPrefixes: ['bl', 'ye'],
                }),
                size: sns.SubscriptionFilter.stringFilter({
                    blacklist: ['small', 'medium'],
                }),
                price: sns.SubscriptionFilter.numericFilter({
                    between: { start: 100, stop: 200 }
                })
            }
        }));
    }
}
const app = new cdk.App();
new SnsToLambda(app, 'aws-cdk-sns-lambda');
app.synth();
function handler(event, _context, callback) {
    // tslint:disable:no-console
    console.log('====================================================');
    console.log(JSON.stringify(event, undefined, 2));
    console.log('====================================================');
    return callback(undefined, event);
}
//# sourceMappingURL=data:application/json;base64,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