"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = void 0;
/**
 * Schedule for canary runs
 */
class Schedule {
    constructor(
    /**
     * The Schedule expression
     */
    expressionString) {
        this.expressionString = expressionString;
    }
    /**
     * The canary will be executed once.
     */
    static once() {
        return new Schedule('rate(0 minutes)');
    }
    /**
     * Construct a schedule from a literal schedule expression. The expression must be in a `rate(number units)` format.
     * For example, `Schedule.expression('rate(10 minutes)')`
     *
     * @param expression The expression to use.
     */
    static expression(expression) {
        return new Schedule(expression);
    }
    /**
     * Construct a schedule from an interval. Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use `Schedule.once()`.
     *
     * @param interval The interval at which to run the canary
     */
    static rate(interval) {
        const minutes = interval.toMinutes();
        if (minutes > 60) {
            throw new Error('Schedule duration must be between 1 and 60 minutes');
        }
        if (minutes === 0) {
            return Schedule.once();
        }
        if (minutes === 1) {
            return new Schedule('rate(1 minute)');
        }
        return new Schedule(`rate(${minutes} minutes)`);
    }
}
exports.Schedule = Schedule;
//# sourceMappingURL=data:application/json;base64,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